<?php
if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

function isProduction()
{
    if (in_array(getEnvironment(), ["PROD", "UAT"])) {
        return true;
    } else {
        return false;
    }

}

function getEnvironment()
{
    $ci       = &get_instance();
    $base_url = base_url();
    if (strpos($base_url, 'elog360.app/svkonekt_test') !== false) {
        return "PROD";
    } else if (strpos($base_url, 'elog360.app/svkonekt_test') !== false) {
        return "PROD";
    } else if (strpos($base_url, 'https://elog360.app/svkonekt_test') !== false) {
        return "UAT";
    } else if (strpos($base_url, 'https://elog360.app/svkonekt_test') !== false) {
        return "LMV";
    } else {
        return false;
    }
}

function decryptPassword($encryptedText)
{
    $key = hash('sha256', ENCRYPTION_KEY, true); // 32 bytes key
    $iv = str_repeat("\0", 16); // same as Flutter IV.fromLength(16)
    $decoded = base64_decode($encryptedText);
    $decrypted = openssl_decrypt($decoded, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
    return $decrypted;
}

function decryptAES256($pwd)
{
    require_once './application/third_party/cryptolib-php/src/CryptoLib.php';
    $encryption = new \MrShan0\CryptoLib\CryptoLib();
    $pwd        = $encryption->decryptCipherTextWithRandomIV($pwd, ENCRYPTION_KEY);
    return $pwd;
}

function encryptAES256($pwd)
{
    require_once './application/third_party/cryptolib-php/src/CryptoLib.php';

    $encryption = new \MrShan0\CryptoLib\CryptoLib();
    $pwd        = $encryption->encryptPlainTextWithRandomIV($pwd, ENCRYPTION_KEY);
    return $pwd;
}

function validateAuthenticationToken(array $requestHeaders): array
{
    $ci          = &get_instance();
    $contentType = $requestHeaders["Content-Type"];
    $apiKey      = $requestHeaders['Api-Key'] ?? "";
    $cid         = $requestHeaders["Cid"] ?? "";
    if (empty($requestHeaders)) {
        return ['status' => "Failed", "status_code" => "400", "data" => [], 'message' => "Invalid Request"];
    }
    if ($apiKey == "") {
        return ['status' => "Failed", "status_code" => "401", "data" => [], 'message' => "Invalid API KEY"];
    }
    if ($contentType != "application/xml") {
        return ['status' => "Failed", "status_code" => "415", "data" => [], 'message' => "Unsupported Media Type"];
    }
    if ($cid == "") {
        return ['status' => "Failed", "status_code" => "401", "data" => [], 'message' => "Invalid CID"];
    }
    if ($apiKey != "" && $cid != "") {
        $ci->load->model('common');
        $getAuthenticationDetails = $ci->common->gettblrowdata(['auth_token' => $apiKey, 'auth_cid' => $cid], "id,auth_cid,`company_code`,`branch_code`,`token_for`,partner_type", "tb_auth_tokens", 0, 0);
        if (! empty($getAuthenticationDetails)) {
            return ['status' => "Success", "status_code" => "200", "data" => [], 'message' => "Authentication Success"];

        } else {
            return ['status' => "Failed", "status_code" => "401", "data" => [], 'message' => "Unauthorized"];
        }
    }

    return ['status' => "Failed", "status_code" => "400", "data" => [], 'message' => "Bad Request"];

}
function decryptCryptoLibPassword($pwd)
{
    require_once './application/third_party/cryptolib-php/src/CryptoLib.php';
    $encryption = new \MrShan0\CryptoLib\CryptoLib();
    $pwd        = $encryption->decryptCipherTextWithRandomIV($pwd, ENCRYPTION_KEY);
    return $pwd;
}
function encryptCryptoLibPassword($pwd)
{
    require_once './application/third_party/cryptolib-php/src/CryptoLib.php';
    $encryption = new \MrShan0\CryptoLib\CryptoLib();
    $pwd        = $encryption->encryptPlainTextWithRandomIV($pwd, ENCRYPTION_KEY);
    return $pwd;
}
