<?php
if (! defined('BASEPATH'))
    exit('No direct script access allowed');

/* bonds booking EDI for ASN orders in AU login */
function bondsBooking($data, $source = '')
{
    $ci = &get_instance();
    $ci->load->model('Aumanifestmodel');
    $chkrefbn = $ci->common->gettblrowdata(array(
        'order_id' => $data['ordid'],
        'reference_id' => 'BN'
    ), "id,ref_value", "tb_order_references", 0, 0);

    if (empty($chkrefbn)) {

         $ci->benchmark->mark('edi_code_start');
         $ci->db->where('order_id', $data['ordid']);
         $ci->db->where('edi_status', 1);
         $ci->db->where('createdon >=', 'NOW() - INTERVAL 15 MINUTE', false);
         $edi_count = $ci->db->count_all_results('tb_edi_bonds');
         if($edi_count > 0){
            if($source == 'callapi') {
                echo "Please try after 15 minutes";
            }
             return false;
         }else {
             $edi_arr['order_id'] = $data['ordid'];
             $edi_arr['edi_source'] = $source;
             $edi_bonds_id = $ci->common->insertTableData('tb_edi_bonds', $edi_arr);
         }
         
        $log_edi_arr = array();
        $ci->load->model('common');
        $ci->load->model('truckwaybillmodel');
        $order_row_id = $data['ordid'];

        $vehicle_info = $ci->common->gettblrowdata(array(
            'id' => $data['vehicle_type']
        ), 'trucktype', 'tb_trucktypes', 0, 0);
        $vehicle_code = isset($vehicle_info['trucktype']) ? $vehicle_info['trucktype'] : 'CAR';
        $where = array(
            "id" => $order_row_id
        );
        $select = "order_id,shift_id,customer_id,user_id,weight,pickup_city,pickup_address2,pickup_pincode,pickup_company,pickup_datetime,pickup_address1,delivery_city,delivery_address2,delivery_pincode,delivery_company,delivery_datetime,delivery_address1,vendor_id";
        $table = "tb_orders";
        $order = $ci->common->gettblrowdata($where, $select, $table, 0, 0);
        $user_id = $ci->session->userdata('user_id')??"0";
        $company_code = $ci->session->userdata('company_code')??"";
        $branch_code = $ci->session->userdata('branch_code')??"";
      /**
       *  Account details
       *
       */
         if((empty($company_code)) || (empty($branch_code))){
            $session_data=get_session_data($order_row_id);
            $company_code=$session_data['company_code']??"";
            $branch_code=$session_data['branch_code']??"";
            $user_id=$session_data['user_id']??"";
         }
         /**
          * Bonds account data
          */
      $bonds_account_data=bonds_account_data($company_code,$branch_code);
      $branch = $bonds_account_data['branch']??"";
      $account = $bonds_account_data['account']??"";
      $auth_code = $bonds_account_data['auth_code']??"";
      $bonds_store = $bonds_account_data['bonds_store']??"";

        /* log_message('error',"Response bonds_store::".$bonds_store); */
        $order_number = '';
        $request_id = 0;
        $result['status'] = 0;
        if (count($order) > 0) {
            $log_edi_arr['vendor_id'] = $order['vendor_id'];
            $log_edi_arr['order_id'] = $order['order_id'];
            $log_edi_arr['row_id'] = $order_row_id;
            $curtz = $ci->session->userdata("usr_tzone")['timezone']??"";
            if(empty($curtz)){
                $curtz = "Australia/Sydney";
            }
            $order['pickup_datetime'] = getdatetimebytimezone($curtz, $order['pickup_datetime'], DFLT_TZ);
            $order['delivery_datetime'] = getdatetimebytimezone($curtz, $order['delivery_datetime'], DFLT_TZ);

            $reference_val = '';
            $where = array(
                "order_id" => $order_row_id
            );
            $select = "cargo_id,length,width,height,quantity,weight,volume,cargo_content";
            $table = "tb_order_cargodetails";
            $dimensions = array();
            $order_cargo = $ci->common->gettbldata($where, $select, $table, 0, 0);
            $pickupinfo = $ci->truckwaybillmodel->getshipper($order_row_id, 'Shipper');
            $receiverinfo = $ci->truckwaybillmodel->getshipper($order_row_id, 'Consignee');
            $order_number = $order['order_id'];
            $order_references = $ci->common->gettbldata(array(
                'order_id' => $order_row_id,
                'status' => 1
            ), 'reference_id,ref_value', 'tb_order_references', 0, 0);
            $order_details = $ci->common->gettblrowdata(array(
                'order_row_id' => $order_row_id
            ), 'service,delivery_note,purchase_order,consignment_note', 'tb_order_details', 0, 0);
            if (isset($order_details['service']) && ! empty($order_details['service'])) {
                $service_master = $ci->common->gettblrowdata(array(
                    'id' => $order_details['service']
                ), 'service_id,name', 'tb_service_master', 0, 0);
                $order_details['service'] = $service_master['service_id'];
            } else {
                $order_details['service'] = 'EG';
            }

            $log_edi_arr['consignment_note'] = ((isset($order_details['consignment_note'])) && (! empty($order_details['consignment_note'])))?$order_details['consignment_note']:'0';



            $reference_val = trim($reference_val, ",");
            $itemscount = 0;
            $itemsweight = 0;
            $dc_volume = 0;
            $goodsdesc = '';
            $isDG = false;
            $del_inst = '';
            $pick_inst = '';
            $service_code = "AF";
            $serviceData=$ci->Aumanifestmodel->getBondsServiceCode(['o.id'=>$data['ordid'], 'o.status !='=>0, 'o.company_code'=>'AUKN']);
            if(!empty($serviceData)){
                $service_code = isset($serviceData['service_code']) && !empty($serviceData['service_code']) ? $serviceData['service_code'] : "AF";
            }
           /* $delivery_pincode=substr($order['delivery_pincode'], 0, 4);
            if ($delivery_pincode=='2228') {
                $service_code = "SYD";
            }elseif ($delivery_pincode=='3043') {
                $service_code = "MEL";
            }else {
                $service_code = "AF";
            }*/
            $bonds_dc_val = 0;
            $overweigh_val = 0;
            $vendors_res = $ci->db->select("name")
                ->from('tb_vendors')
                ->where(array(
                'id' => $order['vendor_id'],
                'company_code' => 'AUKN',
                'status' => 1
            ))
                ->like(array(
                'name' => 'BONDS DC'
            ))
                ->get();
            /* log_message('error',"carrier query".$this->db->last_query()); */
            if (! empty($vendors_res)) {
                if ($vendors_res->num_rows() > 0) {
                    $bonds_dc_val = 1;
                }
            }

            $bons_vehicle_code = "2V";

            if ($bonds_dc_val == 1) {
                if (count($order_cargo) > 0) {
                    $cr_info = array();
                    $c_length = $c_width = $c_height = 0;
                    foreach ($order_cargo as $info) {
                        $cargoinfo = $ci->common->gettblrowdata(array(
                            'id' => $info['cargo_id']
                        ), 'dg_goods,weight_unit,length_unit,width_unit,height_unit,volume', 'tb_cargo_details', 0, 0);
                        $itemsweight += $info['weight'];
                        $isDG = ($cargoinfo['dg_goods'] == 0) ? 'false' : 'true';
                        $goodsdesc = $info['cargo_content'];
                        $info['quantity'] = round($info['quantity']);
                        $c_length += conversationtocm($info['length'], $cargoinfo['length_unit']);
                        $c_width += conversationtocm($info['width'], $cargoinfo['width_unit']);
                        $c_height += conversationtocm($info['height'], $cargoinfo['height_unit']);

                        $itemscount += $info['quantity'];
                        $dc_volume += $info['volume'];
                    }

                    $cr_info['volume'] = $dc_volume;
                    $cr_info['quantity'] = $itemscount;
                    $cr_info['length'] = $c_length;
                    $cr_info['width'] = $c_width;
                    $cr_info['height'] = $c_height;
                    $cargos[] = $cr_info;
                }
            } else {
                if (count($order_cargo) > 0) {
                    foreach ($order_cargo as $info) {
                        $cargoinfo = $ci->common->gettblrowdata(array(
                            'id' => $info['cargo_id']
                        ), 'dg_goods,weight_unit,length_unit,width_unit,height_unit', 'tb_cargo_details', 0, 0);
                        $itemsweight += $info['weight'];
                        $isDG = ($cargoinfo['dg_goods'] == 0) ? 'false' : 'true';
                        $goodsdesc = $info['cargo_content'];
                        $info['quantity'] = round($info['quantity']);
                        $info['length'] = conversationtocm($info['length'], $cargoinfo['length_unit']);
                        $info['width'] = conversationtocm($info['width'], $cargoinfo['width_unit']);
                        $info['height'] = conversationtocm($info['height'], $cargoinfo['height_unit']);
                        $dc_volume += $info['volume'];
                        if ($info['height'] > 120) {
                            $bons_vehicle_code = "8TA";
                        }
                        $itemscount += $info['quantity'];
                        $cargos[] = $info;
                    }
                }
            }


            /* get vechile codes */
            $vechile_codes_data = getvechilecode($itemsweight,$dc_volume);
            if (! empty($vechile_codes_data)) {
                $bons_vehicle_code = $vechile_codes_data['vehicle_code'];
                $overweigh_val = $vechile_codes_data['overweight'];
            }

            foreach ($order_references as $ref) {
                if ($ref['reference_id'] == 'ORD_DLVINST') {
                    $del_inst = $ref['ref_value'];
                    continue;
                }
                if ($ref['reference_id'] == 'ORD_PIKINST') {
                    $pick_inst = $ref['ref_value'];
                    continue;
                }
            }

            $userinfo = $ci->common->gettblrowdata(array(
                'id' => $order['user_id']
            ), 'name,emailid,mobile_no', 'tb_users', 0, 0);
            $customerinfo = $ci->common->gettblrowdata(array(
                'id' => $order['customer_id']
            ), 'name,phone,email_id', 'tb_customers', 0, 0);
            if (empty($customerinfo)) {
                $customerinfo['name'] = '';
                $customerinfo['phone'] = '';
                $customerinfo['email_id'] = '';
            }

            /* get bonds store data */
            $store_data = bondsstores($branch_code, $company_code);

            $request = '';
            $request .= '<?xml version="1.0" encoding="ISO-8859-1"?><job xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="job-bond.xsd">';
            $request .= '<job_action>BOOKING</job_action>';
            $request .= '<notifications>';
            /* if(!empty($userinfo['emailid'])){ */
            $request .= '  <notification>';
            $request .= '     <notify_type>CONFIRM</notify_type>';
            $request .= '     <notify_target>test@svkonekt.com</notify_target>';
            $request .= '  </notification>';
            /* } */

            $request .= '</notifications>';
            $request .= '<job_id></job_id>';
            $request .= '<account>' . $account . '</account>';
            $request .= '<authorization_code>' . $auth_code . '</authorization_code>';
            $request .= '<branch>' . $branch . '</branch>';
            $request .= '<containsDangerousGoods>' . $isDG . '</containsDangerousGoods>';
            $request .= '<job_date>' . $order['pickup_datetime']['date'] . '</job_date>';
            $request .= '<time_ready>07:00:00</time_ready>';

            $request .= '<references>';

            $request .= '  <reference>' . $order_details['consignment_note'] . '</reference>';
            $request .= '  <reference></reference>';
            $request .= '</references>';
            $request .= '<deliver_by_time xsi:nil="true"></deliver_by_time>';
            $request .= '<deliver_by_time_reason xsi:nil="true"></deliver_by_time_reason>';
            $request .= '<order_number>' . $order_details['consignment_note'] . '</order_number>';
            $request .= '<contact>' . substr($customerinfo['name'], 0, 20) . '</contact>';
            $request .= '<contact_email_or_mobile_number>' . $customerinfo['email_id'] . '</contact_email_or_mobile_number>';
            $request .= '<insurance>false</insurance>';
            if ($bonds_dc_val == 1) {
                $request .= '<service_code>TTH</service_code>';
                $request .= '<vehicle_code>' . $bons_vehicle_code . '</vehicle_code>';
            } else {
                $request .= '<service_code>' . $service_code . '</service_code>';
                $request .= '<vehicle_code>' . $bons_vehicle_code . '</vehicle_code>';
            }
            $request .= '<vehicle_special_features>';
            $request .= '<tail_lift>false</tail_lift>';
            $request .= '<hiab>false</hiab>';
            $request .= '<racks>false</racks>';
            $request .= '<rollers>false</rollers>';
            $request .= '</vehicle_special_features>';
            $goodsdesc = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $goodsdesc);
            $pick_inst = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $pick_inst);
            $request .= '<goods_description>' . $goodsdesc . '</goods_description>';
            if ($overweigh_val == 1) {
                $request .= '<instructions>' . 'Total weight ' . $itemsweight . ' Kgs, cubic ' . $dc_volume . '</instructions>';
            } else {
                $request .= '<instructions>' . $pick_inst . '</instructions>';
            }
            if($overweigh_val == 1){
                $request .= '<cubic>1</cubic>';
            } elseif ($bonds_dc_val == 1 || $company_code=="KNAU") {
                $request .= '<cubic>' . $dc_volume . '</cubic>';
            }else{
                $request .= '<cubic></cubic>';
            }
            if ($isDG == 1) {
                $request .= '<dangerous_goods_details><dg_class>2</dg_class></dangerous_goods_details>';
            }
            $request .= '<job_legs>';
            $request .= '<job_leg>';
            $request .= '<action>P</action>';
            $request .= '<service_qual></service_qual>';
            $bonds_store = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $store_data['bonds_store']);
            /* $request .= '<bonds_store>' . $bonds_store . '</bonds_store>'; */
            $request .= '<suburb>' . $store_data['suburb'] . '</suburb>';
            $store_data['address2'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $store_data['address2']);
            $request .= '<state>' . $store_data['state'] . '</state>';
            $request .= '<postcode>' . $store_data['postcode'] . '</postcode>';
            $request .= '<company>' . $store_data['company'] . '</company>';
            $store_data['address1'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $store_data['address1']);
            $request .= '<address1>' . $store_data['address1'] . '</address1>';
            $request .= '<address2>' . $store_data['address2'] . '</address2>';
            $request .= '<contact>' . $store_data['contact'] . '</contact>';
            $request .= '<items>' . $itemscount . '</items>';
            if ($overweigh_val == 1) {
                $request .= '<weight>1</weight>';
            } else {
                $request .= '<weight>' . $itemsweight . '</weight>';
            }
            $request .= '<dimensions>';
            if ($bonds_dc_val == 1) {
                $request .= '  <dimension>';
                $request .= '  <qty></qty>';
                $request .= '  <length></length>';
                $request .= '  <width></width>';
                $request .= '  <height></height>';
                $request .= '  </dimension>';
            } else {
                foreach ($cargos as $li) {
                    $request .= '  <dimension>';
                    $request .= '  <qty>' . $li['quantity'] . '</qty>';
                    $request .= '  <length>' . $li['length'] . '</length>';
                    $request .= '  <width>' . $li['width'] . '</width>';
                    $request .= '  <height>' . $li['height'] . '</height>';
                    $request .= '  </dimension>';
                }
            }
            $request .= '</dimensions>';
            $request .= '<references>';
            $request .= '  <reference>' . $pick_inst . '</reference>';
            $request .= '</references>';
            $request .= '</job_leg>';
            $request .= '  <job_leg>';
            $request .= '  <action>D</action>';
            $request .= '<service_qual></service_qual>';
            $request .= '  <suburb>' . $order['delivery_city'] . '</suburb>';
            $order['delivery_address2'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $order['delivery_address2']);
            $request .= '  <state>' . $order['delivery_address2'] . '</state>';
            $request .= '  <postcode>' . substr($order['delivery_pincode'], 0, 4) . '</postcode>';
            $request .= '  <company>' . $order['delivery_company'] . '</company>';
            $order['delivery_address1'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $order['delivery_address1']);
            $request .= '  <address1>' . $order['delivery_address1'] . '</address1>';
            $request .= '  <address2></address2>';
            $request .= '  <contact>' . substr(isset($receiverinfo['name']) ? $receiverinfo['name'] : "", 0, 25) . '</contact>';
            $request .= '  <items>' . $itemscount . '</items>';
            if ($overweigh_val == 1) {
                $request .= '<weight>1</weight>';
            } else {
                $request .= '<weight>' . $itemsweight . '</weight>';
            }
            $request .= '  <dimensions>';
            if ($bonds_dc_val == 1) {
                $request .= '  <dimension>';
                $request .= '  <qty></qty>';
                $request .= '  <length></length>';
                $request .= '  <width></width>';
                $request .= '  <height></height>';
                $request .= '  </dimension>';
            } else {
                if (! empty($cargos)) {
                    foreach ($cargos as $li) {
                        $request .= '  <dimension>';
                        $request .= '  <qty>' . $li['quantity'] . '</qty>';
                        $request .= '  <length>' . $li['length'] . '</length>';
                        $request .= '  <width>' . $li['width'] . '</width>';
                        $request .= '  <height>' . $li['height'] . '</height>';
                        $request .= '  </dimension>';
                    }
                }
            }
            $request .= '  </dimensions>';
            $request .= '  <references>';
            $request .= '     <reference>' . $del_inst . '</reference>';
            $request .= '  </references>';
            $request .= '  </job_leg>';
            $request .= '</job_legs>';
            $request .= '</job>';
            //log_message("error", "bonds xml " . $request);
            $log_edi_arr['request'] = $request;
            $request1 = $request;

            $resname = date("Ymdhis");
            $filenm = "bonds_request" . $resname . ".xml";
            $dom = new DOMDocument();
            $dom->preserveWhiteSpace = FALSE;
            $dom->loadXML($request);
            $dom->save('xml/borderapi/' . $filenm);
            $filename = "./xml/borderapi/" . $filenm;
            require_once './vendor/pear/http_request2/HTTP/Request2.php';
            $request = new HTTP_Request2();
            $request->setUrl("https://appsrv.bondscouriers.com.au/bondsws/api/upload-xml-job.htm");
            $request->setMethod(HTTP_Request2::METHOD_POST);
            if (SYS_TYPE == "LMV") {
                $request->setConfig(array(
                    'follow_redirects' => true,
                    'ssl_verify_peer' => false,
                    'connect_timeout' => 100,
                    'timeout' => 120
                ));
            } else {
                $request->setConfig(array(
                    'follow_redirects' => true,
                    'proxy' => PROXY_CONSTANT_HERE,
                    'ssl_verify_peer' => false,
                    'connect_timeout' => 100,
                    'timeout' => 120
                ));
            }
            $request->addUpload('uploadfile', $filename, $filenm, 'application/xml');
            $res = "";
            $response_error = '';
            $response_status = 0;
            try {
                $response = $request->send();
                if ($response->getStatus() == 200) {
                    $res = $response->getBody();
                } else {
                    $msg = 'Bonds Couriers Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                    $response_error = $msg;
                    log_message("error", $msg);
                }
            } catch (HTTP_Request2_Exception $e) {
                $error_msg = 'Bonds Couriers Error: ' . $e->getMessage();
                $response_error = $error_msg;
                log_message("error", $error_msg);
            }

            /* $res = file_get_contents(BASEPATH . "../assets/bondsxml/job_fail.xml"); */
            $log_edi_arr['response'] = $res;
            $log_edi_arr['status'] = 0;
            if (! empty($res)) {
                $xml = new SimpleXMLElement($res);
                if ($xml === false) {
                    $log_edi_arr['status'] = 0;
                    $result['errors'][] = $response_error =  "Invalid request try again!";
                } else {
                    $response = json_decode(json_encode(simplexml_load_string($res)), true);
                    if ($response) {
                        $job_id = (isset($response['job_details']['job_id'])) ? $response['job_details']['job_id'] : "";
                        if ($job_id != "") {
                            $log_edi_arr['status'] = 1;
                            $log_edi_arr['job_id'] = $job_id;
                            $line_no = (isset($response['job_details']['line_no'])) ? $response['job_details']['line_no'] : 0;
                            $res_array = array(
                                'order_id' => $order_row_id,
                                'status' => 1,
                                'msg_type' => $response['msg_type'],
                                'msg_status' => $response['msg_status'],
                                'request_path' => $filenm,
                                'response' => $res,
                                'job_id' => $job_id,
                                'line_no' => $line_no
                            );
                            $ins = $ci->common->insertTableData('tb_bondscar_edi', $res_array);
                            $ins_ar = array(
                                'order_id' => $order_row_id,
                                'reference_id' => 'BN',
                                'ref_value' => $job_id,
                                'status' => 1
                            );
                            $chkqry = $ci->common->gettblrowdata(array(
                                'order_id' => $order_row_id,
                                'reference_id' => 'BN',
                                'ref_value' => $response['job_details']['job_id']
                            ), "id", "tb_order_references", 0, 0);
                            if (count($chkqry) == 0) {
                                $ins = $ci->common->insertTableData('tb_order_references', $ins_ar);
                            }
                            $result['status'] = 1;
                            $response_status = 1;
                        } else {
                            $log_edi_arr['status'] = 0;
                            $log_edi_arr['err_msg'] = $response['job_details']['error'];
                            $result['status'] = 0;
                            $result['errors'][] = $response['job_details']['error'];
                            $response_error = 'No Job Id from BONDS Couriers';
                        }
                    } else {
                        $log_edi_arr['status'] = 0;
                        $result['errors'][] = $response_error = "No Response from BONDS Couriers";
                    }
                }
            }
            /*
             * $postdata = array(
             * "order_id" => $order_row_id,
             * "filenm" => $filenm,
             * "xdocdata" => $request1
             * );
             * $serviceurl = "https://elog360.app/svkonekt_test/bondscarrier/getmanifeststatus";
             * $headers = array(
             * 'Content-Type: multipart/form-data'
             * );
             * $ch = curl_init();
             * curl_setopt($ch, CURLOPT_URL, $serviceurl);
             * curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
             * curl_setopt($ch, CURLOPT_POST, 1);
             * curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
             * curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
             * curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
             * curl_setopt($ch, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
             * $res = curl_exec($ch);
             * curl_close($ch);
             * log_message('error', "Bonds Response " . $res);
             * $response = json_decode($res, true);
             * $result['status'] = 0;
             * if (! empty($response)) {
             * $result = $response;
             * }
             */
        }
        bondsedilogtransactions($log_edi_arr);

        $ci->benchmark->mark('edi_code_end');
        $execution_time =  $ci->benchmark->elapsed_time('edi_code_start', 'edi_code_end');
        $job_id = $job_id ?? 0;
        $ci->db->where(array(
            "id" => $edi_bonds_id
        ))
            ->update("tb_edi_bonds", array(
            "edi_status" => 0,
            "job_id" => $job_id,
            'execution_time' => $execution_time,
            'edi_request' => $log_edi_arr['request'],
            'edi_response' => $log_edi_arr['response'],
            'booking_id' => $log_edi_arr['order_id'],
            'response_error' => $response_error,
            'response_status' =>  $response_status
        ));
        if($source == 'callapi') {
            if(!empty($response_error)){
                echo $response_error;
            } else {
                echo "<pre>";
                print_r($response);
            }
        }
        
        return $result;
    }
}

if (! function_exists("get_session_data")) {

    function get_session_data($id)
    {
        $ci = &get_instance();
        $data = array();
        if(!empty($id)){
            $whr=array('id'=>$id);
            $order_data = $ci->common->gettblrowdata($whr, "company_code,branch_code,user_id", "tb_orders", 0, 0);
            if(!empty($order_data)){
                $data=$order_data;
            }
        }
        return $data;
    }
}

if (!function_exists("bonds_account_data")) {
    function bonds_account_data($companyCode, $branchCode)
    {
        $ci = &get_instance();
        $where = [
            'branch_code' => $branchCode,
            'company_code' => $companyCode,
            'status' => 1
        ];
        $bondsAccountData = $ci->common->gettblrowdata($where, 'branch,account_code,auth_code,bonds_store', 'tb_au_bonds_account_code', 0, 0);
        $branch = $bondsAccountData['branch'] ?? "";
        $account = $bondsAccountData['account_code'] ?? "";
        $authCode = $bondsAccountData['auth_code'] ?? "";
        $bondsStore = $bondsAccountData['bonds_store'] ?? "";

        return [
            'branch' => $branch,
            'account' => $account,
            'auth_code' => $authCode,
            'bonds_store' => $bondsStore
        ];
    }
}

/*
 * BONDS TRANSPORT and BONDS DC request and response saved log transactions
 */
if (! function_exists("bondsedilogtransactions")) {

    function bondsedilogtransactions($data)
    {
        $ci = &get_instance();
        $user_id = $ci->session->userdata('user_id')??"";
        $company_code = $ci->session->userdata('company_code')??"";
        $branch_code = $ci->session->userdata('branch_code')??"";
           if((empty($company_code)) || (empty($branch_code))){
              $session_data=get_session_data($data['row_id']);
              $company_code=$session_data['company_code']??"";
              $branch_code=$session_data['branch_code']??"";
              $user_id=$session_data['user_id']??"";
           }
        $ins_edi = $ins_obj_edi = array();
        $edi_id = $edi_name = $object_id = "";
        /*
         * Get vendor name
         */
        $vendors_res = $ci->db->select("name")
            ->from('tb_vendors')
            ->where(array(
            'id' => $data['vendor_id'],
            'company_code' => 'AUKN',
            'status' => 1
        ))
            ->get();
        $vendor_name = "BONDS";
        if ((! empty($vendors_res)) && ($vendors_res->num_rows() > 0)) {
            $ven_result = $vendors_res->row_array();
            $vendor_name = $ven_result['name'];
        }
        /*
         * Get edi_name from tb_edi_types table if edi name is not exists insert edi name
         */
        $edi_types = $ci->db->select("id,edi_name")
            ->from('tb_edi_types')
            ->where(array(
            'status' => '1'
        ))
            ->like(array(
            'edi_name' => $vendor_name
        ))
            ->get();
        if ((! empty($edi_types)) && ($edi_types->num_rows() > 0)) {
            $edi_result = $edi_types->row_array();
            $edi_name = $edi_result['edi_name'];
            $edi_id = $edi_result['id'];
        } else {
            $edi_name = $vendor_name;
            $ins_edi['edi_name'] = $edi_name;
            $edi_id = $ci->common->insertTableData('tb_edi_types', $ins_edi);
        }
        /*
         * Get edi object from tb_edi_object_types table if edi object is not exists insert edi object
         */
        $object_types = $ci->db->select("id,obj_type_name")
            ->from('tb_edi_object_types')
            ->where(array(
            'status' => '1'
        ))
            ->like(array(
            'obj_type_name' => "order-id"
        ))
            ->get();
        if ((! empty($object_types)) && ($object_types->num_rows() > 0)) {
            $edi_obj_result = $object_types->row_array();
            $object_id = $edi_obj_result['id'];
        } else {
            $ins_obj_edi['obj_type_name'] = "order-id";
            $ins_obj_edi['description'] = "bounds carrier unique id KN reference_id (BN)";
            $object_id = $ci->common->insertTableData('tb_edi_object_types', $ins_obj_edi);
        }

        $params = array(
            'edi_type' => 1, // '1->EDI Transport Order,2->EDI Status'
            'transaction_id' => isset($data['job_id']) ? $data['job_id'] : 0,
            'edi_id' => $edi_id, // edi id based on name take it from tb_edi_types
            'edi_name' => $edi_name,
            'bounded_type' => 2, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => 'XML',
            'status' => isset($data['status']) ? $data['status'] : 0,
            'obj_type' => $object_id,
            'txn_obj_id' => isset($data['order_id']) ? $data['order_id'] : 0,
            'ref_value' => isset($data['consignment_note']) ? $data['consignment_note'] : 0,
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'edi_request' => $data['request'],
            'edi_response' => $data['response']
        );
        $job_id = isset($data['job_id']) ? $data['job_id'] : 0;
        $res_edi_log = $ci->common->insertTableData('tb_etn_edi_transactions', $params);
        if (isset($data['status']) && $data['status'] == 0 && empty($job_id) && ! empty($data['err_msg'])) {
            /* bondsmail($data); */
        }
        return $res_edi_log;
        /* log_message('error', "transaction data" . json_encode($params)); */
    }
}
/*
 *
 */
if (! function_exists("getvechilecode")) {

    function getvechilecode($weight = NULL,$volume=NULL)
    {
        $ci = &get_instance();
        $data = array();
        $data['vehicle_code'] = "2V";
        $data['overweight'] = 0;
        if (! empty($weight) && !empty($volume)) {
            $whr = array(
                "max_weight >=" => $weight,
                "max_cubic >=" => $volume
            );
            $vechile_codes = $ci->common->gettblrowdata($whr, "id,vehicle_code", "tb_au_vehiclecodes", 0, 0);
            if (! empty($vechile_codes)) {
                $data['vehicle_code'] = $vechile_codes['vehicle_code'];
            }

            if ($weight > 22000 || $volume > 70) {
                $data['overweight'] = 1;
                $data['vehicle_code'] = "14TA";
            }
        }
        return $data;
    }
}

function bondsmail($data)
{
    $order_id = isset($data['order_id']) ? $data['order_id'] : 0;
    $err_msg = isset($data['err_msg']) ? $data['err_msg'] : "";
    $html = "";
    $html .= "Hi all,<br><br>";
    $html .= "EDI to Bonds Failed Order: " . $order_id . ",<br><br>";
    $html .= "Reason:<br>" . $err_msg . "<br>";
    $html .= "<br><br>";
    $html .= "Thanks,<br><br>Team Svkonekt";

    /*
     * echo $html . "<br/>" . $order_id . "<br/>" . $err_msg . "<br/>";
     */

    $ci = &get_instance();
    $ci->load->library('email');
    $ci->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
    $ci->email->to('external.gopikrishna.d@kuehne-nagel.com', 'Yadav');
    $ci->email->cc('external.gopikrishna.d@kuehne-nagel.com');
    $ci->email->subject('Bonds DC EDI failed : Order ' . $order_id);
    $ci->email->set_mailtype("html");
    $ci->email->message($html);
    if (! $ci->email->send()) {
        log_message("error", $ci->email->print_debugger());
    }
    $ci->email->clear(true);
}

/* get bonds store data */
if (! function_exists("bondsstores")) {

    function bondsstores($branchCode, $companyCode)
    {
        $ci = &get_instance();
        $data = array();
        $branchCode = strtoupper(trim($branchCode));
        $companyCode = strtoupper(trim($companyCode));
        $where = [
            'branch_code' => $branchCode,
            'company_code' => $companyCode,
            'status' => 1
        ];
        $bondsStoresData = $ci->common->gettblrowdata($where, '*', 'tb_bonds_stores_address', 0, 0);
        $data['bonds_store'] = $bondsStoresData['bonds_store'] ?? "";
        $data['suburb'] = $bondsStoresData['suburb'] ?? "";
        $data['state'] = $bondsStoresData['state'] ?? "";
        $data['postcode'] = $bondsStoresData['postcode'] ?? "";
        $data['company'] = $bondsStoresData['company'] ?? "";
        $data['address1'] = $bondsStoresData['address1'] ?? "";
        $data['address2'] = $bondsStoresData['address2'] ?? "";
        $data['contact'] = $bondsStoresData['contact'] ?? "";
        return $data;
    }
}

if (! function_exists("conversationtocm")) {

    function conversationtocm($val, $unit)
    {
        if ($unit == 'M' || $unit == 'm') {
            $cm = 100; // 1 meters in cm
        } else if ($unit == 'Inches') {
            $cm = 2.54; // 1 inch in cm
        } else {
            $cm = 1;
        }
        $res = $val * $cm;
        return $res;
    }
}

if (! function_exists("checkbondsCarrier")) {

    function checkbondsCarrier($id)
    {
        $ci = &get_instance();
        $result = array();
        $res = $ci->db->select("name")
            ->from('tb_vendors')
            ->where(array(
            'id' => $id,
        ))->where_in('company_code', ["AUKN", "KNAU"])
            ->like(array(
            'name' => 'BONDS'
        ))
            ->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = $res->row_array();
            }
        }
        return $result;
    }
}

/*
 * Before driver accept checking order_status table
 * driver accept function calling
 */

if (! function_exists("auupdatestatusbymanifest")) {

    function auupdatestatusbymanifest($order_row_id, $createdon = NULL)
    {
        $ci = &get_instance();
        $ci->load->model('common');
        $status = '0';
        $code = '2490';
        $select = "id,status_code";
        $table = "tb_status_master";
        $where = array(
            "status_code" => $code,
            'status' => 1
        ); // goods loaded by delivery
        $statusinfo = $ci->common->gettblrowdata($where, $select, $table, 0, 0);
        /* log_message('error', "query::1" . $ci->db->last_query() . "----------------->"); */
        if (! empty($statusinfo)) {
            $status_id = $statusinfo['id'];
            $stop_type = 'P';
            if(!empty($createdon)){
                $created_on = $createdon;
            } else{
                $created_on = date('Y-m-d H:i:s');
            }
            $stop_id = 0;
            $stop_detail_id = 0;

            $curtz = $ci->session->userdata("usr_tzone")['timezone']??"";
            if(empty($curtz)){
                $curtz = "Australia/Sydney";
            }
            $status_date = getdatetimebytimezone($curtz, $created_on, DFLT_TZ);
            $created_on = $status_date['datetime'];
            $innr_array = array(
                'order_id' => $order_row_id,
                'status_id' => $status_id,
                'status_code' => $code,
                'status' => 1,
                'status_date' => $created_on,
                'createdon' => $created_on,
                'updatedon' => $created_on
            );
            $check_array = array(
                'order_id' => $order_row_id,
                'status_id' => $status_id,
                'status_code' => $code
            );
            $chk_qry = $ci->db->select("id")->get_where('tb_order_status', $check_array);
            if ($chk_qry->num_rows() == 0) {
                $stsins = $ci->db->insert('tb_order_status', $innr_array);
                /* log_message('error',json_encode($innr_array)); */
            } else {
                $stsins = $ci->db->where_in("id", array(
                    "id" => $chk_qry->row()->id
                ))
                    ->update("tb_order_status", $innr_array);
            }
            $status = '1';
            $orderinfo = $ci->common->gettblrowdata(array(
                'id' => $order_row_id
            ), 'id,plat,plng,dlat,dlng,vendor_id,shift_id,user_id', 'tb_orders', 0, 0);

            if (! empty($orderinfo['shift_id'])) {
                audriveraccept($orderinfo, $createdon);
            }
        }
    }
}

/*
 * driver accept function
 */
if (! function_exists("audriveraccept")) {

    function audriveraccept($order, $createdon = NULL)
    {
        $ci = &get_instance();
        $ci->load->model('common');
        $vehicle_id = $driver_id = $sloc = '';
        $ordid = $order['id'];
        $userid = $order['user_id'];
        $shift_id = $order['shift_id'];
        $plat = $order['plat'];
        $plng = $order['plng'];
        $dlat = $order['dlat'];
        $dlng = $order['dlng'];
        $vendor_id = $order['vendor_id'];
        $curdt = date('Y-m-d H:i:s');
        if ($vendor_id == 310) {
            $vehicle_name = "BORDERVEHICLE";
            $driver_name = "BORDERdriver";
        } else {
            $vehicle_name = "BONDSVEHICLE";
            $driver_name = "BONDSdriver";
        }
        $where = array(
            'truck_number' => 'VEHICLE',
            'register_number' => $vehicle_name,
            'user_id' => $userid
        );
        $select = "id";
        $table = "tb_trucks_data";
        $chkemp = $ci->common->gettblrowdata($where, $select, $table, 0, 0);

        if (count($chkemp) == 0) {
            $inn_arr = array(
                'truck_number' => 'VEHICLE',
                'truck_type' => 1,
                'register_number' => $vehicle_name,
                'route' => 'VEHICLE',
                'user_id' => $userid,
                'status' => 'Active',
                'createdon' => $curdt
            );
            $vehicle_id = $ci->common->insertTableData("tb_trucks_data", $inn_arr);
        } else {
            $vehicle_id = $chkemp['id'];
        }
        $where = array(
            'name' => $driver_name,
            'user_id' => $userid
        );
        $select = "id";
        $table = "tb_truck_drivers";
        $dricheck = $ci->common->gettblrowdata($where, $select, $table, 0, 0);
        /* log_message('error', "query::4" . $ci->db->last_query() . "----------------->"); */
        if (count($dricheck) == 0) {
            $inn_arr = array(
                'name' => $driver_name,
                'password' => 'TVRJek5EVTI=',
                'user_id' => $userid,
                'createdby' => $userid,
                'status' => 'Active',
                'createdon' => $curdt
            );
            $driver_id = $ci->common->insertTableData("tb_truck_drivers", $inn_arr);
        } else {
            $driver_id = $dricheck['id'];
        }

        if ($vehicle_id != "" && $driver_id != "") {
            $stid = 10;
            $stcode = "0212";
            $chqry = $ci->db->select("id")->get_where("tb_trips", array(
                'shift_id' => $shift_id,
                'vehicle_id' => $vehicle_id,
                'driver_id' => $driver_id
            ), 1, 0);

            if ($chqry->num_rows() == 0) {
                $latitude = $plat;
                $longitude = $plng;
                $triparr = array(
                    'shift_id' => $shift_id,
                    'vehicle_id' => $vehicle_id,
                    'driver_id' => $driver_id,
                    'stime' => $curdt,
                    'splace' => "",
                    'eplace' => "",
                    'start_reading' => 0,
                    'end_reading' => 0,
                    'created_on' => $curdt,
                    'updated_on' => $curdt,
                    'status' => 1,
                    'trip_type' => 0,
                    'transit_status' => 0,
                    "plat" => $latitude,
                    "plng" => $longitude
                );
                $tripid = $ci->common->insertTableData('tb_trips', $triparr);
                if (empty($createdon)) {
                    $createdon = $curdt;
                }
                $insarry = array(
                    "shipment_id" => $shift_id,
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "stop_type" => "",
                    "trip_id" => $tripid,
                    "status_id" => $stid,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "status" => 1,
                    "reason" => "From ASN order data",
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "status_code" => $stcode,
                    "createdon" => $createdon,
                    'loc_name' => $sloc
                );
                $ins = $ci->db->insert("tb_stop_status", $insarry);

                /* update orders table */
                $ordwhr = array(
                    "shift_id" => $shift_id
                );
                $ordset = array(
                    "trip_id" => $tripid
                );
                $upd = $ci->db->set($ordset)
                    ->where($ordwhr)
                    ->update("tb_orders");
            }
            $where = array(
                'shft_id' => $shift_id,
                'user_id' => $userid,
                "status" => 1
            );
            $select = "id";
            $table = "tb_shft_veh";
            $shiftcheck = $ci->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($shiftcheck) > 0) {
                $upd = $ci->db->where(array(
                    "shft_id" => $shift_id
                ))->update("tb_shft_veh", array(
                    "vehicle_id" => $vehicle_id
                ));
            }
            $where = array(
                'vendor_id' => $vendor_id,
                'vehicle_id' => $vehicle_id,
                "status" => 1
            );
            $select = "id";
            $table = "tb_vendor_vehicles";
            $ven_veh_check = $ci->common->gettblrowdata($where, $select, $table, 0, 0);

            if (count($ven_veh_check) == 0) {
                $arr = array(
                    'vehicle_id' => $vehicle_id,
                    'vendor_id' => $vendor_id,
                    'status' => 1,
                    'createdon' => $curdt
                );
                $ins = $ci->common->insertTableData("tb_vendor_vehicles", $arr);
            }
            $chk = $ci->db->select("id,driver_id,status")
                ->order_by("id", "DESC")
                ->get_where("tb_vehicles_drivers", array(
                "vehicle_id" => $vehicle_id
            ));
            if ($chk->num_rows() > 0) {
                if ($driver_id == $chk->row()->driver_id) {
                    $upd = $ci->db->where(array(
                        "id" => $chk->row()->id
                    ))
                        ->update("tb_vehicles_drivers", array(
                        "status" => 1
                    ));
                } else {
                    $arr = array(
                        'vehicle_id' => $vehicle_id,
                        'driver_id' => $driver_id,
                        'imei' => "",
                        'status' => 1,
                        'createdon' => $curdt,
                        'updatedon' => $curdt
                    );
                    $ins = $ci->common->insertTableData("tb_vehicles_drivers", $arr);
                }
            } else {
                $arr = array(
                    'vehicle_id' => $vehicle_id,
                    'driver_id' => $driver_id,
                    'imei' => "",
                    'status' => 1,
                    'createdon' => $curdt,
                    'updatedon' => $curdt
                );
                $ins = $ci->common->insertTableData("tb_vehicles_drivers", $arr);
            }
            $chk11 = $ci->db->select("id")->get_where("tbl_assigned_drivers", array(
                "driver_id" => $driver_id,
                "vehicle_id" => $vehicle_id
            ), 1, 0);

            if ($chk11->num_rows() > 0) {
                $upd = $ci->db->where(array(
                    "id" => $chk11->row()->id
                ))
                    ->update("tbl_assigned_drivers", array(
                    "status" => "1",
                    'updated_on' => $curdt
                ));
            } else {
                $chk111 = $ci->db->select("id")->get_where("tbl_assigned_drivers", array(
                    "driver_id <>" => $driver_id,
                    "vehicle_id" => $vehicle_id,
                    "status" => 1
                ), 1, 0);

                if ($chk111->num_rows() == 0) {
                    $ins = $ci->common->insertTableData("tbl_assigned_drivers", array(
                        "vehicle_id" => $vehicle_id,
                        "user_id" => $userid,
                        "driver_id" => $driver_id,
                        "mobile_no" => $driver_id,
                        "from_time" => $curdt,
                        "to_time" => $curdt,
                        "status" => "1",
                        'created_on' => $curdt
                    ));
                } else {
                    $upd = $ci->db->where(array(
                        "id" => $chk111->row()->id
                    ))
                        ->update("tbl_assigned_drivers", array(
                        "driver_id" => $driver_id,
                        'updated_on' => $curdt
                    ));
                }
            }
        }
    }
}

