<?php
if(!defined('BASEPATH')) exit('No direct script access allowed');

	if (!function_exists("distancemetrixship")) {
		function distancemetrixship($lat1,$lng1,$lat2,$lng2) {
			$ci = & get_instance();
			$res = array();
			$res['distance'] = $res['disttext'] = $res['duration'] = $res['duratext'] = "";
			if($lat1 != "" && $lng1 != "" && $lat2 !="" && $lng2 != ""){
				$getqry = $ci->db->get_where("tbl_distance_master",array("slat"=>$lat1,"slng"=>$lng1,"dlat"=>$lat2,"dlng"=>$lng2),1,0);

				if($getqry->num_rows() == 0){
					$url = 'https://maps.googleapis.com/maps/api/distancematrix/json?origins='.$lat1.','.$lng1.'&destinations='.$lat2.','.$lng2.'&language=en&key='.GOOGLE_BKND_API_KEY;
					$data = ProcessGoogleAPICurl($url);
					if(!empty($data)){
						if($data['status'] == "OK"){
							$a=$data["rows"][0]["elements"];
							if($a[0]["status"]=="NOT_FOUND" || $a[0]["status"]=="ZERO_RESULTS"){
								$res['distance'] = $res['disttext'] = "Route";
								$res['duration'] = $res['duratext'] = "Not Found!";
							}else{
								$res['distance'] = isset($a[0]["distance"]["value"]) ? $a[0]["distance"]["value"] : '';
								$res['disttext'] = isset($a[0]["distance"]["text"]) ? $a[0]["distance"]["text"] : '';
								$res['duration'] = isset($a[0]["duration"]["value"]) ? $a[0]["duration"]["value"] : '';
								$res['duratext'] = isset($a[0]["duration"]["text"]) ? $a[0]["duration"]["text"] : '';
								/* Store Into Table */
								if($res['distance'] != "" && $res['duration'] != ""){
									$orgin = isset($data["origin_addresses"][0]) ? $data["origin_addresses"][0] : "";
									$orgin = $ci->db->escape($orgin);
									$dest = isset($data["destination_addresses"][0]) ? $data["destination_addresses"][0] : "";
									$dest = $ci->db->escape($dest);
									/*log_message("error",$orgin." 11---11 ".$dest);*/
									try {
    									$locdata = array("slat"=>$lat1,"slng"=>$lng1,"dlat"=>$lat2,"dlng"=>$lng2,"origin_address"=>$orgin,"destination_address"=>$dest,"distance"=>$res['distance'],"disttext"=>$res['disttext'],"duration"=>$res['duration'],"duratext"=>$res['duratext']);
    									if($ci->db->insert("tbl_distance_master",$locdata)){

    									}else{
    									    $orgloc = explode(", ",$orgin);
    										if(count($orgloc)>0){
    										    unset($orgloc[0]);
    										    $orgin = implode(", ",$orgloc);
    										}
    									    $destloc = explode(", ",$dest);
    										if(count($destloc)>0){
    										    unset($destloc[0]);
    										    unset($destloc[1]);
    										    $dest = implode(", ",$destloc);
    										}
    										log_message("error",$orgin." 22---22 ".$dest);
    									    $locdata1 = array("slat"=>$lat1,"slng"=>$lng1,"dlat"=>$lat2,"dlng"=>$lng2,"origin_address"=>$orgin,"destination_address"=>$dest,"distance"=>$res['distance'],"disttext"=>$res['disttext'],"duration"=>$res['duration'],"duratext"=>$res['duratext']);
    									    if($ci->db->insert("tbl_distance_master",$locdata1)){

    									    }
									    }
									} catch (Exception $e) {
                                        /*this will not catch DB related `enter code here`errors. But it will include them, because this is more general. */
                                        log_message('error ',$e->getMessage());
                                    }
									/*$ins = $ci->db->insert("tbl_distance_master",$locdata);*/
								}
							}
						}
					}
				}else{
					$res['distance'] = $getqry->row()->distance;
					$res['disttext'] = $getqry->row()->disttext;
					$res['duration'] = $getqry->row()->duration;
					$res['duratext'] = $getqry->row()->duratext;
				}
			}
			return $res;
		}
	}

	if (!function_exists("distanceship")) {
		function distanceship($lat1,$lng1,$lat2,$lng2): array {
			$ci = & get_instance();
            $lat1 = (float) $lat1;
            $lat2 = (float) $lat2;
            $lng1 = (float) $lng1;
            $lng2 = (float) $lng2;

            $cacheChain = implode('-', [$lat1, $lng1, $lat2, $lng2]);
            if ($_SESSION['distances'][$cacheChain] ?? false) {
                return $_SESSION['distances'][$cacheChain];
            }

            $qryres=$ci->db->query("select
                   distance,disttext,duration,duratext
                FROM tbl_distance_master
                WHERE (((3959 * acos(cos(radians(".$lat1.")) * cos(radians(slat)) * cos(radians(slng) - radians(".$lng1.")) + sin(radians(".$lat1.")) * sin(radians(slat)))))) < 0.05
                    AND (((3959 * acos(cos(radians(".$lat2.")) * cos(radians(dlat)) * cos(radians(dlng) - radians(".$lng2.")) + sin(radians(".$lat2.")) * sin(radians(dlat)))))) < 0.05
                ORDER BY id
                LIMIT 1");

            if($qryres && $qryres->num_rows()) {
                $rw = $qryres->row();
            }

            $result = [
                'distance' => $rw->distance ?? "",
                'disttext' => $rw->disttext ?? "",
                'duration' => $rw->duration ?? "",
                'duratext' => $rw->duratext ?? ""
            ];
            $_SESSION['distances'][$cacheChain] = $result;

            return $result;
        }
    }

	function distance($latitudeA, $longitudeA, $latitudeB, $longitudeB) :string
	{
        $hasIncorrectA = !($latitudeA ?? false) && !($longitudeA ?? false);
        $hasIncorrectB = !($latitudeB ?? false) && !($longitudeB ?? false);
        if ($hasIncorrectA || $hasIncorrectB) {
            log_message('error', 'wrong pair of coordinates : '.
                print_r ([$latitudeA, $longitudeA, $latitudeB, $longitudeB], true)
            );
            return '0'; // to provide backward compatibility
        }

        $R = 6371.0710; // earth radius in km

        $latitudeA = ((float) $latitudeA) * (M_PI/180);
        $latitudeB = ((float) $latitudeB) * (M_PI/180);
        $diffLatitude = abs($latitudeB - $latitudeA);
        $longitudeA = (float) $longitudeA;
        $longitudeB = (float) $longitudeB;
        $diffLongitude = abs($longitudeB - $longitudeA) * (M_PI/180);

        return 2 * $R * asin(sqrt(
            sin($diffLatitude/2)*sin($diffLatitude/2) +cos($latitudeA)*cos($latitudeB)*sin($diffLongitude/2)*sin($diffLongitude/2)
            )) . '';
	}

    if (!function_exists('getlatlngsbyplace')) {
        function getlatlngsbyplace($address) {
            $address = trim($address);
            $ci = &get_instance();
            $ci->load->driver('cache', ['adapter' => 'redis', 'backup' => 'file']);
            $cacheKey = 'latlong:' . hash('sha256', $address);
            if ($cachedResults = $ci->cache->get($cacheKey)) {
                return $cachedResults;
            }
            $addressArray = explode(",", $address);
            $arrayCount = count($addressArray);
            $arrayCountry = $addressArray[$arrayCount - 2] ?? "";
            if (strlen($arrayCountry) < 4 && $arrayCountry !== '') {
                $getCountryName = $ci->db->query("SELECT country_name FROM tbl_country_master WHERE country_name = ? OR country_code = ? AND status =?", [$arrayCountry, $arrayCountry, 1]);
                if ($getCountryName->num_rows() > 0) {
                    $country = $getCountryName->row()->country_name;
                    $addressArray[$arrayCount - 2] = $country;
                    $address = implode(",", $addressArray);
                }
            }
            $databaseResults = $ci->db->select('name1, lat, lng, country')->get_where('tb_location_data', ['source' => $address], 1);
            if ($databaseResults->num_rows() > 0) {
                $results = [
                    $databaseResults->row()->lat,
                    $databaseResults->row()->lng,
                    $databaseResults->row()->name1,
                    $databaseResults->row()->country,
                ];
                $ci->cache->save($cacheKey, $results, 3600);
                return $results;
            }

            if (empty(GOOGLE_BKND_API_KEY)) {
                return ['', '', '', ''];
            }

            $apiResults = ProcessGoogleAPICurl('https://maps.googleapis.com/maps/api/geocode/json?address=' . urlencode($address) . '&key=' . GOOGLE_BKND_API_KEY);
            if (empty($apiResults) or $apiResults['status'] !== 'OK') {
                return ['', '', '', ''];
            }
            $googleLat = $apiResults['results'][0]['geometry']['location']['lat'];
            $googleLng = $apiResults['results'][0]['geometry']['location']['lng'];
            $googleFormattedAddress = $apiResults['results'][0]['formatted_address'];
            $googleShortAddress = $country = '';
            // find first address component of type "route" and use it as short address
            foreach ($apiResults['results'][0]['address_components'] as $googleAddressComponent) {
                if (in_array('route', $googleAddressComponent['types'])) {
                    $googleShortAddress = $googleAddressComponent['long_name'];
                }  elseif (in_array('country', $googleAddressComponent['types'])){
                    $country = $googleAddressComponent['short_name'];
                }
            }
            $ci->db->insert('tb_location_data', [
                'name1' => $googleFormattedAddress,
                'name2' => $googleShortAddress,
                'country' => $country,
                'lat' => $googleLat,
                'lng' => $googleLng,
                'source' => $address,
            ]);

            $results = [
                $googleLat,
                $googleLng,
                $googleFormattedAddress,
                $country
            ];
            $ci->cache->save($cacheKey, $results, 3600);
            return $results;
        }
    }

	if(!function_exists("getempcount")){
		function getempcount($tripid){
			$time="";
			$ci = & get_instance();
			$query=$ci->db->query("select count(sve.id) as count from tb_trips t,tb_shft_veh sv,tb_shft_veh_emp sve where t.id=$tripid and sv.shft_id=t.shift_id and sve.shft_veh_id=sv.id and sve.status=1 and sv.status=1 and t.vehicle_id=sv.vehicle_id");
			if($query->num_rows()>0){
				$time=$query->row()->count;
			}
			return $time;
		}
	}

	function gettripdata($id){
		$ci = & get_instance();
		return $ci->db->select("id,vehicle_id,driver_id,stime,start_imei,start_reading")
            ->where("id",$id)
            ->limit(1)
            ->get("tb_trips");
	}

	function getStartAndEndDate($week, $year)
	{
	    $time = strtotime("1 January $year", time());
	    $day = date('w', $time);
	    $time += ((7*$week)+1-$day)*24*3600;
	    $return[0] = date('Y-n-j', $time);
	    $time += 6*24*3600;
	    $return[1] = date('Y-n-j', $time);
	    return $return;
	}

	function getvalue($req,$search,$data,$tab,$stat=""):string
    {
        $result = "";
        $ci = &get_instance();
        $isRequestForStime = ($req === "stime");

        if ($isRequestForStime) {
            $curtz = $ci->session->userdata("usr_tzone")['timezone'];
            $req = " convertToClientTZ(stime,'" . ($curtz ?: DFLT_TZ) . "') as stime";
        }
        $query = $ci->db->query(
            "-- getvalue() function
            SELECT $req FROM $tab
            WHERE $search='$data' $stat
            ORDER BY id DESC
            LIMIT 1"
        );

        if ($query->num_rows() > 0) {
            if ($isRequestForStime) {
                $req = "stime";
            }
            $result = $query->row()->$req ?: "";
        }

        return $result;
	}

	function getspeedvalue($data){
		$ret="";
		$ci =& get_instance();
		$q=$ci->db->query("select speed from tb_rtdrive_locations where mobileimei='$data' and speed<='45' and accuracy <=200 order by id desc limit 1");
		if($q->num_rows()>0){
		$ret=$q->row()->speed;
		}
		return $ret;
	}
	function adddefaltsos($emp){
		$ci =& get_instance();
		$qr=$ci->db->query("select id from tb_emp_sos_contacts where emp_id=$emp");
		if($qr->num_rows()>0){
			$upd = $ci->db->where("emp_id",$emp)->update("tb_shft_veh_emp",array("contact_name1"=>'Transport Help Desk','contact_num1'=>'9966314178'));
		}else{
			$upd = $ci->db->insert("tb_emp_sos_contacts",array("emp_id"=>$emp,"createdon"=>date("Y-m-d H:i:s"),"status"=>'1',"contact_name1"=>'Transport Help Desk','contact_num1'=>'9966314178'));
		}
	}

	function getTokenByReg($id,$type){
		$ci =& get_instance();
		$token = array();
		if($type == "Customer"){
			$sql=$ci->db->select("gcm_id")->where(array("id"=>$id,"status"=>1))->where("gcm_id!=''")->where("gcm_id <>","")->get("tb_customers");
		}else if($type == "Driver"){
			$sql=$ci->db->select("gcm_id")->where(array("id"=>$id,"status"=>1))->where("gcm_id!=''")->where("gcm_id <>","")->get("tb_truck_drivers");
		}else{
			$sql=$ci->db->select("gcm_id")->where(array("id"=>$id,"status"=>1))->where("gcm_id!=''")->where("gcm_id <>","")->get("tb_employee");
		}
		if($sql->num_rows()>0){
			$token[]=$sql->row()->gcm_id;
		}
		return $token;
	}
	function getAllTokens($trip="0"){
		$ci =& get_instance();
		$tokens=array();
		$stmt = $ci->db->query("select e.gcm_id from tb_employee e,tb_trips t,tb_shft_veh sv,tb_shft_veh_emp sve where t.id=$trip and t.shift_id=sv.shft_id and t.vehicle_id=sv.vehicle_id and sve.shft_veh_id=sv.id and sve.emp_id=e.id and sv.status=1 and sve.status=1 and e.gcm_id!='' and e.gcm_id != ''");
		if($stmt->num_rows()>0){
	        foreach($stmt->result() as $row){
	            array_push($tokens, $row->gcm_id);
	        }
	    }
	    return $tokens;
	}
if(!function_exists('getShipDetailByVeh'))
{
	function getShipDetailByVeh($veh){
		$ci =& get_instance();
		$ships="";
		if($veh != ""){
			$sql=$ci->db->query("select e.id,e.name,e.shipment_weight,e.shipment_volume,e.ship_type from tb_employee e,tb_trips t,tb_shft_veh sv where e.shift_id=t.shift_id and t.shift_id=sv.shft_id and t.vehicle_id=sv.vehicle_id AND t.driver_id=$veh and sv.status=1 GROUP BY t.driver_id ORDER BY t.id DESC");
			if($sql->num_rows()>0){
				foreach($sql->result() as $res){
					$ships .= $res->id.')'.$res->name.' (weight: '.uom_string($res->shipment_weight, 'kg').', volume: '.uom_string($res->shipment_volume, 'cbm').') ('.$res->ship_type.')<br/>';
				}
			}
		}
		return $ships;
	}
}
if(!function_exists('getGCMDetailByVeh'))
{
	function getGCMDetailByVeh($trip){
		$ci =& get_instance();
		$token=array();
		if($trip != ""){
			$sql=$ci->db->query("select e.gcm_id from tb_employee e,tb_trips t,tb_shft_veh sv,tb_shft_veh_emp sve where t.id=$trip and t.shift_id=sv.shft_id and t.vehicle_id=sv.vehicle_id and sve.shft_veh_id=sv.id and sve.emp_id=e.id and sv.status=1 and sve.status=1 and e.gcm_id!='' and e.gcm_id is not null");
			if($sql->num_rows()>0){
				$token[]=$sql->row()->gcm_id;
			}
		}
		return $token;
	}
}
if(!function_exists('getStopsbyShipment'))
{
	function getStopsbyShipment($ship){
		$ci =& get_instance();
		$res=array();
		if($ship != ""){
			$whr = array('shift_id'=>$ship,'status'=>1);
			$sql=$ci->db->select("id,pickup,`drop`,name,phone,shipment_weight,shipment_volume,ship_type,startdate,stop_order")->get_where('tb_employee',$whr);
			if($sql->num_rows()>0){
				foreach($sql->result() as $qr){
					$res[]= array('id'=>$qr->id,'pickup'=>$qr->pickup,'drop'=>$qr->drop,'name'=>$qr->name,'phone'=>$qr->phone,'ship_type'=>$qr->ship_type,'shipment_weight'=>$qr->shipment_weight,'shipment_volume'=>$qr->shipment_volume,'startdate'=>$qr->startdate,'stop_order'=>$qr->stop_order);
				}
			}
		}
		return $res;
	}
}
if(!function_exists('getpicksdropsbystop'))
{
	function getpicksdropsbystop($ship,$stop,$type){
		$ci =& get_instance();
		$res = array();
		if($ship != "" && $type=="P"){
			$whr = array('shift_id'=>$ship,'stop_id'=>$stop,'status'=>1);
			$sql=$ci->db->query("SELECT e.id,e.ship_type FROM tb_employee e WHERE e.shift_id=$ship AND e.stop_id=$stop AND e.status=1");
			if($sql->num_rows()>0){
				foreach($sql->result() as $qr){
					$res[]= array('id'=>$qr->id,'ship_type'=>"P");
				}
			}
		}else if($ship != "" && $type=="D"){

			$sql1=$ci->db->query("SELECT e.id,e.ship_type FROM tb_employee e WHERE e.shift_id=$ship AND e.drop_stopid=$stop AND e.status=1");
			if($sql1->num_rows()>0){
				foreach($sql1->result() as $qr1){
					$res[]= array('id'=>$qr1->id,'ship_type'=>"D");
				}
			}
		}
		return $res;
	}
}
if(!function_exists('getpicksdropsbystopDetail'))
{
	function getpicksdropsbystopDetail($ship,$stop,$type="P"){
		$ci =& get_instance();
		$res=array();
		$res["P"]=[];
		$res["D"]=[];
		$curtz = $ci->session->userdata("usr_tzone")['timezone'];
		if($curtz == ""){ $curtz = DFLT_TZ;}
		if($ship != ""){
			if($type=="P"){
				$whr = array('shift_id'=>$ship,'stop_id'=>$stop,'status'=>1);
				$sql=$ci->db->query("SELECT e.id,e.ship_type,e.stop_order,e.pickup,e.`drop`, convertToClientTZ(e.pickup_datetime,'".$curtz."') as pickup_datetime, convertToClientTZ(e.drop_datetime,'".$curtz."') as drop_datetime, e.capacity, e.shipment_weight, e.shipment_volume, e.pkgitemid, e.no_of_pkgs, m.material FROM tb_employee e,tb_materials m WHERE e.material_id=m.id AND e.shift_id=$ship AND e.stop_id=$stop AND e.status=1 GROUP BY e.id ORDER BY e.drop_stopid ASC");
				if($sql->num_rows()>0){
					foreach($sql->result() as $qr){
						$res["P"][]= array('id'=>$qr->id,'ship_type'=>"P",'stop_order'=>$qr->stop_order,'pickup'=>$qr->pickup,'drop'=>$qr->drop,'pickup_datetime'=>$qr->pickup_datetime,'drop_datetime'=>$qr->drop_datetime,'capacity'=>$qr->capacity,'shipment_weight'=>$qr->shipment_weight,'shipment_volume'=>$qr->shipment_volume,'material'=>$qr->material,'pkgitemid'=>$qr->pkgitemid,'no_of_pkgs'=>$qr->no_of_pkgs);
					}
				}
			}
			if($type=="D"){
				$sql=$ci->db->query("SELECT e.id,e.ship_type,e.stop_order,e.pickup,e.`drop`,convertToClientTZ(e.pickup_datetime,'".$curtz."') as pickup_datetime, convertToClientTZ(e.drop_datetime,'".$curtz."') as drop_datetime, e.capacity, e.shipment_weight, e.shipment_volume, e.pkgitemid,e.no_of_pkgs,m.material FROM tb_employee e,tb_materials m WHERE e.material_id=m.id AND e.shift_id=$ship AND e.drop_stopid=$stop AND e.status=1 GROUP BY e.id ORDER BY e.stop_id ASC");
				if($sql->num_rows()>0){
					foreach($sql->result() as $qr){
						$res["D"][]= array('id'=>$qr->id,'ship_type'=>"D",'stop_order'=>$qr->stop_order,'pickup'=>$qr->pickup,'drop'=>$qr->drop,'pickup_datetime'=>$qr->pickup_datetime,'drop_datetime'=>$qr->drop_datetime,'capacity'=>$qr->capacity,'shipment_weight'=>$qr->shipment_weight,'shipment_volume'=>$qr->shipment_volume,'material'=>$qr->material,'pkgitemid'=>$qr->pkgitemid,'no_of_pkgs'=>$qr->no_of_pkgs);
					}
				}
			}
		}
		return $res;
	}
}
if(!function_exists('getsdtreforder'))
{
	function getsdtreforder($ord){
		$ci =& get_instance();
		$res="";
		if($ord != ""){
			$whr = array("order_id"=>$ord,"reference_id"=>'SDT',"status"=>1);
			$getsdt = $ci->db->select("ref_value")->get_where("tb_order_references",$whr,1,0);
			if($getsdt->num_rows()>0){
				$res = $getsdt->row()->ref_value;
			}
		}
		return $res;
	}
}

if (!function_exists('getOrderTypeReference')) {
    function getOrderTypeReference(int $orderID): string
    {
        $ci =& get_instance();
        $response = "";
        if ($orderID != "") {
            $where = ["order_id" => $orderID, "reference_id" => 'OT', "status" => 1];
            $getOrderType = $ci->db->select("ref_value")->get_where("tb_order_references", $where, 1, 0);
            if ($getOrderType->num_rows() > 0) {
                $response = $getOrderType->row()->ref_value;
            }
        }
        return $response;
    }
}

if (!function_exists('getJplPath')) {
    function getJplPath(string $orderId): string
    {
        $path = "./assets/jpl_files/RL$orderId.jpl";
        $attempt = 0;
        while (file_exists($path) && $attempt < 100) {
            ++$attempt;
            $path = "./assets/jpl_files/RL" . $orderId . '_' . $attempt . ".jpl";
        }
        return $path;
    }
}

if (!function_exists('getEpodPath')) {
    function getEpodPath(string $orderId): string
    {
        $path = "./assets/trippods/RL" . $orderId . ".pdf";
        $attempt = 0;
        while (file_exists($path) && $attempt < 100) {
            ++$attempt;
            $path = "./assets/trippods/RL" . $orderId . '_' . $attempt . ".pdf";
        }
        return $path;
    }
}
