<?php
if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

if (!function_exists('checkAuthentication')) {
	function checkAuthentication(string $uname, string $pass): string
	{
		$ci = &get_instance();
		$ci->load->model('common');
		$auth_status = "";
		if ($uname != '' && $pass != '') {
			$checkAuth = $ci->common->gettblrowdata(array("code" => $uname, "status" => 1), 'id,password', 'tb_vendors', 0, 0);
			if (count($checkAuth) > 0) {
				$password = $checkAuth['password'];
                if (password_verify($password) == $pass) {
                    $auth_status = "success";
                } else {
                    $auth_status = "failed";
                }

			} else {
				$auth_status = "failed";
			}

		} else {
			$auth_status = "failed";
		}
		return $auth_status;
	}
}

if (!function_exists('validateXml')) {
	function validateXml($file): bool
	{
		$doc = @simplexml_load_string($file);

		if ($doc) {
            return true;
		} else {
			log_message('error', 'Edi-info: XML not Valid');
            return false;
		}

	}
}

if (!function_exists('xmlFieldsValidation')) {
	function xmlFieldsValidation(array $data): array
	{
        $ci = &get_instance();
        $ci->load->model('common');
        $valid_orders = [];
        $orderid = "";
        $status = "";
        $dateTime = "";
        $status_check = "";

        if (count($data['executionStatus'])===0) {
            log_message('error', 'Openbox-info: No orders found.');
            return [];
        }

        foreach ($data['executionStatus'] as $ids) {
            if (array_key_exists("OrderID", $data['executionStatus'])) {
                $status = $data['executionStatus']['status'];
                $dateTime = $data['executionStatus']['DateTime'];
                $orderid = $data['executionStatus']['OrderID'];
            } else {
                $status = $ids['status'];
                $orderid = $ids['OrderID'];
                $dateTime = $ids['DateTime'];
            }

            $checkAuth = $ci->common->gettblrowdata(
                ['order_id' => $orderid, 'trip_id' => $data['TripID'], "status !=" => 0],
                'id',
                'tb_orders',
                0,
                0
            );
            $status_check = checkStatusCodes($status);

            if (count($checkAuth) > 0) {
                if ($status != '' && $dateTime != '' && $status_check == 'success') {
                    $valid_orders[] = [
                        'orderID' => $orderid,
                        'tripID' => $data['TripID'],
                        'status' => $status,
                        'dateTime' => $dateTime,
                    ];
                }
            } else {
                log_message(
                    'error',
                    'Edi-info: Order id-' . $orderid . ' and Trip id-' . $data['TripID'] . ' Miss batch'
                );
            }
        }

        return $valid_orders;
    }
}

if (!function_exists('checkStatusCodes')) {
    function checkStatusCodes(string $status): bool
    {
        $ci = &get_instance();
        $ci->load->helper('customerconfigedi');
        return in_array($status, statusCodesList(), true);
    }
}


