<?php

$ci = &get_instance();
$ci->load->helper( 'string' );

if ( ! function_exists( "statusLabel" ) ) {
	function statusLabel( $status ) {
		if ( $status == 1 ) {
			$res['label'] = 'Active';
			$res['class'] = 'success';
			$res['icon']  = 'fa-check';
		} else if ( $status == - 1 ) {
			$res['label'] = 'Deleted';
			$res['class'] = 'danger';
			$res['icon']  = 'fa-trash';
		} else {
			$res['label'] = 'Inactive';
			$res['class'] = 'warning';
			$res['icon']  = 'fa-times-circle';
		}

		return $res;
	}
}
if ( ! function_exists( "da" ) ) {
	function da( $arr, $l = FALSE ) {
		if ( $l ) {
			log_message( 'error', 'Error Message $arr' . json_encode( $arr, 128 ) );
		} else {
			echo json_encode( $arr, 128 );
			exit;
		}
	}
}

if ( ! function_exists( "getVNCurrencies" ) ) {
	function getVNCurrencies() {
		$ci = &get_instance();

		return $ci->db->query( "select currency from tbl_country_master where currency in ('VND', 'USD', 'THB', 'SGD', 'MYR', 'GBP', 'EUR', 'HKD', 'CNY', 'CHF') group by currency" )->result();
	}
}

if ( ! function_exists( "time_elapsed_string" ) ) {
	function time_elapsed_string( $datetime, $full = FALSE ) {
		$now     = new DateTime;
		$ago     = new DateTime( $datetime );
		$diff    = $now->diff( $ago );
		$diff->w = floor( $diff->d / 7 );
		$diff->d -= $diff->w * 7;
		$string  = array(
			'y' => 'Year',
			'm' => 'Month',
			'w' => 'Week',
			'd' => 'Day',
			'h' => 'Hour',
			'i' => 'Minute',
			's' => 'Sec\'',
		);
		foreach ( $string as $k => &$v ) {
			if ( $diff->$k ) {
				$v = $diff->$k . ' ' . $v . ( $diff->$k > 1 ? 's' : '' );
			} else {
				unset( $string[ $k ] );
			}
		}
		if ( ! $full ) {
			$string = array_slice( $string, 0, 1 );
		}

		return $string ? implode( ', ', $string ) . ' ago' : 'just now';
	}

}
if ( ! function_exists( "string_limited" ) ) {
	function string_limited( $x, $length ) {
		if ( strlen( $x ) <= $length ) {
			return $x;
		} else {
			$y = substr( $x, 0, $length ) . '...';

			return $y;
		}
	}
}

if ( ! function_exists( "removeAllSpecialChar" ) ) {
	function removeAllSpecialChar( $string ) {
//	$string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

		return preg_replace( '/[^A-Za-z0-9]/', '', $string ); // Removes special chars.
	}
}

if ( ! function_exists( "limitChar" ) ) {
	function limitChar( $x, $length ) {
		if ( strlen( $x ) <= $length ) {
			return $x;
		} else {
			$y = substr( $x, 0, $length ) . '...';

			return $y;
		}
	}
}

if ( ! function_exists( "char_replace" ) ) {
	function char_replace( $text, $rep_simbol = " " ) {
		$char = array( '!', '&', '?', '/', '/\/', ':', ';', '#', '<', '>', '=', '^', '@', '~', '`', '[', ']', '{', '}', ' ', ',', '(', ')', '*', '+', '$', '%' );

		return $name = str_replace( $char, $rep_simbol, $text );
	}
}
if ( ! function_exists( "string_mask" ) ) {
	function string_mask( $string, $type ) {
		if ( $type == 'email' ) {
			$emailSub = explode( '@', $string );
			$substr   = substr( $emailSub[0], 2, - 1 );

			return str_replace( $substr, str_repeat( "*", strlen( $substr ) ), $string );
		} else {
			$substr = substr( $string, 2, - 2 );

			return str_replace( $substr, str_repeat( "*", strlen( $substr ) ), $string );
		}
	}
}

if ( ! function_exists( "getPercentage" ) ) {
	function getPercentage( $inp, $total ) {
		return number_format( ( $inp * 100 ) / $total, 2 );
	}
}

if ( ! function_exists( "reduce_comma" ) ) {
	function reduce_comma( $string ) {
		return reduce_multiples( reduce_multiples( reduce_multiples( $string, ',', TRUE ), ', ', TRUE ), ' ,', TRUE );
	}
}

if ( ! function_exists( "getStarRating" ) ) {
	function getStarRating( $starNumber ) {
		$starNumber = floatval( $starNumber );
		$res        = '';
		for ( $x = 1; $x <= $starNumber; $x ++ ) {
			$res .= '<i class="mdi mdi-star"></i>';
		}
		if ( strpos( $starNumber, '.' ) ) {
			$res .= '<i class="mdi mdi-star-half-full"></i>';
			$x ++;
		}
		while ( $x <= 5 ) {
			$res .= '<i class="mdi mdi-star-outline"></i>';
			$x ++;
		}

		return $res;
	}
}

if ( ! function_exists( 'cleanArray' ) ) {

	function cleanArray( $array ) {
		$array = (array) $array;
		if ( is_array( $array ) ) {
			foreach ( $array as $key => $value ) {
				if ( empty( $value ) ) {
					unset( $array[ $key ] );
				}
			}
		}

		return $array;
	}
}

if ( ! function_exists( 'get_offset_time_abbr' ) ) {

	function get_offset_time_abbr(int $seconds, bool $isDST=true): string {
		$tz = timezone_name_from_abbr( '', $seconds, $isDST );
        //shouldn't be needed
		//if ( $tz === FALSE ) {
		//	$tz = timezone_name_from_abbr( '', $seconds, 0 );
		//}

		return $tz;
	}
}

if ( ! function_exists( 'get_http_response_word' ) ) {
	function get_http_response_word( string $http_request_method, int $http_response_code ): array {
	  switch (true){
      case $http_request_method == 'POST' && $http_response_code == 201: $result = 'CREATED'; $color = 'success'; break;
      case $http_request_method == 'POST' && $http_response_code == 200: $result = 'SUCCESS'; $color = 'success'; break;
      case $http_request_method == 'PUT' && $http_response_code == 200: $result = 'UPDATED';  $color = 'primary';break;
      case $http_response_code == 401: $result = 'UNAUTHORIZED';  $color = 'danger'; break;
      case $http_response_code == 422: $result = 'UNPROCESSED';  $color = 'warning'; break;
      case $http_response_code == 400: $result = 'BAD REQUEST';  $color = 'warning'; break;
      case $http_response_code == 500: $result = 'SERVER ERROR';  $color = 'danger'; break;
      default : $result = 'INTERNAL SERVER ERROR'; $color = 'danger'; break;
    }
		return ['key' => $result,'color'=> $color] ;
	}
}

if ( ! function_exists( 'nicplace_status_class' ) ) {
  function nicplace_status_class(string $nicplaceStatus):string
  {
    switch ($nicplaceStatus) {
      case 'RUNNING': $class = 'text-primary'; break;
      case 'WAITING': $class = 'text-warning'; break;
      case 'FINISHED' : $class = 'text-success'; break;
      default: $class = 'text-default';
    }
    return $class;
  }
}
