<?php
if (!defined('BASEPATH')) { exit('No direct script access allowed'); }

/**
* Bascik edi : Upload CSV file to FTP
* @param int $shift_id
* @date  03-07-2021
*/
if (!function_exists('bascikedi_call')) {
    function bascikedi_call($shift_id)
    {
        if($shift_id != ""){
            $CI = &get_instance();
            $CI->load->library('network/Ftp', ['ftpName' => FTP_NAME_BASCIK]);
            $result = array();
            $consignee_id = $shipper_id = 0;
            $shipper_city = $shipper_street = $shipper_state =  $consignee_city = $consignee_street = $consignee_state = $shipper_name = $consignee_name = "";
            $order_row_id = $shipment_number = 0;
            $CI->db->select("o.id as order_row_id,o.order_id,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2");
            $CI->db->from("tb_orders o");
            $CI->db->where("o.shift_id",$shift_id);
            $userdata = $CI->db->get();
            if($userdata->num_rows()>0){
                $CI->load->library("SftpProxyClient");
                $SFTP = $CI->sftpproxyclient->proxyConnection(BASCIK_SFTP_HOST, "Bascik");
                if (!$SFTP) {
                    log_message("error", 'Unable to connect Admin->getcsvfile');
                } else {
                    foreach ($userdata->result() as $res) {
                        $order_row_id = $res->order_row_id;
                        $getdq_note = $CI->common->gettblrowdata(['order_id' => $order_row_id, 'reference_id' => 'DQ'], 'ref_value', 'tb_order_references', 0, 0);
                        if (!empty($getdq_note)) {
                            $shipment_number = $getdq_note['ref_value'] . "00";
                        }
                        $orderfile = "";
                        $order_id = $res->order_id;
                        $order_cnt = mb_substr($order_id, 6, 4);
                        $orderfile = "KNO_" . $order_cnt . date('Ymdhi_s') . "6501" . '.csv';
                        $filename = './assets/csvfiles/' . $orderfile;
                        $file = null;
                        if (file_exists($filename)) {
                            $file = fopen($filename, 'w');
                        } else {
                            $file = fopen($filename, 'x');
                        }
                        $consignee_id = 0;
                        $consignee_name = $res->delivery_company;
                        $shipper_name = $res->pickup_company;
                        $shipper_city = $res->pickup_city;
                        $shipper_street = $res->pickup_address1;
                        $shipper_state = $res->pickup_address2;
                        $consignee_city = $res->delivery_city;
                        $consignee_street = $res->delivery_address1;
                        $consignee_state = $res->delivery_address2;
                        $cargo = [];
                        $getcargodetails = $CI->db->query("SELECT c.cargo_type,c.goods_description,o.weight,o.volume,o.quantity FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $order_row_id . "' AND o.status='1' AND o.cargo_id=c.id GROUP BY c.id ORDER BY c.id DESC");
                        if ($getcargodetails->num_rows() > 0) {
                            foreach ($getcargodetails->result() as $row) {
                                $qty = $row->quantity;
                                $cargo_type = $row->cargo_type;
                                $description = $row->goods_description;
                                $weight = $row->weight;
                                $volume = $row->volume;
                                $empty = "";
                                $cargo[] = ['G', 'quantity' => round($qty), 'cargo_type' => $cargo_type, 'description' => $description, '', 'weight' => $weight, 'volume' => $volume];
                            }
                        }
                        $knorder_id = "SVK" . $order_id;
                        $result = ['H', $knorder_id, 'KU', '', $shipper_name, $shipper_street, $shipper_state, $shipper_city, $consignee_name, $consignee_street, $consignee_state, $consignee_city, $shipment_number];
                        fputcsv($file, $result);
                        foreach ($cargo as $key => $value) {
                            fputcsv($file, $value);
                        }
                        fclose($file);
                        $new_file = "./TestReceiveEDI/" . $orderfile;
                        if (SYS_TYPE == 'TMS') {
                            $new_file = "./ReceiveEDI/" . $orderfile;
                        }

                        $CI->sftpproxyclient->fileUpload([
                            'sftp' => $SFTP,
                            'sftpUsername' => BASCIK_SFTP_USERNAME,
                            'sftpPassword' => BASCIK_SFTP_PASSWORD,
                            'sftpDestination' => $new_file,
                            'sftpSourceFile' => $filename,
                        ], "Bascik");
                    }
                }
            }
        }
    }
}
?>
