<?php
if ( ! defined( 'BASEPATH' ) ) {
	exit( 'No direct script access allowed' );
}
if ( ! function_exists( 'getpartytyperole' ) ) {
	function getpartytyperole() {
		$result  = array();
		$ci      = &get_instance();
		$user_id = '1';
		if ( $user_id != "" ) {
			$qyery = $ci->db->query( "SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name" );
			if ( $qyery->num_rows() > 0 ) {
				foreach ( $qyery->result() as $res ) {
					$result[] = array( 'id' => $res->id, 'name' => $res->name );
				}
			}
		}

		return $result;
	}
}
if ( ! function_exists( "getVasMasterdata" ) ) {
	function getVasMasterdata() {
		$ci           = &get_instance();
		$result       = array();
		$company_code = $ci->session->userdata( 'company_code' );
		if ( $company_code == 'RUKN' ) {
			$sql = $ci->db->query( "SELECT vas_id FROM tb_vas_master WHERE company_code LIKE '" . $company_code . "' AND status ='1'" );
		} else {
			$sql = $ci->db->query( "SELECT vas_id FROM tb_vas_master WHERE company_code NOT LIKE '" . $company_code . "' AND status ='1'" );
		}
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$result[] = $res->vas_id;
			}
		}

		return $result;
	}
}
if ( ! function_exists( 'makeselectedordersasinvoice' ) ) {
	function makeselectedordersasinvoice( $info ) {
		$ci          = &get_instance();
		$ci->load->library('newjfrlogic_sgmy');
		$ci->load->library('ratemanagement');
		$ci->load->library('exchangerate');
		$ci->load->model( 'common' );
		/* SMTC-JFR-LOGIC */
		$company_code= "";
		$i           = 1;
		$rev_row_ids = $resx = array();
		if ( ! empty( $info ) ) {
			$order_ids = $info['order_ids'];
			$curtz     = $info['curtz'];
			$user_id   = $info['user_id'];
			if($user_id >0){
				$getcompany_code = $ci->common->gettblrowdata(array('id'=>$user_id),"company_code","tb_users",0,0);
				if(!empty($getcompany_code)){
					$company_code = $getcompany_code['company_code'];
				}
			}
			if($company_code == ""){
				$company_code = $ci->session->userdata("company_code");
			}
			if($company_code == "SGKN" || $company_code == "MYKN"){
				$resx = $ci->newjfrlogic_sgmy->makeselected_sgmyordersasinvoice($info);
			}else{
				if ( ! empty( $order_ids ) ) {
					foreach ( $order_ids as $ids ) {
						$order_details = $ci->common->gettblrowdata( array( "id" => $ids['ids'] ), "user_id,shift_id, trip_id, order_id", "tb_orders", 0, 0 );
						$bk_id         = $order_details['order_id'];
						$chktrip       = $order_details;
						$user_id       = $order_details['user_id'];
						if ( $order_details['shift_id'] != '' && $order_details['shift_id'] > 0 ) {
							if ( $order_details['trip_id'] != '' && $order_details['trip_id'] > 0 ) {
								$chkorder = $ci->common->gettbldata( array( 'order_id' => $ids['ids'], 'recipient_role !=' => 'Carrier','invoice_status'=>0,'status'=>1 ), "id,recipient_role,invoice_status,amount,currency,exchange_rate,foreign_currency", 'tb_reveneus', 0, 0 );
	//							'invoice_status' => '0',
								$revenue_ids = 0;
								$count_zeros = 0;
								if ( ! empty( $chkorder ) ) {
									$invoice_status = array_map( 'intval', array_column( $chkorder, 'invoice_status' ) );
	//								log_message( 'error', 'Error Message $invoice_status arr => ' . json_encode( $invoice_status, 128 ) );
									$count_zeros = @array_count_values( $invoice_status )['0'];
									if ( $count_zeros ) {
										foreach ( $chkorder as $res ) {
											if ( $res['invoice_status'] == 0 ) {
												if ( in_array( $res['recipient_role'], array( 'Customer', 'Internal BU', 'Overseas OL' ) ) ) {
													$rev_row_ids[] = $res['id'];
													$revenue_ids   = $res['id'];
													if ( $res['amount'] == '0.00' ) {
														$resx[] = array( 'id' => $bk_id, 'recipient_role' => $res['recipient_role'], 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'Revenue found with zero amount' );
													} else {
														if ( $revenue_ids != 0 ) {
															$foreign_currency = $res['foreign_currency'];
															$exchange_rate = $res['exchange_rate'];
															$user_currency = $res['currency'];
															$noexchange_rate =0;
															if($foreign_currency != ""){
																if($exchange_rate >0){
																}else{
																	$exchange_info = array('exchange_rate_id'=>'0','from_currency'=>$foreign_currency,'to_currency'=>$user_currency,'user_id'=>$user_id,'order_id'=>$ids['ids'],'revenue_id'=>$res['id']);
																	$exchange_rate_amount = $ci->ratemanagement->getexchnageamountfromcurrency($exchange_info);
																	if($exchange_rate_amount >0){
																		$upd = $ci->exchangerate->updatelocalamout_byexchangerate($revenue_ids,$exchange_rate_amount,$foreign_currency);
																		$upd_revenue = $ci->exchangerate->updatetotal_amountforrev($revenue_ids);
    																	$chck_limit = $ci->ratemanagement->updateutilizedamount_fororder($ids['ids']);
																	}else{
																		$noexchange_rate =1;
																		$resx[] = array( 'id' => $bk_id, 'recipient_role' => $res['recipient_role'], 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'Exchange Rate conversion is pending' );
																	}
																}
															}
															$cdate     = date( 'Y-m-d H:i:s' );
															$getactual = getdatetimebytimezone( DFLT_TZ, $cdate, $curtz );
															$cdate     = $getactual['datetime'];
															$debtor_jfr = "";
															if($noexchange_rate == '0'){
																$info         = array('user_id' => $user_id, 'revnue_id' => $revenue_ids, 'order_id' => $ids['ids'], 'trip_id' => $chktrip['trip_id'], 'sts_createdon' => $cdate );
																$debtor_jfr   = generatedebitro_jfrcode( $info );
															}
															if ( $debtor_jfr != "" && $debtor_jfr != '0' ) {
																$update    = date( 'Y-m-d H:i:s', strtotime( $cdate . "+{$i} second" ) );
																$i ++;
																$arr_up = array( 'debtor_jfr' => $debtor_jfr, 'invoice_status' => '1', 'debitor_time' => $update );
																$upd    = $ci->common->updatetbledata( "tb_reveneus", $arr_up, array( 'id' => $revenue_ids ) );
																if ( $upd ) {
																	$resx[] = array( 'id' => $bk_id, 'recipient_role' => $res['recipient_role'], 'status' => '<span class="text-success">SUCCESS</span>', 'JFR' => $debtor_jfr, 'error' => 'success', 'message' => 'JFR created successfully' );
																} else {
																	$resx[] = array( 'id' => $bk_id, 'recipient_role' => $res['recipient_role'], 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'unable to update' );
																}
															} else {
																if($noexchange_rate == "0"){
																	$resx[] = array( 'id' => $bk_id, 'recipient_role' => $res['recipient_role'], 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'JFR setup not available' );
																}
															}
														} else {
															$resx[] = array( 'id' => $bk_id, 'recipient_role' => $res['recipient_role'], 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'revenue_ids - 0' );
														}
													}
												} else {
	//										$resx[] = array( 'id' => $bk_id, 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'Recipient Role not found' );
												}
											}
										}
									} else {
										$resx[] = array( 'id' => $bk_id, 'recipient_role' => 'N/A', 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'Ready to Invoice already exists' );
									}
								} else {
									$resx[] = array( 'id' => $bk_id, 'recipient_role' => 'N/A', 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'Revenue not found' );
								}
							} else {
								$resx[] = array( 'id' => $bk_id, 'recipient_role' => 'N/A', 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'Driver not accepted' );
							}
						} else {
							$resx[] = array( 'id' => $bk_id, 'recipient_role' => 'N/A', 'status' => '<span class="text-danger">FAILED</span>', 'JFR' => 'N/A', 'error' => 'something went wrong', 'message' => 'Trip not found' );
						}
					}
				}
			}
			return $resx;
		}

	}
}
if ( ! function_exists( 'getOrderStatus' ) ) {
	function getOrderStatus() {
		$ci             = &get_instance();
		$order_status   = array();
		$getorderstatus = $ci->db->select( "name" )->order_by( 'id', 'ASC' )->get_where( "tb_statuses", array('status_type'=>'0',  'status' => '1' ) );
		if ( $getorderstatus->num_rows() > 0 ) {
			foreach ( $getorderstatus->result() as $res ) {
				$order_status[] = $res->name;
			}
		}

		return $order_status;
	}
}

if ( ! function_exists( 'getOrderStatus_ForReports' ) ) {
	function getOrderStatus_ForReports() {
		$ci             = &get_instance();
		$order_status   = array();
		$getorderstatus = $ci->db->select( "name" )->order_by( 'id', 'ASC' )->get_where( "tb_statuses", array('status_type'=>'1', 'status' => '1' ) );
		if ( $getorderstatus->num_rows() > 0 ) {
			foreach ( $getorderstatus->result() as $res ) {
				$order_status[] = $res->name;
			}
		}

		return $order_status;
	}
}

if ( ! function_exists( 'getcustomerdetailsbyid' ) ) {
	function getcustomerdetailsbyid( $id ) {
		$ci             = &get_instance();
		$pickup_details = array();
		$name           = $address = $pincode = $code = $country = "";
		if ( $id != 0 ) {
			$getpickupdetails = $ci->db->query( "SELECT name,address,pincode,code,country FROM tb_customers WHERE status='1' AND id='" . $id . "' LIMIT 1" );
			if ( $getpickupdetails->num_rows() > 0 ) {
				$name    = $getpickupdetails->row()->name;
				$address = $getpickupdetails->row()->address;
				$pincode = $getpickupdetails->row()->pincode;
				$code    = $getpickupdetails->row()->code;
				$country = $getpickupdetails->row()->country;
			}
			$pickup_details['name']    = $name;
			$pickup_details['address'] = $address;
			$pickup_details['pincode'] = $pincode;
			$pickup_details['code']    = $code;
			$pickup_details['country'] = $country;
		}

		return $pickup_details;
	}
}

if (!function_exists('getOrderTypes')) {

    function getOrderTypes($custid, $company_code) {
        $ci = &get_instance();
        $ordertypes = array();
        if ($custid != '0') {
            $getorders = $ci->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('customer_id' => $custid));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                }
            } else {
                $getorders = $ci->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, "status" => 1));
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                    }
                } else {
                    $getorders = $ci->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => "SGKN", "status" => 1));
                    if ($getorders->num_rows() > 0) {
                        foreach ($getorders->result() as $res) {
                            $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                        }
                    }
                }
            }
        } else {
            $branch_code = $ci->session->userdata('branch_code');
				$getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_order_types WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
				if ($getbranchdetail->num_rows() > 0) {
					$getorders = $ci->db->query("SELECT id,type_name FROM tb_order_types WHERE status ='1' AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))");
					if ($getorders->num_rows() > 0) {
						foreach ($getorders->result() as $res) {
							$ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
						}
					}
				}else{
					$getorders = $ci->db->query("SELECT id,type_name FROM tb_order_types WHERE status ='1' AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))");
					if ($getorders->num_rows() > 0) {
						foreach ($getorders->result() as $res) {
							$ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
						}
					}
				}

        }

        return $ordertypes;
    }

}
if ( ! function_exists( 'getCustomerIDs' ) ) {
	function getCustomerIDs( $user_id, $company_code, $branch_code ) {
		$ci  = &get_instance();
		$ids = array();
		$whr = "";
		
		$permission = checkuserpermissions();
		if(in_array("businesspartners", $permission)){
			$whr .= " AND company_code LIKE '" . $company_code . "' ";
		} else {
			if ( $user_id != "" ) {
				$whr .= " AND user_id ='" . $user_id . "' ";
			}else{
				$whr .= " AND company_code LIKE '" . $company_code . "' ";
			}
		}
		
		$qry = $ci->db->query( "SELECT code FROM tb_customers WHERE  status ='1' AND company_code != '' AND company_code IS NOT NULL AND code != '' AND code != '0' " . $whr . " AND status='1' GROUP BY id ORDER BY createdon DESC" );
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				$ids[] = $res->code;
			}
		}

		return $ids;
	}
}

    /**
     * This method get Carrier details
	 * @param int $user_id
     * @return    array
     * @last change: company code change for australia
     */
if ( ! function_exists( 'getListForTrip' ) ) {
	function getListForTrip( $userid ) {
		$ci           = &get_instance();
		$data         = array();
		$vendors      = array();
		$company_code = $ci->session->userdata( 'company_code' );
		$permission = checkuserpermissions();
		if(in_array("carrier", $permission)){
            $ci->db->select('code, company_code, user_id');
            $ci->db->from('tbl_party_master');
            $ci->db->where('status', 1);
			$ci->db->where_in('company_code', $company_code == "KNAU" ? ['AUKN', 'KNAU'] : [$company_code]);
			$partyMaster = $ci->db->group_by('code, company_code')->get_compiled_select();

            $ci->db->select('v.id, v.name, v.code');
            $ci->db->from('tb_vendors AS v');
            $ci->db->join('(' . $partyMaster . ') AS pm', 'pm.code=v.code AND pm.company_code=v.company_code', 'left');
            $ci->db->where('v.status', 1);
			$ci->db->where_in('v.company_code', $company_code == "KNAU" ? ['AUKN', 'KNAU'] : [$company_code]);
            if ($company_code == "TWKN") {
                $ci->db->where('v.user_id', $userid);
            }
            $ci->db->group_by('v.id');
            $ci->db->order_by('v.name', 'ASC');
		}else {
			$ci->db->select('code, company_code, user_id');
            $ci->db->from('tbl_party_master');
            $ci->db->where('status', 1);
            $ci->db->where('user_id', $userid);
            $partyMaster = $ci->db->group_by('code, user_id')->get_compiled_select();

            $ci->db->select('v.id, v.name, v.code');
            $ci->db->from('tb_vendors AS v');
            $ci->db->join('(' . $partyMaster . ') AS pm', 'pm.code=v.code AND pm.user_id=v.user_id', 'left');
            $ci->db->where('v.status', 1);
            $ci->db->where('v.user_id', $userid);
            $ci->db->group_by('v.id');
            $ci->db->order_by('v.name', 'ASC');

		}
		$vendor_list = $ci->db->get();
		if ( $vendor_list->num_rows() > 0 ) {
			foreach ( $vendor_list->result() as $res ) {
				$vendors[] = array( 'id' => $res->id, 'name' => $res->name, 'code' => $res->code );
			}
		}
        if (in_array("vehicletypes", $permission)) {
            if ($company_code == "KNAU") {
                $data['vehicletypes'] = $ci->db->select('id,trucktype')
				->where_in('company_code', array('AUKN', 'KNAU'))
				->get_where('tb_trucktypes', array('status' => 'Active'));
            } else {
                $data['vehicletypes'] = $ci->db->select('id,trucktype')->get_where('tb_trucktypes', array('status' => 'Active', 'company_code' => $company_code));
            }
        } else {
			$data['vehicletypes'] = $ci->db->select( 'id,trucktype' )->get_where( "tb_trucktypes", ['company_code' => $company_code, "status" => 'Active']);
		}
		$data['carrierlist'] = $vendors;
		return $data;
	}
}

if ( ! function_exists( 'getVendorIDs' ) ) {
	function getVendorIDs( $user_id, $company_code, $branch_code ) {
		$ci  = &get_instance();
		$ids = array();
		$whr = "";
		
		$permission = checkuserpermissions();
        if (in_array("carrier", $permission)) {
			$whr .= " AND company_code LIKE '" . $company_code . "' ";
		}
		else{
			if( $user_id != "" ) {
				$whr .= " AND user_id ='" . $user_id . "' ";
			}
		}
		
		$qry = $ci->db->query( "SELECT code FROM tb_vendors WHERE  status ='1' AND company_code != '' AND company_code IS NOT NULL AND code != '' AND code != '0' " . $whr . " AND status='1' GROUP BY id ORDER BY created_on DESC" );
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $res ) {
				$ids[] = $res->code;
			}
		}

		return $ids;
	}

}if ( ! function_exists( 'getAUVendorIDs' ) ) {
	function getAUVendorIDs( $company_code ) {
		$ci  = &get_instance();
		$res = array();

		$qry = $ci->db->query( "SELECT name FROM tb_vendors WHERE  status ='1' AND company_code LIKE '".$company_code."' AND code != '' AND code != '0'  GROUP BY id ORDER BY created_on DESC" );
		if ( $qry->num_rows() > 0 ) {
			foreach ( $qry->result() as $row ) {
				$res[] = $row->name;
			}
		}

		return $res;
	}
}
if ( ! function_exists( "getCompanyCodes" ) ) {
	function getCompanyCodes() {
		$ci        = &get_instance();
		$companies = array();
		$sql       = $ci->db->query( "SELECT company_code FROM tb_company_master WHERE status ='1'" );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$companies[] = $res->company_code;
			}
		}

		return $companies;
	}
}

if (!function_exists("gettransportmode")) {

    function gettransportmode($order_date='',$less_date='') {
        $ci = &get_instance();
        $transport = array();
        /*ALTER TABLE `tb_transportmode` ADD `company_code` VARCHAR(22) NULL DEFAULT NULL AFTER `user_id`;*/
        $company_code = $ci->session->userdata('company_code');
		$branch_code = $ci->session->userdata('branch_code');

		if($order_date!='' && $less_date!=''){
		 if($order_date<$less_date){
			if ( $company_code == 'RUKN' ) {
			$sql = $ci->db->query( "SELECT id,code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP') AND status ='1' AND (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)" );
			if ( $sql->num_rows() > 0 ) {
				foreach ( $sql->result() as $res ) {
					$transport[] = array( 'id' => $res->id, 'code' => $res->code, 'name' => $res->name );
				}
			}
		} else {
			$sql = $ci->db->query( "SELECT id,code,name FROM tb_transportmode WHERE status ='1' AND (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)" );
			if ( $sql->num_rows() > 0 ) {
				foreach ( $sql->result() as $res ) {
					$transport[] = array( 'id' => $res->id, 'code' => $res->code, 'name' => $res->name );
				}
			}
		}
		 }else{
			$getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_transportmode WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
		if ($getbranchdetail->num_rows() > 0) {
		$sql = $ci->db->query("SELECT id,code,name FROM tb_transportmode WHERE status ='1' AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))");
		}else{
		$sql = $ci->db->query("SELECT id,code,name FROM tb_transportmode WHERE status ='1' AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))");
		}

        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $transport[] = array('id' => $res->id, 'code' => $res->code, 'name' => $res->name);
            }
        }

		 }
		}else{
			$getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_transportmode WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
		if ($getbranchdetail->num_rows() > 0) {
		$sql = $ci->db->query("SELECT id,code,name FROM tb_transportmode WHERE status ='1' AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))");
		}else{
		$sql = $ci->db->query("SELECT id,code,name FROM tb_transportmode WHERE status ='1' AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))");
		}

        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $transport[] = array('id' => $res->id, 'code' => $res->code, 'name' => $res->name);
            }
        }

		}

  return $transport;

    }

    }
if ( ! function_exists( "getBranchCodes" ) ) {
	function getBranchCodes() {
		$ci       = &get_instance();
		$branches = $c_branch = array();
		$sql      = $ci->db->query( "SELECT company_code,branch_code FROM tb_branch_master WHERE status ='1'" );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$c_branch[] = array( 'ccode' => $res->company_code, 'bcode' => $res->branch_code );
				$branches[] = $res->branch_code;
			}
		}
		$result = array( 'branches' => $branches, 'c_branch' => $c_branch );

		return $result;
	}
}
if ( ! function_exists( "getDepartmentCode" ) ) {
	function getDepartmentCode() {
		$ci          = &get_instance();
		$departments = $cb_department = array();
		$sql         = $ci->db->query( "SELECT department_code,company_code,branch_code FROM tb_department_master WHERE status ='1'" );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$cb_department[] = array( 'ccode' => $res->company_code, 'bcode' => $res->branch_code, 'dcode' => $res->department_code );
				$departments[]   = $res->department_code;
			}
		}
		$result = array( 'cb_department' => $cb_department, 'departments' => $departments );

		return $result;
	}
}

if (!function_exists("getProductMasterData")) {

    function getProductMasterData($order_date='',$less_date='') {
        $ci = &get_instance();
        $products = array();
        $company_code = $ci->session->userdata('company_code');
		$branch_code = $ci->session->userdata('branch_code');
        $whr = "";

		if($order_date!='' && $less_date!=''){
		 if($order_date<$less_date){
			 if ( $company_code == 'RUKN' || $company_code == 'ZAKN' || $company_code == "VNKN" ) {
			$whr = " AND company_code LIKE '" . $company_code . "'";
		} else {
			$whr = " AND company_code = '" . $company_code . "' OR (company_code = '' OR company_code IS NULL ) ";
		}
		$sql = $ci->db->query( "SELECT id,name FROM tb_products_master WHERE status =1 " . $whr );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$products[] = array( 'name' => $res->name, 'id' => $res->id );
			}
		}

		 }else{
			$getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_products_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
			if ($getbranchdetail->num_rows() > 0) {
			$whr =" AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))";
			}else{
			$whr = " AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))";
			}
        $sql = $ci->db->query("SELECT id,name FROM tb_products_master WHERE status =1 " . $whr);
        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $products[] = array('name' => $res->name, 'id' => $res->id);
            }
        }

		 }
		}else{
			 $getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_products_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
			if ($getbranchdetail->num_rows() > 0) {
			$whr =" AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))";
			}else{
			$whr = " AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))";
			}
        $sql = $ci->db->query("SELECT id,name FROM tb_products_master WHERE status =1 " . $whr);
        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $products[] = array('name' => $res->name, 'id' => $res->id);
            }
        }

		}


        return $products;
    }

}
if ( ! function_exists( "getReferenceMasterData" ) ) {
	function getReferenceMasterData() {
		$ci        = &get_instance();
		$reference = array();
		$sql       = $ci->db->query( "SELECT name FROM tb_reference_master WHERE status =1 GROUP BY name" );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$reference[] = $res->name;
			}
		}

		return $reference;
	}
}

if (!function_exists("getIncotermMasterData")) {

    function getIncotermMasterData($order_date='',$less_date='') {
        $ci = &get_instance();
        $terms = array();
        $company_code = $ci->session->userdata('company_code');
		$branch_code = $ci->session->userdata('branch_code');
		if($order_date!='' && $less_date!=''){
		 if($order_date<$less_date){
             if (checkAccessConditions('RELATED_2_PL_RU_VN', $company_code)) {
			$sql = $ci->db->query( "SELECT name FROM tb_incoterms_master WHERE company_code LIKE '" . $company_code . "' AND status ='1'" );
		} else {
			$sql = $ci->db->query( "SELECT name FROM tb_incoterms_master WHERE (company_code ='' OR company_code IS NULL) AND status ='1'" );
		}
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$terms[] = $res->name;
			}
		}

		 }else{
			$getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_incoterms_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
		if ($getbranchdetail->num_rows() > 0) {
		$sql = $ci->db->query("SELECT name FROM tb_incoterms_master WHERE ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))) AND status=1");
		}else{
		$sql = $ci->db->query("SELECT name FROM tb_incoterms_master WHERE (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)) AND status=1");
		}

        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $terms[] = $res->name;
            }
        }

		 }
		}else{
			 $getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_incoterms_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
		if ($getbranchdetail->num_rows() > 0) {
		$sql = $ci->db->query("SELECT name FROM tb_incoterms_master WHERE ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))) AND status=1");
		}else{
		$sql = $ci->db->query("SELECT name FROM tb_incoterms_master WHERE (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)) AND status=1");
		}

        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $terms[] = $res->name;
            }
        }

		}


        return $terms;
    }

}
if ( ! function_exists( "getDeliverytermsbyIncoterm" ) ) {
	function getDeliverytermsbyIncoterm( $incoterm ) {
		$ci           = &get_instance();
		$terms        = array();
		$company_code = $ci->session->userdata( 'company_code' );
		if ( $company_code == 'RUKN' ) {
			$getval = $ci->db->query( "SELECT term_id,name,incoterm FROM tb_delivery_terms WHERE term_id IN ('10','12','82') ORDER BY createdon" );
			if ( $getval->num_rows() > 0 ) {
				foreach ( $getval->result() as $res ) {
					$terms[] = array( 'id' => $res->term_id, 'name' => $res->name, 'incoterm' => $res->incoterm );
				}
			}
		} else {
			if ( $incoterm != "" ) {
				$getval = $ci->db->query( "SELECT term_id,name,incoterm FROM tb_delivery_terms WHERE incoterm ='" . $incoterm . "' ORDER BY createdon DESC" );
				if ( $getval->num_rows() > 0 ) {
					foreach ( $getval->result() as $res ) {
						$terms[] = array( 'id' => $res->term_id, 'name' => $res->name, 'incoterm' => $res->incoterm );
					}
				}
			}
		}

		return $terms;
	}
}

if (!function_exists("getServiceMasterData")) {

    function getServiceMasterData($order_date='',$less_date='') {
        $ci = &get_instance();
        $service = array();
        $company_code = $ci->session->userdata('company_code');
        $branch_code = $ci->session->userdata('branch_code');

		if($order_date!='' && $less_date!=''){
		 if($order_date<$less_date){
			$whr          = "";
		if ( $company_code == 'RUKN' || $company_code == "VNKN" ) {
			$whr = " AND company_code LIKE '" . $company_code . "'";
		} else {
			$whr = " AND company_code = '" . $company_code . "' OR (company_code = '' OR company_code IS NULL ) ";
		}
		$sql = $ci->db->query( "SELECT id,service_id,name FROM tb_service_master WHERE status ='1' " . $whr );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$service[] = array( 'row_id' => $res->id, 'id' => $res->service_id, 'name' => $res->name );
			}
		}

		 }else{
			 $getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_service_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
		if ($getbranchdetail->num_rows() > 0) {
		$sql = $ci->db->query("SELECT id,service_id,name FROM tb_service_master WHERE status ='1' AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))");
		   if ($sql->num_rows() > 0) {
		foreach ($sql->result() as $res) {
			$service[] = array('row_id' => $res->id, 'id' => $res->service_id, 'name' => $res->name);
		}
		}
		}else{
		$sql = $ci->db->query("SELECT id,service_id,name FROM tb_service_master WHERE status ='1' AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))");
		  if ($sql->num_rows() > 0) {
		foreach ($sql->result() as $res) {
			$service[] = array('row_id' => $res->id, 'id' => $res->service_id, 'name' => $res->name);
		}
		}

		}


		 }
		}else{
			  $getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_service_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
		if ($getbranchdetail->num_rows() > 0) {
		$sql = $ci->db->query("SELECT id,service_id,name FROM tb_service_master WHERE status ='1' AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))");
		   if ($sql->num_rows() > 0) {
		foreach ($sql->result() as $res) {
			$service[] = array('row_id' => $res->id, 'id' => $res->service_id, 'name' => $res->name);
		}
		}
		}else{
		$sql = $ci->db->query("SELECT id,service_id,name FROM tb_service_master WHERE status ='1' AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))");
		  if ($sql->num_rows() > 0) {
		foreach ($sql->result() as $res) {
			$service[] = array('row_id' => $res->id, 'id' => $res->service_id, 'name' => $res->name);
		}
		}

		}

		}



     return $service;
}
}

if (!function_exists("getVehicletypeMasterData")) {
    function getVehicletypeMasterData() {
        $ci = &get_instance();
        $vehicleType_master = array();
        $company_code = $ci->session->userdata('company_code');
		$branch_code = $ci->session->userdata('branch_code');
		if($company_code == "KNAU"){
			$sql = $ci->db->select('id,trucktype')
			->where_in('company_code', array('AUKN', 'KNAU'))->get_where('tb_trucktypes', array('status' => 'Active'));
		}else {
			if (checkAccessConditions('COMPANY_CODE_WISE_GROUP_MASTERS', $company_code)) {
				$sql = $ci->db->query("SELECT id,trucktype FROM tb_trucktypes WHERE (company_code = ? OR (company_code = '' OR company_code IS NULL)) AND status = ? ", [$company_code , 'Active']);
			} else {
				$getbranchdetail = $ci->db->query("SELECT branch_code
				FROM tb_trucktypes
				WHERE company_code = ? AND branch_code = ? AND status = ? ", array($company_code , $branch_code , 'Active'));
				if ($getbranchdetail->num_rows() > 0) {
					$sql = $ci->db->query("SELECT id,trucktype
					FROM tb_trucktypes
					WHERE ((company_code = ? AND (branch_code = ?
					OR (branch_code = '' OR branch_code IS NULL))) OR ((company_code = '' OR company_code IS NULL)
					AND (branch_code = '' OR branch_code IS NULL))) AND status = ? ", array($company_code , $branch_code , 'Active' ));
				}else{
					$sql = $ci->db->query("SELECT id,trucktype
					FROM tb_trucktypes
					WHERE (company_code = ? OR (company_code = '' OR company_code IS NULL)
					AND (branch_code = '' OR branch_code IS NULL)) AND status = ? ", array($company_code , 'Active'));
				}
			}
		}
        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $vehicleType_master[] = array('trucktype' => $res->trucktype, 'id' => $res->id);
            }
        }
        return $vehicleType_master;
    }
}
if ( ! function_exists( "getpurchaseorderfororders" ) ) {
	function getpurchaseorderfororders() {
		$ci             = &get_instance();
		$purchase_order = array();
		$sql            = $ci->db->query( "SELECT purchase_order FROM tb_order_details WHERE status ='1'" );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$purchase_order[] = $res->purchase_order;
			}
		}

		return $purchase_order;
	}
}
if ( ! function_exists( "getDeliverynotesforOrders" ) ) {
	function getDeliverynotesforOrders( $user_id ) {
		$ci     = &get_instance();
		$dnotes = array();
		$sql    = $ci->db->query( "SELECT r.ref_value FROM tb_order_references r,tb_orders o WHERE r.reference_id  LIKE 'DQ' AND r.order_id=o.id AND r.status='1' AND o.status !='0' AND o.user_id='" . $user_id . "' " );
		if ( $sql->num_rows() > 0 ) {
			foreach ( $sql->result() as $res ) {
				$dnotes[] = $res->ref_value;
			}
		}

		return $dnotes;
	}
}

if (!function_exists("getorderreftypeinfo")) {
	function getorderreftypeinfo($type,$order_id) {
		$ci = &get_instance();
		$refs = "";
		$sql = $ci->db->query("SELECT r.ref_value FROM tb_order_references r WHERE r.reference_id  LIKE '".$type."' AND r.order_id= '".$order_id."' AND r.status='1' ");
		if($sql->num_rows() >0){
			$refs = $sql->row()->ref_value;

		}
		return $refs;
	}
}


/* check geocodes for route automation */
if ( ! function_exists( 'checkgeocode' ) ) {
	function checkgeocode( $location ) {
		$res = array();
		$ci  = &get_instance();
		$ci->load->model( 'common' );
		if ( strtolower( $location['country'] ) == "russia" ) {
			$location['country'] = "RU";
		}
		if ( $location['country'] == "РОССИЯ" || $location['country'] == "Россия" ) {
			$location['country'] = "RU";
		}
		if ( strtolower( $location['country'] ) == 'australia' || strtoupper( $location['country'] ) == 'AU' ) {
			$location['country'] = 'AU';
		}
		$tbl     = "tb_kn_geocodes";
		$whr     = array( "country" => $location['country'], "postal_code" => $location['zipcode'], "status" => 1 );
		$select  = "postal_code,district,city,province,country,region";
		$chkdata = $ci->common->gettblrowdata( $whr, $select, $tbl, 0, 0 );
		if ( count( $chkdata ) > 0 ) {
			$res = array( "country" => $chkdata['country'], "state" => $chkdata['province'], "city" => $chkdata['city'], "region" => $chkdata['region'], "zipcode" => $chkdata['postal_code'] );
		} else {
			$whr1         = array( "country" => $location['country'], "city" => $location['city'], "status" => 1 );
			$chkdata_city = $ci->common->gettblrowdata( $whr1, $select, $tbl, 0, 0 );
			if ( ! empty( $chkdata_city ) ) {
				$res = array( "country" => $chkdata_city['country'], "state" => $chkdata_city['province'], "city" => $chkdata_city['city'], "region" => $chkdata_city['region'], "zipcode" => $chkdata_city['postal_code'] );
			}
		}

		return $res;
	}
}

/* check route automation for customer order location */
if ( ! function_exists( 'getcust_routeautomate' ) ) {
	function getcust_routeautomate($usr, $location) {


        $ci = &get_instance();
        $ci->load->model('common');
        $orderidd = 0;
        $weight = 0;
        $second_weight = 0;
        $volume = 0;
        $second_volume = 0;

        if (isset($location['cargo']) && is_countable($location['cargo']) && count($location['cargo']) != 0) {
            $orderidd = $location['cargo']['order_id'];
        }

        $table = "tb_order_cargodetails";
        $whrr = array("order_id" => $orderidd, "status" => 1);
        $selectt = "id, order_id, cargo_id, handling_unit, length, width, height, weight, second_weight, volumetric_weight, volweight_uom, ldm, volume, second_volume, quantity, scanned_quantity, quantity_type, cargo_content";
        $cargoinfo = $ci->common->gettbldata($whrr, $selectt, $table, 0, 0);
        if (count($cargoinfo) > 0) {
            foreach ($cargoinfo as $row) {

                $weight += $row['weight'];
                $second_weight += $row['second_weight'];
                $volume += $row['volume'];
                $second_volume += $row['second_volume'];
            }
        }

        $carfo_details = array("weight" => $weight, "second_weight" => $second_weight, "volume" => $volume, "second_volume" => $second_volume);

        $res = array();
        //496
        $ship_identifier=$cons_identifier=$notify_identifier="";

        $tbl = "tb_routing_auto";
        $stoptype = $location['stoptype'];
        $whr = ["cust_id" => $usr, "triggered_type" => "2", "status" => 1];

        //496
        $salogFlag = $location['salogFlag'] ?? 0;
        if ($salogFlag > 0) {
            $brnReference = $location['brnReference'] ?? "";
            if ($brnReference != "") {
                $whr['brn_Reference'] =$brnReference;
            }
        }
        /* added constraints colum nammes to fetchh data */
        $select = "pick_type,pick_val,deli_type,deli_val,ship_identifier,cons_identifier,notify_identifier,carrier_id,vehicle_type,vehicle_id,driver_id,template_id,min_weight,max_weight,min_volume,max_volume,min_weight_uom,max_weight_uom,min_volume_uom,max_volume_uom,min_weight_ac,
		max_weight_ac,min_weight_uom_ac,max_weight_uom_ac,min_volume_ac,max_volume_ac,min_volume_uom_ac,max_volume_uom_ac";

        $constraints = "no";


        $chkdirect = $ci->common->gettbldata($whr, $select, $tbl, 0, 0);
        if (count($chkdirect) > 0) {
            foreach ($chkdirect as $rw) {

                $ship_identifier = $rw['ship_identifier'];
                $cons_identifier = $rw['cons_identifier'];
                $notify_identifier = $rw['notify_identifier'];




                if ($rw['min_weight'] == "0.00" && $rw['max_weight'] == "0.00" && $rw['min_weight_ac'] == "0.00" && $rw['max_weight_ac'] == "0.00" && $rw['min_volume'] == "0.00" && $rw['max_volume'] == "0.00" && $rw['min_volume_ac'] == "0.00" && $rw['max_volume_ac'] == "0.00") {
                    $constraints = "yes"; // no constraints avilable
                } else {
                    $constraints = "no";
                }


                if ($stoptype == "P") {
                    $loc_type = 'pick_type';
                    $loc_val = 'pick_val';
                } else {
                    $loc_type = 'deli_type';
                    $loc_val = 'deli_val';
                }

                if ($rw[$loc_type] == "Country") {


                    if (( $location['country'] != "" ) && ( strtoupper($location['country']) == strtoupper($rw[$loc_val]) )) {


                        $checkauto = checkcargofir_autorout($carfo_details, $rw);

                        if ($checkauto == "yes") {
                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            /* 	break; */
                        } else {
                            if ($constraints == "yes") {
                                $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            }
                        }
                    }
                    if (empty($res)) {
                        if (isset($location['order_country'])) {


                            if (( $location['order_country'] != "" ) && ( strtoupper($location['order_country']) == strtoupper($rw[$loc_val]) )) {
                                $checkauto = checkcargofir_autorout($carfo_details, $rw);
                                if ($checkauto == "yes") {
                                    $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                    /* 	break; */
                                } else {
                                    if ($constraints == "yes") {
                                        $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                    }
                                }//else
                            }
                        }
                    }
                } else if ($rw[$loc_type] == "State") {

                    if (( $location['state'] != "" ) && ( strtoupper($location['state']) == strtoupper($rw[$loc_val]) )) {

                        $checkauto = checkcargofir_autorout($carfo_details, $rw);
                        if ($checkauto == "yes") {
                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                        } else {
                            if ($constraints == "yes") {
                                $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            }
                        }
                        break;
                    }
                } else if ($rw[$loc_type] == "City") {


                    if (( $location['city'] != "" ) && ( strtoupper($location['city']) == strtoupper($rw[$loc_val]) )) {

                        $checkauto = checkcargofir_autorout($carfo_details, $rw);

                        if ($checkauto == "yes") {
                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                        } else {
                            if ($constraints == "yes") {
                                $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            }
                        }
                    }
                } else if ($rw[$loc_type] == "Zipcode") {

                    if (( $location['zipcode'] != "" ) && ( strtoupper($location['zipcode']) == strtoupper($rw[$loc_val]) )) {


                        $checkauto = checkcargofir_autorout($carfo_details, $rw);
                        if ($checkauto == "yes") {
                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                        } else {
                            if ($constraints == "yes") {
                                $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            }
                        }
                        break;
                    }
                } else if ($rw[$loc_type] == "Location ID") {

                    $x = 0;
                    if (( $location['region'] != "" ) && ( strtoupper($location['region']) == strtoupper($rw[$loc_val]) )) {

                        $checkauto = checkcargofir_autorout($carfo_details, $rw);
                        if ($checkauto == "yes") {
                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            $x = 1;
                        } else {
                            if ($constraints == "yes") {
                                $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                $x = 1;
                            }
                        }
                    }
                    if ($x == 0) {
                        if (isset($location['order_city'])) {


                            $getregion_city = $ci->db->select("id")->get_where("tb_kn_geocodes", array('city' => $location['order_city'], 'region' => strtoupper($rw[$loc_val]), 'status' => '1'));
                            if ($getregion_city->num_rows() > 0) {
                                $checkauto = checkcargofir_autorout($carfo_details, $rw);
                                if ($checkauto == "yes") {
                                    $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];

                                    $x = 1;
                                } else {

                                    if ($constraints == "yes") {
                                        $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                        $x = 1;
                                    }
                                }
                            }
                        }
                        if ($x == 0) {
                            if (isset($location['order_zipcode'])) {

                                $getregion_zipcode = $ci->db->select("id")->get_where("tb_kn_geocodes", array('postal_code' => $location['order_zipcode'], 'region' => strtoupper($rw[$loc_val]), 'status' => '1'));
                                if ($getregion_zipcode->num_rows() > 0) {
                                    $checkauto = checkcargofir_autorout($carfo_details, $rw);
                                    if ($checkauto == "yes") {
                                        $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                        $x = 1;
                                    } else {
                                        if ($constraints == "yes") {
                                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                            $x = 1;
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if ($rw[$loc_type] == "Region") {

                    $x = 0;
                    if (( $location['region'] != "" ) && ( strtoupper($location['region']) == strtoupper($rw[$loc_val]) )) {

                        $checkauto = checkcargofir_autorout($carfo_details, $rw);
                        if ($checkauto == "yes") {
                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            $x = 1;
                        } else {
                            if ($constraints == "yes") {
                                $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                $x = 1;
                            }
                        }
                    }
                    if (( $location['region'] != "" ) && ( $location['region'] == $rw[$loc_val] )) {

                        $checkauto = checkcargofir_autorout($carfo_details, $rw);
                        if ($checkauto == "yes") {
                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                            $x = 1;
                        } else {
                            if ($constraints == "yes") {
                                $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                $x = 1;
                            }
                        }
                    }
                    if ($x == 0) {
                        if (isset($location['order_city'])) {
                            $getregion_city = $ci->db->select("id")->get_where("tb_kn_geocodes", array('city' => $location['order_city'], 'region' => strtoupper($rw[$loc_val]), 'status' => '1'));
                            if ($getregion_city->num_rows() > 0) {

                                $checkauto = checkcargofir_autorout($carfo_details, $rw);
                                if ($checkauto == "yes") {
                                    $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                    $x = 1;
                                } else {
                                    if ($constraints == "yes") {
                                        $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                        $x = 1;
                                    }
                                }
                            }
                        }

                        if ($x == 0) {
                            if (isset($location['order_zipcode'])) {
                                $getregion_zipcode = $ci->db->select("id")->get_where("tb_kn_geocodes", array('postal_code' => $location['order_zipcode'], 'region' => strtoupper($rw[$loc_val]), 'status' => '1'));
                                if ($getregion_zipcode->num_rows() > 0) {
                                    $checkauto = checkcargofir_autorout($carfo_details, $rw);
                                    if ($checkauto == "yes") {
                                        $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                        $x = 1;
                                    } else {
                                        if ($constraints == "yes") {
                                            $res = ["carrier_id" => $rw['carrier_id'], "vehicle_type" => $rw['vehicle_type'], "vehicle_id" => $rw['vehicle_id'], "driver_id" => $rw['driver_id'], 'template_id' => $rw['template_id']];
                                            $x = 1;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (array_filter([$ship_identifier, $cons_identifier, $notify_identifier])) {
                if (!checkIdentifire($location, $ship_identifier, $cons_identifier, $notify_identifier)) {
                    return [];
                }
            }
        }
        return $res;
    }
}

if (!function_exists('checkIdentifire')) {

    function checkIdentifire(array $orderDetails, string $shiperIdentifier, string $consineeIdentifier, string $notifyIdentifier): bool
    {
        $ci = &get_instance();
        $ci->load->model('routingauto');

        $ci->db->select(
            'tb_order_parties.id, tb_order_parties.order_id, tb_order_parties.party_id, tb_order_parties.party_type,tbl_party_types.name,tbl_party_master.code'
        );
        $ci->db->from('tb_order_parties');
        $ci->db->join('tbl_party_types', 'tb_order_parties.party_type = tbl_party_types.id');
        $ci->db->join('tbl_party_master', 'tbl_party_master.id = tb_order_parties.party_id');
        $ci->db->where(
            ['tb_order_parties.order_id' => $orderDetails['cargo']['order_id'], 'tb_order_parties.status' => 1]
        );
        $query = $ci->db->get();

        if (!count($query->result())) {
            return false;
        }
        $shipperCode = $consigneeCode = $notifyCode = "";
        foreach ($query->result() as $row) {
            switch ($row->name) {
                case "Customer":
                    $customerCode = $row->code;
                    break;
                case "Shipper":
                    $shipperCode = $row->code;
                    break;
                case "Consignee":
                    $consigneeCode = $row->code;
                    break;
                case "NOTIFY_PARTY":
                    $notifyCode = $row->code;
                    break;
                default:
                    log_message("error","Auto routing: Unable to find party.");
                    break;
            }
        }

        if ($shiperIdentifier && $consineeIdentifier && $notifyIdentifier) {
            if ($shiperIdentifier === $shipperCode && $consineeIdentifier === $consigneeCode && $notifyIdentifier === $notifyCode) {
                return true;
            }
        }

        if ($shiperIdentifier && $consineeIdentifier && empty($notifyIdentifier)) {
            if ($shiperIdentifier === $shipperCode && $consineeIdentifier === $consigneeCode) {
                return true;
            }
        }

        if ($shiperIdentifier && empty($consineeIdentifier) && empty($notifyIdentifier)) {
            if ($shiperIdentifier === $shipperCode) {
                return true;
            }
        }
        if (empty($shiperIdentifier) && $consineeIdentifier && $notifyIdentifier) {
            if ($consineeIdentifier === $consigneeCode && $notifyIdentifier === $notifyCode) {
                return true;
            }
        }
        if (empty($shiperIdentifier) && empty($consineeIdentifier) && $notifyIdentifier) {
            if ($notifyIdentifier === $notifyCode) {
                return true;
            }
        }
        if (empty($shiperIdentifier) && $consineeIdentifier && empty($notifyIdentifier)) {
            if ($consineeIdentifier === $consigneeCode) {
                return true;
            }
        }

        if ($shiperIdentifier && empty($consineeIdentifier) && $notifyIdentifier) {
            if ($shiperIdentifier === $shipperCode && $notifyIdentifier === $notifyCode) {
                return true;
            }
        }

        return false;
    }
}


/**
 * checkcargofir_autorout
 *
 * validati to cargo details and routing details
 *
 * @param   array $data order details
 * @param  array $rw  touting details
 * @return string
 */
if (!function_exists('checkcargofir_autorout')) {

    function checkcargofir_autorout($data, $rw) {

        // print_r($data);
        //  echo "<br>"; echo "<br>";
        // 	 echo $rw['min_weight']."-".$rw['max_weight']."===".$data['second_weight'];
        // 	 echo "<br>";
        // 	 echo $rw['min_weight_ac']."-".$rw['max_weight_ac']."===".$data['weight'];
        // 	 echo "<br>";
        // 	 echo $rw['min_volume']."-".$rw['max_volume']."===".$data['second_volume'];
        // 	 echo "<br>";
        // 	 echo $rw['min_volume_ac']."-".$rw['max_volume_ac']."===".$data['volume'];
        // 	 echo "<br>";





        $minweight = $rw['min_weight'];
        $maxwaight = $rw['max_weight'];

        $min_weight_ac = $rw['min_weight_ac'];
        $max_weight_ac = $rw['max_weight_ac'];

        $min_volume = $rw['min_volume'];
        $max_volume = $rw['max_volume'];

        $min_volume_ac = $rw['min_volume_ac'];
        $max_volume_ac = $rw['max_volume_ac'];



        $weightc = checkwwhite($data, $rw);
        $weightc_ac = checkwwhite_ac($data, $rw);
        $volumec = checkvolume($data, $rw);
        $volumec_ac = checkvolume_sc($data, $rw);


        //&& $weightc == "no"

        if ($weightc == "yes" && $weightc_ac == "yes" && $volumec == "yes" && $volumec_ac == "yes") {

            return "yes";
        }



        if ($volumec_ac == "yes" && $volumec == "yes" && $weightc_ac == "yes" && $weightc != "false") {

            return "yes";
        }


        if ($volumec_ac == "yes" && $volumec == "yes" && $weightc == "yes" && $weightc_ac != "false") {

            return "yes";
        }



        if ($volumec_ac == "yes" && $volumec == "yes" && $weightc != "false" && $weightc_ac != "false") {

            return "yes";
        }


        if ($volumec_ac == "yes" && $weightc_ac == "yes" && $weightc == "yes" && $volumec != "false") {

            return "yes";
        }

        if ($volumec_ac == "yes" && $weightc_ac == "yes" && $volumec != "false" && $weightc != "false") {

            return "yes";
        }

        if ($volumec_ac == "yes" && $weightc == "yes" && $weightc_ac != "false" && $volumec != "false") {

            return "yes";
        }


        if ($volumec_ac == "yes" && $weightc != "false" && $weightc_ac != "false" && $volumec != "false") {

            return "yes";
        }



        if ($volumec == "yes" && $weightc_ac == "yes" && $weightc == "yes" && $volumec_ac != "false") {

            return "yes";
        }

        if ($volumec == "yes" && $weightc_ac == "yes" && $volumec_ac != "false" && $weightc != "false") {

            return "yes";
        }

        if ($volumec == "yes" && $weightc == "yes" && $weightc_ac != "false" && $volumec_ac != "false") {

            return "yes";
        }
        if ($volumec == "yes" && $weightc != "false" && $weightc_ac != "false" && $volumec_ac != "false") {

            return "yes";
        }




        if ($weightc_ac == "yes" && $weightc == "yes" && $volumec != "false" && $volumec_ac != "false") {

            return "yes";
        }
        if ($weightc_ac == "yes" && $weightc != "false" && $volumec != "false" && $volumec_ac != "false") {

            return "yes";
        }
        if ($weightc == "yes" && $weightc_ac != "false" && $volumec != "false" && $volumec_ac != "false") {

            return "yes";
        }
    }

}



/**
 * checkwwhite
 *
 * check weight matching or not
 *
 * @param   array $data order details
 * @param  array $rw  touting details
 * @return string
 */
if (!function_exists('checkwwhite')) {

    function checkwwhite($data, $rw) {


        if ($rw['min_weight'] >= 0 && $rw['max_weight'] >= 0) {

            if (($data['second_weight'] >= $rw['min_weight'] && $data['second_weight'] <= $rw['max_weight'])) {

                return "yes";
            } else {
                return "false";
            }
        } else {
            return "no";
        }
    }

}



/**
 * checkwwhite_ac
 *
 * check actaul weight matching or not
 *
 * @param   array $data order details
 * @param  array $rw  touting details
 * @return string
 */
if (!function_exists('checkwwhite_ac')) {

    function checkwwhite_ac($data, $rw) {



        if ($rw['min_weight_ac'] >= 0 && $rw['max_weight_ac'] >= 0) {

            if (($data['weight'] >= $rw['min_weight_ac'] && $data['weight'] <= $rw['max_weight_ac'])) {

                return "yes";
            } else {
                return "false";
            }
        } else {
            return "no";
        }
    }

}



/**
 * checkvolume
 *
 * check   volume matching or not
 *
 * @param   array $data order details
 * @param  array $rw  touting details
 * @return string
 */
if (!function_exists('checkvolume')) {

    function checkvolume($data, $rw) {

        if ($rw['min_volume'] >= 0 && $rw['max_volume'] >= 0) {

            if (($data['second_volume'] >= $rw['min_volume'] && $data['second_volume'] <= $rw['max_volume'])) {

                return "yes";
            } else {

                return "false";
            }
        } else {
            return "no";
        }
    }

}




/**
 * checkvolume_sc
 *
 * check actaul volume matching or not
 *
 * @param   array $data order details
 * @param  array $rw  touting details
 * @return string
 */
if (!function_exists('checkvolume_sc')) {

    function checkvolume_sc($data, $rw) {



        if ($rw['min_volume_ac'] >= 0 && $rw['max_volume_ac'] >= 0) {

            if (($data['volume'] >= $rw['min_volume_ac'] && $data['volume'] <= $rw['max_volume_ac'])) {

                return "yes";
            } else {

                return "false";
            }
        } else {
            return "no";
        }
    }

}



if ( ! function_exists( 'autoaccepttrip' ) ) {
	function autoaccepttrip( $data ) {
		$ci                 = &get_instance();
		$ord_id             = $data['ord_id'];
		$stsid              = 10;
		$arr['vehicle_id']  = $data['vehicle_id'];
		$arr['driver_id']   = $data['driver_id'];
		$arr['ship']        = $data['ship'];
		$arr['contact_num'] = "";
		$lgusrid            = $ci->session->userdata( "user_id" );
		$curtz              = $ci->session->userdata( "usr_tzone" )['timezone'];
		$logdate            = date( 'Y-m-d H:i:s' );
		$getactual          = getdatetimebytimezone( DFLT_TZ, $logdate, $curtz );
		$curdt              = $getactual['datetime'];
		$plat               = $data['plat'];
		$plng               = $data['plng'];
		if ( $arr['driver_id'] == "" ) {
			$getdriverid = $ci->db->select( "driver_id" )->get_where( "tbl_assigned_drivers", array( 'vehicle_id' => $arr['vehicle_id'], 'status' => 1 ), 1, 0 );
			if ( $getdriverid->num_rows() > 0 ) {
				$arr['driver_id'] = $getdriverid->row()->driver_id;
			}
		}
		if ( $plat == "" || $plng == "" ) {
			$chklatlng = $ci->db->select( "latitude,longitude" )->get_where( "tb_site_settings", array( "user_id" => $lgusrid ), 1, 0 );
			if ( $chklatlng->num_rows() > 0 ) {
				$plat = $chklatlng->row()->latitude;
				$plng = $chklatlng->row()->longitude;
			}
		}
		$stcode = "0212";
		if ( $arr['contact_num'] == "" ) {
			$newimei = $ci->db->select( "imei" )->get_where( "tbl_assigned_drivers", array( 'vehicle_id' => $arr['vehicle_id'], 'driver_id' => $arr['driver_id'], 'status' => 1 ), 1, 0 );
			if ( $newimei->num_rows() > 0 ) {
				$arr['contact_num'] = $newimei->row()->imei;
			}
		}
		$latitude  = $plat;
		$longitude = $plng;
		$whr_trip  = array( 'shift_id' => $arr['ship'], 'status' => 1 );
		$chk_trip  = $ci->db->select( "id" )->get_where( "tb_trips", $whr_trip, 1, 0 );
		if ( $chk_trip->num_rows() > 0 ) {
			$arr['trip'] = $chk_trip->row()->id;
		} else {
			$triparr     = array(
				'shift_id'       => $arr['ship'],
				'vehicle_id'     => $arr['vehicle_id'],
				'driver_id'      => $arr['driver_id'],
				'stime'          => $curdt,
				'start_imei'     => $arr['contact_num'],
				'splace'         => "",
				'eplace'         => "",
				'start_reading'  => 0,
				'end_reading'    => 0,
				'created_on'     => $curdt,
				'updated_on'     => $curdt,
				'status'         => 1,
				'trip_type'      => 0,
				'transit_status' => 0,
				"plat"           => $latitude,
				"plng"           => $longitude
			);
			$arr['trip'] = $ci->common->insertTableData( 'tb_trips', $triparr );
		}
		$insarry = array(
			"shipment_id"    => $arr['ship'],
			"stop_id"        => 0,
			"stop_detail_id" => 0,
			"stop_type"      => "",
			"trip_id"        => $arr['trip'],
			"status_id"      => $stsid,
			"latitude"       => $latitude,
			"longitude"      => $longitude,
			"status"         => 1,
			"reason"         => "From Admin",
			"vehicle_id"     => $arr['vehicle_id'],
			"driver_id"      => $arr['driver_id'],
			"status_code"    => $stcode,
			"createdon"      => $curdt
		);
		$ins     = $ci->db->insert( "tb_stop_status", $insarry );
		$ordwhr  = array( "shift_id" => $arr['ship'] );
		$ordset  = array( "trip_id" => $arr['trip'] );
		$upd     = $ci->db->set( $ordset )->where( $ordwhr )->update( "tb_orders" );
	}
}

if ( ! function_exists( 'makeorderinvolvedpartiestype' ) ) {
	function makeorderinvolvedpartiestype( $cid, $order_id, $type, $userId, $companyCode ) {
        $ci = &get_instance();
        $code = $party_name = "";
        $cdate = date('Y-m-d H:i:s');
        $user_id = $ci->session->userdata('user_id');
        $company_code = $ci->session->userdata('company_code');
        if($user_id == "")
        {
            $user_id = $userId;
        }
        if($company_code == "")
        {
            $company_code = $companyCode;
        }
        $ci->load->model('common');
        $permission = checkuserpermissions();
        if (strtoupper($type) == 'CARRIER') {
            $getmaster = $ci->common->gettblrowdata(['id' => $cid, 'status' => '1'], "code", "tb_vendors", 0, 0);
            if (!empty($getmaster)) {
                $code = $getmaster['code'];
            }
        } elseif (strtoupper($type) == 'CUSTOMER') {
            $getmaster = $ci->common->gettblrowdata(['id' => $cid, 'status' => '1'], "code", "tb_customers", 0, 0);
            if (!empty($getmaster)) {
                $code = $getmaster['code'];
            }
        }
		if ( $code != "" && $code != "0" ) {
            if (in_array("businesspartners", $permission)) {
                $getpartymaster = $ci->common->gettblrowdata(['code' => $code, 'company_code' => $company_code, 'status' => '1'], "id,party_type_id,party_types", "tbl_party_master", 0, 0);
            } else {
                $getpartymaster = $ci->common->gettblrowdata(['user_id' => $user_id, 'code' => $code, 'status' => '1'], "id,party_type_id,party_types", "tbl_party_master", 0, 0);
            }
            if (! empty( $getpartymaster ) ) {
				$party_master_id = $getpartymaster['id'];
			}else{
				$party_masters= insertmasterdata_forinvolvedparties($type,$cid);
				$party_master_id = $party_masters['party_master_id'];
			}
            $getPartyTypeId = $ci->common->gettblrowdata(['name' => $type, 'company_code' => $company_code, 'status' => '1'], "id", "tbl_party_types", 0, 0);
            $party_type_id = $getPartyTypeId['id'] ?? 0;
            if ($party_master_id > 0) {
                $booking_id = $order_id;
                $getorder_number = $ci->common->gettblrowdata(['id' => $order_id], "order_id", "tb_orders", 0, 0);
                if (!empty($getorder_number)) {
                    $booking_id = $getorder_number['order_id'];
                }
                $chkparty = $ci->common->gettblrowdata(['order_id' => $order_id, 'party_id' => $party_master_id, 'party_type' => $party_type_id, 'status' => '1'], "id", "tb_order_parties", 0, 0);
                if (empty($chkparty)) {
                    $ins_ar = ['order_id' => $order_id, 'order_number' => $booking_id, 'party_id' => $party_master_id, 'party_type' => $party_type_id, 'status' => '1', 'createdon' => $cdate];
                    $ins_id = $ci->common->insertTableData("tb_order_parties", $ins_ar);
                }
            }
        }
    }
}

if (!function_exists("getDepartmentMasterData")) {

    function getDepartmentMasterData($order_date='',$less_date='') {
        $ci = &get_instance();
        $departments = array();
        $company_code = $ci->session->userdata('company_code');
		$branch_code = $ci->session->userdata('branch_code');
		if($order_date!='' && $less_date!=''){
		 if($order_date<$less_date){
			$whr          = "";
		if ( $company_code == 'VNKN' || $company_code == 'RUKN' ) {
			$sql = $ci->db->select( "department_code" )->get_where( "tb_department_master", array( 'company_code' => $company_code, 'status' => '1' ) );
			if ( $sql->num_rows() > 0 ) {
				foreach ( $sql->result() as $res ) {
					$departments[] = $res->department_code;
				}
			}
		} else if ( $company_code == "SGKN" ) {
			$departments = array( 'CDIT', 'OTFE', 'OTFI', 'OTLE', 'OTLI', 'CTF', 'CTP', 'CDHC', 'OAEL', 'OAER', 'ETRA', 'OX', 'OPR', 'CZ','OCC' );
		} else {
			$departments = array( 'CDIT', 'OTFE', 'OTFI', 'OTLE', 'OTLI', 'CTF', 'CTP', 'CDHC', 'OAEL', 'OAER', 'OARR', 'ETRA', 'OX','CZ','OCC' );

			$sql = $ci->db->select( "department_code" )->get_where( "tb_department_master", array( 'company_code' => $company_code, 'status' => '1' ) );
			if ( $sql->num_rows() > 0 ) {
				foreach ( $sql->result() as $res ) {
					$departments[] = $res->department_code;
				}
			}

		}

		 }else{
			if($company_code == "SGKN"){
		$departments = array('CDIT', 'OTFE', 'OTFI', 'OTLE', 'OTLI', 'CTF', 'CTP', 'CDHC', 'OAEL', 'OAER', 'ETRA', 'OX', 'OPR', 'CZ', 'OCC');
		}else {
        $getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_department_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
            if ($getbranchdetail->num_rows() > 0) {
                $sql = $ci->db->query("SELECT department_code FROM tb_department_master WHERE ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))) AND status=1 ");
            if ($sql->num_rows() > 0) {
                foreach ($sql->result() as $res) {
                    $departments[] = $res->department_code;
                }
            }
            } else {
            $sql = $ci->db->query("SELECT department_code FROM tb_department_master WHERE (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)) AND status=1");
            if ($sql->num_rows() > 0) {
                foreach ($sql->result() as $res) {
                    $departments[] = $res->department_code;
                }
            }
            }
        }

		 }
		}else{
			if($company_code == "SGKN"){
		$departments = array('CDIT', 'OTFE', 'OTFI', 'OTLE', 'OTLI', 'CTF', 'CTP', 'CDHC', 'OAEL', 'OAER', 'ETRA', 'OX', 'OPR', 'CZ', 'OCC');
		}else {
        $getbranchdetail = $ci->db->query("SELECT branch_code FROM tb_department_master WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
            if ($getbranchdetail->num_rows() > 0) {
                $sql = $ci->db->query("SELECT * FROM tb_department_master WHERE ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))) AND status=1");
            if ($sql->num_rows() > 0) {
                foreach ($sql->result() as $res) {
                    $departments[] = $res->department_code;
                }
            }
            } else {
            $sql = $ci->db->query("SELECT department_code FROM tb_department_master WHERE (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)) AND status=1");
            if ($sql->num_rows() > 0) {
                foreach ($sql->result() as $res) {
                    $departments[] = $res->department_code;
                }
            }
            }
        }

		}


        return $departments;
    }

}


if ( ! function_exists( "addOrderToLogs" ) ) {
	function addOrderToLogs( $jsondata ) {
		$ci           = &get_instance();
		$departments  = array();
		$type         = $obj_type = 0;
		$created_on   = date( 'Y-m-d H:i:s' );
		$company_code = $ci->session->userdata( 'company_code' );
		$branch_code  = $ci->session->userdata( 'branch_code' );
		$user_id      = $ci->session->userdata( 'user_id' );
		$chktype      = $ci->db->select( "id" )->get_where( "tb_edi_types", array( "edi_name" => "Excel Upload", "status" => "1" ) );
		$chkobj_type  = $ci->db->select( "id" )->get_where( "tb_edi_object_types", array( "obj_type_name" => "order-id", "status" => "1" ) );
		if ( $chkobj_type->num_rows() > 0 ) {
			$obj_type = $chkobj_type->row()->id;
		}
		if ( $chktype->num_rows() > 0 ) {
			$type = $chktype->row()->id;
			if ( $type > 0 ) {
				$txn_obj_id = date( 'ymdHis' );
				$ins        = array(
					'edi_id'          => $type,
					'transaction_id'  => '0',
					'edi_name'        => 'Excel Upload',
					'edi_type'        => '1',
					'bounded_type'    => '2',
					'edi_format_type' => "JSON",
					'obj_type'        => $obj_type,
					'txn_obj_id'      => $txn_obj_id,
					'edi_request'     => 'Request',
					'edi_response'    => $jsondata,
					'user_id'         => $user_id,
					'company_code'    => $company_code,
					'branch_code'     => $branch_code,
					'user_id'         => $user_id,
					'created_on'      => $created_on
				);
				$ins_id     = $ci->db->insert( "tb_etn_edi_transactions", $ins );
			}
		}


		return $departments;
	}
}


if ( ! function_exists( 'createshipmentbyorder' ) ) {
	function createshipmentbyorder( $vendorinfo, $orderinfo ) {
		$response = 0;
		$ci       = &get_instance();
		$ci->load->model( 'common' );
		$userid = isset( $orderinfo['user_id'] ) ? $orderinfo['user_id'] : "";
		if ( $userid == "" ) {
			$userid = $ci->session->userdata( 'user_id' );
		}
		$year         = date( 'y' );
		$week         = date( 'W' );
		$company_code = isset( $orderinfo['company_code'] ) ? $orderinfo['company_code'] : "";
		if ( $company_code == "" ) {
			$company_code = $ci->session->userdata( 'company_code' );
		}
		if (isset($ci->session->userdata( "usr_tzone" )['timezone']) && $ci->session->userdata( "usr_tzone" )['timezone']!==NULL) {
			$curtz        = $ci->session->userdata( "usr_tzone" )['timezone'];
		} else {
			$userInfo = $ci->common->gettblrowdata(["id"=>$userid], "country_code", "tb_users", 0, 0 );
			if ($userInfo) {
				$countryCode = $userInfo['country_code'];
				$userTimeZone = $ci->common->gettblrowdata("(country_code='".$countryCode."' OR country_name='".$countryCode."') AND status=1", "cntry_timezone", "tbl_country_master", 0, 0 );
				if (!empty($userTimeZone)) {
					$curtz = $userTimeZone['cntry_timezone'];
				}
			}
		}
		$logdate      = date( 'Y-m-d H:i:s' );
		$getactual    = getdatetimebytimezone( DFLT_TZ, $logdate, $curtz );
		$curdt        = $getactual['datetime'];
		$curdt1       = date( 'Y-m-d H:i:s' );

		$count_code     = substr( $company_code, 0, 2 );
		$oid            = $orderinfo['id'];
		$order_nm       = $orderinfo['order_id'];
		$where          = array( "id" => $oid );
		$select         = "*";
		$table          = "tb_orders";
		$order          = $orderinfo;
		$seq_num        = substr( $order_nm, - 6 );
		$shipid         = "T" . $count_code . $week . $year . $seq_num;
		$vendor_id      = $vendorinfo['carrier_id'];
        $vehicle_id = $vendorinfo['vehicle_id'] ?? 0;
        $driver_id = $vendorinfo['driver_id'] ?? 0;
        $tpvehicle_type = $vendorinfo['vehicle_type'] ?? 0;
        $templateId = $vendorinfo['template_id'] ?? 0;
        if ($templateId > 0) {
            $ci->load->library('tripCreateFromOrders');
            $response = $ci->tripcreatefromorders->createTripByTripTemplate(['orderId' => $oid, 'templateId' => $templateId, 'tripType' => 'Single']);
            $orderIds = $response['orderIds'];
            $orderShiftIds = $response['orderShiftIds'];
            if (!empty($orderIds)) {
                $ci->tripcreatefromorders->assignOrdersForNewTrip($orderIds, $orderShiftIds, "Single");
                $response = 1;
                if (count($orderIds) === count($orderShiftIds)) {
                    foreach ($orderShiftIds as $shiftId) {
                        $getVendorId = $ci->common->gettblrowdata(['shift_id' => $shiftId], 'vendor_id', 'tb_orders', 0, 0);
                        if (checkAccessConditions('CHECK_DELHIVERY_LIMITED_CARRIER', $getVendorId['vendor_id'])) {
                            $ci->load->library("DelhiveryB2BEDIServices");
                            $ci->delhiveryb2bediservices->triggerDelhiveryAPI($shiftId);
                        }
                    }
                }
            }
        } else {
            if ( ( $shipid != "" ) && ( $vendor_id > 0 ) && ( $oid > 0 ) ) {
                if ( count( $order ) > 0 ) {
                    $pickup = $order['pickup_address1'];
                    if ( $pickup == "" ) {
                        $pickup = $order['pickup_city'];
                    }
                    $delivery = $order['delivery_address1'];
                    if ( $delivery == "" ) {
                        $delivery = $order['delivery_city'];
                    }
                    $address = $dropaddr = "";
                    if ( $order['pickup_address1'] != "" ) {
                        $address  .= $order['pickup_address1'];
                        $dropaddr .= $order['delivery_address1'];
                    }
                    if ( $order['pickup_company'] != "" ) {
                        $address  .= ", " . $order['pickup_company'];
                        $dropaddr .= ", " . $order['delivery_company'];
                    }
                    if ( $order['pickup_country'] != "" ) {
                        $address  .= ", " . $order['pickup_country'];
                        $dropaddr .= ", " . $order['delivery_country'];
                    }
                    if ( $order['pickup_city'] != "" ) {
                        $address  .= ", " . $order['pickup_city'];
                        $dropaddr .= ", " . $order['delivery_city'];
                    }
                    if ( $order['pickup_pincode'] != "" ) {
                        $address  .= ", " . $order['pickup_pincode'];
                        $dropaddr .= ", " . $order['delivery_pincode'];
                    }
                    $plat     = $order['plat'];
                    $plng     = $order['plng'];
                    $dlat     = $order['dlat'];
                    $dlng     = $order['dlng'];
                    $where    = array( "shipmentid" => $shipid );
                    $select   = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                    $table    = "tb_shifts";
                    $shipment = $ci->common->gettblrowdata( $where, $select, $table, 0, 0 );
                    if ( count( $shipment ) == 0 ) {
                        $splace         = $order['pickup_address1'];
                        $eplace         = $order['delivery_address1'];
                        $pickup_city    = $order['pickup_city'];
                        $delivery_city  = $order['delivery_city'];
                        $customer_id    = $order['customer_id'];
                        $transport_mode = $order['transport_mode'];
                        $weight         = $order['weight'];
                        $volume         = $order['volume'];
                        $txnid          = $shipid;
                        if ( $tpvehicle_type != '' && $tpvehicle_type != 0 ) {
                            $vtwhere  = array( "id" => $tpvehicle_type );
                            $vtselect = "trucktype";
                            $vttable  = "tb_trucktypes";
                            $vtorder  = $ci->common->gettblrowdata( $vtwhere, $vtselect, $vttable, 0, 0 );
                            if ( count( $vtorder ) > 0 ) {
                                $vehicle_type = $vtorder['trucktype'];
                            } else {
                                $company_vehicle = $ci->common->gettblrowdata( array( 'company_code' => $order['company_code'], 'status' => 'Active' ), "trucktype", "tb_trucktypes", 0, 0 );
                                if ( count( $company_vehicle ) > 0 ) {
                                    $vehicle_type = $company_vehicle['trucktype'];
                                } else {
                                    $vehicle_type = "Truck";
                                }
                            }
                        } else {
                            $company_vehicle = $ci->common->gettblrowdata( array( 'company_code' => $order['company_code'], 'status' => 'Active' ), "trucktype", "tb_trucktypes", 0, 0 );
                            if ( count( $company_vehicle ) > 0 ) {
                                $vehicle_type = $company_vehicle['trucktype'];
                            } else {
                                $vehicle_type = "Truck";
                            }
                        }
                        $startdate = $order['pickup_datetime'];
                        $starttime = date( 'H:i', strtotime( $startdate ) );
                        $enddate   = $order['delivery_datetime'];
                        $endtime   = date( 'H:i', strtotime( $enddate ) );
                        $getactual = getdatetimebytimezone( DFLT_TZ, $enddate, $curtz );
                        $enddate   = $getactual['datetime'];
                        $insarr    = array(
                            'user_id'        => $userid,
                            'stime'          => $starttime,
                            'etime'          => $endtime,
                            'splace'         => $order['pickup_city'],
                            'slat'           => $plat,
                            'slng'           => $plng,
                            'eplace'         => $order['delivery_city'],
                            'elat'           => $dlat,
                            'elng'           => $dlng,
                            'scity'          => $order['pickup_city'],
                            'dcity'          => $order['delivery_city'],
                            'zone_id'        => 1,
                            'empshift_start' => $starttime,
                            'empshift_end'   => $endtime,
                            'trip_type'      => 0,
                            'startdate'      => $startdate,
                            'enddate'        => $enddate,
                            'shipment_name'  => 'Boxes',
                            'shipment_id'    => 0,
                            'transport_mode' => $transport_mode,
                            'customer_id'    => $customer_id,
                            'vendor_id'      => $vendor_id,
                            'carrier_type'   => 0,
                            'shipmentid'     => $shipid,
                            'txnid'          => $txnid,
                            'weight'         => $weight,
                            'volume'         => $volume,
                            'units'          => $order['quantity'],
                            'domainname'     => 'INFD',
                            'vehicle_type'   => $vehicle_type,
                            'company_code'   => $order['company_code'],
                            'branch_code'    => $order['branch_code'],
                            'status'         => 1
                        );
                        $ship_id   = $ci->common->insertTableData( "tb_shifts", $insarr );
                    } else {
                        $ship_id = $shipment['id'];
                    }
                    /*update order table*/
                    $upddt    = array( 'vendor_id' => $vendor_id, 'shift_id' => $ship_id, "shipmentid" => $shipid );
                    $updwhr   = array( "id" => $oid );
                    $upd      = $ci->common->updatetbledata( "tb_orders", $upddt, $updwhr );
                    $invtypes = makeorderinvolvedpartiestype( $vendor_id, $oid, "CARRIER", $userid, $order['company_code'] );
                    /*$ci->ordernotify('trip_create',$oid);*/
                    $capacity = $order['weight'];
                    if ( $capacity == "" ) {
                        $capacity = "0";
                    }
                    /*update orders table*/
                    $updwhr = array( 'id' => $oid );
                    $setwhr = array( 'status' => 2 );
                    $ins    = $ci->db->where( $updwhr )->update( "tb_orders", $setwhr );
                    /*insert stops records */
                    $where   = array( "shipment_id" => $ship_id, "stopcity" => $order['pickup_city'], "stoptype" => "P" );
                    $select  = "id";
                    $table   = "tb_shiporder_stops";
                    $chkstop = $ci->common->gettblrowdata( $where, $select, $table, 0, 0 );
                    if ( count( $chkstop ) == 0 ) {
                        $insarr        = array(
                            'stopname'       => $order['pickup_city'],
                            'plat'           => $plat,
                            'plng'           => $plng,
                            'stopcity'       => $order['pickup_city'],
                            'address'        => $address,
                            'stoptype'       => 'P',
                            'stopstatus'     => 0,
                            'shipment_id'    => $ship_id,
                            'ordernumber'    => 1,
                            'startdate'      => $order['pickup_datetime'],
                            'enddate'        => $order['pickup_endtime'],
                            'weight'         => $order['weight'],
                            'volume'         => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units'     => $order['quantity'],
                            'txncode'        => 'NP',
                            'status'         => 1,
                            'created_on'     => $curdt
                        );
                        $ins           = $ci->db->insert( "tb_shiporder_stops", $insarr );
                        $pickupstop_id = $ci->db->insert_id();
                    } else {
                        $pickupstop_id = $chkstop['id'];
                    }
                    $where   = array( "shipment_id" => $ship_id, "stopcity" => $order['delivery_city'], "stoptype" => "D" );
                    $select  = "id";
                    $table   = "tb_shiporder_stops";
                    $chkstop = $ci->common->gettblrowdata( $where, $select, $table, 0, 0 );
                    if ( count( $chkstop ) == 0 ) {
                        $insarr      = array(
                            'stopname'       => $order['delivery_city'],
                            'plat'           => $dlat,
                            'plng'           => $dlng,
                            'stopcity'       => $order['delivery_city'],
                            'address'        => $dropaddr,
                            'stoptype'       => 'D',
                            'stopstatus'     => 0,
                            'shipment_id'    => $ship_id,
                            'ordernumber'    => 2,
                            'startdate'      => $order['delivery_datetime'],
                            'enddate'        => $order['drop_endtime'],
                            'weight'         => $order['weight'],
                            'volume'         => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units'     => $order['quantity'],
                            'txncode'        => 'NP',
                            'status'         => 1,
                            'created_on'     => $curdt
                        );
                        $ins         = $ci->db->insert( "tb_shiporder_stops", $insarr );
                        $dropstop_id = $ci->db->insert_id();
                    } else {
                        $dropstop_id = $chkstop['id'];
                    }
                    /*add pickupstop and drop stop id into details/tb_employee table */
                    $where  = array( 'stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id, 'order_id' => $order['order_id'], 'shift_id' => $ship_id );
                    $select = "id";
                    $table  = "tb_employee";
                    $chkemp = $ci->common->gettblrowdata( $where, $select, $table, 0, 0 );
                    if ( count( $chkstop ) == 0 ) {
                        $order['customer_comments'] = isset( $order['customer_comments'] ) ? $order['customer_comments'] : "";
                        $insarr                     = array(
                            'assoc_id'        => $shipid,
                            'pickup'          => $pickup,
                            'plat'            => $plat,
                            'plng'            => $plng,
                            'drop'            => $delivery,
                            'dlat'            => $dlat,
                            'dlng'            => $dlng,
                            'pickup_city'     => $order['pickup_city'],
                            'drop_city'       => $order['delivery_city'],
                            'pickup_datetime' => $order['pickup_datetime'],
                            'drop_datetime'   => $order['delivery_datetime'],
                            'name'            => 'Boxes',
                            'phone'           => $order['customer_phone'],
                            'address'         => $address,
                            'emailid'         => $order['customer_email'],
                            'user_id'         => $userid,
                            'status'          => 1,
                            'createdon'       => $curdt,
                            'material_id'     => 0,
                            'capacity'        => $capacity,
                            'information'     => $order['customer_comments'],
                            'shipment_weight' => $order['weight'],
                            'shipment_volume' => $order['volume'],
                            'ship_type'       => 'P',
                            'customer_id'     => $order['customer_id'],
                            'vendor_id'       => $vendor_id,
                            'shipment_id'     => 0,
                            'startdate'       => $order['pickup_datetime'],
                            'enddate'         => $order['delivery_datetime'],
                            'shift_id'        => $ship_id,
                            'stop_order'      => 1,
                            'drop_order'      => 0,
                            'basic_stop'      => 0,
                            'stop_id'         => $pickupstop_id,
                            'drop_stopid'     => $dropstop_id,
                            'order_id'        => $order['order_id'],
                            'pkgitemid'       => 'BOXES',
                            'no_of_pkgs'      => $order['quantity'],
                            'domainname'      => 'INFD'
                        );
                        $detail_id                  = $ci->common->insertTableData( "tb_employee", $insarr );
                    } else {
                        $detail_id = $chkemp['id'];
                    }
                    $stops_units = $ci->db->query( "SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$oid' AND im.id = oc.handling_unit AND oc.status='1'" );
                    if ( $stops_units->num_rows() > 1 ) {
                        $odata = $stops_units->row();
                        $upd   = $ci->db->query( "UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '" . $odata->id . "'" );
                    }
                    $chk1 = $ci->db->select( "id" )->get_where( "tb_shft_veh", array( "shft_id" => $ship_id ), 1, 0 );
                    if ( $chk1->num_rows() > 0 ) {
                        $shftvehid = $chk1->row()->id;
                        $chk       = $ci->db->select( "id" )->get_where( "tb_shft_veh_emp", array( "shft_veh_id" => $shftvehid, "status" => 1 ), 1, 0 );
                        if ( $chk->num_rows() == 0 ) {
                            $getemp = $ci->db->select( "id,pickup_datetime,drop_datetime" )->get_where( "tb_employee", array( "shift_id" => $ship_id ) );
                            if ( $getemp->num_rows() > 0 ) {
                                $pri = 1;
                                foreach ( $getemp->result() as $gt ) {
                                    $insveh1 = array( "user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime );
                                    $ins     = $ci->common->insertTableData( "tb_shft_veh_emp", $insveh1 );
                                    $pri ++;
                                }
                            }
                        } else {
                            $chkemp = $ci->db->select( "id" )->get_where( "tb_shft_veh_emp", array( "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1 ), 1, 0 );
                            if ( $chkemp->num_rows() == 0 ) {
                                $insveh1 = array( "user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime'] );
                                $ins     = $ci->common->insertTableData( "tb_shft_veh_emp", $insveh1 );
                            }
                        }
                    } else {
                        if ( $vehicle_id != "" && $vehicle_id != 0 ) {
                            $getVehicleNumber = $ci->common->gettblrowdata(["id" => $vehicle_id], "register_number", "tb_trucks_data", 0, 0);
                            $vehicleNumber = $getVehicleNumber['register_number'] ?? "";
                            $shftvehid = $ci->common->insertTableData("tb_shft_veh", ['user_id' => $userid, 'route_id' => 0, 'shft_id' => $ship_id, 'carrier_id' => $vendor_id, 'vehicle_id' => $vehicle_id, 'register_number' => $vehicleNumber, 'status' => 1]);
                            $getemp    = $ci->db->select( "id,pickup_datetime,drop_datetime" )->get_where( "tb_employee", array( "shift_id" => $ship_id ) );
                            if ( $getemp->num_rows() > 0 ) {
                                $pri = 1;
                                foreach ( $getemp->result() as $gt ) {
                                    $insveh1 = array( "user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime );
                                    $ins     = $ci->common->insertTableData( "tb_shft_veh_emp", $insveh1 );
                                    $pri ++;
                                }
                            }
                        }
                    }
                    if ( $vehicle_id > 0 && $driver_id > 0 ) {
                        $chk = $ci->db->select( "id,driver_id,status" )->order_by( "id", "DESC" )->get_where( "tb_vehicles_drivers", array( "vehicle_id" => $vehicle_id ) );
                        if ( $chk->num_rows() > 0 ) {
                            if ( $driver_id == $chk->row()->driver_id ) {
                                $upd = $ci->db->where( array( "id" => $chk->row()->id ) )->update( "tb_vehicles_drivers", array( "status" => 1 ) );
                            } else {
                                $arr = array( 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt );
                                $ins = $ci->common->insertTableData( "tb_vehicles_drivers", $arr );
                            }
                        } else {
                            $arr = array( 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt );
                            $ins = $ci->common->insertTableData( "tb_vehicles_drivers", $arr );
                        }
                        $chk11 = $ci->db->select( "id" )->get_where( "tbl_assigned_drivers", array( "driver_id" => $driver_id, "vehicle_id" => $vehicle_id ), 1, 0 );
                        if ( $chk11->num_rows() > 0 ) {
                            $upd = $ci->db->where( array( "id" => $chk11->row()->id ) )->update( "tbl_assigned_drivers", array( "status" => "1", 'updated_on' => $curdt ) );
                        } else {
                            $chk111 = $ci->db->select( "id" )->get_where( "tbl_assigned_drivers", array( "driver_id <>" => $driver_id, "vehicle_id" => $vehicle_id, "status" => 1 ), 1, 0 );
                            if ( $chk111->num_rows() == 0 ) {
                                $ins = $ci->common->insertTableData( "tbl_assigned_drivers", array( "vehicle_id" => $vehicle_id, "user_id" => $userid, "driver_id" => $driver_id, "mobile_no" => $driver_id, "imei" => "", "from_time" => $curdt, "to_time" => $curdt, "status" => "1", 'created_on' => $curdt ) );
                            } else {
                                $upd = $ci->db->where( array( "id" => $chk111->row()->id ) )->update( "tbl_assigned_drivers", array( "driver_id" => $driver_id, 'updated_on' => $curdt ) );
                            }
                        }
                    }
                    $response = 1;
                    /* update status */
                    $chk = $ci->db->select( "id" )->get_where( "tb_stop_status", array( "shipment_id" => $ship_id, "status_id" => 9 ), 1, 0 );
                    if ( $chk->num_rows() == 0 ) {
                        $ins = ["shipment_id" => $ship_id, 'order_id' => $oid, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "reason" => "Coming from E-Booking", "createdon" => $curdt1];
                        $insqry = $ci->common->insertTableData("tb_stop_status", $ins);
                    }
                    /* Notification mail for trip_create */
                    $ci->load->library( 'notifytrigger' );
                    $ci->load->library( 'ratemanagement' );
                    $info = array( 'ordid' => $oid, 'carrierid' => $vendor_id );
                    $ci->ratemanagement->addrecodfortripinsertion( $info );
                    $notify['page_title'] = 'Booking Notification';
                    $notify['subject']    = 'Booking Notification';
                    $notify['order_id']   = $oid;
                    $notify['action']     = 'trip_create';
                    $notify['orderid']    = $order_nm;
                    $notify['cargos']     = $ci->common->gettbldata( array( 'order_id' => $oid ), 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0 );
                    $notify['shift_id']   = $ship_id;
                    $shipinfo             = $ci->common->gettblrowdata( array( 'id' => $notify['shift_id'] ), 'shipmentid', 'tb_shifts', 0, 0 );
                    $notify['shiftid']    = ( ! empty( $shipinfo['shipmentid'] ) ) ? $shipinfo['shipmentid'] : '';
                    $notify['body']       = $ci->load->view( 'mail_forms/notifytrigger/trip_create', $notify, TRUE );
                    $ci->notifytrigger->sendtripnotify( $notify );
                    /*send email notification*/

                    if (checkAccessConditions('CHECK_DELHIVERY_LIMITED_CARRIER', $vendor_id)) {
		                $ci->load->library("DelhiveryB2BEDIServices");
		                $ci->delhiveryb2bediservices->triggerDelhiveryAPI($ship_id);
		            }
		            $checkvendors = $ci->db->select("id")->get_where("tb_vendors",array('id'=>$vendor_id,'tms_auto_accept'=>1),1,0);

                    if($checkvendors->num_rows() != 0){
                        $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                        $chkdrivers = $ci->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                        $driver_id = $chkdrivers->row()->driver_id;
                        $dvrarr1 = array('id' => $driver_id, 'status' => 1);
                        $chknum = $ci->db->select("contact_num")->get_where("tb_truck_drivers", $dvrarr1, 1, 0);
                        $contact_num = $chknum->row()->contact_num;
                        if ( $vehicle_id > 0 && $driver_id > 0 )
                        {
                            $checkshifts = $ci->db->select("id")->get_where("tb_trips",array('shift_id'=>$ship_id,'vehicle_id' => $vehicle_id,'driver_id'=>$driver_id),1,0);
                            if ( $checkshifts->num_rows() == 0 ) {
                                $triparr = @array(
                                    'shift_id' => $ship_id,
                                    'vehicle_id' => $vehicle_id,
                                    'driver_id' => $driver_id,
                                    'stime' => $curdt,
                                    'start_imei' => $contact_num,
                                    'splace' => "",
                                    'eplace' => "",
                                    'start_reading' => 0,
                                    'end_reading' => 0,
                                    'created_on' => $curdt,
                                    'updated_on' => $curdt,
                                    'status' => 1,
                                    'trip_type' => 0,
                                    'transit_status' => 0

                                );
                                $trip_id = $ci->db->insert("tb_trips",$triparr);

                                $tripid = array('shift_id' => $ship_id,'vehicle_id' => $vehicle_id, 'status' => 1);
                                $chktrips = $ci->db->select("id")->get_where("tb_trips", $tripid, 1, 0);
                                $trip_id = $chktrips->row()->id;
                                // echo $tripid;
                                $ordwhr = array("shift_id" => $ship_id);
                                $ordset = array("trip_id" => $trip_id);
                                $upd = $ci->db->set($ordset) ->where($ordwhr)->update("tb_orders");

                                $orderid = array('shift_id' => $ship_id);
                                $chkorders = $ci->db->select("id")->get_where("tb_orders", $orderid, 1, 0);
                                $order_id = $chkorders->row()->id;

                                //  $vehicleid = array('shift_id' => $ship_id,'id' => $trip_id);
                                // $chkvehicle = $ci->db->select("vehicle_id,driver_id")->get_where("tb_trips", $vehicleid, 1, 0);
                                // $vehicleid = $chkvehicle->row()->vehicle_id;
                                // $driver_id = $chkvehicle->row()->driver_id;

                                $insarry = array(
                                    'order_id' => $order_id,
                                    "shipment_id" => $ship_id,
                                    "stop_id" => 0,
                                    "stop_detail_id" => 0,
                                    "stop_type" => "",
                                    "trip_id" => $trip_id,
                                    "status_id" => 10,
                                    "latitude" => "",
                                    "longitude" => "",
                                    "status" => 1,
                                    "reason" => "From Admin",
                                    "vehicle_id" => $vehicle_id,
                                    "driver_id" => $driver_id,
                                    "status_code" => '0212',
                                    "createdon" => $curdt
                                );
                                $ins = $ci->db->insert("tb_stop_status", $insarry);
                                $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
                                if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, '0212')) {
                                    $ci->load->library('notifytrigger');
                                    $ci->notifytrigger->sendNotificationToConsignee($order_id, '0212');
                                }
                                if (checkAccessConditions('WECHAT_COUNTRY', $company_code)) {
				                    $ci->load->library('Wechat');
				                    $ci->wechat->orderId = $order_nm;
				                    $ci->wechat->sendNotificationsToWeChat();
				                }
                            }
                        }
                    }
                }
            }
            /* Push notification to mobile using Firebase */
            $customerName = $ci->common->gettblrowdata(["id" => $orderinfo['customer_id']], "name", "tb_customers", 0, 0);
            if ($order['created_source'] == 18) {
                $getTrackingNumber = $ci->common->gettblrowdata(["order_id" => $oid, 'reference_id' => 'AWB', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                $knTrackingNo = $getTrackingNumber['ref_value'] ?? "";
            }else {
                $getTrackingNumber = $ci->common->gettblrowdata(["order_id" => $oid, 'reference_id' => 'DQ', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                $knTrackingNo = $getTrackingNumber['ref_value'] ?? "";
            }
            if ($shipid != "" && $vendorinfo['driver_id']>0) {
                $message = "New trip is assigned and accepted"." "
                    . "Pickup Date: " . substr($order['pickup_datetime'],0,10)." "
                    . "Customer Name: " . $customerName['name']." "
                    . "Booking ID: " . $order_nm." "
                    . "KN tracking no: " . $knTrackingNo." "
                    . "Trip No: " . $shipid;
                $messageData = json_encode(["msg" => $message, "info" => (object)[], "type"=>1],JSON_UNESCAPED_UNICODE);
                $ci->load->library('sendfirebase');
                $fire_ret = $ci->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $vendorinfo['driver_id'], 'type' => 'Driver']);
            }
            /* End Push notification to mobile using Firebase */
        }

		return $response;
	}

}

if ( ! function_exists( 'getorders_withwildcardsearch' ) ) {
	function getorders_withwildcardsearch($wildcard_search,$searchids,$company_code,$user_id,$countryids ) {
		$order_ids = $result = array();
		$ci   = &get_instance();
		$ci->load->model('order');
		if($wildcard_search != ""){
			$whr = "order_id LIKE '".$wildcard_search."' AND status != '0'";
			$orders_data = $ci->order->getwildcardsearchorders($whr,$company_code,$user_id,$countryids);
			if(!empty($orders_data)){
				foreach($orders_data as $row){
					$order_ids[] = $row['order_id'];
				}
				if(!empty($order_ids)){
					if(!empty($searchids)){
						$result = array_intersect($order_ids,$searchids);
					}else{
						$result = $order_ids;
					}
				}else{
					$result  = $searchids;
				}
			}else{
				$result = $searchids;
			}
		}else{
			$result = $searchids;
		}
		return $result;
	}
}

if (!function_exists("insertmasterdata_forinvolvedparties")) {
    function insertmasterdata_forinvolvedparties($party_type,$id) {
		$ci = &get_instance();
		$party_type_id   = $party_master_id =  0;
		$ci->load->model( 'common' );
		$cdate = date('Y-m-d H:i:s');
		if($id >0){
            $getdetails = [];
            if (strtoupper($party_type) == "CUSTOMER") {
                $getdetails = $ci->common->gettblrowdata(['id' => $id, 'status' => '1'], "name,phone,code,country,state,street,location,pincode,fax,email_id,password,user_id,company_code,branch_code", 'tb_customers', 0, 0);
            } elseif (strtoupper($party_type) == "CARRIER") {
                $getdetails = $ci->common->gettblrowdata(['id' => $id, 'status' => '1'], "name,mobile as phone,location,pincode,country,email as email_id,code,user_id,company_code,branch_code", 'tb_vendors', 0, 0);
            }
            $company_code = $getdetails['company_code'] ?? $ci->session->userdata('company_code');
            $branch_code = $getdetails['branch_code'] ?? $ci->session->userdata('branch_code');
            $user_id = $getdetails['user_id'] ?? $ci->session->userdata('user_id');
            $chkparty_type = $ci->common->gettblrowdata(array('name' => $party_type,'user_id'=>$user_id,'company_code'=>$company_code,'status'=>'1'), "id", 'tbl_party_types', 0, 0);
			if(!empty($chkparty_type)){
				$party_type_id = $chkparty_type['id'];
			}else{
				$chkparty_type1 = $ci->common->gettblrowdata(array('name' => $party_type,'company_code'=>$company_code,'status'=>'1'), "id", 'tbl_party_types', 0, 0);
				if(!empty($chkparty_type1)){
					$party_type_id = $chkparty_type1['id'];
				}
			}
			if($party_type_id >0){
				if(!empty($getdetails)){
					$state = isset($getdetails['state']) ? $getdetails['state'] : "";
					if($state == ""){
						$state = $getdetails['location'];
					}
					$street = isset($getdetails['street']) ? $getdetails['street'] : "";
					if($street == ""){
						$street = $getdetails['location'];
					}
					$email_id = isset($getdetails['email_id']) ? $getdetails['email_id'] : "";
					if($email_id == ""){
						$email_id = $getdetails['name'].'@dummy.com';
					}
					$phone = isset($getdetails['phone']) ? $getdetails['phone']: "";
					if($phone == ""){
						$phone = $getdetails['code'];
					}
					$address = $getdetails['location'].",".$state.",".$getdetails['country'];
					$insarr = array('party_type_id'=>$party_type_id,'name'=>$getdetails['name'],'email'=>$email_id,'mobile'=>$phone,'user_id '=>$user_id ,'code'=>$getdetails['code'],'partyindetifier'=>$getdetails['code'],'customeridentifier'=>$getdetails['code'],'company_code'=>$company_code,'branch_code'=>$branch_code,'department_code'=>'CTP','customer_code'=>'0','parent_id'=>'0','autoaccept'=>'0','location_id'=>$getdetails['location'],'address'=>$address,'country'=>$getdetails['country'],'state'=>$state,'street'=>$street,'pincode'=>$getdetails['pincode'],'category_id'=>'0','cargo_limit'=>'0','limit_amount'=>'0','credit_limit_amount'=>'0','utilized_amount'=>'0','status'=>'1','created_on'=>$cdate);
					$party_master_id = $ci->common->insertTableData("tbl_party_master", $insarr);
				}
			}
		}
		$party_masters = array('party_master_id'=>$party_master_id,'name'=>$party_type,'party_type_id'=>$party_type_id);
		return $party_masters;
	}
}

if (!function_exists("subcustpartiesinsert")) {
	function subcustpartiesinsert($order_id, $booking_id, $data)
	{
		$ci = &get_instance();
		$ins_party=0;
		$getpartytype=[];
		$company_code = $ci->session->userdata('company_code');
		$branch_code  = $ci->session->userdata('branch_code');
		$user_id      = $ci->session->userdata('user_id');
		$cdate = date('Y-m-d H:i:s');
		$party_type   = 1;
		if (!empty($data)) {
			for ($i = 0; $i < 4; $i++) {
				if(!empty($data[$i])){
					if($data[$i] >0){
						$name=['shipper','consignee','pickup','delivery'];
                        $whr = ['name' => $name[$i], 'status' => 1, 'company_code' => $company_code, 'user_id' => $user_id];
                        $getpartytype = $ci->common->gettblrowdata($whr, 'id', 'tbl_party_types', 0, 0);
						if (!empty($getpartytype)) {
							$party_type = $getpartytype['id'];
						}else{
							$ins=array('name'=>$name[$i],'description'=>$name[$i],'user_id'=>$user_id,'company_code'=>$company_code,'branch_code'=>$branch_code,'status'=>1);
							$party_type = $ci->common->insertTableData("tbl_party_types", $ins);
						}
						if(!empty($party_type)){
							$party     = array('order_id' => $order_id, 'status' => '1');
							$getparties = $ci->common->gettbldata($party, 'id,party_id,party_type', 'tb_order_parties', 0, 0);
							if(!empty($getparties)){
								foreach ($getparties as $parties) {
									$chk_ptype = $parties['party_type'];
									$chk_ptype_id = $parties['id'];
									$chk_pmaster = $parties['party_id'];
									if($chk_ptype >0){
										$getpname = $ci->common->gettblrowdata(array('id'=>$chk_ptype), 'name', 'tbl_party_types', 0, 0);
										if(!empty($getpname)){
											$pname = strtoupper($getpname['name']);
											if($pname == strtoupper($name[$i])){
												if($chk_pmaster == $data[$i]){
												}else{
													$whr_up=array('id'=>$chk_ptype_id);
													$set_up = array('status'=>'0');
													$ci->common->updatetbledata('tb_order_parties',$set_up,$whr_up);
												}
											}
										}
									}
								}
							}
							$whr_parties=array('order_id' => $order_id,'party_type' => $party_type,'party_id' => $data[$i],'status' => '1');
							$getparties = $ci->common->gettblrowdata($whr_parties, 'id', 'tb_order_parties', 0, 0);
							if(empty($getparties)){
								$chkparty1 = $ci->common->gettblrowdata(array('order_id'=>$order_id,'party_id'=>$data[$i],'status'=>'1'), 'id,party_type','tb_order_parties', 0, 0);
								if(!empty($chkparty1)){
									$party_type1 = $chkparty1['party_type'];
									$getpname1 = $ci->common->gettblrowdata(array('id'=>$party_type1), 'name', 'tbl_party_types', 0, 0);
									if(!empty($getpname1)){
										$pname1 = strtoupper($getpname1['name']);
										if($pname1 == strtoupper($name[$i])){
										}else{
											$party     = array('order_id' => $order_id, 'party_id' => $data[$i], 'status' => '1', 'createdon' => $cdate, 'party_type' => $party_type, 'order_number' => $booking_id);
											$ins_party = $ci->db->insert("tb_order_parties", $party);
										}
									}
								}else{
									$party     = array('order_id' => $order_id, 'party_id' => $data[$i], 'status' => '1', 'createdon' => $cdate, 'party_type' => $party_type, 'order_number' => $booking_id);
									$ins_party = $ci->db->insert("tb_order_parties", $party);
								}
							}
						}
					}
			    }
			}
		}
		return $ins_party;
	}
}

/* get order type name by order type id */
if (!function_exists('getOrderTypeById')) {
    function getOrderTypeById($id)
    {
        $ordtypename = "";
        $ci = &get_instance();
        if ($id != "") {
            $ci->load->model('common');
            $ordtypeqry = $ci->common->gettblrowdata(["id" => $id], "ordtype_code", "tb_order_types", 0, 0);
            if (count($ordtypeqry) > 0) {
                $ordtypename = $ordtypeqry['ordtype_code'];
            }
        }
        return $ordtypename;
    }
}

if (!function_exists('getAllCustomersMasterDataForQuickbook')) {
    function getAllCustomersMasterDataForQuickbook(array $customerIds): array
    {
        $ci = &get_instance();
        $ci->load->model('common');
        if (empty($customerIds)) {
            return [];
        }
        $getVasData = $ci->common->getjointbldata("tb_vas_master v", "customer_vasdata c", "v.id=c.vasrow_id", "v.status ='1' AND c.status = 1 AND c.customer_id IN (" . implode(',', $customerIds) . ")", "v.id,v.vas_id,v.vas_name", 0, 0);
        foreach ($getVasData as $eachLine) {
            if ($eachLine['vas_id'] != "") {
                $vasData[] = ['rowId' => $eachLine['id'], 'vasId' => $eachLine['vas_id'], 'vasName' => $eachLine['vas_name']];
            }
        }
        $getTransportModes = $ci->common->getjointbldata("tb_transportmode t", "customer_moddata c", "t.id=c.tranportrow_id", "t.status ='1' AND c.status = 1 AND c.customer_id IN (" . implode(',', $customerIds) . ")", "t.id,t.code,t.name", 0, 0);
        foreach ($getTransportModes as $eachLine) {
            $transport[] = ['id' => $eachLine['id'], 'code' => $eachLine['code'], 'name' => $eachLine['name']];
        }
        $getService = $ci->common->getjointbldata("tb_service_master s", "customer_servicedata c", "s.id=c.servicerow_id", "s.status ='1' AND c.status = 1 AND c.customer_id IN (" . implode(',', $customerIds) . ")", "s.id,s.service_id,s.name", 0, 0);
        foreach ($getService as $eachLine) {
            $service[] = ['row_id' => $eachLine['id'], 'id' => $eachLine['service_id'], 'name' => $eachLine['name']];
        }
        return ['vasData' => $vasData ?? [], 'service' => $service ?? [], 'transport' => $transport ?? []];
    }
}

if (!function_exists('checkCustomerHasAltovaConnection')) {
    function checkCustomerHasAltovaConnection(int $order_id): int
    {
        $ci = &get_instance();
        $altovaCustomer = $ci->db->query("SELECT tpr.`reference_type`,tpr.`name`,tpr.`value` FROM tb_orders o LEFT OUTER JOIN tb_customers tc ON tc.id=o.customer_id LEFT OUTER JOIN tbl_party_master tpm ON tc.code=tpm.code LEFT OUTER JOIN `tb_party_reference` tpr ON tpm.id=tpr.partner_id WHERE o.id=? AND tpr.`status`=1 AND tpr.name='Send to Altova' AND UPPER(value) = 'Y'", [$order_id]);
        return $altovaCustomer->num_rows() ?? 0;
    }
}

if (!function_exists('insertOrdersRefFileLineIdentifier')) {
    function insertOrdersRefFileLineIdentifier(array $info): void
    {
        $ci = &get_instance();
        $ci->load->model('common');
        $getRefData = $ci->common->gettblrowdata(['source_city' => $info['pickupCity'], 'source_suburb' => $info['pickupState'], 'source_country' => $info['pickupCountry'], 'destination_city' => $info['dropCity'], 'destination_suburb' => $info['dropState'], 'destination_country' => $info['dropCountry'], 'company_code' => $info['companyCode'], 'branch_code' => $info['branchCode'], 'status' => '1'], "ref_value", "orders_filelineidentifier", 0, 0);
        if (!empty($getRefData)) {
            $checkReference = $ci->common->gettblrowdata(['order_id' => $info['orderRowId'], 'reference_id' => 'FI'], "id", "tb_order_references", 0, 0);
            if (empty($checkReference)) {
                $ci->common->insertTableData("tb_order_references", ['order_id' => $info['orderRowId'], 'reference_id' => 'FI', 'ref_value' => $getRefData['ref_value'], 'status' => '1', 'createdon' => $info['date']]);
            } else {
                $updateReference = $ci->common->updatetbledata("tb_order_references", ['order_id' => $info['orderRowId'], 'reference_id' => 'FI', 'ref_value' => $getRefData['ref_value']], ['id' => $checkReference['id']]);
            }
        }
    }
}

if(!function_exists('getcropcustOrderTypes')){
    function getcropcustOrderTypes($users){
        $ci = &get_instance();
        $ordertypes = array();
        $users = (is_array($users)) ?  implode(',', $users) : $users;
        if(!empty($users)){
            $user = (is_array($users)) ? trim($users, ',') : $users;
            $branchcodes_query = $ci->db->query("SELECT company_code,branch_code from tb_users where id IN($user)");
            if($branchcodes_query->num_rows() > 0 ){
                foreach ($branchcodes_query->result() as $res) {
                    $company_code= $res->company_code;
                    $branch_code = $res->branch_code;
                    $getorders = $ci->db->query("SELECT id,type_name FROM tb_order_types WHERE status ='1' AND company_code= '" . $company_code . "' AND branch_code= '".$branch_code."' group by type_name ");
                    if ($getorders->num_rows() > 0) {
                        foreach ($getorders->result() as $res) {
                            $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                        }
                    }
                }
            }
        }
        return $ordertypes;
    }
}

if (!function_exists('insertDgGoodsForOrderCargos')) {
    function insertDgGoodsForOrderCargos(array $postData): array
    {
        $ci = &get_instance();
        $ci->load->model('common');
        $unCodes = $postData['unCode'] ?? [];
        $unCodeNames = $postData['unCodeName'] ?? [];
        $adrMultiplicators = $postData['adrMultiplicator'] ?? [];
        $transportCategorys = $postData['transportCategory'] ?? [];
        $unCodeClasss = $postData['unCodeClass'] ?? [];
        $tunnelCodes = $postData['tunnelCode'] ?? [];
        $numOfPackagess = $postData['numOfPackages'] ?? [];
        $packageTypes = $postData['packageType'] ?? [];
        $grossWeights = $postData['grossWeight'] ?? [];
        $netWeights = $postData['netWeight'] ?? [];
        $netExplosiveMasss = $postData['netExplosiveMass'] ?? [];
        $noss = $postData['nos'] ?? [];
        $literss = $postData['liters'] ?? [];
        $limitedQuantitys = $postData['limitedQuantity'] ?? [];
        $expectedQuantitys = $postData['expectedQuantity'] ?? [];
        $environmentallys = $postData['environmentally'] ?? [];
        $fireworksInformations = $postData['fireworksInformation'] ?? [];
        $technicalNames = $postData['technicalName'] ?? [];
        $dgRowIds = $postData['dgRowId'] ?? [];
        foreach ($unCodes as $key => $eachUnCode) {
            if ($eachUnCode != "") {
                $unCodeName = $unCodeNames[$key] ?? "";
                $adrMultiplicator = $adrMultiplicators[$key] ?? "";
                $transportCategory = $transportCategorys[$key] ?? "";
                $unCodeClass = $unCodeClasss[$key] ?? "";
                $packingGroup = $packingGroups[$key] ?? "";
                $nos = $noss[$key] ?? "";
                $tunnelCode = $tunnelCodes[$key] ?? "";
                $numOfPackages = $numOfPackagess[$key] ?? "";
                $packageType = $packageTypes[$key] ?? "";
                $grossWeight = $grossWeights[$key] ?? "";
                $netWeight = $netWeights[$key] ?? "";
                $netExplosiveMass = $netExplosiveMasss[$key] ?? "";
                $liters = $literss[$key] ?? "";
                $limitedQuantity = $limitedQuantitys[$key] ?? "";
                $expectedQuantity = $expectedQuantitys[$key] ?? "";
                $environmentally = $environmentallys[$key] ?? "";
                $fireworksInformation = $fireworksInformations[$key] ?? "";
                $technicalName = $technicalNames[$key] ?? "";
                $dgRowId = $dgRowIds[$key] ?? "";
                $dgCargo = [
                    'num_pkgs' => $numOfPackages,
                    'pkg_qty_type' => $packageType,
                    'quantity' => $numOfPackages,
                    'org_number' => $eachUnCode,
                    'org_name' => $unCodeName,
                    'quantity_type' => $packageType,
                    'db_class' => $unCodeClass,
                    'description' => $technicalName,
                    'limited_quantity' => $limitedQuantity,
                    'excepted_quantity' => $expectedQuantity,
                    'status' => '1',
                    'createdon' => date('Y-m-d H:i:s'),
                    'tunnel_restriction_code' => $tunnelCode,
                    'environment_hazardous' => $environmentally,
                    'nos' => $nos,
                    'packing_group' => $packingGroup,
                    'gross_weight' => $grossWeight,
                    'net_weight' => $netWeight,
                    'netexplosive_mass' => $netExplosiveMass,
                    'liters' => $liters,
                    'fire_works' => $fireworksInformation,
                    'adr_multiplicator' => $adrMultiplicator,
                    'transport_category' => $transportCategory,
                ];
                if ($dgRowId > 0) {
                    $ci->common->updatetbledata("tb_order_dg_goods", $dgCargo, ['id' => $dgRowId]);
                } else {
                    $dgRowId = $ci->common->insertTableData("tb_order_dg_goods", $dgCargo);
                }
                $insIds[] = $dgRowId;
            }
        }
        return $insIds ?? [];
    }
}

if ( ! function_exists( "getReferenceMasterDataWithDescription" ) ) {
    function getReferenceMasterDataWithDescription() {
        $ci        = &get_instance();
        $reference = array();
        $sql       = $ci->db->query( "SELECT id,name,description FROM tb_reference_master WHERE status =1 GROUP BY name" );
        if ( $sql->num_rows() > 0 ) {
            foreach ( $sql->result() as $res ) {
                $reference[] = [
                    'id' => $res->id,
                    'name' => $res->name,
                    'description' => $res->description
                ];
            }
        }
        return $reference;
    }
}

if (!function_exists("getEdiStatuses")) {
	function getEdiStatuses($type,$external_status) {
	    //log("error","Status:".json$external_status);
		$ci = &get_instance();
		$status = "";
		$sql = $ci->db->query("SELECT svk_status FROM tb_edi_status WHERE otm_status = '".$external_status."' AND external_type= '".$type."' AND status='1' ");
		if($sql->num_rows() >0){
			$status = $sql->row()->svk_status;

		}
		return $status;
	}
}
