<?php
if ( ! defined( 'BASEPATH' ) ) {
    exit( 'No direct script access allowed' );
}
if ( ! function_exists( 'mobilePushNotification' ) ) {
    function mobilePushNotification($ordInput) {
        $ci       = &get_instance();
        $ci->load->model( 'common' );
        $orderIds= [];
        $orderIds[]= $ordInput['ordid'];
        $orders = $ci->common->gettbldata("id IN (" . implode(",", $orderIds) . ")","order_id,customer_id,pickup_datetime,shipmentid,created_source","tb_orders",0,0);
        $bookingIds = $customerIds = $pickUpDates = $createdSource = $customerNames= $shipmentNumbers=$knTrackingNos=[];
        foreach ($orders as $eachRow) {
            $bookingIds[] = $eachRow['order_id'];
            $customerIds[] = $eachRow['customer_id'];
            $pickUpDates[]= $eachRow['pickup_datetime'];
            $createdSource[] = $eachRow['created_source'];
            $shipmentNumbers[] = $eachRow['shipmentid'];
        }
        if (!empty($customerIds)) {
            $customerData = $ci->common->gettbldata("id IN (" . implode(",", $customerIds) . ")", "name", "tb_customers", 0, 0);
            $customerNames = array_merge($customerNames, array_column($customerData, 'name'));
        }
        if (!empty($createdSource)) {
            $referenceId = in_array(18, $createdSource) ? 'AWB' : 'DQ';
            $whereCondition = "order_id IN (" . implode(",", $orderIds) . ") AND reference_id = '" . $referenceId . "' AND status = '1'";
            $trackingData = $ci->common->gettbldata($whereCondition, "ref_value", "tb_order_references", 0, 0);
            $knTrackingNos = array_merge($knTrackingNos, array_column($trackingData, 'ref_value'));
        }
        if ($ordInput['tdrivernum'] != "" && $ordInput['tdrivernum'] >0) {
            $customerName = implode(", ", $customerNames);
            $pickUpDate = implode(
                ", ",
                array_map(function ($date) {
                    return substr($date, 0, 10);
                }, $pickUpDates)
            );
            $bookingID = implode(", ", $bookingIds);
            $tripNo = implode(", ", $shipmentNumbers);
            $knTrackingNo = implode(", ", $knTrackingNos);
            $message = "New trip is assigned" . " "
                . "Pickup Date: " . $pickUpDate . " "
                . "Customer Name: " . $customerName . " "
                . "Booking ID: " . $bookingID . " "
                . "Trip No: " . $tripNo . " "
                . "KN tracking No: " . $knTrackingNo;
            $messageData = json_encode(["msg" => $message, "info" => (object)[], "type"=>1],JSON_UNESCAPED_UNICODE);
            $ci->load->library('sendfirebase');
            $fire_ret = $ci->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $ordInput['tdrivernum'], 'type' => 'Driver']);
        }
    }
}
