<?php

require_once APPPATH . 'libraries/UnitFormatter.php';
require_once APPPATH . 'libraries/UnitConverter.php';

if (!function_exists('uom_value')) {

    /**
     * Returns value automatically converted to proper unit of measure.
     * Value usually is numeric, but sometimes can be null or empty string.
     * Conversion is based on specified unit.
     * Rounds returned value to specified decimal points.
     * Will return same value if conversion is not needed.
     *
     * @param mixed $value
     * @param ?string $unit
     * @param int $decimals
     * @return ?float
     */
    function uom_value($value, ?string $unit = null, int $decimals = 2): ?float
    {
        $converted = new UnitConverter((float) $value, $unit);
        $formatted = new UnitFormatter($converted->get_value(), $converted->get_unit(), $decimals);
        return $formatted->get_value();
    }

}

if (!function_exists('uom_symbol')) {

    /**
     * Returns pretty formatted unit automatically converted to proper unit of measure.
     * Will return same unit if conversion is not needed.
     *
     * @param ?string $unit
     * @return string
     */
    function uom_symbol(?string $unit): string
    {
        // dummy conversion just to get normalized unit symbol in metric or imperial
        $converted = new UnitConverter(null, $unit);
        return (string) new UnitFormatter($converted->get_value(), $converted->get_unit());
    }

}

if (!function_exists('uom_string')) {

    /**
     * Returns pretty formatted string automatically converted to proper unit of measure.
     * Value usually is numeric, but sometimes can be null or empty string.
     * Conversion is based on specified unit.
     * Rounds returned value to specified decimal points.
     * Will return same value if conversion is not needed.
     *
     * @param mixed $value
     * @param ?string $unit
     * @param int $decimals
     * @return float
     */
    function uom_string($value, ?string $unit = null, int $decimals = 2): string
    {
        $converted = new UnitConverter((float) $value, $unit);
        return (string) new UnitFormatter($converted->get_value(), $converted->get_unit(), $decimals);
    }

}

if (!function_exists('uom_raw_value')) {

    /**
     * Returns value without unit of measure conversion.
     * Value usually is numeric, but sometimes can be null or empty string.
     * Rounds returned value to specified decimal points.
     *
     * @param mixed $value
     * @param ?string $unit
     * @param int $decimals
     * @return ?float
     */
    function uom_raw_value($value, ?string $unit = null, int $decimals = 2): ?float
    {
        $formatted = new UnitFormatter((float) $value, $unit, $decimals);
        return $formatted->get_value();
    }

}

if (!function_exists('uom_raw_symbol')) {

    /**
     * Returns pretty formatted unit without unit of measure conversion.
     *
     * @param ?string $unit
     * @return string
     */
    function uom_raw_symbol(?string $unit): string
    {
        return (string) new UnitFormatter(null, $unit);
    }

}

if (!function_exists('uom_raw_string')) {

    /**
     * Returns pretty formatted string without unit of measure conversion.
     * Value usually is numeric, but sometimes can be null or empty string.
     * Rounds returned value to specified decimal points.
     *
     * @param mixed $value
     * @param ?string $unit
     * @param int $decimals
     * @return float
     */
    function uom_raw_string($value, ?string $unit = null, int $decimals = 2): string
    {
        return (string) new UnitFormatter((float) $value, $unit, $decimals);
    }

}
