<?php

if( !function_exists('browsersLanguageDetection')){
  /**
   * To detect languages from the browser request,
   * @param string optional $clientLangHeader It accepts client header ['HTTP_ACCEPT_LANGUAGE'] header
   * @return string It returns language name
   * */

  function browsersLanguageDetection(?string $clientLangHeader = ''): string
  {
      $clientLangHeaderArr = explode(',', $clientLangHeader);
      if (empty($clientLangHeaderArr)) {
        return WEBLINK_DRIVER_APP_DEFAULT_LANG; // default lang
      }

      $supportedLanguage = (is_string(WEBLINK_DRIVER_APP_SUPPORTED_LANGUAGES)) ? json_decode(WEBLINK_DRIVER_APP_SUPPORTED_LANGUAGES, true) : WEBLINK_DRIVER_APP_SUPPORTED_LANGUAGES;

      // filter client languages list
      $clientLanguages = [];
      foreach ($clientLangHeaderArr as $clientLang) {
        /*
         *  get the { ShortCode } and { Priority } form the client browser header,
         *  if explode got only single value then it will add default value : 1 means high priority
         *  https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Language
        */
        [$langShortCode, $langPriority] = array_pad(explode(';', $clientLang, 2), 2, 1);
        sscanf($langPriority, "q=%f", $langPriority); // scan lang priority on float and store to { $langPriority }
        $clientLanguages[] = [ strtolower($langShortCode) => number_format($langPriority, 2) ]; // result array :: [ 'fr' => 1, 'en' => 0.9 ]
      }
      // sort client languages based on priority
      asort($clientLanguages,SORT_NUMERIC);
      log_info('ClientLangs :: ' . json_encode($clientLanguages, JSON_PRETTY_PRINT));

      // Check them all, until we find a match
      foreach ($clientLanguages as $clientLanguage) {
        $clientLangCheckKey = array_key_first($clientLanguage);
        // Check it's in the array. If so, break the loop, we have one!
        if (array_key_exists($clientLangCheckKey, $supportedLanguage)) {
         return $supportedLanguage[$clientLangCheckKey];
        }
      }

    return WEBLINK_DRIVER_APP_DEFAULT_LANG;
  }
}
