<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Altovaordercreation
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'Order', 'altovaordercreationmodel']);
    }

    public function sendOrderToAltova(int $order_id, string $statusCode = ""): void
    {
        if ($order_id == "") {
            log_message("error", "empty order triggered to  altova ");
            return;
        }
        $altovaCustomer = $this->ci->altovaordercreationmodel->checkAltovaCustomer($order_id);
        if ($altovaCustomer == 0) {
            log_message("error", "Customer Does not have permission to send order to Altova " . $order_id);
            return;
        }

        $orderDetails = $this->ci->Order->getordertoedit($order_id);
        $customerdetails = [];
        if ($orderDetails->num_rows() > 0) {
            $parties = [];
            $pickup_id = $orderDetails->row()->customer_id;
            $customerdetails = $this->ci->altovaordercreationmodel->getPickupDetails($pickup_id);
            $customerReferences = $this->ci->common->getPartyReferences($pickup_id);
            $customerdetails['references'] = $customerReferences;
            //  log_message("error", "Order Customer Details " . json_encode($customerdetails));
            $consigneeMobile = $consignorMobile = $shipperMobile = $carrier_mobile = "";
            $partyDetailsInfo = $this->ci->altovaordercreationmodel->getPartyDetails($order_id);

            $shipper_id = $pickup_state = $pickup_email = $consignee_id = $delivery_state = $delivery_email = "";
            if (!empty($partyDetailsInfo)) {
                foreach ($partyDetailsInfo as $party) {
                    $partyDetails = [];
                    $partyType = $party->party_type;
                    $partyTypeid = $party->id;
                    $getpartyinfo = $this->ci->common->gettbldata(["partner_id" => $partyTypeid, "status" => '1'], "*", "tb_party_reference", 0, 0);
                    $checkPartyType = $this->ci->altovaordercreationmodel->getPartyType($partyType);
                    if (!empty($checkPartyType)) {
                        if ($party->party_master_id != "") {
                            $partyDetails = ['name' => $party->name, 'party_id' => $party->code, 'address' => $party->paddress, 'pincode' => $party->ppincode, 'country' => $party->pcountry, 'street' => $party->pstreet,  'house_number' => $party->house_number, 'city' => $party->plocation_id, 'state' => $party->pstate, 'phone' => $party->mobile, 'email' => $party->email, 'latitude' => $party->latitude, 'longitude' => $party->longitude, 'party_references' => $getpartyinfo];
                        } else {
                            $partyDetails = ['name' => $party->name, 'party_id' => $party->code, 'address' => $party->address, 'pincode' => $party->pincode, 'country' => $party->country, 'street' => $party->street, 'house_number' => $party->house_number, 'city' => $party->location_id, 'state' => $party->state, 'phone' => $party->mobile, 'email' => $party->email, 'latitude' => $party->latitude, 'longitude' => $party->longitude, 'party_references' => $getpartyinfo];
                        }
                        if ($checkPartyType->row()->name == "Consignee") {
                            $partyDetails['type'] = "Consignee";
                            $consigneeMobile = $party->mobile;
                            $consignee_id = $party->code;
                            $delivery_state = $party->state ?? $orderDetails->row()->delivery_address2;
                            $delivery_email = $party->email;
                            $delivery_house_number = $party->house_number;
                        }

                        if ($checkPartyType->row()->name == "Consignor") {
                            $consignorMobile = $party->mobile;
                            $consigneer_id = $party->code;
                            $delivery_states = $party->state;
                        }

                        if ($checkPartyType->row()->name == "Shipper") {
                            $shipperMobile = $party->mobile;
                            $shipper_id = $party->code;
                            $pickup_state = $party->state ?? $orderDetails->row()->pickup_address2;
                            $pickup_email = $party->email;
                            $pickup_house_number = $party->house_number;
                        }
                        if ($checkPartyType->row()->name == "Carrier") {
                            $carrier_mobile = $party->mobile;
                        }
                        if ($checkPartyType->row()->name == "Customer") {
                            $customerdetails['house_number'] = $party->house_number;
                        }

                        $partyDetails['type'] = $checkPartyType->row()->name;
                        $parties[] = $partyDetails;
                    }
                }
            }
            //log_message("error", "Order Party Details " . json_encode($parties));

            $areacodes = ["1", "2", "3", "10", "11", "12", "673", "653", "645", "644", "635", "629", "628", "627", "624", "6", "5", "4", "29", "28", "27", "26", "25", "24", "23", "22", "21", "20", "19", "18", "17", "16", "15", "14", "13", "675", "676", "677", "678", "7", "8", "9"];

            $companyCode = $orderDetails->row()->company_code;
            $branchCode = $orderDetails->row()->branch_code;
            $getUserTimeZone = $this->ci->altovaordercreationmodel->getOrderUserTimeZone($orderDetails->row()->user_id);
            $curtz = $getUserTimeZone['cntry_timezone'];
            $hrs = $getUserTimeZone['cntry_hrs'];
            $currency = $getUserTimeZone['currency'] ?? "SGD";
            $countryCode = [
                "THKN" => 66,
                "SGKN" => 65,
                "INKN" => 91
            ];
            $code = $getUserTimeZone['phone_code'] ?? $countryCode[$companyCode];
            $getCargos = $this->ci->altovaordercreationmodel->getCargoDetails($order_id);
            $orderType = ($orderDetails->row()->order_type != "") ? $this->ci->altovaordercreationmodel->getOrderType($orderDetails->row()->order_type) : "";
            $orderService = ($orderDetails->row()->service > 0) ? $this->ci->altovaordercreationmodel->getOrderService($orderDetails->row()->service) : "";
            $valueAddedServices = $this->ci->altovaordercreationmodel->getValueAddedServices($order_id);
            $refrences = $this->ci->altovaordercreationmodel->getOrderReferences($order_id);
            $sourceReferences = $this->ci->altovaordercreationmodel->getPartyRefereces($orderDetails->row()->pickup_custid);
            //  log_message("error", "Order  sourceReferences Details " . json_encode($sourceReferences));
            $destinationReferences = $this->ci->altovaordercreationmodel->getPartyRefereces($orderDetails->row()->drop_partyid);
            // log_message("error", "Order  destinationReferences Details " . json_encode($destinationReferences));
            $delivery_term_id = $orderDetails->row()->delivery_term;
            $delivery_term_name = "";
            if ($delivery_term_id != "") {
                $delivery_term_name = $this->ci->altovaordercreationmodel->getDeliveryTermName($delivery_term_id);
            }
            $LogicalSender = $orderDetails->row()->logicalsender;
            $PhysicalReceiver = $orderDetails->row()->physicalreceiver;
            $LogicalReceiver = $orderDetails->row()->logicalreceiver;
            $PhysicalSender = $orderDetails->row()->physicalsender;

            $logicalinfo = $this->ci->common->gettblrowdata(
                ['branch_code' => $branchCode],
                "logical_sender",
                "tb_branch_master",
                0,
                0
            );
            if (count($logicalinfo) > 0) {
                $LogicalSender = $logicalinfo['logical_sender'];
            }

            $data = [
                'SenderTransmissionNo' => $orderDetails->row()->order_id,
                'pickup_datetime' => $orderDetails->row()->pickup_datetime,
                'delivery_datetime' => $orderDetails->row()->delivery_datetime,
                'pickup_endtime' => $orderDetails->row()->pickup_endtime,
                'delivery_endtime' => $orderDetails->row()->drop_endtime,
                "delivery_company" => $orderDetails->row()->delivery,
                'shipper_id' => $shipper_id,
                'delivery_contact' => $consigneeMobile,
                'delivery_city' => $orderDetails->row()->delivery_city,
                'delivery_country' => $orderDetails->row()->delivery_country,
                'delivery_address1' => $orderDetails->row()->delivery_address1,
                'delivery_address2' => $orderDetails->row()->delivery_address2,
                'delivery_pincode' => $orderDetails->row()->delivery_pincode,
                'branch_code' => $branchCode,
                'company_code' => $companyCode,
                'transport_mode' => $orderDetails->row()->transport_mode,
                'pickup_country' => $orderDetails->row()->pickup_country,
                'pickup_pincode' => $orderDetails->row()->pickup_pincode,
                'country_code' => $code,
                "pickup_company" => $orderDetails->row()->pickup,
                'pickup_contact' => $consignorMobile ?? $shipperMobile,
                'pickup_city' => $orderDetails->row()->pickup_city,
                'pickup_address1' => $orderDetails->row()->pickup_address1,
                'pickup_address2' => $orderDetails->row()->pickup_address2,
                'cargos' => $getCargos,
                "area_code" => $areacodes[1],
                "goods_value" => $orderDetails->row()->goods_value,
                "currency" => $currency,
                "parties" => $parties,
                "customerdetails" => $customerdetails,
                'order_type' => $orderType,
                'product' => $orderDetails->row()->product,
                'service' => $orderService,
                'incoterm' => $orderDetails->row()->incoterm,
                'quantity' => $orderDetails->row()->quantity,
                'volume' => $orderDetails->row()->volume,
                'weight' => $orderDetails->row()->weight,
                'refrences' => $refrences,
                'valueAddser' => $valueAddedServices,
                'department_code' => $orderDetails->row()->department_code,
                "hrs" => $hrs,
                "curtz" => $curtz,
                'plat' => $orderDetails->row()->plat,
                'plng' => $orderDetails->row()->plng,
                'dlat' => $orderDetails->row()->dlat,
                'dlng' => $orderDetails->row()->dlng,
                'sourceReferences' => $sourceReferences,
                'destinationReferences' => $destinationReferences,
                'pickup_state' => $pickup_state,
                'pickup_email' => $pickup_email,
                'pickup_house_number' => $pickup_house_number,
                'delivery_house_number' => $delivery_house_number,
                'consignee_id' => $consignee_id,
                'delivery_state' => $delivery_state,
                'delivery_email' => $delivery_email,
                'delivery_term_id' => $delivery_term_id,
                'delivery_term_name' => $delivery_term_name,
                'logicalreceiver' => $LogicalReceiver,
                'physicalreceiver' => $PhysicalReceiver,
                'physicalsender' => $PhysicalSender,
                'logicalsender' => $LogicalSender,
                'volume_unit' => "CBM",
                'weight_unit' => "KG"
            ];
            //log_message("error", "Order Data " . json_encode($data));
            $this->generateElg360orderxml($data, $statusCode);
        }
    }

    private function generateElg360orderxml(array $data, string $statusCode): void
    {
        $order_id = $data['SenderTransmissionNo'];
        $date = date("Ymdhis");
        $request = '';
        $request .= '<SVKEDIMessage>';
        $request .= '<SVKEDIOrderHeader>';
        $request .= '<Version>1.0</Version>';
        $request .= '<UserName>Svkonekt</UserName>';
        $request .= '<Password>Svkonekt</Password>';
        $request .= '<SenderTransmissionNo>' . $data['SenderTransmissionNo'] . '_' . $date . '</SenderTransmissionNo>';
        $request .= '<AckSpec>';
        $request .= '<EmailAddress>dummy@email.com</EmailAddress>';
        $request .= '<AckOption>SUCCESS</AckOption>';
        $request .= '</AckSpec>';
        $request .= '<SourceApp>Svkonekt</SourceApp>';
        $request .= '<DestinationApp>ETRA</DestinationApp>';
        $request .= '<ReferenceId>' . $data['SenderTransmissionNo'] . '</ReferenceId>';
        $request .= '<Action>IU</Action>';
        $request .= '</SVKEDIOrderHeader>';
        $request .= '<SVKEDIOrderBody>';
        $request .= '<eTNOrgDetails>';
        $request .= '<Companycode>' . $data['company_code'] . '</Companycode>';
        $request .= '<Branchcode>' . $data['branch_code'] . '</Branchcode>';
        $request .= '<Departmentcode>' . $data['department_code'] . '</Departmentcode>';
        $request .= '<PhysicalReceiver>' . $data['physicalreceiver'] . '</PhysicalReceiver>';
        $request .= '<LogicalReceiver>' . $data['logicalreceiver'] . '</LogicalReceiver>';
        $request .= '<PhysicalSender>' . $data['physicalsender'] . '</PhysicalSender>';
        $request .= '<LogicalSender>' . $data['logicalsender'] . '</LogicalSender>';
        $request .= '</eTNOrgDetails>';
        $request .= '<OrderID>' . $data['SenderTransmissionNo'] . '</OrderID>';
        $request .= '<EXTOrderID></EXTOrderID>';
        $request .= '<Transits><TransitLegId></TransitLegId></Transits>';
        $request .= '<OrderType>' . $data['order_type'] . '</OrderType>';
        $request .= '<ModeOfTransport>' . str_replace("&", "AND", $data['transport_mode']) . '</ModeOfTransport>';
        $request .= '<Product>' . str_replace("&", "AND", $data['product']) . '</Product>';
        $request .= '<ServiceType>' . str_replace("&", "AND", $data['service']) . '</ServiceType>';
        $request .= '<TypeOfBusiness>DOMESTIC</TypeOfBusiness>';
        $request .= '<TermsOfTrade>';
        $request .= '<Incoterm>' . $data['incoterm'] . '</Incoterm>';
        $request .= "<FreightName>
                        <Term>" . $data['delivery_term_id'] . "</Term>
                        <Name>" . $data['delivery_term_name'] . "</Name>
                    </FreightName>";
        $request .= '</TermsOfTrade>';
        $request .= $this->getCustomerXML($data['customerdetails'], $data['country_code']);
        $request .= '<LocationInfo>';
        $request .= $this->getSourceLocationXML($data);
        $request .= $this->getDestinationLocationXML($data);
        $request .= '</LocationInfo>';
        $request .= "<CargoSummary>
                        <TotalQuantity>
                        <Value>" . $data['quantity'] . "</Value>
                        <UOM>Numbers</UOM>
                        </TotalQuantity>
                        <TotalVolume>
                        <Value>" . $data['volume'] . "</Value>
                        <UOM>" . $data['volume_unit'] . "</UOM>
                        </TotalVolume>
                        <TotalWeight>
                        <Value>" . $data['weight'] . "</Value>
                        <UOM>" . $data['weight_unit'] . "</UOM>
                        </TotalWeight>
                    </CargoSummary>";
        $request .= $this->getCargoXML($data);

        if (count($data['valueAddser']) > 0) {
            $request .= $this->getValueAddedServicesXML($data);
        } else {
            $request .= '<ValueAddedServices/>';
        }
        $request .= $this->getInvolvedParties($data);
        $request .= '<ManageReferences>';
        if (count($data['refrences']) > 0) {
            foreach ($data['refrences'] as $refreid) {
                $request .= '<References>';
                $request .= '<RefType>';
                $request .= '<Code>' . $refreid['reference_id'] . '</Code>';
                $request .= '<Value>' . $refreid['ref_value'] . '</Value>';
                $request .= '</RefType>';
                $request .= '</References>';
            }
        }
        $request .= '</ManageReferences>';
        $request .= '<Remarks/>';
        if ($statusCode != "") {
            $altovaCustomer = $this->ci->altovaordercreationmodel->checkCustomerStatus($data['SenderTransmissionNo']);
            if ($altovaCustomer == 0) {
                log_message("error", "Customer Does not have permission to send Status_xml_format F" . $order_id);
                return;
            }
            $request .= $this->getTripStatusInfo($data['SenderTransmissionNo'], $statusCode);
        }
        $request .= '</SVKEDIOrderBody>';
        $request .= '</SVKEDIMessage>';
        $request = str_replace("&", "AND", $request);
        $request = str_replace("amp;", "", $request);
        $request = str_replace(";", ",", $request);
        $resname = date("Ymdhis");
        $dom = new DOMDocument;
        $dom->preserveWhiteSpace = false;
        $dom->loadXML($request);
        $dom->save('xml/ORDKN' . $order_id . $resname . '.xml');
        log_message("error", "File name for Booking xml/ORDKN" . $order_id . $resname . ".xml");
        $this->sendElg360order($request, $statusCode);
    }

    private function getInvolvedParties(array $data): string
    {
        $request = '<InvolvedParties>';
        if (count($data['parties']) > 0) {
            foreach ($data['parties'] as $partyType) {
                $request .= "<PartyType type='" . $partyType['type'] . "'>";
                $request .= '<ID>' . $partyType['party_id'] . '</ID>';
                $request .= '<Company>';
                $request .= '<Name>' . str_replace("&", "AND", $partyType['name']) . '</Name>';
                $request .= '<RegistrationNumber>' . $partyType['party_id'] . '</RegistrationNumber>';
                $request .= '</Company>';
                $request .= '<Address>';
                $request .= '<FirstName>' . str_replace("&", "AND", $partyType['name']) . '</FirstName>';
                $request .= '<LastName>' . str_replace("&", "AND", $partyType['name']) . '</LastName>';
                $request .= '<FullName>' . str_replace("&", "AND", $partyType['name']) . '</FullName>';
                $request .= '<Address1>' . str_replace("&", "AND", $partyType['address']) . '</Address1>';
                $request .= '<Address2></Address2>';
                $request .= '<HouseNumber>' . str_replace("&", "AND", $partyType['house_number']) . '</HouseNumber>';
                $request .= '<Street>' . str_replace("&", "AND", $partyType['street']) . '</Street>';
                $request .= '<City>' . str_replace("&", "AND", $partyType['city']) . '</City>';
                $request .= '<State>' . str_replace("&", "AND", $partyType['state']) . '</State>';
                $request .= '<Postal>' . str_replace("&", "AND", $partyType['pincode']) . '</Postal>';
                $request .= '<Country>' . str_replace("&", "AND", $partyType['country']) . '</Country>';
                $request .= '<Latitude>' . $partyType['latitude'] . '</Latitude>';
                $request .= '<Longitude>' . $partyType['longitude'] . '</Longitude>';
                $request .= '<ContactInfo>';
                $request .= '<CountryCode>' . $data['country_code'] . '</CountryCode>';
                if ($partyType['phone'] != "") {
                    $request .= '<ContactNo>' . $partyType['phone'] . '</ContactNo>';
                } else {
                    $request .= '<ContactNo></ContactNo>';
                }

                $request .= '<EmailAddress>' . $partyType['email'] . '</EmailAddress>';
                $request .= '</ContactInfo>';
                $request .= '</Address>';
                if ($partyType['type'] == "Consignor") {
                    $request .= '<Comments></Comments>';
                }
                if ($partyType['type'] == "Consignee") {
                    $request .= '<Comments></Comments>';
                }
                if (count($partyType['party_references']) > 0) {
                    $request .= "<PartyReference>";
                    foreach ($partyType['party_references'] as $partyref) {
                        $request .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
                    }
                    $request .= " </PartyReference>";
                }
                $request .= '</PartyType>';
            }
        }
        $request .= '</InvolvedParties>';
        return $request;
    }

    private function getValueAddedServicesXML(array $data): string
    {
        $request = '<ValueAddedServices>';
        foreach ($data['valueAddser'] as $addons) {
            $request .= '<Addon>';
            $request .= '<AddonName>' . $addons['vas_name'] . '</AddonName>';
            $request .= '<AddonCode>' . $addons['vas_id'] . '</AddonCode>';
            $request .= '<Currency></Currency>';
            $request .= '<RateUnit></RateUnit>';
            $request .= '<AddonAmount></AddonAmount>';
            $request .= '<AddonQuantity>' . $addons['quantity'] . '</AddonQuantity>';
            $request .= '</Addon>';
        }
        $request .= '</ValueAddedServices>';
        return $request;
    }

    private function getCargoXML(array $data): string
    {
        $request = '<CargoDetails>';
        $companyCode = $data['company_code'];
        foreach ($data['cargos'] as $cargo) {
            $length = $cargo['length'];
            $width = $cargo['width'];
            $height = $cargo['height'];
            $lengthUnit = $cargo['length_unit'];
            $widthUnit = $cargo['width_unit'];
            $heightUnit = $cargo['height_unit'];
            if ($companyCode == "NZKN" && $length == 0) {
                $length = $lengthUnit = "";
            }
            if ($companyCode == "NZKN" && $width == 0) {
                $width = $widthUnit = "";
            }
            if ($companyCode == "NZKN" && $height == 0) {
                $height = $heightUnit = "";
            }
            $request .= "<TransportHandlingUnit>
                <CargoType>" . str_replace("&", "AND", $cargo['cargo_type']) . "</CargoType>
                <GoodsDescription>" . str_replace("&", "AND", $cargo['goods_description']) . "</GoodsDescription>
                <MarksandNumbers>" . $cargo['marks_numbers'] . "</MarksandNumbers>
                <ValueOfGoods>" . $data['goods_value'] . "</ValueOfGoods>
                <HandlingUnit>" . $cargo['handling_unit'] . "</HandlingUnit>
                <ItemId>" . $cargo['item_id'] . "</ItemId>
                 <Length>
                    <Value>" . $length . "</Value>
                    <UOM>" . $lengthUnit . "</UOM>
                </Length>
                <Width>
                    <Value>" . $width . "</Value>
                    <UOM>" . $widthUnit . "</UOM>
                </Width>
                <Height>
                    <Value>" . $height . "</Value>
                    <UOM>" . $heightUnit . "</UOM>
                </Height>
                <ActualWeight>
                    <Value>" . $cargo['weight'] . "</Value>
                    <UOM>" . $cargo['weight_unit'] . "</UOM>
                </ActualWeight>
                <Weight>
                    <Value>" . $cargo['second_weight'] . "</Value>
                    <UOM>" . $cargo['secondweight_uom'] . "</UOM>
                </Weight>
                <VolumetricWeight>
                    <Value>" . $cargo['volumetric_weight'] . "</Value>
                    <UOM>" . $cargo['volweight_uom'] . "</UOM>
                </VolumetricWeight>
                <Volume>
                    <Value>" . $cargo['second_volume'] . "</Value>
                    <UOM>" . $cargo['secondvolume_uom'] . "</UOM>
                </Volume>
                <ActualVolume>
                    <Value>" . $cargo['volume'] . "</Value>
                    <UOM>" . $cargo['volume_unit'] . "</UOM>
                </ActualVolume>
                <Quantity>" . $cargo['quantity'] . "</Quantity>
                <ScannedQuantity>" . $cargo['scanned_quantity'] . "</ScannedQuantity>
                <ldm>" . $cargo['ldm'] . "</ldm>
                <GroundedFlag>" . $cargo['grounded'] . "</GroundedFlag>
                <StackableFlag>" . $cargo['stackable'] . "</StackableFlag>
                <SplittableFlag>" . $cargo['splittable'] . "</SplittableFlag>
                <DangerousGoodsFlag>" . $cargo['dg_goods'] . "</DangerousGoodsFlag>";
                $dggoods = "";
                $dgpackgecount = 0;
                if (!empty($cargo['dggoods'])) {
                    $dggoods .= "<DangerousGoods>";
                    foreach ($cargo['dggoods'] as $dgGoodsCargo) {
                        $dgpackgecount += (int)$dgGoodsCargo['num_pkgs'];
                        $dggoods .= "<DangerousGoodsPosition>";
                        $dggoods .= "<NumberOfPackages><Value>" . $dgGoodsCargo['num_pkgs'] . "</Value><QuantityType>" . $dgGoodsCargo['pkg_qty_type'] . "</QuantityType></NumberOfPackages>";
                        $dggoods .= "<DangerousGoodsDetails>";
                        $dggoods .= "<DangerousGoodsQuantity><Value>" . $dgGoodsCargo['quantity'] . "</Value><QuantityType>" . $dgGoodsCargo['quantity_type'] . "</QuantityType></DangerousGoodsQuantity>";
                        $dggoods .= "<UnitedNationsOrganisationNumber><Value>" . $dgGoodsCargo['org_number'] . "</Value><Variant>" . $dgGoodsCargo['org_num_varient'] . "</Variant></UnitedNationsOrganisationNumber>";
                        $dggoods .= "<DangerousGoodsClass>" . $dgGoodsCargo['db_class'] . "</DangerousGoodsClass>";
                        $dggoods .= "<MainRisk>" . $dgGoodsCargo['mainrisk'] . "</MainRisk>";
                        $dggoods .= "<SubsidiaryRisks>" . $dgGoodsCargo['subsidiary_risks'] . "</SubsidiaryRisks>";
                        $dggoods .= "<PackingGroup>" . $dgGoodsCargo['packing_group'] . "</PackingGroup>";
                        $dggoods .= "<DangerousGoodsDescriptions><Language>EN</Language><ProperShippingName>" . $dgGoodsCargo['org_name'] . "</ProperShippingName></DangerousGoodsDescriptions>";
                        $dggoods .= "<LimitedQuantityFlag>" . $dgGoodsCargo['limitqty_flag'] . "</LimitedQuantityFlag>";
                        $dggoods .= "<ExceptedQuantityFlag>" . $dgGoodsCargo['exceptqty_flag'] . "</ExceptedQuantityFlag>";
                        $dggoods .= "<HighConsequence></HighConsequence>";
                        $dggoods .= "<Roadfreight>";
                        $dggoods .= "<TunnelRestrictionCode>" . $dgGoodsCargo['tunnel_restriction_code'] . "</TunnelRestrictionCode>";
                        $dggoods .= "<TransportCategory>" . $dgGoodsCargo['transport_category'] . "</TransportCategory>";
                        $dggoods .= "<EnvironmentallyHazardous>" . $dgGoodsCargo['environment_hazardous'] . "</EnvironmentallyHazardous>";
                        $dggoods .= "<NOS>" . $dgGoodsCargo['nos'] . "</NOS>";
                        $dggoods .= "<ADRMultiplicator>" . $dgGoodsCargo['adr_multiplicator'] . "</ADRMultiplicator>";
                        $dggoods .= "<TotalADRPoints>" . $dgGoodsCargo['total_adr_points'] . "</TotalADRPoints>";
                        $dggoods .= "<ADRVersion>" . $dgGoodsCargo['adr_version'] . "</ADRVersion>";
                        $dggoods .= "</Roadfreight>";
                        $dggoods .= "</DangerousGoodsDetails>";
                        $dggoods .= "</DangerousGoodsPosition>";
                    }
                    $dggoods .= "</DangerousGoods>";
                }

                $request .= "<TotalPackagesOfDangerousGoods>" . $dgpackgecount . "</TotalPackagesOfDangerousGoods>";
                $request .= $dggoods;
            if (count($cargo['inner_cargo']) > 0) {
                foreach ($cargo['inner_cargo'] as $inn_cargo) {
                    $request .= " <Packagingunit>
                        <PackageType>" . $inn_cargo['cargo_type'] . "</PackageType>
                        <PackageDescription>" . $inn_cargo['goods_description'] . "</PackageDescription>
                        <Quantity>" . $inn_cargo['quantity'] . "</Quantity>
                        <Length>
                            <Value>" . $inn_cargo['length'] . "</Value>
                            <UOM>" . $inn_cargo['length_unit'] . "</UOM>
                        </Length>
                        <Width>
                            <Value>" . $inn_cargo['width'] . "</Value>
                            <UOM>" . $inn_cargo['width_unit'] . "</UOM>
                        </Width>
                        <Height>
                            <Value>" . $inn_cargo['height'] . "</Value>
                            <UOM>" . $inn_cargo['height_unit'] . "</UOM>
                        </Height>
                        <Weight>
                            <Value>" . $inn_cargo['weight'] . "</Value>
                            <UOM>" . $inn_cargo['weight_unit'] . "</UOM>
                        </Weight>
                        <Volume>
                            <Value>" . $inn_cargo['volume'] . "</Value>
                            <UOM>" . $inn_cargo['volume_unit'] . "</UOM>
                        </Volume>
                        </Packagingunit>";
                }
            }
            $request .= "
            </TransportHandlingUnit>";
        }

        $request .= '</CargoDetails>';
        return $request;
    }

    private function getCustomerXML(array $customerDetails, string $countryCode): string
    {
        $request = '<CustomerDetails>';
        $request .= '<ID>' . $customerDetails['party_id'] . '</ID>';
        $request .= '<Company>';
        $request .= '<Name>' . str_replace("&", "AND", $customerDetails['name']) . '</Name>';
        $request .= '<RegistrationNumber>' . $customerDetails['party_id'] . '</RegistrationNumber>';
        $request .= '</Company>';
        $request .= '<Address>';
        $request .= '<CustomerName>' . str_replace("&", "AND", $customerDetails['name']) . '</CustomerName>';
        $request .= '<Address1></Address1>';
        $request .= "<Address2></Address2>";
        $request .= '<HouseNumber>' . str_replace("&", "AND", $customerDetails['house_number']) . '</HouseNumber>';
        $request .= '<Street>' . str_replace("&", "AND", $customerDetails['street']) . '</Street>';
        $request .= '<City>' . str_replace("&", "AND", $customerDetails['city']) . '</City>';
        $request .= '<State>' . str_replace("&", "AND", $customerDetails['state']) . '</State>';
        $request .= '<Postal>' . $customerDetails['pincode'] . '</Postal>';
        $request .= '<Country>' . str_replace("&", "AND", $customerDetails['country']) . '</Country>';
        $request .= '<ContactInfo>';
        $request .= '<CountryCode>' . $countryCode . '</CountryCode>';
        $request .= '<ContactNo>' . $customerDetails['phone'] . '</ContactNo>';
        $request .= '<EmailAddress>' . $customerDetails['email'] . '</EmailAddress>';
        $request .= '</ContactInfo>';
        $request .= '</Address>';
        if (count($customerDetails['references']) > 0) {
            $request .= "<PartyReference>";
            foreach ($customerDetails['references'] as $partyref) {
                $request .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
            }
            $request .= " </PartyReference>";
        }
        $request .= '</CustomerDetails>';
        return $request;
    }

    private function getDestinationLocationXML(array $data): string
    {
        $request = '<Destination>';
        $request .= '<ID>' . $data['consignee_id'] . '</ID>';
        $request .= '<Company>';
        $request .= '<Name>' . str_replace("&", "AND", $data['delivery_company']) . '</Name>';
        $request .= '<RegistrationNumber>' . $data['consignee_id'] . '</RegistrationNumber>';
        $request .= '</Company>';
        $request .= '<Address>';
        $request .= '<CompanyName>' . str_replace("&", "AND", $data['delivery_company']) . '</CompanyName>';
        $request .= '<Address1></Address1>';
        $request .= '<Address2></Address2>';
        $request .= '<HouseNumber>' . str_replace("&", "AND", $data['delivery_house_number']) . '</HouseNumber>';
        $request .= '<Street>' . str_replace("&", "AND", $data['delivery_address1']) . '</Street>';
        $request .= '<City>' . str_replace("&", "AND", $data['delivery_city']) . '</City>';
        $request .= '<State>' . str_replace("&", "AND", $data['delivery_state']) . '</State>';
        $request .= '<Postal>' . $data['delivery_pincode'] . '</Postal>';
        $request .= '<Country>' . str_replace("&", "AND", $data['delivery_country']) . '</Country>';
        $request .= '<Latitude>' . $data['dlat'] . '</Latitude>';
        $request .= '<Longitude>' . $data['dlng'] . '</Longitude>';
        $request .= '<ContactInfo>';
        $request .= '<CountryCode>' . $data['country_code'] . '</CountryCode>';
        $request .= '<ContactNo>' . $data['delivery_contact'] . '</ContactNo>';
        $request .= '<EmailAddress>' . $data['delivery_email'] . '</EmailAddress>';
        $request .= '</ContactInfo>';
        $request .= '</Address>';
        $request .= '<EstimatedDateTime>';
        $request .= '<From>';
        $delivery_datetime = $data['delivery_datetime'];
        if ($data['delivery_datetime'] != "" && $data['delivery_datetime'] != "0000-00-00 00:00:00") {
            $delivery_datetime = getdatetimebytimezone($data['curtz'], $data['delivery_datetime'], DFLT_TZ);
        }

        $request .= '<DateTime>' . date("Y-m-d", strtotime($delivery_datetime['datetime'])) . 'T' . date("H:i:s", strtotime($delivery_datetime['datetime'])) . '.000</DateTime>';
        $request .= '<TimeZone>' . $data['hrs'] . '/' . $data['curtz'] . '</TimeZone>';
        $request .= '<UTC>';
        $request .= '<Time>' . str_replace(" ", "T", $data['delivery_datetime']) . '.000</Time>';
        $request .= '</UTC>';
        $request .= '</From>';
        $request .= '<To>';
        if ($data['delivery_endtime'] != "" && $data['delivery_endtime'] != "0000-00-00 00:00:00") {
            $delivery_endtime = getdatetimebytimezone($data['curtz'], $data['delivery_endtime'], DFLT_TZ);
        }
        $request .= '<DateTime>' . date("Y-m-d", strtotime($delivery_endtime['datetime'])) . 'T' . date("H:i:s", strtotime($delivery_endtime['datetime'])) . '.000</DateTime>';
        $request .= '<TimeZone>' . $data['hrs'] . '/' . $data['curtz'] . '</TimeZone>';
        $request .= '<UTC>';
        $request .= '<Time>' . str_replace(" ", "T", $data['delivery_endtime']) . '.000</Time>';
        $request .= '</UTC>';
        $request .= '</To>';
        $request .= '</EstimatedDateTime>';
        if (count($data['destinationReferences']) > 0) {
            $request .= "<PartyReference>";
            foreach ($data['destinationReferences'] as $partyref) {
                $request .= "<References>
                <RefType>
                <Code>" . str_replace(" ", "_", $partyref['name']) . "</Code>
                <Value>" . $partyref['value'] . "</Value>
                </RefType>
                </References>";
            }
            $request .= " </PartyReference>";
        }
        $request .= '</Destination>';
        return $request;
    }

    private function getSourceLocationXML(array $data): string
    {
        $request = '<Source>';
        $request .= '<ID>' . $data['shipper_id'] . '</ID>';
        $request .= '<Company>';
        $request .= '<Name>' . str_replace("&", "AND", $data['pickup_company']) . '</Name>';
        $request .= '<RegistrationNumber>' . $data['shipper_id'] . '</RegistrationNumber>';
        $request .= '</Company>';
        $request .= '<Address>';
        $request .= '<CompanyName>' . str_replace("&", "AND", $data['pickup_company']) . '</CompanyName>';
        $request .= '<Address1></Address1>';
        $request .= '<Address2></Address2>';
        $request .= '<HouseNumber>' . str_replace("&", "AND", $data['pickup_house_number']) . '</HouseNumber>';
        $request .= '<Street>' . str_replace("&", "AND", $data['pickup_address1']) . '</Street>';
        $request .= '<City>' . str_replace("&", "AND", $data['pickup_city']) . '</City>';
        $request .= '<State>' . str_replace("&", "AND", $data['pickup_state']) . '</State>';
        $request .= '<Postal>' . $data['pickup_pincode'] . '</Postal>';
        $request .= '<Country>' . $data['pickup_country'] . '</Country>';
        $request .= '<Latitude>' . $data['plat'] . '</Latitude>';
        $request .= '<Longitude>' . $data['plng'] . '</Longitude>';
        $request .= '<ContactInfo>';
        $request .= '<CountryCode>' . $data['country_code'] . '</CountryCode>';
        $request .= '<ContactNo>' . $data['pickup_contact'] . '</ContactNo>';
        $request .= '<EmailAddress>' . $data['pickup_email'] . '</EmailAddress>';
        $request .= '</ContactInfo>';
        $request .= '</Address>';
        $request .= '<EstimatedDateTime>';
        $request .= '<From>';
        if ($data['pickup_datetime'] != "" && $data['pickup_datetime'] != "0000-00-00 00:00:00") {
            $pickup_datetime = getdatetimebytimezone($data['curtz'], $data['pickup_datetime'], DFLT_TZ);
        }
        $request .= '<DateTime>' . date("Y-m-d", strtotime($pickup_datetime['datetime'])) . 'T' . date("H:i:s", strtotime($pickup_datetime['datetime'])) . '.000</DateTime>';
        $request .= '<TimeZone>' . $data['hrs'] . '/' . $data['curtz'] . '</TimeZone>';
        $request .= '<UTC>';
        $request .= '<Time>' . str_replace(" ", "T", $data['pickup_datetime']) . '.000</Time>';
        $request .= '</UTC>';
        $request .= '</From>';
        $request .= '<To>';
        if ($data['pickup_endtime'] != "" && $data['pickup_endtime'] != "0000-00-00 00:00:00") {
            $pickup_endtime = getdatetimebytimezone($data['curtz'], $data['pickup_endtime'], DFLT_TZ);
        }
        $request .= '<DateTime>' . date("Y-m-d", strtotime($pickup_endtime['datetime'])) . 'T' . date("H:i:s", strtotime($pickup_endtime['datetime'])) . '.000</DateTime>';
        $request .= '<TimeZone>' . $data['hrs'] . '/' . $data['curtz'] . '</TimeZone>';
        $request .= '<UTC>';
        $request .= '<Time>' . str_replace(" ", "T", $data['pickup_endtime']) . '.000</Time>';
        $request .= '</UTC>';
        $request .= '</To>';
        $request .= '</EstimatedDateTime>';
        if (count($data['sourceReferences']) > 0) {
            $request .= "<PartyReference>";
            foreach ($data['sourceReferences'] as $partyref) {
                $request .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
            }
            $request .= " </PartyReference>";
        }
        $request .= '</Source>';

        return $request;
    }


    private function sendElg360order(string $orderinfo, string $statusCode): void
    {
        $altovaUrl = ($statusCode == "") ? ALTOVA_ORDER_URL : ALTOVA_AMAZON_ORDER_STATUS_URL;
        try {
            log_message("error", "sendElg360order request " . json_encode($orderinfo));
            $data = 'inputFiles=' . $orderinfo;
            $curl = curl_init($altovaUrl);
            curl_setopt($curl, CURLOPT_URL, $altovaUrl);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $headers = ["Content-Type: application/x-www-form-urlencoded"];
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            $response = curl_exec($curl);
            if ($response === false) {
                log_message('error', 'sendElg360order request failed: ' . curl_error($curl));
            }
            log_message("error", "sendElg360order Response" . json_encode($response));
            curl_close($curl);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Order to Altova. " . $ex->getMessage());
        }
    }

    public function getTripStatusInfo(string $bookingID, string $statusCode): string
    {
        $altovaCustomer = $this->ci->altovaordercreationmodel->checkCustomerStatus($bookingID);
        if ($altovaCustomer == 0) {
            log_message("error", "Customer Does not have permission to send Status_xml_format F" . $bookingID);
            return "";
        }
        $requestXML = "";
        $orderTripInfo = $this->ci->altovaordercreationmodel->getOrderTripDetails($bookingID);
        if (!empty($orderTripInfo)) {
            $getUserTimeZone = $this->ci->altovaordercreationmodel->getOrderUserTimeZone($orderTripInfo['user_id']);
            $curtz = $getUserTimeZone['cntry_timezone'];
            $hrs = $getUserTimeZone['cntry_hrs'];
            $currency = $getUserTimeZone['currency'] ?? "SGD";
            $countryCode = ["THKN" => 66, "SGKN" => 65, "INKN" => 91];
            $code = $getUserTimeZone['phone_code'] ?? $countryCode[$orderTripInfo['company_code']];
            $carrierDetails = [];
            if ($orderTripInfo['vendor_id'] != 0) {
                $carrierDetails = $this->ci->altovaordercreationmodel->getOrderCarrier($orderTripInfo['vendor_id']);
            }
            $statusDetails = $this->ci->altovaordercreationmodel->getOrderStatus($orderTripInfo['id'], $statusCode);
            $requestXML .= "<TripOrderDetails>
                  <TripID>" . $orderTripInfo['shipmentid'] . "</TripID>
                  <CarrierDetails>
                    <ID>" . $carrierDetails['code'] . "</ID>
                    <Address>
                      <CompanyName>" . $carrierDetails['name'] . "</CompanyName>
                       <Address1></Address1>
                       <Address2></Address2>
                       <Street>" . $carrierDetails['street'] . "</Street>
                       <City>" . $carrierDetails['city'] . "</City>
                       <State>" . $carrierDetails['state'] . "</State>
                       <Postal>" . $carrierDetails['pincode'] . "</Postal>
                       <Country>" . $carrierDetails['country'] . "</Country>
                       <ContactInfo>
                            <CountryCode>" . $code . "</CountryCode>
                             <ContactNo>" . $carrierDetails['mobile'] . "</ContactNo>
                            <EmailAddress>" . $carrierDetails['email'] . "</EmailAddress>
                       </ContactInfo>
                    </Address>
                    </CarrierDetails>
                <VehicleDetails>
                <VehicleTypeCode>" . $orderTripInfo['trucktype'] . "</VehicleTypeCode>
                <VehicleModelCode>" . $orderTripInfo['truck_brand'] . "</VehicleModelCode>
                <RegistrationNumber>" . $orderTripInfo['register_number'] . "</RegistrationNumber>
                </VehicleDetails>
                <DriverDetails>
                <DriverName>" . $orderTripInfo['drivername'] . "</DriverName>
                <DriverLicence>" . $orderTripInfo['driving_licence_num'] . "</DriverLicence>
                <DriverNationalIdentificationNumber>" . $orderTripInfo['driver_national_identification_number'] . "</DriverNationalIdentificationNumber>
                <ContactNo>" . $orderTripInfo['drivernumber'] . "</ContactNo>
                </DriverDetails>
                </TripOrderDetails>";
        }
        if (!empty($statusDetails)) {
            foreach ($statusDetails as $status) {
                $stop_type = $status['stop_type'] == "" ? "P" : $status['stop_type'];
                $status_name = $status['status_name'] == "" ? $status['status_stage'] : $status['status_name'];
                $statusdatetime = (getdatetimebytimezone($curtz, $status['createdon'], DFLT_TZ))['datetime'];
                $locationName = $status['loc_name'];
                if ($locationName == "") {
                    $locationName = getLocationName($status['latitude'], $status['longitude']);
                    if ($locationName == "") {
                        $getOrderDetails = $this->ci->common->gettblrowdata(['id' => $orderTripInfo['id']], "pickup_city,delivery_city ", "tb_orders", 0, 0);
                        $locationName = ($stop_type != "D") ? $getOrderDetails['pickup_city'] : $getOrderDetails['delivery_city'];
                    }
                }

                $requestXML .= "<Status>
                            <StatusCode>" . $status['status_code'] . "</StatusCode>
                            <StatusValue>" . $status_name . "</StatusValue>
                            <StatusType>" . $stop_type . "</StatusType>
                            <DateTime>" . str_replace(" ", "T", $statusdatetime) . "</DateTime>
                            <TimeZone>" . $curtz . "</TimeZone>
                            <Lat>" . $status['latitude'] . "</Lat>
                            <Lng>" . $status['longitude'] . "</Lng>
                            <CountryCode>" . $code . "</CountryCode>
                            <Location>" . $locationName . "</Location>
                            <NextStopETA>" . str_replace(" ", "T", $status['next_stop_eta']) . "</NextStopETA>
                            <NextStopDuration>" . $status['next_stop_duration'] . "</NextStopDuration>
                            </Status>";
            }
        } else {
            $requestXML .= "<Status></Status>";
        }
        $requestXML .= "<AdditionalInfo><Reason>
			<ReasonCode></ReasonCode>
			<ReasonDescription></ReasonDescription>
			<RemarkCode></RemarkCode>
			<RemarkDescription></RemarkDescription>
			</Reason></AdditionalInfo>";


        return str_replace(['&', 'amp;', ';'], ['AND', '', ','], $requestXML);
    }
}
