<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Amazonexceldtohandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'amazonexceldtomodel',]);
    }

    public function pullAmazonOrderXml(array $data): void
    {
        $filterData = $this->generateOrderData($data);
        if (1 == $filterData['status']) {
            echo "Order Creation Failed, : " . $filterData['message'];
            return;
        }
        $orderData = $filterData['data'];
        $customerCode = $orderData['customerID'];
        $user_id = $this->ci->amazonexceldtomodel->getUserId($orderData);
        $timeZone = $this->ci->amazonexceldtomodel->getUserTimeZone($user_id);
        $customerId = $this->ci->amazonexceldtomodel->getcustomerId($customerCode);
        $shipperInfo = $this->ci->amazonexceldtomodel->getPartyDetails($orderData['sourceInfo']['ID']);
        if (empty($shipperInfo)) {
            echo "Order Creation Failed, : Invalid International Origin " . $orderData['sourceInfo']['ID'];
            return;
        }
        $consigneeInfo = $this->ci->amazonexceldtomodel->getPartyDetails($orderData['destinationInfo']['ID']);
        if (empty($consigneeInfo)) {
            echo "Order Creation Failed, : Invalid International Destination " . $orderData['sourceInfo']['ID'];
            return;
        }
        $shipmentId = $this->insertShipmentData($orderData);
        $e_pickup = str_replace("T", " ", $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']);
        $l_pickup = str_replace("T", " ", $orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']);
        $e_delivery = str_replace("T", " ", $orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']);
        $l_delivery = str_replace("T", " ", $orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']);
        $getpickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $timeZone);
        $e_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $timeZone);
        $l_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $timeZone);
        $e_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $timeZone);
        $l_delivery = $getldelivery['datetime'];
        $pickuplatitude = $shipperInfo['latitude'];
        $pickuplongitude = $shipperInfo['longitude'];
        if ($pickuplatitude == "" && $pickuplongitude == "") {
            $pickupaddress = implode(",", [$shipperInfo['street'], $shipperInfo['location_id'], $shipperInfo['country'], $shipperInfo['pincode']]);
            $data = getlatlngsbyplace($pickupaddress);
            $pickuplatitude = @$data[0];
            $pickuplongitude = @$data[1];
        }

        $droplatitude = empty($consigneeInfo['latitude']) ?? "";
        $droplongitude = empty($consigneeInfo['longitude']) ?? "";
        if ($droplatitude == "" && $droplongitude == "") {
            $dropaddress = implode(",", [$consigneeInfo['street'], $consigneeInfo['location_id'], $consigneeInfo['country'], $consigneeInfo['pincode']]);
            $data = getlatlngsbyplace($dropaddress);
            $droplatitude = @$data[0];
            $droplongitude = @$data[1];
        }
        $orderinfo = [
            'customer_id' => $customerId,
            'product' => $orderData['Product'],
            'pickup_datetime' => $e_pickup,
            'delivery_datetime' => $e_delivery,
            'pickup_endtime' => $l_pickup,
            'drop_endtime' => $l_delivery,
            'goods_value' => "0.00",
            'currency' => "",
            'company_code' => $orderData['company_code'],
            'branch_code' => $orderData['branch_code'],
            'drop_custid' => $consigneeInfo['id'],
            'drop_partyid' => $consigneeInfo['id'],
            'user_id' => $user_id,
            'sub_uid' => 0,
            'pickup_custid' => $shipperInfo['id'],
            'pickup_partyid' => $shipperInfo['id'],
            'pickup_country' => $shipperInfo['country'],
            'pickup_city' => $shipperInfo['location_id'],
            'pickup_pincode' => $shipperInfo['pincode'],
            'pickup_company' => $shipperInfo['name'],
            'pickup_address1' => $shipperInfo['street'],
            'pickup_address2' => $shipperInfo['state'],
            'delivery_country' => $consigneeInfo['country'],
            'delivery_city' => $consigneeInfo['location_id'],
            'delivery_pincode' => $consigneeInfo['pincode'],
            'delivery_company' => $consigneeInfo['name'],
            'delivery_address1' => $consigneeInfo['street'],
            'delivery_address2' => $consigneeInfo['state'],
            'is_created' => '1',
            'plat' => $pickuplatitude,
            'plng' => $pickuplongitude,
            'dlat' => $droplatitude,
            'dlng' => $droplongitude,
            'transport_mode' => $orderData['ModeOfTransport'],
            'created_source' => 13
        ];
        if ($orderData['etnordered'] == 0) {
            $orderId = $this->ci->common->insertTableData('tb_orders', $orderinfo);
            $bookingId = $this->ci->amazonexceldtomodel->generateOrderBookingId($orderId, $user_id);
            $this->ci->common->updatetbledata("tb_orders", ['order_id' => $bookingId], ["id" => $orderId]);
        } else {
            $orderId = $orderData['etnordered'];
            $this->ci->common->updatetbledata("tb_orders", $orderinfo, ["id" => $orderId]);
            $bookingId = $this->ci->amazonexceldtomodel->getBookingId($orderId);
        }

        $orderDetails = [
            'shipper_id' => $shipmentId,
            'service' => $orderData['ServiceType'],
            'delivery_term' => $orderData['FreightTerm'],
            'incoterm' => $orderData['Incoterm'],
            'notify_party' => "",
            'department_code' => $orderData['department_code'],
            'order_row_id' => $orderId,
            'order_id' => $bookingId,
            'order_type' => $orderData['OrderType']
        ];
        $orderDetailsCount = $this->ci->amazonexceldtomodel->checkOrderDetails($orderId, $bookingId);
        if ($orderDetailsCount > 0) {
            $this->ci->common->updatetbledata("tb_order_details", $orderDetails, ["order_row_id" => $orderId]);
        } else {
            $this->ci->common->insertTableData('tb_order_details', $orderDetails);
        }
        if (array_key_exists("0", $orderData['cargoDetails']['TransportHandlingUnit']) == 1) {
            foreach ($orderData['cargoDetails']['TransportHandlingUnit'] as $orderCargo) {
                $this->ci->amazonexceldtomodel->insertCargoInfo($orderCargo, $orderId, $user_id);
            }
        } else {
            $this->ci->amazonexceldtomodel->insertCargoInfo($orderData['cargoDetails']['TransportHandlingUnit'], $orderId, $user_id);
        }
        if (!empty($orderData['involvedParties'])) {
            foreach ($orderData['involvedParties']['PartyType'] as $party) {
                $party_type_id = $this->ci->amazonexceldtomodel->getPartyTypeId($orderData['company_code'], $orderData['branch_code'], $party['Type']);
                $partyId = $this->ci->amazonexceldtomodel->getPartyID($party['ID']);
                $orderParty = [
                    'order_id' => $orderId,
                    'order_number' => $bookingId,
                    'party_id' => $partyId,
                    'party_type' => $party_type_id,
                    'status' => 1
                ];
                $this->ci->amazonexceldtomodel->insertOrderParties($orderParty);
            }
        }
        if (array_key_exists("0", $orderData['manageReferences']['References']) == 1) {
            foreach ($orderData['manageReferences']['References'] as $references) {
                $this->ci->amazonexceldtomodel->insertOrderReferences($orderId, $references);
            }
        } else {
            $this->ci->amazonexceldtomodel->insertOrderReferences($orderId, $orderData['manageReferences']['References']);
        }
        echo "Order Created Successfully: Booking - " . $bookingId;
    }

    public function generateOrderData(array $data): array
    {
        $orderInfo = $data['SVKEDIOrderBody'];
        $orderHeader = $data['SVKEDIOrderHeader'];
        $order_id = 0;
        $etnOrderNumber = $this->ci->amazonexceldtomodel->checkOrder($orderInfo['ContainerNumber'], $orderInfo['LocationInfo']['Source']['ID'], $orderInfo['LocationInfo']['Destination']['ID']);
        if ($etnOrderNumber > 0) {
            $order_id = $etnOrderNumber;
        }
        $company_code = is_array($orderInfo['eTNOrgDetails']['Companycode']) ? "" : $orderInfo['eTNOrgDetails']['Companycode'];
        $branch_code = is_array($orderInfo['eTNOrgDetails']['Branchcode']) ? "" : $orderInfo['eTNOrgDetails']['Branchcode'];
        $orderType = $orderInfo['OrderType'];
        if (!empty($orderType)) {
            $orderTypeID = $this->ci->amazonexceldtomodel->checkOrderType($orderType, $company_code, $branch_code);
            if (empty($orderTypeID)) {
                log_error('Standard Order Create :  Invalid Order Type ' . $orderType);
                return ["status" => 1, "message" => ' Invalid Order Type ' . $orderType];
            }
        } else {
            log_error('Standard Order Create : Empty  Order Type');
            return ["status" => 1, "message" => 'Empty  Order Type '];
        }
        $modeOfTransport = $orderInfo['ModeOfTransport'];
        if (!empty($modeOfTransport)) {
            $modeOfTransportID = $this->ci->amazonexceldtomodel->checkModeOfTransport($modeOfTransport);
            if (empty($modeOfTransportID)) {
                log_error('Standard Order Create :  Invalid Mode Of Transport ' . $modeOfTransport);
                return ["status" => 1, "message" => 'Invalid Mode Of Transport ' . $modeOfTransport];
            }
        } else {
            log_error('Standard Order Create : Empty  Mode Of Transport');
            return ["status" => 1, "message" => 'Empty  Mode Of Transport'];
        }

        $product = $orderInfo['Product'];
        if (!empty($product)) {
            $productID = $this->ci->amazonexceldtomodel->checkProduct($product);
            if (empty($productID)) {
                log_error('Standard Order Create :  Invalid Product ' . $product);
                return ["status" => 1, "message" => 'Invalid Product' . $product];
            }
        } else {
            log_error('Standard Order Create : Empty  Product');
            return ["status" => 1, "message" => 'Empty  Product'];
        }
        $serviceType = $orderInfo['ServiceType'];
        if (empty($serviceType)) {
            log_error('Standard Order Create : Empty  Service Type');
            return ["status" => 1, "message" => 'Empty  Service Type'];
        } else {
            $serviceTypeID = $this->ci->amazonexceldtomodel->checkServiceType($serviceType);
            if (empty($serviceTypeID)) {
                log_error('Standard Order Create :  Invalid Service Type ' . $serviceType);
                return ["status" => 1, "message" => ' Invalid Service Type ' . $serviceType];
            }
        }

        $orderData = [
            'containerNumber' => $orderInfo['ContainerNumber'],
            'ModeOfTransport' => $modeOfTransportID,
            'Product' => $productID,
            'ServiceType' => $serviceTypeID,
            'OrderType' => $orderTypeID,
            'Incoterm' => is_array($orderInfo['TermsOfTrade']['Incoterm']) ? "" : $orderInfo['TermsOfTrade']['Incoterm'],
            'FreightTerm' => is_array($orderInfo['TermsOfTrade']['FreightName']['Term']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Term'],
            'FreightTermName' => is_array($orderInfo['TermsOfTrade']['FreightName']['Name']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Name'],
            'company_code' => is_array($orderInfo['eTNOrgDetails']['Companycode']) ? "" : $orderInfo['eTNOrgDetails']['Companycode'],
            'branch_code' => is_array($orderInfo['eTNOrgDetails']['Branchcode']) ? "" : $orderInfo['eTNOrgDetails']['Branchcode'],
            'department_code' => is_array($orderInfo['eTNOrgDetails']['Departmentcode']) ? "" : $orderInfo['eTNOrgDetails']['Departmentcode'],
            'physicalReceiver' => is_array($orderInfo['eTNOrgDetails']['PhysicalReceiver']) ? "" : $orderInfo['eTNOrgDetails']['PhysicalReceiver'],
            'logicalReceiver' => is_array($orderInfo['eTNOrgDetails']['LogicalReceiver']) ? "" : $orderInfo['eTNOrgDetails']['LogicalReceiver'],
            'physicalSender' => is_array($orderInfo['eTNOrgDetails']['PhysicalSender']) ? "" : $orderInfo['eTNOrgDetails']['PhysicalSender'],
            'logicalSender' => is_array($orderInfo['eTNOrgDetails']['LogicalSender']) ? "" : $orderInfo['eTNOrgDetails']['LogicalSender'],
            'customerID' => $orderInfo['CustomerID'],
            'sourceInfo' => $orderInfo['LocationInfo']['Source'],
            'destinationInfo' => $orderInfo['LocationInfo']['Destination'],
            'cargoDetails' => $orderInfo['CargoDetails'],
            'involvedParties' => $orderInfo['InvolvedParties'],
            'manageReferences' => $orderInfo['ManageReferences'],
            'header' => $orderHeader,
            'etnordered' => $order_id
        ];
        return ["status" => 0, "data" => $orderData];
    }

    private function insertShipmentData(array $orderData): int
    {
        if (!empty($orderData['containerNumber'])) {
            $shipment_id = $orderData['containerNumber'];
        } else {
            $shipment_id = "SVK" . time();
        }
        $transportmodeid = $transportmodename = "";
        $gettrasnportmode = $this->ci->amazonexceldtomodel->getTransportModeName($orderData['ModeOfTransport']);
        if (!empty($gettrasnportmode)) {
            $transportmodeid = $gettrasnportmode['id'];
            $transportmodename = $gettrasnportmode['name'];
        }
        $currentDate = date('Y-m-d H:i:s');
        $endDate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $shipmentData = [
            'shipid' => $shipment_id,
            'txnid' => $shipment_id,
            'trucktype' => $transportmodename,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'unitspec' => 1,
            'insertusr' => $orderData['sourceInfo']['ID'],
            'carrier' => '0',
            'insertuserdate' => $currentDate,
            'enddate' => $endDate,
            'insdate' => $currentDate,
            'upddate' => $currentDate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $currentDate,
            'transport_mode' => $orderData['ModeOfTransport'],
            'domainname' => $orderData['branch_code'],
            'company_code' => $orderData['company_code'],
            'branch_code' => $orderData['branch_code'],
            'product' => $orderData['ModeOfTransport'],
            'freight_term' => $orderData['FreightTerm'] ?? "60",
            'freight_termname' => $orderData['FreightTermName'] ?? "Free of Charge",
            'incoterm' => $orderData['Incoterm'],
            'modeoftransport' => $transportmodeid
        ];
        $checkShipmentId = $this->ci->common->gettblrowdata(['shipid' => $shipment_id], "id", "tb_shipments", 0, 0);
        if (!empty($checkShipmentId)) {
            $shipmentRowId = $checkShipmentId['id'];
            $this->ci->common->updatetbledata("tb_shipments", $shipmentData, ["id" => $shipmentRowId]);
        } else {
            $shipmentRowId = $this->ci->common->insertTableData('tb_shipments', $shipmentData);
        }
        return $shipmentRowId;
    }


}
