<?php
// NOTE : V1 OLD CIP Portal valid till Dec 2024
class CipPortal {
	private $CI;
	public string $request_url;

	public function __construct() {
		$this->CI = &get_instance();
		$this->CI->load->model('common');
		require_once './vendor/pear/http_request2/HTTP/Request2.php';
	}

	private function getAuthorizationKey() : array {
		return $this->CI->common->gettblrowdata(['id'=>1],'authorization_key,updated_at','cip_authorization_key',1,0);
	}

	public function createLookupSuggesstions(array $searchData = []): array {
		$authorizationQry = $this->getAuthorizationKey();
		if (empty($authorizationQry)) {
			return ['status'=>0,'data'=>[]];
		}
		$data = [];
		$searchData = (object) $searchData;
		$payLoad = [
			"addressDto" => [
				"addressee"=>$searchData->entityName,
				"country"=> $searchData->countryIso2Code
			],
			"searchOnlyDataMirror"=>true
		];
		$post = json_encode($payLoad);
		//log_message("error","CIP create V1 lookup suggestions payload => ".$post);
		$status = 1;
		$request = new HTTP_Request2();
		$request->setUrl(CIP_PORTAL_V1_BASE_URL.'cip/rest/v2/customers/customer-lookup');
		$request->setMethod(HTTP_Request2::METHOD_POST);
		$request->setConfig(['follow_redirects' => TRUE]);
		$request->setHeader(['X-Authorization' => $authorizationQry['authorization_key'], 'Content-Type' => 'application/json']);
		$request->setBody($post);
		try {
			$response = $request->send();
			$statusCode = (int) $response->getStatus();
			if ( in_array($statusCode, [200, 201])) {
				$body = $response->getBody();
				$message = 'V1 CIP PORTAL GET Lookup Suggesstions Success Response: '.$body;
				$data = json_decode($body,true);
			} else {
				//log_message("error","V1 CIP fetch lookup suggestions error response => ".$response->getBody());
				$status = 3;
				$message = "V1 CIP PORTAL GET Lookup Suggesstions Unexpected HTTP status:".$response->getStatus().' '.$response->getReasonPhrase();
			}
		} catch (HTTP_Request2_Exception $e) {
			$status = 2;
			$message = 'V1 CIP PORTAL GET Lookup Suggesstions Error at '.date('d-m-Y H:i:s'). $e->getMessage();
		}
		log_message("error",$message);
		return compact('status','data');
	}

	public function generateCIDinCIPPortal(array $data=[]) : array {
		$authorizationQry = $this->getAuthorizationKey();
		if (empty($authorizationQry)) {
			return ['status'=>0,'cid'=>''];
		}
		$status = 1;
		$cid  = $message = '';
		$data = (object)$data;
		$forceDuplicate = checkAccessConditions('CIP_CREATE_DUPLICATE_CUSTOMER_STATUS', 1) ? true : false;
		$payLoad = [
			"physicalAddress"=> [
				"deliveryService"=> "PHYSICAL_ADDRESS",
				"forceDuplicate"=> $forceDuplicate,
				"forceInternational"=> true,
				"forceLocal"=> true,
				"forceReason"=> "",
				"internationalAddress"=> [
					"addressee"=> (string) $data->entityName,
					"building"=> (string) $data->building,
					"country"=> (string) $data->countryIso2Code,
					"dataSource"=> "",
					"deliveryServiceName"=> "",
					"deliveryServiceQualifier"=> "",
					"dependentLocality"=> "",
					"divisionName"=> "",
					"extension"=> "",
					"locality"=> (string) $data->locality,
					"plot"=> (string) $data->plot,
					"postcode"=> (string) $data->postcode,
					"processStatus"=> "",
					"province"=> (string) $data->province,
					"provinceCode"=> "",
					"scope"=> "INTERNATIONAL",
					"subDependentLocality"=> "",
					"thoroughfare1"=> (string) $data->thoroughfare1,
					"thoroughfare2"=> (string) $data->thoroughfare2,
					"thoroughfare3"=> ""
				]
			  ],
			  "lookupId"=> ""
			];
		$post = json_encode($payLoad);
		//log_message("error","CIP create CID payload => ".$post);
		$request = new HTTP_Request2();
		$request->setUrl(CIP_PORTAL_V1_BASE_URL.'cip/rest/v2/customers');
		$request->setMethod(HTTP_Request2::METHOD_POST);
		$request->setConfig(['follow_redirects' => TRUE]);
		$request->setHeader([
			'X-Authorization' => $authorizationQry['authorization_key'],
			'Content-Type' => 'application/json'
		]);
		$request->setBody($post);
		try {
			$response = $request->send();
			$statusCode = (int)$response->getStatus();
			if ( in_array($statusCode, [200, 201])) {
				$body = $response->getBody();
				$message = 'V1 CIP PORTAL Success Response: '.$body;
				$responseBody = json_decode($body,true);
				$cid = isset($responseBody['cid']) ? $responseBody['cid'] : '';
			} elseif ($statusCode === 400) {
				$status = 6;
				$body = json_decode($response->getBody(), true);
				//log_message("error","V1 CIP create CID error response => ".$response->getBody());
				$message = (is_array($body) && isset($body['detail'])) ? $body['detail'] : '';
			} else {
				//log_message("error","V1 CIP create CID error response => ".$response->getBody());
				$status = 3;
				$message = "V1 CIP PORTAL Unexpected HTTP status:".$response->getStatus().' '.$response->getReasonPhrase();
			}
		} catch (HTTP_Request2_Exception $e) {
			$status = 2;
			$message = "V1 CIP PORTAL Error at".date('d-m-Y H:i:s'). $e->getMessage();
		}
		log_message("error",$message);
		return compact('status','cid','message');
	}

	public function fetchCipPortalBpInfoByCID(string $cid): array {
		$authorizationQry = $this->getAuthorizationKey();
		if (empty($authorizationQry)) {
			return ['status'=>0,'data'=>[]];
		}
		$data = [];
		$status = 1;
		$request = new HTTP_Request2();
		$request->setUrl(CIP_PORTAL_V1_BASE_URL.'cip/rest/v2/customers/'.$cid);
		$request->setMethod(HTTP_Request2::METHOD_GET);
		$request->setConfig(['follow_redirects' => TRUE]);
		$request->setHeader(['Authorization' => $authorizationQry['authorization_key']]);
		try {
			$response = $request->send();
			$statusCode = (int)$response->getStatus();
			if ( in_array($statusCode, [200, 201]) ) {
				$body = $response->getBody();
				$message = 'V1 CIP PORTAL GET BP Success Response: '.$body;
				$data = json_decode($body,true);
			} else {
				//log_message("error","V1 CIP fetch Customer Info error response => ".$response->getBody());
				$status = 3;
				$message = 'V1 CIP PORTAL GET BP Unexpected HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
			}
		} catch (HTTP_Request2_Exception $e) {
			$status = 2;
			$message = 'V1 CIP PORTAL GET BP Error at '.date('d-m-Y H:i:s'). $e->getMessage();
		}
		log_message("error",$message);
		return compact('status','data');
	}

	public function updateCustomerAddressAfterLookup(array $updateData = []): array {
		$authorizationQry = $this->getAuthorizationKey();
		if (empty($authorizationQry) || empty($updateData)) {
			return ['status'=>0,'data'=>[]];
		}
		$data=[];
		$updateData = (object) $updateData;
		$cid = $updateData->cid;
		$payLoad = [
			"address"=> [
				"addressId"=> $updateData->addressId,
				"forceDuplicate"=> false,
				"forceInternational"=> true,
				"forceLocal"=> false,
				"forceReason"=> "",
				"internationalAddress"=> [
					"addressee"=> $updateData->entityName,
					"building"=> $updateData->building,
					"country"=> $updateData->countryIso2Code,
					"dataSource"=> "",
					"deliveryServiceName"=> "",
					"deliveryServiceQualifier"=> "",
					"dependentLocality"=> "",
					"divisionName"=> "",
					"extension"=> "",
					"locality"=> $updateData->locality,
					"plot"=> $updateData->plot,
					"postcode"=> $updateData->postcode,
					"processStatus"=> "",
					"province"=> $updateData->province,
					"provinceCode"=> "",
					"scope"=> "INTERNATIONAL",
					"subDependentLocality"=> "",
					"thoroughfare1"=> $updateData->thoroughfare1,
					"thoroughfare2"=> $updateData->thoroughfare2,
					"thoroughfare3"=> $updateData->thoroughfare3
				],
				"reason"=> "CHANGE"
			],
			"lookupId"=> $updateData->lookupId,
			"customerId"=> $cid
		];
		$post = json_encode($payLoad);
		//("error","V1 CIP update customer address payload => ".$post);
		$status = 1;
		$request = new HTTP_Request2();
		$request->setUrl(CIP_PORTAL_V1_BASE_URL.'cip/rest/v2/customers/'.$cid.'/change-address');
		$request->setMethod(HTTP_Request2::METHOD_PUT);
		$request->setConfig(['follow_redirects' => TRUE]);
		$request->setHeader(['X-Authorization' => $authorizationQry['authorization_key'], 'Content-Type' => 'application/json']);
		$request->setBody($post);
		try {
			$response = $request->send();
			$statusCode = (int) $response->getStatus();
			if ( in_array($statusCode, [200, 201])) {
				$body = $response->getBody();
				$message = 'V1 CIP PORTAL Update BP Address Success Response: '.$body;
				$data = json_decode($body,true);
			} else {
				//("error","V1 CIP update customer error response => ".$response->getBody());
				$status = 3;
				$message = 'V1 CIP PORTAL Update BP Address Unexpected HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
			}
		} catch (HTTP_Request2_Exception $e) {
			$status = 2;
			$message = 'CIP PORTAL Update BP Address Error at '.date('d-m-Y H:i:s'). $e->getMessage();
		}
		log_message("error",$message);
		return compact('status','data');
	}
}