<?php

use App\Authorization\Authorization;
use App\Authorization\Exception\AuthorizationDeniedException;
use App\Authorization\Exception\EntityAuthorizerNotFoundException;
use App\Authorization\Exception\UserTypeInvalidException;
use App\Authorization\Session\UserSession;

final class CodeIgniterAuthorization
{
    private static $instance;

    public function __construct()
    {
        self::$instance =& $this;
    }

    /**
     * @throws UserTypeInvalidException
     * @throws AuthorizationDeniedException
     * @throws EntityAuthorizerNotFoundException
     */
    public function isAuthorized($sessionData, $entityName, $entityId): bool
    {
        $userSession = UserSession::createFromCodeIgniterSessionData($sessionData);

        $ci = &get_instance();

        return (new Authorization())->isAuthorized($userSession, $entityName, $entityId, $ci);
    }
}
