<?php
/**
 * CommonWealthGames epod exchange information
 *
 * @author          Developer Name Rao, Tirupathi / Kuehne + Nagel / MEM
 * @date            19-06-2021 11:00:00+05.30
 * @change          Asia
 * @copyright       2021 TMS
 * @version         Release: 1.12.0
 * @authentication  Required
 */

use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;

class Commonpodedi
{
    public function sendpodoutboundxml(int $orderId, string $filePath, string $docType, string $option = "UPLOAD"): void
    {
        if (!$this->validateSendPodOutboundxmlData($orderId, $filePath)) {
            log_message("error", "Opexbox document upload is aborted due to invalid data.");
            return;
        }
        $ci = &get_instance();
        $ci->load->model("common");
        $orderInfo = $ci->common->gettblrowdata(
            ['id' => $orderId],
            'order_id,shift_id,trip_id,customer_id,user_id',
            'tb_orders',
            0,
            0
        );
        if (count($orderInfo) > 0) {
            $customerId = $orderInfo['customer_id'];
            $user_id = $orderInfo['user_id'];
            $checkCustomer = $ci->common->gettblrowdata(
                ['id' => $customerId, 'name' => 'COMMON WEALTH GAMES', 'company_code' => 'UKKN-CG', 'status' => 1],
                'id,name',
                'tb_customers',
                0,
                0
            );
            if (count($checkCustomer) > 0) {
                $bookingId = $orderInfo['order_id'];
                $documentType = $docType === '3' ? 'POD' : ($docType === '1' ? 'Signature' : 'POP');
                $documentCode = $docType === '3' ? '545' : ($docType === '1' ? '1' : '507');
                $action = $option === 'Remove' ? 'REMOVE_DOCUMENT' : 'UPLOAD';
                $imageName = basename($filePath);
                $getDocumentHash = $ci->common->gettblrowdata(['imgpath' => $imageName], 'hash', 'tb_pod_uploads', 0, 0);
                $url = '';
                if (!empty($getDocumentHash)) {
                    $hash = $getDocumentHash['hash'];
                    $url = (base_url() === 'https:/' ? SITEURL . '/' : base_url()) . 'downloadEpod/safelink/' . $hash . '.epod';
                }
                $sequenceNumber = Date("Ymdhis") . "_KN" . $bookingId;
                $originalImage = './assets/poduploads/' . $imageName;
                $image = base64_encode(file_get_contents($originalImage));
                $docXml = '<?xml version="1.0" encoding="UTF-8"?>
				<DocumentUpload xmlns="https://elog360.app/svkonekt_test/edi/business_partner/document_upload/v1">
			  <Header>
				<Version>V1</Version>
				<SequenceNumber>' . $sequenceNumber . '</SequenceNumber>
				<SourceApp>SVKONEKT</SourceApp>
				<DestinationApp>OPENBOX</DestinationApp>
			 </Header>
			  <Action>' . $action . '</Action>
			   <OrderID>' . $bookingId . '</OrderID>
			  <DocumentType>' . $documentType . '</DocumentType>
			  <DocumentCode>' . $documentCode . '</DocumentCode>
			  <UploadDetails>
				<DocumentName>' . $imageName . '</DocumentName>
				<DocumentFile>' . $image . '</DocumentFile>
				<URL>' . $url. '</URL>
			  </UploadDetails>
			</DocumentUpload>';
                $ci->load->library('edi/carriernotification/CarrierNotificationSftpManager', 'carriernotificationsftpmanager');
                try {
                    $fileName = $sequenceNumber . ".xml";
                    $localFile = "./xml/cwg/" . $fileName;
                    if (!file_exists(dirname($localFile)) && !mkdir($localDir = dirname($localFile), 0700, true) && !is_dir($localDir)) {
                        throw new \RuntimeException(sprintf('Directory "%s" was not created', $localDir));
                    }
                    file_put_contents($localFile, $docXml);
                    $ci->carriernotificationsftpmanager->initializeConnectionSettings(
                        [
                            'url' => OPENBOX_SERVER_IP,
                            'username' => OPENBOX_USERNAME,
                            'password' => OPENBOX_PASSWORD,
                            'path' => OPENBOX_DOCUMENT_UPLOAD_INBOUND
                        ]
                    );
                    $ci->carriernotificationsftpmanager->uploadToSftp($docXml, $sequenceNumber);
                } catch (\Throwable $th) {
                    log_message("error", "Openbox document upload failed." . $th->getMessage() . '/' . $th->getCode());
                }
            }
        }
    }

    private function validateSendPodOutboundxmlData(int $orderId, string $filePath): bool
    {
        if (empty($orderId)) {
            log_message('error', 'Opex Document upload: Please provide valid Order Id.');
            return false;
        }

        if (empty($filePath)) {
            log_message('error', 'Opex Document upload: Please provide valid File Path.');
            return false;
        }
        return true;
    }

    public function checkDocumentType(string $docType): bool
    {
        // checking the document types 4 - POP, 3 - POD, 49 - POD , 1 - Signature
        return in_array($docType, ['4', '3', '49', '1']);
    }
}
