<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class CustomReportService
{

    public function __construct()
    {
        $ci =& get_instance();
        $modals = [
            'common' => 'common',
            'CustomReportModel' => 'CustomReportModel',
            'DataArrayFormatter_model' => 'DataArrayFormatter_model',
            'DataQueryFormatter_model' => 'DataQueryFormatter_model',
            'Datatables_model' => 'Datatables_model'
        ];
        $ci->load->model($modals);
    }

    public function getCustomReportfilterWhereConditionData(array $post): array
    {
        $ci =& get_instance();
        $whr = [];
        $whr['ordids'] = [];
        if (isset($post['pickupfrom']) && $post['pickupfrom'] != "") {
            $pickupfrom = date('Y-m-d', strtotime($post['pickupfrom']));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $pickupfrom;
        }

        if (isset($post['pickupto']) && $post['pickupto'] != "") {
            $pickupto = date('Y-m-d', strtotime($post['pickupto']));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $pickupto;
        }

        if (isset($post['advdeliveryfrom_date']) && !empty($post['advdeliveryfrom_date'])) {
            $post_advdeliveryfrom_date = $this->db->escape_str($post['advdeliveryfrom_date']);
            $advdeliveryfrom_date = date('Y-m-d', strtotime($post_advdeliveryfrom_date));
            $whr["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') >="] = $advdeliveryfrom_date;
        }
        if (isset($post['advdeliveryto_date']) && !empty($post['advdeliveryto_date'])) {
            $post_advdeliveryto_date = $this->db->escape_str($post['advdeliveryto_date']);
            $advdeliveryto_date = date('Y-m-d', strtotime($post_advdeliveryto_date));
            $whr["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') <="] = $advdeliveryto_date;
        }

        if (isset($post['trip_id']) && $post['trip_id'] != "") {
            $whr['o.shipmentid'] = $post['trip_id'];
        }

        if ($post['fromdate_search'] != "") {
            $fromdate_search = date('Y-m-d', strtotime($post['fromdate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;
        }

        if ($post['todate_search'] != "") {
            $todate = date('Y-m-d', strtotime($post['todate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (!empty($post['adv_from_date'])) {
            $adv_fromdate_search = date('Y-m-d', strtotime($post['adv_from_date']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $adv_fromdate_search;
        }

        if (!empty($post['adv_to_date'])) {
            $adv_todate = date('Y-m-d', strtotime($post['adv_to_date']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $adv_todate;
        }

        if (isset($post['booking_id']) && $post['booking_id'] != "") {
            $whr['o.order_id'] = $post['booking_id'];
        }

        if (isset($post['order_id']) && $post['order_id'] != "") {
            $whr['o.order_id'] = $post['order_id'];
        }

        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers", ['code' => $post['searchcustomer_id']]);
            if ($getcustomer_id->num_rows() > 0) {
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['custcode']) && $post['custcode'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers", ['code' => $post['custcode']]);
            if ($getcustomer_id->num_rows() > 0) {
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['service']) && $post['service'] != "") {
            $whr['d.service'] = $post['service'];
        }

        if (isset($post['order_type']) && $post['order_type'] != "") {
            $whr['d.order_type'] = $post['order_type'];
        }
        if (isset($post['product']) && $post['product'] != "") {
            $whr['o.product'] = $post['product'];
        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $whr['o.transport_mode'] = $post['modeof_trasnport'];
        }
        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $whr['o.pickup_custid'] = $post['searchshipper_id'];
        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $whr['o.drop_custid'] = $post['searchconsignee_id'];
        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
            $ref_whr = ['refid' => 'DQ', 'refvals' => $post['delivery_note']];
            $getordids = $ci->common->getordids($ref_whr);
            if (!empty($getordids)) {
                foreach ($getordids as $key => $getordid) {
                    $whr['ordids'][] = $getordid['order_id'];
                }
            }
        }
        if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
            $ref_whr = ['refid' => 'PO', 'refvals' => $post['purchase_order']];
            $getordids = $ci->common->getordids($ref_whr);
            if (!empty($getordids)) {
                foreach ($getordids as $key => $getordid) {
                    $whr['ordids'][] = $getordid['order_id'];
                }
            }
        }
        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['o.company_code'] = $post['company_code'];
        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['o.branch_code'] = $post['branch_code'];
        }
        return $whr;
    }

    public function getAllRecordList(array $getRecordListing, array $customerDetailsArray, array $tripInfoArray, array $vehicleAndDriverArray): array
    {
        $ci =& get_instance();
        $actionContent = '';
        $result_array = [];
        $curtz = $ci->session->userdata("usr_tzone")['timezone'];
        foreach ($getRecordListing as $res) {
            $undefinedVariables = [
                'vendor_name',
                'revenue_order_count',
                'partydetails_id',
                'partydetails_party_type_id',
                'partydetails_name',
                'partydetails_mobile',
                'partydetails_email',
                'partydetails_code',
                'partydetails_customeridentifier',
                'partydetails_house_number',
                'partydetails_fax',
                'partydetails_acon_debitor_code',
                'partydetails_kn_login_account',
                'partydetails_vat_reg_no',
                'partydetails_tax_payer_no',
                'partydetails_contract_no',
                'partydetails_contract_date',
                'partydetails_party_type',
                'partydetails_party_type_name',
                'pickup',
                'delivery',
                'reference_value',
                'status_details',
                'docs_received_datetime',
                'docs_sent_datetime',
                'chargedetails_type',
                'chargedetails_chargecode',
                'chargedetails_chargecodename',
                'chargedetails_quantity_unit',
                'chargedetails_value',
                'chargedetails_rate_id',
                'chargedetails_amount',
                'chargedetails_currency',
                'chargedetails_vat_percentage',
                'chargedetails_vat_amount',
                'revenue_details',
                'vas_details',
                'name_of_service',
                'order_type_name',
                'delivery_term_name',
                'pod_available',
                'driver_acceptance_date',
                'payer_id',
                'payer_name',
                'payer_cid',
                'payer_acondebtorcode',
                'payer_kn_login_account',
                'payer_vat_regno',
                'payer_tax_payerid',
                'payer_steeet_house',
                'payer_postal',
                'payer_country',
                'payer_phone',
                'payer_email',
                'cargo_total_quantity',
                'cargo_total_package_type',
                'cargo_total_length',
                'cargo_total_length_unit',
                'cargo_total_width',
                'cargo_total_width_unit',
                'cargo_total_height',
                'cargo_total_height_unit',
                'cargo_total_second_weight',
                'cargo_total_weight_unit',
                'cargo_total_second_volume',
                'cargo_total_volume_unit',
                'cargo_total_ldm',
                'cargo_total_volumetric_weight',
                'cargo_total_volweight_uom',
                'cargo_total_stackable',
                'cargo_total_dg_goods',
                'carg_total_weight',
                'cargo_total_weight_unit',
                'cargo_total_volume',
                'cargo_total_volume_unit',
                'transit_time_in_hours',
                'rap_date',
                'rap_status',
                'bap',
                'remarks_issues'
            ];

            foreach ($undefinedVariables as $eachVar) {
                if (!isset($res[$eachVar])) {
                    $res[$eachVar] = '';
                }
            }

            $delivery_note = $purchase_order = "";
            $shipmentid = $res['shipment_id'];
            $trip_no = $res['shipmentid'];
            if ($trip_no == '0') {
                $trip_no = "";
            }
            $shift_id = $res['shift_id'];
            $trip_sts = $res['trip_sts'];
            $trip_id = $res['trip_id'];
            $order_status = 'PENDING';
            if ($trip_id != 0 && $trip_sts == 0) {
                $order_status = 'ACTIVE';
            }
            if ($trip_id != 0 && $trip_sts == 1) {
                $order_status = 'CLOSED';
            }

            if ($order_status === 'PENDING') {
                $statusName = $ci->common->gettblrowdata(['order_id' => $res['order_id']], 'COUNT(trip_id) AS tripno', 'tb_employee', 1, 0);
                if (!empty($statusName)) {
                    if ($statusName['tripno']) {
                        $order_status = $trip_sts ? 'CLOSED' : 'ACTIVE';
                    }
                }
            }

            $vendor_id = $res['vendor_id'];
            $vname = "";
            if ($vendor_id > 0) {
                $vname = $res['vendor_name'];
            }
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $res['createdon'];
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $res['pickup_datetime'];

            $early_delivery = $res['delivery_datetime'];

            $curtz = $ci->session->userdata("usr_tzone")['timezone'];
            if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                $early_pickup = $epickup['datetime'];
            }
            if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                $early_delivery = $edelivery['datetime'];
            }

            $received_status = "Not Received";
            $sent_status = "Not Sent";
            $pickup_date_status = $delivery_datestatus = "";
            $bookingid = $res['order_id'];
            $addon_html = "";
            $rev_amount_billed = $rev_amount_pending_billing = $rev_amount_not_transfered = $costs_amount = 0;
            $rev_status = 'No';
            $html = "";
            if ($res['revenue_order_count'] > 0) {
                $rev_status = 'Yes';
            }

            //pickupaddress and delivery address
            $pickup_address1 = $pickup_city = $pickup_country = $pickup_pincode = $delivery_address1 = $delivery_city = $delivery_country = $delivery_pincode = $pickup_address2 = $delivery_address2 = $delivery_company = $pickup_company = "";
            $pickup_company = (!empty($res['pickup_company'])) ? $res['pickup_company'] . ' , ' : "";
            $delivery_company = (!empty($res['delivery_company'])) ? $res['delivery_company'] . ' , ' : "";
            $pickup_address1 = (!empty($res['pickup_address1'])) ? $res['pickup_address1'] . ' , ' : "";
            $pickup_address2 = (!empty($res['pickup_address2'])) ? $res['pickup_address2'] . ' , ' : "";
            $pickup_city = (!empty($res['pickup_city'])) ? $res['pickup_city'] . ' , ' : "";
            $pickup_country = (!empty($res['pickup_country'])) ? $res['pickup_country'] . ' , ' : "";
            $pickup_pincode = (!empty($res['pickup_pincode'])) ? $res['pickup_pincode'] . ' , ' : "";
            $delivery_address1 = (!empty($res['delivery_address1'])) ? $res['delivery_address1'] . ' , ' : "";
            $delivery_address2 = (!empty($res['delivery_address2'])) ? $res['delivery_address2'] . ' , ' : "";
            $delivery_city = (!empty($res['delivery_city'])) ? $res['delivery_city'] . ' , ' : "";
            $delivery_country = (!empty($res['delivery_country'])) ? $res['delivery_country'] . ' , ' : "";
            $delivery_pincode = (!empty($res['delivery_pincode'])) ? $res['delivery_pincode'] . ' , ' : "";
            $pickup_address = $pickup_company . $pickup_address1 . $pickup_city . $pickup_address2 . $pickup_country . $pickup_pincode;
            $delivery_address = $delivery_company . $delivery_address1 . $delivery_city . $delivery_address2 . $delivery_country . $delivery_pincode;
            $origional_deliverycity = (!empty($res['delivery_city'])) ? $res['delivery_city'] : "";
            $pickup_address = ltrim($pickup_address, ' , ');
            $pickup_address = rtrim($pickup_address, ' , ');
            $delivery_address = ltrim($delivery_address, ' , ');
            $delivery_address = rtrim($delivery_address, ' , ');
            $origional_pickupcity = (!empty($res['pickup_city'])) ? $res['pickup_city'] : "";

            if ($res['partydetails_id'] != '') {
                $partyArray = [
                    $res['partydetails_id'],
                    $res['partydetails_party_type_id'],
                    $res['partydetails_name'],
                    $res['partydetails_mobile'],
                    $res['partydetails_email'],
                    $res['partydetails_code'],
                    $res['partydetails_customeridentifier'],
                    $res['partydetails_house_number'],
                    $res['partydetails_fax'],
                    $res['partydetails_acon_debitor_code'],
                    $res['partydetails_kn_login_account'],
                    $res['partydetails_vat_reg_no'],
                    $res['partydetails_tax_payer_no'],
                    $res['partydetails_contract_no'],
                    $res['partydetails_contract_date'],
                    $res['partydetails_party_type'],
                    $res['partydetails_party_type_name']
                ];

                $getpartydetails = $ci->DataArrayFormatter_model->buildGenericArray($partyArray);
            }

            $customer_details = $payer_details = $drop_details = $shipper_details = ['id' => "", 'name' => "", 'phone' => "", 'email' => "", 'fax' => "", 'code' => "", 'street' => "", 'state' => "", 'city' => "", 'country' => "", 'pincode' => "", 'acon' => "", 'kn_login' => "", 'vat_reg_no' => "", 'tax_payer_no' => "", 'contract_no' => "", 'contract_date' => ""];
            $notify_address['name'] = "Notify Party";
            if (!empty($getpartydetails)) {
                foreach ($getpartydetails as $rr) {
                    if (!isset($rr['customeridentifier'])) {
                        $rr['customeridentifier'] = '';
                    }
                    if (!isset($rr['name'])) {
                        $rr['name'] = '';
                    }
                    if (!isset($rr['mobile'])) {
                        $rr['mobile'] = '';
                    }
                    if (!isset($rr['email'])) {
                        $rr['email'] = '';
                    }
                    if (!isset($rr['fax'])) {
                        $rr['fax'] = '';
                    }
                    if (!isset($rr['code'])) {
                        $rr['code'] = '';
                    }
                    if (!isset($rr['acon_debitor_code'])) {
                        $rr['acon_debitor_code'] = '';
                    }
                    if (!isset($rr['kn_login_account'])) {
                        $rr['kn_login_account'] = '';
                    }
                    if (!isset($rr['vat_reg_no'])) {
                        $rr['vat_reg_no'] = '';
                    }
                    if (!isset($rr['house_number'])) {
                        $rr['house_number'] = '';
                    }
                    if (!isset($rr['contract_no'])) {
                        $rr['contract_no'] = '';
                    }
                    if (!isset($rr['contract_date'])) {
                        $rr['contract_date'] = '';
                    }
                    if (!isset($rr['tax_payer_no'])) {
                        $rr['tax_payer_no'] = '';
                    }
                    if (!isset($rr['party_type_id'])) {
                        $rr['party_type_id'] = '';
                    }
                    $ptype = $rr['party_type_id'];
                    if ($rr['party_type_name'] != '') {
                        if ($rr['party_type_name'] == "Consignee") {
                            $drop_details = ['id' => $rr['customeridentifier'], 'name' => $rr['name'], 'phone' => $rr['mobile'], 'email' => $rr['email'], 'fax' => $rr['fax'], 'code' => $rr['code'], 'acon' => $rr['acon_debitor_code'], 'kn_login' => $rr['kn_login_account'], 'vat_reg_no' => $rr['vat_reg_no'], 'tax_payer_no' => $rr['tax_payer_no'], 'contract_no' => $rr['contract_no'], 'contract_date' => $rr['contract_date'], 'house_number' => $rr['house_number']];
                        }
                        if ($rr['party_type_name'] == "Shipper") {
                            $shipper_details = ['id' => $rr['customeridentifier'], 'name' => $rr['name'], 'phone' => $rr['mobile'], 'email' => $rr['email'], 'fax' => $rr['fax'], 'code' => $rr['code'], 'acon' => $rr['acon_debitor_code'], 'kn_login' => $rr['kn_login_account'], 'vat_reg_no' => $rr['vat_reg_no'], 'tax_payer_no' => $rr['tax_payer_no'], 'contract_no' => $rr['contract_no'], 'contract_date' => $rr['contract_date'], 'house_number' => $rr['house_number']];
                        }
                    }
                    if ($rr['party_type_name'] == 'NOTIFY_PARTY') {
                        $notify_address['name'] = $rr['name'];
                    }
                }
            }

            /*Shipper ACON Debitor Code	Shipper KN Login Account	Shipper VAT Registration Number	Shipper Tax Payer ID*/
            #########################################
            if (isset($res['pickup'])) {
                $shipper_details['name'] = $res['pickup'];
            }
            ###########################################
            $shipper_details['street'] = $res['pickup_address1'];
            if (isset($shipper_details['house_number'])) {
                if ($shipper_details['house_number'] != "") {
                    $shipper_details['street'] .= $shipper_details['house_number'];
                }
            }
            $shipper_details['state'] = $res['pickup_address2'];
            $shipper_details['city'] = $res['pickup_city'];
            $shipper_details['country'] = $res['pickup_country'];
            $shipper_details['pincode'] = $res['pickup_pincode'];
            ##########################################
            if (isset($res['delivery'])) {
                $drop_details['name'] = $res['delivery'];
            }
            #############################################
            $drop_details['street'] = $res['delivery_address1'];
            if (isset($drop_details['house_number'])) {
                if ($drop_details['house_number'] != "") {
                    $drop_details['street'] .= $drop_details['house_number'];
                }
            }
            $drop_details['state'] = $res['delivery_address2'];
            $drop_details['city'] = $res['delivery_city'];
            $drop_details['country'] = $res['delivery_country'];
            $drop_details['pincode'] = $res['delivery_pincode'];

            $street = '';
            if (isset($res['customer_id'])) {
                if ($res['customer_id'] > 0) {
                    $customerIndex = $res['customer_id'];
                    if (isset($customerDetailsArray[$customerIndex])) {
                        if ($customerDetailsArray[$customerIndex]['cust_contract_date'] == "0000-00-00") {
                            $customerDetailsArray[$customerIndex]['cust_contract_date'] = '';
                        }
                        $street = $customerDetailsArray[$customerIndex]['cust_street'];
                        if ($customerDetailsArray[$customerIndex]['cust_house_number'] != "") {
                            $street .= $customerDetailsArray[$customerIndex]['cust_house_number'];
                        }
                        $customer_details = [
                            'id' => $customerDetailsArray[$customerIndex]['cust_customeridentifier'],
                            'name' => $customerDetailsArray[$customerIndex]['cust_name'],
                            'phone' => $customerDetailsArray[$customerIndex]['cust_mobile'],
                            'email' => $customerDetailsArray[$customerIndex]['cust_email'],
                            'fax' => $customerDetailsArray[$customerIndex]['cust_fax'],
                            'code' => $customerDetailsArray[$customerIndex]['cust_code'],
                            'street' => $street,
                            'state' => $customerDetailsArray[$customerIndex]['cust_state'],
                            'city' => $customerDetailsArray[$customerIndex]['cust_location_id'],
                            'country' => $customerDetailsArray[$customerIndex]['cust_country'],
                            'pincode' => $customerDetailsArray[$customerIndex]['cust_pincode'],
                            'acon' => $customerDetailsArray[$customerIndex]['cust_acon_debitor_code'],
                            'kn_login' => $customerDetailsArray[$customerIndex]['cust_kn_login_account'],
                            'vat_reg_no' => $customerDetailsArray[$customerIndex]['cust_vat_reg_no'],
                            'tax_payer_no' => $customerDetailsArray[$customerIndex]['cust_tax_payer_no'],
                            'contract_no' => $customerDetailsArray[$customerIndex]['cust_contract_no'],
                            'contract_date' => $customerDetailsArray[$customerIndex]['cust_contract_date']
                        ];
                    }
                }
            }

            if (isset($res['reference_value'])) {
                if ($res['reference_value'] != '') {
                    $arrayData = [];
                    $arrayData = $ci->DataArrayFormatter_model->formatGenericParameters($res['reference_value'], 'REFERENCE');
                }
            }

            $ref_1_name = $ref_1_description = $ref_1_value = $ref_2_name = $ref_2_description = $ref_2_value = $ref_3_name = $ref_3_description = $ref_3_value = $ref_4_name = $ref_4_description = $ref_4_value = $ref_5_name = $ref_5_description = $ref_5_value = $ruck_val = $rucksn_val = $salog_ref = "";
            if (!empty($arrayData)) {
                $ctr = 1;
                $ref_id = '';
                foreach ($arrayData as $ref) {
                    if (isset($ref['reference_id'])) {
                        $ref_id = $ref['reference_id'];
                    }

                    if (!in_array($ref_id, ['ORD_DLVINST', 'ORD_PIKINST', 'DQ', 'PO'])) {
                        if ($ctr == 1) {
                            $ref_1_name = $ref_id;
                            if (isset($ref['description'])) {
                                $ref_1_description = $ref['description'];
                            }
                            if (isset($ref['ref_value'])) {
                                $ref_1_value = $ref['ref_value'];
                            }
                        } elseif ($ctr == 2) {
                            $ref_2_name = $ref_id;
                            if (isset($ref['description'])) {
                                $ref_2_description = $ref['description'];
                            }
                            if (isset($ref['ref_value'])) {
                                $ref_2_value = $ref['ref_value'];
                            }
                        } elseif ($ctr == 3) {
                            $ref_3_name = $ref_id;
                            if (isset($ref['description'])) {
                                $ref_3_description = $ref['description'];
                            }
                            if (isset($ref['ref_value'])) {
                                $ref_3_value = $ref['ref_value'];
                            }
                        } elseif ($ctr == 4) {
                            $ref_4_name = $ref_id;
                            if (isset($ref['description'])) {
                                $ref_4_description = $ref['description'];
                            }
                            if (isset($ref['ref_value'])) {
                                $ref_4_value = $ref['ref_value'];
                            }
                        } elseif ($ctr == 5) {
                            $ref_5_name = $ref_id;
                            if (isset($ref['description'])) {
                                $ref_5_description = $ref['description'];
                            }
                            if (isset($ref['ref_value'])) {
                                $ref_5_value = $ref['ref_value'];
                            }
                        }
                        $ctr++;
                    }
                    if ($ref_id == 'DQ') {
                        if (isset($ref['ref_value'])) {
                            $delivery_note = $ref['ref_value'];
                        }
                    }
                    if ($ref_id == 'PO') {
                        if (isset($ref['ref_value'])) {
                            $purchase_order = $ref['ref_value'];
                        }
                    }
                    if ($ref_id == 'ORD_DLVINST') {
                        if (isset($ref['ref_value'])) {
                            $delivery_inst = $ref['ref_value'];
                        }
                    }
                    if ($ref_id == 'ORD_PIKINST') {
                        if (isset($ref['ref_value'])) {
                            $pickup_inst = $ref['ref_value'];
                        }
                    }
					if ($ref_id == 'XSR') {
                        if (isset($ref['ref_value'])) {
                            $salog_ref = $ref['ref_value'];
                        }
                    }
                }
            }

            $getstatusdates = ['statuspickupdate' => "", 'statusdeliverydate' => ""];

            $res['status_details'] = '';
            if (isset($res['order_id'])) {
                $orderIndex = $res['order_id'];
                if (isset($statusDatesArray[$orderIndex])) {
                    $res['status_details'] = $statusDatesArray[$orderIndex]['status_details'];
                }
            }

            if ($res['status_details'] != '') {
                $statusArrayData = [];
                $statusArrayData = $ci->DataArrayFormatter_model->formatGenericParameters($res['status_details']);
                $zonecode = $ci->session->userdata("usr_tzone");
                $curtz = $zonecode['timezone'];

                if (!empty($statusArrayData)) {
                    foreach ($statusArrayData as $eachRow) {
                        if ($eachRow['stop_type'] == "P") {
                            if ($eachRow['createdon'] != "") {
                                $getactualStatus = getdatetimebytimezone($curtz, $eachRow['createdon'], DFLT_TZ);
                                if (isset($getactualStatus['datetime'])) {
                                    $getstatusdates['statuspickupdate'] = $getactualStatus['datetime'];
                                }
                            }
                        }
                        if ($eachRow['stop_type'] == "D") {
                            if ($eachRow['createdon'] != "") {
                                $getactualStatus = getdatetimebytimezone($curtz, $eachRow['createdon'], DFLT_TZ);
                                if (isset($getactualStatus['datetime'])) {
                                    $getstatusdates['statusdeliverydate'] = $getactualStatus['datetime'];
                                }
                            }
                        }
                    }
                }
            }

            $docs_received_datetime = $res['docs_received_datetime'];
            if ($docs_received_datetime != "" && $docs_received_datetime != null) {
                $getactual = getdatetimebytimezone($curtz, $docs_received_datetime, DFLT_TZ);
                if (isset($getactual['datetime'])) {
                    $docs_received_datetime = $getactual['datetime'];
                }
            }
            $docs_sent_datetime = $res['docs_sent_datetime'];
            if ($docs_sent_datetime != "" && $docs_sent_datetime != null) {
                $getactual = getdatetimebytimezone($curtz, $docs_sent_datetime, DFLT_TZ);
                if (isset($getactual['datetime'])) {
                    $docs_sent_datetime = $getactual['datetime'];
                }
                $docs_sent_datetime = $getactual['datetime'];
            }

            $shiftIndex = $res['shift_id'];
            $vehicle_type = $trailer_no = $register_number = $trip_created_date = '';
            $res['supplier_id'] = $res['suppier_name'] = $res['suppier_steeet_house'] = $res['suppier_postalcode'] = $res['suppier_country'] = $res['suppier_phone'] = $res['suppier_email'] = '';
            $driver_name = $driver_licence_number = $driver_address = $driver_number = '';
            if (isset($tripInfoArray[$shiftIndex])) {
                $vehicle_type = $tripInfoArray[$shiftIndex]['vehicle_type'];
                $trailer_no = $tripInfoArray[$shiftIndex]['trailer_no'];
                $register_number = $tripInfoArray[$shiftIndex]['register_number'];
                $trip_created_date = $tripInfoArray[$shiftIndex]['trip_created_date'] ?? '';
                if($trip_created_date != ""){
                    $getactual = getdatetimebytimezone($curtz, $trip_created_date, DFLT_TZ);
                    if (isset($getactual['datetime'])) {
                        $trip_created_date = $getactual['datetime'];
                    }
                }
                if ($res['trip_id'] > 0) {
                    $driver_name = $tripInfoArray[$shiftIndex]['driver_name'];
                    $driver_licence_number = $tripInfoArray[$shiftIndex]['driver_licence_number'];
                    $driver_number = $tripInfoArray[$shiftIndex]['driver_number'];
                    $driver_address = $tripInfoArray[$shiftIndex]['driver_address'];

                } elseif (isset($vehicleAndDriverArray[$shiftIndex])) {
                    $vehicle_type = $vehicleAndDriverArray[$shiftIndex]['trucktype'];
                    $trailer_no = $vehicleAndDriverArray[$shiftIndex]['trailer_no'];
                    $register_number = $vehicleAndDriverArray[$shiftIndex]['register_number'];
                    $driver_name = $vehicleAndDriverArray[$shiftIndex]['drivername'];
                    $driver_licence_number = $vehicleAndDriverArray[$shiftIndex]['driver_licence_number'];
                }
                $res['supplier_id'] = $tripInfoArray[$shiftIndex]['supplier_id'];
                $res['suppier_name'] = $tripInfoArray[$shiftIndex]['suppier_name'];
                $res['suppier_steeet_house'] = $tripInfoArray[$shiftIndex]['suppier_steeet_house'];
                $res['suppier_postalcode'] = $tripInfoArray[$shiftIndex]['suppier_postalcode'];
                $res['suppier_country'] = $tripInfoArray[$shiftIndex]['suppier_country'];
                $res['suppier_phone'] = $tripInfoArray[$shiftIndex]['suppier_phone'];
                $res['suppier_email'] = $tripInfoArray[$shiftIndex]['suppier_email'];
            }

            $getcharge = $getcostcharge = ['chargecode' => '', 'chargecodename' => '', 'quantity' => '', 'value' => '', 'rate_id' => '', 'amount' => '', 'currency' => '', 'vat_percentage' => '', 'vat_amount' => ''];
            $tot_amt = $amt = $vatamt = $cost_tot_amt = $cost_amt = $cost_vatamt = $vatamt = 0;
            $currency = $cost_currency = '';
            $chargecode = $chargecodename = $quantity = $value = $rate_id = $amount = $vat_percentage = $vat_amount = [];
            $cost_chargecode = $cost_chargecodename = $cost_quantity = $cost_value = $cost_rate_id = $cost_amount = $cost_vat_percentage = $cost_vat_amount = [];

            if ($res['chargedetails_type'] != '') {
                $chagDetailsArray = [
                    $res['chargedetails_type'],
                    $res['chargedetails_chargecode'],
                    $res['chargedetails_chargecodename'],
                    $res['chargedetails_quantity_unit'],
                    $res['chargedetails_value'],
                    $res['chargedetails_rate_id'],
                    $res['chargedetails_amount'],
                    $res['chargedetails_currency'],
                    $res['chargedetails_vat_percentage'],
                    $res['chargedetails_vat_amount'],
                ];
                $getchargeData = $ci->DataArrayFormatter_model->buildGenericArray($chagDetailsArray);

                if (!empty($getchargeData)) {
                    foreach ($getchargeData as $getcharge) {
                        if (!isset($getcharge['vat_amount']) || $getcharge['vat_amount'] == '') {
                            $getcharge['vat_amount'] = 0;
                        }
                        if (!isset($getcharge['amount']) || $getcharge['amount'] == '') {
                            $getcharge['amount'] = 0;
                        }
                        if (isset($getcharge['type'])) {
                            if ($getcharge['type'] == '0') {
                                if (isset($getcharge['charge_code'])) {
                                    $chargecode[] = $getcharge['charge_code'];
                                }
                                if (isset($getcharge['name'])) {
                                    $chargecodename[] = $getcharge['name'];
                                }
                                if (isset($getcharge['quantity_unit'])) {
                                    $quantity[] = $getcharge['quantity_unit'];
                                }
                                if (isset($getcharge['value'])) {
                                    $value[] = $getcharge['value'];
                                }
                                if (isset($getcharge['rate_id'])) {
                                    $rate_id[] = $getcharge['rate_id'];
                                }
                                if (isset($getcharge['amount'])) {
                                    $amount[] = $getcharge['amount'];
                                }
                                if (isset($getcharge['currency'])) {
                                    $currency = $getcharge['currency'];
                                }
                                if (isset($getcharge['vat_percentage'])) {
                                    $vat_percentage[] = $getcharge['vat_percentage'];
                                }
                                if (isset($getcharge['vat_amount'])) {
                                    $vat_amount[] = $getcharge['vat_amount'];
                                }
                                if (isset($getcharge['amount'])) {
                                    if ($getcharge['amount'] > 0) {
                                        $amt += $getcharge['amount'];
                                    }
                                }
                                if (isset($getcharge['vat_amount'])) {
                                    if ($getcharge['vat_amount'] > 0) {
                                        $vatamt += $getcharge['vat_amount'];
                                    }
                                }
                            } elseif ($getcharge['type'] == '1') {
                                if (isset($getcharge['charge_code'])) {
                                    $cost_chargecode[] = $getcharge['charge_code'];
                                }
                                if (isset($getcharge['name'])) {
                                    $cost_chargecodename[] = $getcharge['name'];
                                }
                                if (isset($getcharge['quantity_unit'])) {
                                    $cost_quantity[] = $getcharge['quantity_unit'];
                                }
                                if (isset($getcharge['value'])) {
                                    $cost_value[] = $getcharge['value'];
                                }
                                if (isset($getcharge['rate_id'])) {
                                    $cost_rate_id[] = $getcharge['rate_id'];
                                }
                                if (isset($getcharge['amount'])) {
                                    $cost_amount[] = $getcharge['amount'];
                                }
                                if (isset($getcharge['currency'])) {
                                    $cost_currency = $getcharge['currency'];
                                }
                                if (isset($getcharge['vat_percentage'])) {
                                    $cost_vat_percentage[] = $getcharge['vat_percentage'];
                                }
                                if (isset($getcharge['vat_amount'])) {
                                    $cost_vat_amount[] = $getcharge['vat_amount'];
                                }
                                if (isset($getcharge['amount'])) {
                                    if ($getcharge['amount'] > 0) {
                                        $cost_amt += $getcharge['amount'];
                                    }
                                }
                                if (isset($getcharge['vat_amount'])) {
                                    if ($getcharge['vat_amount'] > 0) {
                                        $cost_vatamt += $getcharge['vat_amount'];
                                    }
                                }
                            }
                        }
                    }
                    $tot_amt = $amt + $vatamt;
                    $cost_tot_amt = $cost_amt + $cost_vatamt;
                    $getcharge = ['chargecode' => implode(',', $chargecode), 'chargecodename' => implode(',', $chargecodename), 'quantity' => implode(',', $quantity), 'value' => implode(',', $value), 'rate_id' => implode(',', $rate_id), 'amount' => $amt, 'currency' => $currency, 'vat_percentage' => implode(',', $vat_percentage), 'vat_amount' => $vatamt];
                    $getcostcharge = ['chargecode' => implode(',', $cost_chargecode), 'chargecodename' => implode(',', $cost_chargecodename), 'quantity' => implode(',', $cost_quantity), 'value' => implode(',', $cost_value), 'rate_id' => implode(',', $cost_rate_id), 'amount' => $cost_amt, 'currency' => $cost_currency, 'vat_percentage' => implode(',', $cost_vat_percentage), 'vat_amount' => $cost_vatamt];
                }
            }

            $invoiced_bu_jfr = $billed_bu_jfr = '';
            $revenueDataArray = [];
            if ($res['revenue_details'] != '') {
                $rev = $cost = [];
                $getRevenueData = $ci->DataArrayFormatter_model->formatGenericParameters($res['revenue_details'], 'REVENUE');
                foreach ($getRevenueData as $eachData) {
                    if (isset($eachData['type'])) {
                        $revDataIndex = $eachData['type'];
                        if ($eachData['type'] == '0' && $eachData['recipient_role'] != 'Internal BU') {
                            if (array_key_exists('0', $revenueDataArray)) {
                            } else {
                                $revenueDataArray[$revDataIndex] = $eachData;
                            }
                        } elseif ($eachData['type'] == '1' && $eachData['recipient_role'] != 'Internal BU') {
                            if (array_key_exists('1', $revenueDataArray)) {
                            } else {
                                $revenueDataArray[$revDataIndex] = $eachData;
                            }
                        }

                        if ($eachData['recipient_role'] == 'Internal BU') {
                            if ($eachData['type'] == '0') {
                                $invoiced_bu_jfr = $eachData['bu_jfr'];
                            } elseif ($eachData['type'] == '1') {
                                $billed_bu_jfr = $eachData['bu_jfr'];
                            }
                        }
                    }
                }
            }

            $rev_foreign_currency = $rev_debtor_jfr = $rev_bu_jfr = $rev_exchange_rate = $rev_invoiceno = $rev_invoicedate = $rev_creditnote = $rev_invoice_creation_date = $rev_invoice_receivdon_date = $rev_invoice_status = '';
            $cost_foreign_currency = $cost_debtor_jfr = $cost_bu_jfr = $cost_exchange_rate = $cost_invoiceno = $cost_invoicedate = $cost_creditnote = $cost_invoice_creation_date = $cost_invoice_receivdon_date = $cost_invoice_status = '';

            if (isset($revenueDataArray[0])) {
                if (isset($revenueDataArray[0]['foreign_currency'])) {
                    $rev_foreign_currency = $revenueDataArray[0]['foreign_currency'];
                }
                if (isset($revenueDataArray[0]['debtor_jfr'])) {
                    $rev_debtor_jfr = $revenueDataArray[0]['debtor_jfr'];
                }
                if (isset($revenueDataArray[0]['bu_jfr'])) {
                    $rev_bu_jfr = $revenueDataArray[0]['bu_jfr'];
                }
                if (isset($revenueDataArray[0]['exchange_rate'])) {
                    $rev_exchange_rate = $revenueDataArray[0]['exchange_rate'];
                }
                if (isset($revenueDataArray[0]['invoice_number'])) {
                    $rev_invoiceno = $revenueDataArray[0]['invoice_number'];
                }
                if (isset($revenueDataArray[0]['invoice_date'])) {
                    if ($revenueDataArray[0]['invoice_date'] != "0000-00-00 00:00:00") {
                        $rev_invoicedate = $revenueDataArray[0]['invoice_date'];
                    }
                }
                if (isset($revenueDataArray[0]['credit_note_number'])) {
                    $rev_creditnote = $revenueDataArray[0]['credit_note_number'];
                }
                if (isset($revenueDataArray[0]['invoice_creation_date'])) {
                    if ($revenueDataArray[0]['invoice_creation_date'] != "0000-00-00 00:00:00") {
                        $rev_invoice_creation_date = $revenueDataArray[0]['invoice_creation_date'];
                    }
                }
                if (isset($revenueDataArray[0]['invoice_receivdon_date'])) {
                    if ($revenueDataArray[0]['invoice_receivdon_date'] != "0000-00-00 00:00:00") {
                        $rev_invoice_receivdon_date = $revenueDataArray[0]['invoice_receivdon_date'];
                    }
                }
                if (isset($revenueDataArray[0]['invoice_status'])) {
                    if ($revenueDataArray[0]['invoice_status'] == 0) {
                        $rev_invoice_status = "To Be Billed";
                    } elseif ($revenueDataArray[0]['invoice_status'] == 1) {
                        $rev_invoice_status = "Ready to Billed";
                    } elseif ($revenueDataArray[0]['invoice_status'] == 2) {
                        $rev_invoice_status = "Billed";
                    }
                } else {
                    $rev_invoice_status = "";
                }
            }

            if (isset($revenueDataArray[1])) {
                if (isset($revenueDataArray[1]['foreign_currency'])) {
                    $cost_foreign_currency = $revenueDataArray[1]['foreign_currency'];
                }
                if (isset($revenueDataArray[1]['debtor_jfr'])) {
                    $cost_debtor_jfr = $revenueDataArray[1]['debtor_jfr'];
                }
                if (isset($revenueDataArray[1]['bu_jfr'])) {
                    $cost_bu_jfr = $revenueDataArray[1]['bu_jfr'];
                }
                if (isset($revenueDataArray[1]['exchange_rate'])) {
                    $cost_exchange_rate = $revenueDataArray[1]['exchange_rate'];
                }
                if (isset($revenueDataArray[1]['invoice_number'])) {
                    $cost_invoiceno = $revenueDataArray[1]['invoice_number'];
                }
                if (isset($revenueDataArray[1]['invoice_date'])) {
                    if ($revenueDataArray[1]['invoice_date'] != "0000-00-00 00:00:00") {
                        $cost_invoicedate = $revenueDataArray[1]['invoice_date'];
                    }
                }
                if (isset($revenueDataArray[1]['credit_note_number'])) {
                    $cost_creditnote = $revenueDataArray[1]['credit_note_number'];
                }
                if (isset($revenueDataArray[1]['invoice_creation_date'])) {
                    if ($revenueDataArray[1]['invoice_creation_date'] != "0000-00-00 00:00:00") {
                        $cost_invoice_creation_date = $revenueDataArray[1]['invoice_creation_date'];
                    }
                }
                if (isset($cost['invoice_receivdon_date'])) {
                    if ($cost['invoice_receivdon_date'] != "0000-00-00 00:00:00") {
                        $cost_invoice_receivdon_date = $revenueDataArray[1]['invoice_receivdon_date'];
                    }
                }
                if (isset($revenueDataArray[1]['invoice_status'])) {
                    if (isset($revenueDataArray[1]['invoice_status'])) {
                        if ($revenueDataArray[1]['invoice_status'] == 0) {
                            $cost_invoice_status = "To Be Invoiced";
                        } elseif ($revenueDataArray[1]['invoice_status'] == 1) {
                            $cost_invoice_status = "Ready to Invoiced";
                        } elseif ($revenueDataArray[1]['invoice_status'] == 2) {
                            $cost_invoice_status = "Invoiced";
                        }
                    } else {
                        $cost_invoice_status = "";
                    }
                }
            }

            $vas_1_name = $vas_1_quantity = $vas_2_name = $vas_2_quantity = $vas_3_name = $vas_3_quantity = $vas_4_name = $vas_4_quantity = $vas_5_name = $vas_5_quantity = "";
            if ($res['vas_details'] != '') {
                $vasData = $ci->DataArrayFormatter_model->formatGenericParameters($res['vas_details'], 'VAS');
                if (!empty($vasData) && count($vasData) > 0) {
                    $v = 1;
                    foreach ($vasData as $vas) {
                        if (isset($vas['vas_name']) && isset($vas['vas_quantity'])) {
                            if ($v == 1) {
                                $vas_1_name = $vas['vas_name'];
                                $vas_1_quantity = $vas['vas_quantity'];
                            } elseif ($v == 2) {
                                $vas_2_name = $vas['vas_name'];
                                $vas_2_quantity = $vas['vas_quantity'];
                            } elseif ($v == 3) {
                                $vas_3_name = $vas['vas_name'];
                                $vas_3_quantity = $vas['vas_quantity'];
                            } elseif ($v == 4) {
                                $vas_4_name = $vas['vas_name'];
                                $vas_4_quantity = $vas['vas_quantity'];
                            } elseif ($v == 5) {
                                $vas_5_name = $vas['vas_name'];
                                $vas_5_quantity = $vas['vas_quantity'];
                            }
                        }
                        $v++;
                    }
                }
            }

            $service_name = "";
            if ($res['name_of_service'] != '') {
                $service_name = $res['name_of_service'];
            }
            $order_type = $delivery_term = "";
            if ($res['order_type'] != '') {
                $order_type = $res['order_type_name'];
            }
            if ($res['delivery_term_name'] != '') {
                $delivery_term = $res['delivery_term_name'];
            }

            $pod_available = $res['pod_available'];
            if ($pod_available != "" && $pod_available != "0000-00-00 00:00:00" && $pod_available != "0") {
                $poddate = getdatetimebytimezone($curtz, $pod_available, DFLT_TZ);
                $pod_available = date('Y-m-d h:i A', strtotime($poddate['datetime']));
            }

            $accepted = '';
            $res['driver_acceptance_date'] = '';
            $shiftIndex = $res['shift_id'];
            if (isset($driverAcceptanceArray[$shiftIndex])) {
                $res['driver_acceptance_date'] = $driverAcceptanceArray[$shiftIndex]['driver_acceptance_date'];
            }

            if ($res['driver_acceptance_date'] != '') {
                $accepted = $res['driver_acceptance_date'];
                if ($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0") {
                    $acceptdate = getdatetimebytimezone($curtz, $accepted, DFLT_TZ);
                    $accepted = date('Y-m-d h:i A', strtotime($acceptdate['datetime']));
                }
            }

            $shiftIndex = $res['shift_id'];
            $res['generic_status_status_name'] = $res['generic_status_status_code'] = '';
            if (isset($genericStatusArray[$shiftIndex])) {
                $res['generic_status_status_name'] = $genericStatusArray[$shiftIndex]['generic_status_status_name'];
                $res['generic_status_status_code'] = $genericStatusArray[$shiftIndex]['generic_status_status_code'];
            }

            $tempResId = $res['id'];
            $action = '<div class="checkbox checkbox-info">
                <label>
                    <input type="checkbox" name="check_box" id="' . $tempResId . '" value="' . $tempResId . '">
                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                </label>
                </div>';

            $stackable = '';
            $dgGoods = '';
            $stackableExplode = explode(',', $res['cargo_total_stackable']);
            if (!empty($stackableExplode)) {
                foreach ($stackableExplode as $eachStackable) {
                    if ($eachStackable == '1') {
                        $stackable = $stackable . 'Yes,';
                    } else {
                        $stackable = $stackable . 'No,';
                    }
                }
            }
            $dgGoodsExplode = explode(',', $res['cargo_total_dg_goods']);
            if (!empty($dgGoodsExplode)) {
                foreach ($dgGoodsExplode as $eachDg) {
                    if ($eachDg == '1') {
                        $dgGoods = $dgGoods . 'Yes,';
                    } else {
                        $dgGoods = $dgGoods . 'No,';
                    }
                }
            }
            $stackable = rtrim($stackable, ",");
            $dgGoods = rtrim($dgGoods, ",");

            // order status data
            //Manifest and scanned status added in KNAU (company-code)
            if (($order_status === 'PENDING') && ($res['company_code'] === 'AUKN' || $res['company_code'] === 'KNAU')) {
                $statuslist = $this->db->select("status_code")
                    ->order_by("id", "DESC")
                    ->get_where("tb_order_status", ['order_id' => $res['id'], 'status' => '1']);

                if ($statuslist->num_rows() > 0) {
                    $status_code = $statuslist->row()->status_code;

                    if ($status_code == '2491') {
                        $order_status = "SCANNED";
                    }
                    if ($status_code == '2492') {
                        $order_status = 'MANIFESTED';
                    }
                }
            }

            // salog Reference data
            $actualPickupDateTime = $actualDeliveryDateTime = $accpectDateTime = $gateinDateTime = $gateoutDateTime = $intransistDateTime = $gateindesDateTime = $gateoutdesDateTime = '';
            if ($res['id'] > 0) {
                $actual_picup_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'stop_type' => 'P', 'status_code' => '0500'], 'createdon', 'tb_stop_status', 1, 0);
                if (!empty($actual_picup_dt)) {
                    $actual_picup_date = getdatetimebytimezone($curtz,$actual_picup_dt['createdon'],DFLT_TZ);
                    $actualPickupDateTime = date('d-m-Y h:i A', strtotime($actual_picup_date['datetime']));
                }
            }

            if ($res['id'] > 0) {
                $actual_delivery_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'stop_type' => 'D', 'status_code' => '3000'], 'createdon', 'tb_stop_status', 1, 0);
                if (!empty($actual_delivery_dt)) {
                    $actual_delivery_date = getdatetimebytimezone($curtz,$actual_delivery_dt['createdon'],DFLT_TZ);
                    $actualDeliveryDateTime = date('d-m-Y h:i A', strtotime($actual_delivery_date['datetime']));
                }
            }
            if ($res['id'] > 0) {
                $accpect_status_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'trip_id' => $res['trip_id'], 'status_id' => '10'], 'createdon', 'tb_stop_status', 1, 0);
                if(!empty($accpect_status_dt)){
                    $accpectDateTimeData = getdatetimebytimezone($curtz,$accpect_status_dt['createdon'],DFLT_TZ);
                    $accpectDateTime = $accpectDateTimeData['datetime'];
                }

            }
            if ($res['id'] > 0) {
                $gatein_status_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'trip_id' => $res['trip_id'], 'stop_type' => 'P', 'status_id' => '2'], 'createdon', 'tb_stop_status', 1, 0);
                if(!empty($gatein_status_dt)){
                    $gateinDateTimeData = getdatetimebytimezone($curtz,$gatein_status_dt['createdon'],DFLT_TZ);
                    $gateinDateTime = $gateinDateTimeData['datetime'];
                }

            }
            if ($res['id'] > 0) {
                $gateout_status_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'trip_id' => $res['trip_id'], 'stop_type' => 'P', 'status_id' => '3'], 'createdon', 'tb_stop_status', 1, 0);
                if(!empty($gateout_status_dt)){
                    $gateoutDateTimeData = getdatetimebytimezone($curtz,$gateout_status_dt['createdon'],DFLT_TZ);
                    $gateoutDateTime = $gateoutDateTimeData['datetime'];
                }

            }
            if ($res['id'] > 0) {
                $intransist_status_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'trip_id' => $res['trip_id'], 'stop_type' => 'P', 'status_id' => '4'], 'createdon', 'tb_stop_status', 1, 0);
                if(!empty($intransist_status_dt)){
                    $intransistDateTimeData = getdatetimebytimezone($curtz,$intransist_status_dt['createdon'],DFLT_TZ);
                    $intransistDateTime = $intransistDateTimeData['datetime'];
                }

            }
            if ($res['id'] > 0) {
                $gateindes_status_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'trip_id' => $res['trip_id'], 'stop_type' => 'D', 'status_id' => '2'], 'createdon', 'tb_stop_status', 1, 0);
                if(!empty($gateindes_status_dt)){
                    $gateindesDateTimeData = getdatetimebytimezone($curtz,$gateindes_status_dt['createdon'],DFLT_TZ);
                    $gateindesDateTime = $gateindesDateTimeData['datetime'];
                }

            }
            if ($res['id'] > 0) {
                $gateoutdes_status_dt = $ci->common->gettblrowdata(['order_id' => $res['id'], 'trip_id' => $res['trip_id'], 'stop_type' => 'D', 'status_id' => '3'], 'createdon', 'tb_stop_status', 1, 0);
                if(!empty($gateoutdes_status_dt)){
                    $gateoutdesDateTimeData = getdatetimebytimezone($curtz,$gateoutdes_status_dt['createdon'],DFLT_TZ);
                    $gateoutdesDateTime = $gateoutdesDateTimeData['datetime'];
                }

            }

			if ($res['id'] > 0 && !empty($res['order_id'])) {
                $statusInfoArray = $ci->DataQueryFormatter_model->getLastStatusDetails($res['order_id']);
				$lat = $statusInfoArray[0]['latitude'] ?? '';
				$lang = $statusInfoArray[0]['longitude'] ?? '';
				$lastStatus = $statusInfoArray[0]['status_name'] ?? '';
				$lastLocName = $statusInfoArray[0]['loc_name'] ?? '';
				$lastLocDateTime = $statusInfoArray[0]['createdon'] ?? '';
				$lastStatusCode = $statusInfoArray[0]['status_code'] ?? '';

                $statusToName = ['0500' => 'Actual Pick Up', '3000' => 'Delivered to Consignee', '2300' => 'Arrival at Delivery Point'];
                $statusFinalName = $statusToName[$lastStatusCode] ?? '';

                if (empty($statusFinalName)) {
                    $statusFinalName = $lastStatus;
                }

				if (empty($lastLocName)) {
                    $lastLocName = ($lat != "" && $lang != "") ? getLocationName($lat, $lang) : '';
				}
            }

            $result_array[] = [
                'ord_id' => $res['order_id'],
                'delivery_ord_no' => $delivery_note,
                'purchase_ord_no' => $purchase_order,
                'ord_creation_dttme' => date('d-m-Y', strtotime($res['createdon'])),
                'ord_pickup_dttme' => $early_pickup,
                'ord_delivery_dttme' => $early_delivery,
                'shipr_id' => $shipper_details['id'],
                'shipr_cid' => $shipper_details['code'],
                'shipr_acon_debtor_code' => $shipper_details['acon'],
                'shipr_kn_login_account' => $shipper_details['kn_login'],
                'shipr_vat_reg_no' => $shipper_details['vat_reg_no'],
                'shipr_tax_payer_id' => $shipper_details['tax_payer_no'],
                'shipr_name' => $res['pickup_company'],
                'shipr_steeet_and_house_no' => $shipper_details['street'],
                'shipper_province' => $shipper_details['state'],
                'shipr_city' => $shipper_details['city'],
                'shipr_postal_code' => $shipper_details['pincode'],
                'shippper_country_name' => $shipper_details['country'],
                'shipr_phone' => $shipper_details['phone'],
                'shipr_email' => $shipper_details['email'],
                'consignee_id' => $drop_details['id'],
                'consignee_cid' => $drop_details['code'],
                'consignee_acon_debtor_code' => $drop_details['acon'],
                'consignee_kn_login_account' => $drop_details['kn_login'],
                'consignee_vat_reg_no' => $drop_details['vat_reg_no'],
                'consignee_tax_payer_id' => $drop_details['tax_payer_no'],
                'consignee_name' => $res['delivery_company'],
                'consignee_steeet_and_house_no' => $drop_details['street'],
                'consignee_province' => $drop_details['state'],
                'consignee_city' => $drop_details['city'],
                'consignee_postal_code' => $drop_details['pincode'],
                'consignee_country_name' => $drop_details['country'],
                'consignee_phone' => $drop_details['phone'],
                'consignee_email' => $drop_details['email'],
                'customer_id' => $customer_details['id'],
                'customer_cid' => $customer_details['code'],
                'customer_acon_debtor_code' => $customer_details['acon'],
                'customer_kn_login_account' => $customer_details['kn_login'],
                'customer_vat_reg_no' => $customer_details['kn_login'],
                'customer_tax_payer_id' => $customer_details['tax_payer_no'],
                'customer_name' => $customer_details['name'],
                'customer_steeet_and_house_no' => $customer_details['street'],
                'customer_postal_code' => $customer_details['pincode'],
                'customer_country_name' => $customer_details['country'],
                'customer_phone' => $customer_details['phone'],
                'customer_email' => $customer_details['email'],
                'country' => $customer_details['country'],
                'branch' => $res['branch_code'],
                'department_code' => $res['department_code'],
                'product' => $res['product'],
                'service' => $service_name,
                'incoterms' => $res['incoterm'],
                'delivery_terms' => $delivery_term,
                'delivery_note' => $delivery_note,
                'notify_party' => $notify_address['name'],
                'ord_type' => $order_type,
                'mode_of_transport' => $res['transport_mode'],
                'purchase_ord' => $purchase_order,
                'qty' => $res['cargo_total_quantity'],
                'package_type' => $res['cargo_total_package_type'],
                'length' => $res['cargo_total_length'],
                'length_unit' => $res['cargo_total_length_unit'],
                'width' => $res['cargo_total_width'],
                'width_unit' => $res['cargo_total_width_unit'],
                'height' => $res['cargo_total_height'],
                'height_unit' => $res['cargo_total_height_unit'],
                'weight' => $res['cargo_total_second_weight'],
                'weight_unit' => $res['cargo_total_weight_unit'],
                'volume' => $res['cargo_total_second_volume'],
                'volume_unit' => $res['cargo_total_volume_unit'],
                'ldm' => $res['cargo_total_ldm'],
                'volumetric_weight' => $res['cargo_total_volumetric_weight'],
                'volumetric_weight_unit' => $res['cargo_total_volweight_uom'],
                'stackable' => $stackable,
                'dg_goods' => $dgGoods,
                'actual_weight' => $res['carg_total_weight'],
                'actual_weight_unit' => $res['cargo_total_weight_unit'],
                'actual_volume' => $res['cargo_total_volume'],
                'actual_volume_unit' => $res['cargo_total_volume_unit'],
                'vas_1_name' => $vas_1_name,
                'vas_1_qty' => $vas_1_quantity,
                'vas_2_name' => $vas_2_name,
                'vas_2_qty' => $vas_2_quantity,
                'vas_3_name' => $vas_3_name,
                'vas_3_qty' => $vas_3_quantity,
                'vas_4_name' => $vas_4_name,
                'vas_4_qty' => $vas_4_quantity,
                'vas_5_name' => $vas_5_name,
                'vas_5_qty' => $vas_5_quantity,
                'ref_1_name' => $ref_1_name,
                'ref_1_desc' => $ref_1_description,
                'ref_1_value' => $ref_1_value,
                'ref_2_name' => $ref_2_name,
                'ref_2_desc' => $ref_2_description,
                'ref_2_value' => $ref_2_value,
                'ref_3_name' => $ref_3_name,
                'ref_3_desc' => $ref_3_description,
                'ref_3_value' => $ref_3_value,
                'ref_4_name' => $ref_4_name,
                'ref_4_desc' => $ref_4_description,
                'ref_4_value' => $ref_4_value,
                'ref_5_name' => $ref_5_name,
                'ref_5_desc' => $ref_5_description,
                'ref_5_value' => $ref_5_value,
                'driver_pickup_inst' => $getstatusdates['statuspickupdate'],
                'driver_delivery_inst' => $getstatusdates['statusdeliverydate'],
                'status_pickedup' => '',
                'status_delivered' => '',
                'org_doc_received' => $docs_received_datetime,
                'org_doc_sent' => $docs_sent_datetime,
                'trip_id' => $trip_no,
                'trip_row_id'=>$trip_id,
                'carrier' => $res['suppier_name'],
                'vehicle_no' => $register_number,
                'trailer_no' => $trailer_no,
                'vehicle_type' => $vehicle_type,
                'driver_name' => $driver_name,
                'driver_licence_no' => $driver_licence_number,
                'driver_number'=>$driver_number,
                'driver_address' => $driver_address,
                'trip_created_date' => $trip_created_date,
                'payer_role' => 'Customer',
                'payer_id' => $res['payer_id'],
                'payer_name' => $res['payer_name'],
                'payer_cid' => $res['payer_cid'],
                'payer_acon_debtor_code' => $res['payer_acondebtorcode'],
                'payer_kn_login_account' => $res['payer_kn_login_account'],
                'payer_vat_reg_no' => $res['payer_vat_regno'],
                'payer_tax_payer_id' => $res['payer_tax_payerid'],
                'payer_steeet_and_house_no' => $res['payer_steeet_house'],
                'payer_postal_code' => $res['payer_postal'],
                'payer_country_name' => $res['payer_country'],
                'payer_phone' => $res['payer_phone'],
                'payer_email' => $res['payer_email'],
                'rev_chrg_code' => $getcharge['chargecode'],
                'rev_chrg_name' => $getcharge['chargecodename'],
                'rev_chrg_qty' => $getcharge['quantity'],
                'rev_chrg_value' => $getcharge['value'],
                'rev_chrg_rate_id' => $getcharge['rate_id'],
                'rev_chrg_amount' => $getcharge['amount'],
                'rev_chrg_currency' => $getcharge['currency'],
                'rev_chrg_vat' => $getcharge['vat_percentage'],
                'rev_chrg_vat_amount' => $getcharge['vat_amount'],
                'rev_chrg_total' => '',
                'rev_bu_jfr' => $invoiced_bu_jfr,
                'rev_jfr' => $rev_debtor_jfr,
                'rev_exchange_rate' => $rev_exchange_rate,
                'rev_foreign_currency' => $rev_foreign_currency,
                'rev_invoice_no' => $rev_invoiceno,
                'rev_invoice_date' => $rev_invoicedate,
                'rev_credit_note_no' => $rev_creditnote,
                'rev_credit_note_date' => '-',
                'rev_invoice_creation_date' => $rev_invoice_creation_date,
                'rev_invoice_received_date' => $rev_invoice_receivdon_date,
                'rev_status' => $rev_invoice_status,
                'customer_contract_no' => $customer_details['contract_no'],
                'customer_contract_date' => $customer_details['contract_date'],
                'invoice_status' => $cost_invoice_status,
                'suppier_role' => '',
                'suppier_id' => $res['supplier_id'],
                'suppier_name' => $res['suppier_name'],
                'suppier_steeet_and_house_no' => $res['suppier_steeet_house'],
                'suppier_postal_code' => $res['suppier_postalcode'],
                'suppier_country_name' => $res['suppier_country'],
                'suppier_phone' => $res['suppier_phone'],
                'suppier_email' => $res['suppier_email'],
                'cost_chrg_code' => $getcostcharge['chargecode'],
                'cost_chrg_name' => $getcostcharge['chargecodename'],
                'cost_chrg_qty' => $getcostcharge['quantity'],
                'cost_chrg_value' => $getcostcharge['value'],
                'cost_chrg_rate_id' => $getcostcharge['rate_id'],
                'cost_chrg_amount' => $getcostcharge['amount'],
                'cost_chrg_currency' => $getcostcharge['currency'],
                'cost_chrg_vat' => $getcostcharge['vat_percentage'],
                'cost_chrg_vat_amount' => $getcostcharge['vat_amount'],
                'cost_bu_jfr' => $billed_bu_jfr,
                'cost_jfr' => $cost_debtor_jfr,
                'cost_exchange_rate' => $cost_exchange_rate,
                'cost_foreign_currency' => $cost_foreign_currency,
                'salog_ref' => $salog_ref,
                'order_status' => $order_status,
                'pod_status' => $res['pod'],
                'actual_pickup_date_time' => $actualPickupDateTime,
                'actual_delivery_date_time' => $actualDeliveryDateTime,
				'last_status' => $statusFinalName,
				'last_status_location' => $lastLocName,
				'last_status_time' => $lastLocDateTime,
				'accept' => $accpectDateTime,
				'gate_in_origin' => $gateinDateTime,
				'gate_out_origin' => $gateoutDateTime,
				'in_transit' => $intransistDateTime,
				'gate_in_dest' => $gateindesDateTime,
				'gate_out_dest' => $gateoutdesDateTime,
                'transit_time_in_hours' => $res['transit_time_in_hours'] ? $res['transit_time_in_hours'] : '',
                'rap_date' => $res['rap_date'],
                'rap_status' => $res['rap_status'] ? $res['rap_status'] : 'N',
                'bap' => " ",
                'remarks_issues' => " "
            ];
        }

        return $result_array;
    }


}
