<?php

class Customeramchartslib
{
    private $ci;

    function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(['common', 'customerpiechartmodel']);
    }

    public function getPieChartData(int $currentYear = 0): array
    {
        $ci = &get_instance();
        $whereClause = $this->getWhereClause();
        $whereClause['currentYear'] = $currentYear == 0 ? DATE("Y") : $currentYear;
        $pendingOrders = $ci->customerpiechartmodel->getPendingOrders($whereClause);
        $activeOrders = $ci->customerpiechartmodel->getActiveOrders($whereClause);
        $activePendingOrders = [["Name" => "Pending", "Count" => (int)$pendingOrders, "Color" => $this->random_color()], ["Name" => "Active", "Count" => (int)$activeOrders, "Color" => $this->random_color()]];

        $transportModeOrders = [];
        $modeOfTransportOrders = $ci->customerpiechartmodel->getOrdersbyModeofTransport($whereClause);
        foreach ($modeOfTransportOrders as $orders) {
            $transportModeOrders[] = ["Name" => $orders['transport_mode'], "Count" => (int)$orders['order_count'], "Color" => $this->random_color()];
        }
        $deliveryOrdersInfo = [];
        $deliveryTypeOrder = $ci->customerpiechartmodel->getDeliveryTypeOrder($whereClause);
        foreach ($deliveryTypeOrder as $orderType) {
            $deliveryOrdersInfo[] = ["Name" => $orderType['OrderType'], "Count" => (int)$orderType['order_count'], "Color" => $this->random_color()];
        }
        $data = [
            "activePendingOrders" => $activePendingOrders,
            "transportModeOrders" => $transportModeOrders,
            "deliveryOrdersInfo" => $deliveryOrdersInfo
        ];
        return !empty($data) ? $data : [];
    }

    public function random_color(): string
    {
        $colors = ["#0080bf", "#00acdf", "#15AAFF","#55d0ff", "#7ce8ff","#ccf9ff","#2EAAFA"];
        $randomIndex = array_rand($colors);
        return $colors[$randomIndex];
    }

    public function getGaugeChartData(array $yearInfo): array
    {
        $ci = &get_instance();
        $whereClause = $this->getWhereClause();
        if ($yearInfo["currentYear"] == 0 && $yearInfo["currentMonth"] == 0 && $yearInfo["currentweek"] == 0) {
            return [];
        }
        $data['noPodOrders'] = $ci->customerpiechartmodel->getPodNotAvailableOrders($yearInfo, $whereClause);
        $data['deliveryDelayedOrders'] = $ci->customerpiechartmodel->getDelayedOrders($yearInfo, $whereClause, "D");
        $data['pickupDelayedOrders'] = $ci->customerpiechartmodel->getDelayedOrders($yearInfo, $whereClause, "P");
        return $data ?? [];
    }

    public function getLineAreaChartData(array $yearInfo): array
    {
        $ci = &get_instance();
        $whereClause = $this->getWhereClause();
        if ($yearInfo["currentYear"] == 0 && $yearInfo["currentMonth"] == 0) {
            return [];
        }
        $data = $ci->customerpiechartmodel->getLineAreaChartOrders($yearInfo, $whereClause);
        return $data ?? [];
    }

    private function getWhereClause(): array
    {
        $ci = &get_instance();
        $companyCode = $ci->session->userdata('company_code');
        $businessType = $ci->session->userdata("business_type");
        if ($businessType == "Country Admin") {
            $userIds = $ci->session->userdata('country_user_ids');
        }
        if ($businessType == "Truck_Owner") {
            $userIds[] = $ci->session->userdata("user_id");
        }
        if ($businessType == "Customer") {
            $customerId = $ci->session->userdata("cust_id");
        }
        if ($businessType == "Carrier") {
            $vendorId = $ci->session->userdata("id");
        }
        return [
            'companyCode' => $companyCode,
            'businessType' => $businessType,
            'userIds' => $userIds ?? [],
            'customerId' => $customerId ?? 0,
            'vendorId' => $vendorId ?? 0
        ];
    }

    public function getLaneWiseReportData(int $userid, array $searchData,int $shipmentcount): array
    {
        $ci = &get_instance();
        $lanewisecount = [];
        $laneInfo = $ci->customerpiechartmodel->getLaneWiseReport($userid, $searchData);
        if (!empty($laneInfo)) {
            foreach ($laneInfo as $lane) {
                $orderPercentage = round(($lane['laneOrdercount']/$shipmentcount) * 100);
                $lanewisecount[] = [
                    "laneName" => $lane['citylane'],
                    "laneordercount" => $orderPercentage,
                    "Color" => $colors[$i]
                ];
                $i++;
            }
        }
        return $lanewisecount ?? [];
    }

}
