<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customstatustoknlogin
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['Order', 'common']);
        $this->ci->load->library('knlogin');
    }

    public function sendCustomStatustoKNlogin(int $order_id): void
    {
        $ids[] = $order_id;
        $notSentOrders = $ordersToSent = $orderIds = $inTransitData = $orderRowIds = $statusIds = $orderStatusIds = $sentOrders = $statusOrders = [];
        $currentDate = date('Y-m-d H:i:s');
        $updatedDate = date('Y-m-d\TH:i:s', strtotime($currentDate));
        $checkOrders = $this->ci->Order->checkMyknCustomerFromOrders(
            "o.id,
             o.order_id,
             o.pickup_city,
             o.delivery_city,
             o.user_id,
             o.company_code,
             o.branch_code,
             o.modeoftransport,
             o.shift_id,
             o.trip_id,
             o.shipmentid,
             o.is_created,
             o.shift_id,
             c.name,
             c.sendto_knlogin,
             d.department_code",
            $ids
        );
        if (empty($checkOrders)) {
            log_message("error", "Customer Does not have send to Kn option: " . $order_id);
            return;
        }
        $LogicalReceiver = "WWWWW99";
        $PhysicalReceiver = 'WWDPT01';
        $PhysicalSender = 'KNRLG09';
        if (SYS_TYPE == 'TMS') {
            $PhysicalReceiver = 'WWDPP01';
            $PhysicalSender = 'KNRLG01';
        }
        foreach ($checkOrders as $eachOrder) {
            if ($eachOrder['sendto_knlogin'] == 1) {
                if ($eachOrder['shift_id'] > 0) {
                    if ($eachOrder['is_created'] == 2) {
                        $orderIds[] = $eachOrder['id'];
                        $company_code = $eachOrder['company_code'];
                        $branch_code = $eachOrder['branch_code'];
                        $cntrycode = substr($company_code, 0, 2);
                        $curtz = "Asia/Singapore";
                        $dthrs = "+08.00";
                        $code = 66;
                        $cntryname = "Singapore";
                        $cntrys = $this->ci->common->gettblrowdata(["country_code" => $cntrycode, "status" => 1], "country_name,cntry_timezone,cntry_hrs,phone_code", "tbl_country_master", 0, 0);
                        if (!empty($cntrys)) {
                            $curtz = $cntrys['cntry_timezone'];
                            $dthrs = $cntrys['cntry_hrs'];
                            $cntryname = $cntrys['country_name'];
                            $code = $cntrys['phone_code'];
                        }
                        $gentime = getdatetimebytimezone($curtz, $currentDate, DFLT_TZ);
                        $currentdt = $gentime['datetime'];
                        $logicalinfo = $this->ci->common->gettblrowdata(['company_code' => $company_code, 'branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
                        $logicalSender = $logicalinfo['logical_sender'] ?: "THPNA74";
                        $ordersToSent[$eachOrder['id']] = [
                            'id' => $eachOrder['id'],
                            'order_id' => $eachOrder['order_id'],
                            'pickup_city' => $eachOrder['pickup_city'],
                            'delivery_city' => $eachOrder['delivery_city'],
                            'company_code' => $eachOrder['company_code'],
                            'branch_code' => $eachOrder['branch_code'],
                            'modeoftransport' => $eachOrder['modeoftransport'],
                            'shift_id' => $eachOrder['shift_id'],
                            'timeZone' => $curtz,
                            'timeZoneHours' => $dthrs,
                            'logicalSender' => $logicalSender,
                            'shipmentid' => $eachOrder['shipmentid']
                        ];
                    } else {
                        $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Order is not Sent To Knlogin', 'status' => 0];
                    }
                } else {
                    $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Trip is not created for Order', 'status' => 0];
                }
            } else {
                $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Send To KnLogin not enabled', 'status' => 0];
            }
        }
        if (!empty($orderIds)) {
            $getStops = $this->ci->Order->getOrderDetailsWithStopsStatus($orderIds);
            foreach ($getStops as $eachStopId) {
                if ($eachStopId["driver_id"] != "") {
                    $statusIds[] = $eachStopId['id'];
                } else {
                    $orderStatusIds[] = $eachStopId['id'];
                }
                $orderRowId = $eachStopId['order_id'];
                if (!in_array($eachStopId['order_id'], $statusOrders, true)) {
                    $statusOrders[] = $eachStopId['order_id'];
                }
                $getactual = getdatetimebytimezone($ordersToSent[$orderRowId]['timeZone'], $eachStopId['createdon'], DFLT_TZ);
                $createdon = $getactual['datetime'];
                $date = $getactual['date'];
                $time = $getactual['time'] . "" . $ordersToSent[$orderRowId]['timeZoneHours'];
                $statusDateTime = date('Y-m-d\TH:i:s', strtotime($createdon)) . "" . $ordersToSent[$orderRowId]['timeZoneHours'];
                $statusToBeSent = [
                    "shipment_id" => $ordersToSent[$orderRowId]['shipmentid'] ?? "",
                    "shipmentid" => $ordersToSent[$orderRowId]['shipmentid'] ?? "",
                    "latitude" => $eachStopId['latitude'] ?? "",
                    "longitude" => $eachStopId['longitude'] ?? "",
                    "status_code" => $eachStopId['status_code'] ?? "",
                    "status_location" => $eachStopId['loc_name'] ?? "",
                    "company_code" => $ordersToSent[$orderRowId]['company_code'] ?? "",
                    "branch_code" => $ordersToSent[$orderRowId]['branch_code'] ?? "",
                    "pickup_city" => $ordersToSent[$orderRowId]['pickup_city'] ?? "",
                    "delivery_city" => $ordersToSent[$orderRowId]['delivery_city'] ?? "",
                    "logicalreceiver" => $LogicalReceiver,
                    "physicalreceiver" => $PhysicalReceiver,
                    "physicalsender" => $PhysicalSender,
                    "logicalsender" => $ordersToSent[$orderRowId]['logicalSender'],
                    "modeoftransport" => $ordersToSent[$orderRowId]['modeoftransport'] ?? "",
                    "department_code" => $ordersToSent[$orderRowId]['department_code'] ?? "",
                    "trackingnumber" => $ordersToSent[$orderRowId]['order_id'] ?? "",
                    "ref_id" => "INN",
                    "ref_num" => "RL" . $ordersToSent[$orderRowId]['order_id'] ?? "",
                    "createdon" => $createdon,
                    "date" => $date,
                    "time" => $time,
                    'curdt' => $statusDateTime,
                    'curdt1' => $updatedDate,
                    "order_id" => $ordersToSent[$orderRowId]['order_id'] ?? "",
                    "createdon" => '',

                ];
                if ($eachStopId['status_code'] != '1550') {
                    $this->ci->knlogin->knloginsendorderstatus($statusToBeSent);
                } else {
                    $inTransitData[$eachStopId['id']] = (object)$statusToBeSent;
                    if (!in_array($eachStopId['order_id'], $orderRowIds, true)) {
                        $orderRowIds[] = $eachStopId['order_id'];
                    }
                }
            }
            if (!empty($inTransitData)) {
                $this->ci->knlogin->sendHighestIntransitStatusFORCNTW($inTransitData, $orderRowIds, ['companyCode' => $ordersToSent[$orderRowId]['company_code'] ?? "", 'branchCode' => $ordersToSent[$orderRowId]['branch_code'] ?? "", 'timeZone' => $ordersToSent[$orderRowId]['timeZone'], 'updatedDate' => $updatedDate, 'hours' => $ordersToSent[$orderRowId]['timeZoneHours']]);
            }
        }
        if (!empty($statusIds)) {
            $this->ci->common->updatetbledata("tb_stop_status", ["sentknlogin" => 1], "id IN (" . implode(',', $statusIds) . ")");
        }
        if (!empty($orderStatusIds)) {
            $this->ci->common->updatetbledata("tb_order_status", ["sentknlogin" => 1], "id IN (" . implode(',', $orderStatusIds) . ")");
        }
    }

}
