<?php
class DelhiveryB2BEDIServices {
	public $shiftId;
	private $CI;
	private $returnOrderTypeId = '16';

	public function __construct() {
		$this->CI = &get_instance();
		$this->CI->load->model(['common','DelhiveryB2BEDIModel']);
		$this->CI->load->library('Edi_logger');
	}

	public function triggerDelhiveryAPI(int $shiftId) : int {
		$this->shiftId = $shiftId;
		if ($this->checkWareHouse() !== 1 ) {
			return 0;
		}
		return 1;
	}

	public function generateDelhiveryToken(): void {
		$message = '';
		$credentials = [
			"username"=>DELHIVERY_LOGIN_USERNAME,
			"password"=>DELHIVERY_LOGIN_PASSWORD
		];
		$authData = json_encode($credentials);
		$this->CI->edi_logger->setEdi_request($authData);
		$serverURL = DELHIVERY_SERVER_BASE_URL.'ums/login/';
		log_message('error',"DELHIVERY CAREER for {$serverURL} Payload credentials => {$authData}");
		try {
			$curl = curl_init();
			curl_setopt_array($curl, [
				CURLOPT_URL => $serverURL,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS =>$authData,
				CURLOPT_HTTPHEADER => ['Content-Type: application/json']
			]);
			$response = curl_exec($curl);
			curl_close($curl);

			$apiResponse = json_decode($response, true);
			if (!empty($apiResponse) && is_array($apiResponse) && isset($apiResponse['jwt'])) {
				$isUpdate = $this->CI->common->gettblrowdata(['token_for' => 'DELHIVERY_LIMITED','status'=>1],"id","tb_auth_tokens",0,0);
				if (!empty($isUpdate)) {
					$status = $this->CI->common->updatetbledata("tb_auth_tokens", ['auth_token' => $apiResponse['jwt'], 'updated_on' => date('Y-m-d H:i:s')], ['id' => $isUpdate['id']]);
				} else {
					$status = $this->CI->common->insertTableData("tb_auth_tokens", [
						'auth_token'    => $apiResponse['jwt'],
						'created_on'    => date('Y-m-d H:i:s'),
						'updated_on'    => date('Y-m-d H:i:s'),
						'token_for'     => 'DELHIVERY_LIMITED',
						'status'        => 1
					]);
				}
				if ($status) {
					log_message('error',"DELHIVERY CAREER Token generated successfully @ ".gmdate('d-m-Y H:i:00'));
					$this->sendJWTTokentoAltova($apiResponse['jwt']);
				}
			} else {
				log_message('error','Unable to generate Delhivery Token @ '.gmdate('d-m-Y H:i:00'));
			}
		} catch (Exception $e) {
			$message = 'Error: ' . $e->getMessage();
		} finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('DELHIVERY CARRIER Auth Token Generation');
            $this->CI->edi_logger->setBounded_type(1);
            $this->CI->edi_logger->setEdi_format_type('JSON');
            $this->CI->edi_logger->setStatus(((isset($apiResponse['jwt']) && $apiResponse['jwt']) ? 1 : 0));
            $this->CI->edi_logger->setEdi_response(json_encode($response));
            $this->CI->edi_logger->setObj_type_name('DELHIVERY CARRIER Auth Token Generation');
            $this->CI->edi_logger->saveToEdiLogs();
        }
	}

	public function updateToken(): void {
		$tokenInfo = $this->CI->common->gettblrowdata(['token_for' => 'DELHIVERY_LIMITED','status'=>1],"updated_on","tb_auth_tokens",0,0);
		if (!empty($tokenInfo)) {
			$now 		= strtotime(date('Y-m-d H:i:s'));
			$updatedOn 	= strtotime($tokenInfo['updated_on']);
			$minutes 	= round(abs($now-$updatedOn) / 60,2);
			if ($minutes > 15) {
				$this->generateDelhiveryToken();
			}
		}
	}

	private function sendJWTTokentoAltova(string $apiToken) : string {
		$data = 'jwtToken='.$apiToken;
		try {
			$curl = curl_init(ALTOVA_API_TOKEN_URL);
			curl_setopt($curl, CURLOPT_URL, ALTOVA_API_TOKEN_URL);
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$headers = ["Content-Type: application/x-www-form-urlencoded"];
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
			$response = curl_exec($curl);
			if ($response === false) {
				log_message('error', 'sendElg360order request failed: ' . curl_error($curl));
			}
			log_message("error", "JWT token Response".$response);
			curl_close($curl);
		} catch (Exception $ex) {
			$response = "";
			log_message("error", "Some Problem occured!, While Sending JWT Token to Altova " . $ex->getMessage());
		} finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('Send DELHIVERY LTD Auth to Altova');
            $this->CI->edi_logger->setBounded_type(1);
            $this->CI->edi_logger->setEdi_format_type('JSON');
            $this->CI->edi_logger->setStatus((isset($response) && $response ? 1 : 0));
            $this->CI->edi_logger->setEdi_response($response);
            $this->CI->edi_logger->setObj_type_name('Send DELHIVERY LTD Auth to Altova');
            $this->CI->edi_logger->saveToEdiLogs();
        }
		return $response;
	}

	public function checkWareHouse() {
		$this->updateToken();
		$orders = $this->getOrderInfo();
		if (count($orders) > 0) {
			$orderType = $orders[0]['created_source'];
			$isReturnOrder = $orderType == $this->returnOrderTypeId;
			foreach ($orders as $orderDetail) {
				$orderId = $orderDetail['id'];
				$createWareHouseForCustomer = $createWareHouseForConsignee = 0;
				$customerPartyType = 5;
				$consigneePartyType = 3;
				$partyCustomerResult = $this->CI->DelhiveryB2BEDIModel->getPartyInfoByOrderId($orderId, 'Customer');
				if ($partyCustomerResult && $this->isServiceablePincode($partyCustomerResult['pincode'])) {
					$createWareHouseForCustomer = 1;
				}
				$partyConsigneeResult = $this->CI->DelhiveryB2BEDIModel->getPartyInfoByOrderId($orderId, 'Consignee');
				if ($partyConsigneeResult && $this->isServiceablePincode($partyConsigneeResult['pincode'])) {
					$createWareHouseForConsignee = 1;
				}
				if ($createWareHouseForCustomer === 1 && $createWareHouseForConsignee === 1) {
					$customerResponse = $this->createWareHouse($partyCustomerResult['id']);
					$consigneeResponse = $this->createWareHouse($partyConsigneeResult['id']);
					log_message('error',"{$customerResponse} ## {$consigneeResponse}");
					$this->CI->load->library('Carriercommonedilib');
					$this->CI->carriercommonedilib->shipmentdata($orderDetail['shift_id']);
				}
			}
		}
	}

	public function createWareHouse($id): string {
		$wareHouseResponse = "";
		log_message('error',"createwarehouse inbound data: " . $id);
		$party = $this->CI->DelhiveryB2BEDIModel->getPartyInfo($id);
		$clientWareHouse = [
			'id' => $party['id'],
			'mobile' => $party['mobile'],
			'location_id' => $party['location_id'],
			'name' => $party['name'],
			'pincode' => $party['pincode'],
			'address' => $party['address'],
			'country' => $party['country'],
			'email' => $party['email'],
			'code' => $party['code'],
			'state' => $party['state']
		];
		$address = [
			$party['location_id'],
			$party['state'],
			$party['country'],
		];
		$address = implode(',',array_filter($address));
		$wareHouseData = [
			'phone' 			=> $clientWareHouse['mobile'],
			'city' 				=> $clientWareHouse['location_id'],
			'name' 				=> $clientWareHouse['name'],
			'pin' 				=> $clientWareHouse['pincode'],
			'address' 			=> $address,
			'country' 			=> $clientWareHouse['country'],
			'email' 			=> $clientWareHouse['email'],
			'registered_name' 	=> $clientWareHouse['code'],
			'return_address' 	=> $address,
			'return_pin' 		=> $clientWareHouse['pincode'],
			'return_city' 		=> $clientWareHouse['location_id'],
			'return_state' 		=> $clientWareHouse['state'],
			'return_country' 	=> $clientWareHouse['country']
		];
		$requestData = json_encode($wareHouseData);
		$requestData = str_replace('\"', '', $requestData);
		$BearerToken = $this->getJWTToken();
		$serverURL = DELHIVERY_WH_CREATE;
		log_message("error","Delhivery Career Payload {$serverURL} for Create Warehouse is {$requestData}");
		try {
			$curl = curl_init();
			curl_setopt_array($curl, [
				CURLOPT_URL => DELHIVERY_WH_CREATE,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS =>$requestData,
				CURLOPT_HTTPHEADER => [
					'Accept: application/json',
					'Authorization: Bearer '.$BearerToken,
					'Content-Type: application/json'
				]
			]);
			$response = curl_exec($curl);
			curl_close($curl);
			log_message('error','createwarehouse API response payload: ' . $response);
			$pinResponse = json_decode($response, true);
			if (!empty($pinResponse)) {
				if (isset($pinResponse['success']) && $pinResponse['success'] == 'true') {
					$WHResponse = $pinResponse['data'];
					if ($WHResponse['active'] == 1) {
						$workingHours = $WHResponse['business_hours'];
						if (!empty($workingHours)) {
							$carrier = $this->CI->common->gettblrowdata(
								["name" => "DELHIVERY LIMITED"],
								"id",
								"tb_vendors",
								0,
								0
							);
							foreach ($workingHours as $key => $hours) {
								$insertData = [
									"client_id" => $clientWareHouse['id'],
									"carrier_id" => $carrier['id'],
									"day_name" => $key,
									"start_time" => $hours['start_time'],
									"close_time" => $hours['close_time']
								];
								$where = [
									"client_id" => $clientWareHouse['id'],
									"day_name" => $key,
									"start_time" => $hours['start_time'],
									"close_time" => $hours['close_time']
								];

								$hoursQry = $this->CI->common->gettblrowdata($where, "id", "kn_wh_work_hours", 0, 0);
								if (count($hoursQry) > 0) {
									$whereCondition1 = ["id" => $hoursQry['id']];
									log_message('error',"createwarehouse updated data in a kn_wh_work_hours: " . json_encode($where));
									$this->CI->common->updatetbledata('kn_wh_work_hours', $where, $whereCondition1);
								} else {
									log_message('error',"createwarehouse inserted data in a kn_wh_work_hours: " . json_encode($insertData));
									$this->CI->common->insertTableData('kn_wh_work_hours', $insertData);
								}
							}
						}
						$wareHouseResponse = "Success";
					} else {
						$wareHouseResponse = "Failed";
					}
				} elseif (isset($pinResponse['error_code'][0]) && $pinResponse['error_code'][0] == '2000') {
					$WHResponse = $pinResponse['data'];
					if (isset($WHResponse['name']) && $WHResponse['name'] != '') {
						$set = ["partyindetifier" => $WHResponse['name']];
						$where = ["id" => $clientWareHouse['id']];
						log_message('error',"createwarehouse updated data in a tbl_party_master: " . json_encode($set));
						$this->CI->common->updatetbledata("tbl_party_master", $set, $where);
						$workingHours = isset($WHResponse['business_hours']) ? $WHResponse['business_hours'] : [];
						if (!empty($workingHours)) {
							$carrier = $this->CI->common->gettblrowdata(
								["name" => "DELHIVERY LIMITED"],
								"id",
								"tb_vendors",
								0,
								0
							);
							foreach ($workingHours as $key => $hours) {
								$insertData = [
									"client_id" => $clientWareHouse['id'],
									"carrier_id" => $carrier['id'],
									"day_name" => $key,
									"start_time" => $hours['start_time'],
									"close_time" => $hours['close_time']
								];
								$where = [
									"client_id" => $clientWareHouse['id'],
									"day_name" => $key,
									"start_time" => $hours['start_time'],
									"close_time" => $hours['close_time']
								];
								$hoursQry = $this->CI->common->gettblrowdata($where, "id", "kn_wh_work_hours", 0, 0);
								if (count($hoursQry) > 0) {
									$whereCondition1 = ["id" => $hoursQry['id']];
									log_message('error',"createwarehouse updated data in a kn_wh_work_hours: " . json_encode($where));
									$this->CI->common->updatetbledata('kn_wh_work_hours', $where, $whereCondition1);
								} else {
									log_message('error',"createwarehouse inserted data in a kn_wh_work_hours: " . json_encode($insertData));
									$this->CI->common->insertTableData('kn_wh_work_hours', $insertData);
								}
							}
						}
						$wareHouseResponse = "Success";
					}
				}
			} else {
				$wareHouseResponse = 'Unexpected HTTP status: ';
			}
		} catch (Exception $e) {
			$wareHouseResponse = 'Error: ' . $e->getMessage();
		} finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('DELHIVERY LTD Create/Update Warehouse');
            $this->CI->edi_logger->setBounded_type(2);
            $this->CI->edi_logger->setEdi_format_type('JSON');
            $this->CI->edi_logger->setStatus((isset($pinResponse['success']) && $pinResponse['success'] ? 1 : 0));
            $this->CI->edi_logger->setEdi_response(json_encode($pinResponse));
            $this->CI->edi_logger->setObj_type_name('DELHIVERY LTD Create/Update Warehouse');
            $this->CI->edi_logger->saveToEdiLogs();
        }
		log_message('error',"createwarehouse outbound data: " . $wareHouseResponse);
		return $wareHouseResponse;
	}

	private function getOrderInfo() {
		$whereCondition = [
			'shift_id' => $this->shiftId,
			'trip_sts' => 0,
			'status <>' => 0
		];
		return $this->CI->common->gettbldata($whereCondition, "*", "tb_orders", 0, 0);
	}

	private function getJWTToken() : string {
		$getResult = $this->CI->common->gettblrowdata(['token_for' => 'DELHIVERY_LIMITED','status'=>1],"auth_token","tb_auth_tokens",0,0);
		return !empty($getResult) ? $getResult["auth_token"] : "";
	}

	private function isServiceablePincode(string $pinCode) : int {
		$url = DELHIVERY_SERVICEABLE_PINCODE.$pinCode;
		$token = $this->getJWTToken();
		try {
			$curl = curl_init();
			curl_setopt_array($curl, [
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'GET',
				CURLOPT_HTTPHEADER => [
					'Content-Type: application/txt',
					'Authorization: Bearer '.$token
				]
			]);
			$response = curl_exec($curl);
			curl_close($curl);
			if ($response) {
				$result = json_decode($response, true);
				if ((int)$result['success'] === 1) {
					return 1;
				} else {
					return 0;
				}
			} else {
				log_message('error',"Delhivery Carrier Pincode Error response code: ");
			}
		} catch (Exception $e) {
			log_message('error',"Delhivery Carrier Pincode error : " . $e->getMessage());
		} finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('DELHIVERY LTD check serviceable Pincode');
            $this->CI->edi_logger->setBounded_type(2);
            $this->CI->edi_logger->setEdi_format_type('JSON');
            $this->CI->edi_logger->setStatus((isset($result['success']) && $result['success'] ? 1 : 0));
            $this->CI->edi_logger->setEdi_response(json_encode($result));
            $this->CI->edi_logger->setObj_type_name('DELHIVERY LTD check serviceable Pincode');
            $this->CI->edi_logger->saveToEdiLogs();
        }
		return 0;
	}

	public function sendDelhiveryStatusToAltova(string $url, array $payLoadData): void {
		$payLoadData = json_encode($payLoadData);
		log_message('error',"Delhivery Career Status for {$url} to Altova Payload : " . $payLoadData);
		try {
			$curl = curl_init();
			curl_setopt_array($curl, [
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS =>$payLoadData,
				CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
			]);
			$response = curl_exec($curl);
			curl_close($curl);
		} catch (Exception $e) {
			log_message('error',"Delhivery Career Status to Altova : " . $e->getMessage());
		} finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('DELHIVERY CARIER Status to Altova');
            $this->CI->edi_logger->setBounded_type(2);
            $this->CI->edi_logger->setEdi_format_type('XML');
            $this->CI->edi_logger->setStatus((isset($response) && $response ? 1 : 0));
            $this->CI->edi_logger->setEdi_response($response);
            $this->CI->edi_logger->setObj_type_name('DELHIVERY CARIER Status to Altova');
            $this->CI->edi_logger->saveToEdiLogs();
        }
	}
	
	public function delhiveryStatus(array $payLoadData): void
    {
        //$payLoadData = json_encode($payLoadData);
        log_message('error', "Delhivery Career Status for {$url} : " . $payLoadData);
        try {
            $data = json_decode($payLoadData, true);
            // Accessing values
            echo "Shipment Remark: " . $data['shipment_remark'] . "\n";
            echo "Location: " . $data['location'] . "\n";
            echo "Status: " . $data['status'] . "\n";
            echo "LR Number: " . $data['lrnum'] . "\n";
            echo "Expected Delivery Date: " . $data['expected_delivery_date'] . "\n";

            $statusCode  = getEdiStatuses('DELHIVERY', $data['status']);
            $currentDate = date('YmdHis');

            // Create a new DOMDocument
            $docRef               = new DOMDocument('1.0', 'UTF-8');
            $docRef->formatOutput = true;

            // Root element
            $sVKEDIMessageRef = $docRef->createElement('SVKEDIMessage');
            $docRef->appendChild($sVKEDIMessageRef);

            // Transmission Header
            $headerRef = $docRef->createElement('SVKEDITransmissionHeader');

            $headerRef->appendChild($docRef->createElement('EDIVersion', '1.0'));
            $headerRef->appendChild($docRef->createElement('SenderTransmissionNo', $currentDate . "_" . $data['lrnum']));

            $ackSpec = $docRef->createElement('AckSpec');
            $ackSpec->appendChild($docRef->createElement('AckOption', 'ERROR'));
            $ackSpec->appendChild($docRef->createElement('EmailAddress', ''));
            $headerRef->appendChild($ackSpec);

            $headerRef->appendChild($docRef->createElement('SourceApp', 'DELHIVERY'));
            $headerRef->appendChild($docRef->createElement('DestinationApp', 'SVKONEKT'));
            $headerRef->appendChild($docRef->createElement('Action', 'BookingStatusUpdate'));

            $sVKEDIMessageRef->appendChild($headerRef);

            // Transmission Body
            $bodyRef  = $docRef->createElement('SVKEDITransmissionBody');
            $orderRef = $docRef->createElement('Order');
            $orderRef->appendChild($docRef->createElement('OrderID', $data['lrnum']));

            $status = $docRef->createElement('Status');
            $status->appendChild($docRef->createElement('StatusCode', $statusCode));
            $status->appendChild($docRef->createElement('StatusValue', $statusCode));
            $status->appendChild($docRef->createElement('DateTime', $data['timestamp']));
            $status->appendChild($docRef->createElement('TimeZone', '+00:00/IST'));
            $status->appendChild($docRef->createElement('Location', $data['location']));
            $status->appendChild($docRef->createElement('ShipmentRemark', $data['shipment_remark']));
            $status->appendChild($docRef->createElement('PromisedDeliveryDate', $data['promised_delivery_date']));
            $status->appendChild($docRef->createElement('ExpectedDeliveryDate', $data['expected_delivery_date']));

            $orderRef->appendChild($status);
            $bodyRef->appendChild($orderRef);
            $sVKEDIMessageRef->appendChild($bodyRef);

            // Output the XML
            header('Content-Type: application/xml');
            //echo $docRef->saveXML();
            $xmldata = new SimpleXMLElement($docRef->saveXML());
            if ($xmldata === false) {
                echo "Invalid request, Please try again!";
            } else {
                echo $this->parseStatusXml($xmldata);
            }

            // Create XML Document
            $docStatus               = new DOMDocument('1.0', 'UTF-8');
            $docStatus->formatOutput = true;

            // Root element
            $sVKEDIMessageStatus = $docStatus->createElement('SVKEDIMessage');
            $docStatus->appendChild($sVKEDIMessageStatus);

            // Header
            $header = $docStatus->createElement('SVKEDITransmissionHeader');

            $header->appendChild($docStatus->createElement('EDIVersion', '1.0'));
            $header->appendChild($docStatus->createElement('UserName', ''));
            $header->appendChild($docStatus->createElement('Password', ''));
            $header->appendChild($docStatus->createElement('SenderTransmissionNo', $currentDate . "_" . $data['lrnum']));

            $ackSpec = $docStatus->createElement('AckSpec');
            $ackSpec->appendChild($docStatus->createElement('EmailAddress', ''));
            $ackSpec->appendChild($docStatus->createElement('AckOption', 'ERROR'));
            $header->appendChild($ackSpec);

            $header->appendChild($docStatus->createElement('SourceApp', 'DELHIVERY'));
            $header->appendChild($docStatus->createElement('DestinationApp', 'SVKONEKT'));
            $header->appendChild($docStatus->createElement('Action', 'BookingStatusUpdate'));

            $sVKEDIMessageStatus->appendChild($header);

            // Body
            $body        = $docStatus->createElement('SVKEDITransmissionBody');
            $orderStatus = $docStatus->createElement('OrderStatus');

            $orderStatus->appendChild($docStatus->createElement('OrderID', $data['lrnum']));
            $orderStatus->appendChild($docStatus->createElement('ShipmentID', ''));
            $orderStatus->appendChild($docStatus->createElement('RecordType', 'EVENTS'));
            $orderStatus->appendChild($docStatus->createElement('StatusCode', $statusCode));
            $orderStatus->appendChild($docStatus->createElement('StatusName', $statusCode));
            $orderStatus->appendChild($docStatus->createElement('ReferenceValue', ''));
            $orderStatus->appendChild($docStatus->createElement('City', ''));
            $orderStatus->appendChild($docStatus->createElement('Country', $data['location']));
            $orderStatus->appendChild($docStatus->createElement('DateTime', $data['timestamp']));
            $orderStatus->appendChild($docStatus->createElement('TimeZone', '+00:00/IST'));
            $orderStatus->appendChild($docStatus->createElement('ActionUser', $data['name']));

            $body->appendChild($orderStatus);
            $sVKEDIMessageStatus->appendChild($body);

            // Output the XML
            header('Content-Type: application/xml');
            //echo $docStatus->saveXML();
            $response = json_decode(json_encode(simplexml_load_string($docStatus->saveXML(), "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
            $this->customreferenceshandler->pullOrderReferenceXml($response);

        } catch (Exception $e) {
            log_message('error', "Delhivery Career Status : " . $e->getMessage());
        } finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('DELHIVERY CARIER Status to Altova');
            $this->CI->edi_logger->setBounded_type(2);
            $this->CI->edi_logger->setEdi_format_type('XML');
            $this->CI->edi_logger->setStatus((isset($response) && $response ? 1 : 0));
            $this->CI->edi_logger->setEdi_response($response);
            $this->CI->edi_logger->setObj_type_name('DELHIVERY CARIER Status to Altova');
            $this->CI->edi_logger->saveToEdiLogs();
        }
    }
	
	public function parseStatusXml(object $xmldata): string
    {
        $header     = $xmldata->xpath('SVKEDITransmissionHeader');
        $body       = $xmldata->xpath('SVKEDITransmissionBody');
        $headerdata = [
            "partyId"              => isset($header[0]->PartyId) ? (string) ($header[0]->PartyId) : "",
            "SenderTransmissionNo" => isset($header[0]->SenderTransmissionNo) ? (string) ($header[0]->SenderTransmissionNo) : "",
            "emailaddress"         => isset($header[0]->AckSpec->EmailAddress) ? (string) ($header[0]->AckSpec->EmailAddress) : "",
            "ackoption"            => isset($header[0]->AckSpec->AckOption) ? (string) ($header[0]->AckSpec->AckOption) : "",
            "sourceapp"            => isset($header[0]->SourceApp) ? (string) ($header[0]->SourceApp) : "",
            "destinationapp"       => isset($header[0]->DestinationApp) ? (string) ($header[0]->DestinationApp) : "",
            "referenceid"          => isset($header[0]->ReferenceId) ? (string) ($header[0]->ReferenceId) : "",
            "action"               => isset($header[0]->Action) ? (string) ($header[0]->Action) : "",
        ];
        $ordersData = [];
        foreach ($body[0]->Order as $order) {
            $orderId    = isset($order[0]->OrderID) ? (string) ($order[0]->OrderID) : "";
            $statusCode = isset($order[0]->Status->StatusCode) ? (string) ($order[0]->Status->StatusCode) : "";
            if ($orderId > 0 && ! empty($statusCode)) {
                $ordersData[] = [
                    "OrderID"              => $orderId,
                    "statuscode"           => $statusCode,
                    "statusvalue"          => isset($order[0]->Status->StatusValue) ? (string) ($order[0]->Status->StatusValue) : "",
                    "datetime"             => isset($order[0]->Status->DateTime) ? (string) ($order[0]->Status->DateTime) : "",
                    "timezone"             => isset($order[0]->Status->TimeZone) ? (string) ($order[0]->Status->TimeZone) : "",
                    "location"             => isset($order[0]->Status->Location) ? (string) ($order[0]->Status->Location) : "",
                    "shipmentremark"       => isset($order[0]->Status->ShipmentRemark) ? (string) ($order[0]->Status->ShipmentRemark) : "",
                    "promiseddeliverydate" => isset($order[0]->Status->PromisedDeliveryDate) ? (string) ($order[0]->Status->PromisedDeliveryDate) : "",
                    "expecteddeliverydate" => isset($order[0]->Status->ExpectedDeliveryDate) ? (string) ($order[0]->Status->ExpectedDeliveryDate) : "",
                ];
            }
        }
        $this->load->model('DelhiveryB2BEDIModel');
        log_message("error","Status:".json_encode($ordersData));
        $statusresponse = $this->DelhiveryB2BEDIModel->updateStatus(json_encode($ordersData));
        if ("0" === $statusresponse) {
            return "No Order Id Found";
        } else {
            return "Status Updated Successfully";
        }
    }
    
    public function delhiveryPod(array $payLoadData): void
    {
        //$payLoadData = json_encode($payLoadData);
        log_message('error', "Delhivery Career Pod for {$url} : " . $payLoadData);
        try {
            $data = json_decode($json, true);

            // Generate timestamp
            $timestamp = date('YmdHis'); // e.g. 20250621225716
            
            // Prepare SequenceNumber and DocumentName
            $sequenceNumber = $timestamp . '_' . $data['orderId'];
            $documentName = $data['orderId'] . '_' . $timestamp . '.pdf';
            
            // Create XML
            $xml = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><DocumentUpload xmlns="http://www.svkonekt.com/edi/business_partner/document_upload/v1"/>');
            
            $header = $xml->addChild('Header');
            $header->addChild('Version', '6.3.1');
            $header->addChild('SequenceNumber', $sequenceNumber);
            $header->addChild('SourceApp', 'DELHIVERY');
            $header->addChild('DestinationApp', 'SVKONEKT');
            
            $xml->addChild('Action', 'UPLOAD');
            $xml->addChild('OrderID', $data['orderId']);
            $xml->addChild('DocumentType', 'POD');
            $xml->addChild('DocumentCode', '1');
            
            $uploadDetails = $xml->addChild('UploadDetails');
            $uploadDetails->addChild('DocumentName', $documentName);
            $uploadDetails->addChild('DocumentFile', $data['doc']);
            $uploadDetails->addChild('URL', '');
            
            Header('Content-type: text/xml');
            //echo $xml->asXML();
            //$response = json_decode(json_encode(simplexml_load_string($xml->asXML(), "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
            
            $xmldata = new SimpleXMLElement($xml->asXML());
            log_message("error","Status:".$xmldata);
            if ($xmldata === false) {
                echo "Invalid request, Please try again!";
            } else {
                echo $this->parsePodXml($xmldata);
            }
            
            /*if (!empty($postData)) {
                if (($xml = new SimpleXMLElement($postData)) == false) {
                    echo "Invalid request,Please try again!";
                } else {
                    echo $this->parsePodXml($xml);
                }
            } else {
                echo "Please Send Proper XML";
            }*/

        } catch (Exception $e) {
            log_message('error', "Delhivery Career Status : " . $e->getMessage());
        } finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('DELHIVERY CARIER Status');
            $this->CI->edi_logger->setBounded_type(2);
            $this->CI->edi_logger->setEdi_format_type('XML');
            $this->CI->edi_logger->setStatus((isset($response) && $response ? 1 : 0));
            $this->CI->edi_logger->setEdi_response($response);
            $this->CI->edi_logger->setObj_type_name('DELHIVERY CARIER Status');
            $this->CI->edi_logger->saveToEdiLogs();
        }
    }
    
    public function parsePodXml($xmldata): string
    {
        $header = $xmldata->xpath('Header');
        $headerdata = [
            "version" => isset($header[0]->Version) ? (string)($header[0]->Version) : "",
            "sequenceNumber" => isset($header[0]->SequenceNumber) ? (string)($header[0]->SequenceNumber) : "",
            "sourceApp" => isset($header[0]->AckSpec->SourceApp) ? (string)($header[0]->AckSpec->SourceApp) : "",
        ];
        $ordersData = [
            "action" => $xmldata->Action !== null ? (string)($xmldata->Action) : "",
            "documentType" => $xmldata->DocumentType !== null ? (string)($xmldata->DocumentType) : "",
            "OrderID" => $xmldata->OrderID !== null ? (string)($xmldata->OrderID) : "0",
            "documentName" => isset($xmldata->UploadDetails->DocumentName) ? (string)($xmldata->UploadDetails->DocumentName) : "",
            "documentURL" => isset($xmldata->UploadDetails->URL) ? (string)($xmldata->UploadDetails->URL) : "",
            "documentFile" => isset($xmldata->UploadDetails->DocumentFile) ? (string)($xmldata->UploadDetails->DocumentFile) : "",
            "receiverName" => isset($xmldata->UploadDetails->Receiver_Name) ? (string)($xmldata->UploadDetails->Receiver_Name) : "",
        ];
        log_message("error","POD:".json_encode($ordersData));
        return $this->Singlestatusmodel->uploadOrderPod(json_encode($ordersData),$this);
    }
}