<?php

class DocumentSequenceLibrary
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('documentSequenceModel');
    }

    /**
     * @throws Exception
     */
    public function getSequence(string $prefix, string $countryCode, int $documentType, \DateTime $dateTime = null): string
    {
        if (null === $dateTime) {
            $dateTime = new \DateTime();
        }

        self::validateData($prefix, $countryCode, $documentType);

        if (!in_array($documentType, DocumentSequenceModel::DOCUMENT_TYPES)) {
            throw new Exception('DocumentSequenceLibrary has not found provided document type: ' . $documentType);
        }

        return $this->ci->documentSequenceModel->getSequence($prefix, $countryCode, $documentType, $dateTime, self::getEnvironmentIdentifier());
    }

    private static function getEnvironmentIdentifier(): int
    {
        switch (SYS_TYPE) {
            case 'TMS':
                return 0;

            case 'TMS-DEMO':
                return 1;

            case 'TMS-UAT':
                return 2;

            default:
                return 3;
        }
    }

    /**
     * @throws Exception
     */
    private static function validateData(string $prefix, string $countryCode, int $documentType): void
    {
        if (empty($prefix)) {
            throw new \RuntimeException("Empty prefix not allowed.");
        }

        if (empty($countryCode)) {
            throw new \RuntimeException("Empty country code not allowed.");
        }

        if (empty($documentType)) {
            throw new \RuntimeException("Empty document type not allowed.");
        }
    }
}
