<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class ElogOrder
{
    protected $CI;

    public function __construct()
    {
        // Get the CodeIgniter instance
         $this->CI = &get_instance();
        // Load the common model
         $this->CI->load->model('common');
    }

    public function fetchingElogOrderData(string $orderId) : array
    {
        $url = ELOG_STATUS_URL;
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => http_build_query(['orderID' => $orderId]),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/x-www-form-urlencoded'
            ],
        ]);

        $response = curl_exec($curl);
        $curlError = curl_error($curl);
        curl_close($curl);

        if ($response === false) {
            log_message('error', 'cURL Error: ' . $curlError);
            return false;
        }

        $xml = simplexml_load_string($response);
        if ($xml === false) {
            log_message('error', 'Failed to parse XML response');
            return false;
        }

        $data = [];
        $orderHeader = $xml->ELGEDIOrderHeader;
        $orderBody = $xml->ELGEDIOrderBody;
        $order = $orderBody->ELGOrder;
        $locationInfo = $order->LocationInfo;
        $source = $locationInfo->Source;
        $destination = $locationInfo->Destination;
        $cargoSummary = $order->CargoSummary;
        $orderStatus = $order->OrderStatus;

        $data['isPinExists'] = (string) $orderHeader->IsPinExists;
        $data['existingPinNo'] = (string) $orderHeader->PinNo;

        $organizationName = (string) $orderBody->ELGOrgDetails->OrganizationId;
        if ($organizationName) {
            $orgWhr = ["organization_name" => $organizationName, "status <>" => 0];
            $orgData =  $this->CI->common->gettblrowdata($orgWhr, "id", "tb_organization_details", 0, 0);
            $data['organizationId'] = $orgData['id'] ?? null;
        }

        $businessEntityName = (string) $orderBody->ELGOrgDetails->BusinessEntity;
        if ($businessEntityName) {
            $bussEntityWhr = ["entity_value_name" => $businessEntityName, "status <>" => 0];
            $bussEntity =  $this->CI->common->gettblrowdata($bussEntityWhr, "id", "tb_business_entity_values", 0, 0);
            $data['entityValueId'] = $bussEntity['id'] ?? null;
        }

        $data['orderId'] = (string) $order->OrderID;
        $data['orderRowId'] = (string) $order->OrderAutoID ?? '';

        $data['shipmentId'] = (string) $order->TripID;
        $data['tripId'] = (string) $order->TripAutoID ?? '';

        $data['sourceCompany'] = (string) $source->Company->Name;
        $data['plat'] = (string) $source->Address->Latitude;
        $data['plng'] = (string) $source->Address->Longitude;

        $format = 'Y-m-d\TH:i:s.v';
        $outputFormat = 'Y-m-d H:i:s';
        $earlyPickupDate = DateTime::createFromFormat($format, (string) $source->PickupDateTime->StartDate);
        $data['earlyPickupDate'] = $earlyPickupDate ? $earlyPickupDate->format($outputFormat) : null;
        $latePickupDate = DateTime::createFromFormat($format, (string) $source->PickupDateTime->EndDate);
        $data['latePickupDate'] = $latePickupDate ? $latePickupDate->format($outputFormat) : null;

        $data['destinationCompany'] = (string) $destination->Company->Name;
        $data['dlat'] = (string) $destination->Address->Latitude;
        $data['dlng'] = (string) $destination->Address->Longitude;

        $earlydropDate = DateTime::createFromFormat($format, (string) $destination->DeliveryDateTime->StartDate);
        $data['earlydropDate'] = $earlydropDate ? $earlydropDate->format($outputFormat) : null;
        $latedropDate = DateTime::createFromFormat($format, (string) $destination->DeliveryDateTime->EndDate);
        $data['latedropDate'] = $latedropDate ? $latedropDate->format($outputFormat) : null;

        $data['totalQuantity'] = (string) $cargoSummary->TotalQuantity->Value;
        $data['totalWeightValue'] = (string) $cargoSummary->TotalVolume->Value;
        $data['totalWeightUomCode'] = (string) $cargoSummary->TotalVolume->UOM;
        $data['totalVolumeValue'] = (string) $cargoSummary->TotalWeight->Value;
        $data['totalVolumeUomCode'] = (string) $cargoSummary->TotalWeight->UOM;

        $statusCodes = $statusValues = [];
        foreach ($orderStatus->children() as $status) {
            $statusCodes[] = (string) $status->StatusCode;
            $statusValues[] = (string) $status->StatusValue;
        }
        $data['statusCodes'] = $statusCodes;
        $data['statusValues'] = $statusValues;

        log_message('error', 'data jsonencode: ' . json_encode($data));
        return $data;
    }
}
