<?php
require_once './vendor/pear/http_request2/HTTP/Request2.php';
class EportalBUFA {
	private $CI;
	public string $xmlData = '';
	public string $orderId = '0';
	public string $statusCode = '';
	private const EPORTAL_TIMEZONE = "Asia/Shanghai";
	private const EPORTAL_TIMEZONE_HRS = "+08:00";
	private const REQUEST_METHOD = "POST";
	private const TRIP_REQUEST_URI = '/api/v1/svkonekt/push-order';
	private const STATUS_REQUEST_URI = '/api/v1/svkonekt/push-status';
	public string $apiKey = '';
	public string $secretKey = '';
	public function __construct() {
		$this->CI = &get_instance();
		$this->CI->load->model('wechatmodel', 'chat');
		date_default_timezone_set(SELF::EPORTAL_TIMEZONE);
	}

	private function isSalogOrder(): int {
		$status = 0;
		$orderInfo = $this->CI->common->gettblrowdata(["order_id" => $this->orderId], "created_source", "tb_orders", 0, 0);
		if (!empty($orderInfo) && (int) $orderInfo['created_source'] === 5) {
			$status = 1;
		}
		return $status;
	}

	private function generateSignature(string $uri) : string {
		$encryptData = md5($this->xmlData);
		$timestamp = date('Y-m-d H:i:s');
		$data = $this->bin2hex($encryptData);
		$source = implode('\\n', [$this->apiKey, SELF::REQUEST_METHOD, $timestamp, $uri, $data]);
		$signature = hash_hmac('sha256', $source, $this->secretKey, true);
		return base64_encode($signature);
	}

	public function sendTripNotificationToEportal(string $tripXMl): int {
		if ($this->isSalogOrder() === 1) {
			$this->xmlData = $tripXMl;
			log_message('error'," CHINA ePortal Trip Info Payload ".$tripXMl);
			if (checkAccessConditions('EPORTAL_PROD_TRIP_TRIGGER_STATUS', 1)) {
				$this->sendTripNotificationToEportalPROD($tripXMl);
			}
			if (checkAccessConditions('EPORTAL_TEST_TRIP_TRIGGER_STATUS', 1)) {
				$this->apiKey = EPORTAL_CHINA_API_KEY_DEV;
				$this->secretKey = EPORTAL_CHINA_APP_SECRET_DEV;
				$signature = $this->generateSignature(SELF::TRIP_REQUEST_URI);
				$request = new HTTP_Request2();
				$request->setUrl(EPORTAL_CHINA_API_BASEURL_DEV.'push-order');
				$request->setMethod(HTTP_Request2::METHOD_POST);
				$request->setConfig(['follow_redirects' => TRUE]);
				$request->setHeader([
					'X-ePortalChina-Frtinv-ApiKey' => EPORTAL_CHINA_API_KEY_DEV,
					'X-ePortalChina-Frtinv-Date' => date('Y-m-d H:i:s'),
					'X-ePortalChina-Frtinv-Signature' => $signature,
					'Content-Type' => 'text/plain'
				]);
				$request->setBody($this->xmlData);
				try {
					$response = $request->send();
					if ( (int) $response->getStatus() === 200) {
						log_message('error'," CHINA ePortal TEST Trip Info response ".$response->getBody());
						return 1;
					} else {
						return 2;
					}
				} catch(HTTP_Request2_Exception $e) {
					log_message("error", "Some Problem occured!, While Sending Trip Notification XML to ePORTAL CHINA " . $e->getMessage()." @ ".gmdate('d-m-Y H:i:00'));
				}
				log_message("error", "Unable to send Trip Notification XML to ePORTAL TEST CHINA @ ".gmdate('d-m-Y H:i:00'));
			}
		}
		return 0;
	}

	public function sendTripNotificationToEportalPROD(string $tripXMl): int {
			$this->apiKey = EPORTAL_CHINA_API_KEY_PROD;
			$this->secretKey = EPORTAL_CHINA_APP_SECRET_PROD;
			$signature = $this->generateSignature(SELF::TRIP_REQUEST_URI);
			$request = new HTTP_Request2();
			$request->setUrl(EPORTAL_CHINA_API_BASEURL_PROD.'push-order');
			$request->setMethod(HTTP_Request2::METHOD_POST);
			$request->setConfig(['follow_redirects' => TRUE]);
			$request->setHeader([
				'X-ePortalChina-Frtinv-ApiKey' => EPORTAL_CHINA_API_KEY_PROD,
				'X-ePortalChina-Frtinv-Date' => date('Y-m-d H:i:s'),
				'X-ePortalChina-Frtinv-Signature' => $signature,
				'Content-Type' => 'text/plain'
			]);
			$request->setBody($this->xmlData);
			try {
				$response = $request->send();
				if ( (int) $response->getStatus() === 200) {
					log_message('error'," CHINA ePortal PROD Trip Info response ".$response->getBody());
					return 1;
				} else {
					return 2;
				}
			} catch(HTTP_Request2_Exception $e) {
				log_message("error", "Some Problem occured!, While Sending Trip Notification XML to ePORTAL CHINA " . $e->getMessage()." @ ".gmdate('d-m-Y H:i:00'));
			}
			log_message("error", "Unable to send Trip Notification XML to ePORTAL PROD CHINA @ ".gmdate('d-m-Y H:i:00'));
		return 0;
	}

	public function sendStatusNotificationToEportal(string $statusXMl): int {
		if ($this->isSalogOrder() === 1) {
			$this->xmlData = $statusXMl;
			log_message('error'," CHINA ePortal Status Info Payload ".$statusXMl);
			if (checkAccessConditions('EPORTAL_PROD_STATUS_TRIGGER_STATUS', 1)) {
				$this->sendStatusNotificationToEportalPROD($statusXMl);
			}
			if (checkAccessConditions('EPORTAL_TEST_STATUS_TRIGGER_STATUS', 1)) {
				$this->apiKey = EPORTAL_CHINA_API_KEY_DEV;
				$this->secretKey = EPORTAL_CHINA_APP_SECRET_DEV;
				$signature = $this->generateSignature(SELF::STATUS_REQUEST_URI);
				$request = new HTTP_Request2();
				$request->setUrl(EPORTAL_CHINA_API_BASEURL_DEV.'push-status');
				$request->setMethod(HTTP_Request2::METHOD_POST);
				$request->setConfig(['follow_redirects' => TRUE]);
				$request->setHeader([
					'X-ePortalChina-Frtinv-ApiKey' => EPORTAL_CHINA_API_KEY_DEV,
					'X-ePortalChina-Frtinv-Date' => date('Y-m-d H:i:s'),
					'X-ePortalChina-Frtinv-Signature' => $signature,
					'Content-Type' => 'text/plain'
				]);
				$request->setBody($this->xmlData);
				try {
					$response = $request->send();
					if ( (int) $response->getStatus() === 200) {
						log_message('error'," CHINA ePortal TEST Status Info response ".$response->getBody());
						return 1;
					} else {
						return 2;
					}
				} catch (Exception $e) {
					log_message("error", "Some Problem occured!, While Sending Status Notification XML to ePORTAL CHINA ".$e->getMessage()." @ ".gmdate('d-m-Y H:i:00'));
				}
				log_message("error", "Unable to send Trip Notification XML to ePORTAL TEST CHINA @ ".gmdate('d-m-Y H:i:00'));
			}
		}
		return 0;
	}

	private function sendStatusNotificationToEportalPROD(string $statusXMl): int {
		$this->apiKey = EPORTAL_CHINA_API_KEY_PROD;
		$this->secretKey = EPORTAL_CHINA_APP_SECRET_PROD;
		$signature = $this->generateSignature(SELF::STATUS_REQUEST_URI);
		$request = new HTTP_Request2();
		$request->setUrl(EPORTAL_CHINA_API_BASEURL_PROD.'push-status');
		$request->setMethod(HTTP_Request2::METHOD_POST);
		$request->setConfig(['follow_redirects' => TRUE]);
		$request->setHeader([
			'X-ePortalChina-Frtinv-ApiKey' => EPORTAL_CHINA_API_KEY_PROD,
			'X-ePortalChina-Frtinv-Date' => date('Y-m-d H:i:s'),
			'X-ePortalChina-Frtinv-Signature' => $signature,
			'Content-Type' => 'text/plain'
		]);
		$request->setBody($this->xmlData);
		try {
			$response = $request->send();
			if ( (int) $response->getStatus() === 200) {
				log_message('error'," CHINA ePortal PROD Status Info response ".$response->getBody());
				return 1;
			} else {
				return 2;
			}
		} catch (Exception $e) {
			log_message("error", "Some Problem occured!, While Sending Status Notification XML to ePORTAL CHINA ".$e->getMessage()." @ ".gmdate('d-m-Y H:i:00'));
		}
		log_message("error", "Unable to send Trip Notification XML to ePORTAL PROD CHINA @ ".gmdate('d-m-Y H:i:00'));
		return 0;
	}

	private function bin2hex($string): string {
		$response = '';
		$pattern = '/[0-9a-zA-Z_.~!*()]/';
		for ($i = 0, $l = strlen($string); $i < $l; $i++) {
			if (preg_match($pattern, $string[$i])) {
				$response .= dechex(ord($string[$i]));
			} else {
				$response .= rawurlencode($string[$i]);
			}
		}
		return $response;
	}

	private function retriggeringSalogStatuses(): void {
		$orderInfo = $this->CI->common->gettblrowdata(["order_id" => $this->orderId], "id", "tb_orders", 0, 0);
		$salogData = $this->getOrderInformation($orderInfo['id']);
		$salogData['web'] = getdatetimebytimezone($salogData['timezone'], $salogData['deliveryDate'], DFLT_TZ)['datetime'];
        $this->CI->load->library('statusintigration');
        if ($this->statusCode === '0500') {
        	$salogPickupStatus = $this->CI->statusintigration->salogshipmentstatus($salogData);
        	log_message("error","Status triggered to SALOG of ".$this->statusCode." is ".$salogPickupStatus);
        } elseif ($this->statusCode === '2300') {
        	$salogData['status_code'] = '2300';
        	$salogDeliveryStatus = $this->CI->statusintigration->salogshipmentstatus($salogData);
        	log_message("error","Status triggered to SALOG of ".$this->statusCode." is ".$salogDeliveryStatus);
        }
	}

	private function getOrderInformation(int $orderRowId): array {
        $pickupDate = $deliveryDate = date('Y-m-d H:i:s');
        $this->CI->load->model('Roadlogtosalogmodel');
        $orderStatusData = $this->CI->Roadlogtosalogmodel->getPickupAndDeliveryStatuses($orderRowId);
        foreach ($orderStatusData as $eachStatusData) {
            if ($eachStatusData['status_code'] == '0500') {
                $pickupDate = $eachStatusData['createdon'];
            }
            if ($eachStatusData['status_code'] == '2300') {
                $deliveryDate = $eachStatusData['createdon'];
            }
            $bookingId = $eachStatusData['order_id'];
            $shiftId = $eachStatusData['shift_id'];
            $tripId = $eachStatusData['trip_id'];
        }
        $timeZone = SELF::EPORTAL_TIMEZONE;
        $countryHours = SELF::EPORTAL_TIMEZONE_HRS;
        return [
            'shipment_id' => $shiftId ?? 0,
            'trip_id' => $tripId ?? 0,
            'order_id' => $bookingId ?? '',
            'curtz' => $timeZone,
            'hrs' => $countryHours,
            'web' => getdatetimebytimezone($timeZone, $pickupDate, DFLT_TZ)['datetime'],
            'status_code' => '0500',
            'ord_id' => $orderRowId,
            'driver_id' => '',
            'stop_id' => '',
            'deliveryDate' => $deliveryDate,
            'timezone' => $timeZone
        ];
    }
}