	<?php
	class FlipkartEDIServices
	{
		public $shiftId;
		private $CI;
		private $returnOrderTypeId = '16';

		public function __construct()
		{
			$this->CI = &get_instance();
			$this->CI->load->model(['common']);
			$this->CI->load->library('Edi_logger');
			$this->CI->load->helper('user_helper');
			$this->CI->load->library('uuid');
		}

		public function triggerDelhiveryAPI(int $shiftId): int
		{
			$this->shiftId = $shiftId;
			if ($this->checkWareHouse() !== 1) {
				return 0;
			}
			return 1;
		}

		public function generateFlipkartToken(): void
		{
			$message     = '';
			$response    = '';
			$credentials = [
				"userName" => FLIPKART_LOGIN_USERNAME,
				"password" => FLIPKART_LOGIN_PASSWORD,
			];
			$authData = json_encode($credentials);
			$this->CI->edi_logger->setEdi_request($authData);
			$serverURL = FLIPKART_SERVER_BASE_URL . 'login';
			log_message('error', "FLIPKART Carrier for {$serverURL} Payload credentials => {$authData}");
			try {
				$curl = curl_init();
				curl_setopt_array($curl, [
					CURLOPT_URL            => $serverURL,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING       => '',
					CURLOPT_MAXREDIRS      => 10,
					CURLOPT_TIMEOUT        => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST  => 'POST',
					CURLOPT_POSTFIELDS     => $authData,
					CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
				]);
				log_message('error', "cURL Request URL: $serverURL");
				log_message('error', "cURL Request Body: " . $authData);
				$response = curl_exec($curl);
				log_message('error', "Respnse:" . json_encode($response));
				curl_close($curl);

				$apiResponse = json_decode($response, true);
				log_message('error', "ApiResponse:" . json_encode($apiResponse));
				if (! empty($apiResponse) && is_array($apiResponse) && isset($apiResponse['data'])) {
					$isUpdate = $this->CI->common->gettblrowdata(['token_for' => 'FLIPKART', 'status' => 1], "id", "tb_auth_tokens", 0, 0);
					if (! empty($isUpdate)) {
						$status = $this->CI->common->updatetbledata("tb_auth_tokens", ['auth_token' => $apiResponse['data'], 'updated_on' => date('Y-m-d H:i:s')], ['id' => $isUpdate['id']]);
					} else {
						$status = $this->CI->common->insertTableData("tb_auth_tokens", [
							'auth_token' => $apiResponse['data'],
							'created_on' => date('Y-m-d H:i:s'),
							'updated_on' => date('Y-m-d H:i:s'),
							'token_for'  => 'FLIPKART',
							'status'     => 1,
						]);
					}
					if ($status) {
						log_message('error', "FLIPKART Carrier Token generated successfully @ " . gmdate('d-m-Y H:i:00'));
					}
				} else {
					log_message('error', 'Unable to generate Flipkart Token @ ' . gmdate('d-m-Y H:i:00'));
				}
			} catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			} finally {
				$this->CI->edi_logger->setEdi_type(1);
				$this->CI->edi_logger->setTransaction_id(time());
				$this->CI->edi_logger->setEdi_name('FLIPKART CARRIER Auth Token Generation');
				$this->CI->edi_logger->setBounded_type(1);
				$this->CI->edi_logger->setEdi_format_type('JSON');
				$this->CI->edi_logger->setStatus(((isset($apiResponse['data']) && $apiResponse['data']) ? 1 : 0));
				$this->CI->edi_logger->setEdi_response(json_encode($response));
				$this->CI->edi_logger->setObj_type_name('FLIPKART CARRIER Auth Token Generation');
				$this->CI->edi_logger->saveToEdiLogs();
			}
		}

		public function getDocketNo(): string
		{
			$message     = '';
			$response    = '';
			$docketNo    = '';
			$authDetails = $this->CI->common->gettblrowdata(['token_for' => 'FLIPKART', 'status' => 1], "auth_token", "tb_auth_tokens", 0, 0);
			log_message('error', "cURL Request URL:" . json_encode($authDetails));
			$authToken = $authDetails['auth_token'];
			$serverURL = FLIPKART_SERVER_BASE_URL . 'dkts/FTL/1';
			log_message('error', "FLIPKART Carrier for {$serverURL} Payload credentials => {$authToken}");
			try {
				$curl = curl_init();
				curl_setopt_array($curl, [
					CURLOPT_URL            => $serverURL,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING       => '',
					CURLOPT_MAXREDIRS      => 10,
					CURLOPT_TIMEOUT        => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST  => 'GET',
					CURLOPT_POSTFIELDS     => '',
					CURLOPT_HTTPHEADER     => [
						'Content-Type: application/json',
						"Authorization: Bearer $authToken",
					],
				]);
				log_message('error', "cURL Request URL: $serverURL");
				$response = curl_exec($curl);
				log_message('error', "Respnse:" . json_encode($response));
				curl_close($curl);

				$apiResponse = json_decode($response, true);
				log_message('error', "ApiResponse:" . json_encode($apiResponse));
				if (! empty($apiResponse) && is_array($apiResponse) && isset($apiResponse['data'])) {
					$docketNo = $apiResponse['data'][0];
				} else {
					log_message('error', 'Unable to generate Flipkart Docket No @ ' . gmdate('d-m-Y H:i:00'));
				}
			} catch (Exception $e) {
				$message = 'Error: ' . $e->getMessage();
			}
			return $docketNo;
		}
		
		
		
	}
