<?php
class Knlogin
{
    private const CONTACT_REFERENCE_IDS = ['CRI', 'SHI', 'CNI', 'NPI', 'PKI', 'DLI', 'CUI', 'FPI'];

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(['common','Order']);
    }
    
    public function shipmentxml($id)
    {
        //log_message("error","id:".$id);
        $ci = &get_instance();
        /*$companyCode = $ci->session->userdata('company_code');
        $timeZoneHours = $ci->session->userdata("usr_tzone")['hrs'];
        $countryName = $ci->session->userdata("usr_tzone")['country_name'];
        $countryCode = $ci->session->userdata("usr_tzone")['country'];*/
        $countries = $finalCountries = $carrierDetails = $packageCodes = $pdetail = $references = $shipperReferences = [];
        $LogicalReceiver = "WWWWW99";
        $checkPfs = 0;
        if ($id != "") {
            $getPackageCode = $ci->common->gettbldata("unit_code IS NOT NULL ", "unit_name,unit_code,description", "tb_handling_units", 0, 0);
            foreach ($getPackageCode as $singlePackageCode) {
                $packageCodes[$singlePackageCode['description']] = $packageCodes[$singlePackageCode['unit_name']] = $packageCodes[$singlePackageCode['unit_code']] = $singlePackageCode['unit_code'];
            }
            $getOrderDetails = $ci->common->gettblrowdata(['id' => $id], "id,order_id,pickup_datetime,pickup_endtime,shipment_id,delivery_datetime,drop_endtime,pickup_company,delivery_company,pickup_address1,delivery_address1,pickup_address2,delivery_address2,pickup_city,delivery_city,pickup_country,delivery_country,pickup_pincode,delivery_pincode,company_code,branch_code,product,transport_mode,vehicle_type,customer_id,createdon,shipmentid,user_id", "tb_orders", 0, 0);
            if (!empty($getOrderDetails)) {
                $orderRowId = $getOrderDetails['id'];
                $customerRowId = $getOrderDetails['customer_id'];
                $uid = $getOrderDetails['user_id'];
                $companyCode = $getOrderDetails['company_code'];
                $timeZoneHours = $countryName = $countryCode = "";
                $gethrs = $ci->db->query(
                    "SELECT c.cntry_hrs,c.country_code,c.country_name
                    FROM tbl_country_master AS c, tb_users AS u
                    WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                    LIMIT 1",
                    [$uid]
                );
                if ($gethrs && $gethrs->num_rows() > 0) {
                    $timeZoneHours = $gethrs->row()->cntry_hrs;
                    $countryName = $gethrs->row()->country_name;
                    $countryCode = $gethrs->row()->country_code;
                }
                $checkBeforeSending = $ci->common->gettblrowdata(['id' => $customerRowId, 'sendto_knlogin' => '1'], "id", "tb_customers", 0, 0);
                if (!empty($checkBeforeSending)) {
                    $partyTypes = $ci->Order->getOrderParties($orderRowId);
                    foreach ($partyTypes as $eachType) {
                        $partyType = $eachType['party_type_name'];
                        $partyTypeCode = "";
                        if ($partyType == "FREIGHT_PAYER") {
                            $partyTypeCode = "PF";
                            $checkPfs = 1;
                        } elseif ($partyType == "Customer") {
                            $partyTypeCode = "PF";
                            $checkPfs = 1;
                        } elseif ($partyType == "Shipper") {
                            $partyTypeCode = "Shipper";
                        } elseif ($partyType == "Consignee") {
                            $partyTypeCode = "Consignee";
                        } elseif ($partyType == "Carrier") {
                            $carrierDetails = ['type' => 'Carrier', 'name' => $eachType['name'], 'cust_id' => $eachType['code'], 'pincode' => $eachType['pincode'], 'country' => strtoupper($eachType['country']), 'street' => $eachType['street'], 'city' => $eachType['location_id'], 'state' => $eachType['state'], 'party_id' => $eachType['partyindetifier'], 'email' => $eachType['email']];
                        }
                        $countries[] = strtoupper($eachType['country']);
                        $pdetail[] = ['type' => $partyTypeCode, 'name' => $eachType['name'], 'cust_id' => $eachType['code'], 'pincode' => $eachType['pincode'], 'country' => strtoupper($eachType['country']), 'street' => $eachType['street'], 'city' => $eachType['location_id'], 'state' => $eachType['state'], 'party_id' => $eachType['partyindetifier']];
                    }
                    if ($checkPfs == 0) {
                        $customerId = $getOrderDetails['customer_id'];
                        $getCustomerDetails = $ci->common->gettblrowdata(["status" => 1, "id" => $customerId], "id,name,code,company_code,branch_code,state,street,location,pincode,address,code,country", "tb_customers", 0, 0);
                        if (!empty($getCustomerDetails)) {
                            $countries[] = strtoupper($getCustomerDetails['country']);
                            $pdetail[] = ['type' => 'PF', 'name' => $getCustomerDetails['name'], 'cust_id' => $getCustomerDetails['code'], 'address' => $getCustomerDetails['address'], 'pincode' => $getCustomerDetails['pincode'], 'country' => strtoupper($getCustomerDetails['country']), 'street' => $getCustomerDetails['street'], 'city' => $getCustomerDetails['location'], 'state' => $getCustomerDetails['state'], 'party_id' => $getCustomerDetails['code']];
                        }
                    }
                    $countries[] = strtoupper($getOrderDetails['pickup_country']);
                    $countries[] = strtoupper($getOrderDetails['delivery_country']);
                    if (!empty($countries)) {
                        $countries = array_unique($countries);
                        $finalCountries = $ci->Order->getCountryCodesFromMaster($countries);
                    }
                    $cargos = [];
                    $totalVolume = $totalWeight = $totalQuantity = 0;
                    $getcargos = $ci->common->gettbldata(["order_id" => $id, 'status' => '1'], "cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content", "tb_order_cargodetails", 0, 0);
                    foreach ($getcargos as $cargores) {
                        $volume = $cargores['volume'] ?: "1";
                        $weight = $cargores['weight'] ?: "1";
                        $weight_unit = "KG";
                        $volume_unit = "CBM";
                        $length_unit = $width_unit = $height_unit = "CM";
                        if ($cargores['cargo_id'] != "") {
                            $chk = $ci->common->gettblrowdata(["id" => $cargores['cargo_id']], "length_unit,width_unit,height_unit,weight_unit,volume_unit", "tb_cargo_details", 0, 0);
                            if (!empty($chk)) {
                                $weight_unit = $chk['weight_unit'];
                                $volume_unit = $chk['volume_unit'];
                                $length_unit = $chk['length_unit'];
                                $width_unit = $chk['width_unit'];
                                $height_unit = $chk['height_unit'];
                            }
                        }
                        if ($length_unit == 'M') {
                            $cargores['length'] *= 100;
                        }
                        if ($width_unit == 'M') {
                            $cargores['width'] *= 100;
                        }
                        if ($height_unit == 'M') {
                            $cargores['height'] *= 100;
                        }
                        if ($length_unit == 'Inches') {
                            $cargores['length'] *= 2.54;
                        }
                        if ($width_unit == 'Inches') {
                            $cargores['width'] *= 2.54;
                        }
                        if ($height_unit == 'Inches') {
                            $cargores['height'] *= 2.54;
                        }
                        $content = $cargores['cargo_content'] ?? "";
                        $cargos[] = ['cargo_type' => $cargores['quantity_type'], 'content' => $content, 'length' => $cargores['length'], 'width' => $cargores['width'], 'height' => $cargores['height'], 'weight' => $weight, 'volume' => $volume, 'quantity' => $cargores['quantity'], 'weight_unit' => $weight_unit, 'volume_unit' => $volume_unit, 'height_unit' => $height_unit, 'length_unit' => $length_unit, 'width_unit' => $width_unit];

                        $totalVolume += $volume;
                        $totalWeight += $weight;
                        $totalQuantity += $cargores['quantity'];
                    }
                    $companyCode = $getOrderDetails['company_code'];
                    $branchCode = $getOrderDetails['branch_code'];
                    $shipmentRowId = $getOrderDetails['shipment_id'];
                    $logicalSender = $incoterm = '';
                    $logicalinfo = $ci->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode], "logical_sender", "tb_branch_master", 0, 0);
                    if (!empty($logicalinfo)) {
                        $logicalSender = $logicalinfo['logical_sender'];
                    }
                    if ($shipmentRowId > 0) {
                        $chekShipment = $ci->common->gettblrowdata(['id' => $shipmentRowId], "logicalreceiver,incoterm", "tb_shipments", 0, 0);
                        if (!empty($chekShipment)) {
                            if ($chekShipment['logicalreceiver'] != "") {
                                $LogicalReceiver = $chekShipment['logicalreceiver'];
                                $incoterm = $chekShipment['incoterm'];
                            }
                        }
                    }
                    $checkReference = $ci->common->gettbldata(['order_id' => $id, 'status' => '1'], "reference_id,ref_value", "tb_order_references", 0, 0);
                    foreach ($checkReference as $eachreference) {
                        $referenceId = $eachreference['reference_id'];
                        if (strlen($referenceId) == 2) {
                            $references[] = ["id" => $eachreference['reference_id'], "value" => $eachreference['ref_value']];
                        } else {
                            $shipperReferences[] = ['id' => $referenceId, 'value' => $eachreference['ref_value']];
                        }
                    }
                    $product = $getOrderDetails['product'];
                    if ($product == "") {
                        $product = "KN AsiaDirect";
                    }
                    $serviceType = "";
                    $getService = $ci->common->gettblrowdata(["order_row_id" => $id], "service", "tb_order_details", 0, 0);
                    if (!empty($getService)) {
                        $serviceId = $getService['service'];
                        if ($serviceId > 0) {
                            $getServiceName = $ci->common->gettblrowdata(["id" => $serviceId], "name", "tb_service_master", 0, 0);
                            if (!empty($getServiceName)) {
                                $serviceType = $getServiceName['name'];
                            }
                        }
                    }

                    $transportMode = 1;
                    $orderTranportMode = $getOrderDetails['transport_mode'];
                    if ($orderTranportMode == "LTL") {
                        $transportMode = 0;
                    }
                    $orderVehicleType = $getOrderDetails['vehicle_type'];
                    if ($orderVehicleType == "") {
                        $orderVehicleType = "F";
                    }
                    $PhysicalSender = 'KNRLG09';
                    $PhysicalReceiver = 'WWDPT01';
                    if (SYS_TYPE == 'TMS') {
                        $PhysicalSender = 'KNRLG01';
                        $PhysicalReceiver = 'WWDPP01';
                    }
                    $data = [
                        'SenderTransmissionNo' => $getOrderDetails['order_id'],
                        'pickup_datetime' => $getOrderDetails['pickup_datetime'],
                        'delivery_datetime' => $getOrderDetails['delivery_datetime'],
                        'pickup_endtime' => $getOrderDetails['pickup_endtime'],
                        'delivery_endtime' => $getOrderDetails['drop_endtime'],
                        'createdon' => $getOrderDetails['createdon'],
                        "delivery_company" => $getOrderDetails['delivery_company'],
                        'delivery_city' => $getOrderDetails['delivery_city'],
                        'delivery_country' => $finalCountries[strtoupper($getOrderDetails['delivery_country'])] ?? $getOrderDetails['delivery_country'],
                        'delivery_address1' => $getOrderDetails['delivery_address1'],
                        'delivery_address2' => $getOrderDetails['delivery_address2'],
                        'delivery_pincode' => $getOrderDetails['delivery_pincode'],
                        'branch_code' => $branchCode,
                        'company_code' => $companyCode,
                        'transport_mode' => $getOrderDetails['transport_mode'],
                        'pickup_country' => $finalCountries[strtoupper($getOrderDetails['pickup_country'])] ?? $getOrderDetails['pickup_country'],
                        'pickup_pincode' => $getOrderDetails['pickup_pincode'],
                        "pickup_company" => $getOrderDetails['pickup_company'],
                        'pickup_city' => $getOrderDetails['pickup_city'],
                        'pickup_address1' => $getOrderDetails['pickup_address1'],
                        'pickup_address2' => $getOrderDetails['pickup_address2'],
                        'cargos' => $cargos,
                        'weight' => $totalWeight,
                        'total_volume' => $totalVolume,
                        "vehicle_type" => $orderVehicleType,
                        "parties" => $pdetail,
                        "physicalreceiver" => $PhysicalReceiver,
                        "logicalreceiver" => $LogicalReceiver,
                        "physicalsender" => $PhysicalSender,
                        "logicalsender" => $logicalSender,
                        "quantity" => $totalQuantity,
                        "freight_term" => "",
                        "freight_termname" => "",
                        "product" => $product,
                        "service_type" => $serviceType,
                        "hrs" => $timeZoneHours,
                        't_mode' => $transportMode,
                        'country_name' => $countryName,
                        "cntrycode" => $countryCode,
                        'shipmentid' => $getOrderDetails['shipmentid'],
                        'carrierDetails' => $carrierDetails,
                        'packageCodes' => $packageCodes,
                        'finalCountries' => $finalCountries,
                        'shipperReferences' => $shipperReferences,
                        'refs' => $references,
                        'incoterm' => $incoterm
                    ];
                    //log_message("error","id:".$id);
                    $this->sendKNloginOrderxmlservice($data);
                    $upd = $ci->common->updatetbledata("tb_orders", ["is_created" => 2], ["id" => $id]);
                }
            }
        }
    }
    
    public function sendOrderStatusXmlstoKNlogin($id) : int
    {
        //log_message("error","idStatus:".$id);
        $ci = &get_instance();
        $successVal = 0;
        if($id != ""){
            $notSentOrders = $ordersToSent = $orderIds = $inTransitData = $orderRowIds = $statusIds = $orderStatusIds = $sentOrders = $statusOrders = [];
            $currentDate = date('Y-m-d H:i:s');
            $updatedDate = date('Y-m-d\TH:i:s', strtotime($currentDate));
            $checkOrders = $ci->Order->checkMyknCustomerFromOrders(
                "o.id,
                 o.order_id,
                 o.pickup_city,
                 o.delivery_city,
                 o.user_id,
                 o.company_code,
                 o.branch_code,
                 o.modeoftransport,
                 o.shift_id,
                 o.trip_id,
                 o.shipmentid,
                 o.is_created,
                 o.shift_id,
                 c.name,
                 c.sendto_knlogin,
                 d.department_code,
                 o.company_code,
                 o.branch_code",
                 [$id]
            );
            //log_message("error","idStatusQry:".$ci->db->last_query());
            if (!empty($checkOrders)) {
                /*$companyCode = $ci->session->userdata('company_code');
                $branchCode = $ci->session->userdata('branch_code');
                $hours = $ci->session->userdata("usr_tzone")['hrs'];
                $timeZoneHours = str_replace(".", ":", $hours);
                $timeZone = $ci->session->userdata("usr_tzone")['timezone'];*/
                
                $LogicalReceiver = "WWWWW99";
                $PhysicalReceiver = 'WWDPT01';
                $PhysicalSender = 'KNRLG09';
                if (SYS_TYPE == 'TMS') {
                    $PhysicalReceiver = 'WWDPP01';
                    $PhysicalSender = 'KNRLG01';
                }
                $logicalinfo = $ci->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode], "logical_sender", "tb_branch_master", 0, 0);
                //log_message("error","idStatusQry11:".$ci->db->last_query());
                $logicalSender = $logicalinfo['logical_sender'] ?: "THPNA74";
                foreach ($checkOrders as $eachOrder) {
                    //log_message("error","sendtoknlogin:".$eachOrder['sendto_knlogin']);
                    $uid = $eachOrder['user_id'];
                    $companyCode = $eachOrder['company_code'];
                    $branchCode = $eachOrder['company_code'];
                    $timeZoneHours = $countryName = $countryCode = "";
                    $gethrs = $ci->db->query(
                        "SELECT c.cntry_hrs,c.cntry_timezone
                        FROM tbl_country_master AS c, tb_users AS u
                        WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                        LIMIT 1",
                        [$uid]
                    );
                    if ($gethrs && $gethrs->num_rows() > 0) {
                        $timeZoneHours = $gethrs->row()->cntry_hrs;
                        $timeZoneHours = str_replace(".", ":", $timeZoneHours);
                        $timeZone = $gethrs->row()->cnry_timezone;
                    }
                    if ($eachOrder['sendto_knlogin'] == 1) {
                        //log_message("error","shiftid:".$eachOrder['shift_id']);
                        if ($eachOrder['shift_id'] > 0) {
                            //log_message("error","is_created:".$eachOrder['is_created']);
                            if ($eachOrder['is_created'] == 2) {
                                $orderIds[] = $eachOrder['id'];
                                $ordersToSent[$eachOrder['id']] = [
                                    'id' => $eachOrder['id'],
                                    'order_id' => $eachOrder['order_id'],
                                    'pickup_city' => $eachOrder['pickup_city'],
                                    'delivery_city' => $eachOrder['delivery_city'],
                                    'company_code' => $eachOrder['company_code'],
                                    'branch_code' => $eachOrder['branch_code'],
                                    'modeoftransport' => $eachOrder['modeoftransport'],
                                    'shift_id' => $eachOrder['shift_id'],
                                    'trip_id' => $eachOrder['trip_id'],
                                    'shipmentid' => $eachOrder['shipmentid']
                                ];
                            } else {
                                $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Order is not Sent To Knlogin', 'status' => 0];
                            }
                        } else {
                            $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Trip is not created for Order', 'status' => 0];
                        }
                    } else {
                        $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Send To KnLogin not enabled', 'status' => 0];
                    }
                }
                //log_message("error","orderIds:".json_encode($orderIds));
                if (!empty($orderIds)) {
                    $getStops = $ci->Order->getOrderDetailsWithStopsStatus($orderIds);
                    //log_message("error","getStops:".$ci->db->last_query());
                    foreach ($getStops as $eachStopId) {
                        if ($eachStopId["driver_id"] != "") {
                            $statusIds[] = $eachStopId['id'];
                        } else {
                            $orderStatusIds[] = $eachStopId['id'];
                        }
                        $orderRowId = $eachStopId['order_id'];
                        if (!in_array($eachStopId['order_id'], $statusOrders, true)) {
                            $statusOrders[] = $eachStopId['order_id'];
                        }
                        $getactual = getdatetimebytimezone($timeZone, $eachStopId['createdon'], DFLT_TZ);
                        $createdon = $getactual['datetime'];
                        $date = $getactual['date'];
                        $time = $getactual['time'] . "" . $timeZoneHours;
                        $statusDateTime = date('Y-m-d\TH:i:s', strtotime($createdon)) . "" . $timeZoneHours;
                        $getmyknstatuscodes = $ci->db->select("mykn_status_code")->get_where("tb_statuscodes_reference", ["svk_status_code" => $eachStopId['status_code']], 1, 0);
                        //log_message("error","getmyknstatuscodes:".$ci->db->last_query());
                        if ($getmyknstatuscodes->num_rows() > 0) {
                            $eachStopId['status_code'] = $getmyknstatuscodes->row()->mykn_status_code;
                        }
                        $statusToBeSent = [
                            "shipment_id" => $ordersToSent[$orderRowId]['shipmentid'] ?? "",
                            "shipmentid" => $ordersToSent[$orderRowId]['shipmentid'] ?? "",
                            "latitude" => $eachStopId['latitude'] ?? "",
                            "longitude" => $eachStopId['longitude'] ?? "",
                            "status_code" => $eachStopId['status_code'] ?? "",
                            "status_location" => $eachStopId['loc_name'] ?? "",
                            "company_code" => $companyCode,
                            "branch_code" => $ordersToSent[$orderRowId]['branch_code'] ?? "",
                            "pickup_city" => $ordersToSent[$orderRowId]['pickup_city'] ?? "",
                            "delivery_city" => $ordersToSent[$orderRowId]['delivery_city'] ?? "",
                            "logicalreceiver" => $LogicalReceiver,
                            "physicalreceiver" => $PhysicalReceiver,
                            "physicalsender" => $PhysicalSender,
                            "logicalsender" => $logicalSender,
                            "modeoftransport" => $ordersToSent[$orderRowId]['modeoftransport'] ?? "",
                            "department_code" => $ordersToSent[$orderRowId]['department_code'] ?? "",
                            "trackingnumber" => $ordersToSent[$orderRowId]['order_id'] ?? "",
                            "ref_id" => "INN",
                            "ref_num" => "RL" . $ordersToSent[$orderRowId]['order_id'] ?? "",
                            "createdon" => $createdon,
                            "date" => $date,
                            "time" => $time,
                            'curdt' => $statusDateTime,
                            'curdt1' => $updatedDate,
                            "order_id" => $ordersToSent[$orderRowId]['order_id'] ?? "",
                            "createdon"=> '',
                        ];
                        
                        //log_message("error","status_code:".$eachStopId['status_code']);
                        $this->knloginsendorderstatus($statusToBeSent);
                        /*if ($eachStopId['status_code'] != '1550') {
                            $this->knloginsendorderstatus($statusToBeSent);
                        } else {
                            $inTransitData[$eachStopId['id']] = (object) $statusToBeSent;
                            if (!in_array($eachStopId['order_id'], $orderRowIds, true)) {
                                $orderRowIds[] = $eachStopId['order_id'];
                            }
                        }*/
                    }
                    /*if (!empty($inTransitData)) {
                        $this->sendHighestIntransitStatusFORCNTW($inTransitData, $orderRowIds, ['companyCode' => $companyCode, 'branchCode' => $branchCode, 'timeZone' => $timeZone, 'updatedDate' => $updatedDate, 'hours' => $timeZoneHours]);
                    }*/
                    if (!empty($statusOrders)) {
                        foreach ($statusOrders as $eachOrder) {
                            $sentOrders[] = ['orderId' => $ordersToSent[$eachOrder]['order_id'] ?? "", 'customer' => $ordersToSent[$eachOrder]['name'] ?? "", 'message' => 'Sent to myKN', 'status' => 1];
                        }
                    } else {
                        $notSentOrders[] = ['orderId' => '-', 'customer' => '-', 'message' => 'There are no statuses to send for myKN', 'status' => 1];
                    }
                }
                if (!empty($statusIds)) {
                    $updateQuery = $ci->common->updatetbledata("tb_stop_status", ["sentknlogin" => 1], "id IN (" . implode(',', $statusIds) . ")");
                }
                if(!empty($orderStatusIds))
                    $ci->common->updatetbledata("tb_order_status", ["sentknlogin" => 1], "id IN (" . implode(',', $orderStatusIds) . ")");
                }
    
            $excelResponse = array_merge($sentOrders, $notSentOrders);
            if (!empty($excelResponse)) {
                @file_put_contents("assets/ordertemplate/exceluploaddata.txt", json_encode($excelResponse));
            }
            $successVal = $successVal + 1; 
        }
        return $successVal;
    }

    public function knloginshipmentstatus(array $postdata): bool
    {
        $ci = &get_instance();
        /*2300 -> Delivery Shipment Dispatched, 2400 -> Planned Delivery Date, 3000 -> Delivered to Consignee, 3060 -> POD Available */
        $post['shipment_id'] = $postdata['shipment_id'] ?? "";
        $post['trip_id'] = $postdata['trip_id'] ?? "";
        $post['latitude'] = $postdata['latitude'] ?? "";
        $post['longitude'] = $postdata['longitude'] ?? "";
        if (in_array("", [$post['shipment_id'], $post['trip_id']], true)) {
            return false;
        }
        $post['status_code'] = $postdata['status_code'] ?? "";
        if ($post['status_code'] == "") {
            return false;
        }
        $getOrderDetails = $ci->common->gettblrowdata(["order_id" => $postdata['order_id']], "id,pickup_city,delivery_city, company_code, branch_code, shipmentid,modeoftransport,shipment_id", "tb_orders", 0, 0);
        $orderRowId = $getOrderDetails['id'] ?? 0;
        if ($orderRowId > 0) {
            $post['logicalreceiver'] = "WWWWW99";
            $post['physicalreceiver'] = 'WWDPT01';
            $post['physicalsender'] = 'KNRLG09';
            if (SYS_TYPE == 'TMS') {
                $post['physicalreceiver'] = 'WWDPP01';
                $post['physicalsender'] = 'KNRLG01';
            }
            $post['company_code'] = $getOrderDetails['company_code'] ?? "";
            $post['branch_code'] = $getOrderDetails['branch_code'] ?? "";
            $post['shipment_id'] = $getOrderDetails['shipmentid'] ?? "";
            $post['modeoftransport'] = $getOrderDetails['modeoftransport'] ?? "";
            $post['pickup_city'] = $getOrderDetails['pickup_city'] ?? "";
            $post['delivery_city'] = $getOrderDetails['delivery_city'] ?? "";
            $getDepartmentCode = $ci->common->gettblrowdata(['order_row_id' => $orderRowId, 'status' => '1'], "department_code", "tb_order_details", 0, 0);
            $post['department_code'] = $getDepartmentCode['department_code'] ?? "ETRA";
            $logicalinfo = $ci->common->gettblrowdata(['company_code' => $post['company_code'], 'branch_code' => $post['branch_code']], "logical_sender", "tb_branch_master", 0, 0);
            $post['logicalsender'] = $logicalinfo['logical_sender'] ?? "THPNA74";
            $post['trackingnumber'] = $postdata['order_id'];
            $post['ref_id'] = 'INN';
            $post['ref_num'] = "RL" . $post['trackingnumber'];
            $getStatusDate = $ci->common->gettblrowdata(['order_id' => $orderRowId, 'status_code' => $post['status_code'], 'status' => '1'], "id,createdon", "tb_stop_status", 0, 0);
            $post['createdon'] = $getStatusDate['createdon'] ?? date('Y-m-d H:i:s');
            $statusId = $getStatusDate['id'] ?? 0;
            if ($statusId > 0) {
                $updateQuery = $ci->common->updatetbledata("tb_stop_status", ['sentknlogin' => 1], ['id' => $statusId]);
            }
            $hrs = "Z";
            if (isset($postdata['hrs'])) {
                $hrs = str_replace(".", ":", $postdata['hrs']);
            }
            if (isset($postdata['curtz'])) {
                $getactual = getdatetimebytimezone($postdata['curtz'], $post['createdon'], DFLT_TZ);
                $post['createdon'] = $getactual['datetime'];
                $post['date'] = $getactual['date'];
                $post['time'] = $getactual['time'] . "" . $hrs;
            } else {
                $post['date'] = date('Y-m-d');
                $post['time'] = date('H:i:s') . "" . $hrs;
            }
            $post['curdt'] = date('Y-m-d\TH:i:s', strtotime($post['createdon'])) . "" . $hrs;
            $post['curdt1'] = date('Y-m-d\TH:i:s', strtotime($post['createdon']));
            return $this->knloginsendorderstatus($post);
            }
        return false;
    }

    public function sendHighestIntransitStatusFORCNTW(array $postData, array $orderRowIds, array $generalInfo): void
    {
        $ci =& get_instance();
        $companyCode = $generalInfo['companyCode'];
        $branchCode = $generalInfo['branchCode'];
        $timeZone = $generalInfo['timeZone'];
        $updatedDate = $generalInfo['updatedDate'];
        $hours = $generalInfo['hours'];
        $LogicalReceiver = "WWWWW99";
        $PhysicalReceiver = "WWDPT01";
        $PhysicalSender = "KNRLG01";
        $newLogicalSender = "THPNA74";
        $department_code = "ETRA";
        $ref_id = "INN";
        foreach ($orderRowIds as $eachRow) {
            $getLastestIntrasnitDate = $ci->db->query("SELECT id as stid,latitude,longitude,status_code,sentknlogin,createdon from tb_stop_status where createdon = (SELECT MAX(createdon) FROM tb_stop_status WHERE status_code in ? AND status =? AND order_id =?) AND status_code in ? AND order_id = ? AND status = ? LIMIT 1", [['1550','SV0230'], '1', $eachRow, ['1550','SV0230'], $eachRow, '1']);
            $intransitData = $getLastestIntrasnitDate->num_rows() > 0 ? $getLastestIntrasnitDate->row_array() : [];
            if (!empty($intransitData)) {
                $sentKnLogin = $intransitData['sentknlogin'];
                if ($sentKnLogin == 0) {
                    $finalStatusId = $intransitData['stid'];
                    $requestDate = $postData[$finalStatusId] ?? [];
                    if (!empty($requestDate)) {
                        $refNumber = "RL" . $requestDate->order_id;
                        $getactual = getdatetimebytimezone($timeZone, $requestDate->createdon, DFLT_TZ);
                        $createdon = $getactual['datetime'];
                        $date = $getactual['date'];
                        $time = $getactual['time'] . "" . $hours;
                        $currentDate = date('Y-m-d\TH:i:s', strtotime($createdon)) . "" . $hours;
                        $finalData = [
                            "shipment_id" => $requestDate->shipmentid,
                            "latitude" => $requestDate->latitude,
                            "longitude" => $requestDate->longitude,
                            "status_code" => $requestDate->status_code,
                            "company_code" => $companyCode,
                            "branch_code" => $branchCode,
                            "pickup_city" => $requestDate->pickup_city,
                            "logicalreceiver" => $LogicalReceiver,
                            "physicalreceiver" => $PhysicalReceiver,
                            "physicalsender" => $PhysicalSender,
                            "logicalsender" => $newLogicalSender,
                            "modeoftransport" => $requestDate->modeoftransport,
                            "department_code" => $department_code,
                            "trackingnumber" => $requestDate->order_id,
                            "ref_id" => $ref_id,
                            "ref_num" => $refNumber,
                            "createdon" => $createdon,
                            "date" => $date,
                            "time" => $time,
                            'curdt' => $currentDate,
                            'curdt1' => $updatedDate
                        ];
                        $updateQuery = $ci->common->updatetbledata("tb_stop_status", ["sentknlogin" => 1], ["id" => $finalStatusId]);
                        $sendStatus = $this->knloginsendorderstatus($finalData);
                    }
                }
            }
        }
    }

    /**
     * knlogin send order status.
     *
     * @param  mixed $post
     * @return void
     */
    public function knloginsendorderstatus(array $post):bool
    {
        //log_message("error","post:".json_encode($post));
        $deliveryStatus = ['0192', '2300', '3000'];
        $otherStatus = ['1500','1600'];
        $request = '';
        $request .= '<?xml version="1.0" encoding="UTF-8"?><ns9:RoadStatus xmlns:ns6="http://knie4.int.kn/com/lref/0100" xmlns:ns5="http://knie4.int.kn/com/lsts/0200" xmlns:ns8="http://knie4.int.kn/com/lpaci/0200" xmlns:ns7="http://knie4.int.kn/com/lrtv/0100" xmlns:ns9="http://knie4.int.kn/msg/roadstatus/0100" xmlns:ns2="http://knie4.int.kn/com/ltypes/0200" xmlns:ns4="http://knie4.int.kn/com/lmlv/0200" xmlns:ns3="http://knie4.int.kn/com/lhdr/0200">';
        $request .= '<ns3:MessageHeader>';
        $request .= '<ReceiverDetails ns2:AddressType="FW">';
        $request .= '<PhysicalReceiver>'.$post['physicalreceiver'].'</PhysicalReceiver>';
        $request .= '<LogicalReceiver>'.$post['logicalreceiver'].'</LogicalReceiver>';
        $request .= '</ReceiverDetails>';
        $request .= '<PhysicalSender>'.$post['physicalsender'].'</PhysicalSender>';
        $request .= '<LogicalSender>'.$post['logicalsender'].'</LogicalSender>';
        $request .= '<SendingApplication>ROADLOG</SendingApplication>';
        $request .= '<MessageType>RoadStatus</MessageType>';
        $request .= '<VersionNumber>0100</VersionNumber>';
        $request .= '<CreationDateTime>'.$post['curdt1'].'Z</CreationDateTime>';
        $request .= '<FunctionCode>CR</FunctionCode>';
        $request .= '</ns3:MessageHeader>';
        $request .= '<Message>';
        $request .= '<ns4:MessageLevel>';
        $request .= '<TrackingNumber>'.$post['trackingnumber'].'</TrackingNumber>';
        $request .= '<SenderInformation>';
        $request .= '<CompanyCode>'.$post['company_code'].'</CompanyCode>';
        $request .= '<BranchCode>'.$post['branch_code'].'</BranchCode>';
        $request .= '<DepartmentCode>'.$post['department_code'].'</DepartmentCode>';
        $request .= '<ModeOfTransport>1</ModeOfTransport>';
        $request .= '</SenderInformation>';
        $request .= '<MessageReferences ns2:AddressType="FF">';
        $request .= '<Code>'.$post['ref_id'].'</Code>';
        $request .= '<Value>'.$post['ref_num'].'</Value>';
        $request .= '</MessageReferences>';
        $request .= '</ns4:MessageLevel>';
        $request .= '<ns5:StatusInformation ns2:StatusCode="'.$post['status_code'].'">';
        $request .= '<StatusDate>'.$post['date'].'</StatusDate>';
        $request .= '<StatusTime>'.$post['time'].'</StatusTime>';
        if (in_array($post['status_code'], $otherStatus, true)) {
            $request .= '<StatusLocation ns2:LocationIssuer="ZZZ">' . $post['status_location'] . '</StatusLocation>';
        } elseif (in_array($post['status_code'], $deliveryStatus, true)) {
            $request .= '<StatusLocation ns2:LocationIssuer="ZZZ">' . $post['delivery_city'] . '</StatusLocation>';
        } else {
            $request .= '<StatusLocation ns2:LocationIssuer="ZZZ">' . $post['pickup_city'] . '</StatusLocation>';
        }
        $request .= '<StatusLocation ns2:LocationIssuer="6">'.$post['pickup_city'].'</StatusLocation>';
        $request .= '<AdditionalStatusInformation>';
        $request .= '<CreationIdentifier>R</CreationIdentifier>';
        $request .= '<StatusEntryDateTime>'.$post['curdt'].'</StatusEntryDateTime>';
        $request .= '<UserIdentifier>root</UserIdentifier>';
        $request .= '</AdditionalStatusInformation>';
        $request .= '<AdditionalRoadStatusInformation/>';
        $request .= '</ns5:StatusInformation>';
        $request .= '<Shipment/>';
        $request .= '</Message>';
        $request .= '</ns9:RoadStatus>';
        log_message('error', "knloginstatussend-xml " . $request);
        $serviceurl = BOOKING_ETRA_STS_URL;
         $username = BOOKING_ETRA_USRNAME;
         $password = BOOKING_ETRA_PWD;
         $headers = array(
             'Content-Type: application/xml',
             'Authorization: Basic '. base64_encode("$username:$password")
         );
         $output = thirdpartyservicecurl($serviceurl,$headers,$request);
        return true;
    }


    /**
     * send booking status.
     *
     * @param  mixed $data
     * @return void
     */
    public function sendbookingstatus($data){
        $request = '';
        $request .= '<ns20:RoadShipment xmlns:ns20="http://knie4.int.kn/msg/roadshipment/0100" xmlns:ns10="http://knie4.int.kn/com/ldgs/0200" xmlns:ns11="http://knie4.int.kn/com/ldim/0200" xmlns:ns12="http://knie4.int.kn/com/lpaci/0200" xmlns:ns13="http://knie4.int.kn/com/lrdtl/0200" xmlns:ns14="http://knie4.int.kn/com/lprc/0100" xmlns:ns15="http://knie4.int.kn/com/lrour/0100" xmlns:ns16="http://knie4.int.kn/com/lonc/0100" xmlns:ns17="http://knie4.int.kn/com/ltxt/0200" xmlns:ns18="http://knie4.int.kn/com/ltxtk/0100" xmlns:ns19="http://knie4.int.kn/com/lcnt/0100" xmlns:ns2="http://knie4.int.kn/com/ltypes/0200" xmlns:ns21="http://knie4.int.kn/com/laia/0100" xmlns:ns22="http://knie4.int.kn/com/lsdi/0100" xmlns:ns23="http://knie4.int.kn/com/lriroa/0200" xmlns:ns3="http://knie4.int.kn/com/lhdr/0200" xmlns:ns4="http://knie4.int.kn/com/ltru/0200" xmlns:ns5="http://knie4.int.kn/com/lmlv/0200" xmlns:ns6="http://knie4.int.kn/com/lsts/0200" xmlns:ns7="http://knie4.int.kn/com/lshpd/0200" xmlns:ns8="http://knie4.int.kn/com/ladr/0200" xmlns:ns9="http://knie4.int.kn/com/lcgod/0200">';
        $request .= '<ns3:MessageHeader>';
        $request .= '<ReceiverDetails ns2:AddressType="SU">';
        $request .= '<PhysicalReceiver>'.$data['physicalreceiver'].'</PhysicalReceiver>';
        $request .= '<LogicalReceiver>'.$data['logicalreceiver'].'</LogicalReceiver>';
        $request .= '</ReceiverDetails>';
        $request .= '<PhysicalSender>'.$data['physicalsender'].'</PhysicalSender>';
        $request .= '<LogicalSender>'.$data['logicalsender'].'</LogicalSender>';
        $request .= '<SendingApplication>ROADLOG</SendingApplication>';
        $request .= '<MessageType>RoadShipment</MessageType>';
        $request .= '<VersionNumber>0100</VersionNumber>';
        $request .= '<CreationDateTime>'.date("Y-m-d",strtotime($data['createdon'])).'T'.date("H:i:s",strtotime($data['createdon'])).'Z</CreationDateTime>';
        $request .= '<FunctionCode>UP</FunctionCode>';
        $request .= '</ns3:MessageHeader>';
        $request .= '<Message>';
        $request .= '<ns4:TruckAndTrailer>';
        $request .= '<Trailer></Trailer>';
        $request .= '<VoyageNumber></VoyageNumber>';
        $request .= '<TourNumber></TourNumber>';
        $request .= '<Origin>';
        $request .= '<Location ns2:LocationIssuer="6">'.$data['branch_code'].'</Location>';
        $request .= '<Location ns2:LocationIssuer="ZZZ">'.$data['country_name'].'</Location>';
        $request .= '<Date>'.date("Y-m-d",strtotime($data['createdon'])).'</Date>';
        $request .= '</Origin>';
        $request .= '<NumberOfShipments>1</NumberOfShipments>';
        foreach($data['parties'] as $ca1){
            if($ca1['type'] == "Carrier"){
                $request .= '<ns8:NameAddress ns2:AddressType="CA">';
                $request .= '<Name>'.$ca1['name'].'</Name>';
                $request .= '<Street>' . substr($ca1['street'], 0, 34) . '</Street>';
                $request .= '<City>'.$ca1['city'].'</City>';
                $request .= '<CountryCode>'.strtoupper($ca1['country']).'</CountryCode>';
                $request .= '<ZipCode>'.$ca1['pincode'].'</ZipCode>';
                $request .= '<CustomerIdentifier>'.$ca1['cust_id'].'</CustomerIdentifier>';
                $request .= '<PartyIdentifier>'.$ca1['party_id'].'</PartyIdentifier>';
                $request .= '</ns8:NameAddress>';
            }
        }
        $tracknum = $data['SenderTransmissionNo'];
        $str = substr($data['SenderTransmissionNo'], 0, 2);
        if(!is_numeric($str)){
            $tracknum = substr($data['SenderTransmissionNo'], 2);
            $tracknum = $data['country_code'].$tracknum;
        }
        $request .= '<Text ns2:TextType="HAN"></Text>';
        $request .= '<TripType>'.$data['vehicle_type'].'</TripType>';
        $request .= '<LoadingCapacity>'.$data['total_weight'].'</LoadingCapacity>';
        $request .= '</ns4:TruckAndTrailer>';
        $request .= '<Shipment>';
        $request .= '<ns5:MessageLevel>';
        $request .= '<TrackingNumber ns2:Counter="1">'.$tracknum.'</TrackingNumber>';
        $request .= '<SenderInformation>';
        $request .= '<CompanyCode>'.$data['company_code'].'</CompanyCode>';
        $request .= '<BranchCode>'.$data['branch_code'].'</BranchCode>';
        $request .= '<ModeOfTransport>1</ModeOfTransport>';
        $request .= '<ExportImportFlag>1</ExportImportFlag>';
        $request .= '</SenderInformation>';
        if(count($data['refs'])>0){
            foreach($data['refs'] as $rs){
                if($rs['id'] == "INN"){
                    $refval = $rs['value'];
                    if($refval == $tracknum){
                        $refval = "RL".$tracknum;
                    }
                    $request .= '<MessageReferences ns2:AddressType="FF">';
                    $request .= '<Code>INN</Code>';
                    $request .= '<Value>RL'.$tracknum.'</Value>';
                    $request .= '</MessageReferences>';
                }
            }
        }else{
            $request .= '<MessageReferences ns2:AddressType="FF">';
            $request .= '<Code>INN</Code>';
            $request .= '<Value>RL'.$tracknum.'</Value>';
            $request .= '</MessageReferences>';
        }
        $request .= '</ns5:MessageLevel>';
        $request .= '<ShipmentInformation>';
        $request .= '<ns7:ShipmentDetails>';
        $request .= '<TotalPackages>'.round($data['quantity']).'</TotalPackages>';
        $request .= '<Measurements ns2:MeasurementType="AAD">';
        $request .= '<Value>176</Value>';
        $request .= '<UnitOfMeasurementCode>KGM</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<Measurements ns2:MeasurementType="ABJ">';
        $request .= '<Value>0</Value>';
        $request .= '<UnitOfMeasurementCode>MTQ</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<Measurements ns2:MeasurementType="ACV">';
        $request .= '<Value>0</Value>';
        $request .= '<UnitOfMeasurementCode>MTR</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<Measurements ns2:MeasurementType="ACG">';
        $request .= '<Value>7000</Value>';
        $request .= '<UnitOfMeasurementCode>KGM</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<DangerousGoodsFlag>N</DangerousGoodsFlag>';
        $request .= '<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>';
        $request .= '<TermsOfTrade>';
        $request .= '<Incoterm>'.$data['incoterm'].'</Incoterm>';
        $request .= '</TermsOfTrade>';
        $request .= '<Origin>';
        $request .= '<OriginLocation ns2:LocationIssuer="ZZZ">'.$data['pickup_city'].'</OriginLocation>';
        $request .= '<Date>'.date("Y-m-d",strtotime($data['pickup_datetime'])).'</Date>';
        $request .= '</Origin>';
        $request .= '<Destination>';
        $request .= '<DestinationLocation ns2:LocationIssuer="ZZZ">'.$data['delivery_city'].'</DestinationLocation>';
        $request .= '<Date>'.date("Y-m-d",strtotime($data['delivery_datetime'])).'</Date>';
        $request .= '</Destination>';
        $request .= '<Location ns2:LocationType="27" ns2:LocationIssuer="6">'.$data['cntrycode'].'</Location>';
        $request .= '<Location ns2:LocationType="28" ns2:LocationIssuer="6">'.$data['cntrycode'].'</Location>';
        $request .= '<BusinessSolution>';
        $request .= '<Code>XF</Code>';
        $request .= '<CategoryCode>X</CategoryCode>';
        $request .= '</BusinessSolution>';
        $request .= '</ns7:ShipmentDetails>';
        foreach($data['parties'] as $res1){
            if($res1['type'] == "Shipper"){
                $request .= '<ns8:NameAddress ns2:AddressType="SH">';
                $request .= '<Name>'.$res1['name'].'</Name>';
                $request .= '<Street>' . substr($res1['street'], 0, 34) . '</Street>';
                $request .= '<City>'.$res1['city'].'</City>';
                $request .= '<CountryCode>'.strtoupper($res1['country']).'</CountryCode>';
                $request .= '<ZipCode>'.$res1['pincode'].'</ZipCode>';
                $request .= '<CustomerIdentifier>'.$res1['cust_id'].'</CustomerIdentifier>';
                $request .= '<PartyIdentifier>'.$res1['party_id'].'</PartyIdentifier>';
                $request .= '</ns8:NameAddress>';
            }
            if($res1['type'] == "Consignee"){
                $request .= '<ns8:NameAddress ns2:AddressType="CN">';
                $request .= '<Name>'.$res1['name'].'</Name>';
                $request .= '<Street>' . substr($res1['street'], 0, 34) . '</Street>';
                $request .= '<City>'.$res1['city'].'</City>';
                $request .= '<CountryCode>'.strtoupper($res1['country']).'</CountryCode>';
                $request .= '<ZipCode>'.$res1['pincode'].'</ZipCode>';
                $request .= '<CustomerIdentifier>'.$res1['cust_id'].'</CustomerIdentifier>';
                $request .= '<PartyIdentifier>'.$res1['party_id'].'</PartyIdentifier>';
                $request .= '</ns8:NameAddress>';
            }
            if($res1['type'] == "PF"){
                $request .= '<ns8:NameAddress ns2:AddressType="PF">';
                $request .= '<Name>'.$res1['name'].'</Name>';
                $request .= '<Street>' . substr($res1['street'], 0, 34) . '</Street>';
                $request .= '<City>'.$res1['city'].'</City>';
                $request .= '<CountryCode>'.strtoupper($res1['country']).'</CountryCode>';
                $request .= '<ZipCode>'.$res1['pincode'].'</ZipCode>';
                $request .= '<CustomerIdentifier>'.$res1['cust_id'].'</CustomerIdentifier>';
                $request .= '<PartyIdentifier>'.$res1['party_id'].'</PartyIdentifier>';
                $request .= '</ns8:NameAddress>';
            }
        }
        $request .= '<CargoDescription>';
        foreach($data['cargos'] as $info){
            $request .= '<ns9:CargoDescriptionDetails>';
            $request .= '<CargoItem>1</CargoItem>';
            $request .= '<NumberOfPackages>';
            $request .= '<Value>'.number_format($info['quantity']).'</Value>';
            $cargo_type = $info['cargo_type'];
            if($cargo_type == ""){
                $cargo_type = $data['cargo_type'];
            }
            $request .= '<QuantityType>'.$cargo_type.'</QuantityType>';
            $request .= '</NumberOfPackages>';
            $request .= '<GrossWeight>';

            $request .= '<Value>'.number_format($info['weight']).'</Value>';
            $request .= '<UnitOfMeasurementCode>KGM</UnitOfMeasurementCode>';
            $request .= '</GrossWeight>';
            $request .= '<Volume>';
            $request .= '<Value>'.number_format($info['volume']).'</Value>';
            $request .= '<UnitOfMeasurementCode>MTQ</UnitOfMeasurementCode>';
            $request .= '</Volume>';
            $request .= '<MarksAndNumbers ns2:SequenceNumber="1"/>';
            $request .= '<CargoContent ns2:SequenceNumber="1">Dummy</CargoContent>';
            $request .= '<RoadInformation>';
            $request .= '<StackableFlag>N</StackableFlag>';
            $request .= '</RoadInformation>';
            $request .= '</ns9:CargoDescriptionDetails>';
        }
        $request .= '<ns11:Dimensions>';
        $request .= '<NumberOfPackages>';
        $request .= '<Value>'.number_format($data['quantity']).'</Value>';
        $request .= '<QuantityType>PCS</QuantityType>';
        $request .= '</NumberOfPackages>';
        $request .= '</ns11:Dimensions>';
        $request .= '</CargoDescription>';
        $request .= '</ShipmentInformation>';
        $request .= '<ShipmentRoad>';
        $request .= '<ns13:RoadDetails>';
        $request .= '<FreightName>';
        $request .= '<Term>'.$data['freight_term'].'</Term>';
        $request .= '<Name>'.$data['freight_termname'].'</Name>';
        $request .= '</FreightName>';
        $request .= '<Product>'.$data['product'].'</Product>';
        $request .= '<ServiceType>'.$data['service_type'].'</ServiceType>';
        $request .= '<AppointmentRequired>N</AppointmentRequired>';
        $request .= '<DeliverComplete>N</DeliverComplete>';
        $request .= '<OriginalDocumentsRequired>N</OriginalDocumentsRequired>';
        $request .= '<Tail-LiftRequired>N</Tail-LiftRequired>';
        $request .= '<EKAERRequired>N</EKAERRequired>';
        $request .= '<EKAERNumber>NE</EKAERNumber>';
        $request .= '<CustomsRequired>N</CustomsRequired>';
        $request .= '<HighValue>N</HighValue>';
        $request .= '<TimeWindow>N</TimeWindow>';
        $request .= '<OversizedGoods>N</OversizedGoods>';
        $request .= '<PrivateConsignee>N</PrivateConsignee>';
        $request .= '</ns13:RoadDetails>';
        $request .= '<TruckingWayPoint ns20:WayPointType="PUP">';
        $request .= '<ns8:NameAddress ns2:AddressType="PU">';
        $request .= '<Name>'.$data['pickup_company'].'</Name>';
        $request .= '<Street>' . substr($data['delivery_address1'], 0, 34) . '</Street>';
        $request .= '<City>'.$data['pickup_city'].'</City>';
        $request .= '<CountryCode>'.$data['pickup_country'].'</CountryCode>';
        $request .= '<ZipCode>'.$data['pickup_pincode'].'</ZipCode>';
        $request .= '<CustomerIdentifier>1002971306</CustomerIdentifier>';
        $request .= '<PartyIdentifier>ELMAITSOM001</PartyIdentifier>';
        $request .= '</ns8:NameAddress>';
        $request .= '<DateRange>';
        $request .= '<DateFrom>'.date("Y-m-d",strtotime($data['pickup_datetime'])).'</DateFrom>';
        $request .= '<DateTo>'.date("Y-m-d",strtotime($data['pickup_endtime'])).'</DateTo>';
        $request .= '<TimeFrom>'.date("HH:i:s",strtotime($data['pickup_datetime'])).$data['hrs'].'</TimeFrom>';
        $request .= '<TimeTo>'.date("HH:i:s",strtotime($data['pickup_endtime'])).$data['hrs'].'</TimeTo>';
        $request .= '</DateRange>';
        $request .= '<AdditionalTextInformation />';
        $request .= '<Sequence>1</Sequence>';
        $request .= '</TruckingWayPoint>';
        $request .= '<TruckingWayPoint ns20:WayPointType="DEL">';
        $request .= '<ns8:NameAddress ns2:AddressType="DP">';
        $request .= '<Name>'.$data['delivery_company'].'</Name>';
        $request .= '<Street>' . substr($data['delivery_address1'], 0, 34) . '</Street>';
        $request .= '<City>'.$data['delivery_city'].'</City>';
        $request .= '<CountryCode>'.$data['delivery_country'].'</CountryCode>';
        $request .= '<ZipCode>'.$data['delivery_pincode'].'</ZipCode>';
        $request .= '<CustomerIdentifier>1002971306</CustomerIdentifier>';
        $request .= '<PartyIdentifier>ELMAITSOM001</PartyIdentifier>';
        $request .= '</ns8:NameAddress>';
        $request .= '<DateRange>';
        $request .= '<DateFrom>'.date("Y-m-d",strtotime($data['delivery_datetime'])).'</DateFrom>';
        $request .= '<DateTo>'.date("Y-m-d",strtotime($data['delivery_endtime'])).'</DateTo>';
        $request .= '<TimeFrom>'.date("HH:i:s",strtotime($data['delivery_datetime'])).$data['hrs'].'</TimeFrom>';
        $request .= '<TimeTo>'.date("HH:i:s",strtotime($data['delivery_endtime'])).$data['hrs'].'</TimeTo>';
        $request .= '</DateRange>';
        $request .= '<Sequence>2</Sequence>';
        $request .= '</TruckingWayPoint>';
        $request .= '<ns23:ReportingInformationRailroad>';
        $request .= '<ModeOfCreation>0</ModeOfCreation>';
        $request .= '<TypeOfBusiness>DOMESTIC</TypeOfBusiness>';
        $request .= '</ns23:ReportingInformationRailroad>';
        $request .= '</ShipmentRoad>';
        $request .= '</Shipment>';
        $request .= '</Message>';
        $request .= '</ns20:RoadShipment>';
        //log_message('error', "request to knlogin status " . $request);
        /*$resname=date("Ymdhis");
        $dom = new DOMDocument;
        $dom->preserveWhiteSpace = FALSE;
        $dom->loadXML($request);
        $dom->save('xml/shipment/request'.$resname.'.xml');
        $serviceurl = ROADLOG_SHIPMENT_ETRA_URL;
        $headers = array('Content-Type: application/xml');
        $response = otmbookservicecurl($serviceurl,$headers,$request);
        log_message('error', "responsejson " . json_encode($response));
        $this->session->set_flashdata('success_msg', 'Shippment XML Generated Successfully...');*/
    }

    public function sendKNloginOrderxmlservice($data){
        //log_message("error","Data:".json_encode($data));
        $originBranch = strlen($data['branch_code']) > 5 ? substr($data['branch_code'], 0, 5) : $data['branch_code'];
        $timeZoneHrs = str_replace('.', ':', $data['hrs']);
        $carrierParty = $data['carrierDetails'] ?? [];
        $finalCountries = $data['finalCountries'] ?? [];
        $request = '';
        $request .= '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><ns21:RoadShipment xmlns:ns2="http://knie4.int.kn/com/ltypes/0200" xmlns:ns4="http://knie4.int.kn/com/ltru/0200" xmlns:ns3="http://knie4.int.kn/com/lhdr/0200" xmlns:ns6="http://knie4.int.kn/com/lsts/0200" xmlns:ns20="http://knie4.int.kn/com/lcnt/0100" xmlns:ns5="http://knie4.int.kn/com/lmlv/0200" xmlns:ns8="http://knie4.int.kn/com/ladr/0200" xmlns:ns7="http://knie4.int.kn/com/lshpd/0200" xmlns:ns13="http://knie4.int.kn/com/lcus/0100" xmlns:ns24="http://knie4.int.kn/com/lriroa/0200" xmlns:ns9="http://knie4.int.kn/com/lcgod/0200" xmlns:ns12="http://knie4.int.kn/com/lpaci/0200" xmlns:ns23="http://knie4.int.kn/com/lsdi/0100" xmlns:ns11="http://knie4.int.kn/com/ldim/0200" xmlns:ns22="http://knie4.int.kn/com/laia/0100" xmlns:ns10="http://knie4.int.kn/com/ldgs/0200" xmlns:ns21="http://knie4.int.kn/msg/roadshipment/0100" xmlns:ns17="http://knie4.int.kn/com/lonc/0100" xmlns:ns16="http://knie4.int.kn/com/lrour/0100" xmlns:ns15="http://knie4.int.kn/com/lprc/0100" xmlns:ns14="http://knie4.int.kn/com/lrdtl/0200" xmlns:ns19="http://knie4.int.kn/com/ltxtk/0100" xmlns:ns18="http://knie4.int.kn/com/ltxt/0200">';
        $request .= '<ns3:MessageHeader>';
        $request .= '<ReceiverDetails ns2:AddressType="FW">';
        $request .= '<PhysicalReceiver>'.$data['physicalreceiver'].'</PhysicalReceiver>';
        $request .= '<LogicalReceiver>'.$data['logicalreceiver'].'</LogicalReceiver>';
        $request .= '</ReceiverDetails>';
        $request .= '<PhysicalSender>'.$data['physicalsender'].'</PhysicalSender>';
        $request .= '<LogicalSender>'.$data['logicalsender'].'</LogicalSender>';
        $request .= '<SendingApplication>ROADLOG</SendingApplication>';
        $request .= '<MessageType>RoadShipment</MessageType>';
        $request .= '<VersionNumber>0100</VersionNumber>';
        $request .= '<CreationDateTime>'.date("Y-m-d",strtotime($data['createdon'])).'T'.date("H:i:s",strtotime($data['createdon'])).'Z</CreationDateTime>';
        $request .= '<FunctionCode>UP</FunctionCode>';
        $request .= '</ns3:MessageHeader>';
        $request .= '<Message>';
        $request .= '<ns4:TruckAndTrailer>';
        $request .= '<Trailer></Trailer>';
        $request .= '<VoyageNumber></VoyageNumber>';
        $request .= '<TourNumber></TourNumber>';
        $request .= '<Origin>';
        $request .= '<Location ns2:LocationIssuer="6">'.$originBranch.'</Location>';
        $request .= '<Location ns2:LocationIssuer="ZZZ">'.$data['country_name'].'</Location>';
        $request .= '<Date>'.date("Y-m-d",strtotime($data['createdon'])).'</Date>';
        $request .= '</Origin>';
        $request .= '<NumberOfShipments>1</NumberOfShipments>';
        if (!empty($carrierParty)) {
            $carrierCountry = $finalCountries[$carrierParty['country']] ?? $carrierParty['country'];
            $carrierParty['name'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $carrierParty['name']);
            $carrierParty['street'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $carrierParty['street']);
            $carrierParty['city'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $carrierParty['city']);
            $carrierParty['country'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $carrierParty['country']);
            $request .= '<Address ns2:AddressType="CA">';
            $request .= '<Name>'.$carrierParty['name'].'</Name>';
            $request .= '<Street>' . substr($carrierParty['street'], 0, 34) . '</Street>';
            $request .= '<Street>' . substr($carrierParty['street'], 0, 34) . '</Street>';
            $request .= '<City>'.$carrierParty['city'].'</City>';
            $request .= '<CountryCode>'.$carrierCountry.'</CountryCode>';
            $request .= '<ZipCode>'.$carrierParty['pincode'].'</ZipCode>';
            $request .= '<CustomerIdentifier>'.$carrierParty['cust_id'].'</CustomerIdentifier>';
            $request .= '<PartyIdentifier>'.$carrierParty['party_id'].'</PartyIdentifier>';
            $request .= '<ContactDetails>';
            $request .= '<LastName>'.$carrierParty['name'].'</LastName>';
            $request .= '<FirstName>'.$carrierParty['name'].'</FirstName>';
            $request .= ' <ContactType>SUPPLIER</ContactType>';
            $request .= ' <Communication ns2:CommunicationType="EM">'.$carrierParty['email'].'</Communication>';
            $request .= '</ContactDetails>';
            $request .= '</Address>';
        }
        $tracknum = $data['SenderTransmissionNo'];
        $str = substr($data['SenderTransmissionNo'], 0, 2);
        if(!is_numeric($str)){
            $tracknum = substr($data['SenderTransmissionNo'], 2);
            $tracknum = $data['country_code'].$tracknum;
        }
        $request .= '<Text ns2:TextType="HAN"></Text>';
        $request .= '<TripType>'.$data['vehicle_type'].'</TripType>';
        $request .= '<LoadingCapacity>0.1</LoadingCapacity>';
        $request .= '</ns4:TruckAndTrailer>';
        $request .= '<Shipment>';
        $request .= '<ns5:MessageLevel>';
        $request .= '<TrackingNumber ns2:Counter="1">'.$tracknum.'</TrackingNumber>';
        $request .= '<SenderInformation>';
        $request .= '<CompanyCode>'.$data['company_code'].'</CompanyCode>';
        $request .= '<BranchCode>'.$data['branch_code'].'</BranchCode>';
        $request .= '<ModeOfTransport>1</ModeOfTransport>';
        $request .= '<ExportImportFlag>1</ExportImportFlag>';
        $request .= '</SenderInformation>';
        $request .= '<MessageReferences ns2:AddressType="FF">';
        $request .= '<Code>INN</Code>';
        $request .= '<Value>RL'.$tracknum.'</Value>';
        $request .= '</MessageReferences>';
        $request .= '</ns5:MessageLevel>';
        $request .= '<ShipmentInformation>';
        $request .= '<ns7:ShipmentDetails>';
        $request .= '<TotalPackages>'.round($data['quantity']).'</TotalPackages>';
        $request .= '<Measurements ns2:MeasurementType="AAD">';
        $request .= '<Value>'.$data['weight'].'</Value>';
        $request .= '<UnitOfMeasurementCode>KGM</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<Measurements ns2:MeasurementType="ABJ">';
        $request .= '<Value>'.$data['total_volume'].'</Value>';
        $request .= '<UnitOfMeasurementCode>MTQ</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<Measurements ns2:MeasurementType="ACV">';
        $request .= '<Value>0</Value>';
        $request .= '<UnitOfMeasurementCode>MTR</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<Measurements ns2:MeasurementType="ACG">';
        $request .= '<Value>'.$data['weight'].'</Value>';
        $request .= '<UnitOfMeasurementCode>KGM</UnitOfMeasurementCode>';
        $request .= '</Measurements>';
        $request .= '<DangerousGoodsFlag>N</DangerousGoodsFlag>';
        $request .= '<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>';
        $request .= '<TermsOfTrade>';
        $request .= '<Incoterm>'.$data['incoterm'].'</Incoterm>';
        $request .= '</TermsOfTrade>';
        $request .= '<Origin>';
        $data['pickup_city'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['pickup_city']);
        $request .= '<OriginLocation ns2:LocationIssuer="ZZZ">'.$data['pickup_city'].'</OriginLocation>';
        if (isset($data['pickup_datetime']) && $data['pickup_datetime'] !== '' && $data['pickup_datetime'] !== '0000-00-00 00:00:00') {
            $request .= '<Date>'.date("Y-m-d",strtotime($data['pickup_datetime'])).'</Date>';
        }
        else{
            $request .= '<Date></Date>';
        }
        $request .= '</Origin>';
        $request .= '<Destination>';
        $data['delivery_city'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['delivery_city']);
        $request .= '<DestinationLocation ns2:LocationIssuer="ZZZ">'.$data['delivery_city'].'</DestinationLocation>';
        if (isset($data['delivery_datetime']) && $data['delivery_datetime'] !== '' && $data['delivery_datetime'] !== '0000-00-00 00:00:00') {
            $request .= '<Date>'.date("Y-m-d",strtotime($data['delivery_datetime'])).'</Date>';
        }
        else{
            $request .= '<Date></Date>';
        }
        $request .= '</Destination>';
        $request .= '<Location ns2:LocationType="27" ns2:LocationIssuer="6">'.$data['cntrycode'].'</Location>';
        $request .= '<Location ns2:LocationType="28" ns2:LocationIssuer="6">'.$data['cntrycode'].'</Location>';
        $request .= '<BusinessSolution>';
        $request .= '<Code>XL</Code>';
        $request .= '<CategoryCode>X</CategoryCode>';
        $request .= '</BusinessSolution>';
        $request .= '</ns7:ShipmentDetails>';
        foreach($data['parties'] as $res1){
            $res1['cust_id'] = preg_replace("/[^0-9]/", "", $res1['cust_id']);
            $res1['party_id'] = preg_replace("/[^0-9]/", "", $res1['party_id']);
            $res1['street']=preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $res1['street']);
            $res1['name'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $res1['name']);
            $res1['city'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $res1['city']);
            $res1['country'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $res1['country']);
            $country = $finalCountries[$res1['country']] ?? $res1['country'];
            if($res1['type'] == "Shipper"){
                $request .= '<ns8:NameAddress ns2:AddressType="SH">';
                $request .= '<Name>'.$res1['name'].'</Name>';
                $request .= '<Street>' . substr($res1['street'], 0, 34) . '</Street>';
                $request .= '<Street>' . substr($res1['street'], 0, 34) . '</Street>';
                $request .= '<City>'.$res1['city'].'</City>';
                $request .= '<CountryCode>'.$country.'</CountryCode>';
                $request .= '<ZipCode>'.$res1['pincode'].'</ZipCode>';
                $request .= '<CustomerIdentifier>'.$res1['cust_id'].'</CustomerIdentifier>';
                $request .= '<PartyIdentifier>'.$res1['party_id'].'</PartyIdentifier>';
                foreach($data['shipperReferences'] as $eachReference){
                    if (!in_array($eachReference['id'], self::CONTACT_REFERENCE_IDS)) {
                        if ($eachReference['id'] == "XBRDR") {
                            $eachReference['id'] = "XBR";
                        }
                        if ($eachReference['id'] == "MVTY") {
                            $eachReference['id'] = "DT";
                        }
                        if (strlen($eachReference['id']) < 4) {
                            $referenceValue = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $eachReference['value']);
                            $request .= '<References>';
                            $request .= '<Code>' . $eachReference['id'] . '</Code>';
                            $request .= '<Value>' . $referenceValue . '</Value>';
                            $request .= '</References>';
                        } else {
                            log_message("error", "sendKNloginOrderxmlservice Order Reference ID Length Exceeds more then 3 " . json_encode($eachReference));
                        }
                    }
                }
                $request .= '</ns8:NameAddress>';
            }
            if($res1['type'] == "Consignee"){
                $request .= '<ns8:NameAddress ns2:AddressType="CN">';
                $request .= '<Name>'.$res1['name'].'</Name>';
                $request .= '<Street>' . substr($res1['street'], 0, 34) . '</Street>';
                $request .= '<City>'.$res1['city'].'</City>';
                $request .= '<CountryCode>'.$country.'</CountryCode>';
                $request .= '<ZipCode>'.$res1['pincode'].'</ZipCode>';
                $request .= '<CustomerIdentifier>'.$res1['cust_id'].'</CustomerIdentifier>';
                $request .= '<PartyIdentifier>'.$res1['party_id'].'</PartyIdentifier>';
                $request .= '</ns8:NameAddress>';
            }
            if($res1['type'] == "PF"){
                $request .= '<ns8:NameAddress ns2:AddressType="PF">';
                $request .= '<Name>'.$res1['name'].'</Name>';
                $request .= '<Street>' . substr($res1['street'], 0, 34) . '</Street>';
                $request .= '<City>'.$res1['city'].'</City>';
                $request .= '<CountryCode>'.$country.'</CountryCode>';
                $request .= '<ZipCode>'.$res1['pincode'].'</ZipCode>';
                $request .= '<CustomerIdentifier>'.$res1['cust_id'].'</CustomerIdentifier>';
                $request .= '<PartyIdentifier>'.$res1['party_id'].'</PartyIdentifier>';
                if(count($data['refs'])>0){
                    foreach($data['refs'] as $rs){
                        if (!in_array($rs['id'], self::CONTACT_REFERENCE_IDS)) {
                            if ($rs['id'] == "MVTY") {
                                $rs['id'] = "DT";
                            }
                            if (strlen($rs['id']) < 4) {
                                $referenceValue = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $rs['value']);
                                $request .= '<References>';
                                $request .= '<Code>' . $rs['id'] . '</Code>';
                                $request .= '<Value>' . $referenceValue . '</Value>';
                                $request .= '</References>';
                            } else {
                                log_message("error", "sendKNloginOrderxmlservice Order Reference ID Length Exceeds more then 3 " . json_encode($rs));
                            }
                        }
                    }
                }
                $request .= '</ns8:NameAddress>';
            }
        }
        $i = 1;
        foreach ($data['cargos'] as $info) {
            $qrtyval = number_format($info['quantity']);
            $qrtyval = str_replace(",", "", $qrtyval);
            $crcontent = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $info['content']);
            $packageType = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $info['cargo_type']);
            $packageCodes = $data['packageCodes'];
            $cargoContent = $packageCodes[strtoupper($packageType)] ?? "";
            $cargoContent = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $cargoContent);
            $request .= '<CargoDescription>';
            $request .= '<ns9:CargoDescriptionDetails>';
            $request .= '<CargoItem>'.$i.'</CargoItem>';
            $request .= '<NumberOfPackages>';
            $request .= '<Value>' . $qrtyval . '</Value>';
            $request .= '<QuantityType>'.$cargoContent.'</QuantityType>';
            $request .= '</NumberOfPackages>';
            $request .= '<GrossWeight>';
            $request .= '<Value>' . $info['weight'] . '</Value>';
            $request .= '<UnitOfMeasurementCode>KGM</UnitOfMeasurementCode>';
            $request .= '</GrossWeight>';
            $request .= '<Volume>';
            $request .= '<Value>' . $info['volume'] . '</Value>';
            $request .= '<UnitOfMeasurementCode>MTQ</UnitOfMeasurementCode>';
            $request .= '</Volume>';
            $request .= '<MarksAndNumbers ns2:SequenceNumber="'.$i.'"></MarksAndNumbers>';
            $request .= '<CargoContent ns2:SequenceNumber="'.$i.'">' . $crcontent . '</CargoContent>';
            $request .= '<RoadInformation>';
            $request .= '<StackableFlag>N</StackableFlag>';
            $request .= '</RoadInformation>';
            $request .= '</ns9:CargoDescriptionDetails>';
            $dweight = number_format($data['quantity']);
            $dweight = str_replace(",", "", $dweight);
            $request .= '<ns11:Dimensions>';
            $request .= '<NumberOfPackages>';
            $request .= '<Value>' . $qrtyval . '</Value>';
            $request .= '<QuantityType>'.$cargoContent.'</QuantityType>';
            $request .= '</NumberOfPackages>';
            $request .= '<Measurements ns2:MeasurementType="LN">';
            $request .= '<Value>'.$info['length'].'</Value>';
            $request .= '<UnitOfMeasurementCode>CM</UnitOfMeasurementCode>';
            $request .= '</Measurements>';
            $request .= '<Measurements ns2:MeasurementType="WD">';
            $request .= '<Value>'.$info['width'].'</Value>';
            $request .= '<UnitOfMeasurementCode>CM</UnitOfMeasurementCode>';
            $request .= '</Measurements>';
            $request .= '<Measurements ns2:MeasurementType="HT">';
            $request .= '<Value>'.$info['height'].'</Value>';
            $request .= '<UnitOfMeasurementCode>CM</UnitOfMeasurementCode>';
            $request .= '</Measurements>';
            $request .= '</ns11:Dimensions>';
            $request .= '</CargoDescription>';
            $i++;
        }
        $request .= '</ShipmentInformation>';
        $request .= '<ShipmentRoad>';
        $request .= '<ns14:RoadDetails>';
        $request .= '<FreightName>';
        $request .= '<Term>'.$data['freight_term'].'</Term>';
        $request .= '<Name>'.$data['freight_termname'].'</Name>';
        $request .= '</FreightName>';
        $request .= '<Product>'.$data['product'].'</Product>';
        $request .= '<ServiceType>'.$data['service_type'].'</ServiceType>';
        $request .= '<AppointmentRequired>N</AppointmentRequired>';
        $request .= '<DeliverComplete>N</DeliverComplete>';
        $request .= '<OriginalDocumentsRequired>N</OriginalDocumentsRequired>';
        $request .= '<Tail-LiftRequired>N</Tail-LiftRequired>';
        $request .= '<EKAERRequired>N</EKAERRequired>';
        $request .= '<CustomsRequired>N</CustomsRequired>';
        $request .= '<HighValue>N</HighValue>';
        $request .= '<TimeWindow>N</TimeWindow>';
        $request .= '<OversizedGoods>N</OversizedGoods>';
        $request .= '<PrivateConsignee>N</PrivateConsignee>';
        $request .= '</ns14:RoadDetails>';
        $request .= '<TruckingWayPoint ns20:WayPointType="PUP">';
        $request .= '<ns8:NameAddress ns2:AddressType="PU">';
        $data['pickup_company'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['pickup_company']);
        $request .= '<Name>'.$data['pickup_company'].'</Name>';
        $data['pickup_address1'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['pickup_address1']);
        $request .= '<Street>' . substr($data['pickup_address1'], 0, 34) . '</Street>';
        /*$request .= '<Street>'.$data['pickup_address2'].'</Street>';*/
        $request .= '<City>'.$data['pickup_city'].'</City>';
        $data['pickup_country'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['pickup_country']);
        $request .= '<CountryCode>'.$data['pickup_country'].'</CountryCode>';
        $request .= '<ZipCode>'.$data['pickup_pincode'].'</ZipCode>';
        $request .= '</ns8:NameAddress>';
        if (isset($data['pickup_datetime']) && $data['pickup_datetime'] !== '' && $data['pickup_datetime'] !== '0000-00-00 00:00:00') {
            $request .= '<DateRange>';
            $request .= '<DateFrom>'.date("Y-m-d",strtotime($data['pickup_datetime'])).'</DateFrom>';
            $request .= '<DateTo>'.date("Y-m-d",strtotime($data['pickup_endtime'])).'</DateTo>';
            $request .= '<TimeFrom>'.date("H:i:s",strtotime($data['pickup_datetime'])).$timeZoneHrs.'</TimeFrom>';
            $request .= '<TimeTo>'.date("H:i:s",strtotime($data['pickup_endtime'])).$timeZoneHrs.'</TimeTo>';
            $request .= '</DateRange>';
        }
        else{
            $request .= '<DateRange>';
            $request .= '<DateFrom></DateFrom>';
            $request .= '<DateTo></DateTo>';
            $request .= '<TimeFrom></TimeFrom>';
            $request .= '<TimeTo></TimeTo>';
            $request .= '</DateRange>';
        }
        $request .= '<Sequence>1</Sequence>';
        $request .= '</TruckingWayPoint>';
        $request .= '<TruckingWayPoint ns20:WayPointType="DEL">';
        $request .= '<ns8:NameAddress ns2:AddressType="DP">';
        $data['delivery_company'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['delivery_company']);
        $request .= '<Name>'.$data['delivery_company'].'</Name>';
        $data['delivery_address1'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['delivery_address1']);
        $request .= '<Street>' . substr($data['delivery_address1'], 0, 34) . '</Street>';
        $request .= '<City>'.$data['delivery_city'].'</City>';
        $data['delivery_country'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $data['delivery_country']);
        $request .= '<CountryCode>'.$data['delivery_country'].'</CountryCode>';
        $request .= '<ZipCode>'.$data['delivery_pincode'].'</ZipCode>';
        $request .= '</ns8:NameAddress>';
        //("error","delivery_datetime:".$data['delivery_datetime']);
        if (isset($data['delivery_datetime']) && $data['delivery_datetime'] !== '' && $data['delivery_datetime'] !== '0000-00-00 00:00:00') {
            $request .= '<DateRange>';
            $request .= '<DateFrom>'.date("Y-m-d",strtotime($data['delivery_datetime'])).'</DateFrom>';
            $request .= '<DateTo>'.date("Y-m-d",strtotime($data['delivery_endtime'])).'</DateTo>';
            $request .= '<TimeFrom>'.date("H:i:s",strtotime($data['delivery_datetime'])).$timeZoneHrs.'</TimeFrom>';
            $request .= '<TimeTo>'.date("H:i:s",strtotime($data['delivery_endtime'])).$timeZoneHrs.'</TimeTo>';
            $request .= '</DateRange>';
        }
        else{
            $request .= '<DateRange>';
            $request .= '<DateFrom></DateFrom>';
            $request .= '<DateTo></DateTo>';
            $request .= '<TimeFrom></TimeFrom>';
            $request .= '<TimeTo></TimeTo>';
            $request .= '</DateRange>';
        }
        $request .= '<Sequence>2</Sequence>';
        $request .= '</TruckingWayPoint>';
        $request .= '<ns24:ReportingInformationRailroad>';
        $request .= '<ModeOfCreation>0</ModeOfCreation>';
        $request .= '<TypeOfBusiness>DOMESTIC</TypeOfBusiness>';
        $request .= '</ns24:ReportingInformationRailroad>';
        $request .= '</ShipmentRoad>';
        $request .= '</Shipment>';
        $request .= '</Message>';
        $request .= '</ns21:RoadShipment>';
        log_message("error","Request:".$request);
        $serviceurl = ROADLOG_SHIPMENT_ETRA_URL;
        $username = BOOKING_ETRA_USRNAME;
        $password = BOOKING_ETRA_PWD;
        $headers = array(
            'Content-Type: application/xml',
            'Authorization: Basic '. base64_encode("$username:$password"),
            'PHYSICALRECEIVER: '.$data['physicalreceiver'],
            'LOGICALRECEIVER: '.$data['logicalreceiver']
        );
        $output = process_posthttprequest($serviceurl,$headers,$request);
        return $output;
    }

    public function sendStatusToKNLoginWhileDeletingOrder(array $ordersInfo, array $additionalInfo): void
    {
        $ci = &get_instance();
        $timeZone = $additionalInfo['timeZone'];
        $countryHours = $additionalInfo['countryHours'];
        $hours = str_replace(".", ":", $countryHours);
        $currentDateTime = $additionalInfo['currentDate'];
        $currentDate = date('Y-m-d',strtotime($currentDateTime));
        $currentTime = date('H:i:s',strtotime($currentDateTime)) . "" . $hours;
        $userDateTime = date('Y-m-d\TH:i:s', strtotime($currentDateTime));
        $UserDateWithHours = date('Y-m-d\TH:i:s', strtotime($currentDateTime)) . "" . $hours;
        $logicalReceiver = "WWWWW99";
        $PhysicalReceiver = 'WWDPT01';
        $PhysicalSender = 'KNRLG09';
        if (SYS_TYPE == 'TMS') {
            $PhysicalReceiver = 'WWDPP01';
            $PhysicalSender = 'KNRLG01';
        }
        $companyCode = $additionalInfo['sessionCompanyCode'];
        $branchCode = $additionalInfo['sessionBranchCode'];
        $ci->load->model('common');
        $logicalinfo = $ci->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode], "logical_sender", "tb_branch_master", 0, 0);
        $logicalSender = $logicalinfo['logical_sender'] ?: "THPNA74";
        $getDepartmentCode = $ci->common->gettblrowdata(['order_row_id' => $ordersInfo['id']], "department_code", "tb_order_details", 0, 0);
        $departmentCode = $getDepartmentCode['department_code'] ?: "ETRA";
        $postdata = [
            "shipment_id" => $ordersInfo['shipmentid'],
            "status_code" => '9800',
            "company_code" => $companyCode,
            "branch_code" => $branchCode,
            "pickup_city" => $ordersInfo['pickup_city'],
            "logicalreceiver" => $logicalReceiver,
            "physicalreceiver" => $PhysicalReceiver,
            "physicalsender" => $PhysicalSender,
            "logicalsender" => $logicalSender,
            "modeoftransport" => $ordersInfo['modeoftransport'],
            "department_code" => $departmentCode,
            "trackingnumber" => $ordersInfo['order_id'],
            "ref_id" => 'INN',
            "ref_num" => 'RL' . $ordersInfo['order_id'],
            "createdon" => $currentDateTime,
            "date" => $currentDate,
            "time" => $currentTime,
            'curdt' => $UserDateWithHours,
            'curdt1' => $userDateTime
        ];
        $sendKnloginStatus = $this->knloginsendorderstatus($postdata);
    }
}
