<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Knopsmassstatuslibrary
{

    public function __construct()
    {
        $ci =& get_instance();
        $ci->load->model(['trips_model', 'knopstripsmodel']);
    }

    public function getNormalTripsForKnOps(array $post, array $userData)
    {
        $ci =& get_instance();
        $searchWhereCondition = " s.status ='1'";
        $item = "";
        if (isset($post['searchsubmit']) || isset($post['order_id'])) {
            if (isset($post['searchsubmit'])) {
                $item = trim($post['searchsubmit']);
            } else {
                $item = 1;
            }
        }
        if ($item != "") {
            if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                $searchWhereCondition .= "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
            }
            if (isset($post['trip_id']) && $post['trip_id'] != "") {
                $post_trip_id = $post['trip_id'];
                $searchWhereCondition .= "AND s.shipmentid LIKE '%" . $post_trip_id . "%' ";
            }
            if (isset($post['container_no']) && $post['container_no'] != "") {
                $post_container_no = $post['container_no'];
                $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value LIKE '%" . $post_container_no . "%'";
                $ref11 = $ci->db->query($sql);
                if ($ref11->num_rows() > 0) {
                    foreach ($ref11->result() as $gh) {
                        $oid11[] = $gh->order_id;
                    }
                    $kk = implode(",", $oid11);
                    $searchWhereCondition .= "AND o.id IN ($kk) ";
                }
            }
            if (isset($post['driver']) && $post['driver'] != "") {
                $post_driver = addslashes($post['driver']);
                $searchWhereCondition .= " AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
            }
        } elseif (isset($post['searchsubmita']) && $post['searchsubmita'] == "Search") {
            if (isset($post['vehicle']) && $post['vehicle'] != "") {
                $post_vehicle = addslashes($post['vehicle']);
                $searchWhereCondition .= "AND v.register_number LIKE '%" . $post_vehicle . "%' ";
            }
            if (isset($post['ref_id']) && $post['ref_id'] != "") {
                $post_ref_id = addslashes($post['ref_id']);
                $ref = $ci->db->query("SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value LIKE '%" . $post_ref_id . "%' LIMIT 1");
                if ($ref->num_rows() > 0) {
                    $oid = $ref->row()->order_id;
                    $searchWhereCondition .= "AND o.id LIKE '%" . $oid . "%' ";
                }
            }
        } else {
            if (!empty($post)) {
                if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                    $searchWhereCondition .= "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
                }
                if (isset($post['trip_id']) && $post['trip_id'] != "") {
                    $post_trip_id = $post['trip_id'];
                    $searchWhereCondition .= "AND s.shipmentid LIKE '%" . $post_trip_id . "%' ";
                }
                if (isset($post['container_no']) && $post['container_no'] != "") {
                    $post_container_no = $post['container_no'];
                    $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_container_no . "%'";
                    $ref11 = $ci->db->query($sql);
                    if ($ref11->num_rows() > 0) {
                        foreach ($ref11->result() as $gh) {
                            $oid11[] = $gh->order_id;
                        }
                        $kk = implode(",", $oid11);
                        $searchWhereCondition .= " AND o.id IN ($kk) ";
                    }
                }
                if (isset($post['driver']) && $post['driver'] != "") {
                    $post_driver = addslashes($post['driver']);
                    $searchWhereCondition .= "AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
                }
            }
        }
        $allTripsData = $ci->knopstripsmodel->getAllKnopsBasedOrderIds($userData);
        $orderIds = $allTripsData['orderIds'];
        $shiftIds = $allTripsData['allshiftIds'];
        $ordersData = $allTripsData['ordersData'];
        if (empty($shiftIds)) {
            return [];
        }
        $finalTripsData = $ci->knopstripsmodel->getVehicleAndDriversForTrips($shiftIds, $searchWhereCondition);
        return ['finalTripsData' => $finalTripsData, 'ordersData' => $ordersData, 'orderIds' => $orderIds];
    }

    public function giveReferenceParameters(string $referenceParam): array
    {
        $finalArray = [];
        if (!empty($referenceParam) && $referenceParam != '') {
            $requiredArray = explode('=====', $referenceParam);
            if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
                $finalArray['value'] = trim($requiredArray[1]);
            }
        }
        return $finalArray;
    }

    public function getStopsStatusAndArrangeFinalArray(array $data)
    {
        $ci =& get_instance();
        $shiftIds = $data['shiftIds'];
        $orderIds = $data['orderIds'];
        $orderRowIds = [];
        foreach ($orderIds as $key => $value) {
            $orderRowIds[] = $key;
        }
        $companyCode = $ci->session->userdata("company_code");
        if (!empty($orderRowIds)) {
            if (in_array($companyCode, ['UKKN', 'AUKN'])) {
                $codes = ['CTR'];
            } else {
                $codes = ['DQ', 'AAM', 'AWB', 'XSR', 'SD', 'INN', 'CTR'];
            }
            $references = $ci->trips_model->getReferencesForOrders($orderRowIds, $codes);
            foreach ($references as $eachLine) {
                $value = "";
                $orderId = $eachLine['order_id'];
                $referenceData = $eachLine['referenceValue'];
                $referenceDataArray = explode('?????', $referenceData);
                if (!empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
                    foreach ($referenceDataArray as $eachRefData) {
                        $reqArray = $this->giveReferenceParameters($eachRefData);
                        $value .= $reqArray['value'] . " , ";
                        $orderReferences[$orderId] = $value;
                    }
                }
            }
            if (!empty($shiftIds)) {
                $stopStatus = $this->getAllStopStatusDetails($shiftIds);
                $tripsdata = $this->arrangeAllOrdersAndShiftDataIntoSingleArray($stopStatus, $orderReferences ?? [], $data['tripDetails'], $data['ordersData'], $orderIds);
            }
        }
        return $tripsdata ?? [];
    }

    private function arrangeAllOrdersAndShiftDataIntoSingleArray(array $stopStatus, array $orderReferences, array $tripDetails, array $ordersData, array $orderIds): array
    {
        $saccept = "10";
        $sgatein = $dgatein = "2";
        $spickup = $dpickup = "1";
        $sgateout = $dgateout = "3";
        $intransit = "4";
        $sclose = "11";
        if (!empty($stopStatus)) {
            $dropStops = $stopStatus['dropStops'];
            $pickupStops = $stopStatus['pickupStops'];
            $shiftStops = $stopStatus['shiftStops'];
            foreach ($orderIds as $key => $value) {
                $s_saccept = $s_sgatein = $s_spickup = $s_sgateout = $s_intransit = $s_dgatein = $s_dpickup = $s_dgateout = $pstpid = $dstpid = $pstodetailid = $dstodetailid = 0;
                $s_sacceptcr = $s_sgateincr = $s_spickupcr = $s_sgateoutcr = $s_intransitcr = $s_dgateincr = $s_dpickupcr = $s_dgateoutcr = "";
                $orderId = $key;
                $shipmentId = $ordersData[$key]['shipmentId'] ?? "";
                $tripId = $ordersData[$key]['tripId'] ?? "";
                $bookingId = $ordersData[$key]['bookingId'] ?? "";
                $vehicleId = $tripDetails[$value]['vehicleId'] ?? "";
                $driverId = $tripDetails[$value]['driverId'] ?? "";
                $trackType = $tripDetails[$value]['trackType'] ?? "";
                $trackVendor = $tripDetails[$value]['trackVendor'] ?? "";
                $simCarrier = $tripDetails[$value]['simCarrier'] ?? "";
                $contactNumber = $tripDetails[$value]['contactNumber'] ?? "";
                $orderRowId = $ordersData[$key]['rowId'] ?? "";
                $refers = $orderReferences[$key] ?? [];
                /*  $fromCity = $shiftData[$employeeId]['fromPlace'] ?? "";
                   $toCity = $shiftData[$employeeId]['toPlace'] ?? "";
                   $startDate = $shiftData[$employeeId]['startDate'] ?? "";
                   $endDate = $shiftData[$employeeId]['endDate'] ?? "";
                   $closedStatus = $shiftData[$employeeId]['closedStatus'] ?? 0;
                   $tripUpdatedon = $shiftData[$employeeId]['tripUpdatedOn'] ?? ""; */
                $chkAccept = $shiftStops[$value . "-" . $saccept . "-P"]['stopRowId'] ?? 0;
                if ($chkAccept > 0) {
                    $stopsKey = $value . "-" . $saccept . "-P";
                    $pstpid = $pickupStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $pstodetailid = $pickupStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    $saccept = $shiftStops[$stopsKey]['status_id'];
                    $s_saccept = 1;
                    $s_sacceptcr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                }
                $chksGateIn = $shiftStops[$value . "-" . $sgatein . "-" . $orderRowId . "-P"]['stopRowId'] ?? 0;
                if ($chksGateIn > 0) {
                    $stopsKey = $value . "-" . $sgatein . "-" . $orderRowId . "-P";
                    $statusOrderId = $shiftStops[$stopsKey]['order_id'];
                    $sgatein = $shiftStops[$stopsKey]['status_id'];
                    $pstpid = $pickupStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $pstodetailid = $pickupStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    if ($statusOrderId == $orderId) {
                        $s_sgatein = 1;
                        $s_sgateincr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                    }
                }
                $chksPickup = $shiftStops[$value . "-" . $spickup . "-" . $orderRowId . "-P"]['stopRowId'] ?? 0;
                if ($chksPickup > 0) {
                    $stopsKey = $value . "-" . $spickup . "-" . $orderRowId . "-P";
                    $statusOrderId = $shiftStops[$stopsKey]['order_id'];
                    $spickup = $shiftStops[$stopsKey]['status_id'];
                    $pstpid = $pickupStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $pstodetailid = $pickupStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    if ($statusOrderId == $orderId) {
                        $s_spickup = 1;
                        $s_spickupcr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                    }
                }
                $chksGateOut = $shiftStops[$value . "-" . $sgateout . "-" . $orderRowId . "-P"]['stopRowId'] ?? 0;
                if ($chksGateOut > 0) {
                    $stopsKey = $value . "-" . $sgateout . "-" . $orderRowId . "-P";
                    $statusOrderId = $shiftStops[$stopsKey]['order_id'];
                    $sgateout = $shiftStops[$stopsKey]['status_id'];
                    $pstpid = $pickupStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $pstodetailid = $pickupStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    if ($statusOrderId == $orderId) {
                        $s_sgateout = 1;
                        $s_sgateoutcr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                    }
                }
                $chkIntransit = $shiftStops[$value . "-" . $intransit . "-" . $orderRowId . "-P"]['stopRowId'] ?? 0;
                if ($chkIntransit > 0) {
                    $stopsKey = $value . "-" . $intransit . "-" . $orderRowId . "-P";
                    $statusOrderId = $shiftStops[$stopsKey]['order_id'];
                    $intransit = $shiftStops[$stopsKey]['status_id'];
                    $pstpid = $pickupStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $pstodetailid = $pickupStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    if ($statusOrderId == $orderId) {
                        $s_intransit = 1;
                        $s_intransitcr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                    }
                }
                $chkdgateIn = $shiftStops[$value . "-" . $dgatein . "-" . $orderRowId . "-D"]['stopRowId'] ?? 0;
                if ($chkdgateIn > 0) {
                    $stopsKey = $value . "-" . $dgatein . "-" . $orderRowId . "-D";
                    $statusOrderId = $shiftStops[$stopsKey]['order_id'];
                    $dgatein = $shiftStops[$stopsKey]['status_id'];
                    $dstpid = $dropStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $dstodetailid = $dropStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    if ($statusOrderId == $orderId) {
                        $s_dgatein = 1;
                        $s_dgateincr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                    }
                }
                $chkdpickup = $shiftStops[$value . "-" . $dpickup . "-" . $orderRowId . "-D"]['stopRowId'] ?? 0;
                if ($chkdpickup > 0) {
                    $stopsKey = $value . "-" . $dpickup . "-" . $orderRowId . "-D";
                    $statusOrderId = $shiftStops[$stopsKey]['order_id'];
                    $dpickup = $shiftStops[$stopsKey]['status_id'];
                    $dstpid = $dropStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $dstodetailid = $dropStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    if ($statusOrderId == $orderId) {
                        $s_dpickup = 1;
                        $s_dpickupcr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                    }
                }
                $chkdgateout = $shiftStops[$value . "-" . $dgateout . "-" . $orderRowId . "-D"]['stopRowId'] ?? 0;
                if ($chkdgateout > 0) {
                    $stopsKey = $value . "-" . $dgateout . "-" . $orderRowId . "-D";
                    $statusOrderId = $shiftStops[$stopsKey]['order_id'];
                    $dgateout = $shiftStops[$stopsKey]['status_id'];
                    $dstpid = $dropStops[$value]['stop_id'] ?? $shiftStops[$stopsKey]['stop_id'];
                    $dstodetailid = $dropStops[$value]['stop_detail_id'] ?? $shiftStops[$stopsKey]['stop_detail_id'];
                    if ($statusOrderId == $orderId) {
                        $s_dgateout = 1;
                        $s_dgateoutcr = date('d-m-Y H:i:s', strtotime($shiftStops[$stopsKey]['createdon']));
                    }
                }
                $tripsData[] = [
                    "trip_id" => $tripId,
                    "ship_id" => $value,
                    "ord_id" => $orderId,
                    "shipmentid" => $shipmentId,
                    "order_id" => $bookingId,
                    "refers" => $refers,
                    "saccept" => $saccept,
                    "sgatein" => $sgatein,
                    "spickup" => $spickup,
                    "sgateout" => $sgateout,
                    "intransit" => $intransit,
                    "dgatein" => $dgatein,
                    "dpickup" => $dpickup,
                    "dgateout" => $dgateout,
                    "s_saccept" => $s_saccept,
                    "s_sgatein" => $s_sgatein,
                    "s_spickup" => $s_spickup,
                    "s_sgateout" => $s_sgateout,
                    "s_intransit" => $s_intransit,
                    "s_dgatein" => $s_dgatein,
                    "s_dpickup" => $s_dpickup,
                    "s_dgateout" => $s_dgateout,
                    "s_sacceptcr" => $s_sacceptcr,
                    "s_sgateincr" => $s_sgateincr,
                    "s_spickupcr" => $s_spickupcr,
                    "s_sgateoutcr" => $s_sgateoutcr,
                    "s_intransitcr" => $s_intransitcr,
                    "s_dgateincr" => $s_dgateincr,
                    "s_dpickupcr" => $s_dpickupcr,
                    "s_dgateoutcr" => $s_dgateoutcr,
                    "sclose" => $sclose,
                    "pstpid" => $pstpid,
                    "dstpid" => $dstpid,
                    "pstodetailid" => $pstodetailid,
                    "dstodetailid" => $dstodetailid,
                    "vehicle_id" => $vehicleId,
                    "driver_id" => $driverId,
                    "tracktype" => $trackType,
                    "trackvendor" => $trackVendor,
                    "simcarrier" => $simCarrier,
                    "contact_num" => $contactNumber,
                    "multiship" => "0",
                    "crossBorderCheck" => '',
                    'fromCity' => '',
                    'toCity' => '',
                    'startDate' => '',
                    'endDate' => '',
                    'closedStatus' => '',
                    'tripUpdatedOn' => ''
                ];
            }
        }
        return $tripsData ?? [];
    }

    private function getAllStopStatusDetails(array $shiftIds): array
    {
        $ci =& get_instance();
        $currentTimeZone = $ci->session->userdata("usr_tzone")['timezone'];
        $getStopShiftIds = $shiftStops = $pickupStops = $dropStops = [];
        if (!empty($shiftIds)) {
            $ci->db->select(
                'id,order_id,shipment_id,stop_id,stop_detail_id,
                       stop_type, status_id, convertToClientTZ(createdon, "' . $currentTimeZone . '") as createdon'
            );
            $ci->db->from('tb_stop_status');
            $ci->db->where_in('status_id', [1, 2, 3, 4, 10, 11]);
            $ci->db->where_in('shipment_id', $shiftIds);
            $getStopStatus = $ci->db->get();
            if ($getStopStatus->num_rows() > 0) {
                foreach ($getStopStatus->result_array() as $eachLine) {
                    $stopId = $eachLine['stop_id'];
                    $stopDetailId = $eachLine['stop_detail_id'];
                    $stopType = strtoupper($eachLine['stop_type']);
                    if (in_array($eachLine['status_id'], ["10", "4"], true)) {
                        $stopType = "P";
                    }
                    if ($eachLine['status_id'] === '10') {
                        $key = $eachLine['shipment_id'] . "-" . $eachLine['status_id'] . "-" . $stopType;
                    } else {
                        $key = $eachLine['shipment_id'] . "-" . $eachLine['status_id'] . "-" . $eachLine['order_id'] . "-" . $stopType;
                    }
                    $shiftStops[$key] = ['stopRowId' => $eachLine['id'], 'order_id' => $eachLine['order_id'], 'shipment_id' => $eachLine['shipment_id'], 'stop_id' => $stopId, 'stop_detail_id' => $stopDetailId, 'stop_type' => $stopType, 'status_id' => $eachLine['status_id'], 'createdon' => $eachLine['createdon']];

                    if (in_array('0', [$stopId, $stopDetailId])) {
                        $getStopShiftIds[] = $eachLine['shipment_id'];
                    }
                }
            }
            if (!empty($getStopShiftIds)) {
                $chkq = $ci->db->query("SELECT s.id,e.id as stopdetailsid,s.shipment_id FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id IN ? AND s.status=? AND s.id=e.stop_id AND e.status=? AND e.shift_id IN ? LIMIT 1", [$getStopShiftIds, 1, 1, $getStopShiftIds]);
                if ($chkq->num_rows() > 0) {
                    foreach ($chkq->result_array() as $eachLine) {
                        $pickupStops[$eachLine['shipment_id']] = ['stop_id' => $eachLine['id'], 'stop_detail_id' => $eachLine['stopdetailsid']];
                    }
                }
                $chkq = $ci->db->query("SELECT s.id,e.id as stopdetailsid,s.shipment_id FROM tb_shiporder_stops s,tb_employee e WHERE s.shipment_id IN ? AND s.status=? AND s.id=e.drop_stopid AND e.status=? AND e.shift_id IN ? LIMIT 1", [$getStopShiftIds, 1, 1, $getStopShiftIds]);
                if ($chkq->num_rows() > 0) {
                    foreach ($chkq->result_array() as $eachLine) {
                        $dropStops[$eachLine['shipment_id']] = ['stop_id' => $eachLine['id'], 'stop_detail_id' => $eachLine['stopdetailsid']];
                    }
                }
            }
        }
        return ['dropStops' => $dropStops, 'pickupStops' => $pickupStops, 'shiftStops' => $shiftStops];
    }

}

?>
