<?php
use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;

class Linfoxshipmentedi {
    private $ci;
    //put your code here
    function __construct() {
        $this->ci = & get_instance();
        $this->ci->load->library("edi/EdiEngine");
        $this->ci->load->library("edi/EdiStatusProcess");
    }

    public function shipmentdata($shift_id) {

        $this->ci->load->library("edi/EdiEngine");
        if ($shift_id != "") {
            $getorderids = $this->ci->ediengine->getOrderIds($shift_id);
            $orders_size = count($getorderids);
            if ($orders_size == 0) {
                echo "No orders found.";
                exit();
            }

            for ($i = 0; $i < $orders_size; $i++) {
                $order_id = $getorderids[$i]['id'];
                $order_routing_details = $this->ci->ediengine->getOrderRoutingDetails($order_id);
                $getcargos = $this->ci->ediengine->getCargoDetailsSum($order_id);
                $pickup_details = $this->ci->ediengine->getOrderParites('Shipper',$order_id);
                $drop_details = $this->ci->ediengine->getOrderParites('Consignee',$order_id);
                $order_details = array(
                    "routing_details" => $order_routing_details,
                    "cargo_details" => $getcargos,
                    "pickup_details" => $pickup_details,
                    "drop_details" => $drop_details,
                );
                $this->sendjsonservice($order_details);
            }
        }
    }

    public function sendjsonservice($data) {
        $curtz = $this->ci->session->userdata("usr_tzone")['timezone'];
        $routing_details = $data['routing_details'];
        $cargo_details = $data['cargo_details'];
        $pickup_details = $data['pickup_details'];
        $drop_details = $data['drop_details'];
        //echo $data->cargos->weight;
        $hu = array(
            "IndRefNo" => "",
            "HUID" => "",
            "HUProduct" => "",
            "PCQty" => "",
            "PLTS" => "",
            "PLTType" => "",
            "DGITEM" => "");
        $orders = array(
            "State" => 0,
            "DG" => "False",
            "DGType" => "",
            "OrderNo" => $routing_details['order_id'],
            "RefNo" => array(
                "RefNo" => $routing_details['order_id']
            ),
            "PONo" => "",
            "MsgID" => "",
            "ConOrderNo" => "",
            "ConsID" => $routing_details['drop_custid'],
            "ConsName" => $routing_details['delivery'],
            "ConsStreet" => $routing_details['delivery_address1'],
            "ConsSuburb" => $routing_details['delivery_address2'],
            "ConsCity" => $routing_details['delivery_city'],
            "ConsPC" => $routing_details['delivery_pincode'],
            "ConsCountry" => $routing_details['delivery_country'],
            "ConsContact" => $drop_details['mobile'],
            "CareOfID" => "",
            "CareOfName" => "",
            "CareOfStreet" => "",
            "CareOfSuburb" => "",
            "CareOfCity" => "",
            "CareOfPC" => "",
            "CareOfCountry" => "NZ",
            "CareOfContact" => "",
            "CareOfPhone" => "",
            "CareOfEmail" => "",
            "DeliverBy" => getdatetimebytimezone($curtz,
                date('Y-m-d H:i:s',strtotime($routing_details['pickup_datetime'] . "+1 days")), DFLT_TZ)['datetime'],
            "DeliverByEnd" => getdatetimebytimezone($curtz,
                $routing_details['drop_endtime'], DFLT_TZ)['datetime'],
            "ProductCat" => $routing_details['product'],
            "TotalWT" => $cargo_details['weight'],
            "TotalM3" => $cargo_details['volume'],
            "TotalPLTS" => $cargo_details['quantity'],
            "TotalCHEP" => "0",
            "TotalLOSCAM" => "0",
            "TotalCUSTOM" =>  $cargo_details['quantity'],
            "TotalPCS" => $cargo_details['total_cargos_count'],
            "TotalLifts" => "0",
            "HU" => array($hu)
        );
        $jdata = array(
            'ManifestID' => date('YmdHi'),
            "SecKey" => LINFOX_SEC_KEY,
            "ShipID" => $routing_details['pickup_custid'],
            "ShipName" => $routing_details['pickup'],
            "ShipStreet" => $routing_details['pickup_address1'],
            "ShipSuburb" => $routing_details['pickup_address2'],
            "ShipCity" => $routing_details['pickup_city'],
            "ShipPC" => $routing_details['pickup_pincode'],
            "ShipCountry" => "NZ",
            "ShipContact" => $pickup_details['mobile'],
            "ShipPhone" => $pickup_details['mobile'],
            "ShipEmail" => $pickup_details['email'],
            "OrderDate" => getdatetimebytimezone($curtz,
                $routing_details['createdon'], DFLT_TZ)['datetime'],
            "PickupBy" => getdatetimebytimezone($curtz,
                $routing_details['pickup_datetime'], DFLT_TZ)['datetime'],
            "PickupByEnd" => getdatetimebytimezone($curtz,
                $routing_details['pickup_endtime'], DFLT_TZ)['datetime'],
            "Orders" => array($orders));
        $resname = date("Ymdhis");

        $filename = "LF-" . $routing_details['shipmentid'] . "-" . $routing_details['id'] . "-" . $resname . ".json";
        $my_file = $filename;
        try {
            $handle = fopen('xml/LF/' . $my_file, 'w+') or die('Cannot open file:  ' . $my_file);
            $data = json_encode($jdata);
            fwrite($handle, $data);
        } catch (Exception $exc) {
            log_message("error", $exc->getTraceAsString());
        } finally {
            fclose($handle);
        }


        $this->uploadfiletoftp($filename);


        //by mahendra start
        /*$json = file_get_contents(base_url()."assets/LF-TRU3620360024-2834-20201027100359.json");
        $obj  = json_decode($json,true);
        print_r($obj);*/


        //	$this->initiate_bite_transit_status_process_dynamic();

        //by mahendra end
        /* insert TRN ref into table */
        /*
          $refnum = '{
          "OrderNo": "183588",
          "MsgID": "MID183588CO",
          "Manifest": "785216",
          "SecKey": "UULK07las8LL9alla",
          "State": "PICKUP",
          "StateDT": "2020-08-11T13:25:16Z"
          }';

          if($refnum != ""){
          $ref_id = "TRN";
          $insarr = array("order_id"=>$data['id'],"reference_id"=>$ref_id,"ref_value"=>$refnum,"status"=>1);
          $ins = $this->common->insertTableData("tb_order_references",$insarr);
          }
         */
    }

    function initiate_bite_transit_status_process(){
        try {
            /*$folder = "/pub/inbound";
            $sftp_url = "mft-test.int.kn";
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $pwd)) {
                exit('Login Failed');
            }
            // outputs the contents of filename.remote to the screen
            $sftp->chdir($folder);
            $files_list = $sftp->nlist();*/

            $files_list = array("test.json","test1.json");

            if (!empty($files_list)) {
                foreach ($files_list as $index => $filename) {
                    //if (strlen($filename) > 10) {

                    //$file_content = $sftp->get($folder . '/' . $filename);
                    $json = file_get_contents(base_url()."assets/inbound_json/".$filename);
                    //echo base_url()."assets/inbound_json/".$filename;
                    $response  = json_decode($json,true);
                    print_r($response);

                    //mahendra start

                    //print_r($response);
                    //echo $response['ManifestID'];

                    //mahendra end
                    $stdclass = new stdClass();
                    $stdclass->communicationReference = $response['OrderNo'];
                    /*$stdclass->consignmentNumber = $response['consignmentNumber'];
                    $stdclass->toStatus = $response['toStatus'];
                    $stdclass->trackDate = $response['trackDate'];
                    $stdclass->trackTime = $response['trackTime'];
                    $SenderAddress = $response['SenderAddress'];
                    $stdclass->pickup_street = $SenderAddress['street'];
                    $deliveryAddress = $response['deliveryAddress'];
                    $stdclass->delivery_street = $deliveryAddress['street'];

                    $this->bite_transit_status_process($stdclass);*/
                    //}
                }
            }
        } catch (Exception $e) {
            log_message("error", "------SFTP Success @ BITE TRANSIT-----" . $e->getMessage());
        }
    }
    function initiate_bite_transit_status_process_dynamic(){
        try {
            $folder = "/pub/outbound/inbound_sample_test";
            $sftp_url = "mft-test.int.kn";
            $username = LINFOX_USERNAME;
            $pwd = LINFOX_PWD;
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $pwd)) {
                unset($sftp);
                exit('Login Failed');
            }
            // outputs the contents of filename.remote to the screen
            $sftp->chdir($folder);
            $files_list = $sftp->nlist();

            if (!empty($files_list)) {
                foreach ($files_list as $index => $filename){
                    $expdata = explode(".",$filename);
                    if($expdata[1]=="json"){
                        $file_content = $sftp->get($folder . '/' . $filename);
                        file_put_contents("assets/linfox/".$filename,$file_content);
                        $json = file_get_contents("assets/linfoxedi/".$filename);
                        $response  = json_decode($json,true);
                        //echo "<pre>";
                        //print_r($response);
                        //echo "<pre>";

                        $date = $response['StateDT'];
                        $this->status_update_process($response['OrderNo'],$response['State'],$date);



                        /*$stdclass = new stdClass();
                        $stdclass->communicationReference = ""; //
                        $stdclass->consignmentNumber = "";
                        $stdclass->toStatus = $response['State'];
                        $stdclass->trackDate = $response['StateDT'];
                        $stdclass->trackTime = "";
                        $SenderAddress = "";
                        $stdclass->pickup_street = "";
                        $deliveryAddress = "";
                        $stdclass->delivery_street = "";

                        $this->bite_transit_status_process($stdclass);*/
                    }
                }

            }
            unset($sftp);

        } catch (Exception $e) {
            log_message("error", "------SFTP Success @ BITE TRANSIT-----" . $e->getMessage());
        }
    }

    function status_update_process($order_id, $status, $date) {
        if($status=="PICKUP"){
            $pickup_date = $date;
            $delivered_date = "";
        }
        else{
            $pickup_date = "";
            $delivered_date = $date;
        }

        $stop_id = $stop_detail_id = 0;
        $stop_type = 'P';

        $company_code = $this->ci->session->userdata('company_code');
        $branch_code = $this->ci->session->userdata('branch_code');
        /*
         *  Before Inserting  time it must be convert into UTC .
         */
        $createdon = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), '')['datetime'];
        $pickup_date = getdatetimebytimezone(DFLT_TZ, $pickup_date, '')['datetime'];
        $delivered_date = getdatetimebytimezone(DFLT_TZ, $delivered_date, '')['datetime'];

        /*
         *  check carrier related status codes are exists in tb_status_master else insert them with company and branch code.
         *  and then start using them in tb_Stop_Status.
         */
        $this->ci->edistatusprocess->bite_transit_carrier_status_update($company_code, $branch_code, $createdon);

        /*
         *  carrier status codes
         */
        $status_list = array("0500", "3000");
        $status_codes = array("PICKUP" => "0500", "DELIVERY" => "1300");
        /*
         *  kn status names.
         */
        $avilable_status = array("Accept", "Gate In", "Pickup", "Gate Out", "In-Transit", "Gate IN", "Delivery", "Gate Out", "Close");
        if (in_array($status, array("3000"))) {
            $stop_type = 'D';
        }
        /*
         *  Get shift_id and trip id
         */
        //echo $order_id;
        $order = $this->ci->edistatusprocess->getshipment_id1($order_id);

        $shipment_id = $order['shift_id'];
        $trip_id = $order['trip_id'];
        $big_order_id = $order['order_id'];

        /*
         *  Get Stop_id
         */
        $stop_id = $this->ci->edistatusprocess->get_order_stop_id($shipment_id, $stop_type);
        /*
         *  stop_detail_id
         */
        $stop_detail_id = $this->ci->edistatusprocess->get_order_stops_details_id($shipment_id, $big_order_id);

        /*
         * vehicel info
         */
        $vehicle_info = $this->ci->edistatusprocess->get_vehicle_info($shipment_id);
        $driver_id = $vehicle_info['driver_id'];
        $vehicle_id = $vehicle_info['vehicle_id'];


        /*
         * get driver phone number
         */

        $mobile_num = $this->ci->edistatusprocess->get_driver_info($driver_id);
        /*
         * Default Lat and Lng
         */
        $lat = 0;
        $lng = 0;
        $reason = 'From Linfox';
        $status = "0500";
        if (in_array($status, $status_list)) {
            if ($status == "0500") {
                // i.e. pickup is happend
                /*
                 *  Gate In
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[1], $company_code, 'name');
                log_message("error", $this->ci->db->last_query());

                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];

                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                //print_r($check_array);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array); //inserting fine

                }



                /*
                 *  Pickup
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($status_codes['PICKUP'], $company_code, 'code');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  Gate Out
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[3], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  InTransit
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[4], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $pickup_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }
            }

            if ($status == "3000") {
                /*
                 *  Gate In
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[1], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $delivered_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }


                /*
                 *  Drop/delivery
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($status_codes['DELIVERY'], $company_code, 'code');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $delivered_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  Gate Out
                 */
                $status_info = $this->ci->edistatusprocess->get_status_ids($avilable_status[3], $company_code, 'name');
                $status_id = $status_info['id'];
                $status_code = $status_info['status_code'];
                /*
                 *  check if status already inserted or not if not insert else no need to update .i.e we can leave it.
                 */
                $check_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                if ($this->ci->edistatusprocess->check_stop_status_exists_or_not($check_array) == "0") {
                    $innr_array = array('order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stop_type, 'trip_id' => $trip_id, 'status_id' => $status_id, 'status_code' => $status_code, 'status' => 1, 'reason' => $reason, 'latitude' => $lat, 'longitude' => $lng, 'createdon' => $delivered_date, 'loc_name' => '', 'driver_id' => $driver_id, 'vehicle_id' => $vehicle_id);
                    $this->ci->edistatusprocess->add_stop_status($innr_array);
                }

                /*
                 *  Close Trip/
                 */

                // $this->ci->edistatusprocess->close_shipment($order_id, $shipment_id, $trip_id);
            }

            /*
             * add_driver_location info
             */
            if ($vehicle_id != '' && $driver_id != '') {
                $this->ci->edistatusprocess->add_driver_location($driver_id, $vehicle_id, $trip_id, $lat, $lng, $mobile_num, $createdon);
            }
            /*
             *  Add Truck Data.
             */
            if ($vehicle_id != '') {
                $this->ci->edistatusprocess->add_truck_data($vehicle_id, $lat, $lng);
            }
        }
    }

    function initiate_bite_transit_status_process_old() {
        try {
            $folder = BITE_TRANSIT_OUTBOUND_PATH;
            $sftp_url = BITE_TRANSIT_SERVER_IP;
            $username = BITE_TRANSIT_USERNAME;
            $pwd = BITE_TRANSIT_PWD;
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $pwd)) {
                unset($sftp);
                exit('Login Failed');
            }
            // outputs the contents of filename.remote to the screen
            $sftp->chdir($folder);
            $files_list = $sftp->nlist();
            if (!empty($files_list)) {
                foreach ($files_list as $index => $filename) {
                    if (strlen($filename) > 10) {
                        $file_content = $sftp->get($folder . '/' . $filename);
                        $response = simplexml_load_string($file_content);

                        $response = json_decode(json_encode(simplexml_load_string($file_content)), true);
                        $stdclass = new stdClass();
                        $stdclass->communicationReference = $response['communicationReference'];
                        $stdclass->consignmentNumber = $response['consignmentNumber'];
                        $stdclass->toStatus = $response['toStatus'];
                        $stdclass->trackDate = $response['trackDate'];
                        $stdclass->trackTime = $response['trackTime'];
                        $SenderAddress = $response['SenderAddress'];
                        $stdclass->pickup_street = $SenderAddress['street'];
                        $deliveryAddress = $response['deliveryAddress'];
                        $stdclass->delivery_street = $deliveryAddress['street'];

                        $this->bite_transit_status_process($stdclass);
                    }
                }
            }
            unset($sftp);
        } catch (Exception $e) {
            log_message("error", "------SFTP Success @ BITE TRANSIT-----" . $e->getMessage());
        }
    }

    public function uploadfiletoftp($filename) {
        try {
            $localfile = "xml/LF/".$filename;
            $folder ="/pub/outbound";
            $sftp_url = "mft-test.int.kn";
            $username = LINFOX_USERNAME;
            $pwd = LINFOX_PWD;
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $pwd)) {
                unset($sftp);
                throw new \Exception('something in went wrong. !');
            }
            $sftp->chdir($folder);
            $sftp->put($folder."/".$filename,$localfile,SFTP::SOURCE_LOCAL_FILE);
            unset($sftp);
            return true;
        } catch (Exception $e) {
            log_message("error", "------Linfox sftp issue-----" . $e->getMessage());
        }
    }

}
