<?php

class Mailhandler
{
    private $ci;
    private $charset;
    private $from;
    private $name;
    private $mimeType;

    public function __construct(
        string $charset = 'utf-8',
        string $from = 'svkonekt@kuehne-nagel.com',
        string $name = 'svkonekt',
        string $mimeType = 'application/pdf'
    ) {
        $this->ci = &get_instance();
        $this->charset = $charset;
        $this->from = $from;
        $this->name = $name;
        $this->mimeType = $mimeType;
    }

    public function mailRequestHandler(
        string $email,
        string $subject,
        string $message,
        string $fileContent,
        string $fileName
    ): bool {
        return $this->mailDataValidator($email, $subject, $message) && $this->sendMail(
                $email,
                $subject,
                $message,
                $fileContent,
                $fileName
            );
    }

    private function sendMail(
        string $email,
        string $subject,
        string $message,
        string $fileContent,
        string $fileName
    ): bool {
        $this->ci->load->library('email');
        $this->ci->email->initialize(
            [
                'mailtype' => 'html',
                'charset' => $this->charset,
                'wordwrap' => false,
                'validate' => true,
                'newline' => '\r\n',
            ]
        );
        $this->ci->email->from($this->from, $this->name);
        $this->ci->email->to($email, '');
        $this->ci->email->subject($subject);
        $this->ci->email->message($message);
        $this->ci->email->attach($fileContent, 'attachment', $fileName, $this->mimeType);
        $result = $this->ci->email->send();
        $this->ci->email->clear(true);
        return $result;
    }

    private function mailDataValidator(string $email, string $subject, string $message): bool
    {
        switch (true) {
            case filter_var($email, FILTER_VALIDATE_EMAIL) === false:
            case strlen(trim($subject)) <= 2:
            case strlen(trim($message)) <= 2:
                return false;
            default:
                return true;
        }
    }
}
