<?php

class Misreportlib
{
    private const SWIFTLOG_SOURCE = '15';

    /**
     * @param $orderData
     * @param $scansData
     * @return array
     */
    public function orderScanData($orderData, $scansData): array
    {
        if (empty($scansData)) {
            return [];
        }

        return $this->prepareOrderScansData($scansData, $orderData);
    }

    /**
     * @param $scansData
     * @param $orderData
     * @return array
     */
    private function prepareOrderScansData($scansData, $orderData): array
    {
        foreach ($scansData as $scanData) {
            if ($scanData['order_id'] == $orderData['id']) {
                $scanData['prev_scan_val'] = $scanData['scan_val'];
                $scanData['scan_val'] = $this->getScanValue($scanData, $orderData['created_source']);
                $orderScanData[] = $scanData;
            }
        }

        return $orderScanData ?? [];
    }

    private function getScanValue(array $scanData, string $created_source): string
    {
        $scanType = $scanData['scan_type'];
        $scanValue = $scanData['scan_val'];

        if ($created_source == self::SWIFTLOG_SOURCE) {
            $scanValue = $this->getScanValueForSwiflogSource($scanType, $scanValue);
        } else {
            $scanValue = $this->getScanValueForRestSources($scanType, $scanValue);
        }

        if ($scanType == "LT" && $scanValue == 'LOST') {
            $scanValue = "Lost";
        }

        return $scanValue;
    }

    /**
     * @param $scanType
     * @param $scanValue
     * @return mixed|string
     */
    private function getScanValueForSwiflogSource($scanType, $scanValue)
    {
        if ($scanType == "UD" && in_array($scanValue, ['Manifested', 'Not Picked','Pending','Assigned','Out-For-Pickup','Pickup-Failed'])) {
            $scanValue = "Pickup Pending";
        }
        if ($scanType == "UD" && in_array($scanValue, ['In Transit', 'Pending','At-Hub','Moving-To-Hub','Picked'])) {
            $scanValue = "In Transit";
        }
        if ($scanType == "UD" && in_array($scanValue, ['Dispatched', 'Attempted','In-Progress'])) {
            $scanValue = "Out for delivery";
        }
        if ($scanType == "RT" && in_array($scanValue, ['Dispatched','Moving-to-Origin']) ) {
            $scanValue = "Out for Return";
        }
        if ($scanType == "RT" && in_array($scanValue, ['In Transit', 'Pending','Returned-to-Origin','Returned-to-Origin-Failed','At-Hub-RTO'])) {
            $scanValue = "Return In Transit";
        }
        if ($scanType == "DL" && in_array($scanValue, ['Delivered','Complete'])) {
            $scanValue = "Delivered";
        }
        if ($scanType == "DL" && in_array($scanValue, ['RTO','Returned'])) {
            $scanValue = "RTO Delivered";
        }

        return $scanValue;
    }

    /**
     * @param $scanType
     * @param $scanValue
     * @return mixed|string
     */
    private function getScanValueForRestSources($scanType, $scanValue)
    {
        if (($scanType == "PP" && in_array($scanValue, ["Open", "Dispatched"])) ||
            (in_array($scanType, ["PP", "PU"]) && $scanValue == 'Scheduled')) {
            $scanValue = "Pickup Pending";
        }
        if ($scanType == "PU" && $scanValue == 'In Transit') {
            $scanValue = "In Transit";
        }
        if ($scanType == "PU" && $scanValue == 'Pending') {
            $scanValue = "Pending";
        }
        if ($scanType == "PU" && $scanValue == 'Dispatched') {
            $scanValue = "Out for delivery";
        }
        if (in_array($scanType, ["DL", "DTO"]) && in_array($scanValue, ["DTO", "Delivered"])) {
            $scanValue = "Delivered";
        }
        if ($scanType == "PP" && $scanValue == 'Canceled') {
            $scanValue = "Cancelled";
        }
        if ($scanType == "CN" && $scanValue == 'Canceled') {
            $scanValue = "Pickup Cancelled";
        }
        if ($scanType == "CN" && $scanValue == 'Closed') {
            $scanValue = "Closed";
        }

        return $scanValue;
    }
}
