<?php

use phpDocumentor\Reflection\PseudoTypes\False_;

class Notifycustomer {

    private $ci = '';
    private $shift_id = 0;
    private $vehicle_id = '-';
    private $driver_id = '-';
    private $driver_name = '-';
    private $driver_phone_number = '-';
    private $truck_number = '-';
    private $truck_brand = '-';
    private static $skip_count = 0;
    function __construct() {
        $this->ci = & get_instance();
    }

    function getShift_id() {
        return $this->shift_id;
    }

    function setShift_id($shift_id): void {
        $this->shift_id = $shift_id;
    }

    function getVehicle_id() {
        return $this->vehicle_id;
    }

    function getDriver_id() {
        return $this->driver_id;
    }

    function getDriver_name() {
        return $this->driver_name;
    }

    function getDriver_phone_number() {
        return $this->driver_phone_number;
    }

    function getTruck_number() {
        return $this->truck_number;
    }

    function getTruck_brand() {
        return $this->truck_brand;
    }

    function setVehicle_id($vehicle_id): void {
        $this->vehicle_id = $vehicle_id;
    }

    function setDriver_id($driver_id): void {
        $this->driver_id = $driver_id;
    }

    function setDriver_name($driver_name): void {
        $this->driver_name = $driver_name;
    }

    function setDriver_phone_number($driver_phone_number): void {
        $this->driver_phone_number = $driver_phone_number;
    }

    function setTruck_number($truck_number): void {
        $this->truck_number = $truck_number;
    }

    function setTruck_brand($truck_brand): void {
        $this->truck_brand = $truck_brand;
    }

    static function getSkip_count() {
        return Notifycustomer::$skip_count;
    }

    static function setSkip_count($skip_count): void {
        Notifycustomer::$skip_count = $skip_count;
    }

    public function notify_customer($shift_id,$source='') {
        if (!(is_numeric($shift_id) && $shift_id > 0)) {
            $message ="<p style='color:black'>Please provide valid details.</p>";
            if($source == 'trip_create'){
                return  $message;
            }else{
                echo $message;
                return;
            }
        }
        $this->get_trip_vehicle_info($shift_id);
        if($this->getDriver_id() =="-" ||  $this->getVehicle_id() == "-"){
            $message = "<p style='color:black'>We are unable to find vehicle OR Driver Details to send emails</p>";
            log_message("error","at step -2".$shift_id);
            if($source == 'trip_create'){
                return  $message;
            }else{
                echo $message;
                return;
            }
        }
        $query = "SELECT
                        tb_orders.trip_id
                        ,tb_orders.order_id
                        ,tb_orders.shipmentid
                        ,tb_orders.id AS order_row_id
                        ,tb_orders.delivery_datetime
                        ,GROUP_CONCAT(CONCAT(tbl_party_types.name,':',tbl_party_master.name) SEPARATOR '||') party_name
                        ,GROUP_CONCAT(CONCAT(tbl_party_types.name,':',tbl_party_master.email) SEPARATOR '||') party_email
                        ,GROUP_CONCAT(tbl_party_master.id SEPARATOR '.') party_unique_id
                        ,GROUP_CONCAT(tbl_party_types.name) party_type
                        ,(SELECT tb_order_references.ref_value FROM tb_order_references WHERE tb_order_references.order_id = order_row_id AND tb_order_references.reference_id='DQ' AND tb_order_references.status = 1 LIMIT 1) AS delivery_note
                        ,(SELECT tb_order_references.ref_value FROM tb_order_references WHERE tb_order_references.order_id = order_row_id AND tb_order_references.reference_id='PO' AND tb_order_references.status = 1 LIMIT 1) AS purchase_order
                        FROM tb_orders
                        JOIN `tb_order_parties` ON (tb_orders.id=tb_order_parties.order_id AND tb_order_parties.status=1)
                        JOIN `tbl_party_master` ON (tbl_party_master.id=tb_order_parties.party_id)
                        JOIN `tbl_party_types` ON (tbl_party_types.id = tbl_party_master.party_type_id AND tbl_party_types.name IN ('Consignee','Customer'))
                    WHERE shift_id='$shift_id' -- AND tb_orders.trip_id!=0
                    GROUP BY tb_orders.order_id
                    ORDER BY tb_orders.order_id,party_unique_id";
        $orders_data_set = $this->ci->db->query($query);
        if($orders_data_set == FALSE){
            $orders_data_set = array();
        }else{
            $orders_data_set = $orders_data_set->result_array();
        }
        if (is_array($orders_data_set) && !empty($orders_data_set)) {
            $size_of_order_set = sizeof($orders_data_set);
            $total_emails_processed = $this->process_order_data($orders_data_set, $size_of_order_set);
            $not_processed_emails = ($size_of_order_set - Notifycustomer::$skip_count) - $total_emails_processed;
            $message = "<br><p style='color:black'><b>$total_emails_processed</b> Email(s) send successfully! <b>$not_processed_emails</b> Email(s) not send successfully.</p>";
            Notifycustomer::$skip_count =0 ;
            if($source == 'trip_create'){
                return  $message;
            }else{
                echo $message;
                return;
            }
        } else {
            $message = "<br><p style='color:black'>Zero Records found with give shipment Id</p>";
            if($source == 'trip_create'){
                return  $message;
            }else{
                echo $message;
                return;
            }
        }
    }

    private function process_order_data($orders_data_set, $orders_size) {
        $orders_desc = '';
        $total_emails_proceessed = 0;
        $this->setShift_id($orders_data_set[0]['shipmentid']);
        for ($i = 0; $i < $orders_size; $i++) {
            $order_set = $orders_data_set[$i];
            $order_id = $order_set['order_id'];
            $order_row_id = $order_set['order_row_id'];
            $delivery_datetime = $order_set['delivery_datetime'];
            $party_unique_id = $order_set['party_unique_id'];
            $party_type = $order_set['party_type'];
            $delivery_note = $order_set['delivery_note'];
            $purchase_order = $order_set['purchase_order'];

            $parties_info = $this->extract_parites_info($order_set['party_name']);

            $customer_name = $parties_info['customer'];
            $consignee_name = $parties_info['consignee'];

            $parties_email_info = $this->extract_parites_info($order_set['party_email']);
            $customer_email = $parties_email_info['customer'];
            $consignee_email = $parties_email_info['consignee'];

            $orders_desc .= $this->generate_email_template_body($order_id, $delivery_note, $purchase_order, $delivery_datetime);
            if($orders_size>1){

                $current_pointer = $orders_data_set[$i]['party_unique_id'];
                $next_pointer = (isset($orders_data_set[$i+1]['party_unique_id']))? $orders_data_set[$i+1]['party_unique_id']:0;
                if($current_pointer == $next_pointer){
                    Notifycustomer::$skip_count++;
                    log_message("error","SKIP ".$next_pointer);
                }else{
                    if (filter_var($consignee_email, FILTER_VALIDATE_EMAIL)) {
                        $this->email_notify_customer($consignee_email, $customer_email, $this->generate_full_template($customer_name, $orders_desc));
                        $total_emails_proceessed++;
                    }
                    $orders_desc = '';
                }
            }else{
                if (filter_var($consignee_email, FILTER_VALIDATE_EMAIL)) {
                    $this->email_notify_customer($consignee_email, $customer_email, $this->generate_full_template($customer_name, $orders_desc));
                    $total_emails_proceessed++;
                }
                $orders_desc = '';
            }
        }
        return $total_emails_proceessed;
    }

    private function generate_email_template_body($order_id, $delivery_note, $purchase_order, $delivery_datetime) {
        $orders = "<p> $order_id; $delivery_note; $purchase_order доставка $delivery_datetime </p>";
        return $orders;
    }

    private function generate_full_template($customer_name, $orders_desc) {
        $welcome = "<p>Уважаемые партнеры!</p>";
        $line1 = "<p> Информируем Вас, что в Ваш адрес планируется доставка заказов от $customer_name:</p>";
        $line2 = "<p>Автомашина " . $this->getTruck_brand() . " гос. Номер " . $this->getTruck_number() . " водитель " . $this->getDriver_name() . ", телефон " . $this->getDriver_phone_number() . "</p>";
        $line3 = "<p>При необходимости оформите пропуск!</p>";
        $line4 = "<p>С Уважением,</p>";
        $line5 = "<p>ООО КН</p>";
        $template = $welcome . $line1 . $orders_desc . $line2 . $line3 . $line4 . $line5;
        return $template;
    }

    public function email_notify_customer($consignee_email, $customer_email, $body) {
        $this->ci->load->library('email');
        $config['mailtype'] = 'html';
        $config['charset'] = 'UTF-8';
        $config['wordwrap'] = FALSE;
        $config['validate'] = TRUE;
        $config['newline'] = '\r\n';
        $config['priority'] = '1';

        $this->ci->email->initialize($config);
        $this->ci->email->from('noreply@kuehne-nagel.com', 'Kuehne + Nagel');
        $this->ci->email->to($consignee_email, '');
        if (filter_var($customer_email, FILTER_VALIDATE_EMAIL)) {
            $this->ci->email->cc($customer_email, '');
        }
        $this->ci->email->subject('Уведомление о доставке ' . $this->getShift_id());
        $this->ci->email->message($body);
        $this->ci->email->send();
        $this->ci->email->clear(true);
    }

    private function extract_parites_info($parties_names) {
        $customer_name = $consignee_name = '';
        $is_customer = false;
        if (strlen($parties_names) > 3) {
            $parties_names = explode('||', $parties_names);
            if (substr($parties_names[0], 0, strlen('Customer:')) == 'Customer:') {
                $customer_name = $parties_names[0];
                $is_customer = true;
            }
            if ($is_customer) {
                $consignee_name = $parties_names[1];
            } else {
                $consignee_name = $parties_names[0];
                $customer_name = $parties_names[1];
            }
        }
        return array(
            "customer" => str_replace('Customer:', '', $customer_name),
            "consignee" => str_replace('Consignee:', '', $consignee_name)
        );
    }

    private function get_trip_vehicle_info($shift_id) {
       $this->ci->db->select(array('tb_shft_veh.vehicle_id','tb_shft_veh.register_number','tbl_assigned_drivers.driver_id',
            'tb_truck_drivers.name','tb_truck_drivers.contact_num','tb_trucks_data.truck_brand','tb_shft_veh.shft_id'))
            ->from('tb_shft_veh')
            ->join('tbl_assigned_drivers','tb_shft_veh.vehicle_id =tbl_assigned_drivers.vehicle_id AND tbl_assigned_drivers.status=1')
            ->join('tb_truck_drivers','tb_truck_drivers.id = tbl_assigned_drivers.driver_id')
            ->join('tb_trucks_data',"tb_trucks_data.id = tb_shft_veh.vehicle_id AND .tb_trucks_data.status='Active'")
            ->where(array('shft_id'=>$shift_id))->limit(1);
        $vehicle_driver_info = $this->ci->db->get();
        if($vehicle_driver_info == FALSE){
            $vehicle_driver_info = array();
        }else{
            $vehicle_driver_info = $vehicle_driver_info->row_array();
        }
        if (sizeof($vehicle_driver_info) > 0 && isset($vehicle_driver_info['vehicle_id'])) {
            $this->setVehicle_id($vehicle_driver_info['vehicle_id']);
            $this->setDriver_id($vehicle_driver_info['driver_id']);
            $this->setDriver_name($vehicle_driver_info['name']);
            $this->setDriver_phone_number($vehicle_driver_info['contact_num']);
            $this->setTruck_number($vehicle_driver_info['register_number']);
            $this->setTruck_brand($vehicle_driver_info['truck_brand']);
        }
    }
 
    public function get_shiftids_based_on_order_id($order_list){
        $restult_set =$this->ci->db->distinct()
                            ->select('shift_id')
                            ->from('tb_orders')
                            ->where_in("id",$order_list)
                            ->get();
        if($restult_set == FALSE){
            $restult_set = array();
        }else{
            $restult_set = $restult_set->result_array();
        }
        return $restult_set;
    }
}
