<?php

use phpseclib\Net\SFTP;


class Openbox_status_execution
{
    private $ci;

    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('common');
        $this->ci->load->helper('customerconfigedi');
    }

    function pushStatusExecutionXml(array $status_data): void
    {

        if (openBoxcheckCustomerIdvalid($status_data['order_row_id'], 'orderid')) {

            $isvalid = $this->validate_status($status_data['status']);
            if ($isvalid['valid'] == true) {
                if (count($status_data) == 0) {
                    log_message("error", "Open-box-info: data not available");
                } else {
                    $data['status_string'] = $isvalid['status_string'];
                    $data['status_data'] = $status_data;

                    $getorder_id = $this->ci->common->gettblrowdata(['id' => $status_data['order_row_id']], 'order_id, shipmentid', 'tb_orders', 0, 0);
                    if (count($getorder_id)) {
                        $order_id = $getorder_id['order_id'];
                        $shipmentid = $getorder_id['shipmentid'];
                        $data['order_id'] = $order_id;
                        $data['shipmentid'] = $shipmentid;
                        $data['executionTimestamp'] = (new \DateTime($data['status_data']['date_time']))
                            ->format("Y-m-d\TH:i:s\Z");
                        $this->generateExecutionXml($data);
                    } else {
                        log_message("error", "Open-box-info: Order id not found.");
                    }

                }
            }
        }
    }

    function generateExecutionXml(array $data): void
    {
        $seqNo = (new \DateTime())->getTimestamp();
        $fileName = uniqid() . '_openbox_status_execution.xml';
        $xmlString = '<?xml version="1.0" encoding="UTF-8"?>
<Execution xmlns="https://elog360.app/svkonekt_test/edi/carrier/trip_execution/v1">
  <Header>
    <Version>V1</Version>
    <SequenceNumber>' . $seqNo . '</SequenceNumber>
    <DestinationApp>Openboxes</DestinationApp>
  </Header>
  <TripID>' . $data['shipmentid'] . '</TripID>
  <ExecutionStatus>
    <OrderID>' . $data['order_id'] . '</OrderID>
    <Status>' . $data['status_string'] . '</Status>
    <DateTime>' . $data['executionTimestamp'] . '</DateTime>
    <GeoData>
      <Latitude>' . $data['status_data']['lat'] . '</Latitude>
      <Longitude>' . $data['status_data']['long'] . '</Longitude>
    </GeoData>
  </ExecutionStatus>
 </Execution>';

        $sftp = new SFTP(OPENBOX_SERVER_IP);
        if (!$sftp->login(OPENBOX_USERNAME, OPENBOX_PASSWORD)) {
            unset($sftp);
            log_error( 'Open-box-info: FTP LOGIN FAIL.');
            return;
        }

        if (!$sftp->chdir(OPENBOX_STATUS_EXECUTION_PATH)) {
            log_error( 'Open-box-info: Unable to find directory.');
            return;
        }

        if ($sftp->put($fileName, $xmlString)) {
            log_error('Open-box-info: Status Execute File moved to FTP.');
        }
        unset($sftp);
    }

    function validate_status(string $status): array
    {
        $data = array();
        $result = false;
        $status_list = array(
            "0420",
            "0500",
            "0191",
            "1550",
            "0192",
            "2300",
            "3000",
            "0218"
        );
        $result = in_array($status, $status_list);

        if ($result) {
            $result = true;
            switch ($status) {
                case "0420":
                    $status_string = "ORIGIN_GATE_IN";
                    break;
                case "0500":
                    $status_string = "PICKUP";
                    break;
                case "0191":
                    $status_string = "ORIGIN_GATE_OUT";
                    break;
                case "1550":
                    $status_string = "IN_TRANSIT";
                    break;
                case "0192":
                    $status_string = "DESTINATION_GATE_IN";
                    break;
                case "2300":
                    $status_string = "DELIVERY";
                    break;
                case "3000":
                    $status_string = "DESTINATION_GATE_OUT";
                    break;
                case "0218":
                    $status_string = "CLOSE";
                    break;
                default:
                    $status_string = "";
            }
        } else {
            $result = false;
            log_message("error", "Open-box-info: Invalid status string.");
        }

        return $data = ["valid" => $result, "status_string" => $status_string];
    }

}
