<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Orderallocationservice
{
    private const SO_ORDER_TYPE = '0';
    private const RETURN_ORDER_TYPE = '1';
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('common');
        $this->ci->load->helper('log_helper');
        $this->ci->load->helper('string_helper');
    }

    public function allocateOrders($ordersData, $orderTotalCount, $batchtime = '')
    {
        $curdt = date('Y-m-d H:i:s');
        $ordersnopincodeList = $ordersList = array();
        foreach ($ordersData as $orderData) {
            if ($orderData['ordtype_code'] == 'SO') {
                $whrcond = array(
                    'origin_pin' => $orderData['pickup_pincode'],
                    'destination_pin' => $orderData['delivery_pincode'],
                    'status' => '1'
                );
            }
            if ($orderData['ordtype_code'] == 'Return') {
                $whrcond = array(
                    'origin_pin' => $orderData['delivery_pincode'],
                    'destination_pin' => $orderData['pickup_pincode'],
                    'status' => '1'
                );
            }
            $checkService = $this->ci->common->gettblrowdata(
                $whrcond,
                "id,reverse_qc,destination_state",
                "tb_customer_pincodes",
                0,
                0
            ); /*here we can get rever_qc also*/
            if (!empty($checkService)) {
                $orderData['reverse_qc'] = $checkService['reverse_qc'];
                $orderData['pickup_state'] = $checkService['destination_state'];
                $orderData['delivery_state'] = $checkService['destination_state'];
                $ordersList[] = $orderData;
            } else {
                $ordersList[] = $orderData;
                $ordersnopincodeList[] = $orderData;
            }
        }
        /* mail alert for orders with no service found*/
        if (!empty($ordersnopincodeList)) {

                $this->ci->load->library('email');
                $this->ci->email->from(SVKONEKT_EMAIL, 'svkonekt');
                $this->ci->email->to(UNIQLO_ORDER_MAILS);
                $sub = "eTN: Pincode not avaible in the carrier master";
                $message = "Hi Team, <br/>Orders Details:<br/>";
                foreach ($ordersnopincodeList as $nopinOrderInfo) {
                    $message .= "Order " . $nopinOrderInfo['shipmentid'] . ": Pickup:" . $nopinOrderInfo['pickup_pincode'] . "  -  Delivery:" . $nopinOrderInfo['delivery_pincode'] . "<br/>";
                }
                $this->ci->email->cc(strip_quotes(UNIQLO_ORDER_CC_MAILS));
                $this->ci->email->subject($sub);
                $this->ci->email->set_mailtype("html");
                $this->ci->email->message($message);
                $this->ci->email->send();
                $this->ci->email->clear(true);

                log_error(
                    UNIQLO_LOG_PREFIX . "allocateOrders sending email with subject: " . $sub
                );

        }

        $allocationRatioData = $allocationPinData = $tripCreate = array();
        if (!empty($ordersList)) {
            foreach ($ordersList as $orderList) {
                $pincode = $orderList['delivery_pincode'];
                $qc_carrier = 0;
                if ($orderList['ordtype_code'] != "SO") {
                    $pincode = $orderList['pickup_pincode'];
                    /*check for SO order carrier for this return order*/
                    $ordshipmentid = trim($orderList['shipmentid']);
                    $chkpo = array('reference_id' => "PO", 'ref_value' => $ordshipmentid, "status" => 1);
                    $chkpoqry = $this->ci->common->gettblrowdata($chkpo, "order_id", "tb_order_references", 0, 0);
                    if (count($chkpoqry) > 0) {
                        $chkord = array(
                            'id' => $chkpoqry['order_id'],
                            'vendor_id >' => 0,
                            'status <>' => 0,
                            'created_source' => '15'
                        );
                        $chkordqry = $this->ci->common->gettblrowdata($chkord, "id,vendor_id", "tb_orders", 0, 0);
                        if (count($chkordqry) > 0) {
                            $qc_carrier = $this->checkcarrierrevqc($chkordqry['vendor_id'], $pincode);
                        }
                    } else {
                        $chkpo = array('order_id' => $orderList['id'], 'reference_id' => "XSR", "status" => 1);
                        $chkordrefqry = $this->ci->common->gettblrowdata(
                            $chkpo,
                            "ref_value",
                            "tb_order_references",
                            0,
                            0
                        );
                        if (count($chkordrefqry) > 0) {
                            if ($ordshipmentid != $chkordrefqry['ref_value']) {
                                $chkpo = array(
                                    'reference_id' => "PO",
                                    'ref_value' => $chkordrefqry['ref_value'],
                                    "status" => 1
                                );
                                $chkpoqry = $this->ci->common->gettblrowdata(
                                    $chkpo,
                                    "order_id",
                                    "tb_order_references",
                                    0,
                                    0
                                );
                                if (count($chkpoqry) > 0) {
                                    $chkord = array(
                                        'id' => $chkpoqry['order_id'],
                                        'vendor_id >' => 0,
                                        'created_source' => '15'
                                    );
                                    $chkordqry = $this->ci->common->gettblrowdata(
                                        $chkord,
                                        "id,vendor_id",
                                        "tb_orders",
                                        0,
                                        0
                                    );
                                    if (count($chkordqry) > 0) {
                                        $qc_carrier = $this->checkcarrierrevqc($chkordqry['vendor_id'], $pincode);
                                    }
                                }
                            }
                        }
                    }
                }
                if ($qc_carrier > 0 && $orderList['ordtype_code'] != "SO") {
                    $orderList['carrier_id'] = $qc_carrier;
                    $orderList['pincode'] = $pincode;
                    $tripCreate[] = $orderList;
                } else {
                    $prferWhr1 = array('pincode' => $pincode, 'status' => '1');
                    $checkPreferRule1 = $this->ci->common->gettblrowdata(
                        $prferWhr1,
                        "carrier_id",
                        "tb_carrier_prefer_rule",
                        0,
                        0
                    );
                    if (!empty($checkPreferRule1)) {
                        $orderList['carrier_id'] = $checkPreferRule1['carrier_id'];
                        $orderList['pincode'] = $pincode;
                        $tripCreate[] = $orderList;
                    } else {
                        /* if SO order then delivery city state, else pickup city state*/
                        $cityChk = $orderList['delivery_city'];
                        $stateChk = $orderList['delivery_state'];
                        if ($orderList['ordtype_code'] != "SO") {
                            $cityChk = $orderList['pickup_city'];
                            $stateChk = $orderList['pickup_state'];
                        }
                        $prferWhr2 = array('pincode' => "*", 'city' => $cityChk, 'state' => $stateChk, 'status' => '1');
                        $checkPreferRule2 = $this->ci->common->gettblrowdata(
                            $prferWhr2,
                            "carrier_id",
                            "tb_carrier_prefer_rule",
                            0,
                            0
                        );
                        if (!empty($checkPreferRule2)) {
                            $orderList['carrier_id'] = $checkPreferRule2['carrier_id'];
                            $orderList['pincode'] = $pincode;
                            $tripCreate[] = $orderList;
                        } else {
                            $prferWhr3 = array('pincode' => "*", 'city' => "*", 'state' => $stateChk, 'status' => '1');
                            $checkPreferRule3 = $this->ci->common->gettblrowdata(
                                $prferWhr3,
                                "carrier_id",
                                "tb_carrier_prefer_rule",
                                0,
                                0
                            );
                            if (!empty($checkPreferRule3)) {
                                $orderList['carrier_id'] = $checkPreferRule3['carrier_id'];
                                $orderList['pincode'] = $pincode;
                                $tripCreate[] = $orderList;
                            } else {
                                $allocationRatioData[] = $orderList;
                            }
                        }
                    }
                }
                /* 1) only pin 2) pin is * and city,state 3) pin is * and city is * and state */
            }
        }
        if (!empty($tripCreate)) {
            foreach ($tripCreate as $orderInfo) {
                $orderTxnData = array(
                    "user_id" => $orderInfo['user_id'],
                    "order_id" => $orderInfo['id'],
                    "pincode" => $orderInfo['pincode'],
                    "awb_num" => "",
                    "order_type" => $orderInfo['ordtype_code'],
                    "actual_carrier_id" => $orderInfo['carrier_id'],
                    "allocated_carrier_id" => $orderInfo['carrier_id'],
                    "batch_count" => count($tripCreate),
                    "allocate_status" => 0,
                    "nsz" => "",
                    "batchtime" => $orderInfo['batchtime'],
                    "alloted_state" => 2,
                    "createdon" => $curdt,
                    "total_count" => $orderTotalCount,
                );

                $this->saveTransaction($orderTxnData);
            }
        }
        if (!empty($allocationRatioData)) {
            foreach ($allocationRatioData as $value) {
                if ($value['ordtype_code'] == 'SO') {
                    $value['pincode'] = $value['delivery_pincode'];
                } else {
                    $value['pincode'] = $value['pickup_pincode'];
                }
                $allocationPinData[] = $value;
            }
            $this->savebulkTransaction($allocationPinData, $orderTotalCount);
            $soOrdersGroup = $returnOrdersGroup = [];
            $where = ["batchtime" => $batchtime, "status" => 1, "allocate_status" => 0, "alloted_state" => 0];
            $select = "id,order_type,pincode,uniqid_of_package";
            $ordersList = $this->ci->common->gettbldataorderby($where, $select, "tb_allocate_ratio_txn", "id", "ASC");

            if (count($ordersList) > 0) {
                foreach ($ordersList as $order) {
                    if ($order['order_type'] == 'SO') {
                        $soOrdersGroup[$order['uniqid_of_package']][] = $order;
                    } else {
                        $returnOrdersGroup[$order['uniqid_of_package']][] = $order;
                    }
                }
            }

            $this->allocateCarrierByPercentage($batchtime, self::SO_ORDER_TYPE, $soOrdersGroup);
            $this->allocateCarrierByPercentage($batchtime, self::RETURN_ORDER_TYPE, $returnOrdersGroup);
        }
    }

    /**
     * @param string $batchTime
     * @param string $orderType
     * @param array $soOrdersGroup
     */
    private function allocateCarrierByPercentage(string $batchTime, string $orderType, array $ordersGroup)
    {
        $times = explode("#", $batchTime);
        $starTime = $batchTime == '' ? date("Y-m-d") : date("Y-m-d", strtotime($times[0]));
        $endTime = $batchTime == '' ? date("Y-m-d") : date("Y-m-d", strtotime($times[1]));

        if (!empty($ordersGroup)) {
            $carriers = $this->getCarrieList($orderType, $starTime, $endTime);
            if (!empty($carriers)) {
                $sequence = $this->getCarrSeqno($carriers, 'sequence_no');

                foreach ($ordersGroup as $orders) {
                    $this->allocateCarrPerc($orders, $carriers, $sequence);
                }
            }
        }
    }

    /*check carrier pincode reverse qc*/
    public function checkcarrierrevqc($carrierid, $pincode)
    {
        $resp = 0;
        $whrcond = array('destination_pin' => $pincode, 'carrier_id' => $carrierid, 'reverse_qc' => 1, 'status' => 1);
        $chkrevqc = $this->ci->common->gettblrowdata($whrcond, "id,carrier_id", "tb_customer_pincodes", 0, 0);
        if (count($chkrevqc) > 0) {
            $resp = $carrierid;
        } else {
            $curdt = date('Y-m-d');
            $select = "id,sequence_no,carrier_id";
            $tbl = "tb_allocate_ratio_batch";
            $whr = array(
                "order_type" => 1,
                "carrier_id <>" => $carrierid,
                "startdate <=" => $curdt,
                "enddate >=" => $curdt,
                "status" => 1
            );
            $txnarr = $this->ci->common->gettbldataorderby($whr, $select, $tbl, "sequence_no", "ASC");
            if (count($txnarr) > 0) {
                foreach ($txnarr as $res) {
                    $whrcond = array(
                        'destination_pin' => $pincode,
                        'carrier_id' => $res['carrier_id'],
                        'reverse_qc' => 1,
                        'status' => 1
                    );
                    $chkrevqc1 = $this->ci->common->gettblrowdata(
                        $whrcond,
                        "id,carrier_id",
                        "tb_customer_pincodes",
                        0,
                        0
                    );
                    if (count($chkrevqc1) > 0) {
                        $resp = $res['carrier_id'];
                        break;
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "checkcarrierrevqc outbound data: " . json_encode($resp));

        return $resp;
    }

    public function allocateCarrPerc($orders, $carriers, $seqPrefer)
    {
        $orderscnt = count($orders);
        foreach ($carriers as $key => $carrier) {
            if ($orderscnt == 1) {
                /*If single order we can assign to carr who has seq num 1*/
                if ($carrier['sequence_no'] == $seqPrefer) {
                    $set = array(
                        "actual_carrier_id" => $carrier['carrier_id'],
                        "allocated_carrier_id" => $carrier['carrier_id']
                    );
                    $whr = array("id" => $orders[$key]['id']);

                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "allocateCarrPerc updated data in a tb_allocate_ratio_txn: " . json_encode($set)
                    );

                    $updateTxn = $this->ci->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                }
            } elseif ($carrier['sequence_no'] <= $seqPrefer) {
                $asscount = round(($orderscnt * $carrier['allocate_percent']) / 100);
                foreach ($orders as $inkey => $order) {
                    if ($inkey < $asscount) {
                        $set = array(
                            "actual_carrier_id" => $carrier['carrier_id'],
                            "allocated_carrier_id" => $carrier['carrier_id']
                        );
                        $whr = array("id" => $order['id']);

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "allocateCarrPerc updated data in a tb_allocate_ratio_txn: " . json_encode($set)
                        );

                        $updateTxn = $this->ci->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                    }
                }
                $neworders = array_slice($orders, $asscount);
            } elseif ($carrier['sequence_no'] == ($seqPrefer + 1)) {
                $asscount = round(($orderscnt * $carrier['allocate_percent']) / 100);
                if (!empty($neworders)) {
                    foreach ($neworders as $inkey => $neworder) {
                        if ($inkey < $asscount) {
                            $set = array(
                                "actual_carrier_id" => $carrier['carrier_id'],
                                "allocated_carrier_id" => $carrier['carrier_id']
                            );
                            $whr = array("id" => $neworder['id']);

                            log_error(
                                UNIQLO_LOG_PREFIX .
                                "allocateCarrPerc updated data in a tb_allocate_ratio_txn: " . json_encode($set)
                            );

                            $updateTxn = $this->ci->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                        }
                    }
                    $neworders = array_slice($neworders, $asscount);
                }
            } elseif ((count($carriers) - 1) == $key) {
                $asscount = round(($orderscnt * $carrier['allocate_percent']) / 100);
                if (!empty($neworders)) {
                    foreach ($neworders as $inkey => $neworder) {
                        if ($inkey < $asscount) {
                            $set = array(
                                "actual_carrier_id" => $carrier['carrier_id'],
                                "allocated_carrier_id" => $carrier['carrier_id']
                            );
                            $whr = array("id" => $neworder['id']);

                            log_error(
                                UNIQLO_LOG_PREFIX .
                                "allocateCarrPerc updated data in a tb_allocate_ratio_txn: " . json_encode($set)
                            );

                            $updateTxn = $this->ci->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                        }
                    }
                    $neworders = array_slice($neworders, $asscount);
                }
            }
        }
    }

    public function allocateCarrPref($orders, $carriers)
    {
        $carcount = count($carriers);
        $carrkey = 0;
        foreach ($orders as $key => $order) {
            if ($carrkey < $carcount) {
                $carrier_id = $carriers[$carrkey]['carrier_id'];
                $set = array("actual_carrier_id" => $carrier_id, "allocated_carrier_id" => $carrier_id);
                $whr = array("id" => $order['id']);
            } else {
                $carrkey = 0;
                $carrier_id = $carriers[$carrkey]['carrier_id'];
                $set = array("actual_carrier_id" => $carrier_id, "allocated_carrier_id" => $carrier_id);
                $whr = array("id" => $order['id']);
            }
            $carrkey = $carrkey + 1;

            log_error(
                UNIQLO_LOG_PREFIX .
                "allocateCarrPerc updated data in a tb_allocate_ratio_txn: " . json_encode($set)
            );

            $updateTxn = $this->ci->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
        }
    }

    public function getCarrieList($order_type, $startime, $endtime)
    {
        $socarrier = [];
        $whr = array("status" => 1, "allocate_percent >" => 0, "startdate <=" => $startime, "enddate>=" => $endtime);
        if ($order_type != '') {
            $whr = array(
                "status" => 1,
                "order_type" => $order_type,
                "allocate_percent >" => 0,
                "startdate <=" => $startime,
                "enddate>=" => $endtime
            );
        }
        $select = "id,sequence_no,carrier_id,allocate_percent";
        $tbl = "tb_allocate_ratio_batch";
        $txnarr = $this->ci->common->gettbldataorderby($whr, $select, $tbl, "sequence_no", "ASC");
        if (count($txnarr) > 0) {
            foreach ($txnarr as $txn) {
                $socarrier[] = $txn;
            }

            log_error(UNIQLO_LOG_PREFIX . "getCarrieList outbound data: " . json_encode($socarrier));

            return $socarrier;
        } else {
            log_error(UNIQLO_LOG_PREFIX . "getCarrieList outbound data: " . json_encode($socarrier));

            return $socarrier;
        }
    }

    public function getCarrSeqno($socarrier, $clmn)
    {
        $result = min(array_column($socarrier, $clmn));

        log_error(UNIQLO_LOG_PREFIX . "getCarrSeqno outbound data: " . json_encode($result));

        return $result;
    }

    public function getPinCount($soorders)
    {
        $aggreSet = [];
        foreach ($soorders as $key => $soorder) {
            foreach ($soorder as $key2 => $soorde2) {
                if ($key2 == 'pincode') {
                    $pinval = $soorde2;
                    if (array_key_exists($pinval, $aggreSet)) {
                        $aggreSet[$pinval]++;
                    } else {
                        $aggreSet[$pinval] = 1;
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getPinCount outbound data: " . json_encode($aggreSet));

        return $aggreSet;
    }

    public function saveTransaction($orderInfo)
    {
        $whrcond = array(
            "user_id" => $orderInfo['user_id'],
            "order_id" => $orderInfo['order_id'],
            "order_type" => $orderInfo['order_type']
        );
        $checktxnExists = $this->ci->common->gettblrowdata($whrcond, "id", "tb_allocate_ratio_txn", 0, 0);
        if (empty($checktxnExists)) {
            log_error(
                UNIQLO_LOG_PREFIX .
                "saveTransaction inserted data in a tb_allocate_ratio_txn: " . json_encode($orderInfo)
            );

            $ins = $this->ci->common->insertTableData('tb_allocate_ratio_txn', $orderInfo);
            $orderTxnData = array();
        }
    }

    public function savebulkTransaction($ordersInfo, $orderTotalCount)
    {
        $curdt = date('Y-m-d H:i:s');
        $orderTxnData = [];
        $batchtime = "";
        $uniqId = uniqid();

        if (!empty($ordersInfo)) {
            foreach ($ordersInfo as $orderInfo) {
                $whrcond = array(
                    "user_id" => $orderInfo['user_id'],
                    "order_id" => $orderInfo['id'],
                    "order_type" => $orderInfo['ordtype_code']
                );
                $checktxnExists = $this->ci->common->gettblrowdata($whrcond, "id", "tb_allocate_ratio_txn", 0, 0);
                if (empty($checktxnExists)) {
                    $orderTxnData[] = array(
                        "user_id" => $orderInfo['user_id'],
                        "order_id" => $orderInfo['id'],
                        "pincode" => $orderInfo['pincode'],
                        "awb_num" => "",
                        "order_type" => $orderInfo['ordtype_code'],
                        "actual_carrier_id" => 0,
                        "allocated_carrier_id" => 0,
                        "batch_count" => count($ordersInfo),
                        "allocate_status" => 0,
                        "nsz" => "",
                        "batchtime" => $orderInfo['batchtime'] ?? '',
                        "alloted_state" => 0,
                        "createdon" => $curdt,
                        "total_count" => $orderTotalCount,
                        'uniqid_of_package' => $orderInfo['uniqid_of_package']
                    );
                }
            }
            if (!empty($orderTxnData)) {
                $ins = $this->ci->db->insert_batch('tb_allocate_ratio_txn', $orderTxnData);
            }
            $batchtime = isset($ordersInfo[0]['batchtime']) ? $ordersInfo[0]['batchtime'] : "";
        }

        log_error(UNIQLO_LOG_PREFIX . "savebulkTransaction outbound data: " . $batchtime);

        return $batchtime;
    }

}
