<?php

class Orderdetailsrusiaedi
{
    private $ci;

    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->library(['Edi_logger', 'edi_engine']);
        $this->ci->load->model(['Order', 'common', 'Edi_common_model']);
        $this->ci->load->helper('log');
        if ($this->ci->session->userdata('user_id') == '') {
            redirect('login');
        }
    }

    public function shipmentdata(int $shiftId): void
    {
        $getOrderIds = $this->ci->common->gettbldata(['shift_id' => $shiftId, 'status !=' => 0], 'id,order_id', 'tb_orders', 0, 0);
        foreach ($getOrderIds as $res) {
            $checkTrigger = $this->ci->edi_engine->checkTrigerStatus($res['id']);
            if (0 == $checkTrigger) {
                log_error('RusExpress Triggered for Order id-' . $res['id']);
                $this->triggerApi($res['id']);
            } else {
                log_error('RusExpress API already Triggered for order id-' . $res['order_id']);
                $this->ci->edi_logger->log_ruexp_order('0', 'RusExpress API CALL', 'RusExpress API already Triggered for order id-' . $res['order_id'], $res['order_id'], 2);
            }
        }
    }

    public function triggerApi($orderId)
    {
        $getOrderInfo = $this->ci->Order->getordertoedit($orderId);
        if (0 == $getOrderInfo->num_rows()) {
            log_error('RusExpress API Order id not found-' . $orderId);
            $this->ci->edi_logger->log_ruexp_order('0', 'SKIF API CALL', 'RusExpress API Order id not forund-' . $orderId, $orderId, 2);
            return;
        }
        $timezone = $this->ci->session->userdata('usr_tzone')['timezone'];
        $getDateTimeByTimezone = getdatetimebytimezone($timezone, $getOrderInfo->row()->delivery_datetime, DFLT_TZ);
        $deliveryDatetime = $getDateTimeByTimezone['datetime'];
        $deliveryEndDateTime = getdatetimebytimezone($timezone, $getOrderInfo->row()->drop_endtime, DFLT_TZ);
        $deliveryLateEndDate = $deliveryEndDateTime['date'];
        $deliveryLateEndTime = $deliveryEndDateTime['time'];
        $pickupDateTime = $getOrderInfo->row()->pickup_datetime;
        $getActualPickup = getdatetimebytimezone($timezone, $pickupDateTime, DFLT_TZ);
        $pickupDateTime = $getActualPickup['datetime'];
        $pickupDate = $getActualPickup['date'];
        $pickupTime = $getActualPickup['time'];
        $trimmedPickupTime = substr($getActualPickup['time'], 0, 5);
        $getCargos = $this->ci->common->gettbldata(['order_id' => $orderId, 'status' => 1], 'cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content', 'tb_order_cargodetails', 0, 0);
        if (count($getCargos) > 0) {
            foreach ($getCargos as $res) {
                $cargos[] = $res;
            }
        }
        $consigneeDetails = $this->ci->edi_engine->getOrderParites('Consignee', $orderId);
        if (count($consigneeDetails) > 0) {
            $consigneePhone = $consigneeDetails['mobile'];
            $consigneeEmail = $consigneeDetails['email'];
            $consigneeId = $consigneeDetails['party_master_id'];
            $getConsigneeCid = $this->ci->common->gettblrowdata(['id' => $consigneeId], 'code', 'tbl_party_master', 0, 0);
            if (count($getConsigneeCid) > 0) {
                $consigneeCode = $getConsigneeCid['code'];
            }
        }
        $shipper_details = $this->ci->edi_engine->getOrderParites('Shipper', $orderId);
        if (count($shipper_details) > 0) {
            $shipperId = $shipper_details['party_master_id'];
            $getShipperInfo = $this->ci->common->gettblrowdata(['id' => $shipperId], 'code,mobile', 'tbl_party_master', 0, 0);
            if (count($getShipperInfo) > 0) {
                $shipperCode = $getShipperInfo['code'];
                $shipperPhone = $getShipperInfo['mobile'];
            }
        }
        $carrierDetails = $this->ci->edi_engine->gecareerdDetails($orderId);
        if (count($carrierDetails) > 0) {
            foreach ($carrierDetails as $rf) {
                $carrierMobile = $rf->mobile;
            }
        }
        if ($orderId != '') {
            $getOrderInfo = $this->ci->Order->getordertoedit($orderId);
            if ($getOrderInfo->num_rows() > 0) {
                $customerDetails = $this->ci->common->gettblrowdata(['order_id' => $getOrderInfo->row()->order_id], 'customer_phone,customer_name,trip_sts', 'tb_orders', 0, 0);
                if (!empty($customerDetails)) {
                    $customerPhone = $customerDetails['customer_phone'];
                    $customerName = $customerDetails['customer_name'];
                }
                $getBookingCost = $this->ci->common->gettblrowdata(['order_id' => $orderId, 'type' => 1], 'amount,', 'tb_reveneus', 0, 0);
                if (!empty($getBookingCost)) {
                    $bookingAmount = $getBookingCost['amount'];
                }
                $referenceIds = ['DQ', 'Z05', 'ORD_PIKINST', 'ORD_DLVINST'];
                $getReferences = $this->ci->common->gettbldata_where_in(['order_id' => $orderId, 'status' => 1], ['col' => 'reference_id', 'arr' => $referenceIds], 'reference_id,ref_value', 'tb_order_references');
                foreach ($getReferences as $references) {
                    if ('DQ' == $references['reference_id']) {
                        $dqReferenceValue = $references['ref_value'];
                    }
                    if ('Z05' == $references['reference_id']) {
                        $z05Value = $references['ref_value'];
                    }
                    if ('ORD_PIKINST' == $references['reference_id']) {
                        $pickupInstructions = $references['ref_value'];
                    }
                    if ('ORD_DLVINST' == $references['reference_id']) {
                        $deliveryInstructions = $references['ref_value'];
                    }
                }
                $data = [
                    'order_id' => $getOrderInfo->row()->order_id,
                    'customer_phone' => $customerPhone ?? '',
                    'customer_name' => $customerName ?? '',
                    'customer_id' => $getOrderInfo->row()->customer_id,
                    'pickup_company' => $getOrderInfo->row()->pickup,
                    'created_on' => $getOrderInfo->row()->createdon,
                    'delivery_company' => $getOrderInfo->row()->delivery,
                    'complete_delivery_address' => $getOrderInfo->row()->delivery_city . ',' . $getOrderInfo->row()->delivery_address1 . ',' . $getOrderInfo->row()->delivery_pincode,
                    'cargo' => $cargos ?? [],
                    'amount' => $bookingAmount ?? 0,
                    'pickup_address1' => $getOrderInfo->row()->pickup_address1,
                    'pickup_country' => $getOrderInfo->row()->pickup_country,
                    'pickup_city' => $getOrderInfo->row()->pickup_city,
                    'pickup_zipcode' => $getOrderInfo->row()->pickup_pincode,
                    'pickup_date_time' => $pickupDateTime,
                    'pickup_date' => $pickupDate,
                    'trimmed_pickup_time' => $trimmedPickupTime,
                    'pickup_time' => $pickupTime,
                    'delivery_instructions' => $deliveryInstructions ?? '',
                    'pickup_instructions' => $pickupInstructions ?? '',
                    'consignee_phone' => $consigneePhone ?? '',
                    'consignee_email' => $consigneeEmail ?? '',
                    'shipper_phone' => $shipperPhone ?? '',
                    'carrier_mobile' => $carrierMobile ?? '',
                    'order_row_id' => $orderId,
                    'z05_value' => $z05Value ?? '',
                    'dq_reference_value' => $dqReferenceValue ?? 0,
                    'shipper_code' => $shipperCode ?? '',
                    'consignee_code' => $consigneeCode ?? '',
                    'delivery_datetime' => $deliveryDatetime,
                    'delivery_late_end_date' => $deliveryLateEndDate,
                    'delivery_late_end_time' => $deliveryLateEndTime,
                    'goods_value' => $getOrderInfo->row()->goods_value
                ];
                $this->sendXmlService($data);
            }
        }
    }

    public function sendXmlService(array $data)
    {
        $data['weight'] = $data['volume'] = $data['length'] = $data['width'] = $data['height'] = $data['quantity'] = 0;
        $data['cargo_content'] = '';
        $cargoCount = count($data['cargo']);
        $a = 1;
        foreach ($data['cargo'] as $info) {
            $b = $a++;
            $data['weight'] += $info['weight'];
            $data['volume'] += $info['volume'];
            $data['length'] += $info['length'];
            $data['width'] += $info['width'];
            $data['height'] += $info['height'];
            $data['quantity'] += $info['quantity'];
            $data['cargo_content'] .= $info['cargo_content'];
            if ($b < $cargoCount) {
                $data['cargo_content'] .= ',';
            }
        }
        $customerCode = $this->ci->Edi_common_model->getCustomercode($data['order_row_id']);
        $credentials = $this->ci->Edi_common_model->getCridencials($customerCode);
        $data['login'] = $credentials['login'];
        $data['password'] = $credentials['password'];
        $data['client_id'] = '6023b830-1b2d-11ea-80d8-00155d630100';
        $requestXml = $this->generateRequestXml($data);
        $response = rusExpressOrder($requestXml);
        if ("Error" === $response['status']) {
            $this->ci->edi_logger->log_ruexp_order(0, $requestXml, $response['result'], $data['order_id'], 2);
            return;
        }
        $xml_post_string = $response['result'];
        $plainXML = getPlainXml(trim($xml_post_string));
        $arrayResult = json_decode(json_encode(SimpleXML_Load_String($plainXML, 'SimpleXMLElement', LIBXML_NOCDATA)), true);
        $receivedReferenceValue = '';
        if (isset($arrayResult['soap_Body']['m_SaveOrderResponse']['m_return']['m_Value'])) {
            $receivedReferenceValue = $arrayResult['soap_Body']['m_SaveOrderResponse']['m_return']['m_Value'];
        } else {
            $this->ci->edi_logger->log_ruexp_order(0, $requestXml, $xml_post_string, $data['order_id'], 2);
            return;
        }
        if ('' != $receivedReferenceValue) {
            $referenceInsertData = [
                'ref_value' => $receivedReferenceValue,
                'reference_id' => 'RUCK',
                'order_id' => $data['order_row_id'],
                'createdon' => date('Y-m-d h:i:s')
            ];
            $this->ci->common->insertTableData('tb_order_references', $referenceInsertData);
            $this->ci->edi_logger->log_ruexp_order(1, $requestXml, $xml_post_string, $data['order_id'], 2);
        }
    }

    public function generateRequestXml(array $data): string
    {
        $xml = '<?xml version="1.0" encoding="UTF-8"?>';
        $xml .= '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:car="http://www.cargo3.org">';
        $xml .= '<soapenv:Header/>';
        $xml .= '<soapenv:Body>';
        $xml .= '<car:SaveOrder>';
        $xml .= '<car:Language>ru</car:Language>';
        $xml .= '<car:Login>' . $data['login'] . '</car:Login>';
        $xml .= '<car:Password>' . $data['password'] . '</car:Password>';
        $xml .= '<car:Company>this</car:Company>';
        $xml .= '<car:Number></car:Number>';
        $xml .= '<car:ClientNumber>' . $data['dq_reference_value'] . '</car:ClientNumber>';
        $xml .= '<car:OrderData>';
        $xml .= '<car:Client>' . $data['client_id'] . '</car:Client>';
        $xml .= '<car:Contract>Договор  № ' . $data['carrier_mobile'] . ' от ' . $data['created_on'] . '</car:Contract>';
        $xml .= '<car:CreateDate>' . $data['created_on'] . '</car:CreateDate>';
        $xml .= '<car:DeliveryDate>' . $data['delivery_late_end_date'] . 'T' . $data['delivery_late_end_time'] . '</car:DeliveryDate>';
        $xml .= '<car:DeliveryMethod>e45b6d73-fd62-44da-82a6-44eb4d1d9490</car:DeliveryMethod>';
        $xml .= '<car:Department></car:Department>';
        $xml .= '<car:Office>ef628d6e-9ff1-11e4-9fac-74f06d814833</car:Office>';
        $xml .= '<car:Official></car:Official>';
        $xml .= '<car:Recipient>';
        $xml .= '<car:Client>' . $data['delivery_company'] . '</car:Client>';
        $xml .= '<car:Official></car:Official>';
        $xml .= '<car:Address>';
        $xml .= '<car:Geography>' . $data['consignee_code'] . ' </car:Geography>';
        $xml .= '<car:Info>' . $data['complete_delivery_address'] . '</car:Info>';
        $xml .= '<car:Comment></car:Comment>';
        $xml .= '<car:FreeForm>true</car:FreeForm>';
        $xml .= '</car:Address>';
        $xml .= '<car:SubwayStation></car:SubwayStation>';
        $xml .= '<car:Phone>' . $data['consignee_phone'];
        if ('' != $data['z05_value']) {
            $xml .= ',' . $data['z05_value'] . '</car:Phone>';
        } else {
            $xml .= '</car:Phone>';
        }
        $xml .= '<car:EMail>' . $data['consignee_email'] . '</car:EMail>';
        $xml .= '<car:Info>' . $data['delivery_instructions'] . '</car:Info>';
        $xml .= '<car:Urgency>18c4f209-458b-11dc-9497-0015170f8c09</car:Urgency>';
        $xml .= '<car:Cargo>';
        $xml .= '<car:CargoDescription>' . $data['cargo_content'] . '</car:CargoDescription>';
        $xml .= '<car:CargoPackageQty>' . $data['quantity'] . '</car:CargoPackageQty>';
        $xml .= '<car:Weight>' . $data['weight'] . '</car:Weight>';
        $xml .= '<car:VolumeWeight>0</car:VolumeWeight>';
        $xml .= '<car:Length>' . $data['volume'] . '</car:Length>';
        $xml .= '<car:Width>1</car:Width>';
        $xml .= '<car:Height>1</car:Height>';
        $xml .= '<car:InsuranceRate>0</car:InsuranceRate>';
        $xml .= '<car:DeclaredValueRate>' . $data['goods_value'] . '</car:DeclaredValueRate>';
        $xml .= '</car:Cargo></car:Recipient>';
        $xml .= '<car:ReplyEMail></car:ReplyEMail>';
        $xml .= '<car:ReplySMSPhone></car:ReplySMSPhone>';
        $xml .= '<car:Sender>';
        $xml .= '<car:Client>' . $data['pickup_company'] . '</car:Client>';
        $xml .= '<car:Official></car:Official>';
        $xml .= '<car:Address>';
        $xml .= '<car:Geography>' . $data['shipper_code'] . '</car:Geography>';
        $xml .= '<car:Info>' . $data['pickup_city'] . ', ' . $data['pickup_address1'] . ',' . $data['pickup_zipcode'] . '</car:Info>';
        $xml .= '<car:Comment></car:Comment>';
        $xml .= '<car:FreeForm>true</car:FreeForm>';
        $xml .= '</car:Address>';
        $xml .= '<car:SubwayStation></car:SubwayStation>';
        $xml .= '<car:Phone>' . $data['shipper_phone'] . '</car:Phone>';
        $xml .= '<car:EMail></car:EMail>';
        $xml .= '<car:Info>' . $data['pickup_instructions'] . '</car:Info>';
        $xml .= '</car:Sender>';
        $xml .= '<car:TakeDate>' . $data['pickup_date'] . 'T' . $data['pickup_time'] . '</car:TakeDate>';
        $xml .= '<car:TakeTime>' . $data['trimmed_pickup_time'] . '</car:TakeTime>';
        $xml .= '<car:TypeOfCargo>4aab1fc6-fc2b-473a-8728-58bcd4ff79ba</car:TypeOfCargo>';
        $xml .= '<car:TypeOfPayer>0</car:TypeOfPayer>';
        $xml .= '<car:WayOfPayment>1</car:WayOfPayment>';
        $xml .= '<car:WithReturn>false</car:WithReturn>';
        $xml .= '</car:OrderData>';
        $xml .= '</car:SaveOrder>';
        $xml .= '</soapenv:Body>';
        $xml .= '</soapenv:Envelope>';
        return $xml;
    }

}
