<?php

class OrdersCo2Update
{
    private $ci;

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->library('calculateDistanceByOrderId');
    }

    public function updateOrdersCo2Information(array $orderInfo): string
    {
        $ci = &get_instance();
        try {
            foreach ($orderInfo as $order) {
                $plannedDistance = $ci->calculatedistancebyorderid->findPlannedDistanceByOrderId($order['order_id']);
                $actualDistance = $ci->calculatedistancebyorderid->findActualDistanceByOrderId($order['order_id']);
                $fuel_consumption = $order['fuel_consumption'];
                $ltl_ftl_utilization = 1;
                $ftlSercies = ['Full Truck Load', 'FTL', 'FTL Full Truck Load'];
                if (in_array($order['servicename'], $ftlSercies)) {
                    $ltl_ftl_utilization = ceil($order['weight'] / 24000);
                } else {
                    $ltl_ftl_utilization = ceil($order['weight'] / 19999);
                }
                $plannedDistanceValues = explode(" ", $plannedDistance);
                $plannedDistance = (float)(strtolower($plannedDistanceValues[1]) == "m" ? ($plannedDistanceValues[0] / 1000) : $plannedDistanceValues[0]);

                $actualDistanceValues = explode(" ", $actualDistance);
                $actualDistance = (float)(strtolower($actualDistanceValues[1]) == "m" ? ($actualDistanceValues[0] / 1000) : $actualDistanceValues[0]);

                $distance = $actualDistance == "0" ? $plannedDistance : $actualDistance;

                log_message("error", "Distance: " . $distance . " For Order: " . $order['id']);
                $co2kg_ttw = ((((float)$distance / 100) *
                        (((float)$fuel_consumption * (100 + (float)$order['distance_deviation_factor'])) / 100) *
                        ((float)$order['co2_ttw'])) * (float)$ltl_ftl_utilization);
                $co2kg_ttw = (((float)$co2kg_ttw * (100 + (float)$order['temp_regime_value'])) / 100);
                $co2kg_ttw = number_format((float)$co2kg_ttw, 2, '.', '');
                log_message("error", "co2kg_ttw: " . $co2kg_ttw . " For Order: " . $order['id']);

                $co2kg_wtw = ((((float)$distance / 100) *
                        (((float)$fuel_consumption * (100 + (float)$order['distance_deviation_factor'])) / 100) *
                        ((float)$order['co2_wtw'])) * (float)$ltl_ftl_utilization);
                $co2kg_wtw = (((float)$co2kg_wtw * (100 + (float)$order['temp_regime_value'])) / 100);
                $co2kg_wtw = number_format((float)$co2kg_wtw, 2, '.', '');
                log_message("error", "co2kg_wtw: " . $co2kg_wtw . " For Order: " . $order['id']);

                $co2eqkg_ttw = ((((float)$distance / 100) *
                        (((float)$fuel_consumption * (100 + (float)$order['distance_deviation_factor'])) / 100) *
                        ((float)$order['co2e_ttw'])) * (float)$ltl_ftl_utilization);
                $co2eqkg_ttw = (((float)$co2eqkg_ttw * (100 + (float)$order['temp_regime_value'])) / 100);
                $co2eqkg_ttw = number_format((float)$co2eqkg_ttw, 2, '.', '');
                log_message("error", "co2eqkg_ttw: " . $co2eqkg_ttw . " For Order: " . $order['id']);

                $co2eqkg_wtw = ((((float)$distance / 100) *
                        (((float)$fuel_consumption * (100 + (float)$order['distance_deviation_factor'])) / 100) *
                        ((float)$order['co2e_wtw'])) * (float)$ltl_ftl_utilization);
                $co2eqkg_wtw = (((float)$co2eqkg_wtw * (100 + (float)$order['temp_regime_value'])) / 100);
                $co2eqkg_wtw = number_format((float)$co2eqkg_wtw, 2, '.', '');
                log_message("error", "co2eqkg_wtw: " . $co2eqkg_wtw . " For Order: " . $order['id']);
                $orderCo2Reeport = [
                    'order_id' => $order['id'],
                    'pickup_location_id' => $order['pickup_custid'],
                    'delivery_location_id' => $order['drop_custid'],
                    'customer_id' => $order['customer_id'],
                    'order_truck_type' => $order['vehicle_type'],
                    'order_actual_weight' => $order['weight'],
                    'temp_controlled' => $order['temp_regime_type'],
                    'transport_mode' => $order['transport_mode'],
                    'order_service' => $order['servicename'],
                    'planned_travel_distance' => $plannedDistance,
                    'actual_travel_distance' => $actualDistance,
                    'fuel_consumption' => $fuel_consumption,
                    'distance_deviation_factor' => $order['distance_deviation_factor'],
                    'ltl_ftl_utilization' => $ltl_ftl_utilization,
                    'co2kg_ttw' => $co2kg_ttw,
                    'co2kg_wtw' => $co2kg_wtw,
                    'co2eqkg_ttw' => $co2eqkg_ttw,
                    'co2eqkg_wtw' => $co2eqkg_wtw,
                    'company_code' => $order['company_code'],
                    'bracnh_code' => $order['branch_code'],
                    'department_code' => $order['department_code'],
                    'user_id' => $order['user_id'],
                    'order_created_date' => $order['createdon'],
                ];
                $checkCo2Report = $ci->common->gettblrowdata(['order_id' => $order['id']], "id", "tb_co2_orders", 0, 0);
                if (count($checkCo2Report) > 0) {
                    $ci->common->updatetbledata("tb_co2_orders", $orderCo2Reeport, ['id' => $checkCo2Report['id']]);
                } else {
                    $ci->common->insertTableData("tb_co2_orders", $orderCo2Reeport);
                }
            }
            $response = "Success";
        } catch (Exception $ex) {
            $response = "fail";
            log_message("error", "Some Problem occured!, While updating the CO2 Report " . $ex->getMessage());
        }
        return $response;
    }


}
