<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Orderstatusretriggertoedi214
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->library("Altovaordercreation");
        $this->ci->load->model(['common', 'Order']);
    }

    public function retriggeredPreviousStatus(int $order_id): void
    {
        $getOrderDetails = $this->ci->common->gettblrowdata(['id' => $order_id], "id,order_id,customer_id", "tb_orders", 0, 0);
        if (!checkAccessConditions('CHECK_STATUS_RETRIGGER_CUSTOMER', $getOrderDetails['customer_id'])) {
            log_message("error", "Customer Does not have Permission to Retrigger the Old Status: " . $getOrderDetails['order_id']);
            return;
        }
        $orderIds[] = $order_id;
        $getOrderStatuses = $this->ci->Order->getOrderDetailsWithStopsStatus($orderIds);
        foreach ($getOrderStatuses as $orderStatus) {
            $this->ci->altovaordercreation->sendOrderToAltova($orderStatus['order_id'], $orderStatus['status_code']);
        }
    }
}
