<?php

class OtmTripHandlerNew
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance(); //
        $this->ci->load->model(['common', 'otmTripModel', 'otmBookingModel']);
        $this->ci->load->library(['otmordershipmenthandler','standardtriphandler']);
    }

    public function getOtmShipmentData(string $data): string
    {
        log_message("ERROR", "Trip Request:" . $data);
        $xml = simplexml_load_string($data);
        $gLogElement = $xml->xpath('/Transmission/TransmissionBody/GLogXMLElement');
        $plannedShipment = $gLogElement[0]->xpath('PlannedShipment/Shipment');
        // $domainName = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/DomainName')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/DomainName')[0];
        $domainName = "DEMO/INFND";
        $tripId = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/Xid')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/Xid')[0];
        $organizationAry = $this->getOrganizationInfo($domainName);
        $locationAry = $plannedShipment[0]->xpath('Location');
        $tripInfoAry = $this->getTripInfo($plannedShipment);
        //$carrierAry = $this->getCarrierInfo($locationAry);
        $carrierAry = $this->getCarrierInfo($plannedShipment, $locationAry);
        $tripSourceLocationRef = $plannedShipment[0]->xpath('ShipmentHeader/SourceLocationRef');
        $tripSourceAry = $this->getTripSourceLocationInfo($tripSourceLocationRef, $locationAry);
        $tripDestinationLocationRef = $plannedShipment[0]->xpath('ShipmentHeader/DestinationLocationRef');
        $tripDestinationAry = $this->getTripDestinationLocationInfo($tripDestinationLocationRef, $locationAry);
        $tripDestinationInfo = $consigneeInvolvedPartyTripInfo = "";
        $tripDatesAry = $this->getTripDates($plannedShipment);
        if (!empty($tripDestinationLocationRef)) {
            $tripDestinationAry = $this->getTripDestinationLocationInfo($tripDestinationLocationRef, $locationAry);
            $tripDestinationInfo = $this->setTripDestinationLocationInfo($tripDestinationAry, $tripDatesAry, 'N');
            $consigneeInvolvedPartyTripInfo = $this->setTripDestinationLocationInfo($tripDestinationAry, $tripDatesAry, 'Y');
        }
        $vehicleTripAry = $this->getVehicleInfo($plannedShipment);
        //$driverAry = $this->getDriverInfo($gLogElement);
        $cargoSummaryTripAry = $this->getCargoSummaryTripInfo($plannedShipment);
        $tripAddonsAry = $this->getTripAddonsInfo($plannedShipment);
        $tripReferencesAry = $this->getTripManageReferences($plannedShipment);
        $tripRemarksAry = $this->getTripRemarks($plannedShipment);
        $shipmentStopsAry = $this->getShipmentStops($plannedShipment, $locationAry);
        $tripInvolvedPartiesAry = $this->getTripInvolvedParties($plannedShipment);

        $tripInfo = $this->setTripInfo($tripInfoAry);
        $carrierInfo = $this->setCarrierInfo($carrierAry, 'N');
        $tripSourceInfo = $this->setTripSourceLocationInfo($tripSourceAry, $tripDatesAry, 'N');
        $tripDatesInfo = $this->setTripDates($tripDatesAry);
        $vehicleInfo = $this->setVehicleInfo($vehicleTripAry);
        $driverAry = [];
        $driverInfo = $this->setDriverInfo($organizationAry, $driverAry);
        $cargoSummaryTripInfo = $this->setCargoSummaryTripInfo($cargoSummaryTripAry);
        $addonsTripInfo = $this->setTripAddonsInfo($tripAddonsAry);
        //$tripReferencesInfo = $this->setManageReferences($tripReferencesAry, $tripId);
        $tripRemarksInfo = $this->setRemarks($tripRemarksAry);
        $shipmentStopsInfo = $this->setShipmentStops($shipmentStopsAry);
        $carrierInvolvedPartyTripInfo = $this->setCarrierInfo($carrierAry, 'Y');
        //$shipperInvolvedPartyTripInfo = $this->setTripSourceLocationInfo($tripSourceAry, 'Y');
        log_message("error", "tripInvolvedPartiesAry:" . json_encode($tripInvolvedPartiesAry));
        $tripInvolvedPartiesInfo = $this->setTripInvolvedPartiesInfo($tripInvolvedPartiesAry, $tripSourceAry, $tripDestinationAry);

        $tripDetails = '<TripHeader>' . $tripInfo . $carrierInfo . '<TripLocation>' . $tripSourceInfo . $tripDestinationInfo . '</TripLocation>' /*. $tripDatesInfo . $shipmentStopsInfo*/ . $vehicleInfo . $driverInfo . $cargoSummaryTripInfo . /*$addonsTripInfo . '<BusinessParties>' . $carrierInvolvedPartyTripInfo . $tripInvolvedPartiesInfo . '</BusinessParties>' .*/ /*$tripReferencesInfo . $tripRemarksInfo .*/ '</TripHeader>';

        $releaseAry = $plannedShipment[0]->xpath('Release');
        $tripOrderDetails = "";

        foreach ($releaseAry as $release) {
            $bookingId = empty($release[0]->xpath('ReleaseGid/Gid/Xid')) ? 0 : (string) $release[0]->xpath('ReleaseGid/Gid/Xid')[0];
            $orderMovementId = empty($release[0]->xpath('OrderMovement/OrderMovementD/ShipUnitGid/Gid/Xid')) ? "" : (string) $release[0]->xpath('OrderMovement/OrderMovementD/ShipUnitGid/Gid/Xid')[0];
            if ($orderMovementId == "") {
                $orderMovementId = empty($release[0]->xpath('OrderMovement/OrderMovementD/ShipUnit/ShipUnitGid/Gid/Xid')) ? 0 : (string) $release[0]->xpath('OrderMovement/OrderMovementD/ShipUnit/ShipUnitGid/Gid/Xid')[0];
            }
            $orderType = $modeOfTransport = "DEFAULT";
            if (!empty($release[0]->xpath('Release/ReleaseTypeGid/Gid/Xid')[0])) {
                $orderType = empty((string) $release[0]->xpath('Release/ReleaseTypeGid/Gid/Xid')[0]) ? "DEFAULT" : (string) $release[0]->xpath('Release/ReleaseTypeGid/Gid/Xid')[0];
            }
            if (!empty($release[0]->xpath('Release/ReleaseHeader/TransportModeGid/Gid/Xid')[0])) {
                $modeOfTransport = empty((string) $release[0]->xpath('Release/ReleaseHeader/TransportModeGid/Gid/Xid')[0]) ? "DEFAULT" : (string) $release[0]->xpath('Release/ReleaseHeader/TransportModeGid/Gid/Xid')[0];
            }
            $customerAry = $this->getCustomerInfo($organizationAry, $domainName);
            $shipFromLocationRef = $release->xpath('ShipFromLocationRef');
            $sourceAry = $this->getShipFromLocationInfo($shipFromLocationRef, $locationAry);
            $shipToLocationRef = $release->xpath('ShipToLocationRef');
            $destinationAry = $this->getShipToLocationInfo($shipToLocationRef, $locationAry);
            $cargoSummaryAry = $this->getCargoSummary($release[0]->xpath('TotalWeightVolume'), $release[0]->xpath('TotalPackagedItemCount'));
            $outerCargos = $this->getShipUnitInfo($release[0]->xpath('ReleaseLine'), $release[0]->xpath('ShipUnit'));
            /*$outerReleaseCargos = $this->getReleaseLineInfo($release[0]->xpath('ReleaseLine'), $release[0]->xpath('ShipUnit'));*/
            $referencesAry = $this->getManageReferences($release[0]->xpath('ReleaseRefnum'));
            $remarksAry = $this->getRemarks($release[0]->xpath('Remark'));
            $timeWindowAry = $this->getTimeWindow($release[0]->xpath('TimeWindow'));
            $involvedPartiesAry = $this->getInvolvedParties($release[0]->xpath('InvolvedParty'));

            $headerInfo = $this->setHeaderInfo();
            //$customerInfo = $this->setCustomerInfo($customerAry, 'N');
            $organizationInfo = $this->setOrganizationInfo($organizationAry, $domainName);

            $bookingHeaderInfo = $this->setBookingHeaderInfo($bookingId, $orderMovementId, $orderType, $modeOfTransport);
            /*$sourceInfo = $this->setShipFromLocationInfo($sourceAry, 'N');
            $destinationInfo = $this->setShipToLocationInfo($destinationAry, 'N');*/
            $customerInfo = $this->setCustomerInfo($involvedPartiesAry);
            $sourceInfo = $this->setShipFromLocationInfo($sourceAry, $timeWindowAry);
            $destinationInfo = $this->setShipToLocationInfo($destinationAry, $timeWindowAry);
            $cargoSummaryInfo = $this->setCargoSummaryInfo($cargoSummaryAry);
            $outerCargosInfo = $this->setShipUnitInfo($outerCargos);
            /*$outerReleaseCargosInfo = $this->setReleaseLineInfo($outerReleaseCargos);*/
            $addonsInfo = $this->setAddonsInfo();
            //$customerInvolvedPartyInfo = $this->setCustomerInfo($customerAry, 'Y');
            //$shipperInvolvedPartyInfo = $this->setShipFromLocationInfo($sourceAry, 'Y');
            //$consigneeInvolvedPartyInfo = $this->setShipToLocationInfo($destinationAry, 'Y');
            $referencesInfo = $this->setManageReferences($referencesAry, $tripReferencesAry, $bookingId, $tripId);
            $remarksInfo = $this->setRemarks($remarksAry);
            $involvedPartiesInfo = $this->setInvolvedPartiesInfo($involvedPartiesAry, $sourceAry, $destinationAry);

            $tripOrderDetails .= '<TripOrderDetails>' . $bookingHeaderInfo . $customerInfo . $cargoSummaryInfo . '<LocationInfo>' . $sourceInfo . $destinationInfo . '</LocationInfo>' . '<CargoDetails>' . $outerCargosInfo . /* $outerReleaseCargosInfo .*/'</CargoDetails>' . $addonsInfo . '<InvolvedParties>' . $involvedPartiesInfo/*$customerInvolvedPartyInfo . $shipperInvolvedPartyInfo . $consigneeInvolvedPartyInfo*/ . '</InvolvedParties>' . $referencesInfo . $remarksInfo . '</TripOrderDetails>';
        }

        $tripXML = '<SVKEDIMessage>' . $headerInfo . '<SVKEDITripBody>' . $organizationInfo . '<TripDetails>' . $tripDetails . $tripOrderDetails . '</TripDetails></SVKEDITripBody></SVKEDIMessage>';
        print_r($tripXML);
        log_message("ERROR", "Trip XML:" . print_r($tripXML, true));
        $tripXML = json_decode(
            json_encode(simplexml_load_string($tripXML, "SimpleXMLElement", LIBXML_NOCDATA)),
            true,
            512,
            JSON_THROW_ON_ERROR
        );
        
        $response = "";
      
        /*$response = $this->ci->otmordershipmenthandler->pullTripOrderXml($tripXML);*/

        // $ediInfo = [
        //     'edi_type' => "OTM",
        //     'edi_name' => "Planned Shipment",
        //     'edi_format' => "XML",
        //     'transaction_id' => $tripId,
        //     'edi_request' => $data,
        //     'edi_response' => $response,
        //     'org_id' => $organizationAry['organizationId'],
        //     'business_entity_id' => $organizationAry['businessEntityValue'],
        // ];
        // $this->ci->common->insertTableData('tb_edi_logs', $ediInfo);
        return $response;
    }

    public function getOrganizationInfo(string $domainName): array
    {
        $organizationId = $businessEntityValue = "";
        $orgDetails = $this->ci->otmTripModel->getOrganizationInfo($domainName);
        if (count($orgDetails) > 0) {
            $organizationId = $orgDetails['organization_name'];
            $businessEntityValue = $orgDetails['business_entity_value'];
        }
        $organizationAry = [
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue,
        ];
        return $organizationAry;
    }

    public function getTripInfo(array $plannedShipment): array
    {
        $bookingId = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/Xid')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/Xid')[0];
        $modeOfTransport = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/TransportModeGid/Gid/Xid')[0]) ? "DEFAULT" : (string) $plannedShipment[0]->xpath('ShipmentHeader/TransportModeGid/Gid/Xid')[0];
        $tripType = "DEFAULT";
        if (!empty($plannedShipment[0]->xpath('ShipmentHeader2/ShipmentTypeGid'))) {
            $tripType = empty((string) $plannedShipment[0]->xpath('ShipmentHeader2/ShipmentTypeGid/Gid/Xid')[0]) ? "DEFAULT" : (string) $plannedShipment[0]->xpath('ShipmentHeader2/ShipmentTypeGid/Gid/Xid')[0];
        }
        $tripInfoAry = [
            'bookingId' => $bookingId,
            'modeOfTransport' => $modeOfTransport,
            'tripType' => $tripType,
        ];
        return $tripInfoAry;
    }

    public function getCarrierInfo(array $plannedShipment, array $locationAry): array
    {
        $serviceProviderId = empty($plannedShipment[0]->xpath('ShipmentHeader/PlannedShipmentInfo/ServiceProviderGid')) ? '' : $plannedShipment[0]->xpath('ShipmentHeader/PlannedShipmentInfo/ServiceProviderGid/Gid/Xid')[0];
        if ($serviceProviderId == "") {
            $serviceProviderId = empty($plannedShipment[0]->xpath('ShipmentHeader/ServiceProviderGid')) ? '' : $plannedShipment[0]->xpath('ShipmentHeader/ServiceProviderGid/Gid/Xid')[0];
        }
        $carrierLocationName = $carrierProvince = $carrierCity = $carrierProvinceCode = $carrierPostalCode = $carrierCountryCode = $carrierLatitude = $carrierLongitude = "";
        $carrierAry = $carrierAddressAry = [];
        foreach ($locationAry as $location) {
            $locationRoleXid = (string) $location[0]->xpath('LocationRole/LocationRoleGid/Gid/Xid')[0];

            if (strtoupper($locationRoleXid) == "CARRIER") {
                if ($serviceProviderId == "") {
                    $carrierLocationName = empty($location[0]->xpath('LocationName')) ? 0 : $location[0]->xpath('LocationName')[0][0];
                } else {
                    $carrierLocationName = $serviceProviderId;
                }
                $carrierAddress = empty($location[0]->xpath('Address/AddressLines')) ? [] : $location[0]->xpath('Address/AddressLines');
                foreach ($carrierAddress as $fromAddress) {
                    $address = empty($fromAddress->xpath('AddressLine')[0]) ? "" : $fromAddress->xpath('AddressLine')[0];
                    array_push($carrierAddressAry, $address);
                }
                $carrierCity = empty($location[0]->xpath('Address/City')) ? 0 : (string) $location[0]->xpath('Address/City')[0];
                $carrierProvince = empty($location[0]->xpath('Address/Province')) ? 0 : (string) $location[0]->xpath('Address/Province')[0];
                $carrierProvinceCode = empty($location[0]->xpath('Address/ProvinceCode')) ? 0 : (string) $location[0]->xpath('Address/ProvinceCode')[0];
                $carrierPostalCode = empty($location[0]->xpath('Address/PostalCode')) ? 0 : (string) $location[0]->xpath('Address/PostalCode')[0];
                $carrierCountryCode = empty($location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')) ? 0 : (string) $location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')[0];
                $carrierLatitude = empty($location[0]->xpath('Address/Latitude')) ? 0 : (string) $location[0]->xpath('Address/Latitude')[0];
                $carrierLongitude = empty($location[0]->xpath('Address/Longitude')) ? 0 : (string) $location[0]->xpath('Address/Longitude')[0];
                $carrierAry = [
                    'carrierLocationName' => $carrierLocationName,
                    'carrierAddressAry' => $carrierAddressAry,
                    'carrierCity' => $carrierCity,
                    'carrierProvince' => $carrierProvince,
                    'carrierProvinceCode' => $carrierProvinceCode,
                    'carrierPostalCode' => $carrierPostalCode,
                    'carrierCountryCode' => $carrierCountryCode,
                    'carrierLatitude' => $carrierLatitude,
                    'carrierLongitude' => $carrierLongitude,
                ];
            }
        }

        if (empty($carrierAry)) {
            $involvedParties = empty($plannedShipment[0]->xpath('ShipmentHeader/InvolvedParty')) ? [] : $plannedShipment[0]->xpath('ShipmentHeader/InvolvedParty');
            $involvedPartiesAry = [];
            foreach ($involvedParties as $involvedParty) {
                $partyType = empty((string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0]) ? "" : (string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0];
                $id = empty($involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')[0];
                $email = empty($involvedParty->xpath('ContactRef/Contact/EmailAddress')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/EmailAddress')[0];
                $firstName = empty($involvedParty->xpath('ContactRef/Contact/FirstName')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/FirstName')[0];
                $phone = empty($involvedParty->xpath('ContactRef/Contact/Phone1')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/Phone1')[0];
                $parties = [];
                if ($partyType == "CARRIER") {
                    $carrierAry = [
                        'carrierLocationName' => $id,
                        'carrierAddressAry' => $carrierAddressAry,
                        'carrierCity' => $carrierCity,
                        'carrierProvince' => $carrierProvince,
                        'carrierProvinceCode' => $carrierProvinceCode,
                        'carrierPostalCode' => $carrierPostalCode,
                        'carrierCountryCode' => $carrierCountryCode,
                        'carrierLatitude' => $carrierLatitude,
                        'carrierLongitude' => $carrierLongitude,
                    ];
                }
            }

            if (empty($carrierAry)) {
                $carrierAry = [
                    'carrierLocationName' => 'ALL',
                    'carrierAddressAry' => $carrierAddressAry,
                    'carrierCity' => $carrierCity,
                    'carrierProvince' => $carrierProvince,
                    'carrierProvinceCode' => $carrierProvinceCode,
                    'carrierPostalCode' => $carrierPostalCode,
                    'carrierCountryCode' => $carrierCountryCode,
                    'carrierLatitude' => $carrierLatitude,
                    'carrierLongitude' => $carrierLongitude,
                ];
            }
        }
        return $carrierAry;
    }

    /*public function getCarrierInfo(array $locationAry): array
    {
    $carrierLocationName = $carrierProvince = $carrierCity = $carrierProvinceCode = $carrierPostalCode = $carrierCountryCode = $carrierLatitude = $carrierLongitude = "";
    $carrierAry = $carrierAddressAry = [];
    foreach ($locationAry as $location)
    {
    $locationRoleXid = (string)$location[0]->xpath('LocationRole/LocationRoleGid/Gid/Xid')[0];
    if(strtoupper($locationRoleXid) == "CARRIER")
    {
    $carrierLocationName = empty($location[0]->xpath('LocationName')) ? 0 : (string)$location[0]->xpath('LocationName')[0];
    $carrierAddress = empty($location[0]->xpath('Address/AddressLines')) ? [] : $location[0]->xpath('Address/AddressLines');
    foreach ($carrierAddress as $fromAddress)
    {
    $address = empty($fromAddress->xpath('AddressLine')[0]) ? "" : $fromAddress->xpath('AddressLine')[0];
    array_push($carrierAddressAry ,$address);
    }
    $carrierCity = empty($location[0]->xpath('Address/City')) ? 0 : (string)$location[0]->xpath('Address/City')[0];
    $carrierProvince = empty($location[0]->xpath('Address/Province')) ? 0 : (string)$location[0]->xpath('Address/Province')[0];
    $carrierProvinceCode = empty($location[0]->xpath('Address/ProvinceCode')) ? 0 : (string)$location[0]->xpath('Address/ProvinceCode')[0];
    $carrierPostalCode = empty($location[0]->xpath('Address/PostalCode')) ? 0 : (string)$location[0]->xpath('Address/PostalCode')[0];
    $carrierCountryCode = empty($location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')) ? 0 : (string)$location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')[0];
    $carrierLatitude = empty($location[0]->xpath('Address/Latitude')) ? 0 : (string)$location[0]->xpath('Address/Latitude')[0];
    $carrierLongitude = empty($location[0]->xpath('Address/Longitude')) ? 0 : (string)$location[0]->xpath('Address/Longitude')[0];
    }
    $carrierAry = [
    'carrierLocationName' => $carrierLocationName,
    'carrierAddressAry' => $carrierAddressAry,
    'carrierCity' => $carrierCity,
    'carrierProvince' => $carrierProvince,
    'carrierProvinceCode' => $carrierProvinceCode,
    'carrierPostalCode' => $carrierPostalCode,
    'carrierCountryCode' => $carrierCountryCode,
    'carrierLatitude' => $carrierLatitude,
    'carrierLongitude' => $carrierLongitude,
    ];
    }
    return $carrierAry;
    }*/

    public function getVehicleInfo(array $plannedShipment): array
    {
        $vehicleTripAry = [];
        $externalId = empty($plannedShipment[0]->xpath('SEquipment/Gid/Xid')) ? '0' : $plannedShipment[0]->xpath('SEquipment/Gid/Xid');
        $truckName = empty($plannedShipment[0]->xpath('SEquipment/EquipmentGroupGid/Gid/Xid')) ? '0' : $plannedShipment[0]->xpath('SEquipment/EquipmentGroupGid/Gid/Xid');
        $totalVolumeValue = $totalVolumeUOM = "";
        if (!empty($plannedShipment[0]->xpath('SEquipment/LoadConfigVolume/Volume'))) {
            $totalVolume = $plannedShipment[0]->xpath('SEquipment/LoadConfigVolume/Volume');
            $totalVolumeValue = empty($totalVolume[0]->xpath('VolumeValue')) ? 0 : (string) $totalVolume[0]->xpath('VolumeValue')[0];
            $totalVolumeUOM = empty($totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')) ? 0 : (string) $totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')[0];
        }

        $vehicleTripAry = [
            'externalId' => $externalId,
            'truckName' => $truckName,
            'totalVolumeValue' => $totalVolumeValue,
            'totalVolumeUOM' => $totalVolumeUOM,
        ];
        return $vehicleTripAry;
    }

    public function getDriverInfo(string $domainName): array
    {
        $customerId = $customerName = $registrationNumber = $address1 = $address2 = $street = "";
        $province = $city = $state = $postal = $country = $latitude = $longitude = "";
        $countryCode = $contactNo = $emailAddress = "";
        $customerDetails = $this->ci->otmTripModel->getCustomerInfo($organizationAry, $domainName);
        if ($customerDetails->num_rows() > 0) {
            $customerId = $customerDetails->row()->customer_code;
            $customerName = $customerDetails->row()->name;
            $registrationNumber = $customerDetails->row()->customer_code;
            $address1 = $customerDetails->row()->street1;
            $address2 = $customerDetails->row()->street2;
            $street = $customerDetails->row()->street3;
            $province = $customerDetails->row()->province;
            $city = $customerDetails->row()->city;
            $state = $customerDetails->row()->province;
            $postal = $customerDetails->row()->zipcode;
            $country = $customerDetails->row()->country;
            $latitude = $customerDetails->row()->latitude;
            $longitude = $customerDetails->row()->longitude;
            $countryCode = $customerDetails->row()->country;
            $contactNo = $customerDetails->row()->phone;
            $emailAddress = $customerDetails->row()->email;
        }

        $customerAry = [
            'customerId' => $customerId,
            'customerName' => $customerName,
            'registrationNumber' => $registrationNumber,
            'address1' => $address1,
            'address2' => $address2,
            'street' => $street,
            'province' => $province,
            'city' => $city,
            'state' => $state,
            'postal' => $postal,
            'country' => $country,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'countryCode' => $countryCode,
            'contactNo' => $contactNo,
            'emailAddress' => $emailAddress,
        ];
        return $customerAry;
    }

    public function getTripSourceLocationInfo(array $tripSourceLocationRef, array $locationAry): array
    {
        $tripSourceLocationXid = (string) $tripSourceLocationRef[0]->xpath('LocationRef/LocationGid/Gid/Xid')[0];
        $tripSourceLocationName = $tripSourceAddressAry = $tripSourceCity = $tripSourceProvince = $tripSourceProvinceCode = "";
        $tripSourcePostalCode = $tripSourceCountryCode = $tripSourceLatitude = $tripSourceLongitude = "";
        foreach ($locationAry as $location) {
            $locationXid = (string) $location[0]->xpath('LocationGid/Gid/Xid')[0];
            $sourceAry = [];

            if ($locationXid == $tripSourceLocationXid) {
                $tripSourceLocationName = empty($location[0]->xpath('LocationName')) ? 0 : (string) $location[0]->xpath('LocationName')[0];
                $tripSourceAddress = empty($location[0]->xpath('Address/AddressLines')) ? [] : $location[0]->xpath('Address/AddressLines');
                $tripSourceAddressAry = [];
                foreach ($tripSourceAddress as $fromAddress) {
                    $address = empty($fromAddress->xpath('AddressLine')[0]) ? "" : $fromAddress->xpath('AddressLine')[0];
                    array_push($tripSourceAddressAry, $address);
                }
                $tripSourceCity = empty($location[0]->xpath('Address/City')) ? 0 : (string) $location[0]->xpath('Address/City')[0];
                $tripSourceProvince = empty($location[0]->xpath('Address/Province')) ? 0 : (string) $location[0]->xpath('Address/Province')[0];
                $tripSourceProvinceCode = empty($location[0]->xpath('Address/ProvinceCode')) ? 0 : (string) $location[0]->xpath('Address/ProvinceCode')[0];
                $tripSourcePostalCode = empty($location[0]->xpath('Address/PostalCode')) ? 0 : (string) $location[0]->xpath('Address/PostalCode')[0];
                $tripSourceCountryCode = empty($location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')) ? 0 : (string) $location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')[0];
                $tripSourceLatitude = empty($location[0]->xpath('Address/Latitude')) ? 0 : (string) $location[0]->xpath('Address/Latitude')[0];
                $tripSourceLongitude = empty($location[0]->xpath('Address/Longitude')) ? 0 : (string) $location[0]->xpath('Address/Longitude')[0];
            }
            $sourceAry = [
                'tripSourceLocationId' => $tripSourceLocationXid,
                'tripSourceLocationName' => $tripSourceLocationName,
                'tripSourceAddressAry' => $tripSourceAddressAry,
                'tripSourceCity' => $tripSourceCity,
                'tripSourceProvince' => $tripSourceProvince,
                'tripSourceProvinceCode' => $tripSourceProvinceCode,
                'tripSourcePostalCode' => $tripSourcePostalCode,
                'tripSourceCountryCode' => $tripSourceCountryCode,
                'tripSourceLatitude' => $tripSourceLatitude,
                'tripSourceLongitude' => $tripSourceLongitude,
            ];
        }
        return $sourceAry;
    }

    public function getTripDestinationLocationInfo(array $tripDestinationLocationRef, array $locationAry): array
    {
        $tripDestinationLocationXid = (string) $tripDestinationLocationRef[0]->xpath('LocationRef/LocationGid/Gid/Xid')[0];
        $tripDestinationLocationName = $tripDestinationAddressAry = $tripDestinationCity = $tripDestinationProvince = $tripDestinationProvinceCode = "";
        $tripDestinationPostalCode = $tripDestinationCountryCode = $tripDestinationLatitude = $tripDestinationLongitude = "";
        foreach ($locationAry as $location) {
            $locationXid = (string) $location[0]->xpath('LocationGid/Gid/Xid')[0];
            $destinationAry = [];
            if ($locationXid == $tripDestinationLocationXid) {
                $tripDestinationLocationName = empty($location[0]->xpath('LocationName')) ? 0 : (string) $location[0]->xpath('LocationName')[0];
                $tripDestinationAddress = empty($location[0]->xpath('Address/AddressLines')) ? [] : $location[0]->xpath('Address/AddressLines');
                $tripDestinationAddressAry = [];

                foreach ($tripDestinationAddress as $toAddress) {
                    $address = empty($toAddress->xpath('AddressLine')[0]) ? "" : $toAddress->xpath('AddressLine')[0];
                    array_push($tripDestinationAddressAry, $address);
                }

                $tripDestinationCity = empty($location[0]->xpath('Address/City')) ? 0 : (string) $location[0]->xpath('Address/City')[0];
                $tripDestinationProvince = empty($location[0]->xpath('Address/Province')) ? 0 : (string) $location[0]->xpath('Address/Province')[0];
                $tripDestinationProvinceCode = empty($location[0]->xpath('Address/ProvinceCode')) ? 0 : (string) $location[0]->xpath('Address/ProvinceCode')[0];
                $tripDestinationPostalCode = empty($location[0]->xpath('Address/PostalCode')) ? 0 : (string) $location[0]->xpath('Address/PostalCode')[0];
                $tripDestinationCountryCode = empty($location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')) ? 0 : (string) $location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')[0];
                $tripDestinationLatitude = empty($location[0]->xpath('Address/Latitude')) ? 0 : (string) $location[0]->xpath('Address/Latitude')[0];
                $tripDestinationLongitude = empty($location[0]->xpath('Address/Longitude')) ? 0 : (string) $location[0]->xpath('Address/Longitude')[0];
            }
            $destinationAry = [
                'tripDestinationLocationId' => $tripDestinationLocationXid,
                'tripDestinationLocationName' => $tripDestinationLocationName,
                'tripDestinationAddressAry' => $tripDestinationAddressAry,
                'tripDestinationCity' => $tripDestinationCity,
                'tripDestinationProvince' => $tripDestinationProvince,
                'tripDestinationProvinceCode' => $tripDestinationProvinceCode,
                'tripDestinationPostalCode' => $tripDestinationPostalCode,
                'tripDestinationCountryCode' => $tripDestinationCountryCode,
                'tripDestinationLatitude' => $tripDestinationLatitude,
                'tripDestinationLongitude' => $tripDestinationLongitude,
            ];
        }
        return $destinationAry;
    }

    public function getTripInvolvedParties(array $plannedShipment): array
    {
        $involvedParties = empty($plannedShipment[0]->xpath('ShipmentHeader/InvolvedParty')) ? [] : $plannedShipment[0]->xpath('ShipmentHeader/InvolvedParty');
        $involvedPartiesAry = [];
        foreach ($involvedParties as $involvedParty) {
            $partyType = empty((string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0]) ? "" : (string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0];
            $id = empty($involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')[0];
            $email = empty($involvedParty->xpath('ContactRef/Contact/EmailAddress')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/EmailAddress')[0];
            $firstName = empty($involvedParty->xpath('ContactRef/Contact/FirstName')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/FirstName')[0];
            $phone = empty($involvedParty->xpath('ContactRef/Contact/Phone1')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/Phone1')[0];
            $parties = [];
            $parties = [
                'partyType' => $partyType,
                'id' => $id,
                'email' => $email,
                'firstName' => $firstName,
                'phone' => $phone,
            ];
            array_push($involvedPartiesAry, $parties);
        }
        return $involvedPartiesAry;
    }

    public function getShipmentStops(array $plannedShipment, $locationAry): array
    {
        $shipmentStops = $plannedShipment[0]->xpath('ShipmentStop');
        $shipmentStopAry = [];
        foreach ($shipmentStops as $shipmentStop) {
            $shipmentStopSequence = (string) $shipmentStop[0]->xpath('StopSequence')[0];
            $shipmentStopLocationXid = (string) $shipmentStop[0]->xpath('LocationRef/LocationGid/Gid/Xid')[0];
            $shipmentStopLocationRoleXid = "";
            if (!empty($shipmentStop[0]->xpath('LocationRoleGid'))) {
                $shipmentStopLocationRoleXid = (string) $shipmentStop[0]->xpath('LocationRoleGid/Gid/Xid')[0];
            }
            $shipmentStopPlannedArrivalXid = (string) $shipmentStop[0]->xpath('ArrivalTime/EventTime/PlannedTime/GLogDate')[0];
            $shipmentStopPlannedArrivalXid = date("Y-m-d H:i:s", strtotime($shipmentStopPlannedArrivalXid));
            $shipmentStopEstimatedArrivalXid = (string) $shipmentStop[0]->xpath('ArrivalTime/EventTime/EstimatedTime/GLogDate')[0];
            $shipmentStopEstimatedArrivalXid = date("Y-m-d H:i:s", strtotime($shipmentStopEstimatedArrivalXid));
            $shipmentStopPlannedDepartureXid = (string) $shipmentStop[0]->xpath('DepartureTime/EventTime/PlannedTime/GLogDate')[0];
            $shipmentStopPlannedDepartureXid = date("Y-m-d H:i:s", strtotime($shipmentStopPlannedDepartureXid));
            $shipmentStopEstimatedDepartureXid = (string) $shipmentStop[0]->xpath('DepartureTime/EventTime/EstimatedTime/GLogDate')[0];
            $shipmentStopEstimatedDepartureXid = date("Y-m-d H:i:s", strtotime($shipmentStopEstimatedDepartureXid));
            $shipmentStopIsPermanent = $shipmentStopIsDepot = $shipmentStopDistFromPrevStop = "";
            $shipmentStopDistFromPrevStopTime = $shipmentStopDistFromPrevStopTimeUOM = "";
            $shipmentAccessorialTime = $shipmentAccessorialTimeUOM = $shipmentIsMotherVessel = "";
            $shipmentRushHourTime = $shipmentRushHourTimeUOM = $shipmentStopType = "";
            if (!empty($shipmentStop[0]->xpath('IsPermanent')[0])) {
                $shipmentStopIsPermanent = (string) $shipmentStop[0]->xpath('IsPermanent')[0];
            }
            if (!empty($shipmentStop[0]->xpath('IsPermanent')[0])) {
                $shipmentStopIsPermanent = (string) $shipmentStop[0]->xpath('IsDepot')[0];
            }
            if (!empty($shipmentStop[0]->xpath('DistFromPrevStop'))) {
                $shipmentStopDistFromPrevStop = $shipmentStop[0]->xpath('DistFromPrevStop/Distance')[0];
                $shipmentStopDistFromPrevStopTime = (string) $shipmentStopDistFromPrevStop[0]->xpath('DistanceValue')[0];
                $shipmentStopDistFromPrevStopTimeUOM = (string) $shipmentStopDistFromPrevStop[0]->xpath('DistanceUOMGid/Gid/Xid')[0];
            }
            $shipmentStopDetails = empty($shipmentStop[0]->xpath('ShipmentStopDetail')) ? "" : $shipmentStop[0]->xpath('ShipmentStopDetail');
            if (!empty($shipmentStop[0]->xpath('AccessorialTime'))) {
                $shipmentAccessorial = $shipmentStop[0]->xpath('AccessorialTime/Duration')[0];
                $shipmentAccessorialTime = (string) $shipmentAccessorial[0]->xpath('DurationValue')[0];
                $shipmentAccessorialTimeUOM = (string) $shipmentAccessorial[0]->xpath('DurationUOMGid/Gid/Xid')[0];
            }
            if (!empty($shipmentStop[0]->xpath('IsMotherVessel'))) {
                $shipmentIsMotherVessel = (string) $shipmentStop[0]->xpath('IsMotherVessel')[0];
            }
            $shipmentRushHour = empty($shipmentStop[0]->xpath('RushHourTime/Duration')[0]) ? "" : $shipmentStop[0]->xpath('RushHourTime/Duration')[0];
            if (!empty($shipmentStop[0]->xpath('RushHourTime/Duration')[0])) {
                $shipmentRushHourTime = empty((string) $shipmentRushHour[0]->xpath('DurationValue')[0]) ? "" : (string) $shipmentRushHour[0]->xpath('DurationValue')[0];
                $shipmentRushHourTimeUOM = empty((string) $shipmentRushHour[0]->xpath('DurationUOMGid/Gid/Xid')[0]) ? "" : (string) $shipmentRushHour[0]->xpath('DurationUOMGid/Gid/Xid')[0];
            }
            if (!empty($shipmentStop[0]->xpath('StopType')[0])) {
                $shipmentStopType = (string) $shipmentStop[0]->xpath('StopType')[0];
            }
            $tripStopLocationName = $tripStopAddress = $tripStopCity = $tripStopProvince = $tripStopProvinceCode = "";
            $tripStopPostalCode = $tripStopCountryCode = $tripStopLatitude = $tripStopLongitude = "";
            foreach ($locationAry as $location) {
                $locationXid = (string) $location[0]->xpath('LocationGid/Gid/Xid')[0];
                $tripStopAry = $tripStopAddressAry = [];

                if ($locationXid == $shipmentStopLocationXid) {
                    $tripStopLocationName = empty($location[0]->xpath('LocationName')) ? 0 : (string) $location[0]->xpath('LocationName')[0];
                    $tripStopAddress = empty($location[0]->xpath('Address/AddressLines')) ? [] : $location[0]->xpath('Address/AddressLines');

                    foreach ($tripStopAddress as $toAddress) {
                        $address = empty($toAddress->xpath('AddressLine')[0]) ? "" : $toAddress->xpath('AddressLine')[0];
                        array_push($tripStopAddressAry, $address);
                    }

                    $tripStopCity = empty($location[0]->xpath('Address/City')) ? 0 : (string) $location[0]->xpath('Address/City')[0];
                    $tripStopProvince = empty($location[0]->xpath('Address/Province')) ? 0 : (string) $location[0]->xpath('Address/Province')[0];
                    $tripStopProvinceCode = empty($location[0]->xpath('Address/ProvinceCode')) ? 0 : (string) $location[0]->xpath('Address/ProvinceCode')[0];
                    $tripStopPostalCode = empty($location[0]->xpath('Address/PostalCode')) ? 0 : (string) $location[0]->xpath('Address/PostalCode')[0];
                    $tripStopCountryCode = empty($location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')) ? 0 : (string) $location[0]->xpath('Address/CountryCode/CountryCode3Gid/Gid/Xid')[0];
                    $tripStopLatitude = empty($location[0]->xpath('Address/Latitude')) ? 0 : (string) $location[0]->xpath('Address/Latitude')[0];
                    $tripStopLongitude = empty($location[0]->xpath('Address/Longitude')) ? 0 : (string) $location[0]->xpath('Address/Longitude')[0];
                }
                $tripStopAry = [
                    'tripStopLocationName' => $tripStopLocationName,
                    'tripStopAddressAry' => $tripStopAddressAry,
                    'tripStopCity' => $tripStopCity,
                    'tripStopProvince' => $tripStopProvince,
                    'tripStopProvinceCode' => $tripStopProvinceCode,
                    'tripStopPostalCode' => $tripStopPostalCode,
                    'tripStopCountryCode' => $tripStopCountryCode,
                    'tripStopLatitude' => $tripStopLatitude,
                    'tripStopLongitude' => $tripStopLongitude,
                ];
            }
            $shipmentStop = [];
            array_push($shipmentStop, $shipmentStopSequence);
            array_push($shipmentStop, $shipmentStopLocationXid);
            array_push($shipmentStop, $shipmentStopLocationRoleXid);
            array_push($shipmentStop, $shipmentStopPlannedArrivalXid);
            array_push($shipmentStop, $shipmentStopEstimatedArrivalXid);
            array_push($shipmentStop, $shipmentStopPlannedDepartureXid);
            array_push($shipmentStop, $shipmentStopEstimatedDepartureXid);
            array_push($shipmentStop, $shipmentStopIsPermanent);
            array_push($shipmentStop, $shipmentStopIsDepot);
            array_push($shipmentStop, $shipmentStopDistFromPrevStopTime);
            array_push($shipmentStop, $shipmentStopDistFromPrevStopTimeUOM);
            array_push($shipmentStop, $shipmentStopDetails);
            array_push($shipmentStop, $shipmentIsMotherVessel);
            array_push($shipmentStop, $shipmentAccessorialTime);
            array_push($shipmentStop, $shipmentAccessorialTimeUOM);
            array_push($shipmentStop, $shipmentRushHourTime);
            array_push($shipmentStop, $shipmentRushHourTimeUOM);
            array_push($shipmentStop, $shipmentStopType);
            array_push($shipmentStop, $tripStopAry);
            array_push($shipmentStopAry, $shipmentStop);
        }
        return $shipmentStopAry;
    }

    public function getTripDates(array $plannedShipment): array
    {
        $startDate = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/StartDt/GLogDate')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/StartDt/GLogDate')[0];
        $startTimeZoneId = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/StartDt/TZId')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/StartDt/TZId')[0];
        $startTimeZoneOffset = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/StartDt/TZOffset')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/StartDt/TZOffset')[0];
        $startTimeZone = $startTimeZoneId . "/" . $startTimeZoneOffset;
        $endDate = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/LatestStartDt/GLogDate')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/LatestStartDt/GLogDate')[0];
        $endTimeZoneId = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/LatestStartDt/TZId')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/LatestStartDt/TZId')[0];
        $endTimeZoneOffset = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/LatestStartDt/TZOffset')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/LatestStartDt/TZOffset')[0];
        $endTimeZone = $endTimeZoneId . "/" . $endTimeZoneOffset;
        if ($startDate != 0) {
            $startDate = date("Y-m-d H:i:s", strtotime($startDate));
        }
        if ($endDate != 0) {
            $endDate = date("Y-m-d H:i:s", strtotime($endDate));
        }

        $tripInfoAry = [
            'startDate' => $startDate,
            'startTimeZone' => $startTimeZone,
            'endDate' => $endDate,
            'endTimeZone' => $endTimeZone,
        ];
        log_message("error", "tripInfoAry:" . json_encode($tripInfoAry));
        return $tripInfoAry;
    }

    public function getCargoSummaryTripInfo(array $plannedShipment): array
    {
        $totalWeight = $plannedShipment[0]->xpath('ShipmentHeader/TotalWeightVolume/WeightVolume/Weight');
        $totalVolume = $plannedShipment[0]->xpath('ShipmentHeader/TotalWeightVolume/WeightVolume/Volume');

        $totalWeightValue = empty($totalWeight[0]->xpath('WeightValue')) ? '0' : (string) $totalWeight[0]->xpath('WeightValue')[0];
        $totalWeightUOM = empty($totalWeight[0]->xpath('WeightUOMGid/Gid/Xid')) ? 0 : (string) $totalWeight[0]->xpath('WeightUOMGid/Gid/Xid')[0];
        $totalVolumeValue = empty($totalVolume[0]->xpath('VolumeValue')) ? 0 : (string) $totalVolume[0]->xpath('VolumeValue')[0];
        $totalVolumeUOM = empty($totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')) ? 0 : (string) $totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')[0];
        $totalQuantityValue = empty($plannedShipment[0]->xpath('ShipmentHeader/TotalPackagedItemCount')) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/TotalPackagedItemCount')[0];

        $cargoSummaryTripAry = [
            'totalWeightValue' => $totalWeightValue,
            'totalWeightUOM' => $totalWeightUOM,
            'totalVolumeValue' => $totalVolumeValue,
            'totalVolumeUOM' => $totalVolumeUOM,
            'totalQuantityValue' => $totalQuantityValue,
        ];
        return $cargoSummaryTripAry;
    }

    public function getTripAddonsInfo(array $plannedShipment): array
    {
        $tripAddons = empty($plannedShipment[0]->xpath('ShipmentHeader/ShipmentSpecialService')) ? [] : $plannedShipment[0]->xpath('ShipmentHeader/ShipmentSpecialService');
        $tripAddonsAry = [];
        foreach ($tripAddons as $addons) {
            $addonName = empty($addons->xpath('SpecialServiceGid/Gid/Xid')[0]) ? 0 : $addons->xpath('SpecialServiceGid/Gid/Xid')[0];
            $addons = [];
            array_push($addons, $addonName);
            array_push($tripAddonsAry, $addons);
        }
        return $tripAddonsAry;
    }

    public function getTripManageReferences(array $plannedShipment): array
    {
        $releaseRefNums = empty($plannedShipment[0]->xpath('ShipmentHeader//ShipmentRefnum')) ? [] : $plannedShipment[0]->xpath('ShipmentHeader//ShipmentRefnum');
        $referencesAry = [];
        foreach ($releaseRefNums as $releaseRefNum) {
            $refCode = empty($releaseRefNum->xpath('ShipmentRefnumQualifierGid/Gid/Xid')[0]) ? 0 : $releaseRefNum->xpath('ShipmentRefnumQualifierGid/Gid/Xid')[0];
            $refValue = (string) $releaseRefNum->xpath('ShipmentRefnumValue')[0];
            $references = [];
            array_push($references, $refCode);
            array_push($references, $refValue);
            array_push($referencesAry, $references);
        }

        return $referencesAry;
    }

    public function getTripRemarks(array $plannedShipment): array
    {
        $releaseRemarks = empty($plannedShipment[0]->xpath('ShipmentHeader/Remark')) ? [] : $plannedShipment[0]->xpath('ShipmentHeader/Remark');
        $remarksAry = [];
        foreach ($releaseRemarks as $remark) {
            $remarkCode = empty($remark->xpath('RemarkQualifierGid/Gid/Xid')[0]) ? 0 : $remark->xpath('RemarkQualifierGid/Gid/Xid')[0];
            $remarkValue = (string) $remark->xpath('RemarkText')[0];
            $remarks = [];
            array_push($remarks, $remarkCode);
            array_push($remarks, $remarkValue);
            array_push($remarksAry, $remarks);
        }
        return $remarksAry;
    }

    public function setTripInfo(array $tripInfoAry): string
    {
        $tripInfoAry['tripType'] = empty($tripInfoAry['tripType']) ? "DEFAULT" : $tripInfoAry['tripType'];
        $tripInfoAry['modeOfTransport'] = empty($tripInfoAry['modeOfTransport']) ? "DEFAULT" : $tripInfoAry['modeOfTransport'];
        $emptyValue = "";
        $tripInfo = '<TripID>' . $tripInfoAry['bookingId'] . '</TripID>';
        $tripInfo .= '<ExternalTripID>' . $tripInfoAry['bookingId'] . '</ExternalTripID>';
        $tripInfo .= '<Transits>';
        $tripInfo .= '<TransitLegId>' . $emptyValue . '</TransitLegId>';
        $tripInfo .= '</Transits>';
        $tripInfo .= '<TripType>' . $tripInfoAry['tripType'] . '</TripType>';
        $tripInfo .= '<ModeOfTransport>' . $tripInfoAry['modeOfTransport'] . '</ModeOfTransport>';
        $tripInfo .= '<Product>' . $emptyValue . '</Product>';
        $tripInfo .= '<ServiceType>' . $emptyValue . '</ServiceType>';
        $tripInfo .= '<GoodsValue>' . $emptyValue . '</GoodsValue>';
        $tripInfo .= '<TypeOfBusiness>' . $emptyValue . '</TypeOfBusiness>';
        $tripInfo .= '<TermsOfTrade>';
        $tripInfo .= '<Incoterm>' . $emptyValue . '</Incoterm>';
        $tripInfo .= '<FreightTerm>';
        $tripInfo .= '<Term>' . $emptyValue . '</Term>';
        $tripInfo .= '<Name>' . $emptyValue . '</Name>';
        $tripInfo .= '</FreightTerm>';
        $tripInfo .= '</TermsOfTrade>';
        return $tripInfo;
    }

    public function setCarrierInfo(array $carrierAry, string $status): string
    {
        
        $carrierInfo = $emptyValue = "";
        foreach ($involvedPartiesAry as $involvedParties) {
            if (strtoupper($involvedParties['partyType']) == 'CARRIER') {
                $carrierInfo = '';
                $carrierInfo .= '<CarrierDetails>';
                $carrierInfo .= '<ID>' . $carrierAry['carrierLocationName'] . '</ID>';
                $carrierInfo .= '<Company>';
                $carrierInfo .= '<Name>' . $carrierAry['carrierLocationName'] . '</Name>';
                $carrierInfo .= '<RegistrationNumber>' . $carrierAry['carrierLocationName'] . '</RegistrationNumber>';
                $carrierInfo .= '</Company>';
                $carrierInfo .= '<Address>';
                $carrierInfo .= '<Address1>' . (empty($carrierAry['carrierAddressAry'][0]) ? "" : $carrierAry['carrierAddressAry'][0]) . '</Address1>';
                $carrierInfo .= '<Address2>' . (empty($carrierAry['carrierAddressAry'][1]) ? "" : $carrierAry['carrierAddressAry'][1]) . '</Address2>';
                $carrierInfo .= '<Street>' . $emptyValue . '</Street>';
                $carrierInfo .= '<City>' . $carrierAry['carrierCity'] . '</City>';
                $carrierInfo .= '<State>' . $carrierAry['carrierProvince'] . '</State>';
                $carrierInfo .= '<Province>' . $carrierAry['carrierProvince'] . '</Province>';
                $carrierInfo .= '<Postal>' . $carrierAry['carrierPostalCode'] . '</Postal>';
                $carrierInfo .= '<Country>' . $carrierAry['carrierCountryCode'] . '</Country>';
                $carrierInfo .= '<Latitude>' . $carrierAry['carrierLatitude'] . '</Latitude>';
                $carrierInfo .= '<Longitude>' . $carrierAry['carrierLongitude'] . '</Longitude>';
                $carrierInfo .= '<ContactInfo>';
                $carrierInfo .= '<CountryCode>' . $carrierAry['carrierCountryCode'] . '</CountryCode>';
                $carrierInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
                $carrierInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
                $carrierInfo .= '</ContactInfo>';
                $carrierInfo .= '</Address>';
                $carrierInfo .= '</CarrierDetails>';
            }
        }
        if ($carrierInfo == "") {
            $carrierInfo = '';
            $carrierInfo .= '<CarrierDetails>';
            $carrierInfo .= '<ID>' . "ALL" . '</ID>';
            $carrierInfo .= '<Company>';
            $carrierInfo .= '<Name>' . "ALL" . '</Name>';
            $carrierInfo .= '<RegistrationNumber>' . "ALL" . '</RegistrationNumber>';
            $carrierInfo .= '</Company>';
            $carrierInfo .= '<Address>';
            $carrierInfo .= '<Address1>' . $emptyValue . '</Address1>';
            $carrierInfo .= '<Address2>' . $emptyValue . '</Address2>';
            $carrierInfo .= '<Street>' . $emptyValue . '</Street>';
            $carrierInfo .= '<City>' . $emptyValue . '</City>';
            $carrierInfo .= '<Province>' . $emptyValue . '</Province>';
            $carrierInfo .= '<State>' . $emptyValue . '</State>';
            $carrierInfo .= '<Postal>' . $emptyValue . '</Postal>';
            $carrierInfo .= '<Country>' . $emptyValue . '</Country>';
            $carrierInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
            $carrierInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
            $carrierInfo .= '<ContactInfo>';
            $carrierInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
            $carrierInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
            $carrierInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
            $carrierInfo .= '</ContactInfo>';
            $carrierInfo .= '</Address>';
            $carrierInfo .= '</CarrierDetails>';
        }
        return $carrierInfo;
        /*
        $carrierInfo = $emptyValue = "";
        if ($status == 'Y') {
            $carrierInfo .= '<BusinessParty>';
            $carrierInfo .= '<PartyType>CARRIER</PartyType>';
        } else {
            $carrierInfo .= '<CarrierDetails>';
        }
        $carrierInfo .= '<ID>' . $carrierAry['carrierLocationName'] . '</ID>';
        $carrierInfo .= '<Company>';
        $carrierInfo .= '<Name>' . $carrierAry['carrierLocationName'] . '</Name>';
        $carrierInfo .= '<RegistrationNumber>' . $carrierAry['carrierLocationName'] . '</RegistrationNumber>';
        $carrierInfo .= '</Company>';
        $carrierInfo .= '<Address>';
        $carrierInfo .= '<Address1>' . (empty($carrierAry['carrierAddressAry'][0]) ? "" : $carrierAry['carrierAddressAry'][0]) . '</Address1>';
        $carrierInfo .= '<Address2>' . (empty($carrierAry['carrierAddressAry'][1]) ? "" : $carrierAry['carrierAddressAry'][1]) . '</Address2>';
        $carrierInfo .= '<Street>' . $emptyValue . '</Street>';
        $carrierInfo .= '<City>' . $carrierAry['carrierCity'] . '</City>';
        $carrierInfo .= '<State>' . $carrierAry['carrierProvince'] . '</State>';
        $carrierInfo .= '<Province>' . $carrierAry['carrierProvince'] . '</Province>';
        $carrierInfo .= '<Postal>' . $carrierAry['carrierPostalCode'] . '</Postal>';
        $carrierInfo .= '<Country>' . $carrierAry['carrierCountryCode'] . '</Country>';
        $carrierInfo .= '<Latitude>' . $carrierAry['carrierLatitude'] . '</Latitude>';
        $carrierInfo .= '<Longitude>' . $carrierAry['carrierLongitude'] . '</Longitude>';
        $carrierInfo .= '<ContactInfo>';
        $carrierInfo .= '<CountryCode>' . $carrierAry['carrierCountryCode'] . '</CountryCode>';
        $carrierInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
        $carrierInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
        $carrierInfo .= '</ContactInfo>';
        $carrierInfo .= '</Address>';
        $carrierInfo .= '<AdditionalContactInfo>' . $emptyValue . '</AdditionalContactInfo>';
        if ($status == 'N') {
            $carrierInfo .= '</CarrierDetails>';
        } else {
            $carrierInfo .= '</BusinessParty>';
        }
        return $carrierInfo;*/
    }

    public function setTripSourceLocationInfo(array $tripSourceAry, array $tripDatesAry, string $status): string
    {
        $emptyValue = $tripSourceInfo = '';
        if ($status == 'Y') {
            $tripSourceInfo .= '<BusinessParty>';
            $tripSourceInfo .= '<PartyType>SHIPPER</PartyType>';
        } else {
            $tripSourceInfo .= '<TripStartLocation>';
        }
        $tripSourceInfo .= '<ID>' . $tripSourceAry['tripSourceLocationId'] . '</ID>';
        $tripSourceInfo .= '<Company>';
        $tripSourceInfo .= '<Name>' . $tripSourceAry['tripSourceLocationName'] . '</Name>';
        $tripSourceInfo .= '<RegistrationNumber>' . $tripSourceAry['tripSourceLocationName'] . '</RegistrationNumber>';
        $tripSourceInfo .= '</Company>';
        $tripSourceInfo .= '<Address>';
        $tripSourceInfo .= '<CompanyName>' . $tripSourceAry['tripSourceLocationName'] . '</CompanyName>';
        $tripSourceInfo .= '<Address1>' . (empty($tripSourceAry['tripSourceAddressAry'][0]) ? "" : $tripSourceAry['tripSourceAddressAry'][0]) . '</Address1>';
        $tripSourceInfo .= '<Address2>' . (empty($tripSourceAry['tripSourceAddressAry'][1]) ? "" : $tripSourceAry['tripSourceAddressAry'][1]) . '</Address2>';
        $tripSourceInfo .= '<Street>' . $emptyValue . '</Street>';
        $tripSourceInfo .= '<City>' . $tripSourceAry['tripSourceCity'] . '</City>';
        $tripSourceInfo .= '<State>' . $tripSourceAry['tripSourceProvince'] . '</State>';
        $tripSourceInfo .= '<Province>' . $tripSourceAry['tripSourceProvince'] . '</Province>';
        $tripSourceInfo .= '<Postal>' . $tripSourceAry['tripSourcePostalCode'] . '</Postal>';
        $tripSourceInfo .= '<Country>' . $tripSourceAry['tripSourceCountryCode'] . '</Country>';
        $tripSourceInfo .= '<Latitude>' . $tripSourceAry['tripSourceLatitude'] . '</Latitude>';
        $tripSourceInfo .= '<Longitude>' . $tripSourceAry['tripSourceLongitude'] . '</Longitude>';
        $tripSourceInfo .= '<ContactInfo>';
        $tripSourceInfo .= '<CountryCode>' . $tripSourceAry['tripSourceCountryCode'] . '</CountryCode>';
        $tripSourceInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
        $tripSourceInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
        $tripSourceInfo .= '</ContactInfo>';
        $tripSourceInfo .= '</Address>';
        if ($status == 'N') {
            $tripSourceInfo .= '<EstimatedDateTime>';
            $tripSourceInfo .= '<From>';
            $tripSourceInfo .= '<DateTime>' . $tripDatesAry['startDate'] . '</DateTime>';
            $tripSourceInfo .= '<TimeZone>' . $tripDatesAry['startTimeZone'] . '</TimeZone>';
            $tripSourceInfo .= '<UTC>';
            $tripSourceInfo .= '<Time>' . $tripDatesAry['startDate'] . '</Time>';
            $tripSourceInfo .= '</UTC>';
            $tripSourceInfo .= '</From>';
            $tripSourceInfo .= '<To>';
            $tripSourceInfo .= '<DateTime>' . $tripDatesAry['startDate'] . '</DateTime>';
            $tripSourceInfo .= '<TimeZone>' . $tripDatesAry['startTimeZone'] . '</TimeZone>';
            $tripSourceInfo .= '<UTC>';
            $tripSourceInfo .= '<Time>' . $tripDatesAry['startDate'] . '</Time>';
            $tripSourceInfo .= '</UTC>';
            $tripSourceInfo .= '</To>';
            $tripSourceInfo .= '</EstimatedDateTime>';
            $tripSourceInfo .= '</TripStartLocation>';
        } else {
            $tripSourceInfo .= '</BusinessParty>';
        }
        return $tripSourceInfo;
    }

    public function setTripDestinationLocationInfo(array $tripDestinationAry, array $tripDatesAry, string $status): string
    {
        $emptyValue = $tripDestinationInfo = '';
        if ($status == 'Y') {
            $tripDestinationInfo .= '<BusinessParty>';
            $tripDestinationInfo .= '<PartyType>CONSIGNEE</PartyType>';
        } else {
            $tripDestinationInfo .= '<TripEndLocation>';
        }
        $tripDestinationInfo .= '<ID>' . $tripDestinationAry['tripDestinationLocationId'] . '</ID>';
        $tripDestinationInfo .= '<Company>';
        $tripDestinationInfo .= '<Name>' . $tripDestinationAry['tripDestinationLocationName'] . '</Name>';
        $tripDestinationInfo .= '<RegistrationNumber>' . $tripDestinationAry['tripDestinationLocationName'] . '</RegistrationNumber>';
        $tripDestinationInfo .= '</Company>';
        $tripDestinationInfo .= '<Address>';
        $tripDestinationInfo .= '<CompanyName>' . $tripDestinationAry['tripDestinationLocationName'] . '</CompanyName>';
        $tripDestinationInfo .= '<Address1>' . (empty($tripDestinationAry['tripDestinationAddressAry'][0]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][0]) . '</Address1>';
        $tripDestinationInfo .= '<Address2>' . (empty($tripDestinationAry['tripDestinationAddressAry'][1]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][1]) . '</Address2>';
        $tripDestinationInfo .= '<Street>' . $emptyValue . '</Street>';
        $tripDestinationInfo .= '<City>' . $tripDestinationAry['tripDestinationCity'] . '</City>';
        $tripDestinationInfo .= '<State>' . $tripDestinationAry['tripDestinationProvince'] . '</State>';
        $tripDestinationInfo .= '<Province>' . $tripDestinationAry['tripDestinationProvince'] . '</Province>';
        $tripDestinationInfo .= '<Postal>' . $tripDestinationAry['tripDestinationPostalCode'] . '</Postal>';
        $tripDestinationInfo .= '<Country>' . $tripDestinationAry['tripDestinationCountryCode'] . '</Country>';
        $tripDestinationInfo .= '<Latitude>' . $tripDestinationAry['tripDestinationLatitude'] . '</Latitude>';
        $tripDestinationInfo .= '<Longitude>' . $tripDestinationAry['tripDestinationLongitude'] . '</Longitude>';
        $tripDestinationInfo .= '<ContactInfo>';
        $tripDestinationInfo .= '<CountryCode>' . $tripDestinationAry['tripDestinationCountryCode'] . '</CountryCode>';
        $tripDestinationInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
        $tripDestinationInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
        $tripDestinationInfo .= '</ContactInfo>';
        $tripDestinationInfo .= '</Address>';
        if ($status == 'N') {
            $tripDestinationInfo .= '<EstimatedDateTime>';
            $tripDestinationInfo .= '<From>';
            $tripDestinationInfo .= '<DateTime>' . $tripDatesAry['endDate'] . '</DateTime>';
            $tripDestinationInfo .= '<TimeZone>' . $tripDatesAry['endTimeZone'] . '</TimeZone>';
            $tripDestinationInfo .= '<UTC>';
            $tripDestinationInfo .= '<Time>' . $tripDatesAry['endDate'] . '</Time>';
            $tripDestinationInfo .= '</UTC>';
            $tripDestinationInfo .= '</From>';
            $tripDestinationInfo .= '<To>';
            $tripDestinationInfo .= '<DateTime>' . $tripDatesAry['endDate'] . '</DateTime>';
            $tripDestinationInfo .= '<TimeZone>' . $tripDatesAry['endTimeZone'] . '</TimeZone>';
            $tripDestinationInfo .= '<UTC>';
            $tripDestinationInfo .= '<Time>' . $tripDatesAry['endDate'] . '</Time>';
            $tripDestinationInfo .= '</UTC>';
            $tripDestinationInfo .= '</To>';
            $tripDestinationInfo .= '</EstimatedDateTime>';
            $tripDestinationInfo .= '</TripEndLocation>';
        } else {
            $tripDestinationInfo .= '</BusinessParty>';
        }
        return $tripDestinationInfo;
    }

    public function setTripDates(array $tripDatesAry): string
    {
        $tripDatesInfo = '';
        
        $tripDatesInfo .= '<TripDates>';
        $tripDatesInfo .= '<StartDate>';
        $tripDatesInfo .= '<DateTime>' . $tripDatesAry['startDate'] . '</DateTime>';
        $tripDatesInfo .= '<TimeZone>' . $tripDatesAry['startTimeZone'] . '</TimeZone>';
        $tripDatesInfo .= '<UTC>';
        $tripDatesInfo .= '<Time>' . $tripDatesAry['startDate'] . '</Time>';
        $tripDatesInfo .= '</UTC>';
        $tripDatesInfo .= '</StartDate>';
        $tripDatesInfo .= '<EndDate>';
        $tripDatesInfo .= '<DateTime>' . $tripDatesAry['endDate'] . '</DateTime>';
        $tripDatesInfo .= '<TimeZone>' . $tripDatesAry['endTimeZone'] . '</TimeZone>';
        $tripDatesInfo .= '<UTC>';
        $tripDatesInfo .= '<Time>' . $tripDatesAry['endDate'] . '</Time>';
        $tripDatesInfo .= '</UTC>';
        $tripDatesInfo .= '</EndDate>';
        $tripDatesInfo .= '</TripDates>';
        return $tripDatesInfo;
    }

    public function setShipmentStops(array $shipmentStopsAry): string
    {
        $emptyValue = "";
        $shipmentStopInfo = '<TripStops>';
        foreach ($shipmentStopsAry as $shipmentStops) {
            $shipmentStopInfo .= '<TripStop>';
            $shipmentStopInfo .= '<StopSequence>' . $shipmentStops[0] . '</StopSequence>';
            $shipmentStopInfo .= '<LocationGid>' . $shipmentStops[1] . '</LocationGid>';
            $shipmentStopInfo .= '<LocationRoleGid>' . $shipmentStops[2] . '</LocationRoleGid>';
            $shipmentStopInfo .= '<DistFromPrevStop>';
            $shipmentStopInfo .= '<DistanceValue>' . $shipmentStops[9] . '</DistanceValue>';
            $shipmentStopInfo .= '<DistanceUOMGid>' . $shipmentStops[10] . '</DistanceUOMGid>';
            $shipmentStopInfo .= '</DistFromPrevStop>';
            $shipmentStopInfo .= '<ArrivalTime>';
            $shipmentStopInfo .= '<PlannedTime>' . $shipmentStops[3] . '</PlannedTime>';
            $shipmentStopInfo .= '<EstimatedTime>' . $shipmentStops[4] . '</EstimatedTime>';
            $shipmentStopInfo .= '</ArrivalTime>';
            $shipmentStopInfo .= '<DepartureTime>';
            $shipmentStopInfo .= '<PlannedTime>' . $shipmentStops[5] . '</PlannedTime>';
            $shipmentStopInfo .= '<EstimatedTime>' . $shipmentStops[6] . '</EstimatedTime>';
            $shipmentStopInfo .= '</DepartureTime>';
            $shipmentStopInfo .= '<IsPermanent>' . $shipmentStops[7] . '</IsPermanent>';
            $shipmentStopInfo .= '<IsDepot>' . $shipmentStops[8] . '</IsDepot>';
            $shipmentStopInfo .= '<AccessorialTime>';
            $shipmentStopInfo .= '<DurationValue>' . $shipmentStops[13] . '</DurationValue>';
            $shipmentStopInfo .= '<DurationUOMGid>' . $shipmentStops[14] . '</DurationUOMGid>';
            $shipmentStopInfo .= '</AccessorialTime>';
            $shipmentStopInfo .= '<IsMotherVessel>' . $shipmentStops[12] . '</IsMotherVessel>';
            $shipmentStopInfo .= '<RushHourTime>';
            $shipmentStopInfo .= '<DurationValue>' . $shipmentStops[15] . '</DurationValue>';
            $shipmentStopInfo .= '<DurationUOMGid>' . $shipmentStops[16] . '</DurationUOMGid>';
            $shipmentStopInfo .= '</RushHourTime>';
            $shipmentStopDetails = $shipmentStops[11];
            if (!empty($shipmentStopDetails)) {
                foreach ($shipmentStopDetails as $shipmentStop) {
                    $shipmentStopActivityTime = $shipmentStopActivityTimeUOM = "";
                    if (!empty($shipmentStop[0]->xpath('ActivityDuration/Duration')[0])) {
                        $shipmentStopDetail = $shipmentStop[0]->xpath('ActivityDuration/Duration')[0];
                        $shipmentStopActivityTime = (string) $shipmentStopDetail[0]->xpath('DurationValue')[0];
                        $shipmentStopActivityTimeUOM = (string) $shipmentStopDetail[0]->xpath('DurationUOMGid/Gid/Xid')[0];
                    }
                    $shipmentStopActivityBase = (string) $shipmentStop[0]->xpath('Activity')[0];
                    $shipUnitId = (string) $shipmentStop[0]->xpath('ShipUnitGid/Gid/Xid')[0];
                    $shipmentStopInfo .= '<TripStopDetail>';
                    $shipmentStopInfo .= '<ActivityBase>' . $shipmentStopActivityBase . '</ActivityBase>';
                    $shipmentStopInfo .= '<DurationValue>' . $shipmentStopActivityTime . '</DurationValue>';
                    $shipmentStopInfo .= '<DurationUOMGid>' . $shipmentStopActivityTimeUOM . '</DurationUOMGid>';
                    $shipmentStopInfo .= '<ShipUnitId>' . $shipUnitId . '</ShipUnitId>';
                    $shipmentStopInfo .= '</TripStopDetail>';
                }
            }
            $shipmentStopInfo .= '<StopType>' . $shipmentStops[17] . '</StopType>';
            $shipmentStopInfo .= '<Address>';
            $shipmentStopInfo .= '<CompanyName>' . $shipmentStops[18]['tripStopLocationName'] . '</CompanyName>';
            $shipmentStopInfo .= '<Address1>' . (empty($shipmentStops[18]['tripStopAddressAry'][0]) ? "" : $shipmentStops[18]['tripStopAddressAry'][0]) . '</Address1>';
            $shipmentStopInfo .= '<Address2>' . (empty($shipmentStops[18]['tripStopAddressAry'][1]) ? "" : $shipmentStops[18]['tripStopAddressAry'][1]) . '</Address2>';
            $shipmentStopInfo .= '<Street>' . $emptyValue . '</Street>';
            $shipmentStopInfo .= '<City>' . $shipmentStops[18]['tripStopCity'] . '</City>';
            $shipmentStopInfo .= '<State>' . $shipmentStops[18]['tripStopProvince'] . '</State>';
            $shipmentStopInfo .= '<Province>' . $shipmentStops[18]['tripStopProvince'] . '</Province>';
            $shipmentStopInfo .= '<Postal>' . $shipmentStops[18]['tripStopPostalCode'] . '</Postal>';
            $shipmentStopInfo .= '<Country>' . $shipmentStops[18]['tripStopCountryCode'] . '</Country>';
            $shipmentStopInfo .= '<Latitude>' . $shipmentStops[18]['tripStopLatitude'] . '</Latitude>';
            $shipmentStopInfo .= '<Longitude>' . $shipmentStops[18]['tripStopLongitude'] . '</Longitude>';
            $shipmentStopInfo .= '<ContactInfo>';
            $shipmentStopInfo .= '<CountryCode>' . $shipmentStops[18]['tripStopCountryCode'] . '</CountryCode>';
            $shipmentStopInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
            $shipmentStopInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
            $shipmentStopInfo .= '</ContactInfo>';
            $shipmentStopInfo .= '</Address>';
            $shipmentStopInfo .= '</TripStop>';
        }
        $shipmentStopInfo .= '</TripStops>';
        return $shipmentStopInfo;
    }

    public function setVehicleInfo(array $vehicleTripAry): string
    {
        $emptyValue = "";
        $vehicleInfo = '<VehicleDetails>';
        $vehicleInfo .= '<VehicleTypeCode>' . $vehicleTripAry['truckName'][0] . '</VehicleTypeCode>';
        $vehicleInfo .= '<VehicleModelCode>' . $vehicleTripAry['truckName'][0] . '</VehicleModelCode>';
        $vehicleInfo .= '<RegistrationNumber>' . $emptyValue . '</RegistrationNumber>';
        $vehicleInfo .= '<License>' . $emptyValue . '</License>';
        $vehicleInfo .= '<ApplicableForDangerousGoods>' . $emptyValue . '</ApplicableForDangerousGoods>';
        $vehicleInfo .= '<CommodityType>' . $emptyValue . '</CommodityType>';
        $vehicleInfo .= '<Properties>';
        $vehicleInfo .= '<Weight>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</Weight>';
        $vehicleInfo .= '<Volume>';
        $vehicleInfo .= '<Min>0</Min>';
        $vehicleInfo .= '<Max>' . $vehicleTripAry['totalVolumeValue'] . '</Max>';
        $vehicleInfo .= '<UOM>' . $vehicleTripAry['totalVolumeUOM'] . '</UOM>';
        $vehicleInfo .= '</Volume>';
        $vehicleInfo .= '<Length>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</Length>';
        $vehicleInfo .= '<Width>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</Width>';
        $vehicleInfo .= '<Height>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</Height>';
        $vehicleInfo .= '<Distance>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</Distance>';
        $vehicleInfo .= '<DimensionGirth>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</DimensionGirth>';
        $vehicleInfo .= '<ShipmentUnit>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</ShipmentUnit>';
        $vehicleInfo .= '<PacketWeight>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</PacketWeight>';
        $vehicleInfo .= '<PacketVolume>';
        $vehicleInfo .= '<Min>' . $emptyValue . '</Min>';
        $vehicleInfo .= '<Max>' . $emptyValue . '</Max>';
        $vehicleInfo .= '<UOM>' . $emptyValue . '</UOM>';
        $vehicleInfo .= '</PacketVolume>';
        $vehicleInfo .= '</Properties>';
        $vehicleInfo .= '</VehicleDetails>';

        return $vehicleInfo;
    }

    public function setDriverInfo(array $driverAry): string
    {
        $emptyValue = "";
        $driverInfo = '<DriverDetails>';
        $driverInfo .= '<DriverId>' . $emptyValue . '</DriverId>';
        $driverInfo .= '<DriverName>' . $emptyValue . '</DriverName>';
        $driverInfo .= '<DriverLicence>' . $emptyValue . '</DriverLicence>';
        $driverInfo .= '<Address>';
        $driverInfo .= '<Address1>' . $emptyValue . '</Address1>';
        $driverInfo .= '<Address2>' . $emptyValue . '</Address2>';
        $driverInfo .= '<Street>' . $emptyValue . '</Street>';
        $driverInfo .= '<City>' . $emptyValue . '</City>';
        $driverInfo .= '<State>' . $emptyValue . '</State>';
        $driverInfo .= '<Province>' . $emptyValue . '</Province>';
        $driverInfo .= '<Postal>' . $emptyValue . '</Postal>';
        $driverInfo .= '<Country>' . $emptyValue . '</Country>';
        $driverInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
        $driverInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
        $driverInfo .= '<ContactInfo>';
        $driverInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
        $driverInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
        $driverInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
        $driverInfo .= '</ContactInfo>';
        $driverInfo .= '</Address>';
        $driverInfo .= '</DriverDetails>';

        return $driverInfo;
    }

    public function setCargoSummaryTripInfo(array $cargoSummaryTripAry): string
    {
        $cargoSummaryTripInfo = '<CargoSummary>';
        $cargoSummaryTripInfo .= '<TotalQuantity>';
        $cargoSummaryTripInfo .= '<Value>' . $cargoSummaryTripAry['totalQuantityValue'] . '</Value>';
        $cargoSummaryTripInfo .= '<UOM>Numbers</UOM>';
        $cargoSummaryTripInfo .= '</TotalQuantity>';
        $cargoSummaryTripInfo .= '<TotalVolume>';
        $cargoSummaryTripInfo .= '<Value>' . $cargoSummaryTripAry['totalVolumeValue'] . '</Value>';
        $cargoSummaryTripInfo .= '<UOM>' . $cargoSummaryTripAry['totalVolumeUOM'] . '</UOM>';
        $cargoSummaryTripInfo .= '</TotalVolume>';
        $cargoSummaryTripInfo .= '<TotalWeight>';
        $cargoSummaryTripInfo .= '<Value>' . $cargoSummaryTripAry['totalWeightValue'] . '</Value>';
        $cargoSummaryTripInfo .= '<UOM>' . $cargoSummaryTripAry['totalWeightUOM'] . '</UOM>';
        $cargoSummaryTripInfo .= '</TotalWeight>';
        $cargoSummaryTripInfo .= '</CargoSummary>';

        return $cargoSummaryTripInfo;
    }

    public function setTripAddonsInfo(array $tripAddonsAry): string
    {
        $emptyValue = '';
        $addonsInfo = '<ValueAddedServices>';
        foreach ($tripAddonsAry as $tripAddons) {
            $addonsInfo .= '<Addon>';
            $addonsInfo .= '<AddonName>' . $tripAddons[0] . '</AddonName>';
            $addonsInfo .= '<AddonCode>' . $emptyValue . '</AddonCode>';
            $addonsInfo .= '<Currency>' . $emptyValue . '</Currency>';
            $addonsInfo .= '<RateUnit>' . $emptyValue . '</RateUnit>';
            $addonsInfo .= '<AddonAmount>' . $emptyValue . '</AddonAmount>';
            $addonsInfo .= '<AddonQuantity>' . $emptyValue . '</AddonQuantity>';
            $addonsInfo .= '</Addon>';
        }
        $addonsInfo .= '</ValueAddedServices>';

        return $addonsInfo;
    }
    
    public function getCustomerInfo(array $organizationAry, string $domainName): array
    {
		$customerId = $customerName = $registrationNumber = $address1 = $address2 = $street = "";
		$province = $city = $state = $postal = $country = $latitude = $longitude = "";
		$countryCode = $contactNo = $emailAddress = "";
		$customerName = $this->ci->otmBookingModel->getPartyType($organizationAry['organizationId'], $organizationAry['businessEntityValue']);
		//log_message("error","customerName".$customerName);
		$customerDetails = $this->ci->otmBookingModel->getCustomerInfo($organizationAry['organizationId'], $organizationAry['businessEntityValue'], $customerName);
		foreach ($customerDetails as $customerDet)
		{
			$customerId = $customerDet['code'];
			$customerName = $customerDet['name'];
			$registrationNumber = $customerDet['customer_code'];
			$address1 = $customerDet['address'];
			$address2 = $customerDet['house_number'];
			$street = $customerDet['street'];
			$province = $customerDet['state'];
			$city = $customerDet['street'];
			$state = $customerDet['state'];
			$postal = $customerDet['pincode'];
			$country = $customerDet['country'];
			$latitude = $customerDet['latitude'];
			$longitude = $customerDet['longitude'];
			$countryCode = $customerDet['country'];
			$contactNo = $customerDet['mobile'];
			$emailAddress = $customerDet['email'];
		}
        $customerAry = [
			'customerId' => $customerId,
			'customerName' => $customerName,
			'registrationNumber' => $registrationNumber,
			'address1' => $address1,
			'address2' => $address2,
			'street' => $street,
			'province' => $province,
			'city' => $city,
			'state' => $state,
			'postal' => $postal,
			'country' => $country,
			'latitude' => $latitude,
			'longitude' => $longitude,
			'countryCode' => $countryCode,
			'contactNo' => $contactNo,
			'emailAddress' => $emailAddress,
		];

		return $customerAry;
	}

    /* public function getCustomerInfo(string $domainName): array
    {
        $customerId = $customerName = $registrationNumber = $address1 = $address2 = $street = "";
        $province = $city = $state = $postal = $country = $latitude = $longitude = "";
        $countryCode = $contactNo = $emailAddress = "";
        $customerDetails = $this->ci->otmTripModel->getCustomerInfo($domainName);
        if ($customerDetails->num_rows() > 0) {
            $customerId = $customerDetails->row()->customer_code;
            $customerName = $customerDetails->row()->name;
            $registrationNumber = $customerDetails->row()->customer_code;
            $address1 = $customerDetails->row()->address1;
            $address2 = $customerDetails->row()->address2;
            $street = $customerDetails->row()->street;
            $province = $customerDetails->row()->province;
            $city = $customerDetails->row()->city;
            $state = $customerDetails->row()->state;
            $postal = $customerDetails->row()->zipcode;
            $country = $customerDetails->row()->country;
            $latitude = $customerDetails->row()->latitude;
            $longitude = $customerDetails->row()->longitude;
            $countryCode = $customerDetails->row()->country;
            $contactNo = $customerDetails->row()->phone;
            $emailAddress = $customerDetails->row()->email;
        }

        $customerAry = [
            'customerId' => $customerId,
            'customerName' => $customerName,
            'registrationNumber' => $registrationNumber,
            'address1' => $address1,
            'address2' => $address2,
            'street' => $street,
            'province' => $province,
            'city' => $city,
            'state' => $state,
            'postal' => $postal,
            'country' => $country,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'countryCode' => $countryCode,
            'contactNo' => $contactNo,
            'emailAddress' => $emailAddress,
        ];
        return $customerAry;
    }*/

    public function getShipFromLocationInfo(array $shipFromLocationRef, array $locationAry): array
    {
        $shipFromLocationXid = (string) $shipFromLocationRef[0]->xpath('LocationRef/LocationGid/Gid/Xid')[0];
        $shipFromLocationName = $shipFromAddressAry = $shipFromCity = $shipFromProvince = $shipFromProvinceCode = "";
        $shipFromPostalCode = $shipFromCountryCode = $shipFromLatitude = $shipFromLongitude = "";
        foreach ($locationAry as $location) {
            $locationXid = (string) $location[0]->xpath('LocationGid/Gid/Xid')[0];
            $sourceAry = [];

            if ($locationXid == $shipFromLocationXid) {
                $shipFromLocationName = empty($location[0]->xpath('LocationName')) ? 0 : (string) $location[0]->xpath('LocationName')[0];
                $shipFromAddress = empty($location[0]->xpath('Address/AddressLines')) ? [] : $location[0]->xpath('Address/AddressLines');
                $shipFromAddressAry = [];
                foreach ($shipFromAddress as $fromAddress) {
                    $address = empty($fromAddress->xpath('AddressLine')[0]) ? "" : $fromAddress->xpath('AddressLine')[0];
                    array_push($shipFromAddressAry, $address);
                }
                $shipFromCity = empty($location[0]->xpath('Address/City')) ? 0 : (string) $location[0]->xpath('Address/City')[0];
                $shipFromProvince = empty($location[0]->xpath('Address/Province')) ? 0 : (string) $location[0]->xpath('Address/Province')[0];
                $shipFromProvinceCode = empty($location[0]->xpath('Address/ProvinceCode')) ? 0 : (string) $location[0]->xpath('Address/ProvinceCode')[0];
                $shipFromPostalCode = empty($location[0]->xpath('Address/PostalCode')) ? 0 : (string) $location[0]->xpath('Address/PostalCode')[0];
                $shipFromCountryCode = empty($location[0]->xpath('Address/CountryCode3Gid/Gid/Xid')) ? 0 : (string) $location[0]->xpath('Address/CountryCode3Gid/Gid/Xid')[0];
                $shipFromLatitude = empty($location[0]->xpath('Address/Latitude')) ? 0 : (string) $location[0]->xpath('Address/Latitude')[0];
                $shipFromLongitude = empty($location[0]->xpath('Address/Longitude')) ? 0 : (string) $location[0]->xpath('Address/Longitude')[0];
            }
            $sourceAry = [
                'shipFromLocationId' => $shipFromLocationXid,
                'shipFromLocationName' => $shipFromLocationName,
                'shipFromAddressAry' => $shipFromAddressAry,
                'shipFromCity' => $shipFromCity,
                'shipFromProvince' => $shipFromProvince,
                'shipFromProvinceCode' => $shipFromProvinceCode,
                'shipFromPostalCode' => $shipFromPostalCode,
                'shipFromCountryCode' => $shipFromCountryCode,
                'shipFromLatitude' => $shipFromLatitude,
                'shipFromLongitude' => $shipFromLongitude,
            ];
        }
        return $sourceAry;
    }

    public function getShipToLocationInfo(array $shipToLocationRef, array $locationAry): array
    {
        $shipToLocationXid = (string) $shipToLocationRef[0]->xpath('LocationRef/LocationGid/Gid/Xid')[0];
        $shipToLocationName = $shipToAddressAry = $shipToCity = $shipToProvince = $shipToProvinceCode = "";
        $shipToPostalCode = $shipToCountryCode = $shipToLatitude = $shipToLongitude = "";
        foreach ($locationAry as $location) {
            $locationXid = (string) $location[0]->xpath('LocationGid/Gid/Xid')[0];
            $destinationAry = [];
            if ($locationXid == $shipToLocationXid) {
                $shipToLocationName = empty($location[0]->xpath('LocationName')) ? 0 : (string) $location[0]->xpath('LocationName')[0];
                $shipToAddress = empty($location[0]->xpath('Address/AddressLines')) ? [] : $location[0]->xpath('Address/AddressLines');
                $shipToAddressAry = [];

                foreach ($shipToAddress as $toAddress) {
                    $address = empty($toAddress->xpath('AddressLine')[0]) ? "" : $toAddress->xpath('AddressLine')[0];
                    array_push($shipToAddressAry, $address);
                }

                $shipToCity = empty($location[0]->xpath('Address/City')) ? 0 : (string) $location[0]->xpath('Address/City')[0];
                $shipToProvince = empty($location[0]->xpath('Address/Province')) ? 0 : (string) $location[0]->xpath('Address/Province')[0];
                $shipToProvinceCode = empty($location[0]->xpath('Address/ProvinceCode')) ? 0 : (string) $location[0]->xpath('Address/ProvinceCode')[0];
                $shipToPostalCode = empty($location[0]->xpath('Address/PostalCode')) ? 0 : (string) $location[0]->xpath('Address/PostalCode')[0];
                $shipToCountryCode = empty($location[0]->xpath('Address/CountryCode3Gid/Gid/Xid')) ? 0 : (string) $location[0]->xpath('Address/CountryCode3Gid/Gid/Xid')[0];
                $shipToLatitude = empty($location[0]->xpath('Address/Latitude')) ? 0 : (string) $location[0]->xpath('Address/Latitude')[0];
                $shipToLongitude = empty($location[0]->xpath('Address/Longitude')) ? 0 : (string) $location[0]->xpath('Address/Longitude')[0];
            }
            $destinationAry = [
                'shipToLocationId' => $shipToLocationXid,
                'shipToLocationName' => $shipToLocationName,
                'shipToAddressAry' => $shipToAddressAry,
                'shipToCity' => $shipToCity,
                'shipToProvince' => $shipToProvince,
                'shipToProvinceCode' => $shipToProvinceCode,
                'shipToPostalCode' => $shipToPostalCode,
                'shipToCountryCode' => $shipToCountryCode,
                'shipToLatitude' => $shipToLatitude,
                'shipToLongitude' => $shipToLongitude,
            ];
        }
        return $destinationAry;
    }

    public function getCargoSummary(array $totalWeightVolume, array $totalPackagedItemCount): array
    {
        $totalWeight = $totalWeightVolume[0]->xpath('WeightVolume/Weight');
        $totalVolume = $totalWeightVolume[0]->xpath('WeightVolume/Volume');

        $totalWeightValue = empty($totalWeight[0]->xpath('WeightValue')) ? '0' : (string) $totalWeight[0]->xpath('WeightValue')[0];
        $totalWeightUOM = empty($totalWeight[0]->xpath('WeightUOMGid/Gid/Xid')) ? 0 : (string) $totalWeight[0]->xpath('WeightUOMGid/Gid/Xid')[0];
        $totalVolumeValue = empty($totalVolume[0]->xpath('VolumeValue')) ? 0 : (string) $totalVolume[0]->xpath('VolumeValue')[0];
        $totalVolumeUOM = empty($totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')) ? 0 : (string) $totalVolume[0]->xpath('VolumeUOMGid/Gid/Xid')[0];
        $totalQuantityValue = empty($totalPackagedItemCount) ? 0 : $totalPackagedItemCount[0];

        $cargoSummaryAry = [
            'totalWeightValue' => $totalWeightValue,
            'totalWeightUOM' => $totalWeightUOM,
            'totalVolumeValue' => $totalVolumeValue,
            'totalVolumeUOM' => $totalVolumeUOM,
            'totalQuantityValue' => $totalQuantityValue,
        ];
        return $cargoSummaryAry;
    }

    public function getShipUnitInfo(array $releaseLine, array $shipUnit): array
    {
        $innerReleaseLines = $releaseLine;
        $shipUnits = empty($shipUnit) ? [] : $shipUnit;
        $outerCargos = [];
        foreach ($shipUnits as $shipUnit) {
            $shipUnitContent = $shipUnit[0]->xpath('ShipUnitContent')[0];
            $shipUnitCargoId = (string) $shipUnit[0]->xpath('ShipUnitGid/Gid/Xid')[0];

            $packaging = empty((array) $shipUnit->xpath('ShipUnitContent/PackagedItemRef/PackagedItem/Packaging')) ? [] : (array) $shipUnit->xpath('ShipUnitContent/PackagedItemRef/PackagedItem/Packaging');

            /*if(sizeof($packaging) != 0) {
            $packagingWeightVolume = $packaging[0]->xpath('PackageShipUnitWeightVolume');
            $packagingDimensions = $packaging[0]->xpath('PackageShipUnitLWH');
            }*/

            $packagingWeightVolume = $shipUnit[0]->xpath('WeightVolume')[0];

            $shipUnitPackagingWeightVolume = $shipUnit->xpath('WeightVolume');
            $shipUnitPackagingDimensions = $shipUnit->xpath('LengthWidthHeight');

            $outerPackageType = $outerPackageDesc = $outerPackageWeightUOM = $outerPackageVolumeUOM = $outerPackageLengthUOM = $outerPackageWidthUOM = $outerPackageHeightUOM = "";
            $outerPackageWeightValue = $outerPackageVolumeValue = $outerPackageLengthValue = $outerPackageWidthValue = $outerPackageHeightValue = 0;

            $outerPackageQuantity = empty((string) $shipUnit[0]->xpath('ShipUnitCount')[0]) ? "0" : (string) $shipUnit[0]->xpath('ShipUnitCount')[0];

            if (!empty($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemGid'))) {
                $outerPackageType = is_array($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemGid/Gid/Xid')[0]) ? 0 : $shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemGid/Gid/Xid')[0];
            } else if (!empty($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItemGid'))) {
                $outerPackageType = is_array($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0]) ? 0 : $shipUnitContent[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0];
            }

            $outerPackageDesc = $outerPackageType;

            /*$outerPackageQuantity = empty((string)$shipUnit[0]->xpath('ShipUnitContent/ItemQuantity/PackagedItemCount')[0]) ? "0" : (string)$shipUnit[0]->xpath('ShipUnitContent/ItemQuantity/PackagedItemCount')[0];*/

            /*if(!empty($shipUnitContent[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid')))
            {
            $outerPackageType = is_array($shipUnitContent[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0]) ? 0 : $shipUnitContent[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0];
            }
            elseif(!empty($packaging) && !empty($packaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef')))
            {
            $outerPackageType = is_array($packaging[0]->xpath('PackagedItemRefPackagedItemSpecRef/ShipUnitSpecRef/Gid/Xid')[0]) ? 0 : $packaging[0]->xath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0];
            }
            elseif(!empty($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid')))
            {
            $outerPackageType = is_array($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
            }
            elseif(!empty($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItemGid')))
            {
            $outerPackageType = is_array($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0]) ? 0 : $shipUnitContent[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0];
            }

            if(!empty($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')))
            {
            $outerPackageDesc = is_array($shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0]) ? 0 : $shipUnitContent[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0];
            }
            elseif(!empty($packaging) && !empty($packaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid')))
            {
            $outerPackageDesc = is_array($packaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $packaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
            }
            else
            {
            $outerPackageDesc = $outerPackageType;
            }*/

            if (!empty($packagingWeightVolume)) {
                $outerPackageWeightValue = empty((string) $packagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $packagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                $outerPackageWeightUOM = empty((string) $packagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 'DEFAULT WEIGHT' : (string) $packagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                $outerPackageVolumeValue = empty((string) $packagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $packagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                $outerPackageVolumeUOM = empty((string) $packagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 'DEFAULT VOLUME' : (string) $packagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
            }

            /*if(!empty($packagingWeightVolume))
            {
            $outerPackageWeightValue = empty((string)$packagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string)$packagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
            $outerPackageWeightUOM = empty((string)$packagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string)$packagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
            $outerPackageVolumeValue = empty((string)$packagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string)$packagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
            $outerPackageVolumeUOM = empty((string)$packagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string)$packagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
            }
            elseif(!empty($shipUnitPackagingWeightVolume))
            {
            $outerPackageWeightValue = empty((string)$shipUnitPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string)$shipUnitPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
            $outerPackageWeightUOM = empty((string)$shipUnitPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
            $outerPackageVolumeValue = empty((string)$shipUnitPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string)$shipUnitPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
            $outerPackageVolumeUOM = empty((string)$shipUnitPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
            }*/

            /*if(!empty($packagingDimensions))
            {
            $outerPackageLengthValue = empty((string)$packagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string)$packagingDimensions[0]->xpath('Length/LengthValue')[0];
            $outerPackageLengthUOM = empty((string)$packagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 0 : (string)$packagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
            $outerPackageWidthValue = empty((string)$packagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string)$packagingDimensions[0]->xpath('Width/WidthValue')[0];
            $outerPackageWidthUOM = empty((string)$packagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 0 : (string)$packagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
            $outerPackageHeightValue = empty((string)$packagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string)$packagingDimensions[0]->xpath('Height/HeightValue')[0];
            $outerPackageHeightUOM = empty((string)$packagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 0 : (string)$packagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
            }
            elseif(!empty($shipUnitPackagingDimensions))
            {
            $outerPackageLengthValue = empty((string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthValue')[0];
            $outerPackageLengthUOM = empty((string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
            $outerPackageWidthValue = empty((string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthValue')[0];
            $outerPackageWidthUOM = empty((string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
            $outerPackageHeightValue = empty((string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightValue')[0];
            $outerPackageHeightUOM = empty((string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 0 : (string)$shipUnitPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
            }*/

            $releaseLines = $shipUnit[0]->xpath('ShipUnitContent/ReleaseLineGid/Gid');
            $innerCargosAry = [];
            foreach ($releaseLines as $releaseLine) {
                $outerReleaseLineXid = (string) $releaseLine->xpath('Xid')[0];
                foreach ($innerReleaseLines as $innerReleaseLine) {
                    $innerReleaseLineXid = (string) $innerReleaseLine[0]->xpath('ReleaseLineGid/Gid/Xid')[0];
                    if (strcasecmp($innerReleaseLineXid, $outerReleaseLineXid) == 0) {
                        $innerPackaging = empty($innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging')) ? [] : $innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging');

                        if (!empty($innerReleaseLine->xpath('PackageDimensions'))) {
                            $innerPackagingDimensions = $innerReleaseLine->xpath('PackageDimensions');
                        } elseif (!empty($innerPackaging)) {
                            $innerPackagingDimensions = $innerPackaging[0]->xpath('PackageShipUnitLWH');
                        }

                        if (!empty($innerReleaseLine->xpath('ItemQuantity'))) {
                            $innerPackagingWeightVolume = $innerReleaseLine->xpath('ItemQuantity/WeightVolume');
                        } elseif (!empty($innerPackaging)) {
                            $innerPackagingWeightVolume = $innerPackaging[0]->xpath('PackageShipUnitWeightVolume');
                        }

                        //$itemInnerPackaging = $innerReleaseLine->xpath('ItemQuantity/WeightVolume');

                        $innerPackageType = $innerPackageDesc = $innerPackageType = $innerPackageWeightUOM = $innerPackageVolumeUOM = $innerPackageLengthUOM = $innerPackageWidthUOM = $innerPackageHeightUOM = "";
                        $innerPackageQuantity = $innerPackageWeightValue = $innerPackageVolumeValue = $innerPackageLengthValue = $innerPackageWidthValue = $innerPackageHeightValue = 0;

                        $innerPackageQuantity = empty((string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0]) ? "0" : (string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0];
                        if (!empty($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid'))) {
                            $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0];
                        } elseif (!empty($innerPackaging) && !empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef'))) {
                            $innerPackageType = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0];
                        } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                            $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                        } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid'))) {
                            $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0];
                        }

                        if (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description'))) {
                            $innerPackageDesc = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0];
                        } elseif (!empty($innerPackaging) && !empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                            $innerPackageDesc = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                        } else {
                            $innerPackageDesc = $innerPackageType;
                        }

                        if (!empty($innerPackagingWeightVolume)) {
                            $innerPackageWeightValue = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                            $innerPackageWeightUOM = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                            $innerPackageVolumeValue = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                            $innerPackageVolumeUOM = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
                        } else {
                            $innerPackageWeightValue = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                            $innerPackageWeightUOM = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                            $innerPackageVolumeValue = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                            $innerPackageVolumeUOM = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
                        }
                        if (!empty($innerPackagingDimensions)) {
                            $innerPackageLengthValue = empty($innerPackagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthValue')[0];
                            $innerPackageLengthUOM = empty($innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
                            $innerPackageWidthValue = empty($innerPackagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthValue')[0];
                            $innerPackageWidthUOM = empty($innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
                            $innerPackageHeightValue = empty($innerPackagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightValue')[0];
                            $innerPackageHeightUOM = empty($innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
                        }

                        $innerCargos = [];
                        $innerCargos = [
                            'externalInnerCargoId' => $innerReleaseLineXid,
                            'innerPackageType' => $innerPackageType,
                            'innerPackageDesc' => $innerPackageDesc,
                            'innerPackageWeightValue' => $innerPackageWeightValue,
                            'innerPackageWeightUOM' => $innerPackageWeightUOM,
                            'innerPackageVolumeValue' => $innerPackageVolumeValue,
                            'innerPackageVolumeUOM' => $innerPackageVolumeUOM,
                            'innerPackageLengthValue' => $innerPackageLengthValue,
                            'innerPackageLengthUOM' => $innerPackageLengthUOM,
                            'innerPackageWidthValue' => $innerPackageWidthValue,
                            'innerPackageWidthUOM' => $innerPackageWidthUOM,
                            'innerPackageHeightValue' => $innerPackageHeightValue,
                            'innerPackageHeightUOM' => $innerPackageHeightUOM,
                            'innerPackageQuantity' => $innerPackageQuantity,
                        ];
                        array_push($innerCargosAry, $innerCargos);
                    }
                }
            }
            $shipUnitsAry = [];
            $shipUnitsAry = [
                'externalOuterCargoId' => $shipUnitCargoId,
                'outerPackageType' => $outerPackageType,
                'outerPackageDesc' => $outerPackageDesc,
                'outerPackageWeightValue' => $outerPackageWeightValue,
                'outerPackageWeightUOM' => $outerPackageWeightUOM,
                'outerPackageVolumeValue' => $outerPackageVolumeValue,
                'outerPackageVolumeUOM' => $outerPackageVolumeUOM,
                'outerPackageLengthValue' => $outerPackageLengthValue,
                'outerPackageLengthUOM' => $outerPackageLengthUOM,
                'outerPackageWidthValue' => $outerPackageWidthValue,
                'outerPackageWidthUOM' => $outerPackageWidthUOM,
                'outerPackageHeightValue' => $outerPackageHeightValue,
                'outerPackageHeightUOM' => $outerPackageHeightUOM,
                'outerPackageQuantity' => $outerPackageQuantity,
                'innerCargos' => $innerCargosAry,
            ];
            array_push($outerCargos, $shipUnitsAry);
        }
        return $outerCargos;
    }

    public function getReleaseLineInfo(array $releaseLine, array $shipUnit): array
    {
        $innerReleaseLines = $releaseLine;
        $shipUnits = empty($shipUnit) ? [] : $shipUnit;
        $outerReleaseCargos = [];
        foreach ($innerReleaseLines as $innerReleaseLine) {
            $outerReleaseLineXid = (string) $innerReleaseLine->xpath('ReleaseLineGid/Gid/Xid')[0];
            $incValue = 0;
            if (sizeof($shipUnits) == 0) {
                $incValue++;
            }
            $releaseLineValue = 0;
            foreach ($shipUnits as $shipUnit) {
                $releaseLines = $shipUnit->xpath('ShipUnitContent/ReleaseLineGid/Gid');
                $innerReleaseLineXid = (string) $releaseLines[0]->xpath('Xid')[0];

                if ($innerReleaseLineXid == $outerReleaseLineXid) {
                    $releaseLineValue++;
                }
            }
            if ($incValue >= 1 || $releaseLineValue == 0) {

                /*$innerPackaging = $innerReleaseLine->xpath('PackagedItemRef/PackagedItem/Packaging');
                $innerPackagingWeightVolume = $innerPackaging[0]->xpath('PackageShipUnitWeightVolume');
                $innerPackagingDimensions = $innerPackaging[0]->xpath('PackageShipUnitLWH');*/

                if (!empty($innerReleaseLine->xpath('PackageDimensions'))) {
                    $innerPackagingDimensions = $innerReleaseLine->xpath('PackageDimensions');
                } elseif (!empty($innerPackaging)) {
                    $innerPackagingDimensions = $innerPackaging[0]->xpath('PackageShipUnitLWH');
                }

                if (!empty($innerReleaseLine->xpath('ItemQuantity'))) {
                    $innerPackagingWeightVolume = $innerReleaseLine->xpath('ItemQuantity/WeightVolume');
                } elseif (!empty($innerPackaging)) {
                    $innerPackagingWeightVolume = $innerPackaging[0]->xpath('PackageShipUnitWeightVolume');
                }

                //$itemInnerPackaging = $innerReleaseLine->xpath('ItemQuantity/WeightVolume');

                $innerPackageDesc = $innerPackageType = $innerPackageWeightUOM = $innerPackageVolumeUOM = $innerPackageLengthUOM = $innerPackageWidthUOM = $innerPackageHeightUOM = "";
                $innerPackageQuantity = $innerPackageWeightValue = $innerPackageVolumeValue = $innerPackageLengthValue = $innerPackageWidthValue = $innerPackageHeightValue = 0;

                $innerPackageQuantity = empty((string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0]) ? "0" : (string) $innerReleaseLine[0]->xpath('ItemQuantity/PackagedItemCount')[0];

                if (!empty($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid'))) {
                    $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecGid/Gid/Xid')[0];
                } elseif (!empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Packaging/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef'))) {
                    $innerPackageType = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemSpecRef/ShipUnitSpecRef/ShipUnitSpecRef/Gid/Xid')[0];
                } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                    $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                } elseif (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid'))) {
                    $innerPackageType = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItemGid/Gid/Xid')[0];
                }

                if (!empty($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description'))) {
                    $innerPackageDesc = is_array($innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0]) ? 0 : $innerReleaseLine[0]->xpath('PackagedItemRef/PackagedItem/Item/Description')[0];
                } elseif (!empty($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid'))) {
                    $innerPackageDesc = is_array($innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0]) ? 0 : $innerPackaging[0]->xpath('PackagedItemRef/PackagedItem/Item/ItemGid/Gid/Xid')[0];
                } else {
                    $innerPackageDesc = $innerPackageType;
                }

                if (!empty($innerPackagingWeightVolume)) {
                    $innerPackageWeightValue = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                    $innerPackageWeightUOM = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                    $innerPackageVolumeValue = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                    $innerPackageVolumeUOM = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
                } else {
                    $innerPackageWeightValue = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightValue')[0];
                    $innerPackageWeightUOM = empty($innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Weight/WeightUOMGid/Gid/Xid')[0];
                    $innerPackageVolumeValue = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeValue')[0];
                    $innerPackageVolumeUOM = empty($innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingWeightVolume[0]->xpath('Volume/VolumeUOMGid/Gid/Xid')[0];
                }

                if (!empty($innerPackagingDimensions)) {
                    $innerPackageLengthValue = empty($innerPackagingDimensions[0]->xpath('Length/LengthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthValue')[0];
                    $innerPackageLengthUOM = empty($innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Length/LengthUOMGid/Gid/Xid')[0];
                    $innerPackageWidthValue = empty($innerPackagingDimensions[0]->xpath('Width/WidthValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthValue')[0];
                    $innerPackageWidthUOM = empty($innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Width/WidthUOMGid/Gid/Xid')[0];
                    $innerPackageHeightValue = empty($innerPackagingDimensions[0]->xpath('Height/HeightValue')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightValue')[0];
                    $innerPackageHeightUOM = empty($innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0]) ? 0 : (string) $innerPackagingDimensions[0]->xpath('Height/HeightUOMGid/Gid/Xid')[0];
                }

                $releaseLineAry = [];
                $releaseLineAry = [
                    'externalOuterCargoId' => $innerReleaseLineXid,
                    'outerPackageType' => $innerPackageType,
                    'outerPackageDesc' => $innerPackageDesc,
                    'outerPackageWeightValue' => $innerPackageWeightValue,
                    'outerPackageWeightUOM' => $innerPackageWeightUOM,
                    'outerPackageVolumeValue' => $innerPackageVolumeValue,
                    'outerPackageVolumeUOM' => $innerPackageVolumeUOM,
                    'outerPackageLengthValue' => $innerPackageLengthValue,
                    'outerPackageLengthUOM' => $innerPackageLengthUOM,
                    'outerPackageWidthValue' => $innerPackageWidthValue,
                    'outerPackageWidthUOM' => $innerPackageWidthUOM,
                    'outerPackageHeightValue' => $innerPackageHeightValue,
                    'outerPackageHeightUOM' => $innerPackageHeightUOM,
                    'outerPackageQuantity' => $innerPackageQuantity,
                ];

                array_push($outerReleaseCargos, $releaseLineAry);
            }

        }
        return $outerReleaseCargos;
    }

    public function getManageReferences(array $release): array
    {
        $referencesAry = [];
        if (!empty($release)) {
            foreach ($release as $releaseRefNum) {
                $refCode = empty($releaseRefNum->xpath('ReleaseRefnumQualifierGid/Gid/Xid')[0]) ? 0 : $releaseRefNum->xpath('ReleaseRefnumQualifierGid/Gid/Xid')[0];
                $refValue = (string) $releaseRefNum->xpath('ReleaseRefnumValue')[0];
                $references = [];
                array_push($references, $refCode);
                array_push($references, $refValue);
                array_push($referencesAry, $references);
            }
        }

        return $referencesAry;
    }

    public function getRemarks(array $release): array
    {
        $remarksAry = [];
        if (!empty($release)) {
            foreach ($release as $remark) {
                $remarkCode = empty($remark->xpath('RemarkQualifierGid/Gid/Xid')[0]) ? 0 : $remark->xpath('RemarkQualifierGid/Gid/Xid')[0];
                $remarkValue = (string) $remark->xpath('RemarkText')[0];
                $remarks = [];
                array_push($remarks, $remarkCode);
                array_push($remarks, $remarkValue);
                array_push($remarksAry, $remarks);
            }
        }
        return $remarksAry;
    }

    public function getTimeWindow(array $release): array
    {
        $timeWindow = $release;

        $earlyPickupDate = empty($timeWindow[0]->xpath('EarlyPickupDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s", strtotime((integer) $timeWindow[0]->xpath('EarlyPickupDt/GLogDate')[0]));
        $earlyPickupTime = empty($timeWindow[0]->xpath('EarlyPickupDt/TZId')) ? "" : (string) $timeWindow[0]->xpath('EarlyPickupDt/TZId')[0];
        $earlyPickupZone = empty($timeWindow[0]->xpath('EarlyPickupDt/TZOffset')) ? "" : (string) $timeWindow[0]->xpath('EarlyPickupDt/TZOffset')[0];
        $earlyPickupTimeZone = empty($earlyPickupZone) ? "" : $earlyPickupZone . "/" . $earlyPickupTime;

        $latePickupDate = empty($timeWindow[0]->xpath('LatePickupDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s", strtotime((integer) $timeWindow[0]->xpath('LatePickupDt/GLogDate')[0]));
        $latePickupTime = empty($timeWindow[0]->xpath('LatePickupDt/TZId')) ? "" : (string) $timeWindow[0]->xpath('LatePickupDt/TZId')[0];
        $latePickupZone = empty($timeWindow[0]->xpath('LatePickupDt/TZOffset')) ? "" : (string) $timeWindow[0]->xpath('LatePickupDt/TZOffset')[0];
        $latePickupTimeZone = empty($latePickupZone) ? "" : $latePickupZone . "/" . $latePickupTime;

        $earlyDeliveryDate = empty($timeWindow[0]->xpath('EarlyDeliveryDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s", strtotime((integer) $timeWindow[0]->xpath('EarlyDeliveryDt/GLogDate')[0]));
        $earlyDeliveryTime = empty($timeWindow[0]->xpath('EarlyDeliveryDt/TZId')) ? "" : (string) $timeWindow[0]->xpath('EarlyDeliveryDt/TZId')[0];
        $earlyDeliveryZone = empty($timeWindow[0]->xpath('EarlyDeliveryDt/TZOffset')) ? "" : (string) $timeWindow[0]->xpath('EarlyDeliveryDt/TZOffset')[0];
        $earlyDeliveryTimeZone = empty($earlyDeliveryZone) ? "" : $earlyDeliveryZone . "/" . $earlyDeliveryTime;

        $lateDeliveryDate = empty($timeWindow[0]->xpath('LateDeliveryDt/GLogDate')) ? "" : date("Y-m-d\TH:i:s", strtotime((integer) $timeWindow[0]->xpath('LateDeliveryDt/GLogDate')[0]));
        $lateDeliveryTime = empty($timeWindow[0]->xpath('LateDeliveryDt/TZId')) ? "" : (string) $timeWindow[0]->xpath('LateDeliveryDt/TZId')[0];
        $lateDeliveryZone = empty($timeWindow[0]->xpath('LateDeliveryDt/TZOffset')) ? "" : (string) $timeWindow[0]->xpath('LateDeliveryDt/TZOffset')[0];
        $lateDeliveryTimeZone = empty($lateDeliveryZone) ? "" : $lateDeliveryZone . "/" . $lateDeliveryTime;

        if ($earlyPickupDate == $lateDeliveryDate) {
            $earlyPickupDate = $lateDeliveryDate = "";
        }

        $timeWindowAry = [
            'earlyPickupDate' => $earlyPickupDate,
            'earlyPickupTimeZone' => $earlyPickupTimeZone,
            'latePickupDate' => $latePickupDate,
            'latePickupTimeZone' => $latePickupTimeZone,
            'earlyDeliveryDate' => $earlyDeliveryDate,
            'earlyDeliveryTimeZone' => $earlyDeliveryTimeZone,
            'lateDeliveryDate' => $lateDeliveryDate,
            'lateDeliveryTimeZone' => $lateDeliveryTimeZone,
        ];

        return $timeWindowAry;
    }

    public function getInvolvedParties(array $release): array
    {
        $involvedParties = empty($release) ? [] : $release;
        $involvedPartiesAry = [];
        foreach ($involvedParties as $involvedParty) {
            $partyType = empty((string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0]) ? "" : (string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0];
            $id = empty($involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')[0];
            $email = empty($involvedParty->xpath('ContactRef/Contact/EmailAddress')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/EmailAddress')[0];
            $firstName = empty($involvedParty->xpath('ContactRef/Contact/FirstName')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/FirstName')[0];
            $phone = empty($involvedParty->xpath('ContactRef/Contact/Phone1')) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/Phone1')[0];
            $parties = [];
            $parties = [
                'partyType' => $partyType,
                'id' => $id,
                'email' => $email,
                'firstName' => $firstName,
                'phone' => $phone,
            ];
            array_push($involvedPartiesAry, $parties);
        }
        return $involvedPartiesAry;
    }

    public function getBusinessParties(array $plannedShipment): array
    {
        $BusinessParties = empty($plannedShipment[0]->xpath('Release/InvolvedParty')) ? [] : $plannedShipment[0]->xpath('Release/InvolvedParty');
        $BusinessPartiesAry = [];
        foreach ($BusinessParties as $involvedParty) {
            $partyType = empty((string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0]) ? "" : (string) $involvedParty->xpath('InvolvedPartyQualifierGid/Gid/Xid')[0];
            $id = empty((string) $involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')[0]) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/ContactGid/Gid/Xid')[0];
            $email = empty((string) $involvedParty->xpath('ContactRef/Contact/EmailAddress')[0]) ? "" : (string) $involvedParty->xpath('ContactRef/Contact/EmailAddress')[0];
            $parties = [];
            $parties = [
                'partyType' => $partyType,
                'id' => $id,
                'email' => $email,
            ];
            array_push($BusinessPartiesAry, $parties);
        }
        return $BusinessPartiesAry;
    }

    public function setHeaderInfo(): string
    {
        $emptyValue = "";
        $headerInfo = '<SVKEDITripHeader>';
        $headerInfo .= '<EDIVersion>1.0</EDIVersion>';
        $headerInfo .= '<AckSpec>';
        $headerInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
        $headerInfo .= '<AckOption>' . $emptyValue . '</AckOption>';
        $headerInfo .= '</AckSpec>';
        $headerInfo .= '<SourceApp>OTM</SourceApp>';
        $headerInfo .= '<DestinationApp>SVKONEKT</DestinationApp>';
        $headerInfo .= '<ReferenceObject>Trip</ReferenceObject>';
        $headerInfo .= '<Action>I</Action>';
        $headerInfo .= '</SVKEDITripHeader>';

        return $headerInfo;
    }

    public function setOrganizationInfo(array $organizationAry, string $domainName): string
    {
        $organizationInfo = '<SVKOrgDetails>';
        $organizationInfo .= '<DomainName>' . $domainName . '</DomainName>';
        $organizationInfo .= '<Companycode>' . $organizationAry['organizationId'] . '</Companycode>';
        $organizationInfo .= '<Branchcode>' . $organizationAry['businessEntityValue'] . '</Branchcode>';
        $organizationInfo .= '<PhysicalReceiver></PhysicalReceiver>';
        $organizationInfo .= '<LogicalReceiver></LogicalReceiver>';
        $organizationInfo .= '<PhysicalSender></PhysicalSender>';
        $organizationInfo .= '<LogicalSender></LogicalSender>';
        $organizationInfo .= '</SVKOrgDetails>';

        return $organizationInfo;
    }

    public function setBookingHeaderInfo(string $bookingId, string $orderMovementId, $orderType, $modeOfTransport): string
    {
        $emptyValue = "";
        $bookingHeaderInfo = '<OrderID>' . $bookingId . '</OrderID>';
        $bookingHeaderInfo .= '<EXTOrderID>' . $bookingId . '</EXTOrderID>';
        $bookingHeaderInfo .= '<Transits>';
        $bookingHeaderInfo .= '<TransitLegId>' . $emptyValue . '</TransitLegId>';
        $bookingHeaderInfo .= '</Transits>';
        $bookingHeaderInfo .= '<OrderMovementId>' . $orderMovementId . '</OrderMovementId>';
        $bookingHeaderInfo .= '<OrderType>' . $orderType . '</OrderType>';
        $bookingHeaderInfo .= '<ModeOfTransport>' . $modeOfTransport . '</ModeOfTransport>';
        $bookingHeaderInfo .= '<Product>' . $emptyValue . '</Product>';
        $bookingHeaderInfo .= '<ServiceType>' . $emptyValue . '</ServiceType>';
        $bookingHeaderInfo .= '<GoodsValue>' . $emptyValue . '</GoodsValue>';
        $bookingHeaderInfo .= '<TypeOfBusiness>' . $emptyValue . '</TypeOfBusiness>';
        $bookingHeaderInfo .= '<TermsOfTrade>';
        $bookingHeaderInfo .= '<Incoterm>' . $emptyValue . '</Incoterm>';
        $bookingHeaderInfo .= '<FreightTerm>';
        $bookingHeaderInfo .= '<Term>' . $emptyValue . '</Term>';
        $bookingHeaderInfo .= '<Name>' . $emptyValue . '</Name>';
        $bookingHeaderInfo .= '</FreightTerm>';
        $bookingHeaderInfo .= '</TermsOfTrade>';

        return $bookingHeaderInfo;
    }

    /*public function setCustomerInfo(array $customerAry, string $status): string
    {
    $customerInfo = '';
    if($status == 'Y')
    {
    $customerInfo .= '<InvolvedParty>';
    $customerInfo .= '<PartyType>CUSTOMER</PartyType>';
    }
    else
    {
    $customerInfo .= '<SVKCUSTOMER>';
    }
    $customerInfo .= '<ID>'.$customerAry['customerId'].'</ID>';
    $customerInfo .= '<Company>';
    $customerInfo .= '<Name>'.$customerAry['customerName'].'</Name>';
    $customerInfo .= '<RegistrationNumber>'.$customerAry['customerId'].'</RegistrationNumber>';
    $customerInfo .= '</Company>';
    $customerInfo .= '<Address>';
    $customerInfo .= '<Address1>'.$customerAry['address1'].'</Address1>';
    $customerInfo .= '<Address2>'.$customerAry['address2'].'</Address2>';
    $customerInfo .= '<Street>'.$customerAry['street'].'</Street>';
    $customerInfo .= '<City>'.$customerAry['city'].'</City>';
    $customerInfo .= '<Province>'.$customerAry['province'].'</Province>';
    $customerInfo .= '<State>'.$customerAry['state'].'</State>';
    $customerInfo .= '<Postal>'.$customerAry['postal'].'</Postal>';
    $customerInfo .= '<Country>'.$customerAry['country'].'</Country>';
    $customerInfo .= '<Latitude>'.$customerAry['latitude'].'</Latitude>';
    $customerInfo .= '<Longitude>'.$customerAry['longitude'].'</Longitude>';
    $customerInfo .= '<ContactInfo>';
    $customerInfo .= '<CountryCode>'.$customerAry['countryCode'].'</CountryCode>';
    $customerInfo .= '<ContactNo>'.$customerAry['contactNo'].'</ContactNo>';
    $customerInfo .= '<EmailAddress>'.$customerAry['emailAddress'].'</EmailAddress>';
    $customerInfo .= '</ContactInfo>';
    $customerInfo .= '</Address>';
    if($status == 'N')
    {
    $customerInfo .= '</SVKCUSTOMER>';
    }
    else
    {
    $customerInfo .= '</InvolvedParty>';
    }

    return $customerInfo;
    }*/

    public function setCargoSummaryInfo(array $cargoSummaryAry): string
    {
        $cargoSummaryInfo = '<OrderCargoSummary>';
        $cargoSummaryInfo .= '<TotalQuantity>';
        $cargoSummaryInfo .= '<Value>' . $cargoSummaryAry['totalQuantityValue'] . '</Value>';
        $cargoSummaryInfo .= '<UOM>Numbers</UOM>';
        $cargoSummaryInfo .= '</TotalQuantity>';
        $cargoSummaryInfo .= '<Volume>';
        $cargoSummaryInfo .= '<Value>' . $cargoSummaryAry['totalVolumeValue'] . '</Value>';
        $cargoSummaryInfo .= '<UOM>' . $cargoSummaryAry['totalVolumeUOM'] . '</UOM>';
        $cargoSummaryInfo .= '</Volume>';
        $cargoSummaryInfo .= '<TotalVolume>';
        $cargoSummaryInfo .= '<Value>' . $cargoSummaryAry['totalVolumeValue'] . '</Value>';
        $cargoSummaryInfo .= '<UOM>' . $cargoSummaryAry['totalVolumeUOM'] . '</UOM>';
        $cargoSummaryInfo .= '</TotalVolume>';
        $cargoSummaryInfo .= '<ActualVolume>';
        $cargoSummaryInfo .= '<Value>' . $cargoSummaryAry['totalVolumeValue'] . '</Value>';
        $cargoSummaryInfo .= '<UOM>' . $cargoSummaryAry['totalVolumeUOM'] . '</UOM>';
        $cargoSummaryInfo .= '</ActualVolume>';
        $cargoSummaryInfo .= '<Weight>';
        $cargoSummaryInfo .= '<Value>' . $cargoSummaryAry['totalWeightValue'] . '</Value>';
        $cargoSummaryInfo .= '<UOM>' . $cargoSummaryAry['totalWeightUOM'] . '</UOM>';
        $cargoSummaryInfo .= '</Weight>';
        $cargoSummaryInfo .= '<TotalWeight>';
        $cargoSummaryInfo .= '<Value>' . $cargoSummaryAry['totalWeightValue'] . '</Value>';
        $cargoSummaryInfo .= '<UOM>' . $cargoSummaryAry['totalWeightUOM'] . '</UOM>';
        $cargoSummaryInfo .= '</TotalWeight>';
        $cargoSummaryInfo .= '<ActualWeight>';
        $cargoSummaryInfo .= '<Value>' . $cargoSummaryAry['totalWeightValue'] . '</Value>';
        $cargoSummaryInfo .= '<UOM>' . $cargoSummaryAry['totalWeightUOM'] . '</UOM>';
        $cargoSummaryInfo .= '</ActualWeight>';
        $cargoSummaryInfo .= '</OrderCargoSummary>';

        return $cargoSummaryInfo;
    }

    /*public function setShipFromLocationInfo(array $sourceAry, string $status): string
    {
    $emptyValue = $sourceInfo = '';
    if($status == 'Y')
    {
    $sourceInfo .= '<InvolvedParty>';
    $sourceInfo .= '<PartyType>SHIPPER</PartyType>';
    }
    else
    {
    $sourceInfo .= '<Source>';
    }
    $sourceInfo .= '<ID>'.$sourceAry['shipFromLocationName'].'</ID>';
    $sourceInfo .= '<Company>';
    $sourceInfo .= '<Name>'.$sourceAry['shipFromLocationName'].'</Name>';
    $sourceInfo .= '<RegistrationNumber>'.$sourceAry['shipFromLocationName'].'</RegistrationNumber>';
    $sourceInfo .= '</Company>';
    $sourceInfo .= '<Address>';
    $sourceInfo .= '<Address1>'.(empty($sourceAry['shipFromAddressAry'][0]) ? "" : $sourceAry['shipFromAddressAry'][0]).'</Address1>';
    $sourceInfo .= '<Address2>'.(empty($sourceAry['shipFromAddressAry'][1]) ? "" : $sourceAry['shipFromAddressAry'][1]).'</Address2>';
    $sourceInfo .= '<Street>'.$emptyValue.'</Street>';
    $sourceInfo .= '<City>'.$sourceAry['shipFromCity'].'</City>';
    $sourceInfo .= '<State>'.$sourceAry['shipFromProvince'].'</State>';
    $sourceInfo .= '<Province>'.$sourceAry['shipFromProvince'].'</Province>';
    $sourceInfo .= '<Postal>'.$sourceAry['shipFromPostalCode'].'</Postal>';
    $sourceInfo .= '<Country>'.$sourceAry['shipFromCountryCode'].'</Country>';
    $sourceInfo .= '<Latitude>'.$emptyValue.'</Latitude>';
    $sourceInfo .= '<Longitude>'.$emptyValue.'</Longitude>';
    $sourceInfo .= '<ContactInfo>';
    $sourceInfo .= '<CountryCode>'.$sourceAry['shipFromCountryCode'].'</CountryCode>';
    $sourceInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
    $sourceInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
    $sourceInfo .= '</ContactInfo>';
    $sourceInfo .= '</Address>';
    if($status == 'N')
    {
    $sourceInfo .= '<EstimatedDateTime>';
    $sourceInfo .= '<From>';
    $sourceInfo .= '<DateTime>'.$emptyValue.'</DateTime>';
    $sourceInfo .= '<TimeZone>'.$emptyValue.'</TimeZone>';
    $sourceInfo .= '<UTC>';
    $sourceInfo .= '<Time>'.$emptyValue.'</Time>';
    $sourceInfo .= '</UTC>';
    $sourceInfo .= '</From>';
    $sourceInfo .= '<To>';
    $sourceInfo .= '<DateTime>'.$emptyValue.'</DateTime>';
    $sourceInfo .= '<TimeZone>'.$emptyValue.'</TimeZone>';
    $sourceInfo .= '<UTC>';
    $sourceInfo .= '<Time>'.$emptyValue.'</Time>';
    $sourceInfo .= '</UTC>';
    $sourceInfo .= '</To>';
    $sourceInfo .= '</EstimatedDateTime>';
    $sourceInfo .= '<AdditionalContactInfo>'.$emptyValue.'</AdditionalContactInfo>';
    $sourceInfo .= '</Source>';
    }
    else
    {
    $sourceInfo .= '<AdditionalContactInfo>'.$emptyValue.'</AdditionalContactInfo>';
    $sourceInfo .= '</InvolvedParty>';
    }

    return $sourceInfo;
    }

    public function setShipToLocationInfo(array $destinationAry, string $status): string
    {
    $emptyValue = $destinationInfo = '';
    if($status == 'Y')
    {
    $destinationInfo .= '<InvolvedParty>';
    $destinationInfo .= '<PartyType>CONSIGNEE</PartyType>';
    }
    else
    {
    $destinationInfo .= '<Destination>';
    }
    $destinationInfo .= '<ID>'.$destinationAry['shipToLocationName'].'</ID>';
    $destinationInfo .= '<Company>';
    $destinationInfo .= '<Name>'.$destinationAry['shipToLocationName'].'</Name>';
    $destinationInfo .= '<RegistrationNumber>'.$destinationAry['shipToLocationName'].'</RegistrationNumber>';
    $destinationInfo .= '</Company>';
    $destinationInfo .= '<Address>';
    $destinationInfo .= '<Address1>'.(empty($destinationAry['shipToAddressAry'][0]) ? "" : $destinationAry['shipToAddressAry'][0]).'</Address1>';
    $destinationInfo .= '<Address2>'.(empty($destinationAry['shipToAddressAry'][1]) ? "" : $destinationAry['shipToAddressAry'][1]).'</Address2>';
    $destinationInfo .= '<Street>'.$emptyValue.'</Street>';
    $destinationInfo .= '<City>'.$destinationAry['shipToCity'].'</City>';
    $destinationInfo .= '<State>'.$destinationAry['shipToProvince'].'</State>';
    $destinationInfo .= '<Province>'.$destinationAry['shipToProvince'].'</Province>';
    $destinationInfo .= '<Postal>'.$destinationAry['shipToPostalCode'].'</Postal>';
    $destinationInfo .= '<Country>'.$destinationAry['shipToCountryCode'].'</Country>';
    $destinationInfo .= '<Latitude>'.$emptyValue.'</Latitude>';
    $destinationInfo .= '<Longitude>'.$emptyValue.'</Longitude>';
    $destinationInfo .= '<ContactInfo>';
    $destinationInfo .= '<CountryCode>'.$destinationAry['shipToCountryCode'].'</CountryCode>';
    $destinationInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
    $destinationInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
    $destinationInfo .= '</ContactInfo>';
    $destinationInfo .= '</Address>';

    if($status == 'N')
    {
    $destinationInfo .= '<EstimatedDateTime>';
    $destinationInfo .= '<From>';
    $destinationInfo .= '<DateTime>'.$emptyValue.'</DateTime>';
    $destinationInfo .= '<TimeZone>'.$emptyValue.'</TimeZone>';
    $destinationInfo .= '<UTC>';
    $destinationInfo .= '<Time>'.$emptyValue.'</Time>';
    $destinationInfo .= '</UTC>';
    $destinationInfo .= '</From>';
    $destinationInfo .= '<To>';
    $destinationInfo .= '<DateTime>'.$emptyValue.'</DateTime>';
    $destinationInfo .= '<TimeZone>'.$emptyValue.'</TimeZone>';
    $destinationInfo .= '<UTC>';
    $destinationInfo .= '<Time>'.$emptyValue.'</Time>';
    $destinationInfo .= '</UTC>';
    $destinationInfo .= '</To>';
    $destinationInfo .= '</EstimatedDateTime>';
    $destinationInfo .= '<AdditionalContactInfo>'.$emptyValue.'</AdditionalContactInfo>';
    $destinationInfo .= '</Destination>';
    }
    else
    {
    $destinationInfo .= '</InvolvedParty>';
    }

    return $destinationInfo;
    }*/

    public function setTripInvolvedPartiesInfo(array $tripInvolvedPartiesAry, array $tripSourceAry, array $tripDestinationAry): string
    {
        $emptyValue = $tripInvolvedPartiesInfo = "";
        $shipper = $consignee = $pickup = $delivery = 0;

        foreach ($tripInvolvedPartiesAry as $tripInvolvedParties) {
            /*if(strtoupper($tripInvolvedParties['partyType'])=='SHIPPER')
            {
            $shipper++;
            }
            else if(strtoupper($tripInvolvedParties['partyType'])=='CONSIGNEE')
            {
            $consignee++;
            }
            else if(strtoupper($tripInvolvedParties['partyType'])=='PICKUP')
            {
            $pickup++;
            }
            else if(strtoupper($tripInvolvedParties['partyType'])=='DELIVERY')
            {
            $delivery++;
            }*/

            if (strtoupper($tripInvolvedParties['partyType']) == 'PICKUP') {
                $pickup++;
            }

            if (strtoupper($tripInvolvedParties['partyType']) == 'DELIVERY') {
                $delivery++;
            }

            if (strtoupper($tripInvolvedParties['partyType']) != 'CARRIER') {
                $tripInvolvedPartiesInfo .= '<BusinessParty>';
                $tripInvolvedPartiesInfo .= '<PartyType>' . strtoupper($tripInvolvedParties['partyType']) . '</PartyType>';
                $tripInvolvedPartiesInfo .= '<ID>' . $tripInvolvedParties['id'] . '</ID>';
                $tripInvolvedPartiesInfo .= '<Company>';
                $tripInvolvedPartiesInfo .= '<Name>' . $tripInvolvedParties['id'] . '</Name>';
                $tripInvolvedPartiesInfo .= '<RegistrationNumber>' . $tripInvolvedParties['id'] . '</RegistrationNumber>';
                $tripInvolvedPartiesInfo .= '</Company>';
                $tripInvolvedPartiesInfo .= '<Address>';
                $tripInvolvedPartiesInfo .= '<Address1>' . $emptyValue . '</Address1>';
                $tripInvolvedPartiesInfo .= '<Address2>' . $emptyValue . '</Address2>';
                $tripInvolvedPartiesInfo .= '<Street>' . $emptyValue . '</Street>';
                $tripInvolvedPartiesInfo .= '<City>' . $emptyValue . '</City>';
                $tripInvolvedPartiesInfo .= '<Province>' . $emptyValue . '</Province>';
                $tripInvolvedPartiesInfo .= '<State>' . $emptyValue . '</State>';
                $tripInvolvedPartiesInfo .= '<Postal>' . $emptyValue . '</Postal>';
                $tripInvolvedPartiesInfo .= '<Country>' . $emptyValue . '</Country>';
                $tripInvolvedPartiesInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
                $tripInvolvedPartiesInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
                $tripInvolvedPartiesInfo .= '<ContactInfo>';
                $tripInvolvedPartiesInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
                $tripInvolvedPartiesInfo .= '<ContactNo>' . $tripInvolvedParties['phone'] . '</ContactNo>';
                $tripInvolvedPartiesInfo .= '<EmailAddress>' . $tripInvolvedParties['email'] . '</EmailAddress>';
                $tripInvolvedPartiesInfo .= '</ContactInfo>';
                $tripInvolvedPartiesInfo .= '</Address>';
                $tripInvolvedPartiesInfo .= '</BusinessParty>';
            }
        }

        if ($pickup == 0) {
            $tripInvolvedPartiesInfo .= '<BusinessParty>';
            $tripInvolvedPartiesInfo .= '<PartyType>PICKUP</PartyType>';
            $tripInvolvedPartiesInfo .= '<ID>' . $tripSourceAry['tripSourceLocationName'] . '</ID>';
            $tripInvolvedPartiesInfo .= '<Company>';
            $tripInvolvedPartiesInfo .= '<Name>' . $tripSourceAry['tripSourceLocationName'] . '</Name>';
            $tripInvolvedPartiesInfo .= '<RegistrationNumber>' . $tripSourceAry['tripSourceLocationName'] . '</RegistrationNumber>';
            $tripInvolvedPartiesInfo .= '</Company>';
            $tripInvolvedPartiesInfo .= '<Address>';
            $tripInvolvedPartiesInfo .= '<Address1>' . (empty($tripSourceAry['tripSourceAddressAry'][0]) ? "" : $tripSourceAry['tripSourceAddressAry'][0]) . '</Address1>';
            $tripInvolvedPartiesInfo .= '<Address2>' . (empty($tripSourceAry['tripSourceAddressAry'][1]) ? "" : $tripSourceAry['tripSourceAddressAry'][1]) . '</Address2>';
            $tripInvolvedPartiesInfo .= '<Street>' . $emptyValue . '</Street>';
            $tripInvolvedPartiesInfo .= '<City>' . $tripSourceAry['tripSourceCity'] . '</City>';
            $tripInvolvedPartiesInfo .= '<Province>' . $tripSourceAry['tripSourceProvince'] . '</Province>';
            $tripInvolvedPartiesInfo .= '<State>' . $tripSourceAry['tripSourceProvinceCode'] . '</State>';
            $tripInvolvedPartiesInfo .= '<Postal>' . $tripSourceAry['tripSourcePostalCode'] . '</Postal>';
            $tripInvolvedPartiesInfo .= '<Country>' . $tripSourceAry['tripSourceCountryCode'] . '</Country>';
            $tripInvolvedPartiesInfo .= '<Latitude>' . $tripSourceAry['tripSourceLatitude'] . '</Latitude>';
            $tripInvolvedPartiesInfo .= '<Longitude>' . $tripSourceAry['tripSourceLongitude'] . '</Longitude>';
            $tripInvolvedPartiesInfo .= '<ContactInfo>';
            $tripInvolvedPartiesInfo .= '<CountryCode>' . $tripSourceAry['tripSourceCountryCode'] . '</CountryCode>';
            $tripInvolvedPartiesInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
            $tripInvolvedPartiesInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
            $tripInvolvedPartiesInfo .= '</ContactInfo>';
            $tripInvolvedPartiesInfo .= '</Address>';
            $tripInvolvedPartiesInfo .= '</BusinessParty>';
        }
        if ($delivery == 0) {
            $tripInvolvedPartiesInfo .= '<BusinessParty>';
            $tripInvolvedPartiesInfo .= '<PartyType>DELIVERY</PartyType>';
            $tripInvolvedPartiesInfo .= '<ID>' . $tripDestinationAry['tripDestinationLocationName'] . '</ID>';
            $tripInvolvedPartiesInfo .= '<Company>';
            $tripInvolvedPartiesInfo .= '<Name>' . $tripDestinationAry['tripDestinationLocationName'] . '</Name>';
            $tripInvolvedPartiesInfo .= '<RegistrationNumber>' . $tripDestinationAry['tripDestinationLocationName'] . '</RegistrationNumber>';
            $tripInvolvedPartiesInfo .= '</Company>';
            $tripInvolvedPartiesInfo .= '<Address>';
            $tripInvolvedPartiesInfo .= '<Address1>' . (empty($tripDestinationAry['tripDestinationAddressAry'][0]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][0]) . '</Address1>';
            $tripInvolvedPartiesInfo .= '<Address2>' . (empty($tripDestinationAry['tripDestinationAddressAry'][1]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][1]) . '</Address2>';
            $tripInvolvedPartiesInfo .= '<Street>' . $emptyValue . '</Street>';
            $tripInvolvedPartiesInfo .= '<City>' . $tripDestinationAry['tripDestinationCity'] . '</City>';
            $tripInvolvedPartiesInfo .= '<Province>' . $tripDestinationAry['tripDestinationProvince'] . '</Province>';
            $tripInvolvedPartiesInfo .= '<State>' . $tripDestinationAry['tripDestinationProvinceCode'] . '</State>';
            $tripInvolvedPartiesInfo .= '<Postal>' . $tripDestinationAry['tripDestinationPostalCode'] . '</Postal>';
            $tripInvolvedPartiesInfo .= '<Country>' . $tripDestinationAry['tripDestinationCountryCode'] . '</Country>';
            $tripInvolvedPartiesInfo .= '<Latitude>' . $tripDestinationAry['tripDestinationLatitude'] . '</Latitude>';
            $tripInvolvedPartiesInfo .= '<Longitude>' . $tripDestinationAry['tripDestinationLongitude'] . '</Longitude>';
            $tripInvolvedPartiesInfo .= '<ContactInfo>';
            $tripInvolvedPartiesInfo .= '<CountryCode>' . $tripDestinationAry['tripDestinationCountryCode'] . '</CountryCode>';
            $tripInvolvedPartiesInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
            $tripInvolvedPartiesInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
            $tripInvolvedPartiesInfo .= '</ContactInfo>';
            $tripInvolvedPartiesInfo .= '</Address>';
            $tripInvolvedPartiesInfo .= '</BusinessParty>';
        }

        /*if($shipper==0)
        {
        $tripInvolvedPartiesInfo .= '<BusinessParty>';
        $tripInvolvedPartiesInfo .= '<PartyType>SHIPPER</PartyType>';
        $tripInvolvedPartiesInfo .= '<ID>'.$tripSourceAry['tripSourceLocationName'].'</ID>';
        $tripInvolvedPartiesInfo .= '<Company>';
        $tripInvolvedPartiesInfo .= '<Name>'.$tripSourceAry['tripSourceLocationName'].'</Name>';
        $tripInvolvedPartiesInfo .= '<RegistrationNumber>'.$tripSourceAry['tripSourceLocationName'].'</RegistrationNumber>';
        $tripInvolvedPartiesInfo .= '</Company>';
        $tripInvolvedPartiesInfo .= '<Address>';
        $tripInvolvedPartiesInfo .= '<Address1>'.(empty($tripSourceAry['tripSourceAddressAry'][0]) ? "" : $tripSourceAry['tripSourceAddressAry'][0]).'</Address1>';
        $tripInvolvedPartiesInfo .= '<Address2>'.(empty($tripSourceAry['tripSourceAddressAry'][1]) ? "" : $tripSourceAry['tripSourceAddressAry'][1]).'</Address2>';
        $tripInvolvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $tripInvolvedPartiesInfo .= '<City>'.$tripSourceAry['tripSourceCity'].'</City>';
        $tripInvolvedPartiesInfo .= '<Province>'.$tripSourceAry['tripSourceProvince'].'</Province>';
        $tripInvolvedPartiesInfo .= '<State>'.$tripSourceAry['tripSourceProvinceCode'].'</State>';
        $tripInvolvedPartiesInfo .= '<Postal>'.$tripSourceAry['tripSourcePostalCode'].'</Postal>';
        $tripInvolvedPartiesInfo .= '<Country>'.$tripSourceAry['tripSourceCountryCode'].'</Country>';
        $tripInvolvedPartiesInfo .= '<Latitude>'.$tripSourceAry['tripSourceLatitude'].'</Latitude>';
        $tripInvolvedPartiesInfo .= '<Longitude>'.$tripSourceAry['tripSourceLongitude'].'</Longitude>';
        $tripInvolvedPartiesInfo .= '<ContactInfo>';
        $tripInvolvedPartiesInfo .= '<CountryCode>'.$tripSourceAry['tripSourceCountryCode'].'</CountryCode>';
        $tripInvolvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $tripInvolvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $tripInvolvedPartiesInfo .= '</ContactInfo>';
        $tripInvolvedPartiesInfo .= '</Address>';
        $tripInvolvedPartiesInfo .= '</BusinessParty>';
        }
        if($consignee==0)
        {
        $tripInvolvedPartiesInfo .= '<BusinessParty>';
        $tripInvolvedPartiesInfo .= '<PartyType>CONSIGNEE</PartyType>';
        $tripInvolvedPartiesInfo .= '<ID>'.$tripDestinationAry['tripDestinationLocationName'].'</ID>';
        $tripInvolvedPartiesInfo .= '<Company>';
        $tripInvolvedPartiesInfo .= '<Name>'.$tripDestinationAry['tripDestinationLocationName'].'</Name>';
        $tripInvolvedPartiesInfo .= '<RegistrationNumber>'.$tripDestinationAry['tripDestinationLocationName'].'</RegistrationNumber>';
        $tripInvolvedPartiesInfo .= '</Company>';
        $tripInvolvedPartiesInfo .= '<Address>';
        $tripInvolvedPartiesInfo .= '<Address1>'.(empty($tripDestinationAry['tripDestinationAddressAry'][0]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][0]).'</Address1>';
        $tripInvolvedPartiesInfo .= '<Address2>'.(empty($tripDestinationAry['tripDestinationAddressAry'][1]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][1]).'</Address2>';
        $tripInvolvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $tripInvolvedPartiesInfo .= '<City>'.$tripDestinationAry['tripDestinationCity'].'</City>';
        $tripInvolvedPartiesInfo .= '<Province>'.$tripDestinationAry['tripDestinationProvince'].'</Province>';
        $tripInvolvedPartiesInfo .= '<State>'.$tripDestinationAry['tripDestinationProvinceCode'].'</State>';
        $tripInvolvedPartiesInfo .= '<Postal>'.$tripDestinationAry['tripDestinationPostalCode'].'</Postal>';
        $tripInvolvedPartiesInfo .= '<Country>'.$tripDestinationAry['tripDestinationCountryCode'].'</Country>';
        $tripInvolvedPartiesInfo .= '<Latitude>'.$tripDestinationAry['tripDestinationLatitude'].'</Latitude>';
        $tripInvolvedPartiesInfo .= '<Longitude>'.$tripDestinationAry['tripDestinationLongitude'].'</Longitude>';
        $tripInvolvedPartiesInfo .= '<ContactInfo>';
        $tripInvolvedPartiesInfo .= '<CountryCode>'.$tripDestinationAry['tripDestinationCountryCode'].'</CountryCode>';
        $tripInvolvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $tripInvolvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $tripInvolvedPartiesInfo .= '</ContactInfo>';
        $tripInvolvedPartiesInfo .= '</Address>';
        $tripInvolvedPartiesInfo .= '</BusinessParty>';
        }
        if($pickup==0)
        {
        $tripInvolvedPartiesInfo .= '<BusinessParty>';
        $tripInvolvedPartiesInfo .= '<PartyType>PICKUP</PartyType>';
        $tripInvolvedPartiesInfo .= '<ID>'.$tripSourceAry['tripSourceLocationName'].'</ID>';
        $tripInvolvedPartiesInfo .= '<Company>';
        $tripInvolvedPartiesInfo .= '<Name>'.$tripSourceAry['tripSourceLocationName'].'</Name>';
        $tripInvolvedPartiesInfo .= '<RegistrationNumber>'.$tripSourceAry['tripSourceLocationName'].'</RegistrationNumber>';
        $tripInvolvedPartiesInfo .= '</Company>';
        $tripInvolvedPartiesInfo .= '<Address>';
        $tripInvolvedPartiesInfo .= '<Address1>'.(empty($tripSourceAry['tripSourceAddressAry'][0]) ? "" : $tripSourceAry['tripSourceAddressAry'][0]).'</Address1>';
        $tripInvolvedPartiesInfo .= '<Address2>'.(empty($tripSourceAry['tripSourceAddressAry'][1]) ? "" : $tripSourceAry['tripSourceAddressAry'][1]).'</Address2>';
        $tripInvolvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $tripInvolvedPartiesInfo .= '<City>'.$tripSourceAry['tripSourceCity'].'</City>';
        $tripInvolvedPartiesInfo .= '<Province>'.$tripSourceAry['tripSourceProvince'].'</Province>';
        $tripInvolvedPartiesInfo .= '<State>'.$tripSourceAry['tripSourceProvinceCode'].'</State>';
        $tripInvolvedPartiesInfo .= '<Postal>'.$tripSourceAry['tripSourcePostalCode'].'</Postal>';
        $tripInvolvedPartiesInfo .= '<Country>'.$tripSourceAry['tripSourceCountryCode'].'</Country>';
        $tripInvolvedPartiesInfo .= '<Latitude>'.$tripSourceAry['tripSourceLatitude'].'</Latitude>';
        $tripInvolvedPartiesInfo .= '<Longitude>'.$tripSourceAry['tripSourceLongitude'].'</Longitude>';
        $tripInvolvedPartiesInfo .= '<ContactInfo>';
        $tripInvolvedPartiesInfo .= '<CountryCode>'.$tripSourceAry['tripSourceCountryCode'].'</CountryCode>';
        $tripInvolvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $tripInvolvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $tripInvolvedPartiesInfo .= '</ContactInfo>';
        $tripInvolvedPartiesInfo .= '</Address>';
        $tripInvolvedPartiesInfo .= '</BusinessParty>';
        }
        if($delivery==0)
        {
        $tripInvolvedPartiesInfo .= '<BusinessParty>';
        $tripInvolvedPartiesInfo .= '<PartyType>DELIVERY</PartyType>';
        $tripInvolvedPartiesInfo .= '<ID>'.$tripDestinationAry['tripDestinationLocationName'].'</ID>';
        $tripInvolvedPartiesInfo .= '<Company>';
        $tripInvolvedPartiesInfo .= '<Name>'.$tripDestinationAry['tripDestinationLocationName'].'</Name>';
        $tripInvolvedPartiesInfo .= '<RegistrationNumber>'.$tripDestinationAry['tripDestinationLocationName'].'</RegistrationNumber>';
        $tripInvolvedPartiesInfo .= '</Company>';
        $tripInvolvedPartiesInfo .= '<Address>';
        $tripInvolvedPartiesInfo .= '<Address1>'.(empty($tripDestinationAry['tripDestinationAddressAry'][0]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][0]).'</Address1>';
        $tripInvolvedPartiesInfo .= '<Address2>'.(empty($tripDestinationAry['tripDestinationAddressAry'][1]) ? "" : $tripDestinationAry['tripDestinationAddressAry'][1]).'</Address2>';
        $tripInvolvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $tripInvolvedPartiesInfo .= '<City>'.$tripDestinationAry['tripDestinationCity'].'</City>';
        $tripInvolvedPartiesInfo .= '<Province>'.$tripDestinationAry['tripDestinationProvince'].'</Province>';
        $tripInvolvedPartiesInfo .= '<State>'.$tripDestinationAry['tripDestinationProvinceCode'].'</State>';
        $tripInvolvedPartiesInfo .= '<Postal>'.$tripDestinationAry['tripDestinationPostalCode'].'</Postal>';
        $tripInvolvedPartiesInfo .= '<Country>'.$tripDestinationAry['tripDestinationCountryCode'].'</Country>';
        $tripInvolvedPartiesInfo .= '<Latitude>'.$tripDestinationAry['tripDestinationLatitude'].'</Latitude>';
        $tripInvolvedPartiesInfo .= '<Longitude>'.$tripDestinationAry['tripDestinationLongitude'].'</Longitude>';
        $tripInvolvedPartiesInfo .= '<ContactInfo>';
        $tripInvolvedPartiesInfo .= '<CountryCode>'.$tripDestinationAry['tripDestinationCountryCode'].'</CountryCode>';
        $tripInvolvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $tripInvolvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $tripInvolvedPartiesInfo .= '</ContactInfo>';
        $tripInvolvedPartiesInfo .= '</Address>';
        $tripInvolvedPartiesInfo .= '</BusinessParty>';
        }*/
        return $tripInvolvedPartiesInfo;
    }

    public function setCustomerInfo(array $involvedPartiesAry): string
    {
        $customerInfo = $emptyValue = "";
        foreach ($involvedPartiesAry as $involvedParties) {
            if (strtoupper($involvedParties['partyType']) == 'CUSTOMER') {
                $customerInfo = '';
                $customerInfo .= '<CustomerDetails>';
                $customerInfo .= '<ID>' . $involvedParties['id'] . '</ID>';
                $customerInfo .= '<Company>';
                $customerInfo .= '<Name>' . $involvedParties['id'] . '</Name>';
                $customerInfo .= '<RegistrationNumber>' . $involvedParties['id'] . '</RegistrationNumber>';
                $customerInfo .= '</Company>';
                $customerInfo .= '<Address>';
                $customerInfo .= '<Address1>' . $emptyValue . '</Address1>';
                $customerInfo .= '<Address2>' . $emptyValue . '</Address2>';
                $customerInfo .= '<Street>' . $emptyValue . '</Street>';
                $customerInfo .= '<City>' . $emptyValue . '</City>';
                $customerInfo .= '<Province>' . $emptyValue . '</Province>';
                $customerInfo .= '<State>' . $emptyValue . '</State>';
                $customerInfo .= '<Postal>' . $emptyValue . '</Postal>';
                $customerInfo .= '<Country>' . $emptyValue . '</Country>';
                $customerInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
                $customerInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
                $customerInfo .= '<ContactInfo>';
                $customerInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
                $customerInfo .= '<ContactNo>' . $involvedParties['phone'] . '</ContactNo>';
                $customerInfo .= '<EmailAddress>' . $involvedParties['email'] . '</EmailAddress>';
                $customerInfo .= '</ContactInfo>';
                $customerInfo .= '</Address>';
                $customerInfo .= '</CustomerDetails>';
            }
        }
        if ($customerInfo == "") {
            $customerInfo = '';
            $customerInfo .= '<CustomerDetails>';
            $customerInfo .= '<ID>' . "ALL" . '</ID>';
            $customerInfo .= '<Company>';
            $customerInfo .= '<Name>' . "ALL" . '</Name>';
            $customerInfo .= '<RegistrationNumber>' . "ALL" . '</RegistrationNumber>';
            $customerInfo .= '</Company>';
            $customerInfo .= '<Address>';
            $customerInfo .= '<Address1>' . $emptyValue . '</Address1>';
            $customerInfo .= '<Address2>' . $emptyValue . '</Address2>';
            $customerInfo .= '<Street>' . $emptyValue . '</Street>';
            $customerInfo .= '<City>' . $emptyValue . '</City>';
            $customerInfo .= '<Province>' . $emptyValue . '</Province>';
            $customerInfo .= '<State>' . $emptyValue . '</State>';
            $customerInfo .= '<Postal>' . $emptyValue . '</Postal>';
            $customerInfo .= '<Country>' . $emptyValue . '</Country>';
            $customerInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
            $customerInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
            $customerInfo .= '<ContactInfo>';
            $customerInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
            $customerInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
            $customerInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
            $customerInfo .= '</ContactInfo>';
            $customerInfo .= '</Address>';
            $customerInfo .= '</CustomerDetails>';
        }
        return $customerInfo;
    }

    public function setShipFromLocationInfo(array $sourceAry, array $timeWindowAry): string
    {
        $emptyValue = $sourceInfo = $earlyPickupDate = $earlyPickupTimeZone = $latePickupDate = $latePickupTimeZone = "";

        $sourceInfo .= '<Source>';
        $sourceInfo .= '<ID>' . $sourceAry['shipFromLocationId'] . '</ID>';
        $sourceInfo .= '<Company>';
        $sourceInfo .= '<Name>' . $sourceAry['shipFromLocationName'] . '</Name>';
        $sourceInfo .= '<RegistrationNumber>' . $sourceAry['shipFromLocationName'] . '</RegistrationNumber>';
        $sourceInfo .= '</Company>';
        $sourceInfo .= '<Address>';
        $sourceInfo .= '<Address1>' . (empty($sourceAry['shipFromAddressAry'][0]) ? "" : $sourceAry['shipFromAddressAry'][0]) . '</Address1>';
        $sourceInfo .= '<Address2>' . (empty($sourceAry['shipFromAddressAry'][1]) ? "" : $sourceAry['shipFromAddressAry'][1]) . '</Address2>';
        $sourceInfo .= '<Street>' . $emptyValue . '</Street>';
        $sourceInfo .= '<City>' . $sourceAry['shipFromCity'] . '</City>';
        $sourceInfo .= '<Province>' . $sourceAry['shipFromProvince'] . '</Province>';
        $sourceInfo .= '<State>' . $sourceAry['shipFromProvinceCode'] . '</State>';
        $sourceInfo .= '<Postal>' . $sourceAry['shipFromPostalCode'] . '</Postal>';
        $sourceInfo .= '<Country>' . $sourceAry['shipFromCountryCode'] . '</Country>';
        $sourceInfo .= '<Latitude>' . $sourceAry['shipFromLatitude'] . '</Latitude>';
        $sourceInfo .= '<Longitude>' . $sourceAry['shipFromLongitude'] . '</Longitude>';
        $sourceInfo .= '<ContactInfo>';
        $sourceInfo .= '<CountryCode>' . $sourceAry['shipFromCountryCode'] . '</CountryCode>';
        $sourceInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
        $sourceInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
        $sourceInfo .= '</ContactInfo>';
        $sourceInfo .= '</Address>';

        $earlyPickupDate = $timeWindowAry['earlyPickupDate'];
        $earlyPickupTimeZone = $timeWindowAry['earlyPickupTimeZone'];
        $latePickupDate = $timeWindowAry['latePickupDate'];
        $latePickupTimeZone = $timeWindowAry['latePickupTimeZone'];

        $sourceInfo .= '<EstimatedDateTime>';
        $sourceInfo .= '<From>';
        $sourceInfo .= '<DateTime>' . $earlyPickupDate . '</DateTime>';
        $sourceInfo .= '<TimeZone>' . $earlyPickupTimeZone . '</TimeZone>';
        $sourceInfo .= '<UTC>';
        $sourceInfo .= '<Time>' . $earlyPickupDate . '</Time>';
        $sourceInfo .= '</UTC>';
        $sourceInfo .= '</From>';
        $sourceInfo .= '<To>';
        $sourceInfo .= '<DateTime>' . $latePickupDate . '</DateTime>';
        $sourceInfo .= '<TimeZone>' . $latePickupTimeZone . '</TimeZone>';
        $sourceInfo .= '<UTC>';
        $sourceInfo .= '<Time>' . $latePickupDate . '</Time>';
        $sourceInfo .= '</UTC>';
        $sourceInfo .= '</To>';
        $sourceInfo .= '</EstimatedDateTime>';
        $sourceInfo .= '</Source>';

        return $sourceInfo;
    }

    public function setShipToLocationInfo(array $destinationAry, array $timeWindowAry): string
    {
        $emptyValue = $destinationInfo = $earlyDeliveryDate = $earlyDeliveryTimeZone = $lateDeliveryDate = $lateDeliveryTimeZone = '';
        $destinationInfo .= '<Destination>';
        $destinationInfo .= '<ID>' . $destinationAry['shipToLocationId'] . '</ID>';
        $destinationInfo .= '<Company>';
        $destinationInfo .= '<Name>' . $destinationAry['shipToLocationName'] . '</Name>';
        $destinationInfo .= '<RegistrationNumber>' . $destinationAry['shipToLocationName'] . '</RegistrationNumber>';
        $destinationInfo .= '</Company>';
        $destinationInfo .= '<Address>';
        $destinationInfo .= '<Address1>' . (empty($destinationAry['shipToAddressAry'][0]) ? "" : $destinationAry['shipToAddressAry'][0]) . '</Address1>';
        $destinationInfo .= '<Address2>' . (empty($destinationAry['shipToAddressAry'][1]) ? "" : $destinationAry['shipToAddressAry'][1]) . '</Address2>';
        $destinationInfo .= '<Street>' . $emptyValue . '</Street>';
        $destinationInfo .= '<City>' . $destinationAry['shipToCity'] . '</City>';
        $destinationInfo .= '<Province>' . $destinationAry['shipToProvince'] . '</Province>';
        $destinationInfo .= '<State>' . $destinationAry['shipToProvinceCode'] . '</State>';
        $destinationInfo .= '<Postal>' . $destinationAry['shipToPostalCode'] . '</Postal>';
        $destinationInfo .= '<Country>' . $destinationAry['shipToCountryCode'] . '</Country>';
        $destinationInfo .= '<Latitude>' . $destinationAry['shipToLatitude'] . '</Latitude>';
        $destinationInfo .= '<Longitude>' . $destinationAry['shipToLongitude'] . '</Longitude>';
        $destinationInfo .= '<ContactInfo>';
        $destinationInfo .= '<CountryCode>' . $destinationAry['shipToCountryCode'] . '</CountryCode>';
        $destinationInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
        $destinationInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
        $destinationInfo .= '</ContactInfo>';
        $destinationInfo .= '</Address>';

        $earlyDeliveryDate = $timeWindowAry['earlyDeliveryDate'];
        $earlyDeliveryTimeZone = $timeWindowAry['earlyDeliveryTimeZone'];
        $lateDeliveryDate = $timeWindowAry['lateDeliveryDate'];
        $lateDeliveryTimeZone = $timeWindowAry['lateDeliveryTimeZone'];

        $destinationInfo .= '<EstimatedDateTime>';
        $destinationInfo .= '<From>';
        $destinationInfo .= '<DateTime>' . $earlyDeliveryDate . '</DateTime>';
        $destinationInfo .= '<TimeZone>' . $earlyDeliveryTimeZone . '</TimeZone>';
        $destinationInfo .= '<UTC>';
        $destinationInfo .= '<Time>' . $earlyDeliveryDate . '</Time>';
        $destinationInfo .= '</UTC>';
        $destinationInfo .= '</From>';
        $destinationInfo .= '<To>';
        $destinationInfo .= '<DateTime>' . $lateDeliveryDate . '</DateTime>';
        $destinationInfo .= '<TimeZone>' . $lateDeliveryTimeZone . '</TimeZone>';
        $destinationInfo .= '<UTC>';
        $destinationInfo .= '<Time>' . $lateDeliveryDate . '</Time>';
        $destinationInfo .= '</UTC>';
        $destinationInfo .= '</To>';
        $destinationInfo .= '</EstimatedDateTime>';
        $destinationInfo .= '</Destination>';

        return $destinationInfo;
    }

    public function setInvolvedPartiesInfo(array $involvedPartiesAry, array $sourceAry, array $destinationAry): string
    {
        $emptyValue = $involvedPartiesInfo = "";
        $shipper = $consignee = $pickup = $delivery = $customer = 0;
        foreach ($involvedPartiesAry as $involvedParties) {
            if (strtoupper($involvedParties['partyType']) == 'CUSTOMER') {
                $customer++;
            }
            if(strtoupper($involvedParties['partyType'])=='SHIPPER')
            {
            $shipper++;
            }
            else if(strtoupper($involvedParties['partyType'])=='CONSIGNEE')
            {
            $consignee++;
            }
            else if(strtoupper($involvedParties['partyType'])=='CARRIER')
            {
            $carrier++;
            }
            /*else if(strtoupper($involvedParties['partyType'])=='PICKUP')
            {
            $pickup++;
            }
            else if(strtoupper($involvedParties['partyType'])=='DELIVERY')
            {
            $delivery++;
            }*/
            $involvedPartiesInfo .= '<InvolvedParty>';
            $involvedPartiesInfo .= '<PartyType>' . strtoupper($involvedParties['partyType']) . '</PartyType>';
            $involvedPartiesInfo .= '<ID>' . $involvedParties['id'] . '</ID>';
            $involvedPartiesInfo .= '<Company>';
            $involvedPartiesInfo .= '<Name>' . $involvedParties['id'] . '</Name>';
            $involvedPartiesInfo .= '<RegistrationNumber>' . $involvedParties['id'] . '</RegistrationNumber>';
            $involvedPartiesInfo .= '</Company>';
            $involvedPartiesInfo .= '<Address>';
            $involvedPartiesInfo .= '<Address1>' . $emptyValue . '</Address1>';
            $involvedPartiesInfo .= '<Address2>' . $emptyValue . '</Address2>';
            $involvedPartiesInfo .= '<Street>' . $emptyValue . '</Street>';
            $involvedPartiesInfo .= '<City>' . $emptyValue . '</City>';
            $involvedPartiesInfo .= '<Province>' . $emptyValue . '</Province>';
            $involvedPartiesInfo .= '<State>' . $emptyValue . '</State>';
            $involvedPartiesInfo .= '<Postal>' . $emptyValue . '</Postal>';
            $involvedPartiesInfo .= '<Country>' . $emptyValue . '</Country>';
            $involvedPartiesInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
            $involvedPartiesInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
            $involvedPartiesInfo .= '<ContactInfo>';
            $involvedPartiesInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
            $involvedPartiesInfo .= '<ContactNo>' . $involvedParties['phone'] . '</ContactNo>';
            $involvedPartiesInfo .= '<EmailAddress>' . $involvedParties['email'] . '</EmailAddress>';
            $involvedPartiesInfo .= '</ContactInfo>';
            $involvedPartiesInfo .= '</Address>';
            $involvedPartiesInfo .= '</InvolvedParty>';
        }
        if ($customer == 0) {
            $involvedPartiesInfo .= '<InvolvedParty>';
            $involvedPartiesInfo .= '<PartyType>CUSTOMER</PartyType>';
            $involvedPartiesInfo .= '<ID>ALL</ID>';
            $involvedPartiesInfo .= '<Company>';
            $involvedPartiesInfo .= '<Name>ALL</Name>';
            $involvedPartiesInfo .= '<RegistrationNumber>ALL</RegistrationNumber>';
            $involvedPartiesInfo .= '</Company>';
            $involvedPartiesInfo .= '<Address>';
            $involvedPartiesInfo .= '<Address1>' . $emptyValue . '</Address1>';
            $involvedPartiesInfo .= '<Address2>' . $emptyValue . '</Address2>';
            $involvedPartiesInfo .= '<Street>' . $emptyValue . '</Street>';
            $involvedPartiesInfo .= '<City>' . $emptyValue . '</City>';
            $involvedPartiesInfo .= '<Province>' . $emptyValue . '</Province>';
            $involvedPartiesInfo .= '<State>' . $emptyValue . '</State>';
            $involvedPartiesInfo .= '<Postal>' . $emptyValue . '</Postal>';
            $involvedPartiesInfo .= '<Country>' . $emptyValue . '</Country>';
            $involvedPartiesInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
            $involvedPartiesInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
            $involvedPartiesInfo .= '<ContactInfo>';
            $involvedPartiesInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
            $involvedPartiesInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
            $involvedPartiesInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
            $involvedPartiesInfo .= '</ContactInfo>';
            $involvedPartiesInfo .= '</Address>';
            $involvedPartiesInfo .= '</InvolvedParty>';
        }
        if($shipper==0)
        {
        $involvedPartiesInfo .= '<InvolvedParty>';
        $involvedPartiesInfo .= '<PartyType>SHIPPER</PartyType>';
        $involvedPartiesInfo .= '<ID>'.$sourceAry['shipFromLocationId'].'</ID>';
        $involvedPartiesInfo .= '<Company>';
        $involvedPartiesInfo .= '<Name>'.$sourceAry['shipFromLocationName'].'</Name>';
        $involvedPartiesInfo .= '<RegistrationNumber>'.$sourceAry['shipFromLocationName'].'</RegistrationNumber>';
        $involvedPartiesInfo .= '</Company>';
        $involvedPartiesInfo .= '<Address>';
        $involvedPartiesInfo .= '<Address1>'.(empty($sourceAry['shipFromAddressAry'][0]) ? "" : $sourceAry['shipFromAddressAry'][0]).'</Address1>';
        $involvedPartiesInfo .= '<Address2>'.(empty($sourceAry['shipFromAddressAry'][1]) ? "" : $sourceAry['shipFromAddressAry'][1]).'</Address2>';
        $involvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $involvedPartiesInfo .= '<City>'.$sourceAry['shipFromCity'].'</City>';
        $involvedPartiesInfo .= '<Province>'.$sourceAry['shipFromProvince'].'</Province>';
        $involvedPartiesInfo .= '<State>'.$sourceAry['shipFromProvinceCode'].'</State>';
        $involvedPartiesInfo .= '<Postal>'.$sourceAry['shipFromPostalCode'].'</Postal>';
        $involvedPartiesInfo .= '<Country>'.$sourceAry['shipFromCountryCode'].'</Country>';
        $involvedPartiesInfo .= '<Latitude>'.$sourceAry['shipFromLatitude'].'</Latitude>';
        $involvedPartiesInfo .= '<Longitude>'.$sourceAry['shipFromLongitude'].'</Longitude>';
        $involvedPartiesInfo .= '<ContactInfo>';
        $involvedPartiesInfo .= '<CountryCode>'.$sourceAry['shipFromCountryCode'].'</CountryCode>';
        $involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $involvedPartiesInfo .= '</ContactInfo>';
        $involvedPartiesInfo .= '</Address>';
        $involvedPartiesInfo .= '</InvolvedParty>';
        }
        if($consignee==0)
        {
        $involvedPartiesInfo .= '<InvolvedParty>';
        $involvedPartiesInfo .= '<PartyType>CONSIGNEE</PartyType>';
        $involvedPartiesInfo .= '<ID>'.$destinationAry['shipToLocationId'].'</ID>';
        $involvedPartiesInfo .= '<Company>';
        $involvedPartiesInfo .= '<Name>'.$destinationAry['shipToLocationName'].'</Name>';
        $involvedPartiesInfo .= '<RegistrationNumber>'.$destinationAry['shipToLocationName'].'</RegistrationNumber>';
        $involvedPartiesInfo .= '</Company>';
        $involvedPartiesInfo .= '<Address>';
        $involvedPartiesInfo .= '<Address1>'.(empty($destinationAry['shipToAddressAry'][0]) ? "" : $destinationAry['shipToAddressAry'][0]).'</Address1>';
        $involvedPartiesInfo .= '<Address2>'.(empty($destinationAry['shipToAddressAry'][1]) ? "" : $destinationAry['shipToAddressAry'][1]).'</Address2>';
        $involvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $involvedPartiesInfo .= '<City>'.$destinationAry['shipToCity'].'</City>';
        $involvedPartiesInfo .= '<Province>'.$destinationAry['shipToProvince'].'</Province>';
        $involvedPartiesInfo .= '<State>'.$destinationAry['shipToProvinceCode'].'</State>';
        $involvedPartiesInfo .= '<Postal>'.$destinationAry['shipToPostalCode'].'</Postal>';
        $involvedPartiesInfo .= '<Country>'.$destinationAry['shipToCountryCode'].'</Country>';
        $involvedPartiesInfo .= '<Latitude>'.$destinationAry['shipToLatitude'].'</Latitude>';
        $involvedPartiesInfo .= '<Longitude>'.$destinationAry['shipToLongitude'].'</Longitude>';
        $involvedPartiesInfo .= '<ContactInfo>';
        $involvedPartiesInfo .= '<CountryCode>'.$destinationAry['shipToCountryCode'].'</CountryCode>';
        $involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $involvedPartiesInfo .= '</ContactInfo>';
        $involvedPartiesInfo .= '</Address>';
        $involvedPartiesInfo .= '</InvolvedParty>';
        }
        if ($carrier == 0) {
            $involvedPartiesInfo .= '<InvolvedParty>';
            $involvedPartiesInfo .= '<PartyType>CARRIER</PartyType>';
            $involvedPartiesInfo .= '<ID>ALL</ID>';
            $involvedPartiesInfo .= '<Company>';
            $involvedPartiesInfo .= '<Name>ALL</Name>';
            $involvedPartiesInfo .= '<RegistrationNumber>ALL</RegistrationNumber>';
            $involvedPartiesInfo .= '</Company>';
            $involvedPartiesInfo .= '<Address>';
            $involvedPartiesInfo .= '<Address1>' . $emptyValue . '</Address1>';
            $involvedPartiesInfo .= '<Address2>' . $emptyValue . '</Address2>';
            $involvedPartiesInfo .= '<Street>' . $emptyValue . '</Street>';
            $involvedPartiesInfo .= '<City>' . $emptyValue . '</City>';
            $involvedPartiesInfo .= '<Province>' . $emptyValue . '</Province>';
            $involvedPartiesInfo .= '<State>' . $emptyValue . '</State>';
            $involvedPartiesInfo .= '<Postal>' . $emptyValue . '</Postal>';
            $involvedPartiesInfo .= '<Country>' . $emptyValue . '</Country>';
            $involvedPartiesInfo .= '<Latitude>' . $emptyValue . '</Latitude>';
            $involvedPartiesInfo .= '<Longitude>' . $emptyValue . '</Longitude>';
            $involvedPartiesInfo .= '<ContactInfo>';
            $involvedPartiesInfo .= '<CountryCode>' . $emptyValue . '</CountryCode>';
            $involvedPartiesInfo .= '<ContactNo>' . $emptyValue . '</ContactNo>';
            $involvedPartiesInfo .= '<EmailAddress>' . $emptyValue . '</EmailAddress>';
            $involvedPartiesInfo .= '</ContactInfo>';
            $involvedPartiesInfo .= '</Address>';
            $involvedPartiesInfo .= '</InvolvedParty>';
        }
        /*if($pickup==0)
        {
        $involvedPartiesInfo .= '<InvolvedParty>';
        $involvedPartiesInfo .= '<PartyType>PICKUP</PartyType>';
        $involvedPartiesInfo .= '<ID>'.$sourceAry['shipFromLocationName'].'</ID>';
        $involvedPartiesInfo .= '<Company>';
        $involvedPartiesInfo .= '<Name>'.$sourceAry['shipFromLocationName'].'</Name>';
        $involvedPartiesInfo .= '<RegistrationNumber>'.$sourceAry['shipFromLocationName'].'</RegistrationNumber>';
        $involvedPartiesInfo .= '</Company>';
        $involvedPartiesInfo .= '<Address>';
        $involvedPartiesInfo .= '<Address1>'.(empty($sourceAry['shipFromAddressAry'][0]) ? "" : $sourceAry['shipFromAddressAry'][0]).'</Address1>';
        $involvedPartiesInfo .= '<Address2>'.(empty($sourceAry['shipFromAddressAry'][1]) ? "" : $sourceAry['shipFromAddressAry'][1]).'</Address2>';
        $involvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $involvedPartiesInfo .= '<City>'.$sourceAry['shipFromCity'].'</City>';
        $involvedPartiesInfo .= '<Province>'.$sourceAry['shipFromProvince'].'</Province>';
        $involvedPartiesInfo .= '<State>'.$sourceAry['shipFromProvinceCode'].'</State>';
        $involvedPartiesInfo .= '<Postal>'.$sourceAry['shipFromPostalCode'].'</Postal>';
        $involvedPartiesInfo .= '<Country>'.$sourceAry['shipFromCountryCode'].'</Country>';
        $involvedPartiesInfo .= '<Latitude>'.$sourceAry['shipFromLatitude'].'</Latitude>';
        $involvedPartiesInfo .= '<Longitude>'.$sourceAry['shipFromLongitude'].'</Longitude>';
        $involvedPartiesInfo .= '<ContactInfo>';
        $involvedPartiesInfo .= '<CountryCode>'.$sourceAry['shipFromCountryCode'].'</CountryCode>';
        $involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $involvedPartiesInfo .= '</ContactInfo>';
        $involvedPartiesInfo .= '</Address>';
        $involvedPartiesInfo .= '</InvolvedParty>';
        }
        if($delivery==0)
        {
        $involvedPartiesInfo .= '<InvolvedParty>';
        $involvedPartiesInfo .= '<PartyType>DELIVERY</PartyType>';
        $involvedPartiesInfo .= '<ID>'.$destinationAry['shipToLocationName'].'</ID>';
        $involvedPartiesInfo .= '<Company>';
        $involvedPartiesInfo .= '<Name>'.$destinationAry['shipToLocationName'].'</Name>';
        $involvedPartiesInfo .= '<RegistrationNumber>'.$destinationAry['shipToLocationName'].'</RegistrationNumber>';
        $involvedPartiesInfo .= '</Company>';
        $involvedPartiesInfo .= '<Address>';
        $involvedPartiesInfo .= '<Address1>'.(empty($destinationAry['shipToAddressAry'][0]) ? "" : $destinationAry['shipToAddressAry'][0]).'</Address1>';
        $involvedPartiesInfo .= '<Address2>'.(empty($destinationAry['shipToAddressAry'][1]) ? "" : $destinationAry['shipToAddressAry'][1]).'</Address2>';
        $involvedPartiesInfo .= '<Street>'.$emptyValue.'</Street>';
        $involvedPartiesInfo .= '<City>'.$destinationAry['shipToCity'].'</City>';
        $involvedPartiesInfo .= '<Province>'.$destinationAry['shipToProvince'].'</Province>';
        $involvedPartiesInfo .= '<State>'.$destinationAry['shipToProvinceCode'].'</State>';
        $involvedPartiesInfo .= '<Postal>'.$destinationAry['shipToPostalCode'].'</Postal>';
        $involvedPartiesInfo .= '<Country>'.$destinationAry['shipToCountryCode'].'</Country>';
        $involvedPartiesInfo .= '<Latitude>'.$destinationAry['shipToLatitude'].'</Latitude>';
        $involvedPartiesInfo .= '<Longitude>'.$destinationAry['shipToLongitude'].'</Longitude>';
        $involvedPartiesInfo .= '<ContactInfo>';
        $involvedPartiesInfo .= '<CountryCode>'.$destinationAry['shipToCountryCode'].'</CountryCode>';
        $involvedPartiesInfo .= '<ContactNo>'.$emptyValue.'</ContactNo>';
        $involvedPartiesInfo .= '<EmailAddress>'.$emptyValue.'</EmailAddress>';
        $involvedPartiesInfo .= '</ContactInfo>';
        $involvedPartiesInfo .= '</Address>';
        $involvedPartiesInfo .= '</InvolvedParty>';
        }*/
        return $involvedPartiesInfo;
    }

    public function setShipUnitInfo(array $outerCargos): string
    {
        $emptyValue = $outerCargosInfo = "";
        foreach ($outerCargos as $outerCargo) {
            $outerCargosInfo .= '<TransportHandlingUnit>';
            $outerCargosInfo .= '<PackageType>' . $outerCargo['outerPackageType'] . '</PackageType>';
            $outerCargosInfo .= '<GoodsDescription>' . $outerCargo['outerPackageDesc'] . '</GoodsDescription>';
            $outerCargosInfo .= '<MarksandNumbers>N</MarksandNumbers>';
            $outerCargosInfo .= '<HandlingUnit/>';
            $outerCargosInfo .= '<ValueOfGoods>' . $emptyValue . '</ValueOfGoods>';
            $outerCargosInfo .= '<ItemId>' . $outerCargo['externalOuterCargoId'] . '</ItemId>';
            $outerCargosInfo .= '<Length>';
            $outerCargosInfo .= '<Value>' . $outerCargo['outerPackageLengthValue'] . '</Value>';
            $outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageLengthUOM'] . '</UOM>';
            $outerCargosInfo .= '</Length>';
            $outerCargosInfo .= '<Width>';
            $outerCargosInfo .= '<Value>' . $outerCargo['outerPackageWidthValue'] . '</Value>';
            $outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageWidthUOM'] . '</UOM>';
            $outerCargosInfo .= '</Width>';
            $outerCargosInfo .= '<Height>';
            $outerCargosInfo .= '<Value>' . $outerCargo['outerPackageHeightValue'] . '</Value>';
            $outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageHeightUOM'] . '</UOM>';
            $outerCargosInfo .= '</Height>';
            $outerCargosInfo .= '<ActualWeight>';
            $outerCargosInfo .= '<Value>' . $outerCargo['outerPackageWeightValue'] . '</Value>';
            $outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageWeightUOM'] . '</UOM>';
            $outerCargosInfo .= '</ActualWeight>';
            $outerCargosInfo .= '<Weight>';
            $outerCargosInfo .= '<Value>' . $outerCargo['outerPackageWeightValue'] . '</Value>';
            $outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageWeightUOM'] . '</UOM>';
            $outerCargosInfo .= '</Weight>';
            $outerCargosInfo .= '<VolumetricWeight>';
            $outerCargosInfo .= '<Value>0.000</Value>';
            $outerCargosInfo .= '<UOM/>';
            $outerCargosInfo .= '</VolumetricWeight>';
            $outerCargosInfo .= '<Volume>';
            $outerCargosInfo .= '<Value>' . $outerCargo['outerPackageVolumeValue'] . '</Value>';
            $outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageVolumeUOM'] . '</UOM>';
            $outerCargosInfo .= '</Volume>';
            $outerCargosInfo .= '<ActualVolume>';
            $outerCargosInfo .= '<Value>' . $outerCargo['outerPackageVolumeValue'] . '</Value>';
            $outerCargosInfo .= '<UOM>' . $outerCargo['outerPackageVolumeUOM'] . '</UOM>';
            $outerCargosInfo .= '</ActualVolume>';
            $outerCargosInfo .= '<Quantity>' . $outerCargo['outerPackageQuantity'] . '</Quantity>';
            $outerCargosInfo .= '<ScannedQuantity>' . $outerCargo['outerPackageQuantity'] . '</ScannedQuantity>';
            $outerCargosInfo .= '<ldm>0.000</ldm>';
            $outerCargosInfo .= '<GroundedFlag>0</GroundedFlag>';
            $outerCargosInfo .= '<StackableFlag>0</StackableFlag>';
            $outerCargosInfo .= '<SplittableFlag>0</SplittableFlag>';
            $outerCargosInfo .= '<DangerousGoodsFlag>0</DangerousGoodsFlag>';
            $outerCargosInfo .= '<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>';
            foreach ($outerCargo['innerCargos'] as $innerCargo) {
                $innerCargosInfo = '<PackagingUnit>';
                $innerCargosInfo .= '<PackageType>' . $innerCargo['innerPackageType'] . '</PackageType>';
                $innerCargosInfo .= '<GoodsDescription>' . $innerCargo['innerPackageDesc'] . '</GoodsDescription>';
                $innerCargosInfo .= '<MarksandNumbers>N</MarksandNumbers>';
                $innerCargosInfo .= '<HandlingUnit/>';
                $innerCargosInfo .= '<ValueOfGoods>' . $emptyValue . '</ValueOfGoods>';
                $innerCargosInfo .= '<Quantity>' . $innerCargo['innerPackageQuantity'] . '</Quantity>';
                $innerCargosInfo .= '<ScannedQuantity>' . $innerCargo['innerPackageQuantity'] . '</ScannedQuantity>';
                $innerCargosInfo .= '<ItemId>' . $innerCargo['externalInnerCargoId'] . '</ItemId>';
                $innerCargosInfo .= '<Length>';
                $innerCargosInfo .= '<Value>' . $innerCargo['innerPackageLengthValue'] . '</Value>';
                $innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageLengthUOM'] . '</UOM>';
                $innerCargosInfo .= '</Length>';
                $innerCargosInfo .= '<Width>';
                $innerCargosInfo .= '<Value>' . $innerCargo['innerPackageWidthValue'] . '</Value>';
                $innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageWidthUOM'] . '</UOM>';
                $innerCargosInfo .= '</Width>';
                $innerCargosInfo .= '<Height>';
                $innerCargosInfo .= '<Value>' . $innerCargo['innerPackageHeightValue'] . '</Value>';
                $innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageHeightUOM'] . '</UOM>';
                $innerCargosInfo .= '</Height>';
                $innerCargosInfo .= '<ActualWeight>';
                $innerCargosInfo .= '<Value>' . $innerCargo['innerPackageWeightValue'] . '</Value>';
                $innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageWeightUOM'] . '</UOM>';
                $innerCargosInfo .= '</ActualWeight>';
                $innerCargosInfo .= '<Weight>';
                $innerCargosInfo .= '<Value>' . $innerCargo['innerPackageWeightValue'] . '</Value>';
                $innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageWeightUOM'] . '</UOM>';
                $innerCargosInfo .= '</Weight>';
                $innerCargosInfo .= '<VolumetricWeight>';
                $innerCargosInfo .= '<Value>0.000</Value>';
                $innerCargosInfo .= '<UOM/>';
                $innerCargosInfo .= '</VolumetricWeight>';
                $innerCargosInfo .= '<Volume>';
                $innerCargosInfo .= '<Value>' . $innerCargo['innerPackageVolumeValue'] . '</Value>';
                $innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageVolumeUOM'] . '</UOM>';
                $innerCargosInfo .= '</Volume>';
                $innerCargosInfo .= '<ActualVolume>';
                $innerCargosInfo .= '<Value>' . $innerCargo['innerPackageVolumeValue'] . '</Value>';
                $innerCargosInfo .= '<UOM>' . $innerCargo['innerPackageVolumeUOM'] . '</UOM>';
                $innerCargosInfo .= '</ActualVolume>';
                $innerCargosInfo .= '<ldm>0.000</ldm>';
                $innerCargosInfo .= '<GroundedFlag>0</GroundedFlag>';
                $innerCargosInfo .= '<StackableFlag>0</StackableFlag>';
                $innerCargosInfo .= '<SplittableFlag>0</SplittableFlag>';
                $innerCargosInfo .= '<DangerousGoodsFlag>0</DangerousGoodsFlag>';
                $innerCargosInfo .= '</PackagingUnit>';
                $outerCargosInfo .= $innerCargosInfo;
            }
            $outerCargosInfo .= '</TransportHandlingUnit>';
        }

        return $outerCargosInfo;
    }

    public function setReleaseLineInfo(array $outerReleaseCargos): string
    {
        $emptyValue = $outerReleaseCargosInfo = "";
        foreach ($outerReleaseCargos as $outerReleaseCargo) {
            $outerReleaseCargosInfo .= '<TransportHandlingUnit>';
            $outerReleaseCargosInfo .= '<PackageType>' . $outerReleaseCargo['outerPackageType'] . '</PackageType>';
            $outerReleaseCargosInfo .= '<GoodsDescription>' . $outerReleaseCargo['outerPackageDesc'] . '</GoodsDescription>';
            $outerReleaseCargosInfo .= '<MarksandNumbers>N</MarksandNumbers>';
            $outerReleaseCargosInfo .= '<HandlingUnit/>';
            $outerReleaseCargosInfo .= '<ValueOfGoods>' . $emptyValue . '</ValueOfGoods>';
            $outerReleaseCargosInfo .= '<ItemId>' . $emptyValue . '</ItemId>';
            $outerReleaseCargosInfo .= '<Length>';
            $outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageLengthValue'] . '</Value>';
            $outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageLengthUOM'] . '</UOM>';
            $outerReleaseCargosInfo .= '</Length>';
            $outerReleaseCargosInfo .= '<Width>';
            $outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageWidthValue'] . '</Value>';
            $outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageWidthUOM'] . '</UOM>';
            $outerReleaseCargosInfo .= '</Width>';
            $outerReleaseCargosInfo .= '<Height>';
            $outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageHeightValue'] . '</Value>';
            $outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageHeightUOM'] . '</UOM>';
            $outerReleaseCargosInfo .= '</Height>';
            $outerReleaseCargosInfo .= '<ActualWeight>';
            $outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageWeightValue'] . '</Value>';
            $outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageWeightUOM'] . '</UOM>';
            $outerReleaseCargosInfo .= '</ActualWeight>';
            $outerReleaseCargosInfo .= '<Weight>';
            $outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageWeightValue'] . '</Value>';
            $outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageWeightUOM'] . '</UOM>';
            $outerReleaseCargosInfo .= '</Weight>';
            $outerReleaseCargosInfo .= '<VolumetricWeight>';
            $outerReleaseCargosInfo .= '<Value>0.000</Value>';
            $outerReleaseCargosInfo .= '<UOM/>';
            $outerReleaseCargosInfo .= '</VolumetricWeight>';
            $outerReleaseCargosInfo .= '<Volume>';
            $outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageVolumeValue'] . '</Value>';
            $outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageVolumeUOM'] . '</UOM>';
            $outerReleaseCargosInfo .= '</Volume>';
            $outerReleaseCargosInfo .= '<ActualVolume>';
            $outerReleaseCargosInfo .= '<Value>' . $outerReleaseCargo['outerPackageVolumeValue'] . '</Value>';
            $outerReleaseCargosInfo .= '<UOM>' . $outerReleaseCargo['outerPackageVolumeUOM'] . '</UOM>';
            $outerReleaseCargosInfo .= '</ActualVolume>';
            $outerReleaseCargosInfo .= '<Quantity>' . $emptyValue . '</Quantity>';
            $outerReleaseCargosInfo .= '<ScannedQuantity>' . $emptyValue . '</ScannedQuantity>';
            $outerReleaseCargosInfo .= '<ldm>0.000</ldm>';
            $outerReleaseCargosInfo .= '<GroundedFlag>0</GroundedFlag>';
            $outerReleaseCargosInfo .= '<StackableFlag>0</StackableFlag>';
            $outerReleaseCargosInfo .= '<SplittableFlag>0</SplittableFlag>';
            $outerReleaseCargosInfo .= '<DangerousGoodsFlag>0</DangerousGoodsFlag>';
            $outerReleaseCargosInfo .= '<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>';
            $outerReleaseCargosInfo .= '</TransportHandlingUnit>';
        }

        return $outerReleaseCargosInfo;
    }

    public function setAddonsInfo(): string
    {
        $emptyValue = '';
        $addonsInfo = '<ValueAddedServices>';
        $addonsInfo .= '<Addon>';
        $addonsInfo .= '<AddonName>' . $emptyValue . '</AddonName>';
        $addonsInfo .= '<AddonCode>' . $emptyValue . '</AddonCode>';
        $addonsInfo .= '<Currency>' . $emptyValue . '</Currency>';
        $addonsInfo .= '<RateUnit>' . $emptyValue . '</RateUnit>';
        $addonsInfo .= '<AddonAmount>' . $emptyValue . '</AddonAmount>';
        $addonsInfo .= '<AddonQuantity>' . $emptyValue . '</AddonQuantity>';
        $addonsInfo .= '</Addon>';
        $addonsInfo .= '</ValueAddedServices>';

        return $addonsInfo;
    }

    public function setManageReferences(array $referencesAry, array $tripReferencesAry, string $bookingId, string $tripId): string
    {
        $referencesInfo = '<ManageReferences>';
        if (empty($referencesAry)) {
            $referencesInfo .= '<Reference>';
            $referencesInfo .= '<RefType>';
            $referencesInfo .= '<Code>TRIPEXTID</Code>';
            $referencesInfo .= '<Value>' . $tripId . '</Value>';
            $referencesInfo .= '</RefType>';
            $referencesInfo .= '</Reference>';
            $referencesInfo .= '<Reference>';
            $referencesInfo .= '<RefType>';
            $referencesInfo .= '<Code>EXTID</Code>';
            $referencesInfo .= '<Value>' . $bookingId . '</Value>';
            $referencesInfo .= '</RefType>';
            $referencesInfo .= '</Reference>';
        } else {
            foreach ($referencesAry as $references) {
                $referencesInfo .= '<Reference>';
                $referencesInfo .= '<RefType>';
                $referencesInfo .= '<Code>' . $references[0] . '</Code>';
                $referencesInfo .= '<Value>' . $references[1] . '</Value>';
                $referencesInfo .= '</RefType>';
                $referencesInfo .= '</Reference>';
            }
            foreach ($tripReferencesAry as $tripReferences) {
                $referencesInfo .= '<Reference>';
                $referencesInfo .= '<RefType>';
                $referencesInfo .= '<Code>' . $tripReferences[0] . '</Code>';
                $referencesInfo .= '<Value>' . $tripReferences[1] . '</Value>';
                $referencesInfo .= '</RefType>';
                $referencesInfo .= '</Reference>';
            }
            $referencesInfo .= '<Reference>';
            $referencesInfo .= '<RefType>';
            $referencesInfo .= '<Code>TRIPEXTID</Code>';
            $referencesInfo .= '<Value>' . $tripId . '</Value>';
            $referencesInfo .= '</RefType>';
            $referencesInfo .= '</Reference>';
            $referencesInfo .= '<Reference>';
            $referencesInfo .= '<RefType>';
            $referencesInfo .= '<Code>EXTID</Code>';
            $referencesInfo .= '<Value>' . $bookingId . '</Value>';
            $referencesInfo .= '</RefType>';
            $referencesInfo .= '</Reference>';
        }
        $referencesInfo .= '</ManageReferences>';

        return $referencesInfo;
    }

    public function setRemarks(array $remarksAry): string
    {
        $remarksInfo = "";
        if (empty($remarksAry)) {
            $remarksInfo .= '<Remarks>';
            $remarksInfo .= '</Remarks>';
        } else {
            $remarksInfo .= '<Remarks>';
            foreach ($remarksAry as $remarks) {
                $remarksInfo .= '<RemarkType>';
                $remarksInfo .= '<Code>' . $remarks[0] . '</Code>';
                $remarksInfo .= '<Value>' . $remarks[1] . '</Value>';
                $remarksInfo .= '</RemarkType>';
            }
            $remarksInfo .= '</Remarks>';
        }

        return $remarksInfo;
    }
}
