<?php

class Otmbookinghandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'otmbookingmodel']);
        $this->ci->load->model(['common', 'otmshipmentmodel']);

    }

    public function pullOrderXml(array $data): string
    {
        $status = "";
        $filterData = $this->orderData($data);
        if ($filterData['status'] == 1) {
            $status = "Order Creation Failed, : " . $filterData['message'];
            //echo "Order Creation Failed, : " . $filterData['message'];
            return $status;
        }
        $BookingId = $this->saveOrderDetails($filterData['data']);
        $status = "Order Created Successfully: Booking - " . $BookingId;
        return $status;
        //echo "Order Created Successfully: Booking - " . $BookingId;
    }

    public function orderData(array $data): array
    {
        $orderInfo = $data['ELGEDIOrderBody'];
        $orderHeader = $data['ELGEDIOrderHeader'];
        $orderDetails = $orderInfo['ELGBookingHeader'];
        $status = "";
        $domain = (empty($orderInfo['ELGOrgDetails']['DomainName']) ? "" : $orderInfo['ELGOrgDetails']['DomainName']);

        $organization = (empty($orderInfo['ELGOrgDetails']['OrganizationId']) ? "" : $orderInfo['ELGOrgDetails']['OrganizationId']);
        if ($organization == "") {
            $status = ["status" => 1, "message" => 'Organization ID is Empty'];
            return $status;
        }
        $organizationId = $this->ci->common->checkOrganization($organization);
        if ($organizationId == 0) {
            $status = ["status" => 1, "message" => 'Organization details was Wrong: ' . $organization];
            return $status;
        }
        $businessEntity = (empty($orderInfo['ELGOrgDetails']['BusinessEntity']) ? "" : $orderInfo['ELGOrgDetails']['BusinessEntity']);
        if ($businessEntity == "") {
            $status = ["status" => 1, "message" => 'Business Entity Value is Empty'];
            return $status;
        }

        $businessEntityValue = $this->ci->common->checkBusinessEntity($businessEntity, $organizationId);
        if (empty($businessEntityValue)) {
            $status = ["status" => 1, "message" => 'Business Entity Value was Wrong: ' . $businessEntity];
            return $status;
        }

        $OrderID = (empty($orderInfo['ELGBookingId']['BookingId']) ? "" : $orderInfo['ELGBookingId']['BookingId']);
        if ($OrderID == "") {
            $status = ["status" => 1, "message" => 'External Order ID in the XML: ' . ['ELGBookingId']['BookingId']];
            return $status;
        }

        $subCustomerId = "";

        if (empty($orderDetails['ELGCUSTOMER'])) {
            $status = ["status" => 1, "message" => 'Customer Details are Empty:'];
            return $status;
        } else {
            $customerName = (empty($orderDetails['ELGCUSTOMER']['ID']) ? "ALL" : $orderDetails['ELGCUSTOMER']['ID']);
            $xrefCustomer = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, 'CUSTOMER', $customerName);
            if ($xrefCustomer == "") {
                $status = ["status" => 1, "message" => 'XREF Customer Details are Empty:' . $orderDetails['ELGCUSTOMER']['ID']];
                return $status;
            } else {
                $parentCustomer = $this->ci->common->checkCustomer($xrefCustomer);
                if (empty($parentCustomer)) {
                    $status = ["status" => 1, "message" => 'XREF Customer Details Not Matching:' . $orderDetails['ELGCUSTOMER']['ID']];
                    return $status;
                } else {
                    if ($orderDetails['ELGCUSTOMER']['ID'] != "ALL") {
                        $subCustomer = $this->ci->common->checkCustomer($orderDetails['ELGCUSTOMER']['ID']);
                        if (empty($subCustomer)) {
                            $userData = [
                                'cusomer_code' => $orderDetails['ELGCUSTOMER']['ID'],
                                'user_id' => $orderDetails['ELGCUSTOMER']['ID'],
                                'parent_id' => $parentCustomer['id'],
                                'privilege' => $parentCustomer['privilege'],
                                'party_type' => $parentCustomer['party_type'],
                                'organization_id' => $organizationId,
                                'structure_id' => $businessEntityValue['id'],
                                'entity_id' => $businessEntityValue['entity_id'],
                                'entity_value_id' => $businessEntityValue['structure_id'],
                                'status' => 1,
                            ];
                            $subCustomerId = $this->ci->otmbookingmodel->insertUser($userData);
                        } else {
                            $subCustomerId = $subCustomer['id'];
                        }
                    } else {
                        $subCustomerId = $parentCustomer['id'];
                    }
                }
            }
        }

        if (!empty($orderInfo['CargoSummary']['TotalWeight']['UOM'])) {
            $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($orderInfo['CargoSummary']['TotalWeight']['UOM'], 'WT', $organizationId, $businessEntityValue['id']);
            if (empty($toWeightUOM)) {
                $status = ["status" => 1, "message" => 'Weight UOM not exist for organization: ' . $orderInfo['CargoSummary']['TotalWeight']['UOM']];
                return $status;
            }
        }

        if (!empty($orderInfo['CargoSummary']['TotalVolume']['UOM'])) {
            $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($orderInfo['CargoSummary']['TotalVolume']['UOM'], 'VO', $organizationId, $businessEntityValue['id']);
            if (empty($toVolumeUOM)) {
                $status = ["status" => 1, "message" => 'Volume UOM not exist for organization: ' . $orderInfo['CargoSummary']['TotalVolume']['UOM']];
                return $status;
            }
        }

        if (!empty($orderInfo['CargoDetails'])) {
            if (array_key_exists("0", $orderInfo['CargoDetails']['CargoThuDetails']) == 1) {
                foreach ($orderInfo['CargoDetails']['CargoThuDetails'] as $orderCargo) {
                    $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderCargo['PackageType'], $organizationId, $businessEntityValue['id']);
                    if (empty($toPackage)) {
                        $status = ["status" => 1, "message" => 'Order Outer Package Type not exist for organization: ' . $orderCargo['PackageType']];
                        return $status;
                    }
                    if (!empty($orderCargo['CargoPuDetails'])) {
                        if (array_key_exists("0", $orderCargo['CargoPuDetails']) == 1) {
                            foreach ($orderCargo['CargoPuDetails'] as $orderInnerCargo) {
                                $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInnerCargo['PackageType'], $organizationId, $businessEntityValue['id']);
                                if (empty($toPackage)) {
                                    $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInnerCargo['PackageType']];
                                    return $status;
                                }
                            }
                        } else {
                            $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderCargo['CargoPuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
                            if (empty($toPackage)) {
                                $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderCargo['CargoPuDetails']['PackageType']];
                                return $status;
                            }
                        }
                    }
                }
            } else {
                $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInfo['CargoDetails']['CargoThuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
                if (empty($toPackage)) {
                    $status = ["status" => 1, "message" => 'Order Outer Package Type not exist for organization: ' . $orderInfo['CargoDetails']['CargoThuDetails']['PackageType']];
                    return $status;
                }
                if (!empty($orderCargo['CargoPuDetails'])) {
                    if (array_key_exists("0", $orderCargo['CargoPuDetails']) == 1) {
                        foreach ($orderInfo['CargoDetails']['CargoThuDetails']['CargoPuDetails'] as $orderInnerCargo) {
                            $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInnerCargo['PackageType'], $organizationId, $businessEntityValue['id']);
                            if (empty($toPackage)) {
                                $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInnerCargo['PackageType']];
                                return $status;
                            }
                        }
                    } else {
                        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInfo['CargoDetails']['CargoThuDetails']['CargoPuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
                        if (empty($toPackage)) {
                            $status = ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInfo['CargoDetails']['CargoThuDetails']['CargoPuDetails']['PackageType']];
                            return $status;
                        }
                    }
                }
            }
        }

        if (!empty($orderInfo['InvolvedParties'])) {
            if (array_key_exists("0", $orderInfo['InvolvedParties']['InvolvedParty']) == 1) {
                foreach ($orderInfo['InvolvedParties']['InvolvedParty'] as $party) {
                    if ($party['PartyType'] == "CUSTOMER" && $party['ID'] == "ALL") {
                        $partyTypeValue = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, $party['PartyType'], $party['ID']);
                        $party['ID'] = $partyTypeValue;
                        $party['Company']['Name'] = $partyTypeValue;
                        $party['Company']['RegistrationNumber'] = $partyTypeValue;
                    }
                    $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $organizationId, $businessEntityValue['id']);
                    if (empty($toParty)) {
                        $status = ["status" => 1, "message" => 'Party Type not exist for organization: ' . $party['PartyType']];
                        return $status;
                    }
                }
            } else {
                $toParty = $this->ci->otmshipmentmodel->checkPartyRole($orderInfo['InvolvedParties']['InvolvedParty']['PartyType'], $organizationId, $businessEntityValue['id']);
                if (empty($toParty)) {
                    $status = ["status" => 1, "message" => 'Party Type not exist for organization: ' . $orderInfo['InvolvedParties']['InvolvedParty']['PartyType']];
                    return $status;
                }
            }
        }

        if (!empty($orderInfo['ManageReferences']['Reference'])) {
            if (array_key_exists("0", $orderInfo['ManageReferences']['Reference']) == 1) {
                foreach ($orderInfo['ManageReferences']['Reference'] as $orderRef) {
                    $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRefCode)) {
                        $status = ["status" => 1, "message" => 'Reference not exist for organization: ' . $orderRef['RefType']['Code']];
                        return $status;
                    }
                }
            } else {
                $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderInfo['ManageReferences']['Reference']['RefType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRefCode)) {
                    $status = ["status" => 1, "message" => 'Reference not exist for organization: ' . $orderInfo['ManageReferences']['Reference']['RefType']['Code']];
                    return $status;
                }
            }
        }

        if (!empty($orderInfo['Remarks'])) {
            if (array_key_exists("0", $orderInfo['Remarks']['RemarkType']) == 1) {
                foreach ($orderInfo['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRemarkCode)) {
                        $status = ["status" => 1, "message" => 'Remark not exist for organization: ' . $orderRem['Code']];
                        return $status;
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderInfo['Remarks']['RemarkType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRemarkCode)) {
                    $status = ["status" => 1, "message" => 'Remark not exist for organization: ' . $orderInfo['Remarks']['RemarkType']['Code']];
                    return $status;
                }
            }
        }

        $orderType = $orderDetails['OrderType'] ?? "DEFAULT";
        if (!empty($orderType)) {
            $destinationOrderType = $this->ci->otmshipmentmodel->checkOrderTypeCrossRef($orderDetails['OrderType'], $organizationId,
                $businessEntityValue['entity_id']);
            if (!empty($destinationOrderType)) {
                $orderType = $this->ci->otmbookingmodel->checkOrderType(
                    $destinationOrderType,
                    $organizationId,
                    $businessEntityValue['id'],
                    $businessEntityValue['entity_id']
                );
            }
        }

        $modeOfTransport = $orderDetails['ModeOfTransport'] ?? "DEFAULT";
        if (!empty($modeOfTransport)) {
            $destinationModeOfTransport = $this->ci->otmshipmentmodel->checkModeOfTransportCrossRef($orderDetails['ModeOfTransport'], $organizationId,
                $businessEntityValue['entity_id']);
            if (!empty($destinationModeOfTransport)) {
                $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
                    $destinationModeOfTransport,
                    $organizationId,
                    $businessEntityValue['id'],
                    $businessEntityValue['entity_id']
                );
            }
        }

        /*    $orderType = (empty($orderDetails['OrderType']) ? "0" : $orderDetails['OrderType']);
        $modeOfTransport = (empty($orderDetails['ModeOfTransport']) ? "0" : $orderDetails['ModeOfTransport']);*/
        $product = (empty($orderDetails['Product']) ? "0" : $orderDetails['Product']);
        $serviceType = (empty($orderDetails['ServiceType']) ? "0" : $orderDetails['ServiceType']);
        $orderData = [
            'TripID' => '0',
            'OrderID' => $OrderID,
            'EXTOrderID' => (empty($orderDetails['ELGBookingId']['BookingId']) ? $OrderID : $orderDetails['ELGBookingId']['BookingId']),
            'OrderType' => $orderType,
            'ModeOfTransport' => $modeOfTransport,
            'Product' => $product,
            'ServiceType' => $serviceType,
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue['id'],
            'businessEntityID' => $businessEntityValue['entity_id'],
            'TypeOfBusiness' => (empty($orderDetails['TypeOfBusiness']) ? "" : $orderDetails['TypeOfBusiness']),
            'Incoterm' => (empty($orderDetails['TermsOfTrade']['Incoterm']) ? "" : $orderDetails['TermsOfTrade']['Incoterm']),
            'FreightTerm' => (empty($orderDetails['TermsOfTrade']['FreightTerm']['Term']) ? "" : $orderDetails['TermsOfTrade']['FreightTerm']['Term']),
            'FreightTermName' => (empty($orderDetails['TermsOfTrade']['FreightTerm']['Name']) ? "" : $orderDetails['TermsOfTrade']['FreightTerm']['Name']),
            'customerDetails' => $orderDetails['ELGCUSTOMER'],
            'sourceInfo' => $orderInfo['LocationInfo']['Source'],
            'destinationInfo' => $orderInfo['LocationInfo']['Destination'],
            'cargoSummary' => $orderInfo['CargoSummary'],
            'cargoDetails' => $orderInfo['CargoDetails'],
            'valueAddedServices' => $orderInfo['ValueAddedServices'],
            'involvedParties' => $orderInfo['InvolvedParties'],
            'manageReferences' => $orderInfo['ManageReferences'],
            'remarks' => $orderInfo['Remarks'],
            'header' => $orderHeader,
            'organization' => $organization,
            'businessEntity' => $businessEntity,
            'source' => $orderHeader['SourceApp'],
            'domain' => $domain,
            'parentCustomer' => $parentCustomer,
            'subCustomerId' => $subCustomerId,
            'parentCarrier' => [],
            'subCarrierId' => "",
        ];
        return ["status" => 0, "data" => $orderData];
    }

    public function saveOrderDetails(array $orderData): string
    {
        $cdate = date('Y-m-d H:i:s');
        $userId = $this->ci->otmbookingmodel->getUserId('Integration');

        $customerId = 0;
        if (is_array($orderData['customerDetails'])) {
            $customerId = $this->checkPartyDetails($orderData, $orderData['customerDetails'], 'CUSTOMER', $orderData['organizationId'],
                $orderData['businessEntityValue']);
            log_message("error", "customerId:" . $customerId);
            /*$customerId = $this->checkPartyDetails(
        $orderData['customerDetails'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['domain'],
        'CUSTOMER',
        $orderData['organization'],
        $orderData['businessEntity']
        );*/
        }

        $sourceInfo = $this->checkPartyContactsDetails(
            $orderData['sourceInfo'],
            $orderData['organizationId'],
            $orderData['businessEntityValue'],
            $orderData['domain'],
            $customerId,
            "PICKUP",
            $orderData['organization'],
            $orderData['businessEntity']
        );

        $destinationInfo = $this->checkPartyContactsDetails(
            $orderData['destinationInfo'],
            $orderData['organizationId'],
            $orderData['businessEntityValue'],
            $orderData['domain'],
            $customerId,
            "DELIVERY",
            $orderData['organization'],
            $orderData['businessEntity']
        );

        /*$orderType = $orderData['OrderType'] ?? "DEFAULT";
        if (!empty($orderType)) {
        $destinationOrderType = $this->ci->otmshipmentmodel->checkOrderTypeCrossRef($orderData['OrderType'], $orderData['organizationId'],
        $orderData['businessEntityValue']);
        if (!empty($destinationOrderType)) {
        $orderType = $this->ci->otmbookingmodel->checkOrderType(
        $destinationOrderType,
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }
        }
        $modeOfTransport = $orderData['ModeOfTransport'] ?? "DEFAULT";
        if (!empty($modeOfTransport)) {
        $destinationModeOfTransport = $this->ci->otmshipmentmodel->checkModeOfTransportCrossRef($orderData['ModeOfTransport'], $orderData['organizationId'],
        $orderData['businessEntityValue']);
        if (!empty($destinationModeOfTransport)) {
        $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
        $destinationModeOfTransport,
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }
        }*/

        $product = $orderData['Product'] ?? 0;
        if ($product > 0) {
            $product = $this->ci->otmbookingmodel->checkProduct(
                $product,
                $orderData['organizationId'],
                $orderData['businessEntityID'],
                $orderData['businessEntityValue']
            );
        }
        $serviceType = $orderData['ServiceType'] ?? 0;
        if ($serviceType > 0) {
            $serviceType = $this->ci->otmbookingmodel->checkServiceType(
                $serviceType,
                $orderData['organizationId'],
                $orderData['businessEntityValue']
            );
        }
        $incoterm = $orderData['Incoterm'] ?? 0;
        if ($incoterm > 0) {
            $incoterm = $this->ci->otmbookingmodel->checkIncoTerm(
                $incoterm,
                $orderData['organizationId'],
                $orderData['businessEntityID'],
                $orderData['businessEntityValue']
            );
        }
        if ($incoterm == '') {
            $incoterm = 0;
        }
        $totalWeightUomCode = $totalVolumeUomCode = "";
        if (!empty($orderData['cargoSummary']['TotalWeight']['UOM'])) {
            $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['cargoSummary']['TotalWeight']['UOM'], 'WT', $orderData['organizationId'], $orderData['businessEntityValue']);
            /*if (!empty($toWeightUOM)) {
            $totalWeightUomCode = $this->ci->otmshipmentmodel->getUOMId($toWeightUOM);
            }*/
            $totalWeightUomCode = $toWeightUOM;
        }
        if (!empty($orderData['cargoSummary']['TotalVolume']['UOM'])) {
            $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['cargoSummary']['TotalVolume']['UOM'], 'VO', $orderData['organizationId'], $orderData['businessEntityValue']);
            /*if (!empty($toVolumeUOM)) {
            $totalVolumeUomCode = $this->ci->otmshipmentmodel->getUOMId($toVolumeUOM);
            }*/
            $totalVolumeUomCode = $toVolumeUOM;
        }
        $orderQuantity = $orderData['cargoSummary']['TotalQuantity']['Value'];
        /*$orderTotalVolume = $orderData['cargoSummary']['TotalVolume']['Value'];
        $orderTotalVolumeUOM = $orderData['cargoSummary']['TotalVolume']['UOM'];
        $orderTotalWeight = $orderData['cargoSummary']['TotalWeight']['Value'];
        $orderTotalWeightUOM = $orderData['cargoSummary']['TotalWeight']['UOM'];*/
        $orderTotalVolume = $orderData['cargoSummary']['TotalVolume']['Value'];
        $orderTotalVolumeUOM = $totalVolumeUomCode;
        $orderTotalWeight = $orderData['cargoSummary']['TotalWeight']['Value'];
        $orderTotalWeightUOM = $totalWeightUomCode;

        /*$orderInfo = [
        'external_order_id' => $orderData['OrderID'],
        'customer_id' => $customerId,
        'pickup_id' => $sourceInfo['partyContactID'],
        'delivery_id' => $destinationInfo['partyContactID'],
        'pickup_start_date' => $pickup_start_date,
        'delivery_start_date' => $delivery_start_date,
        'pickup_end_date' => $pickup_end_date,
        'delivery_end_date' => $delivery_end_date,
        'order_type' => $orderType,
        'mode_of_transport' => $modeOfTransport,
        'inco_terms' => $incoterm,
        'rate_terms' => 0,
        'product' => $product,
        'service' => $serviceType,
        'quantity' => $orderQuentity,
        'order_weight' => $orderTotalWeight,
        'order_weight_uom' => $orderTotalWeightUOM,
        'order_volume' => $orderTotalVolume,
        'order_volume_uom' => $orderTotalVolumeUOM,
        'organization_id' => $orderData['organizationId'],
        'entity_value_id' => $orderData['businessEntityValue'],
        'user_id' => $userId,
        'ship_unit_id' => $orderMovementId
        ];*/
        $checkorder = $this->ci->otmbookingmodel->checkOrderCount(
            $orderData['OrderID'],
            $orderData['organizationId'],
            $orderData['businessEntityValue']
        );
        if (!empty($checkorder)) {
            $pickup_start_date = str_replace("T", " ", is_array($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) ? $checkorder['pickup_start_date'] : $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']);
            $pickup_end_date = str_replace("T", " ", (is_array($orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']) ? $checkorder['pickup_end_date'] : $orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']));
            $delivery_start_date = str_replace("T", " ", (is_array($orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']) ? $checkorder['delivery_start_date'] : $orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']));
            $delivery_end_date = str_replace("T", " ", (is_array($orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']) ? $checkorder['delivery_end_date'] : $orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']));
            $orderMovementId = empty($orderData['orderMovementId']) ? $checkorder['ship_unit_id'] : $orderData['orderMovementId'];
            $orderType = $checkorder['order_type'];
            $modeOfTransport = $checkorder['mode_of_transport'];
            /*$orderType = empty($orderData['OrderType']) ? $checkorder['order_type'] : $orderData['OrderType'];
            $modeOfTransport = empty($orderData['ModeOfTransport']) ? $checkorder['mode_of_transport'] : $orderData['ModeOfTransport'];*/
            $orderQuantity = empty($orderQuantity) ? $checkorder['quantity'] : $orderQuantity;
            $orderTotalWeight = empty($orderTotalWeight) ? $checkorder['$orderTotalWeight'] : $orderTotalWeight;
            $orderTotalWeightUOM = empty($orderTotalWeightUOM) ? $checkorder['$orderTotalWeightUOM'] : $orderTotalWeightUOM;
            $orderTotalVolume = empty($orderTotalVolume) ? $checkorder['$orderTotalVolume'] : $orderTotalVolume;
            $orderTotalVolumeUOM = empty($orderTotalVolumeUOM) ? $checkorder['$orderTotalVolumeUOM'] : $orderTotalVolumeUOM;
            $orderInfo = [
                'external_order_id' => $orderData['OrderID'],
                'customer_id' => $customerId,
                'pickup_id' => $sourceInfo['partyContactID'],
                'delivery_id' => $destinationInfo['partyContactID'],
                'pickup_start_date' => $pickup_start_date,
                'delivery_start_date' => $delivery_start_date,
                'pickup_end_date' => $pickup_end_date,
                'delivery_end_date' => $delivery_end_date,
                'order_type' => $orderType,
                'mode_of_transport' => $modeOfTransport,
                'inco_terms' => $incoterm,
                'rate_terms' => 0,
                'product' => $product,
                'service' => $serviceType,
                'quantity' => $orderQuantity,
                'order_weight' => $orderTotalWeight,
                'order_weight_uom' => $orderTotalWeightUOM,
                'order_volume' => $orderTotalVolume,
                'order_volume_uom' => $orderTotalVolumeUOM,
                'organization_id' => $orderData['organizationId'],
                'entity_value_id' => $orderData['businessEntityValue'],
                'user_id' => $userId,
                'ship_unit_id' => $orderMovementId,
                'modifiedon' => date('Y-m-d H:i:s'),
                'source' => $orderData['source'],
                'domain' => $orderData['domain'],
            ];
            $this->ci->common->updatetbledata('tb_orders', $orderInfo, ['id' => $checkorder['id']]);
            $bookingID = $checkorder['order_id'];
            $orderNo = $checkorder['id'];
        } else {
            $pickup_start_date = str_replace("T", " ", is_array($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) ? "" : $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']);
            $pickup_end_date = str_replace("T", " ", (is_array($orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']) ? "" : $orderData['sourceInfo']['EstimatedDateTime']['To']['DateTime']));
            $delivery_start_date = str_replace("T", " ", (is_array($orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']) ? "" : $orderData['destinationInfo']['EstimatedDateTime']['From']['DateTime']));
            $delivery_end_date = str_replace("T", " ", (is_array($orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']) ? "" : $orderData['destinationInfo']['EstimatedDateTime']['To']['DateTime']));
            $orderMovementId = empty($orderData['orderMovementId']) ? "" : $orderData['orderMovementId'];
            $orderType = $orderData['OrderType'];
            $modeOfTransport = $orderData['ModeOfTransport'];
            $orderInfo = [
                'external_order_id' => $orderData['OrderID'],
                'customer_id' => $customerId,
                'pickup_id' => $sourceInfo['partyContactID'],
                'delivery_id' => $destinationInfo['partyContactID'],
                'pickup_start_date' => $pickup_start_date,
                'delivery_start_date' => $delivery_start_date,
                'pickup_end_date' => $pickup_end_date,
                'delivery_end_date' => $delivery_end_date,
                'order_type' => $orderType,
                'mode_of_transport' => $modeOfTransport,
                'inco_terms' => $incoterm,
                'rate_terms' => 0,
                'product' => $product,
                'service' => $serviceType,
                'quantity' => $orderQuantity,
                'order_weight' => $orderTotalWeight,
                'order_weight_uom' => $orderTotalWeightUOM,
                'order_volume' => $orderTotalVolume,
                'order_volume_uom' => $orderTotalVolumeUOM,
                'organization_id' => $orderData['organizationId'],
                'entity_value_id' => $orderData['businessEntityValue'],
                'user_id' => $userId,
                'ship_unit_id' => $orderMovementId,
                'modifiedon' => date('Y-m-d H:i:s'),
                'source' => $orderData['source'],
                'domain' => $orderData['domain'],
            ];

            $orderNo = $this->ci->common->insertTableData('tb_orders', $orderInfo);
            if (strlen($orderNo) < 5) {
                $lastGenId = str_pad($orderNo, 5, '0', STR_PAD_LEFT);
            } else {
                $lastGenId = $orderNo;
            }
            $bookingID = date('d') . date('m') . date('y') . $lastGenId;

            /*$bookingID = "ORD" . $orderData['organizationId'] . $orderData['businessEntityValue'] . date('y') . date(
            'm') . date('W') . date('d') . date('s') . $orderNo;*/
            $this->ci->common->updatetbledata("tb_orders", ['order_id' => $bookingID], ['id' => $orderNo]);
            $this->ci->otmbookingmodel->insertOrderStatus($orderData['TripID'], $bookingID, $orderData['organizationId'], $orderData['businessEntityValue']);
        }

        if (!empty($orderData['cargoDetails'])) {
            if (array_key_exists("0", $orderData['cargoDetails']['CargoThuDetails']) == 1) {
                foreach ($orderData['cargoDetails']['CargoThuDetails'] as $orderCargo) {
                    $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderCargo['PackageType'], $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                    if (!empty($toPackage)) {
                        $packageId = $this->ci->otmshipmentmodel->getPackageId($toPackage);
                        $orderCargo['PackageType'] = $packageId;
                        $itemId = $this->ci->otmshipmentmodel->getItemId($toPackage);
                        $orderCargo['ldm'] = $itemId;
                        $this->ci->otmbookingmodel->insertCargoInfo($orderCargo,
                            $orderNo,
                            $orderData['organizationId'],
                            $orderData['businessEntityValue']);
                    }
                }
            } else {
                $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderData['cargoDetails']['CargoThuDetails']['PackageType'], $orderData['organizationId'],
                    $orderData['businessEntityValue']);
                if (!empty($toPackage)) {
                    $packageId = $this->ci->otmshipmentmodel->getPackageId($toPackage);
                    $orderData['cargoDetails']['CargoThuDetails']['PackageType'] = $packageId;
                    $itemId = $this->ci->otmshipmentmodel->getItemId($toPackage);
                    $orderData['cargoDetails']['CargoThuDetails']['ldm'] = $itemId;
                    $this->ci->otmbookingmodel->insertCargoInfo($orderData['cargoDetails']['CargoThuDetails'],
                        $orderNo,
                        $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                }
            }
        }

        if (!empty($orderData['valueAddedServices']['Addon'])) {
            if (array_key_exists("0", $orderData['valueAddedServices']['Addon']) == 1) {
                foreach ($orderData['valueAddedServices']['Addon'] as $valueAddedServices) {
                    $this->ci->otmbookingmodel->insertValueAddedServices($valueAddedServices,
                        $orderNo,
                        $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                }
            } else {
                $this->ci->otmbookingmodel->insertValueAddedServices(
                    $orderData['valueAddedServices']['Addon'],
                    $orderNo,
                    $orderData['organizationId'],
                    $orderData['businessEntityValue']
                );
            }
        }

        if (!empty($orderData['involvedParties'])) {
            if (array_key_exists("0", $orderData['involvedParties']['InvolvedParty']) == 1) {
                foreach ($orderData['involvedParties']['InvolvedParty'] as $party) {
                    $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                    $partyInfo = $this->checkPartyContactsDetails(
                        $party,
                        $orderData['organizationId'],
                        $orderData['businessEntityValue'],
                        $orderData['domain'],
                        $customerId,
                        strtoupper($toParty),
                        $orderData['organization'],
                        $orderData['businessEntity']
                    );
                    $orderParty = [
                        'order_id' => $orderNo,
                        'party_id' => $customerId,
                        'contact_id' => $partyInfo['partyContactID'],
                        'party_type' => $partyInfo['party_type_id'],
                        'organization_id' => $orderData['organizationId'],
                        'entity_value_id' => $orderData['businessEntityValue'],
                        'status' => 1,
                    ];
                    $this->ci->otmbookingmodel->insertOrderParties($orderParty);
                }
            } else {
                $toParty = $this->ci->otmshipmentmodel->checkPartyRole($orderData['involvedParties']['InvolvedParty']['PartyType'], $orderData['organizationId'],
                    $orderData['businessEntityValue']);
                $partyInfo = $this->checkPartyContactsDetails(
                    $orderData['involvedParties']['InvolvedParty'],
                    $orderData['organizationId'],
                    $orderData['businessEntityValue'],
                    $orderData['domain'],
                    $customerId,
                    strtoupper($toParty),
                    $orderData['organization'],
                    $orderData['businessEntity']
                );
                $orderParty = [
                    'order_id' => $orderNo,
                    'party_id' => $customerId,
                    'contact_id' => $partyInfo['partyContactID'],
                    'party_type' => $partyInfo['party_type_id'],
                    'organization_id' => $orderData['organizationId'],
                    'entity_value_id' => $orderData['businessEntityValue'],
                    'status' => 1,
                ];
                $this->ci->otmbookingmodel->insertOrderParties($orderParty);
            }
        }

        if (!empty($orderData['manageReferences']['Reference'])) {
            if (array_key_exists("0", $orderData['manageReferences']['Reference']) == 1) {
                foreach ($orderData['manageReferences']['Reference'] as $orderRef) {
                    $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
                    if (!empty($toRefCode)) {
                        $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
                        $orderRef['RefType']['Code'] = $referenceId;
                        $this->ci->otmbookingmodel->insertOrderReferences($orderNo, $orderRef, $orderData['organizationId'], $orderData['businessEntityValue']);
                    }
                }
            } else {
                $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderData['manageReferences']['Reference']['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
                if (!empty($toRefCode)) {
                    $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
                    $orderData['manageReferences']['Reference']['RefType']['Code'] = $referenceId;
                    $this->ci->otmbookingmodel->insertOrderReferences($orderNo, $orderData['manageReferences']['Reference'], $orderData['organizationId'], $orderData['businessEntityValue']);
                }
            }
        }

        if (!empty($orderData['remarks'])) {
            if (array_key_exists("0", $orderData['remarks']['RemarkType']) == 1) {
                foreach ($orderData['remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                    if (!empty($toRemarkCode)) {
                        $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                        $orderRem['Code'] = $remarkId;
                        $this->ci->otmbookingmodel->insertOrderRemarks($orderNo, $orderRem, $orderData['organizationId'], $orderData['businessEntityValue']);
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderData['remarks']['RemarkType']['Code'], $orderData['organizationId'],
                    $orderData['businessEntityValue']);
                if (!empty($toRemarkCode)) {
                    $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                    $orderData['remarks']['RemarkType']['Code'] = $remarkId;
                    $this->ci->otmbookingmodel->insertOrderRemarks($orderNo, $orderData['remarks']['RemarkType'], $orderData['organizationId'], $orderData['businessEntityValue']);
                }
            }
        }

        return $bookingID ?? "";
    }

    /*public function checkPartyDetails(
    array $partyData,
    int $organizationId,
    int $businessEntityValue,
    string $domain,
    string $partyType,
    string $organization,
    string $businessEntity
    ): int
    {
    $party_code = is_array($partyData['ID']) ? "" : $partyData['ID'];
    $partyTypeValue = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue, $domain, $partyType, $party_code);
    //$partyTypeValue = $this->ci->common->checkPartyTypeCrossRef($organization, $businessEntity, $partyType, $party_code);
    if($party_code == "ALL")
    {
    $party_code = $partyTypeValue;
    }
    $partyTypeId = 0;
    if($partyType == "CUSTOMER")
    {
    $partyTypeId = 1;
    }
    if($partyType == "CARRIER")
    {
    $partyTypeId = 2;
    }
    $userId = $this->ci->otmbookingmodel->getUserId($partyTypeValue);
    $partyWhere = [
    "customer_code" => $party_code,
    "user_id" => $userId,
    "party_type" => $partyTypeId,
    "organization_id" => $organizationId,
    "entity_value_id" => $businessEntityValue,
    'status' => 1
    ];
    $checkParty = $this->ci->common->gettblrowdata($partyWhere, "id", "tb_party", 0, 0);
    if (!empty($checkParty)) {
    $party_id = $checkParty['id'];
    } else {
    $partyWhere['user_id'] = $userId;
    $party_id = $this->ci->common->insertTableData('tb_party', $partyWhere);
    //$party_code = $organizationId . $businessEntityValue . date('y') . date('W') . $party_id;
    $this->ci->common->updatetbledata("tb_party", ['customer_code' => $party_code], ['id' => $party_id]);//
    }
    return $party_id ?? 0;
    }*/

    public function checkPartyDetails(array $orderData, array $partyData, string $partyType, int $organizationId,
        int $businessEntityValue): int {
        $party_code = is_array($partyData['ID']) ? "" : $partyData['ID'];
        $parentPartyType = $orderData['parentCustomer']['party_type'];

        $partyTypeId = 0;
        if ($partyType == "CUSTOMER") {
            $partyTypeId = 1;
            $childId = $orderData['subCustomerId'];
            $childUserId = $orderData['subCustomerId'];
            $parentUserId = $orderData['parentCustomer']['user_id'];
            $parentId = $orderData['parentCustomer']['id'];
            $partyCode = ($party_code == "ALL") ? $parentUserId : $party_code;
        }
        if ($partyType == "CARRIER") {
            $partyTypeId = 2;
            $childId = $orderData['subCarrierId'];
            $childUserId = $orderData['subCarrierId'];
            $parentUserId = $orderData['parentCarrier']['user_id'];
            $parentId = $orderData['parentCarrier']['id'];
            $partyCode = ($party_code == "ALL") ? $orderData['parentCarrier']['user_id'] : $party_code;
        }
        $parentCustomerWhere = [
            "customer_code" => $parentUserId,
            "user_id" => $parentId,
            //"party_type" => $parentPartyType,
            "organization_id" => $organizationId,
            "entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];

        $parentCustomerInsert = [
            "customer_code" => $parentUserId,
            "user_id" => $parentId,
            "party_type" => $parentPartyType,
            "organization_id" => $organizationId,
            "entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];
        $checkParentParty = $this->ci->common->gettblrowdata($parentCustomerWhere, "id", "tb_party", 0, 0);

        $parentIdVal = 0;
        $party_id = 0;

        if (!empty($checkParentParty)) {
            $parentIdVal = $checkParentParty['id'];

        } else {
            $parentIdVal = $this->ci->common->insertTableData('tb_party', $parentCustomerInsert);

        }
        if ($party_code == "ALL") {
            $parentIdVal = null;
            //$partyCode = $parentUserId;
        }
        $partyWhere = [
            "customer_code" => $partyCode,
            "user_id" => $childId,
            "parent_customer" => $parentIdVal,
            //"party_type" => $partyTypeId,
            "organization_id" => $organizationId,
            "entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];
        $partyInsert = [
            "customer_code" => $partyCode,
            "user_id" => $childId,
            "parent_customer" => $parentIdVal,
            "party_type" => $partyTypeId,
            "organization_id" => $organizationId,
            "entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];

        $checkParty = $this->ci->common->gettblrowdata($partyWhere, "id", "tb_party", 0, 0);

        if (!empty($checkParty)) {
            $party_id = $checkParty['id'];

        } else {
            $party_id = $this->ci->common->insertTableData('tb_party', $partyInsert);

        }

        return $party_id ?? 0;
    }

    public function checkPartyContactsDetails(
        array $partyData,
        int $organizationId,
        int $businessEntityValue,
        string $domain,
        int $customerId,
        string $partyDataType,
        string $organization,
        string $businessEntity
    ): array {
        $curdt = date("Y-m-d H:i:s");
        log_message("error", "customerId1111:" . $customerId);
        $party_code = empty($partyData['ID']) ? $partyData['CompanyName'] : $partyData['ID'];
        $customer = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue, $domain, $partyDataType, $party_code);
        //$customer = $this->ci->common->checkPartyTypeCrossRef($organization, $businessEntity, $partyDataType, $party_code);
        if ($party_code == "ALL") {
            $party_code = $customer;
        }
        $party_type_id = $this->ci->otmbookingmodel->getPartyTypeId($partyDataType);
        $partyWhere = [
            "name" => $party_code,
            "party_role" => $party_type_id,
            "party_id" => $customerId,
            'status' => 1,
            'organization_id' => $organizationId,
            'business_entity_value' => $businessEntityValue,
        ];
        log_message("error", "partyWhere:" . json_encode($partyWhere));
        $checkParty = $this->ci->common->gettblrowdata($partyWhere, "id", "tb_party_contacts", 0, 0);

        if (!empty($checkParty)) {
            $partyContactID = $checkParty['id'];
        } else {
            $name = $party_code;
            $address1 = empty($partyData['Address']['Address1']) ? empty($partyData['Address1']) ? "" : $partyData['Address1'] : $partyData['Address']['Address1'];
            $address2 = empty($partyData['Address']['Address2']) ? empty($partyData['Address2']) ? "" : $partyData['Address2'] : $partyData['Address']['Address2'];
            $street = empty($partyData['Address']['Street']) ? empty($partyData['Street']) ? "" : $partyData['Street'] : $partyData['Address']['Street'];
            $city = empty($partyData['Address']['City']) ? empty($partyData['City']) ? "" : $partyData['City'] : $partyData['Address']['City'];
            $State = (empty($partyData['Address']['State']) ? "" : $partyData['Address']['State']);
            $province = empty($partyData['Address']['Province']) ? "" : $partyData['Address']['Province'];
            $postal = (empty($partyData['Address']['Postal']) ? empty($partyData['Postal']) ? "" : $partyData['Postal'] : $partyData['Address']['Postal']);
            $country = (empty($partyData['Address']['Country']) ? empty($partyData['ContactInfo']['Country']) ? "" : $partyData['ContactInfo']['Country'] : $partyData['Address']['Country']);
            $email = (empty($partyData['Address']['ContactInfo']['EmailAddress']) ? "" : $partyData['Address']['ContactInfo']['EmailAddress']);
            $phone = (empty($partyData['Address']['ContactInfo']['ContactNo']) ? empty($partyData['ContactInfo']['ContactNo']) ? "" : $partyData['ContactInfo']['ContactNo'] : $partyData['Address']['ContactInfo']['ContactNo']);
            $latitude = (empty($partyData['Address']['Latitude']) ? empty($partyData['Latitude']) ? 0 : $partyData['Latitude'] : $partyData['Address']['Latitude']);
            $longitude = (empty($partyData['Address']['Longitude']) ? empty($partyData['Longitude']) ? 0 : $partyData['Longitude'] : $partyData['Address']['Longitude']);
            $address = $address1 . "," . $address2 . "," . $street . "," . $city . "," . $State . "," . $province . "," . $postal . "," . $country;

            $addressFlag = 0;
            if ($partyDataType == "CUSTOMER" || $partyDataType == "CARRIER") {
                $addressFlag = 1;
            }

            if ($latitude == "" && $longitude == "") {
                $data = getlatlngsbyaddress($address);
                $latitude = @$data[0];
                $longitude = @$data[1];
            }

            $partycontactInfo = [
                "party_code" => $party_code,
                "party_role" => $party_type_id,
                "party_id" => $customerId,
                'name' => $name,
                'address1' => $address1,
                'address2' => $address2,
                'province' => $province,
                'phone' => $phone,
                'email' => $email,
                'street' => $street,
                'city' => $city,
                'state' => $State,
                'zipcode' => $postal,
                'country' => $country,
                'latitude' => $latitude,
                'longitude' => $longitude,
                'organization_id' => $organizationId,
                'business_entity_value' => $businessEntityValue,
                'status' => 1,
                'address_flag' => $addressFlag,
            ];
            if ($customerId != 0) {
                $partyContactID = $this->ci->common->insertTableData('tb_party_contacts', $partycontactInfo);
            }
        }

        $partyContacts = [
            'partyContactID' => $partyContactID,
            'party_type_id' => $party_type_id,

        ];
        return $partyContacts ?? [];
    }
}
