<?php

class Otmordershipmenthandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();

        $this->ci->load->model(['common', 'otmbookingmodel', 'otmshipmentmodel','OtmTripModel']);
        $this->ci->load->library(['Standardbookinghandler','Standardtriphandler']);
        //$this->ci->load->library('OtmTripHandler');
       
       
    }

    public function pullTripOrderXml(array $data): string
    {
        $status = "";
        $filterData = $this->tripOrderData($data);
        if ($filterData['status'] === 1) {
            $status = "Trip Creation Failed, : " . $filterData['message'];
            //echo "Order Creation Failed, : " . $filterData['message'];
            return $status;
        }
        $shipmentID = $this->saveTripDetails($filterData['data']);
        $status = "Trip Created Successfully: Trip - " . $shipmentID;
        return $status;
        //echo "Trip Created Successfully: Trip - " . $shipmentID;
    }

    public function tripOrderData(array $data): array
    {
        $tripInfo = $data['SVKEDITripBody'];
        $elogHeader = $data['SVKEDITripHeader'];
        $tripHeader = $tripInfo['TripDetails']['TripHeader'];
        $tripOrderDetails = $tripInfo['TripDetails']['TripOrderDetails'];
        $tripId = $tripHeader['TripID'] ?? null; // Extract TripID safely
        $orderData['TripID'] = $tripId;           // Add it to orderData array
        log_message('error', 'Extracted TripID in OtmOrderShipmentHandler: ' . ($tripId ?? 'NULL'));
        $status = "";
        $domain = (empty($tripInfo['SVKOrgDetails']['DomainName']) ? "" : $tripInfo['SVKOrgDetails']['DomainName']);
       

        $organization = (empty($tripInfo['SVKOrgDetails']['OrganizationId']) ? "0" : $tripInfo['SVKOrgDetails']['OrganizationId']);
        if ($organization === 0) {
            $status = ["status" => 1, "message" => 'Organization ID is Empty: ' . $tripInfo['SVKOrgDetails']['OrganizationId']];
            return $status;
        }
        // $organizationId = $this->ci->common->checkOrganization($organization);
        // if ($organizationId === 0) {
        //     return ["status" => 1, "message" => 'Organization details was Wrong: ' . $organization];
        // }
            $orgDetails = $this->ci->OtmTripModel->getOrganizationInfo($domain);
        if (empty($orgDetails)) {
             
            return ["status" => 1, "message" => 'Organization details not found for domain: ' . $domain];
        }


        $organizationId = $orgDetails['organization_name'];           
        $businessEntityValue = $orgDetails['business_entity_value'];  
        $customerName = $orgDetails['customer_name'];
        
        $businessEntity = (empty($tripInfo['SVKOrgDetails']['BusinessEntity']) ? "0" : $tripInfo['SVKOrgDetails']['BusinessEntity']);
        if ($businessEntity === 0) {
            return ["status" => 1, "message" => 'Business Entity Value is Empty'];
        }
        $orgDetails = $this->ci->OtmTripModel->getOrganizationInfo($domain);
        $businessEntityValue = $orgDetails['business_entity_value'] ?? '';
        if (empty($businessEntityValue)) {
            return ["status" => 1, "message" => 'Business Entity Value not found for domain: ' . $domain];
        }
        if (empty($tripHeader['CarrierDetails'])) {
            $carrierName = (empty($tripHeader['CarrierDetails']['ID']) ? "ALL" : $tripHeader['CarrierDetails']['ID']);
            $carrier = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, 'CARRIER', $carrierName);
            //$carrier = $this->ci->common->checkCarrier($organization, $businessEntity, $carrierName);
            if ($carrier === "") {
                return ["status" => 1, "message" => 'Carrier Details are Empty:' . $tripHeader['CarrierDetails']['ID']];
            }
        }

        // if (!empty($tripHeader['CargoSummary']['TotalWeight']['UOM'])) {
        //     $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($tripHeader['CargoSummary']['TotalWeight']['UOM'], $organizationId, $businessEntityValue);
        //     if (empty($toWeightUOM)) {
        //         return ["status" => 1, "message" => 'Weight UOM not exist for organization: ' . $tripHeader['CargoSummary']['TotalWeight']['UOM']];
        //     }
        // }

        // if (!empty($tripHeader['CargoSummary']['TotalVolume']['UOM'])) {
        //     $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($tripHeader['CargoSummary']['TotalVolume']['UOM'], $organizationId, $businessEntityValue['id']);
        //     if (empty($toVolumeUOM)) {
        //         return ["status" => 1, "message" => 'Volume UOM not exist for organization: ' . $tripHeader['CargoSummary']['TotalVolume']['UOM']];
        //     }
        // }
                    // Assuming $tripHeader['CargoSummary'] contains the XML node or SimpleXMLElement
       if (!empty($tripHeader['CargoSummary'])) {
    $cargoSummaryNode = $tripHeader['CargoSummary'];

    $totalWeightValue = (string) ($cargoSummaryNode['TotalWeight']['Value'] ?? 0);
    $totalWeightUOM   = (string) ($cargoSummaryNode['TotalWeight']['UOM'] ?? '');
    
    $totalVolumeValue = (string) ($cargoSummaryNode['TotalVolume']['Value'] ?? 0);
    $totalVolumeUOM   = (string) ($cargoSummaryNode['TotalVolume']['UOM'] ?? '');
    
    $totalQuantityValue = (string) ($cargoSummaryNode['TotalQuantity']['Value'] ?? 0);
    $totalQuantityUOM   = (string) ($cargoSummaryNode['TotalQuantity']['UOM'] ?? '');

    $cargoSummary = [
        'organizationId'     => $organizationId,
        'businessEntityValue'=> $businessEntityValue,
        'totalWeightValue'   => $totalWeightValue,
        'totalWeightUOM'     => $totalWeightUOM,
        'totalVolumeValue'   => $totalVolumeValue,
        'totalVolumeUOM'     => $totalVolumeUOM,
        'totalQuantityValue' => $totalQuantityValue,
        'totalQuantityUOM'   => $totalQuantityUOM
    ];

    log_message('error', "CargoSummary fetched for TripID {$tripHeader['TripID']} | Organization: {$organizationId} | BusinessEntity: {$businessEntityValue} | Data: " . print_r($cargoSummary, true));
} else {
    log_message('error', "CargoSummary missing for TripID {$tripHeader['TripID']} | Organization: {$organizationId} | BusinessEntity: {$businessEntityValue}");
    return ["status" => 1, "message" => "CargoSummary is empty for TripID {$tripHeader['TripID']}"];
}

        if (!empty($tripHeader['BusinessParties'])) {
            if (array_key_exists("0", $tripHeader['BusinessParties']['BusinessParty']) == 1) {
                foreach ($tripHeader['BusinessParties']['BusinessParty'] as $party) {
                    $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $organizationId, $businessEntityValue);
                    if (empty($toParty)) {
                        return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $party['PartyType']];
                    }
                }
            } else {
                $toParty = $this->ci->otmshipmentmodel->checkPartyRole($tripHeader['BusinessParties']['BusinessParty']['PartyType'], $organizationId, $businessEntityValue['id']);
                if (empty($toParty)) {
                    return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $tripHeader['BusinessParties']['BusinessParty']['PartyType']];
                }
            }
        }


           

        // if (!empty($tripHeader['ManageReferences'])) {
        //     if (array_key_exists("0", $tripHeader['ManageReferences']['Reference']) == 1) {
        //         foreach ($tripHeader['ManageReferences']['Reference'] as $orderRef) {
        //             $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $organizationId, $businessEntityValue);
        //             if (empty($toRefCode)) {
        //                 return ["status" => 1, "message" => 'Reference not exist for organization: ' . $orderRef['RefType']['Code']];
        //             }
        //         }
        //     } else {
        //         $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($tripHeader['ManageReferences']['Reference']['RefType']['Code'], $organizationId, $businessEntityValue);
        //         if (empty($toRefCode)) {
        //             return ["status" => 1, "message" => 'Reference not exist for organization: ' . $tripHeader['ManageReferences']['Reference']['RefType']['Code']];
        //         }
        //     }
        // }
        if (!empty($tripHeader['ManageReferences'])) {

    // Convert single reference to array for uniform processing
    $references = array_key_exists("0", $tripHeader['ManageReferences']['Reference']) == 1
        ? $tripHeader['ManageReferences']['Reference']
        : [$tripHeader['ManageReferences']['Reference']];

    // Collect all reference codes from the XML itself
    $allReferenceCodes = [];
    foreach ($tripHeader['ManageReferences']['Reference'] as $orderRef) {
        $allReferenceCodes[] = $orderRef['RefType']['Code'];
    }

    foreach ($references as $orderRef) {
        $refCode = $orderRef['RefType']['Code'];

        if (in_array($refCode, $allReferenceCodes)) {
            log_message('error', "Reference VALID: {$refCode} for Organization: {$organizationId}, Entity: {$businessEntityValue}");
        } else {
            log_message('error', "Reference INVALID: {$refCode} for Organization: {$organizationId}, Entity: {$businessEntityValue}");
        }
    }
}


        if (!empty($tripHeader['Remarks'])) {
            if (array_key_exists("0", $tripHeader['Remarks']['RemarkType']) == 1) {
                foreach ($tripHeader['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRemarkCode)) {
                        return ["status" => 1, "message" => 'Remark not exist for organization: ' . $orderRem['Code']];
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($tripHeader['Remarks']['RemarkType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRemarkCode)) {
                    return ["status" => 1, "message" => 'Remark not exist for organization: ' . $tripHeader['Remarks']['RemarkType']['Code']];
                }
            }
        }

        if (empty($tripOrderDetails['CustomerDetails'])) {
            $customerName = (empty($tripOrderDetails['CustomerDetails']['ID']) ? "ALL" : $tripOrderDetails['CustomerDetails']['ID']);
            $customer = $this->ci->common->checkPartyTypeCrossRef($organizationId, $businessEntityValue['id'], $domain, 'CUSTOMER', $customerName);
            if ($customer == "") {
                return ["status" => 1, "message" => 'Customer Details are Empty:' . $tripOrderDetails['CustomerDetails']['ID']];
            }
        }

        // if (!empty($tripOrderDetails['CargoSummary']['TotalWeight']['UOM'])) {
        //     $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($tripOrderDetails['CargoSummary']['TotalWeight']['UOM'], $organizationId, $businessEntityValue['id']);
        //     if (empty($toWeightUOM)) {
        //         return ["status" => 1, "message" => 'Weight UOM not exist for organization: ' . $tripOrderDetails['CargoSummary']['TotalWeight']['UOM']];
        //     }
        // }

        // if (!empty($tripOrderDetails['CargoSummary']['TotalVolume']['UOM'])) {
        //     $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($tripOrderDetails['CargoSummary']['TotalVolume']['UOM'], $organizationId, $businessEntityValue['id']);
        //     if (empty($toVolumeUOM)) {
        //         return ["status" => 1, "message" => 'Volume UOM not exist for organization: ' . $tripOrderDetails['CargoSummary']['TotalVolume']['UOM']];
        //     }
        // }
               if (!empty($tripOrderDetails['OrderCargoSummary'])) {
    $cargoSummaryNode = $tripOrderDetails['OrderCargoSummary'];

    $totalWeightValue = (string) ($cargoSummaryNode['TotalWeight']['Value'] ?? 0);
    $totalWeightUOM   = (string) ($cargoSummaryNode['TotalWeight']['UOM'] ?? '');
    
    $totalVolumeValue = (string) ($cargoSummaryNode['TotalVolume']['Value'] ?? 0);
    $totalVolumeUOM   = (string) ($cargoSummaryNode['TotalVolume']['UOM'] ?? '');
    
    $totalQuantityValue = (string) ($cargoSummaryNode['TotalQuantity']['Value'] ?? 0);
    $totalQuantityUOM   = (string) ($cargoSummaryNode['TotalQuantity']['UOM'] ?? '');

    $cargoSummary = [
        'organizationId'     => $organizationId,
        'businessEntityValue'=> $businessEntityValue,
        'totalWeightValue'   => $totalWeightValue,
        'totalWeightUOM'     => $totalWeightUOM,
        'totalVolumeValue'   => $totalVolumeValue,
        'totalVolumeUOM'     => $totalVolumeUOM,
        'totalQuantityValue' => $totalQuantityValue,
        'totalQuantityUOM'   => $totalQuantityUOM
    ];

    log_message('error', "CargoSummary fetched for TripID {$tripOrderDetails['TripID']} | Organization: {$organizationId} | BusinessEntity: {$businessEntityValue} | Data: " . print_r($cargoSummary, true));
} else {
    log_message('error', "CargoSummary missing for TripID {$tripOrderDetails['TripID']} | Organization: {$organizationId} | BusinessEntity: {$businessEntityValue}");
    return ["status" => 1, "message" => "CargoSummary is empty for TripID {$tripOrderDetails['TripID']}"];
}

        /*if (!empty($tripOrderDetails['CargoDetails'])) {
        if (array_key_exists("0", $tripOrderDetails['CargoDetails']['CargoThuDetails']) === 1) {
        foreach ($tripOrderDetails['CargoDetails']['CargoThuDetails'] as $orderCargo) {
        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderCargo['PackageType'], $organizationId, $businessEntityValue['id']);
        if (empty($toPackage)) {
        return ["status" => 1, "message" => 'Order Outer Package Type not exist for organization: ' . $orderCargo['PackageType']];
        }
        if (!empty($orderCargo['CargoPuDetails'])) {
        if (array_key_exists("0", $orderCargo['CargoPuDetails']) === 1) {
        foreach ($orderCargo['CargoPuDetails'] as $orderInnerCargo) {
        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInnerCargo['PackageType'], $organizationId, $businessEntityValue['id']);
        if (empty($toPackage)) {
        return ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInnerCargo['PackageType']];
        }
        }
        } else {
        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderCargo['CargoPuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
        if (empty($toPackage)) {
        return ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderCargo['CargoPuDetails']['PackageType']];
        }
        }
        }
        }
        } else {
        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($tripOrderDetails['CargoDetails']['CargoThuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
        if (empty($toPackage)) {
        return ["status" => 1, "message" => 'Order Outer Package Type not exist for organization: ' . $tripOrderDetails['CargoDetails']['CargoThuDetails']['PackageType']];
        }
        if (!empty($orderCargo['CargoPuDetails'])) {
        if (array_key_exists("0", $orderCargo['CargoPuDetails']) === 1) {
        foreach ($tripOrderDetails['CargoDetails']['CargoThuDetails']['CargoPuDetails'] as $orderInnerCargo) {
        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($orderInnerCargo['PackageType'], $organizationId, $businessEntityValue['id']);
        if (empty($toPackage)) {
        return ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $orderInnerCargo['PackageType']];
        }
        }
        } else {
        $toPackage = $this->ci->otmshipmentmodel->checkPackageType($tripOrderDetails['CargoDetails']['CargoThuDetails']['CargoPuDetails']['PackageType'], $organizationId, $businessEntityValue['id']);
        if (empty($toPackage)) {
        return ["status" => 1, "message" => 'Order Inner Package Type not exist for organization: ' . $tripOrderDetails['CargoDetails']['CargoThuDetails']['CargoPuDetails']['PackageType']];
        }
        }
        }
        }
        }*/

        if (!empty($tripOrderDetails['InvolvedParties'])) {
            if (array_key_exists("0", $tripOrderDetails['InvolvedParties']['InvolvedParty']) == 1) {
                foreach ($tripOrderDetails['InvolvedParties']['InvolvedParty'] as $party) {
                    $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $organizationId, $businessEntityValue);
                    if (empty($toParty)) {
                        return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $party['PartyType']];
                    }
                }
            } else {
                $toParty = $this->ci->otmshipmentmodel->checkPartyRole($tripOrderDetails['InvolvedParties']['InvolvedParty']['PartyType'], $organizationId, $businessEntityValue);
                if (empty($toParty)) {
                    return ["status" => 1, "message" => 'Party Type not exist for organization: ' . $tripOrderDetails['InvolvedParties']['InvolvedParty']['PartyType']];
                }
            }
        }

        // if (!empty($tripOrderDetails['ManageReferences'])) {
        //     if (array_key_exists("0", $tripOrderDetails['ManageReferences']['Reference']) == 1) {
        //         foreach ($tripOrderDetails['ManageReferences']['Reference'] as $orderRef) {
        //             $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $organizationId, $businessEntityValue);
        //             if (empty($toRefCode)) {
        //                 return ["status" => 1, "message" => 'Reference not exist for organization: ' . $orderRef['RefType']['Code']];
        //             }
        //         }
        //     } else {
        //         $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($tripOrderDetails['ManageReferences']['Reference']['RefType']['Code'], $organizationId, $businessEntityValue);
        //         if (empty($toRefCode)) {
        //             return ["status" => 1, "message" => 'Reference not exist for organization: ' . $tripOrderDetails['ManageReferences']['Reference']['RefType']['Code']];
        //         }
        //     }
        // }
        if (!empty($tripOrderDetails['ManageReferences'])) {

    // Normalize to always work with an array
    $references = array_key_exists("0", $tripOrderDetails['ManageReferences']['Reference']) == 1
        ? $tripOrderDetails['ManageReferences']['Reference']
        : [$tripOrderDetails['ManageReferences']['Reference']];

    foreach ($references as $orderRef) {
        $refCode = $orderRef['RefType']['Code'];

        // Here you can check dynamically (e.g., against XML or any array you already have)
        // For demonstration, we just consider non-empty codes as valid
        if (!empty($refCode)) {
            log_message('error', "Reference VALID: {$refCode} for Organization: {$organizationId}, Entity: {$businessEntityValue}");
        } else {
            log_message('error', "Reference INVALID: {$refCode} for Organization: {$organizationId}, Entity: {$businessEntityValue}");
        }
    }
}


        if (!empty($tripOrderDetails['Remarks'])) {
            if (array_key_exists("0", $tripOrderDetails['Remarks']['RemarkType']) == 1) {
                foreach ($tripOrderDetails['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $organizationId, $businessEntityValue['id']);
                    if (empty($toRemarkCode)) {
                        return ["status" => 1, "message" => 'Remark not exist for organization: ' . $orderRem['Code']];
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($tripOrderDetails['Remarks']['RemarkType']['Code'], $organizationId, $businessEntityValue['id']);
                if (empty($toRemarkCode)) {
                    return ["status" => 1, "message" => 'Remark not exist for organization: ' . $tripOrderDetails['Remarks']['RemarkType']['Code']];
                }
            }
        }
        $tripId = (empty($tripHeader['TripID']) ? "0" : $tripHeader['TripID']);
        if ($tripId === 0) {
            return ["status" => 1, "message" => 'Trip ID is Empty'];
        }

        $tripData = [
            'TripHeader' => $tripHeader,
            'TripOrderDetails' => $tripOrderDetails,
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue,
            // 'businessEntityID' => $businessEntityValue['entity_id'],
            'domain' => $domain,
            'elogheader' => $elogHeader,
            'organization' => $organization,
            'businessEntity' => $businessEntity,
        ];
        return ["status" => 0, "data" => $tripData];
    }

    public function saveTripDetails(array $orderData): string
    {
        $cdate = date('Y-m-d H:i:s');
       $tripId = isset($orderData['TripHeader']['TripID']) && !is_array($orderData['TripHeader']['TripID'])
    ? $orderData['TripHeader']['TripID']
    : null;

// Log for debugging
log_message('error', 'TripID extracted at start of saveTripDetails: ' . ($tripId ?? 'NULL'));

// Pass $tripId directly to orderdetails()
if (array_key_exists("0", $orderData['TripOrderDetails']) == 1) {
    foreach ($orderData['TripOrderDetails'] as $orderDetail) {
        $bookingIDs[] = $this->orderdetails(
            $orderDetail,
            $orderData['organizationId'],
            $orderData['businessEntityValue'],
            $orderData['businessEntityID'],
            $orderData['organization'],
            $orderData['businessEntity'],
            $orderData['domain'],
            $orderData['TripHeader'],
            $tripId // ✅ keep the XML TripID
        );
    }
} else {
    $bookingIDs[] = $this->orderdetails(
        $orderData['TripOrderDetails'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        $orderData['organization'],
        $orderData['businessEntity'],
        $orderData['domain'],
        $orderData['TripHeader'],
        $tripId // ✅ keep the XML TripID
    );
}

        $carrier_id = 0;
        $user_id = isset($orderData['user_id']) ? (int) $orderData['user_id'] : 0;
        if (!empty($orderData['TripHeader']['CarrierDetails'])) {
            $carrier_id = $this->ci->standardbookinghandler->checkPartyDetails(
                $orderData['TripHeader']['CarrierDetails'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $user_id,
                $orderData['domain'],
               'CARRIER',
                $orderData['organization'],
                $orderData['businessEntity']
            );
           



            /*$carrier_id = $this->getCarrierDetails(
        $orderData['TripHeader']['CarrierDetails'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        $orderData['organization'],
        $orderData['businessEntity']
        );*/
        }
       
    if (!empty($orderData['TripHeader']['VehicleDetails'])) {
       $vehicle_id = $this->getVehicleDetails(
        $orderData['TripHeader']['VehicleDetails'] ?? [],                    // ensure array
        isset($orderData['organizationId']) ? (string) $orderData['organizationId'] : '',  // string
        isset($orderData['businessEntityValue']) ? (string) $orderData['businessEntityValue'] : '', // string
        isset($orderData['businessEntityID']) ? (string) $orderData['businessEntityID'] : '',  // string
        isset($carrier_id) ? (int) $carrier_id : 0                               // int
      );
    }

        /*    if (!empty($orderData['TripHeader']['DriverDetails'])) {
        $driver_id = $this->getDriverDetails(
        $orderData['TripHeader']['DriverDetails'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        $carrier_id,
        $vehicle_id
        );
        }*/

        if (!empty($orderData['TripHeader']['TripLocation']['TripStartLocation'])) {
           $user_id = isset($orderData['user_id']) ? (int) $orderData['user_id'] : 0;

        $startlocationID = $this->ci->standardbookinghandler->checkPartyDetails(
            $orderData['TripHeader']['TripLocation']['TripStartLocation'],
            $orderData['organizationId'],
            $orderData['businessEntityValue'],
            $user_id, 
            'PICKUP'
        );
            $startlocationID = $startlocationID['partyContactID'];
        }
        if (!empty($orderData['TripHeader']['TripLocation']['TripEndLocation'])) {
            $endlocationID = $this->ci->standardbookinghandler->checkPartyDetails(
                $orderData['TripHeader']['TripLocation']['TripEndLocation'],
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $user_id,
                'DELIVERY',
                $orderData['organization'],
                $orderData['businessEntity']
            );
            $endlocationID = $endlocationID['partyContactID'];
        }

        /*if (!empty($orderData['TripHeader']['TripLocation']['TripStartLocation'])) {
        $startlocationID = $this->getLocationDetails(
        $orderData['TripHeader']['TripLocation']['TripStartLocation']['Address'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID'],
        ''
        );
        }
        if (!empty($orderData['TripHeader']['TripLocation']['TripEndLocation'])) {
        $endlocationID = $this->getLocationDetails(
        $orderData['TripHeader']['TripLocation']['TripEndLocation']['Address'],
        $orderData['organizationId'],
        $orderData['businessEntityValue'],
        $orderData['businessEntityID']
        );
        }*/

        // $tripId = is_array($orderData['TripHeader']['TripID']) ? "0" : $orderData['TripHeader']['TripID'];
        // $checkTrip = $this->ci->common->gettblrowdata(
        //     ["external_trip_id" => $tripId, 'status' => 1],
        //     "trip_id",
        //     "tb_trips",
        //     0,
        //     0
        // );
         $tripId = is_array($orderData['TripHeader']['TripID']) ? "0" : $orderData['TripHeader']['TripID'];
        $checkTrip = $this->ci->common->gettblrowdata(
            ["external_trip_id" => $tripId, 'status' => 1],
            "id",
            "tb_trips",
            0,
            0
        );

        $tripType = $orderData['TripHeader']['TripType'] ?? "";
        if (!empty($tripType)) {
            $destinationTripType = $this->ci->otmshipmentmodel->checkOrderTypeCrossRef($orderData['TripHeader']['TripType'], $orderData['organizationId'],
                $orderData['businessEntityValue']);
            if (!empty($destinationTripType)) {
                $tripType = $this->ci->otmbookingmodel->checkOrderType(
                    $destinationTripType,
                    $orderData['organizationId'],
                    $orderData['businessEntityID'],
                    $orderData['businessEntityValue']
                );
            }
        }
        $modeOfTransport = $orderData['TripHeader']['ModeOfTransport'] ?? "";
        if (!empty($modeOfTransport)) {
            $destinationModeOfTransport = $this->ci->otmshipmentmodel->checkModeOfTransportCrossRef($orderData['TripHeader']['ModeOfTransport'], $orderData['organizationId'],
                $orderData['businessEntityValue']);
            if (!empty($destinationModeOfTransport)) {
                $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
                    $destinationModeOfTransport,
                    $orderData['organizationId'],
                    $orderData['businessEntityID'],
                    $orderData['businessEntityValue']
                );
            }
        }

        /*$tripType = (empty($orderData['TripHeader']['TripType']) ? "0" : $orderData['TripHeader']['TripType']);
        if ($tripType > 0) {
        $tripType = $this->ci->otmbookingmodel->checkOrderType(
        $orderData['TripHeader']['TripType'],
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }

        $modeOfTransport = $orderData['TripHeader']['ModeOfTransport'];
        if (!empty($modeOfTransport)) {
        $modeOfTransport = $this->ci->otmbookingmodel->checkModeOfTransport(
        $modeOfTransport,
        $orderData['organizationId'],
        $orderData['businessEntityID'],
        $orderData['businessEntityValue']
        );
        }*/
        $pickup_start_date = str_replace(
            "T",
            " ",
            is_array(
                $orderData['TripHeader']['TripDates']['StartDate']['DateTime']
            ) ? "" : $orderData['TripHeader']['TripDates']['StartDate']['DateTime']
        );
        $delivery_start_date = str_replace(
            "T",
            " ",
            is_array(
                $orderData['TripHeader']['TripDates']['EndDate']['DateTime']
            ) ? "" : $orderData['TripHeader']['TripDates']['EndDate']['DateTime']
        );

        $totalWeightUomCode = $totalVolumeUomCode = "";

        // if (!empty($orderData['TripHeader']['CargoSummary']['TotalWeight']['UOM'])) {
        //     $toWeightUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['TripHeader']['CargoSummary']['TotalWeight']['UOM'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //     if (!empty($toWeightUOM)) {
        //         $totalWeightUomCode = $this->ci->otmshipmentmodel->getUOMId($toWeightUOM);
        //     }
        // }
        // if (!empty($orderData['TripHeader']['CargoSummary']['TotalVolume']['UOM'])) {
        //     $toVolumeUOM = $this->ci->otmshipmentmodel->checkUOM($orderData['TripHeader']['CargoSummary']['TotalVolume']['UOM'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //     if (!empty($toVolumeUOM)) {
        //         $totalVolumeUomCode = $this->ci->otmshipmentmodel->getUOMId($toVolumeUOM);
        //     }
        // }
          if (!empty($orderData['TripHeader']['CargoSummary'])) {
    $cargoSummaryNode = $orderData['TripHeader']['CargoSummary'];

    // Extract values safely
    $totalWeightValue   = (string) ($cargoSummaryNode['TotalWeight']['Value'] ?? 0);
    $totalWeightUOM     = (string) ($cargoSummaryNode['TotalWeight']['UOM'] ?? '');

    $totalVolumeValue   = (string) ($cargoSummaryNode['TotalVolume']['Value'] ?? 0);
    $totalVolumeUOM     = (string) ($cargoSummaryNode['TotalVolume']['UOM'] ?? '');

    $totalQuantityValue = (string) ($cargoSummaryNode['TotalQuantity']['Value'] ?? 0);
    $totalQuantityUOM   = (string) ($cargoSummaryNode['TotalQuantity']['UOM'] ?? '');

    // Build CargoSummary array
    $cargoSummary = [
        'organizationId'      => $orderData['organizationId'] ?? '',
        'businessEntityValue' => $orderData['businessEntityValue'] ?? '',
        'totalWeightValue'    => $totalWeightValue,
        'totalWeightUOM'      => $totalWeightUOM,
        'totalVolumeValue'    => $totalVolumeValue,
        'totalVolumeUOM'      => $totalVolumeUOM,
        'totalQuantityValue'  => $totalQuantityValue,
        'totalQuantityUOM'    => $totalQuantityUOM
    ];

    // TripID may be missing; use null coalescing
    $tripID = $TripHeader['TripID'] ?? '';

    // Log CargoSummary
    log_message(
        'error',
        "CargoSummary fetched for TripID {$tripID} | Organization: {$cargoSummary['organizationId']} | BusinessEntity: {$cargoSummary['businessEntityValue']} | Data: " . print_r($cargoSummary, true)
    );

} else {
    // TripID may be missing; use null coalescing
    $tripID = $TripHeader['TripID'] ?? '';

    // Log missing CargoSummary
    log_message(
        'error',
        "CargoSummary missing for TripID {$tripID} | Organization: {$orderData['organizationId']} | BusinessEntity: {$orderData['businessEntityValue']}"
    );

   return json_encode([
    "status"  => 1,
    "message" => "CargoSummary is empty for TripID: {$tripID}"
]);

}

$startlocationID = isset($orderData['TripHeader']['TripLocation']['TripStartLocation']['ID'])
    ? (string) $orderData['TripHeader']['TripLocation']['TripStartLocation']['ID']
    : null;

// Safely get Trip End Location ID
$endlocationID = isset($orderData['TripHeader']['TripLocation']['TripEndLocation']['ID'])
    ? (string) $orderData['TripHeader']['TripLocation']['TripEndLocation']['ID']
    : null;

// Log to verify
log_message('error', "Trip Processing Started222| ExternalTripID: {$tripId} | StartPlace: {$startlocationID} | EndPlace: {$endlocationID}");


$tripType        = empty($tripType) ? 0 : $tripType;
$modeOfTransport = empty($modeOfTransport) ? 0 : $modeOfTransport;

// TripID from XML
$tripId = is_array($orderData['TripHeader']['TripID']) ? "0" : $orderData['TripHeader']['TripID'];

// Start log
log_message('error', "Trip Processing Started | ExternalTripID: {$tripId} | StartPlace: {$startlocationID} | EndPlace: {$endlocationID}");
 $startlocationNode = $orderData['TripHeader']['TripLocation']['TripStartLocation'] ?? [];
$endlocationNode   = $orderData['TripHeader']['TripLocation']['TripEndLocation'] ?? [];

// Extract latitude/longitude safely
$plat = $startlocationNode['Address']['Latitude']  ?? null;
$plng = $startlocationNode['Address']['Longitude'] ?? null;

$dlat   = $endlocationNode['Address']['Latitude']  ?? null;
$dlng   = $endlocationNode['Address']['Longitude'] ?? null;

$tripDetails = [
    'trip_type'        => $tripType,
    'splace'           => $startlocationID,
    'eplace'           => $endlocationID,
    'stime'            => $pickup_start_date,
    'etime'            => $delivery_start_date,
    'vehicle_id'       => $vehicle_id,
    'external_trip_id' => $tripId,
    'updated_on'       => date('Y-m-d H:i:s'),
     'plat'            => $plat,
    'plng'            => $plng,
    'dlat'            => $dlat,
    'dlng'            => $dlng,

];

if (!empty($checkTrip)) {
    // update
    $tripInternalID = $checkTrip['id'];
    $this->ci->common->updatetbledata("tb_trips", $tripDetails, ['id' => $tripInternalID]);

    $shipment_gid = "SVK" . date('y') . date('m') . date('W') . date('d') . date('s') . $tripInternalID;

    log_message('error', "Trip Updated | ID: {$tripInternalID}, ExternalTripID: {$tripId}, ShipmentGID: {$shipment_gid}, SPlace: {$startlocationID}, EPlace: {$endlocationID}");

} else {
    // insert
    $tripInternalID = $this->ci->common->insertTableData('tb_trips', $tripDetails);

    $shipment_gid = "SVK" . date('y') . date('m') . date('W') . date('d') . date('s') . $tripInternalID;

    $this->ci->common->updatetbledata(
        "tb_trips", 
        [
            'splace'           => $startlocationID,
            'eplace'           => $endlocationID,
            'stime'            => $pickup_start_date,
            'etime'            => $delivery_start_date,
            'external_trip_id' => $tripId,
           
        ], 
        ['id' => $tripInternalID]
    );

    log_message('error', "Trip Inserted | ID: {$tripInternalID}, ExternalTripID: {$tripId}, ShipmentGID: {$shipment_gid}, SPlace: {$startlocationID}, EPlace: {$endlocationID}");
}
$cdate = date('Y-m-d H:i:s');

  $modeOfTransport = $orderData['TripHeader']['ModeOfTransport'] ?? "";
   $startlocationNode = $orderData['TripHeader']['TripLocation']['TripStartLocation'] ?? [];
$endlocationNode   = $orderData['TripHeader']['TripLocation']['TripEndLocation'] ?? [];

// Extract latitude/longitude safely
$plat = $startlocationNode['Address']['Latitude']  ?? null;
$plng = $startlocationNode['Address']['Longitude'] ?? null;

$dlat   = $endlocationNode['Address']['Latitude']  ?? null;
$dlng   = $endlocationNode['Address']['Longitude'] ?? null;

// Optional: city, address, postal code
$startCity  = $startlocationNode['Address']['City'] ?? null;
$endCity    = $endlocationNode['Address']['City'] ?? null;
$company_code    = $orderData['company_code'];
        $branch_code     = $orderData['branch_code'];
$company_code = $company_code ?? '';
        $branch_code  = $branch_code ?? '';
         $firstTwoChars = $firstTwoChars ?? '';
 $user_id = $this->ci->Standardbookingmodel->checkUser($company_code, $branch_code, $firstTwoChars);

$shiftData = [
    
    'user_id'         => $user_id ?? 0,
    'stime'           => $pickup_start_date ?? null,
    'etime'           => $delivery_start_date ?? null,
    'splace'          => $startlocationID ?? null,
    'eplace'          => $endlocationID ?? null,
    'scity'           => $startCity,
    'dcity'           => $endCity ,
    'zone_id'         => $orderData['zone_id'] ?? 0,
    'trip_type'       => $tripType ?? 0,
    'startdate'       => $pickup_start_date ?? null,
    'enddate'         => $delivery_start_date ?? null,
    'shipment_name'   => $orderData['TripHeader']['ShipmentName'] ?? '',
    'shipmentid'      => $tripId,  // link to tb_trips
    'customer_id'     => $orderData['customer_id'] ?? 0,
    'transport_mode'  => $modeOfTransport ,
    'company_code'    => $orderData['company_code'] ?? '',
    'branch_code'     => $orderData['branch_code'] ?? '',
    'domainname'      => $orderData['domainname'] ?? '',
     'txnid'          => $tripId,
    'status'          => 1,
    'created_on'      => $cdate,
    'slat'            => $plat,
    'slng'            => $plng,
    'elat'            => $dlat,
    'elng'            => $dlng,
   
           
    
];

$this->ci->db->insert('tb_shifts', $shiftData);
$shift_id = $this->ci->db->insert_id();
log_message('error', 'Last Query: ' . $this->ci->db->last_query());
log_message('error', 'DB Error: ' . print_r($this->ci->db->error(), true));

// log for verification
log_message('error', "Shift Inserted for TripID {$tripInternalID} | Start: {$startlocationID} | End: {$endlocationID}");

$this->ci->common->updatetbledata(
    "tb_trips", 
    [
        'splace'           => $startlocationID,
        'eplace'           => $endlocationID,
        'stime'            => $pickup_start_date,
        'etime'            => $delivery_start_date,
        'external_trip_id' => $tripId,
        'shift_id'         => $shift_id, // Now this exists
    ], 
    ['id' => $tripInternalID]
);


        // if (!empty($orderData['TripHeader']['BusinessParties'])) {
        //     if (array_key_exists("0", $orderData['TripHeader']['BusinessParties']['BusinessParty']) == 1) {
        //         foreach ($orderData['TripHeader']['BusinessParties']['BusinessParty'] as $party) {
        //             $toParty = $this->ci->otmshipmentmodel->checkPartyRole($party['PartyType'], $orderData['organizationId'],
        //                 $orderData['businessEntityValue']);
        //             $partyInfo = $this->ci->standardbookinghandler->checkPartyDetails(
        //                 $party,
        //                 $orderData['organizationId'],
        //                 $orderData['businessEntityValue'],
        //                 $user_id,
        //                 strtoupper($toParty),
        //                 $orderData['organization'],
        //                 $orderData['businessEntity']
        //             );
        //             $tripParty = [
        //                 'trip_id' => $tripInternalID,
        //                 'involved_party_contact_gid' => $partyInfo['partyContactID'],
        //                 'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //                 'organization_id' => $orderData['organizationId'],
        //                 'bisiness_entity_id' => $orderData['businessEntityValue'],
        //             ];
        //             $updateTripParty = [
        //                 'trip_id' => $tripInternalID,
        //                 'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //                 'organization_id' => $orderData['organizationId'],
        //                 'bisiness_entity_id' => $orderData['businessEntityValue'],
        //             ];
        //             $tripInvolvedPartiesInfo = $this->ci->common->gettblrowdata($tripParty, "trip_involved_party_id", "tb_trips_involved_parties", 0, 0);
        //             if (empty($tripInvolvedPartiesInfo)) {
        //                 $this->ci->common->insertTableData('tb_trips_involved_parties', $tripParty);
        //             } else {
        //                 $this->ci->db->where($updateTripParty)->update("tb_trips_involved_parties", $tripParty);
        //             }
        //         }
        //     } else {
        //         $toParty = $this->ci->otmshipmentmodel->checkPartyRole($orderData['TripHeader']['BusinessParties']['BusinessParty']['PartyType'], $orderData['organizationId'],
        //             $orderData['businessEntityValue']);
        //         $partyInfo = $this->ci->standardbookinghandler->checkPartyDetails(
        //             $orderData['TripHeader']['BusinessParties']['BusinessParty'],
        //             $orderData['organizationId'],
        //             $orderData['businessEntityValue'],
        //             $carrier_id,
        //             strtoupper($toParty),
        //             $orderData['organization'],
        //             $orderData['businessEntity']
        //         );
        //         $tripParty = [
        //             'trip_id' => $tripInternalID,
        //             'involved_party_contact_gid' => $partyInfo['partyContactID'],
        //             'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //             'organization_id' => $orderData['organizationId'],
        //             'bisiness_entity_id' => $orderData['businessEntityValue'],
        //         ];
        //         $updateTripParty = [
        //             'trip_id' => $tripInternalID,
        //             'involved_party_qual_gid' => $partyInfo['party_type_id'],
        //             'organization_id' => $orderData['organizationId'],
        //             'bisiness_entity_id' => $orderData['businessEntityValue'],
        //         ];
        //         $tripInvolvedPartiesInfo = $this->ci->common->gettblrowdata($tripParty, "trip_involved_party_id", "tb_trips_involved_parties", 0, 0);
        //         if (empty($tripInvolvedPartiesInfo)) {
        //             $this->ci->common->insertTableData('tb_trips_involved_parties', $tripParty);
        //         } else {
        //             $this->ci->db->where($updateTripParty)->update("tb_trips_involved_parties", $tripParty);
        //         }
        //     }
        // }

        // if (!empty($orderData['TripHeader']['ManageReferences'])) {
        //     if (array_key_exists("0", $orderData['TripHeader']['ManageReferences']['Reference']) == 1) {
        //         foreach ($orderData['TripHeader']['ManageReferences']['Reference'] as $orderRef) {
        //             $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderRef['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //             if (!empty($toRefCode)) {
        //                 $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
        //                 $orderRef['RefType']['Code'] = $referenceId;
        //                 $this->ci->otmshipmentmodel->insertTripReferences($tripInternalID, $orderRef, $orderData['organizationId'], $orderData['businessEntityValue']);
        //             }
        //         }
        //     } else {
        //         $toRefCode = $this->ci->otmshipmentmodel->checkCrossReferences($orderData['TripHeader']['ManageReferences']['Reference']['RefType']['Code'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //         if (!empty($toRefCode)) {
        //             $referenceId = $this->ci->otmshipmentmodel->getReferenceId($toRefCode);
        //             $orderData['manageReferences']['Reference']['RefType']['Code'] = $referenceId;
        //             $this->ci->otmshipmentmodel->insertTripReferences($tripInternalID, $orderData['TripHeader']['ManageReferences']['Reference'], $orderData['organizationId'], $orderData['businessEntityValue']);
        //         }
        //     }
        // }
          if (!empty($orderData['TripHeader']['ManageReferences'])) {

    // Convert single reference to array for uniform processing
    $references = array_key_exists("0", $orderData['TripHeader']['ManageReferences']['Reference']) == 1
        ? $orderData['TripHeader']['ManageReferences']['Reference']
        : [$orderData['TripHeader']['ManageReferences']['Reference']];

    // Collect all reference codes from the XML itself
    $allReferenceCodes = [];
    foreach ($orderData['TripHeader']['ManageReferences']['Reference'] as $orderRef) {
        $allReferenceCodes[] = $orderRef['RefType']['Code'];
    }

    foreach ($references as $orderRef) {
        $refCode = $orderRef['RefType']['Code'];

        if (in_array($refCode, $allReferenceCodes)) {
            log_message('error', "Reference VALID22: {$refCode} for Organization: {$orderData['organizationId']}, Entity: {$orderData['businessEntityValue']}");
        } else {
            log_message('error', "Reference INVALID22: {$refCode} for Organization: {$orderData['organizationId']}, Entity: {$orderData['businessEntityValue']}");
        }
    }
}


        if (!empty($orderData['TripHeader']['Remarks'])) {
            if (array_key_exists("0", $orderData['TripHeader']['Remarks']['RemarkType']) == 1) {
                foreach ($orderData['TripHeader']['Remarks']['RemarkType'] as $orderRem) {
                    $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderRem['Code'], $orderData['organizationId'],
                        $orderData['businessEntityValue']);
                    if (!empty($toRemarkCode)) {
                        $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                        $orderRem['RemarkType']['Code'] = $remarkId;
                        $this->ci->otmshipmentmodel->insertTripRemarks($tripInternalID, $orderRem, $orderData['organizationId'], $orderData['businessEntityValue']);
                    }
                }
            } else {
                $toRemarkCode = $this->ci->otmshipmentmodel->checkCrossRemarks($orderData['TripHeader']['Remarks']['RemarkType']['Code'], $orderData['organizationId'],
                    $orderData['businessEntityValue']);
                if (!empty($toRemarkCode)) {
                    $remarkId = $this->ci->otmshipmentmodel->getRemarkId($toRemarkCode);
                    $orderData['TripHeader']['Remarks']['RemarkType']['Code'] = $remarkId;
                    $this->ci->otmshipmentmodel->insertTripRemarks($tripInternalID, $orderData['TripHeader']['Remarks'], $orderData['organizationId'], $orderData['businessEntityValue']);
                }
            }
        }

        //$endlocationID = empty($endlocationID) ? 0 : $endlocationID;
        if (!empty($orderData['TripHeader']['TripStops'])) {
            foreach ($orderData['TripHeader']['TripStops']['TripStop'] as $tripStop) {
               $this->insertTripStopsDetails(
    $tripStop,
    isset($orderData['organizationId']) ? (string)$orderData['organizationId'] : '',
    isset($orderData['businessEntityValue']) ? (string)$orderData['businessEntityValue'] : '',
    isset($orderData['businessEntityID']) ? (string)$orderData['businessEntityID'] : '',
    (int)$tripInternalID,
    (int)$startlocationID,
    (int)$endlocationID,
    'NEW',
    isset($orderData['organization']) ? (string)$orderData['organization'] : '',
    isset($orderData['businessEntity']) ? (string)$orderData['businessEntity'] : ''
);
            }
        }

        if (!empty($bookingIDs)) {
    foreach ($bookingIDs as $orders) {
        $orderinfo = $this->ci->common->gettblrowdata(
            ['order_id' => $orders],
            "id",
            "tb_orders",
            0,
            0
        );

        if (!empty($orderinfo)) {
            // Log: Order fetched
            log_message('error', "Order fetched | OrderID: {$orders} | DB ID: {$orderinfo['id']}");

            // Link tb_orders to tb_trips
            $this->ci->common->updatetbledata(
                "tb_orders",
                 ['shift_id' => $shift_id],
                ['trip_id' => $tripInternalID],
                ['id' => $orderinfo['id']]
            );
            log_message('error', "tb_orders updated with trip_id | OrderID: {$orderinfo['id']} | TripID: {$tripInternalID}");

            $tripOrders = [
                'trip_id'  => $tripInternalID,
                'order_id' => $orderinfo['id'],
            ];

            $orderinfo1 = $this->ci->common->gettblrowdata($tripOrders, "trip_id", "tb_stop_status", 0, 0);
            if (empty($orderinfo1)) {
                $this->ci->common->insertTableData('tb_stop_status', $tripOrders);
                log_message('error', "tb_stop_status inserted | OrderID: {$orderinfo['id']} | TripID: {$tripInternalID}");
            } else {
                log_message('error', "tb_stop_status already exists | OrderID: {$orderinfo['id']} | TripID: {$tripInternalID}");
            }

            $this->ci->standardtriphandler->insertOrderAcknowledgementStatus(
                $tripInternalID,
                $orders,
                $orderData['organizationId'],
                $orderData['businessEntityValue']
            );
            log_message('error', "Order Acknowledgement inserted | OrderID: {$orders} | TripID: {$tripInternalID}");

            $this->ci->common->updatetbledata(
                "tb_orders",
                ['order_status' => 1],
                ['id' => $orderinfo['id'], 'order_id' => $orders]
            );
            log_message('error', "tb_orders order_status updated | OrderID: {$orderinfo['id']}");

            $this->ci->common->updatetbledata(
                "tb_stop_status",
                ['order_id' => $orderinfo['id']],
                ['trip_id' => $tripInternalID]
            );
            log_message('error', "tb_stop_status order_id updated | OrderID: {$orderinfo['id']} | TripID: {$tripInternalID}");
        } 
    }
} 


        /*$userId = $this->ci->otmbookingmodel->getUserId('Integration');
        $TripDrivers = [
        'trip_id' => $tripInternalID,
        'vehicle_id' => $vehicle_id,
        'carrier_id' => $carrier_id,
        'driver_id' => $driver_id,
        'status' => 1,
        'user_id' => $userId
        ];
        $tripDriversInfo = $this->ci->common->gettblrowdata($TripDrivers, "id", "tb_trip_assigned_drivers", 0, 0);
        if (empty($tripDriversInfo)) {
        $this->ci->common->insertTableData('tb_trip_assigned_drivers', $TripDrivers);
        }*/
        return $shipment_gid;
    }

    private function insertReferenceInfo(int $tripInternalID, array $orderData, string $toRefCode, array $orderRef): array
    {
        $refId = $this->ci->otmbookingmodel->checkRefMaster($orderRef['RefType']['Code']);
        if ($refId > 0) {
            $orderRef['RefType']['Code'] = $refId;
            $this->ci->otmshipmentmodel->insertTripReferences(
                $tripInternalID,
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderRef
            );
        }
        return $orderRef;
    }

    private function insertRemarkInfo(int $tripInternalID, array $orderData, string $toRemarkCode, array $orderRem): array
    {
        $remId = $this->ci->otmbookingmodel->checkRemMaster($orderRem['RemarkType']['Code']);
        if ($remId > 0) {
            $orderRem['RemarkType']['Code'] = $remId;
            $this->ci->otmshipmentmodel->insertTripRemarks(
                $tripInternalID,
                $orderData['organizationId'],
                $orderData['businessEntityValue'],
                $orderRem
            );
        }
        return $orderRem;
    }

    public function insertTripStopsDetails(
        array $tripStop,
        string $organizationId,
        string $businessEntityValue,
        string $businessEntityID,
        int $tripId,
        int $startlocationID,
        int $endlocationID,
        string $type,
        string $organization,
        string $businessEntity
    ): void {
        if ($type == 'NEW') {
            $sequence = $tripStop['StopSequence'];
            $stopType = $tripStop['StopType'];
            $locationRoleId = 0;
            if ($stopType == "P") {
                $partyType = "PICKUP";
                $locationRoleId = "1";
            }
            if ($stopType == "D") {
                $partyType = "DELIVERY";
                $locationRoleId = "2";
            }
            $locationId = $this->ci->standardbookinghandler->checkPartyDetails(
                $tripStop['Address'],
                $organizationId,
                $businessEntityValue,
                0,
                $partyType,
                $organization,
                $businessEntity
            );
            $locationId = $locationId['partyContactID'];
        }

        if (!empty($tripStop['TripStopDetail'])) {
            if (array_key_exists("0", $tripStop['TripStopDetail']) == 1) {
                foreach ($tripStop['TripStopDetail'] as $tripStopDetail) {
                    $tripStopsInfo = [
                        'trip_id' => $tripId,
                        'stop_detail_id' => is_array($sequence) ? "" : $sequence,
                        'location_gid' => empty($locationId) ? "0" : $locationId,
                        'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                        'planned_arrival' => is_array($tripStop['ArrivalTime']['PlannedTime']) ? "" : $tripStop['ArrivalTime']['PlannedTime'],
                        'estimated_arrival' => is_array($tripStop['ArrivalTime']['EstimatedTime']) ? "" : $tripStop['ArrivalTime']['EstimatedTime'],
                        'planned_departure' => is_array($tripStop['DepartureTime']['PlannedTime']) ? "" : $tripStop['DepartureTime']['PlannedTime'],
                        'estimated_departure' => is_array($tripStop['DepartureTime']['EstimatedTime']) ? "" : $tripStop['DepartureTime']['EstimatedTime'],
                        'dist_from_prev_stop' => is_array($tripStop['DistFromPrevStop']['DistanceValue']) ? "" : $tripStop['DistFromPrevStop']['DistanceValue'],
                        'dist_from_prev_stop_uom_code' => is_array($tripStop['DistFromPrevStop']['DistanceUOMGid']) ? "" : $tripStop['DistFromPrevStop']['DistanceUOMGid'],
                        'activity_time_base' => empty($tripStopDetail['ActivityBase']) ? "" : $tripStopDetail['ActivityBase'],
                        'activity_time' => empty($tripStopDetail['DurationValue']) ? "" : $tripStopDetail['DurationValue'],
                        'activity_time_uom_code' => empty($tripStopDetail['DurationUOMGid']) ? "" : $tripStopDetail['DurationUOMGid'],
                        'ship_unit_id' => empty($tripStopDetail['ShipUnitId']) ? "" : $tripStopDetail['ShipUnitId'],
                        'stop_type' => is_array($tripStop['StopType']) ? empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'] : $tripStop['StopType'],
                        'is_permanent' => is_array($tripStop['IsPermanent'] == 'N') ? 1 : 0,
                        'is_depot' => is_array($tripStop['IsDepot'] == 'N') ? 1 : 0,
                        'accessorial_time' => is_array($tripStop['AccessorialTime']['DurationValue']) ? "" : $tripStop['AccessorialTime']['DurationValue'],
                        'accessorial_time_uom_code' => is_array($tripStop['AccessorialTime']['DurationUOMGid']) ? "" : $tripStop['AccessorialTime']['DurationUOMGid'],
                        'rush_hour_time' => is_array($tripStop['RushHourTime']['DurationValue']) ? "" : $tripStop['RushHourTime']['DurationValue'],
                        'rush_hour_time_uom_code' => is_array($tripStop['RushHourTime']['DurationUOMGid']) ? "" : $tripStop['RushHourTime']['DurationUOMGid'],
                        'is_mother_vessel' => is_array($tripStop['IsMotherVessel']) ? "" : $tripStop['IsMotherVessel'],
                        'organization_id' => $organizationId,
                        'entity_value_id' => $businessEntityValue,
                        'status' => 1,
                    ];

                    $shipUnitId = empty($tripStopDetail['ShipUnitId']) ? "" : $tripStopDetail['ShipUnitId'];

                    $checkTripStops = [
                        'trip_id' => $tripId,
                        'stop_detail_id' => $sequence,
                        // 'ship_unit_id' => $shipUnitId,
                        'location_gid' => empty($locationId) ? "0" : $locationId,
                        'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                        // 'organization_id' => $organizationId,
                        // 'entity_value_id' => $businessEntityValue,
                    ];

                    $checkStopLocation = $this->ci->common->gettblrowdata(
                        $checkTripStops,
                        "stop_id",
                        "tb_stop_status",
                        0,
                        0
                    );

                    if (empty($checkStopLocation)) {
                        $stop_id = $this->ci->common->insertTableData('tb_stop_status', $tripStopsInfo);
                    } else {
                        $stop_id = $checkStopLocation['stop_id'];
                        $this->ci->common->updatetbledata(
                            "tb_stop_status",
                            $tripStopsInfo,
                            ['stop_id' => $stop_id, 
                            // 'ship_unit_id' => $shipUnitId
                            ]
                        );
                    }
                }
            } else {
                // $tripStopsInfo = [
                //     'trip_id' => $tripId,
                //     'stop_detail_id' => is_array($sequence) ? "" : $sequence,
                //     'location_gid' => empty($locationId) ? "0" : $locationId,
                //     'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                //     'planned_arrival' => is_array($tripStop['ArrivalTime']['PlannedTime']) ? "" : $tripStop['ArrivalTime']['PlannedTime'],
                //     'estimated_arrival' => is_array($tripStop['ArrivalTime']['EstimatedTime']) ? "" : $tripStop['ArrivalTime']['EstimatedTime'],
                //     'planned_departure' => is_array($tripStop['DepartureTime']['PlannedTime']) ? "" : $tripStop['DepartureTime']['PlannedTime'],
                //     'estimated_departure' => is_array($tripStop['DepartureTime']['EstimatedTime']) ? "" : $tripStop['DepartureTime']['EstimatedTime'],
                //     'dist_from_prev_stop' => is_array($tripStop['DistFromPrevStop']['DistanceValue']) ? "" : $tripStop['DistFromPrevStop']['DistanceValue'],
                //     'dist_from_prev_stop_uom_code' => is_array($tripStop['DistFromPrevStop']['DistanceUOMGid']) ? "" : $tripStop['DistFromPrevStop']['DistanceUOMGid'],
                //     'activity_time_base' => empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'],
                //     'activity_time' => empty($tripStop['TripStopDetail']['DurationValue']) ? "" : $tripStop['TripStopDetail']['DurationValue'],
                //     'activity_time_uom_code' => empty($tripStop['TripStopDetail']['DurationUOMGid']) ? "" : $tripStop['TripStopDetail']['DurationUOMGid'],
                //     'ship_unit_id' => empty($tripStop['TripStopDetail']['ShipUnitId']) ? "" : $tripStop['TripStopDetail']['ShipUnitId'],
                //     'stop_type' => is_array($tripStop['StopType']) ? empty($tripStop['TripStopDetail']['ActivityBase']) ? "" : $tripStop['TripStopDetail']['ActivityBase'] : $tripStop['StopType'],
                //     'is_permanent' => is_array($tripStop['IsPermanent'] == 'N') ? 1 : 0,
                //     'is_depot' => is_array($tripStop['IsDepot'] == 'N') ? 1 : 0,
                //     'accessorial_time' => is_array($tripStop['AccessorialTime']['DurationValue']) ? "" : $tripStop['AccessorialTime']['DurationValue'],
                //     'accessorial_time_uom_code' => is_array($tripStop['AccessorialTime']['DurationUOMGid']) ? "" : $tripStop['AccessorialTime']['DurationUOMGid'],
                //     'rush_hour_time' => is_array($tripStop['RushHourTime']['DurationValue']) ? "" : $tripStop['RushHourTime']['DurationValue'],
                //     'rush_hour_time_uom_code' => is_array($tripStop['RushHourTime']['DurationUOMGid']) ? "" : $tripStop['RushHourTime']['DurationUOMGid'],
                //     'is_mother_vessel' => is_array($tripStop['IsMotherVessel']) ? "" : $tripStop['IsMotherVessel'],
                //     'organization_id' => $organizationId,
                //     'entity_value_id' => $businessEntityValue,
                //     'status' => 1,
                // ];
             $tripStopsInfo = [
    'shipment_id'       => $shipmentId ?? 0,
    'stopnumber'        => $tripStop['StopSequence'] ?? 0,
    'stopduration'      => is_array($tripStop['TripStopDetail']['DurationValue']) 
                           ? '' : ($tripStop['TripStopDetail']['DurationValue'] ?? ''),
    'location'          => $tripStop['Address']['CompanyName'] ?? '',
    'stopcustomer'      => $tripStop['Address']['City'] ?? '',
    'distfrmprevious'   => is_array($tripStop['DistFromPrevStop']) 
                           ? ($tripStop['DistFromPrevStop']['DistanceValue'] ?? '') 
                           : ($tripStop['DistFromPrevStop'] ?? ''),
    'pickupplanned'     => $tripStop['ArrivalTime']['PlannedTime'] ?? null,
    'pickupestimate'    => $tripStop['ArrivalTime']['EstimatedTime'] ?? null,
    'deliveryplan'      => $tripStop['DepartureTime']['PlannedTime'] ?? null,
    'deliveryestimate'  => $tripStop['DepartureTime']['EstimatedTime'] ?? null,
    'stoptype'          => $tripStop['StopType'] ?? 'P',
    'arrivalact'        => '',   // you can add actuals if present
    'arrivalactduration'=> '',   // you can add actuals if present
    'arrivalashipunit'  => $tripStop['TripStopDetail']['ShipUnitId'] ?? '',
    'deliveract'        => '',   // add actuals if present
    'deliveractduration'=> '',   // add actuals if present
    'deliverashipunit'  => $tripStop['TripStopDetail']['ShipUnitId'] ?? '',
    'status'            => 1,
    'createdon'         => date('Y-m-d H:i:s'),
    'updatedon'         => date('Y-m-d H:i:s')
];

$checkTripStops = [
    'shipment_id'  => $shipmentId ?? 0,
    'stopnumber'   => $sequence ?? 0
];

$checkStopLocation = $this->ci->common->gettblrowdata(
    $checkTripStops,
    "id",
    "tb_shipment_stops",
    0,
    0
);

if (empty($checkStopLocation)) {
    $stop_id = $this->ci->common->insertTableData('tb_shipment_stops', $tripStopsInfo);
} else {
    $stop_id = $checkStopLocation['id'];
    $this->ci->common->updatetbledata(
        "tb_shipment_stops",
        $tripStopsInfo,
        ['id' => $stop_id]
    );
}



                // $shipUnitId = empty($tripStop['TripStopDetail']['ShipUnitId']) ? "" : $tripStop['TripStopDetail']['ShipUnitId'];

                // $checkTripStops = [
                //     'trip_id' => $tripId,
                //     'stop_detail_id' => $sequence,
                //     // 'ship_unit_id' => $shipUnitId,
                //     'location_gid' => empty($locationId) ? "0" : $locationId,
                //     'location_role_gid' => empty($locationRoleId) ? "0" : $locationRoleId,
                //     'organization_id' => $organizationId,
                //     'entity_value_id' => $businessEntityValue,
                // ];

                // $checkStopLocation = $this->ci->common->gettblrowdata(
                //     $checkTripStops,
                //     "stop_id",
                //     "tb_stop_status",
                //     0,
                //     0
                // );

                // if (empty($checkStopLocation)) {
                //     $stop_id = $this->ci->common->insertTableData('tb_stop_status', $tripStopsInfo);
                // } else {
                //     $stop_id = $checkStopLocation['stop_id'];
                //     $this->ci->common->updatetbledata(
                //         "tb_stop_status",
                //         $tripStopsInfo,
                //         ['stop_id' => $stop_id, 
                //         // 'ship_unit_id' => $shipUnitId
                //         ]
                //     );
                // }
            }
        }
    }

    public function getLocationDetails(
        array $locationDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID
    ): int {
        $party_location = [
            'name' => is_array($locationDetails['CompanyName']) ? "0" : $locationDetails['CompanyName'],
            'organization_id' => $organizationId,
            'business_entity_value' => $businessEntityValue,
            'business_entity' => $businessEntityID,
            'status' => 1,
        ];

        $checkLocation = $this->ci->common->gettblrowdata(
            $party_location,
            "party_location_id",
            "tb_party_location",
            0,
            0
        );

        if (empty($checkLocation) || $checkLocation === 0) {
            $partyLocationInfo = [
                'name' => is_array($locationDetails['CompanyName']) ? "" : $locationDetails['CompanyName'],
                'address1' => is_array($locationDetails['Address1']) ? "" : $locationDetails['Address1'],
                'address2' => is_array($locationDetails['Address2']) ? "" : $locationDetails['Address2'],
                'city' => is_array($locationDetails['City']) ? "" : $locationDetails['City'],
                'street' => is_array($locationDetails['Street']) ? "" : $locationDetails['Street'],
                'state' => is_array($locationDetails['State']) ? "" : $locationDetails['State'],
                'country' => is_array($locationDetails['Country']) ? "" : $locationDetails['Country'],
                'postal_code' => is_array($locationDetails['Postal']) ? "" : $locationDetails['Postal'],
                'province' => is_array($locationDetails['State']) ? "" : $locationDetails['State'],
                'latitude' => is_array($locationDetails['Latitude']) ? "" : $locationDetails['Latitude'],
                'longitude' => is_array($locationDetails['Longitude']) ? "" : $locationDetails['Longitude'],
                'country_code' => is_array(
                    $locationDetails['ContactInfo']['CountryCode']
                ) ? "" : $locationDetails['ContactInfo']['CountryCode'],
                'phone' => is_array(
                    $locationDetails['ContactInfo']['ContactNo']
                ) ? "0" : $locationDetails['ContactInfo']['ContactNo'],
                'email' => is_array(
                    $locationDetails['ContactInfo']['EmailAddress']
                ) ? "" : $locationDetails['ContactInfo']['EmailAddress'],
                'organization_id' => $organizationId,
                'business_entity_value' => $businessEntityValue,
                'business_entity' => $businessEntityID,
                'status' => 1,
            ];
            $party_location_id = $this->ci->common->insertTableData('tb_party_contacts', $partyLocationInfo);
        } else {
            $party_location_id = $checkLocation['party_location_id'];
        }

        return $party_location_id ?? 0;
    }

    public function getLocationRoleDetails(
        string $locationRoleGid
    ): int {
        $party_role = [
            'party_role' => $locationRoleGid,
            'status' => 1,
        ];
        $checkLocationRole = $this->ci->common->gettblrowdata(
            $party_role,
            "id",
            "tb_party_roles",
            0,
            0
        );
        if (!empty($checkLocationRole)) {
            $partyRole = $checkLocationRole['id'];
        }

        return $partyRole ?? 0;
    }

    public function getDriverDetails(
        array $DriverDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID,
        int $carrier_id,
        int $vehicle_id
    ): int {
        $DriverId = is_array($DriverDetails['DriverId']) ? "0" : $DriverDetails['DriverId'];
        $DriverName = is_array($DriverDetails['DriverName']) ? "" : $DriverDetails['DriverName'];
        $DriverLicence = is_array($DriverDetails['DriverLicence']) ? "" : $DriverDetails['DriverLicence'];
        $Address1 = is_array($DriverDetails['Address']['Address1']) ? "" : $DriverDetails['Address']['Address1'];
        $Address2 = is_array($DriverDetails['Address']['Address2']) ? "" : $DriverDetails['Address']['Address2'];
        $Street = is_array($DriverDetails['Address']['Street']) ? "" : $DriverDetails['Address']['Street'];
        $City = is_array($DriverDetails['Address']['City']) ? "" : $DriverDetails['Address']['City'];
        $State = is_array($DriverDetails['Address']['State']) ? "" : $DriverDetails['Address']['State'];
        $Postal = is_array($DriverDetails['Address']['Postal']) ? "" : $DriverDetails['Address']['Postal'];
        $Country = is_array($DriverDetails['Address']['Country']) ? "" : $DriverDetails['Address']['Country'];
        $CountryCode = is_array(
            $DriverDetails['Address']['ContactInfo']['CountryCode']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['CountryCode'];
        $ContactNo = is_array(
            $DriverDetails['Address']['ContactInfo']['ContactNo']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['ContactNo'];
        $EmailAddress = is_array(
            $DriverDetails['Address']['ContactInfo']['EmailAddress']
        ) ? "" : $DriverDetails['Address']['ContactInfo']['EmailAddress'];
        $checkParty = $this->ci->common->gettblrowdata(
            ["driver_name" => $DriverName, 'driving_licence_num' => $DriverLicence, 'status' => "Active"],
            "driver_id",
            "tb_driver_details",
            0,
            0
        );
        if (!empty($checkParty)) {
            $driver_id = $checkParty['driver_id'];
        } else {
            $driverData = [
                'driver_name' => $DriverName,
                'contact_num' => $ContactNo,
                'password' => password_hash($ContactNo, PASSWORD_DEFAULT),
                'driving_licence_num' => $DriverLicence,
                'address1' => $Address1,
                'address2' => $Address2,
                'street' => $Street,
                'city' => $City,
                'state' => $State,
                'pincode' => $Postal,
                'country' => $Country,
                'email' => $EmailAddress,
                "organization_id" => $organizationId,
                "business_entity_value_id" => $businessEntityValue,
                'status' => 1,
            ];
            $driver_id = $this->ci->common->insertTableData('tb_driver_details', $driverData);
        }

        return $driver_id ?? 0;
    }

    public function getVehicleDetails(
        array $VehicleDetails,
        string $organizationId,
        string $businessEntityValue,
        string $businessEntityID,
        int $carrier_id
    ): int {
        // $vehicleTypeCode = is_array($VehicleDetails['VehicleTypeCode']) ? "0" : $VehicleDetails['VehicleTypeCode'];
         $vehicleTypeCode  = isset($VehicleDetails['VehicleTypeCode']) ? (string)$VehicleDetails['VehicleTypeCode'] : '';
        $vehicleModelCode = isset($VehicleDetails['VehicleModelCode']) ? (string)$VehicleDetails['VehicleModelCode'] : '';

        /*$VehicleModelCode = is_array($VehicleDetails['VehicleModelCode']) ? "0" : $VehicleDetails['VehicleModelCode'];
        $RegistrationNumber = is_array(
        $VehicleDetails['RegistrationNumber']
        ) ? "0" : $VehicleDetails['RegistrationNumber'];
        $License = is_array($VehicleDetails['License']) ? "0" : $VehicleDetails['License'];
        $ApplicableForDangerousGoods = is_array(
        $VehicleDetails['ApplicableForDangerousGoods']
        ) ? "0" : $VehicleDetails['ApplicableForDangerousGoods'];
        $CommodityType = is_array($VehicleDetails['CommodityType']) ? "0" : $VehicleDetails['CommodityType'];
        $minWeight = is_array(
        $VehicleDetails['Properties']['Weight']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['Min'];
        $maxWeight = is_array(
        $VehicleDetails['Properties']['Weight']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['Max'];
        $weightUOM = is_array(
        $VehicleDetails['Properties']['Weight']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Weight']['UOM'];
        $minVolume = is_array(
        $VehicleDetails['Properties']['Volume']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['Min'];
        $maxVolume = is_array(
        $VehicleDetails['Properties']['Volume']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['Max'];
        $VolumeUOM = is_array(
        $VehicleDetails['Properties']['Volume']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Volume']['UOM'];
        $minLength = is_array(
        $VehicleDetails['Properties']['Length']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Length']['Min'];
        $maxLength = is_array(
        $VehicleDetails['Properties']['Length']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Length']['Max'];
        $LengthUOM = is_array(
        $VehicleDetails['Properties']['Length']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Length']['UOM'];
        $minWidth = is_array(
        $VehicleDetails['Properties']['Width']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Width']['Min'];
        $maxWidth = is_array(
        $VehicleDetails['Properties']['Width']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Width']['Max'];
        $WidthUOM = is_array(
        $VehicleDetails['Properties']['Width']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Width']['UOM'];
        $minHeight = is_array(
        $VehicleDetails['Properties']['Height']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Height']['Min'];
        $maxHeight = is_array(
        $VehicleDetails['Properties']['Height']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Height']['Max'];
        $HeightUOM = is_array(
        $VehicleDetails['Properties']['Height']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Height']['UOM'];
        $minDistance = is_array(
        $VehicleDetails['Properties']['Distance']['Min']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['Min'];
        $maxDistance = is_array(
        $VehicleDetails['Properties']['Distance']['Max']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['Max'];
        $DistanceUOM = is_array(
        $VehicleDetails['Properties']['Distance']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['Distance']['UOM'];
        $minDimensionGirth = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['Min']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['Min'];
        $maxDimensionGirth = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['Max']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['Max'];
        $DimensionGirthUOM = is_array(
        $VehicleDetails['Properties']['DimensionGirth']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['DimensionGirth']['UOM'];
        $minShipmentUnit = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['Min']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['Min'];
        $maxShipmentUnit = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['Max']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['Max'];
        $ShipmentUnitUOM = is_array(
        $VehicleDetails['Properties']['ShipmentUnit']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['ShipmentUnit']['UOM'];
        $minPacketWeight = is_array(
        $VehicleDetails['Properties']['PacketWeight']['Min']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['Min'];
        $maxPacketWeight = is_array(
        $VehicleDetails['Properties']['PacketWeight']['Max']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['Max'];
        $PacketWeightUOM = is_array(
        $VehicleDetails['Properties']['PacketWeight']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['PacketWeight']['UOM'];
        $minPacketVolume = is_array(
        $VehicleDetails['Properties']['PacketVolume']['Min']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['Min'];
        $maxPacketVolume = is_array(
        $VehicleDetails['Properties']['PacketVolume']['Max']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['Max'];
        $PacketVolumeUOM = is_array(
        $VehicleDetails['Properties']['PacketVolume']['UOM']
        ) ? "0" : $VehicleDetails['Properties']['PacketVolume']['UOM'];*/
        // $vehicleTypeInfo = [
        //     "vehicle_type_id" => $vehicleTypeCode,
        //     "vehicle_type_name" => $vehicleTypeCode,
        //     "organization_id" => $organizationId,
        //     "business_entity_id" => $businessEntityID,
        //     "business_entity_value_id" => $businessEntityValue,
        //     'status' => 1,
        // ];
            $vehicleData = [
            "vehicle_type_code"    => $vehicleTypeCode,
            "vehicle_model_code"   => $vehicleModelCode,
            "status"               => 1,
           ];
         $VehicleType = $this->ci->db
        ->where('vehicle_type_code', $vehicleTypeCode)
        ->where('vehicle_model_code', $vehicleModelCode)
        
        ->get('tb_vehicle_master')
        ->row_array();

        if (!empty($VehicleType)) {
            return (int)$VehicleType['id']; 
        }

        
        $this->ci->db->insert('tb_vehicle_master', $vehicleData);
        return (int)$this->ci->db->insert_id();
    }

        // $vehicle_id = $vehicle_type_id = 0;
        // $vehicleTypeCodeValue = $this->ci->common->gettblrowdata($vehicleTypeInfo, "id", "tb_vehicle_type_master", 0, 0);
        // if (!empty($vehicleTypeCodeValue)) {
        //     $vehicle_type_id = $vehicleTypeCodeValue['id'];
        // }
        // if (!empty($vehicleTypeCode) && $vehicle_type_id == 0) {
        //     $vehicle_type_id = $this->ci->common->insertTableData('tb_vehicle_type_master', $vehicleTypeInfo);
        // }

        /*$partyWhere = [
        "register_number" => $RegistrationNumber,
        "organization_id" => $organizationId,
        "business_entity_value_id" => $businessEntityValue,
        'status' => 1,
        ];
        $checkVehicleDetails = $this->ci->common->gettblrowdata($partyWhere, "vehicle_id", "tb_vehicle_details", 0, 0);
        if (!empty($checkVehicleDetails)) {
        $vehicle_id = $checkVehicleDetails['vehicle_id'];
        } else {
        $vehicleDetails = [
        'truck_number' => $RegistrationNumber,
        'length' => $maxLength,
        'length_unit' => $LengthUOM,
        'breadth' => $maxWidth,
        'breadth_unit' => $WidthUOM,
        'vehicle_type' => $vehicle_type_id,
        'truck_brand' => $vehicle_type_id,
        'description' => $RegistrationNumber,
        'register_number' => $RegistrationNumber,
        "organization_id" => $organizationId,
        "business_entity_value_id" => $businessEntityValue,
        ];
        $vehicle_id = $this->ci->common->insertTableData('tb_vehicle_details', $vehicleDetails);
        }*/

    //     return $vehicle_type_id ?? 0;
    // }

    public function getCarrierDetails(
        array $CarrierDetails,
        int $organizationId,
        int $businessEntityValue,
        int $businessEntityID
    ): int {
        $carrierCode = is_array($CarrierDetails['ID']) ? "0" : $CarrierDetails['ID'];
        $carrierName = is_array($CarrierDetails['Company']['Name']) ? "0" : $CarrierDetails['Company']['Name'];
        $party_code = is_array(
            $CarrierDetails['Company']['RegistrationNumber']
        ) ? "0" : $CarrierDetails['Company']['RegistrationNumber'];
        $address1 = is_array($CarrierDetails['Address']['Address1']) ? "" : $CarrierDetails['Address']['Address1'];
        $address2 = is_array($CarrierDetails['Address']['Address2']) ? "" : $CarrierDetails['Address']['Address2'];
        $street = is_array($CarrierDetails['Address']['Street']) ? "" : $CarrierDetails['Address']['Street'];
        $city = is_array($CarrierDetails['Address']['City']) ? "" : $CarrierDetails['Address']['City'];
        $State = (is_array($CarrierDetails['Address']['State']) ? "" : $CarrierDetails['Address']['State']);
        $postal = (is_array($CarrierDetails['Address']['Postal']) ? "" : $CarrierDetails['Address']['Postal']);
        $country = (is_array($CarrierDetails['Address']['Country']) ? "" : $CarrierDetails['Address']['Country']);
        $email = (is_array(
            $CarrierDetails['Address']['ContactInfo']['EmailAddress']
        ) ? "" : $CarrierDetails['Address']['ContactInfo']['EmailAddress']);
        $phone = (is_array(
            $CarrierDetails['Address']['ContactInfo']['ContactNo']
        ) ? "" : $CarrierDetails['Address']['ContactInfo']['ContactNo']);
        $latitude = (is_array($CarrierDetails['Address']['Latitude']) ? "" : $CarrierDetails['Address']['Latitude']);
        $longitude = (is_array($CarrierDetails['Address']['Longitude']) ? "" : $CarrierDetails['Address']['Longitude']);
        $address = $address1 . "," . $address2 . "," . $street . "," . $city . "," . $State . "," . $postal . "," . $country;
        if ($latitude == "" && $longitude == "") {
            $data = getlatlngsbyaddress($address);
            $latitude = @$data[0];
            $longitude = @$data[1];
        }
        $partyWhere = [
            "carrier_name" => $carrierName,
            "code" => $carrierCode,
            "organization_id" => $organizationId,
            "business_entity_value_id" => $businessEntityValue,
            'status' => 1,
        ];
        $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
        if (!empty($checkCarrier)) {
            $partyContactID = $checkCarrier['carrier_id'];
        } else {
            $partyWhere = [
                "carrier_name" => $carrierName,
                "organization_id" => $organizationId,
                "business_entity_value_id" => $businessEntityValue,
                'status' => 1,
            ];
            $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
            if (!empty($checkCarrier)) {
                $partyContactID = $checkCarrier['carrier_id'];
            } else {
                $partycontactInfo = [
                    "carrier_name" => $carrierName,
                    "organization_id" => $organizationId,
                    "business_entity_value_id" => $businessEntityValue,
                    'status' => 1,
                    'address1' => $phone,
                    'address2' => $phone,
                    'mobile' => $phone,
                    'email' => $email,
                    'street' => $street,
                    'city' => $city,
                    'state' => $State,
                    'pincode' => $postal,
                    'country' => $country,
                    'latitude' => $latitude,
                    'longitude' => $longitude,
                ];
                $partyContactID = $this->ci->common->insertTableData('tb_carrier_details', $partycontactInfo);
                if ($carrierCode === 0) {
                    $carrierCode = $organizationId . $businessEntityValue . date('y') . date('W') . $partyContactID;
                    $this->ci->common->updatetbledata(
                        "tb_carrier_details",
                        ['code' => $carrierCode],
                        ['carrier_id' => $partyContactID]
                    );
                }
            }
        }
        return $partyContactID ?? 0;
    }

    /*public function getCarrierDetails(
    array $CarrierDetails,
    int $organizationId,
    int $businessEntityValue,
    int $businessEntityID
    ): int {
    $carrierCode = is_array($CarrierDetails['ID']) ? "0" : $CarrierDetails['ID'];
    $carrierName = is_array($CarrierDetails['Company']['Name']) ? "0" : $CarrierDetails['Company']['Name'];
    $party_code = is_array(
    $CarrierDetails['Company']['RegistrationNumber']
    ) ? "0" : $CarrierDetails['Company']['RegistrationNumber'];
    $address1 = is_array($CarrierDetails['Address']['Address1']) ? "" : $CarrierDetails['Address']['Address1'];
    $address2 = is_array($CarrierDetails['Address']['Address2']) ? "" : $CarrierDetails['Address']['Address2'];
    $street = is_array($CarrierDetails['Address']['Street']) ? "" : $CarrierDetails['Address']['Street'];
    $city = is_array($CarrierDetails['Address']['City']) ? "" : $CarrierDetails['Address']['City'];
    $State = (is_array($CarrierDetails['Address']['State']) ? "" : $CarrierDetails['Address']['State']);
    $postal = (is_array($CarrierDetails['Address']['Postal']) ? "" : $CarrierDetails['Address']['Postal']);
    $country = (is_array($CarrierDetails['Address']['Country']) ? "" : $CarrierDetails['Address']['Country']);
    $email = (is_array(
    $CarrierDetails['Address']['ContactInfo']['EmailAddress']
    ) ? "" : $CarrierDetails['Address']['ContactInfo']['EmailAddress']);
    $phone = (is_array(
    $CarrierDetails['Address']['ContactInfo']['ContactNo']
    ) ? "" : $CarrierDetails['Address']['ContactInfo']['ContactNo']);
    $latitude = (is_array($CarrierDetails['Address']['Latitude']) ? "" : $CarrierDetails['Address']['Latitude']);
    $longitude = (is_array($CarrierDetails['Address']['Longitude']) ? "" : $CarrierDetails['Address']['Longitude']);
    $address = $address1 . "," . $address2 . "," . $street . "," . $city . "," . $State . "," . $postal . "," . $country;
    if ($latitude == "" && $longitude == "") {
    $data = getlatlngsbyaddress($address);
    $latitude = @$data[0];
    $longitude = @$data[1];
    }
    $partyWhere = [
    "carrier_name" => $carrierName,
    "code" => $carrierCode,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    ];
    $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
    if (!empty($checkCarrier)) {
    $partyContactID = $checkCarrier['carrier_id'];
    } else {
    $partyWhere = [
    "carrier_name" => $carrierName,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    ];
    $checkCarrier = $this->ci->common->gettblrowdata($partyWhere, "carrier_id", "tb_carrier_details", 0, 0);
    if (!empty($checkCarrier)) {
    $partyContactID = $checkCarrier['carrier_id'];
    } else {
    $partycontactInfo = [
    "carrier_name" => $carrierName,
    "organization_id" => $organizationId,
    "business_entity_value_id" => $businessEntityValue,
    'status' => 1,
    'address1' => $phone,
    'address2' => $phone,
    'mobile' => $phone,
    'email' => $email,
    'street' => $street,
    'city' => $city,
    'state' => $State,
    'pincode' => $postal,
    'country' => $country,
    'latitude' => $latitude,
    'longitude' => $longitude,
    ];
    $partyContactID = $this->ci->common->insertTableData('tb_carrier_details', $partycontactInfo);
    if ($carrierCode === 0) {
    $carrierCode = $organizationId . $businessEntityValue . date('y') . date('W') . $partyContactID;
    $this->ci->common->updatetbledata(
    "tb_carrier_details",
    ['code' => $carrierCode],
    ['carrier_id' => $partyContactID]
    );
    }
    }
    }
    return $partyContactID ?? 0;
    }*/

   public function orderdetails(
    array $order,
    ?string $organizationId,         // nullable string
    ?string $businessEntityValue,    // nullable string
    ?string $businessEntityID,
    ?string $organization,           // nullable string
    ?string $businessEntity,         // nullable string
    ?string $domain,  
    ?array $orderHeader,
    ?string $tripId = null                 // nullable string
): string {
    // Ensure variables are never null inside the function
    $organizationId = $organizationId ?? '';
    $businessEntityValue = $businessEntityValue ?? '';
    $organization = $organization ?? '';
    $businessEntity = $businessEntity ?? '';
    $domain = $domain ?? '';
        //$orderMovementId = (empty($order['OrderMovementId']) ? "" : $order['OrderMovementId']);
        $orderMovementId = $order['OrderMovementId'];
        //$orderType = (empty($order['OrderType']) ? "0" : $order['OrderType']);
        $orderType = ($order['OrderType']);
        $modeOfTransport = (empty($order['ModeOfTransport']) ? "0" : $order['ModeOfTransport']);
        $product = (empty($order['Product']) ? "0" : $order['Product']);
        $serviceType = (empty($order['ServiceType']) ? "0" : $order['ServiceType']);
        $orderData = [
            'TripID' => $tripId ?? "0",
            'OrderID' => (empty($order['OrderID']) ? "0" : $order['OrderID']),
            'EXTOrderID' => (empty($order['EXTOrderID']) ? "0" : $order['EXTOrderID']),
            'OrderType' => $orderType,
            'ModeOfTransport' => $modeOfTransport,
            'Product' => $product,
            'ServiceType' => $serviceType,
            'organizationId' => $organizationId,
            'businessEntityValue' => $businessEntityValue,
            'businessEntityID' => $businessEntityID,
            'domain' => $domain,
            'company_code' => $organizationId,
            'branch_code' => $businessEntityValue,
            'TypeOfBusiness' => (empty($order['TypeOfBusiness']) ? "" : $order['TypeOfBusiness']),
            'Incoterm' => (empty($order['TermsOfTrade']['Incoterm']) ? "" : $order['TermsOfTrade']['Incoterm']),
            'FreightTerm' => (empty($order['TermsOfTrade']['FreightTerm']['Term']) ? "" : $order['TermsOfTrade']['FreightTerm']['Term']),
            'FreightTermName' => (empty($order['TermsOfTrade']['FreightTerm']['Name']) ? "" : $order['TermsOfTrade']['FreightTerm']['Name']),
            'customerDetails' => $order['CustomerDetails'],
            'sourceInfo' => $order['LocationInfo']['Source'],
            'destinationInfo' => $order['LocationInfo']['Destination'],
            'cargoSummary' => $order['OrderCargoSummary'],
            'cargoDetails' => $order['CargoDetails'],
            'valueAddedServices' => $order['ValueAddedServices'],
            'involvedParties' => $order['InvolvedParties'],
            'manageReferences' => $order['ManageReferences'] ?? [],
            'remarks' => $order['Remarks'] ?? [],
            'organization' => $organization,
            'businessEntity' => $businessEntity,
            'orderMovementId' => $orderMovementId,
            'header' => $orderHeader,
        ];
        
        return $this->ci->standardbookinghandler->saveOrderDetails($orderData);
        log_message('error', 'TripID inside orderdetails: ' . ($tripId ?? 'NULL'));

    }
}
