<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class PhpMailerLibrary
{

    /*public function __construct()
    {
        $this->mail = new PHPMailer();
        $this->mail->IsSMTP();
        $this->mail->SMTPOptions = [
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ];
        $this->mail->Mailer = "smtp";
        $this->mail->Host = KN_SMTP_HOST;
        $this->mail->Port = KN_SMTP_PORT;
        $this->mail->CharSet = 'UTF-8';
    }*/
    public function __construct()
    {
        $this->mail = new PHPMailer(true); // Enable exceptions for debugging
        $this->mail->isSMTP();
        $this->mail->SMTPDebug = 0; // Add for temporary debugging (disable in production)
        $this->mail->Mailer = "smtp";
        $this->mail->Host = KN_SMTP_HOST;           // elog360.app
        $this->mail->Port = KN_SMTP_PORT;           // 465
        //$this->mail->Port = 587;           // 465
        $this->mail->SMTPAuth = true;               // ✅ Required for auth
        $this->mail->Username = KN_SMTP_USER;       // alert-donotreply@elog360.app
        $this->mail->Password = KN_SMTP_PASS;       // Elog@svk
        $this->mail->SMTPSecure = KN_SMTP_SECURE;            // ✅ Use 'ssl' for port 465
        $this->mail->CharSet = 'UTF-8';
    
        // Optional: bypass cert errors (can be removed if SSL cert is valid)
        $this->mail->SMTPOptions = [
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ];
    }

    public function sendMail(string $to, string $subject, string $message, array $ccMailIds = [], array $attachments = [], array $bccMailIds = []): bool
    {
        if($to == '' || $message == ''){
            return false;
        }
        $this->mail->ClearAllRecipients();
        $this->mail->clearAttachments();
        $this->mail->clearCustomHeaders();
        $this->mail->AddAddress($to, "");
        foreach ($ccMailIds as $eachCcMailId) {
            $this->mail->AddCC($eachCcMailId);
        }
        foreach ($bccMailIds as $eachBccMailId) {
            $this->mail->addBCC($eachBccMailId);
        }
        $this->mail->SetFrom(SVKONEKT_EMAIL, 'Svkonekt');
        $this->mail->Subject = $subject ?? '';
        $this->mail->Body = $message;
        $this->mail->IsHTML(true);
        foreach ($attachments as $eachAttachment) {
            $this->mail->addAttachment($eachAttachment);
        }
        if (!$this->mail->Send()) {
            log_message("error", 'PhpMailer error: ' . $this->mail->ErrorInfo);
            return false;
        }
        return true;
    }
    
    public function sendMailCollins(string $from, string $subject, string $message, array $ccMailIds = [], string $to): bool
    {
        if($to == '' || $message == ''){
            return false;
        }
        $this->mail->ClearAllRecipients();
        $this->mail->clearAttachments();
        $this->mail->clearCustomHeaders();
        $this->mail->AddAddress($to, "");
        foreach ($ccMailIds as $eachCcMailId) {
            $this->mail->AddCC($eachCcMailId);
        }
        $this->mail->SetFrom($from, 'Svkonekt');
        $this->mail->Subject = $subject ?? '';
        $this->mail->Body = $message;
        $this->mail->IsHTML(true);
        log_message("error", "mail1:" . json_encode($this->mail));
        if (!$this->mail->Send()) {
            log_message("error", 'PhpMailer error: ' . $this->mail->ErrorInfo);
            return false;
        }
        return true;
    }

    public function sendMultipleToMail(array $toAddress, string $subject, string $message, array $ccAddress = [], array $attachments = [], array $bccAddress = []): bool {
        if (empty($toAddress) || empty($message)) {
            return false;
        }
        $this->mail->ClearAllRecipients();
        $this->mail->clearAttachments();
        $this->mail->clearCustomHeaders();
        foreach ($toAddress as $to) { $this->mail->AddAddress($to, ""); }
        foreach ($ccAddress as $cc) { $this->mail->AddCC($cc); }
        foreach ($bccAddress as $bcc) { $this->mail->addBCC($bcc); }
        $this->mail->SetFrom(SVKONEKT_EMAIL, 'Svkonekt');
        $this->mail->Subject = $subject ?? '';
        $this->mail->Body = $message;
        $this->mail->IsHTML(true);
        foreach ($attachments as $eachAttachment) {
            $this->mail->addAttachment($eachAttachment);
        }
        if (!$this->mail->Send()) {
            log_message("error", 'PhpMailer error: ' . $this->mail->ErrorInfo);
            return false;
        }
        return true;
    }
}
