<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class RateForMultilegs
{

    public function __construct()
    {
        $ci =& get_instance();
        $ci->load->model(['common', 'Orderrevenuesmodel', 'Order']);
        $ci->load->library('Ratemanagement');
        $this->companyCode = $ci->session->userdata('company_code');
        $this->userId = $ci->session->userdata('user_id');
        $this->currency = $ci->session->userdata("usr_tzone")['currency'];;
    }

    public function checkRatePreferenceForLegs(array $legIds, int $orderId): void
    {
        $ci =& get_instance();
        $vendorProfiles = [];
        if (!empty($legIds) && $orderId > 0) {
            $generalData = $this->getAllGeneralData($legIds, $orderId);
            $partyAddresses = $generalData['partyAddresses'];
            $stops = $generalData['stops'];
            $legsData = $generalData['legsData'];
            $vendorDetails = $generalData['vendorDetails'];
            $vendorNames = $generalData['vendorNames'];
            if (!empty($vendorDetails)) {
                $vendorProfileData = $ci->Orderrevenuesmodel->getVendorProfileDetailsFromCID($vendorDetails, $this->userId);
                foreach ($vendorProfileData as $eachLine) {
                    $vendorProfiles[$eachLine['profile_id']][] = ['profileRowId' => $eachLine['id'], 'profileId' => $eachLine['vend_profile_id'], 'code' => $eachLine['profile_id']];
                }
                foreach ($legsData as $eachLine) {
                    $shiftId = $eachLine['rowId'];
                    $vendorId = $eachLine['vendorId'];
                    $vendorCode = $vendorDetails[$vendorId] ?? "";
                    $vendorName = $vendorNames[$vendorId] ?? "";
                    $pickupStopPartyId = $stops[$shiftId]['P']['partyRowId'] ?? 0;
                    $deliveryStopPartyId = $stops[$shiftId]['D']['partyRowId'] ?? 0;
                    if (!in_array(0, [$pickupStopPartyId, $deliveryStopPartyId], true)) {
                        $pickupRowId = $partyAddresses[$pickupStopPartyId]['id'] ?? 0;
                        $deliveryRowId = $partyAddresses[$deliveryStopPartyId]['id'] ?? 0;
                        if (!in_array(0, [$pickupRowId, $deliveryRowId], true)) {
                            $pickupData = [
                                'country' => trim($partyAddresses[$pickupStopPartyId]['country']),
                                'state' => trim($partyAddresses[$pickupStopPartyId]['state']),
                                'city' => trim($partyAddresses[$pickupStopPartyId]['city']),
                                'pincode' => trim($partyAddresses[$pickupStopPartyId]['pincode']),
                                'divisionName' => trim($partyAddresses[$pickupStopPartyId]['divisionName']),
                                'subDistrict' => trim($partyAddresses[$pickupStopPartyId]['subDistrict'])
                            ];
                            $deliveryData = [
                                'country' => trim($partyAddresses[$deliveryStopPartyId]['country']),
                                'state' => trim($partyAddresses[$deliveryStopPartyId]['state']),
                                'city' => trim($partyAddresses[$deliveryStopPartyId]['city']),
                                'pincode' => trim($partyAddresses[$deliveryStopPartyId]['pincode']),
                                'divisionName' => trim($partyAddresses[$deliveryStopPartyId]['divisionName']),
                                'subDistrict' => trim($partyAddresses[$deliveryStopPartyId]['subDistrict'])
                            ];
                            $finalData[] = ['shiftId' => $shiftId, 'shipmentId' => $eachLine['shipmentId'], 'vendorId' => $vendorId, 'pickupAddress' => $pickupData, 'deliveryAddress' => $deliveryData];
                            if ($vendorCode != "") {
                                $vendorProfileIds = [];
                                foreach ($vendorProfiles[$vendorCode] as $eachRow) {
                                    $vendorProfileIds[] = $eachRow['profileRowId'];
                                }
                                $preferences = $ci->Order->getvendorpreferencebyorderdetails(0, $this->userId, $pickupData, $deliveryData, $vendorProfileIds);
                                foreach ($preferences as $preference) {
                                    $checkPrefrenceCondition = $this->checkAllRatePreferencesCondition($preference, $generalData['orderDetails']);
                                    if ($checkPrefrenceCondition > 0) {
                                        $generalData['orderDetails']['vendorCode'] = $vendorCode;
                                        $generalData['orderDetails']['vendorName'] = $vendorName;
                                        $finalCondition = $this->checkRemainingRateConditions($preference, $pickupData, $deliveryData, $generalData['orderDetails']);
                                        if ($finalCondition > 0) {
                                            $this->insertRatesForIndividualLegs($preference, $generalData['orderDetails'], ['pickup' => $pickupData, 'delivery' => $deliveryData, 'shiftId' => $shiftId]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private function insertRatesForIndividualLegs($preference, $orderDetails, $legsLocation)
    {
        $ci =& get_instance();
        $currentDate = date('Y-m-d');
        $rateService = $preference['rate_service_id'];
        $rateOffering = $preference['rate_offering_id'];
        $rateRecord = $preference['rate_record_id'];
        $ratePreference = $preference['rate_prefer_id'] ?? $preference['id'];
        $getRateRecordId = $ci->common->gettblrowdata(['id' => $rateRecord, 'status' => '1'], 'rate_id', "tb_rate_records", 0, 0);
        $rateRecordId = $getRateRecordId['rate_id'] ?? $rateRecord;
        $getRateOfferingId = $ci->common->gettblrowdata(['id' => $rateOffering, 'status' => '1'], "offering_id", "tb_rate_offerings", 0, 0);
        $rateOfferingId = $getRateOfferingId['offering_id'] ?? $rateOffering;
        $vasCharges = $ci->ratemanagement->getchargesthrougvasbyrecord($rateOffering, $rateRecord, $orderDetails['id'], $this->userId, '1');
        foreach ($vasCharges as $eachLine) {
            $vasChargeId = $eachLine['charge_id'];
            if ($vasChargeId > 0) {
                $getchargesForLane = $ci->common->gettblrowdata(['id' => $vasChargeId, 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                $laneChargeId = $getchargesForLane['id'] ?? 0;
                $laneChargeName = $getchargesForLane['name'] ?? "";
            } else {
                $getchargesForLane = $ci->common->gettblrowdata(['charge_code' => 'CSC', 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
                $laneChargeId = $getchargesForLane['id'] ?? 0;
                $laneChargeName = $getchargesForLane['name'] ?? "";
            }
            $recordVasCharges[] = ['charge_code' => $laneChargeId, 'description' => $laneChargeName, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $rateRecordId, 'amount' => $eachLine['amount'], 'currency' => $eachLine['currency'], 'user_id' => $this->userId, 'createdon' => $currentDate];
        }
        $getOfferingVasCharges = $ci->ratemanagement->getchargesthrougvasbyoffering($rateOffering, '1', $orderDetails['id'], $this->userId);
        foreach ($getOfferingVasCharges as $res) {
            $getcharge_forlane = $ci->common->gettblrowdata(['id' => $res['charge_id'], 'status' => '1'], 'id,name', "tb_charge_codes", 0, 0);
            $laneChargeName = $getcharge_forlane['name'] ?? "";
            $offeringVasCharges[] = ['charge_code' => $res['charge_id'], 'description' => $laneChargeName, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => $rateOfferingId, 'amount' => $res['amount'], 'currency' => $res['currency'], 'rate_service_id' => $rateService, 'rate_offering_id' => $rateOffering, 'rate_record_id' => $rateRecord, 'user_id' => $this->userId, 'createdon' => $currentDate];
        }
        $recordCharges = $ci->ratemanagement->getraterecordcharges($rateOffering, $rateRecord, '1', $orderDetails['id'], $rateRecordId, $this->userId, $legsLocation);
        if (!empty($recordCharges)) {
            $foreign_currency = $recordCharges[0]['foreign_currency'] ?? "";
            $currency = $recordCharges[0]['currency'] ?? "";
            $exchange_rate = $recordCharges[0]['exchange_amount'];
            for ($c = 0, $cMax = count($recordCharges); $c < $cMax; $c++) {
                unset($recordCharges[$c]['foreign_currency'], $recordCharges[$c]['exchange_amount']);
                $recordCharges[$c]['rate_service_id'] = $rateService;
                $recordCharges[$c]['rate_offering_id'] = $rateOffering;
                $recordCharges[$c]['rate_record_id'] = $rateRecord;
            }
        }
        $revenue_ar = [
            'order_id' => $orderDetails['id'],
            'type' => '1',
            'recipient_role' => 'Carrier',
            'recipient_code' => $orderDetails['vendorCode'],
            'recipient_name' => $orderDetails['vendorName'],
            'debtor_jfr' => "",
            'invoice_number' => "",
            'credit_note_number' => "",
            'invoice_date' => "0000-00-00 00:00:00",
            'invoice_creation_date' => "0000-00-00 00:00:00",
            'invoice_receivdon_date' => "0000-00-00 00:00:00",
            'amount' => '0',
            'currency' => $currency ?? $this->currency,
            'status' => 1,
            'user_id' => $this->userId,
            'leg_id' => $legsLocation['shiftId'],
            'createdon' => $currentDate,
            'exchange_rate' => $exchange_rate,
            'invoice_status' => '0',
            'foreign_currency' => $foreign_currency,
            'source_created' => $ratePreference
        ];
        $costId = $ci->ratemanagement->insertrecords($revenue_ar, $recordCharges ?? [], [], $offeringVasCharges ?? [], $recordVasCharges ?? []);
        if ($costId > 0) {
            $getCostAmount = $ci->common->gettblrowdata(['id'=>$costId],"amount,currency","tb_reveneus",0,0);
            $costAmount = $getCostAmount['amount'] ?? 0;
            $costCurrency = $getCostAmount['currency'] ?? $this->currency;
            $checkRecords = $ci->common->gettblrowdata(['id!=' => $costId, 'type' => '1', 'amount' => $costAmount, 'currency' => $costCurrency, 'order_id' => $orderDetails['id'], 'recipient_role' => 'Carrier', 'recipient_code' => $orderDetails['vendorCode'], 'recipient_name' => $orderDetails['vendorName'], 'invoice_status' => '0', 'status' => '1', 'leg_id' => $legsLocation['shiftId'], 'source_created' => $ratePreference], "id", "tb_reveneus", 0, 0);
            if (!empty($checkRecords)) {
                $ci->common->updatetbledata("tb_reveneus", ['status' =>'0'], ['id'=>$checkRecords['id']]);
                $ci->common->updatetbledata("tb_charges", ['status' =>'0'], ['revenue_id'=>$checkRecords['id']]);
            }
        }
        if ($rateRecord > 0 && $costId > 0) {
            $addfaf = $ci->ratemanagement->addfafcharges_toorder($orderDetails['id'], $costId, $rateRecord, 'RP - Rate Preference');
        }
    }

    private function checkRemainingRateConditions(array $preference, array $pickupData, array $deliveryData, array $orderDetails): int
    {
        $ci =& get_instance();
        $lanes = [];
        $rateService = $preference['rate_service_id'];
        $rateOffering = $preference['rate_offering_id'];
        $source = [
            'pickup_country' => $pickupData['country'],
            'delivery_country' => $deliveryData['country'],
            'pickup_city' => $pickupData['city'],
            'delivery_city' => $deliveryData['city'],
            'pickup_zcode' => $pickupData['pincode'],
            'delivery_zcode' => $deliveryData['pincode'],
            'pickup_sub_district' => $pickupData['subDistrict'],
            'delivery_sub_district' => $deliveryData['subDistrict'],
            'pickup_division_name' => $pickupData['divisionName'],
            'delivery_division_name' => $deliveryData['divisionName'],
            'pickup_state' => $pickupData['state'],
            'delivery_state' => $deliveryData['state']
        ];
        $getLanesData = $ci->Order->getlanes_byservice($source, $rateService);
        foreach ($getLanesData as $eachLane) {
            $lanes[] = $eachLane['id'];
        }
        if (empty($lanes)) {
            return 0;
        }
        $checkRateService = $ci->common->gettblrowdata(['id' => $rateService, 'service_type' => $orderDetails['service']], "service_id", "tb_rate_services", 0, 0);
        if (!empty($checkRateService)) {
            $rateServiceCondition = 1;
        }
        $checkRateOffering = $ci->common->gettblrowdata(['id' => $rateOffering, "offering_type" => $orderDetails['transport_mode'], "offering_active" => '1', "tarrif_type" => 'BUY'], "id,vendor_profile_id", "tb_rate_offerings", 0, 0);
        if (!empty($checkRateOffering)) {
            $rateOfferingCondition = 1;
            $checkVendorPrrofile = $ci->common->gettblrowdata(['vp_id' => $checkRateOffering['vendor_profile_id'], 'profile_id' => $orderDetails['vendorCode'], 'status' => '1'], "id", "tb_vendor_profile_list", 0, 0);
            if (!empty($checkVendorPrrofile)) {
                $profileCondition = 1;
            }
        }
        if (in_array(0, [$profileCondition ?? 0, $rateOfferingCondition ?? 0, $rateServiceCondition ?? 0])) {
            return 0;
        }
        return 1;
    }

    private function checkAllRatePreferencesCondition(array $preference, array $orderDetails): int
    {
        $ci =& get_instance();
        $rateService = $preference['rate_service_id'];
        $rateOffering = $preference['rate_offering_id'];
        $rateRecord = $preference['rate_record_id'];
        $ratePreferenceRowId = $preference['id'];
        $preferenceOrderTypes = $preferenceServices = [];
        if (in_array(0, [$rateService, $rateOffering, $rateRecord], true)) {
            return 0;
        }
        if ($orderDetails['order_type'] > 0) {
            $getPreferenceOrderTypes = $ci->common->gettbldata(['rate_prefer_id' => $ratePreferenceRowId, 'status' => '1'], "order_type_id", "tb_rateprefer_ordertypes", 0, 0);
            foreach ($getPreferenceOrderTypes as $eachLine) {
                $preferenceOrderTypes[] = $eachLine['order_type_id'];
            }
            if (empty($preferenceOrderTypes) || in_array($orderDetails['order_type'], $preferenceOrderTypes, true)) {
                $orderTypeCheckCondition = 1;
            }
        }
        if ($orderDetails['service'] > 0) {
            $getPreferenceServices = $ci->common->gettbldata(['rate_prefer_id' => $ratePreferenceRowId, 'status' => '1'], "service_id", "tb_rateprefer_service", 0, 0);
            foreach ($getPreferenceServices as $eachLine) {
                $preferenceServices[] = $eachLine['service_id'];
            }
            if (empty($preferenceServices) || in_array($orderDetails['order_type'], $preferenceServices, true)) {
                $serviceCheckCondition = 1;
            }
        }
        $productNames = [];
        if ($orderDetails['product'] != "") {
            $getPreferenceProducts = $ci->common->gettbldata(['rate_prefer_id' => $ratePreferenceRowId, 'status' => '1'], "product_id", "tb_rateprefer_product", 0, 0);
            foreach ($getPreferenceProducts as $eachLine) {
                $preferenceproducts[] = $eachLine['product_id'];
            }
            if (!empty($preferenceproducts)) {
                $getProductNames = $ci->common->gettbldata("id IN (" . implode(',', $preferenceproducts) . ") ", "name", "tb_products_master", 0, 0);
                foreach ($getProductNames as $eachLine) {
                    $productNames[] = $eachLine['name'];
                }
            }
            if (empty($productNames) || in_array($orderDetails['product'], $productNames, true)) {
                $productCheckCondition = 1;
            }
        }
        $referenceCheckCondition = $ci->ratemanagement->preference_checkrefandorcondition($orderDetails['id'], $ratePreferenceRowId);
        if (in_array(0, [$productCheckCondition ?? 1, $serviceCheckCondition ?? 1, $orderTypeCheckCondition ?? 1, $referenceCheckCondition], true)) {
            return 0;
        }
        return 1;
    }

    private function getAllGeneralData(array $legIds, int $orderId): array
    {
        $ci =& get_instance();
        $orderDetails = $ci->Orderrevenuesmodel->getOrderDetailsForRates($orderId);
        $getLegDetails = $ci->common->gettbldata("id IN (" . implode(',', $legIds) . ") AND status =1", "id,shipmentid,vendor_id", "tb_shifts", 0, 0);
        $vendorIds = $partyIds = [];
        foreach ($getLegDetails as $eachLine) {
            $legsData[$eachLine['id']] = ['rowId' => $eachLine['id'], 'shipmentId' => $eachLine['shipmentid'], 'vendorId' => $eachLine['vendor_id']];
            $vendorIds[] = $eachLine['vendor_id'];
        }
        if (!empty($vendorIds)) {
            $vendorIds = array_unique($vendorIds);
            $getVendorDetails = $ci->common->gettbldata("id IN (" . implode(',', $vendorIds) . ") AND status =1", "id,name,code", "tb_vendors", 0, 0);
            foreach ($getVendorDetails as $eachLine) {
                $vendorDetails[$eachLine['id']] = $eachLine['code'];
                $vendorNames[$eachLine['id']] = $eachLine['name'];
            }
        }
        $getStopsDetails = $ci->common->gettbldata("shipment_id IN (" . implode(',', $legIds) . ") AND status =1", "id,stopcity,stoptype,shipment_id,stop_party_id", "tb_shiporder_stops", 0, 0);
        foreach ($getStopsDetails as $eachLine) {
            $stops[$eachLine['shipment_id']][strtoupper($eachLine['stoptype'])] = ['shipmentId' => $eachLine['shipment_id'], 'stopType' => $eachLine['stoptype'], 'rowId' => $eachLine['id'], 'partyRowId' => $eachLine['stop_party_id']];
            $partyIds[] = $eachLine['stop_party_id'];
        }
        if (!empty($partyIds)) {
            $partyIds = array_unique($partyIds);
            $getPartyLocationDetails = $ci->common->gettbldata("id IN (" . implode(',', $partyIds) . ") AND status =1", "id,name,location_id,country,state,division_name,sub_district,pincode", "tbl_party_master", 0, 0);
            foreach ($getPartyLocationDetails as $eachLine) {
                $partyAddresses[$eachLine['id']] = ['id' => $eachLine['id'], 'name' => $eachLine['name'], 'city' => $eachLine['location_id'], 'country' => $eachLine['country'], 'state' => $eachLine['state'], 'divisionName' => $eachLine['division_name'], 'subDistrict' => $eachLine['sub_district'], 'pincode' => $eachLine['pincode']];
            }
        }
        return ['partyAddresses' => $partyAddresses ?? [], 'stops' => $stops ?? [], 'legsData' => $legsData ?? [], 'vendorDetails' => $vendorDetails ?? [], 'orderDetails' => $orderDetails, 'vendorNames' => $vendorNames];
    }
}

?>
