<?php

class ReportCWGLibrary
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['Datatables_model', 'ReportCWGModel']);
    }

    public function getWhereCondition(array $postData): string
    {
        $subWhereCondition = [];
        $whereCondition[] = "o.status !=0";
        $userIds = $this->getUserIds();
        if (!empty($userIds)) {
            $whereCondition[] = $userIds;
        }
        if (!empty($postData['fromDate'])) {
            $whereCondition[] = $this->getDateWhereCondition((string)$postData['fromDate'], 's.created_on', 'from');
        }
        if (!empty($postData['toDate'])) {
            $whereCondition[] = $this->getDateWhereCondition((string)$postData['toDate'], 's.created_on', 'to');
        }
        if (!empty($postData['earlyPickup'])) {
            $whereCondition[] = $this->getDateWhereCondition((string)$postData['earlyPickup'], 'o.pickup_datetime', 'from');
        }
        if (!empty($postData['lateDelivery'])) {
            $whereCondition[] = $this->getDateWhereCondition((string)$postData['lateDelivery'], 'o.drop_endtime', 'to');
        }

        if (!empty($postData['tripId'])) {
            $subWhereCondition[] = $this->getInWhereCondition($postData['tripId'], 's.shipmentid');
        }
        if (!empty($postData['bookingId'])) {
            $subWhereCondition[] = $this->getInWhereCondition($postData['bookingId'], 'o.order_id');
        }
        if (!empty($postData['truckNum'])) {
            $subWhereCondition[] = "td.register_number = " . "'" . $postData['truckNum'] . "'";
        }
        if (empty($subWhereCondition)) {
            return implode(' AND ', $whereCondition);
        }
        if (count($subWhereCondition) > 1) {
            return implode(' AND ', $whereCondition) . " and (" . implode(' OR ', $subWhereCondition) . ")";
        }
        return implode(' AND ', $whereCondition) . " and " . implode(' AND ', $subWhereCondition);
    }

    public function getDateWhereCondition(string $date, string $columnName, string $condition): string
    {
        $getCondition = ($condition === 'from') ? '>=' : '<=';
        $fromDate = date('Y-m-d', strtotime($date));
        return "DATE_FORMAT($columnName,'%Y-%m-%d')" . $getCondition . '"' . $fromDate . '"';
    }

    public function getInWhereCondition($data, string $columnName): string
    {
        $getString = "'" . implode("','", $data) . "'";
        return $columnName . " in ($getString)";
    }

    public function getCWGReportData(array $postData): array
    {
        $whereCondition = $this->getWhereCondition($postData);
        $indexColumn = 'o.id';
        $excludeCountQuery = 'Yes';
        $curtz = $this->ci->session->userdata("usr_tzone")['timezone'];
        $groupBy = 'o.id';
        $table_name = 'tb_shifts as s';
        $joinsArray[] = ['table_name' => 'tb_orders as o', 'condition' => "s.id=o.shift_id", 'join_type' => 'inner'];
        $joinsArray[] = ['table_name' => 'tb_order_cargodetails as oc', 'condition' => "oc.order_id=o.id and oc.status='1'", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_cargo_details as cd', 'condition' => "oc.cargo_id=cd.id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_shft_veh as sv', 'condition' => "s.id=sv.shft_id", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_trucks_data as td', 'condition' => "td.id=sv.vehicle_id and td.status='Active'", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_pod_uploads as p', 'condition' => "p.order_id=o.id and p.status='1' and p.stop_type='D'", 'join_type' => 'left'];
        $joinsArray[] = $this->getStatusJointTable('ss', '3000', 'D');
        $joinsArray[] = $this->getStatusJointTable('st', '0191', 'P');
        $joinsArray[] = $this->getStatusJointTable('et', '0192', 'D');
        $joinsArray[] = $this->getStatusJointTable('at', '2300', 'D');
        $selectColumns = [
            "o.id,o.order_id,GROUP_CONCAT(DISTINCT cd.goods_description) goodsDescription,
             s.shipmentid as tripId,td.register_number as vehicleRegNum,td.truck_number as VehicleTrailerRegNum,
             s.vehicle_type,
             convertToClientTZ(o.pickup_datetime,'" . $curtz . "') as estimatedPickup,
             o.pickup_company as shipperName,o.pickup_city,o.pickup_address1 as shipperStreet,o.pickup_pincode,o.pickup_country,
             o.delivery_company as consigneeName,o.delivery_city,o.delivery_address1 as consigneeStreet,o.delivery_pincode,o.delivery_country,
             convertToClientTZ(o.drop_endtime,'" . $curtz . "') as estimatedDelivery,
             p.id as podId,
             convertToClientTZ(ss.createdon,'" . $curtz . "') as deliveryDate,
             convertToClientTZ(st.createdon,'" . $curtz . "') as tripStartTime,
             convertToClientTZ(et.createdon,'" . $curtz . "') as tripEndTime,
             convertToClientTZ(at.createdon,'" . $curtz . "') as actualArrivalDate,"
        ];
        $dataTableSortOrdering = [];
        $getRecordListing = $this->ci->Datatables_model->datatablesQuery(
            $selectColumns,
            $dataTableSortOrdering,
            $table_name,
            $joinsArray,
            $whereCondition,
            $indexColumn,
            'TRUE',
            $groupBy,
            $excludeCountQuery,
            'POST'
        );
        $getOrderCount = $this->ci->ReportCWGModel->getOrderCount($whereCondition, $postData);
        $orderCount = (!empty($getOrderCount)) ? (int)$getOrderCount['count'] : 0;
        return ['data' => $getRecordListing['data'], 'getRecordListing' => $getRecordListing, 'ordersCount' => $orderCount];
    }

    public function getStatusJointTable(string $alias, string $statusCode, string $stopType): array
    {
        return [
            'table_name' => 'tb_stop_status as ' . $alias,
            'condition' => "$alias.order_id=o.id and $alias.status_code = '$statusCode' and $alias.stop_type='$stopType' and $alias.status='1' ",
            'join_type' => 'left'
        ];
    }

    public function getDataTableRecords(array $orderData)
    {
        $i = 0;
        $recordListing = [];
        foreach ($orderData as $res) {
            $estimatedPickup = $this->getDateTime($res['estimatedPickup'] ?? '');
            $estimatedDelivery = $this->getDateTime($res['estimatedDelivery'] ?? '');
            $actualArrival = $this->getDateTime($res['actualArrivalDate'] ?? '');
            $OrderLocation = $this->getOrderLocation($res);
            $deliveryOnTime = $this->getDeliveryOnTime($res);
            $TotalJourneyTime = $this->getTotalJourneyTime($res);
            $tripLength = $this->getTripLength($res);
            $checkBox = '<div class="checkbox checkbox-info">
                                 <label>
                                    <input type="checkbox" class="chckbox" name="check_box" id="' . $res['id'] . '" data-row-id="' . $res['id'] . '">
                                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                 </label>
                              </div>';
            $j = 0;
            $recordListing[$i][0] = $checkBox;
            $recordListing[$i][++$j] = $i + 1;
            $recordListing[$i][++$j] = $res['order_id'] ?? '';
            $recordListing[$i][++$j] = $res['goodsDescription'] ?? '';
            $recordListing[$i][++$j] = $res['tripId'] ?? '';
            $recordListing[$i][++$j] = $res['vehicleRegNum'] ?? '';
            $recordListing[$i][++$j] = $res['vehicle_type'] ?? '';
            $recordListing[$i][++$j] = $res['VehicleTrailerRegNum'] ?? '';
            $recordListing[$i][++$j] = $estimatedPickup['date'] ?? '';
            $recordListing[$i][++$j] = $estimatedPickup['time'] ?? '';
            $recordListing[$i][++$j] = $OrderLocation['shipper'] ?? '';
            $recordListing[$i][++$j] = $OrderLocation['consignee'] ?? '';
            $recordListing[$i][++$j] = $estimatedDelivery['date'] ?? '';
            $recordListing[$i][++$j] = $estimatedDelivery['time'] ?? '';
            $recordListing[$i][++$j] = $res['tripStartTime'] ?? '';
            $recordListing[$i][++$j] = $res['tripEndTime'] ?? '';
            $recordListing[$i][++$j] = $tripLength ?? '';
            $recordListing[$i][++$j] = $actualArrival['date'] ?? '';
            $recordListing[$i][++$j] = $actualArrival['time'] ?? '';
            $recordListing[$i][++$j] = empty($res['podId']) ? 'N' : 'Y';
            $recordListing[$i][++$j] = $TotalJourneyTime;
            $recordListing[$i][++$j] = $deliveryOnTime['onTime'];
            $recordListing[$i][++$j] = $deliveryOnTime['delayTime'];
            $i++;
        }
        return json_encode($recordListing, JSON_THROW_ON_ERROR);
    }

    public function getTripLength(array $orderData)
    {
        $pickup = $orderData['shipperStreet'] . ', ' . $orderData['pickup_city'] . ', ' . $orderData['pickup_pincode'] . ', '
            . $orderData['pickup_country'];
        $delivery = $orderData['consigneeStreet'] . ', ' . $orderData['delivery_city'] . ', ' . $orderData['delivery_pincode'] . ', '
            . $orderData['delivery_country'];
        $url = 'https://maps.googleapis.com/maps/api/distancematrix/json?origins=' . $pickup . '&destinations=' . $delivery . '&key=' . GOOGLE_BKND_API_KEY;
        $getDistanceMatrix = ProcessGoogleAPICurl($url);
        return $getDistanceMatrix['rows'][0]['elements'][0]['distance']['text'] ?? '';
    }

    public function getTotalJourneyTime(array $orderData): string
    {
        if (empty($orderData['tripStartTime']) && $orderData['tripStartTime'] !== "0000-00-00 00:00:00" &&
            empty($orderData['tripEndTime']) && $orderData['tripEndTime'] !== "0000-00-00 00:00:00") {
            return '';
        }
        $minutesDiff = (int)((strtotime($orderData['tripEndTime']) - strtotime($orderData['tripStartTime'])) / 60);
        if ($minutesDiff > 0) {
            return $minutesDiff . ' minutes';
        }
        return '';
    }

    public function getDeliveryOnTime(array $orderData): array
    {
        if (empty($orderData['deliveryDate']) || $orderData['deliveryDate'] === "0000-00-00 00:00:00" ||
            empty($orderData['estimatedDelivery']) || $orderData['estimatedDelivery'] === "0000-00-00 00:00:00") {
            return ['delayTime' => '', 'onTime' => ''];
        }
        $hourDiff = (int)((strtotime($orderData['deliveryDate']) - strtotime($orderData['estimatedDelivery'])) / 3600);
        if ($hourDiff > 0) {
            return ['delayTime' => $hourDiff . ' hours', 'onTime' => 'N'];
        }
        return ['delayTime' => '', 'onTime' => 'y'];
    }


    public function getDateTime($timeStamp): array
    {
        $timeStamp = $timeStamp ?? '';
        if (empty($timeStamp)) {
            return ['date' => '', 'time' => ''];
        }
        $date = date('Y-m-d', strtotime($timeStamp));
        $time = date('H:i:s', strtotime($timeStamp));
        return ['date' => $date, 'time' => $time];
    }

    public function getOrderLocation(array $orderData): array
    {
        $getPartyCodes = $this->ci->ReportCWGModel->getPartyCodes((string)$orderData['id']);
        return [
            'shipper' => $getPartyCodes['shipperId'] . ', ' . $orderData['shipperName'] . ', '
                . $orderData['shipperStreet'] . ', ' . $orderData['pickup_city'] . ', ' . $orderData['pickup_pincode'],
            'consignee' => $getPartyCodes['consigneeId'] . ', ' . $orderData['consigneeName'] .
                ', ' . $orderData['consigneeStreet'] . ', ' . $orderData['delivery_city'] . ', ' . $orderData['delivery_pincode']
        ];
    }


    public function getUserIds(): string
    {
        $userId = $this->ci->session->userdata("user_id");
        $countryUserIds = $this->ci->session->userdata("country_user_ids");
        if ($userId === '0') {
            return "";
        }
        if (!empty($countryUserIds)) {
            $uIds = implode(',', $countryUserIds);
            if ($uIds !== '') {
                $uIds = $this->ci->db->escape_str($uIds);
                return " o.user_id in ($uIds)";
            }
        }
        $userId = $this->ci->db->escape_str($userId);
        return "o.user_id = $userId";
    }

}

?>
