<?php

use App\Generators\RandomString;
use phpseclib\Net\SFTP;

class Roadlogsalogdocument
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'roadlogtosalogmodel','Singlestatusmodel']);
    }

    public function sendDocumentToSlog(array $postdata): void
    {
        $orderId = $postdata['order_id'];
        log_message("error", "SALOG JPL File Genearatuon 3" . json_encode($postdata));
        $checkCustomer = $this->ci->roadlogtosalogmodel->getCustomerDetails($orderId);
        if (!empty($checkCustomer)) {
            $ediPODFile = 0;
            $orderId = $checkCustomer['id'];
            $customerId = $checkCustomer['customer_id'];
            $userId = $checkCustomer['user_id'];
            $ustomerName = $checkCustomer['name'];
            $companyCode = $checkCustomer['company_code'];
            $branchCode = $checkCustomer['branch_code'];
            $createdSource = $checkCustomer['created_source'];
            $customerCid = $checkCustomer['phone'];
            $customerCode = $checkCustomer['code'];
            $pickupCity = $checkCustomer['pickup_city'];
            $deliveryCity = $checkCustomer['delivery_city'];
            $pickupAddress1 = $checkCustomer['pickup_address1'];
            $deliveryAddress1 = $checkCustomer['delivery_address1'];
            $orderNumber = $checkCustomer['order_id'];
            $orderCompanyCode = $checkCustomer['order_company_code'];
            $orderDocuments = $this->ci->roadlogtosalogmodel->getOrderDocuments($pickupAddress1, $pickupCity, $deliveryCity, $orderNumber, $orderId);
            if ($orderDocuments->num_rows() > 0) {
                if (checkAccessConditions('SEND_EPOD_TO_SALOG_COUNTRIES', $orderCompanyCode)) {
                    $getPODFileInfo = $this->ci->common->fetchRecordsByCustomQry("SELECT imgpath FROM tb_pod_uploads WHERE stop_type = ? AND doc_type = ? AND order_id = ?",['D',3,(int)$orderRequest['ord_id']],false);
                    if ($getPODFileInfo) {
                        $PODFile = NEW_POD_PATH . $getPODFileInfo['imgpath'];
                        if (file_exists($PODFile)) {
                            $ediPODFile = 1;
                        }
                    }
                }
                $data['order'] = ["order_id" => $orderNumber, "pickup_address1" => $pickupAddress1, "delivery_address1" => $deliveryAddress1];
                $data['userid'] = $userId;
                $epodpath = "./assets/trippods/RL" . $orderNumber . ".pdf";
                $data["pod"] = $orderDocuments;
                $data["orderref"] = $this->ci->common->getallorderreferences($orderId);
                $refvalue = $orderDepartmentCode = "";
                $departmentCode = $this->ci->common->gettblrowdata(['order_row_id' => $orderId], "department_code", "tb_order_details", 0, 0);
                if (!empty($departmentCode)) {
                    $orderDepartmentCode = $departmentCode['department_code'];
                }
                $data['pickup_datetime'] = "";
                $data['delivery_datetime'] = "";
                $stops = $this->ci->roadlogtosalogmodel->getShipmentStops($postdata['shipment_id']);
                if (!empty($stops)) {
                    foreach ($stops as $stop) {
                        if ($stop['status_id'] === "1" && $stop['stop_type'] === "P") {
                            $data['pickup_datetime'] = $stop['createdon'];
                        }
                        if ($stop['status_id'] === "1" && $stop['stop_type'] === "D") {
                            $data['delivery_datetime'] = $stop['createdon'];
                        }
                    }
                }
                $this->ci->load->library('m_pdf');
                $html = $this->ci->load->view('settings/bulkepod', $data, true);
                $this->ci->m_pdf->pdf->WriteHTML($html);
                $this->ci->m_pdf->pdf->Output($epodpath, "F");
                $uniqueId = "RL" . $orderNumber . "." . date("Ymd") . "." . date("his");
                $pagescnt = $this->ci->m_pdf->pdf->pages;
                $pages = count($pagescnt);
                /* SALog JPL*/
                $checkOOrderReference = $this->ci->roadlogtosalogmodel->getOrderReferences($orderId);
                $bookingNumber = $innComRef = $invoiceNumber = $deliveryNoteTRN = $country = $branch = $trackingNumber = "";
                if (!empty($checkOOrderReference)) {
                    foreach ($checkOOrderReference as $orderReference) {
                        if ($orderReference->reference_id == "BN") {
                            $bookingNumber = $orderReference->ref_value;
                        }
                        if ($orderReference->reference_id == "INN") {
                            $innComRef = $orderReference->ref_value;
                        }
                        if ($orderReference->reference_id == "IV") {
                            $invoiceNumber = $orderReference->ref_value;
                        }
                        if ($orderReference->reference_id == "TRN") {
                            $deliveryNoteTRN = $orderReference->ref_value;
                        }
                        if ($orderReference->reference_id == "CMP") {
                            $country = $orderReference->ref_value;
                        }
                        if ($orderReference->reference_id == "BRN") {
                            $branch = $orderReference->ref_value;
                        }
                        if ($orderReference->reference_id == "XSR") {
                            $trackingNumber = $orderReference->ref_value;
                        }
                    }
                }
                if ($country == "") {
                    $country = $companyCode;
                }
                if ($branch == "") {
                    $branch = $branchCode;
                }
                $countrycode = substr($companyCode, 0, -2);
                $randomstr = RandomString::generate(10);
                $jplData = [
                    "country" => $country,
                    "branch" => $branch,
                    "order_id" => $orderNumber,
                    "time" => date("hi"),
                    "unique_id" => $uniqueId,
                    "date" => date("d.m.Y"),
                    "pages" => $pages,
                    "xsr" => $trackingNumber,
                    "sd" => $orderDepartmentCode,
                    "bn" => $bookingNumber,
                    "inn" => $innComRef,
                    "iv" => $invoiceNumber,
                    "dq" => $deliveryNoteTRN,
                    "custcid" => $customerCid,
                    "custcode" => $customerCode,
                    "countrycode" => $countrycode,
                    "randomstr" => $randomstr,
                    "doctype" => 171
                ];
                $jplFilePath = $this->saveSalogJPF($jplData);
                $this->uploadSalogKNFile($jplFilePath);
                if ($ediPODFile === 1) {
                    $this->uploadSalogKNFile($PODFile);
                } else {
                    $this->uploadSalogKNFile($epodpath);
                }
            }
        }
    }

    public function saveSalogJPF($jplData)
    {
        $orderNumber = $jplData["order_id"];
        $file_path = self::getJplPath($orderNumber);
        $jplData["unique_id"] = basename($file_path, ".jpl");
        $file_path = "./assets/jpl_files/RL$orderNumber.jpl";
        $content = $this->ci->load->view("jpl_salogtemplate", $jplData, true);
        $fp = fopen($file_path, "wb");
        fwrite($fp, $content);
        fclose($fp);
        return $file_path;
    }

    private static function getJplPath(int $orderId): string
    {
        $path = "./assets/jpl_files/RL$orderId.jpl";
        $attempt = 0;
        while (file_exists($path) && $attempt < 100) {
            ++$attempt;
            $path = "./assets/jpl_files/RL" . $orderId . '_' . $attempt . ".jpl";
        }
        return $path;
    }

    public function uploadSalogKNFile($localfile)
    {
        $remotefile = basename($localfile);
        $sftp_url = SALOG_FTP;
        $username = SALOG_FTP_USER;
        $password = SALOG_FTP_PWD;
        $folder_name = "/pub/inbound/D3/IF";
        try {
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                unset($sftp);
                log_message("error", "Cannot login into your SWIFTLOG MTF Test server !");
            } else {
                $sftp->chdir($folder_name);
                $sftp->put($folder_name . "/" . $remotefile, $localfile, SFTP::SOURCE_LOCAL_FILE);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, SWIFTLOG MTF Test server, Please Try Again Later.");
        }
    }

    public function sendCarrierPODtoRoadlog(int $orderRowId, string $documentType, CI_Controller $CI): string
    {
        $getOrderDetails = $this->ci->roadlogtosalogmodel->getRoadlogOrderDetails($orderRowId,$documentType);
        if (empty($getOrderDetails)) {
            return "ePOD Sending failed!";
        }
        foreach ($getOrderDetails as $order) {
            $data = [
                "order_id" => $order['id'],
                "ord_id" => $order['order_id'],
                'country_code' => $order['country_code'],
                'company_code' => $order['company_code'],
                'branch_code' => $order['branch_code'],
                'shipment_id' => $order['shift_id'],
                'trip_id' => $order['trip_id'],
                'stop_id' => ($order['type_name'] == "POD") ? $order['drop_stopid'] : $order['stop_id'],
                'doc_type' => $order['type_name'],
                'userid' => $order['user_id'],
                'filename' => $order['imgpath']
            ];
            try {
                $this->ci->Singlestatusmodel->pushOrderDocumentsToRoadlog($data,$CI);
            } catch (Exception $ex) {
                log_message("error", "roadlog SFTP: document failed to send!  " . $ex->getMessage());
            }
        }
        return 1;
    }
}
