<?php
class Roadmatics
{
    private const LOCATION_REQUIRED = false;
    private const RESPONSE_LIMIT = 100;

    public function getAllVehicles(): array
    {
        $vehicleData = $vehicleList = [];
        $currentPageNo = 0;
        $url = 'http://api.ilogistek.com:6604/list';
        $vehiclesList = $this->getVehiclesList($url);
        if ($vehiclesList && isset($vehiclesList['VehicleList']) && is_array($vehiclesList['VehicleList'])) {
            $vehicleList = array_merge($vehiclesList, $vehicleLocation['VehicleList']);
        }
        return $vehiclesList;
    }

    private function getLocation(string $url): array
    {
        $vehicleData = [];
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
    
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
    
        $request->setHeader([
            'Content-Type' => 'application/x-www-form-urlencoded'
        ]);
    
        $request->addPostParameter([
            'sKey' => 'PV7q60SurjJIcfQ1c45Xcq83d8r5hbQ4SiWtfYktoL'
        ]);
    
        $request->setConfig([
            'follow_redirects' => true,
            'ssl_verify_peer' => true,
            'ssl_verify_host' => true,
            'connect_timeout' => 100,
            'timeout' => 120
        ]);
    
        $curlAdapter = new HTTP_Request2_Adapter_Curl();
        $request->setAdapter($curlAdapter);
    
        try {
            $response = $request->send();
    
            if ($response->getStatus() == 200) {
                $vehicleData = json_decode($response->getBody(), true);
            } else {
                log_message(
                    "error",
                    'HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase()
                );
            }
        } catch (HTTP_Request2_Exception $e) {
            log_message("error", 'Roadmatics Vehicle Location Error: ' . $e->getMessage());
        }
    
        return $vehicleData;
    }

    public function getUnknownRegisterNumbers(array $orders, array $registerNumbers): array
    {
        $knownRegisterNumbers = [];
        $unknownRegisterNumbersFromApi = [];
        foreach($orders as $order) {
            $knownRegisterNumbers[] = $order['register_number'];
        }
        foreach ($registerNumbers as $registerNumber) {
            if (!in_array($registerNumber, $knownRegisterNumbers)) {
                $unknownRegisterNumbersFromApi[] = $registerNumber;
            }
        }
        return $unknownRegisterNumbersFromApi;
    }
    
    
}