<?php

/**
 * eTn To SALog PUP and POD integrate services
 **/

use phpseclib\Net\SFTP;

class Salogintegrateservice
{
    private const POD_VALUE = 746;
    private const PUP_VALUE = 171;
    private const TRIP_DOCUMENT_PATH = "./assets/trippods/";
    private const JPL_PATH = "./assets/jpl_files/";
    private const SALOG_POD_PATH = "/pub/inbound/D3/IF";
    private int $loginCounter = 10;
    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model("common");
        $this->ci->load->helper("log_helper");
        $this->ci->load->library("m_pdf");
    }

    public function sendePodToSalog($orderRequest = [], $orderType = null)
    {
        $salogStatus = 0;
        if(empty($orderRequest)){
            return;
        }
        if (in_array($orderType, ['DEL', 'PUP'])) {
            $ediPODFile = 0;
            $whereCondition = ["o.id" => $orderRequest['ord_id']];
            $select = "o.id,o.order_id,o.pickup_address1,o.delivery_address1,o.user_id,o.company_code,o.branch_code,c.name,c.phone,c.code";
            $orderTable = "tb_orders o";
            $customerTable = "tb_customers c";
            $joinWhere = "o.customer_id=c.id";
            $this->ci->db->select($select);
            $this->ci->db->from($orderTable);
            $this->ci->db->join($customerTable, $joinWhere, "INNER");
            $this->ci->db->where($whereCondition);
            $this->ci->db->limit(1);
            $orderResult = $this->ci->db->get();
            if ($orderResult->num_rows() > 0) {
                $data['order'] = $orderData = $orderResult->row_array();
                if (checkAccessConditions('SEND_EPOD_TO_SALOG_COUNTRIES', $orderData["company_code"])) {
                    $getPODFileInfo = $this->ci->common->fetchRecordsByCustomQry("SELECT imgpath FROM tb_pod_uploads WHERE stop_type = ? AND doc_type = ? AND order_id = ?",['D',3,(int)$orderRequest['ord_id']],false);
                    if ($getPODFileInfo) {
                        $PODFile = NEW_POD_PATH . $getPODFileInfo['imgpath'];
                        if (file_exists($PODFile)) {
                            $ediPODFile = 1;
                        }
                    }
                }
                $orderTimeZone = ($this->ci->session->userdata("usr_tzone")) ? $this->ci->session->userdata("usr_tzone")["timezone"] : "";
                if($orderTimeZone == "") {
                    $getTimeZone = getbytimezonebyusr($orderData["user_id"],$orderData["company_code"]);
                    if(!empty($getTimeZone)){
                        $orderTimeZone = $getTimeZone["timezone"];
                    }
                    $orderTimeZone = $orderTimeZone ?? date_default_timezone_get();
                }
                $podWhereCondition = [
                    "ts.order_id" => $orderData['id'],
                    "ts.status" => 1
                ];
                if($orderType == "PUP"){
                    $podWhereCondition["dt.type_name"] = "PUP";
                }else{
                    $podWhereCondition["dt.type_name <>"] = "PUP";
                }
                if (checkAccessConditions('SEND_DOCUMENTS_BASED_ON_SALOG_SDT_REF', $orderData["company_code"])) {
                    $getSdtType = $this->ci->common->gettblrowdata(['order_id' => $orderData["id"], 'reference_id' => 'SDT', 'status' => 1], "ref_value", "tb_order_references", 0, 0);
                    $sdtType = '';
                    if (!empty($getSdtType)) {
                        $sdtType = $getSdtType["ref_value"];
                    }
                    if ($sdtType != $orderType) {
                        return;
                    }
                }
                $this->ci->db->select("ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,convertToClientTZ(ts.createdon, '".$orderTimeZone."') as createdon, ts.imgpath, ts.hash");
                $this->ci->db->from("tb_pod_uploads ts");
                $this->ci->db->join("tb_document_types dt","dt.id=ts.doc_type","INNER");
                $this->ci->db->where($podWhereCondition);
                $this->ci->db->group_by("ts.id");
                $this->ci->db->order_by("ts.createdon","ASC");
                $data["pod"] = $this->ci->db->get();
                if($data["pod"]->num_rows() > 0){
                    $ePodPath = getEpodPath($orderData["order_id"]);
                    /* get all order references in single row*/
                    $data["orderref"] = $this->ci->common->getallorderreferences($orderData["id"]);
                    $data["pickup_datetime"] = $data["delivery_datetime"] = "";
                    $statusWhereCondition = [
                        "order_id" => $orderData["id"],
                        "status" => 1,
                        "status_id" => 1
                    ];
                    $this->ci->db->select("stop_type,status_id,convertToClientTZ(createdon, '".$orderTimeZone."') as createdon");
                    $this->ci->db->from("tb_stop_status");
                    $this->ci->db->where($statusWhereCondition);
                    $this->ci->db->order_by("createdon","ASC");
                    $stopStatus = $this->ci->db->get();
                    if($stopStatus->num_rows()>0){
                        foreach($stopStatus->result() as $orderStatus){
                            if($orderStatus->status_id=="1" && $orderStatus->stop_type == "P"){
                                $data["pickup_datetime"] = $orderStatus->createdon;
                            }
                            if($orderStatus->status_id=="1" && $orderStatus->stop_type == "D"){
                                $data["delivery_datetime"] = $orderStatus->createdon;
                            }
                        }
                    }
                    $html = $this->ci->load->view("settings/bulkepod",$data,true);
                    $this->ci->m_pdf->resetInstance();
                    $writeHtml = @$this->ci->m_pdf->pdf->WriteHTML($html);
                    $storePod = @$this->ci->m_pdf->pdf->Output($ePodPath,"F");
                    $pages = $this->ci->m_pdf->pdf->pages;
                    $pagesCount = count($pages);
                    $jplData = $this->getJPLData($orderData,$orderType);
                    $jplData["pages"]=$pagesCount;
                    $jplData["epod_path"] = $ePodPath;
                    $jplFilePath = $this->saveSalogJPF($jplData);
                    $filesList = $ediPODFile === 1 ? [$PODFile,$jplFilePath] : [$ePodPath,$jplFilePath];
                    $salogStatus = $this->uploadSalogKNFiles($filesList)['status'];
                }
            }
        }
        return $salogStatus;
    }

    function getJPLData($orderData,$orderType){
        $trackValue = $orderDepartmentCode = $bnValue = $innValue = $dqValue = "";
        /*get department code for this order*/
        $departmentCode = $this->ci->common->gettblrowdata(["order_row_id"=>$orderData["id"]],"department_code","tb_order_details",0,0);
        if(!empty($departmentCode)){
            $orderDepartmentCode = $departmentCode["department_code"];
        }
        $companyCode = $orderData["company_code"];
        $branchCode = $orderData["branch_code"];
        $orderRefWhereCondition = [
            "order_id" => $orderData["id"],
            "ref_value <>" => ""
        ];
        $this->ci->db->select("reference_id,ref_value");
        $this->ci->db->from("tb_order_references");
        $this->ci->db->where($orderRefWhereCondition);
        $this->ci->db->group_by("reference_id");
        $orderReferences = $this->ci->db->get();
        if($orderReferences->num_rows()>0){
            foreach($orderReferences->result() as $referenceData){
                if($referenceData->reference_id == "BN"){
                    $bnValue = $referenceData->ref_value;
                }
                if($referenceData->reference_id == "INN"){
                    $innValue = $referenceData->ref_value;
                }
                if($referenceData->reference_id == "XSR"){
                    $trackValue = $referenceData->ref_value;
                }
                if($referenceData->reference_id == "DQ"){
                    if (isset($trackValue->ref_value) && strlen($trackValue->ref_value) < 11 && (strpos($trackValue->ref_value, 'O') === false)) {
                        $dqValue = $referenceData->ref_value;
                    }
                }
                if($referenceData->reference_id == "CMP" && $referenceData->ref_value != ""){
                    $companyCode = $referenceData->ref_value;
                }
                if($referenceData->reference_id == "BRN" && $referenceData->ref_value != ""){
                    $branchCode = $referenceData->ref_value;
                }
            }
        }
        $countryCode = substr($companyCode,0,-2);
        $randomString = $this->generateRandomString(10);
        $documentTypeValue = ($orderType == "PUP") ? self::PUP_VALUE : self::POD_VALUE;
        $uniqueId = "RL".$orderData["order_id"].".".date("Ymd").".".date("his");
        $jplData = [
            "country"=>$companyCode,
            "branch"=>$branchCode,
            "order_id"=>$orderData["order_id"],
            "time"=>date("hi"),
            "unique_id"=>$uniqueId,
            "date"=>date("d.m.Y"),
            "xsr"=>$trackValue,
            "sd"=>$orderDepartmentCode,
            "bn"=>$bnValue,
            "inn"=>$innValue,
            "dq"=>$dqValue,
            "custcid"=>$orderData["phone"],
            "custcode"=>$orderData["code"],
            "countrycode"=>$countryCode,
            "randomstr"=>$randomString,
            "doctype"=>$documentTypeValue
        ];
        return $jplData;
    }
    /*generate random string*/
    function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = "";
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    /*generate jpl file*/
    public function saveSalogJPF($jplData){
        $content = $this->ci->load->view("jpl_salogtemplate",$jplData,TRUE);
        $baseName = basename($jplData["epod_path"], ".pdf");
        $file_path =  "./assets/jpl_files/".$baseName.".jpl";
        $fp = fopen($file_path,"wb");
        fwrite($fp,$content);
        fclose($fp);
        return $file_path;
    }

    private function uploadSalogKNFiles(array $files): array
    {
        $sftp = new SFTP(SALOG_FTP);
        if (!$sftp->login(SALOG_FTP_USER, SALOG_FTP_PWD)) {
            log_error("Salog SFTP: Cannot login into your SALog MTF Test server ! ".$files[0]);
            return $this->repeatLogin($files);
        }
        $sftp->chdir(self::SALOG_POD_PATH);
        foreach ($files as $file) {
            $sftp->put(self::SALOG_POD_PATH . "/" . basename($file), $file, SFTP::SOURCE_LOCAL_FILE);
        }
        unset($sftp);
        return ['status' => 1];
    }

    private function repeatLogin(array $files): array
    {
        if (!$this->loginCounter--) {
            log_error("Salog SFTP: login failed! ".json_encode($files));
            return ['status' => 0];
        }
        sleep(random_int(2, 5));
        log_message("error", "SALOG SFTP, retry login " . $this->loginCounter . " on failure");
        return $this->uploadSalogKNFiles($files);
    }
}
