<?php

class SearchService
{
    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['Order']);
    }

    public function searchForBookingIds(string $searchValue): array
    {
        $countryUserIds = $this->ci->session->userdata("country_user_ids");
        if (!($userId = $this->ci->session->userdata('user_id'))) {
            return [];
        }

        $getOrderIds = !empty($countryUserIds)
            ? $this->ci->Order->getcountryuserorderids($userId, $countryUserIds, $searchValue)
            : $this->ci->Order->getorderids($userId, [], $searchValue);
        foreach ($getOrderIds->result() as $res) {
            $data[] = ["id" => $res->order_id, "text" => $res->order_id];
        }
        return $data ?? [];
    }

    public function searchForTripIds(string $searchValue): array
    {
        $this->ci->load->model(['Tatkpimodel']);
        $countryUserIds = $this->ci->session->userdata("country_user_ids");
        if (!($userId = $this->ci->session->userdata('user_id'))) {
            return [];
        }
        $getTripIds = !empty($countryUserIds)
            ? $this->ci->Tatkpimodel->getCountryUserTripIds($userId, $countryUserIds, $searchValue)
            : $this->ci->Tatkpimodel->getTripIds($userId, [], $searchValue);
        foreach ($getTripIds as $res) {
            $data[] = ["id" => $res['shipmentid'], "text" => $res['shipmentid']];
        }
        return $data ?? [];
    }
}
