<?php
class Sms
{
	public function send($params)
	{
		require_once(APPPATH.'libraries/Sendsms.php');
		$smsObj = new sendsms("alerts.sinfini.com/api/", "115948kz7517216zm1sl", "RTRUCK");
		try{
			$sendingdt = date('Y-m-d H:i:s');
			$res = $smsObj->send_sms(trim($params['mobile']), $params['message'], SITEURL, "xml");
			$this->saveLog($params,$res,$sendingdt);
		}catch(Exception $e){

		}
	}
	/**
	 * To save sms sending request into logs
	 * @param array $params
	 * @param string $res
	 * @param date $senddate
	 * @return void
	 */
	private function saveLog($params,$res=null,$senddate=null)
	{
		$p1 = isset($params['trip_id']) ? $params['trip_id'] : 0;
		$p2 = isset($params['emp_id']) ? $params['emp_id'] : 0;
		$p3 = isset($params['latitude']) ? $params['latitude'] : '';
		$p4 = isset($params['longitude']) ? $params['longitude'] : '';
		$p5 = isset($params['register_number']) ? $params['register_number'] : '';
		$p6 = isset($params['alert_reason']) ? $params['alert_reason'] : '';
		$p7 = isset($params['status']) ? $params['status'] : 1;
		$res = isset($res) ? $res : "";
		if($res != ""){
			$response = $res;
		}else{
			$response = "";
		}
		if($senddate == ""){
			$senddate = date('Y-m-d H:i:s');
		}
		$data = array(
					'module'=>$params['module'],
					'sent_to'=>trim($params['mobile']),
					'message'=>$params['message'],
					'user_id'=>$params['user_id'],
					'callcenter'=>0,
					'sent_on'=>$senddate,
					'trip_id'=>$p1,
					'emp_id'=>$p2,
					'latitude'=>$p3,
					'longitude'=>$p4,
					'register_number'=>$p5,
					'alert_reason'=>$p6,
					'status'=>$p7,
					'response'=>$response
				);
		$ci = & get_instance();
		$ci->db->insert("tbl_sms_logs",$data);
		$id=$ci->db->insert_id();
		$data1=array('sms_log_id'=>$id,'sent_to'=>trim($params['mobile']),'message'=>$params['message'],'createdon'=>date('Y-m-d H:i:s'));
		$ci->db->insert("tb_modem_sms",$data1);
		return true;
	}

    function share_secure_link($message, $phone_numbers = array())
    {
        $recipients = array();
        if (sizeof($phone_numbers) > 0) {
            foreach ($phone_numbers as $key => $value) {
                $recipients[] = array(
                    "dst" => "$value"
                );
            }
        }
        // encoding is changed to STANDARD to avoid Carrier Reception issues
        $request = array(
            "options" => array(
                "src" => "K + N Road",
                "encoding" => "STANDARD",
                "billcode" => "Billingcode",
                "statusRequested" => true,
                "flash" => false, "validityMin" => 5,
                "maxParts" => 2,
                "invalidCharacters" => "TRANSLITERATE",
                "qos" => "EXPRESS", "duplicateDetection" => false
            ),
            "messages" => array(
                array(
                    "text" => $message,
                    "recipients" => $recipients
                )
            )
        );
        $ci = &get_instance();
        $ci->load->helper('curlfun');
        $response = share_secure_link($request);
        if ($response['err'] != "") {
            $response = $response['err'];
            $status = '0';
        } else {
            $response = $response['response'];
            $status = '1';
        }
        $this->sms_log($ci, $request, $response, $phone_numbers, $status);
        return $status;
    }

    function sms_log($ci, $request, $response, $phone_numbers, $status)
    {
        $user_id = 0;
        $company_code = 'FRKN';
        $branch_code = 'FRKN';
        $ci->load->model('common');
        $params = array(
            'edi_type' => 1, //'1->EDI Transport Order,2->EDI Status,3->SMS Gateway'
            'transaction_id' => time(),
            'edi_id' => 17, // edi id based on name take it from tb_edi_types
            'edi_name' => 'Retarus Rest API',
            'bounded_type' => 2, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => 'JSON',
            'status' => $status,
            'obj_type' => 3,
            'txn_obj_id' => implode(',', $phone_numbers),
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'edi_request' => json_encode($request),
            'edi_response' => json_encode($response)
        );
        $ci->common->insertTableData('tb_etn_edi_transactions', $params);
    }
}
