<?php

class Standard_document_execution
{
    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'standarddocumentmodel', 'altovaordercreationmodel']);
    }

    public function sendStandardDocumentXMLtoAltova(array $documentdata): void
    {
        return;
        $altovaCustomer = $this->ci->altovaordercreationmodel->checkAltovaCustomer($documentdata['order_id']);
        if ($altovaCustomer == 0) {
            log_message("error", "Customer Does not have permission to send order to Altova " . $documentdata['order_id']);
            return;
        }
        $getorderinfo = $this->ci->common->gettblrowdata(['id' => $documentdata['order_id']], 'shift_id,trip_id,shipmentid,customer_id,logicalreceiver,physicalreceiver,physicalsender,logicalsender,company_code,branch_code,plat,plng,dlat,dlng,created_source', 'tb_orders', 0, 0);
        if (empty($getorderinfo)) {
            return;
        }
        $data['orderinfo'] = $documentdata;
        $customer_id = $getorderinfo['customer_id'];
        $data['orderinfo']['shipmentid'] = $getorderinfo['shipmentid'];
        $branch_code = $documentdata['branch_code'];
        $customer = $this->ci->common->gettblrowdata(["id" => $customer_id], "*", "tb_customers", 0, 0);
        $customerdetails = $customer;
        $customerdetails['references'] = $this->ci->common->getPartyReferences($customer_id);
        $data['customer_details'] = $customerdetails;
        $data["orderinfo"]['logicalreceiver'] = $getorderinfo['logicalreceiver'];
        $data["orderinfo"]['physicalreceiver'] = $getorderinfo['physicalreceiver'];
        $data["orderinfo"]['physicalsender'] = $getorderinfo['physicalsender'];
        if ("" == $getorderinfo['logicalsender']) {
            $logicalinfo = $this->ci->common->gettblrowdata(['branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
            if (count($logicalinfo) > 0) {
                $logicalsender = $logicalinfo['logical_sender'];
            }
            $data["orderinfo"]['logicalsender'] = $logicalsender;
        }
        $data["orderReferences"] = $this->ci->altovaordercreationmodel->getOrderReferences($documentdata['order_id']);
        $this->pushDocumentXMLtoAltova($data);
    }

    private function pushDocumentXMLtoAltova(array $data): void
    {
        $tansctionno = date("Ymdhis") . "_KN" . $data['orderinfo']['order_id'];
        $code = $data['orderinfo']['country_code'];
        $legids = $this->ci->standarddocumentmodel->getOrderLegs($data);
        $dqvalue = $this->ci->standarddocumentmodel->getOrderReference($data['orderinfo']['order_id']);
        $requestXML = "<?xml version='1.0' encoding='UTF-8'?>
    <SVKEDIMessage>
      <SVKEDITransmissionHeader>
        <EDIVersion>6.3.1</EDIVersion>
        <SenderTransmissionNo>" . $tansctionno . "</SenderTransmissionNo>
        <AckSpec>
          <AckOption>ERROR</AckOption>
        </AckSpec>
        <SourceApp>ETRA</SourceApp>
        <DestinationApp>ETRA</DestinationApp>
        <Action>Document</Action>
      </SVKEDITransmissionHeader>
      <SVKEDITransmissionBody>
        <eTNOrgDetails>
            <Companycode>" . $data['orderinfo']['company_code'] . "</Companycode>
            <Branchcode>" . $data['orderinfo']['branch_code'] . "</Branchcode>
            <Departmentcode>" . $data['orderinfo']['branch_code'] . "</Departmentcode>
            <PhysicalReceiver>" . $data['orderinfo']['physicalreceiver'] . "</PhysicalReceiver>
            <LogicalReceiver>" . $data['orderinfo']['logicalreceiver'] . "</LogicalReceiver>
            <PhysicalSender>" . $data['orderinfo']['physicalsender'] . "</PhysicalSender>
            <LogicalSender>" . $data['orderinfo']['logicalsender'] . "</LogicalSender>
        </eTNOrgDetails>
        <OrderDocument>
            <OrderID>" . $data['orderinfo']['ord_id'] . "</OrderID>
            <TripID>" . $data['orderinfo']['shipmentid'] . "</TripID>";
        if ($legids != "") {
            $requestXML .= $legids;
        } else {
            $requestXML .= "<LegID>" . $legids . "</LegID>";
        }
        $requestXML .= "<CustRef>" . $dqvalue . "</CustRef>
                    <CarRef></CarRef>
                    <CustomerDetails>
                 <ID> " . $data['customer_details']['code'] . "</ID>
                <Company>
                    <Name> " . $data['customer_details']['name'] . "</Name>
                    <RegistrationNumber> " . $data['customer_details']['code'] . "</RegistrationNumber>
                </Company>
                <Address>
                    <CustomerName> " . $data['customer_details']['name'] . "</CustomerName>
                    <Address1> " . $data['customer_details']['address'] . "</Address1>
                    <Address2> " . $data['customer_details']['address'] . "</Address2>
                    <Street> " . $data['customer_details']['code'] . "</Street>
                    <City> " . $data['customer_details']['location'] . "</City>
                    <State> " . $data['customer_details']['location'] . "</State>
                    <Postal> " . $data['customer_details']['pincode'] . "</Postal>
                    <Country> " . $data['customer_details']['country'] . "</Country>
                    <ContactNo>
                        <CountryCode> " . $code . "</CountryCode>
                        <ContactNo> " . $data['customer_details']['phone'] . "</ContactNo>
                        <EmailAddress> " . $data['customer_details']['email_id'] . "</EmailAddress>
                    </ContactNo>
                </Address> ";
        if (count($data['customer_details']['references']) > 0) {
            $requestXML .= "<PartyReference> ";
            foreach ($data['customer_details']['references'] as $partyref) {
                $requestXML .= "<References><RefType><Code> " . str_replace(" ", "_", $partyref['name']) . "</Code><Value> " . $partyref['value'] . "</Value></RefType></References> ";
            }
            $requestXML .= " </PartyReference>";
        }

        $requestXML .= "</CustomerDetails><ManageReferences>";
        if (count($data['orderReferences']) > 0) {
            foreach ($data['orderReferences'] as $reference) {
                $requestXML .= "<References>";
                $requestXML .= "<RefType>";
                $requestXML .= "<Code>" . $reference['reference_id'] . "</Code>";
                $requestXML .= "<Value>" . $reference['ref_value'] . "</Value>";
                $requestXML .= "</RefType>";
                $requestXML .= "</References>";
            }
        }

          $requestXML .= "</ManageReferences><DocumentUpload>";
        $requestXML .= $this->getDocumentXml($data);
        $requestXML .= "</DocumentUpload></OrderDocument>
              </SVKEDITransmissionBody>
            </SVKEDIMessage> ";

        $filename = "documment_" . date('Ymd') . "SVK" . $data['orderinfo']['ord_id'] . ".xml";
        $localfile = "./xml/tripoutbound/" . $filename;
        log_message("error", "Status XML filename  for NZPG" . $localfile);
        if (!file_exists(dirname($localfile))) {
            if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                throw new \RuntimeException(sprintf('Directory " % s" was not created', $concurrentDirectory));
            }
        }
        file_put_contents($localfile, $requestXML);
        $this->sendDocumentXML($requestXML);
    }

    private function getDocumentXml(array $data): string
    {
        $arrContextOptions = [
            "ssl" => [
                "verify_peer" => false,
                "verify_peer_name" => false,
            ],
        ];
        $requestXML = "";
        $getOrderDoc = $this->ci->common->getjointbldata("tb_pod_uploads tpu", "tb_document_types tdt", "tpu.doc_type = tdt.id", ['tpu.order_id' => $data['orderinfo']['order_id'], 'tpu.status' => '1'], "tpu.`imgpath`,tdt.`document_id`,tdt.`type_name`,tdt.id as documentid ", 0, 0);
        if (!empty($getOrderDoc)) {
            $requestXML .= "<DocumentFormat>Base64encode</DocumentFormat>";
            foreach ($getOrderDoc as $orderDoc) {
                $document_id = $orderDoc['document_id'] ?? $orderDoc['documentid'];
                $imagetype = pathinfo($orderDoc['imgpath'], PATHINFO_EXTENSION);
                $imglink = base_url(checkimageintmsorknlmv($orderDoc['imgpath'], false));
                $response = file_get_contents($imglink, false, stream_context_create($arrContextOptions));
                $base64_code = base64_encode($response);
                $requestXML .= " <Document>
				<DocumentType>" . $imagetype . "</DocumentType>
				<DocumentName>" . $orderDoc['type_name'] . "</DocumentName>
				<DocumentCode>" . $document_id . "</DocumentCode>
				<DocumentFile>" . $base64_code . "</DocumentFile>
				<DocumentURL>" . $imglink . "</DocumentURL>
			</Document>";
            }
        }
        return $requestXML;
    }

    private function sendDocumentXML($requestXML): void
    {
        log_message("error", "sendTollXML Request to Altova" . json_encode($requestXML));
        $data = 'inputFiles=' . $requestXML;
        $curl = curl_init(ALTOVA_ORDER_DOCUMENT_URL);
        curl_setopt($curl, CURLOPT_URL, ALTOVA_ORDER_DOCUMENT_URL);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $headers = ["Content-Type: application/x-www-form-urlencoded"];
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        $resp = curl_exec($curl);
        if ($resp === false) {
            log_message('error', 'sendElg360order request failed: ' . curl_error($curl));
        }
        log_message("error", "sendTollXML Response" . $resp);
        curl_close($curl);
    }

}
