<?php

class Standard_status_execution
{
    private $ci;

    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'standardstatusmodel', 'altovaordercreationmodel']);
    }

    public function sendStandardXMLtoAltova(array $status_data): void
    {
        $isValid = $this->validate_status($status_data['status_code']);
        if ($isValid['valid'] == true) {
            if (count($status_data) == 0) {
                log_message("error", "Standard Status Info: data not available");
                return;
            }
        }
        $altovaCustomer = $this->ci->altovaordercreationmodel->checkAltovaCustomer($status_data['ord_id']);
        if ($altovaCustomer == 0) {
            log_message("error", "Customer Does not have permission to send order to Altova " . $status_data['ord_id']);
            return;
        }
        $data['status_string'] = $isValid['status_string'];
        $data['status_data'] = $status_data;
        $logicalsender = "";
        $customerdetails = [];
        $getorderinfo = $this->ci->common->gettblrowdata(['id' => $status_data['ord_id']], 'shift_id,trip_id,shipmentid,customer_id,logicalreceiver,physicalreceiver,physicalsender,logicalsender,company_code,branch_code,plat,plng,dlat,dlng,created_source,user_id', 'tb_orders', 0, 0);
        if (empty($getorderinfo)) {
            return;
        }
        $branchCode = $getorderinfo['branch_code'];
        $customerId = $getorderinfo['customer_id'];
        $data['orderinfo'] = $getorderinfo;
        $customer = $this->ci->common->gettblrowdata(["id" => $customerId], "*", "tb_customers", 0, 0);
        $customerdetails = $customer;
        $customerdetails['references'] = $this->ci->common->getPartyReferences($customerId);
        $data['customer_details'] = $customerdetails;
        $logicalinfo = $this->ci->common->gettblrowdata(['branch_code' => $branchCode], "logical_sender", "tb_branch_master", 0, 0);
        if (count($logicalinfo) > 0) {
            $logicalsender = $logicalinfo['logical_sender'];
        }
        $data["orderinfo"]['logicalsender'] = $logicalsender;
        $data["orderReferences"] = $this->ci->altovaordercreationmodel->getOrderReferences($status_data['ord_id']);
        $this->pushStandardXMLtoAltova($data);
    }

    private function pushStandardXMLtoAltova(array $data): void
    {
        $curtz = $data['status_data']['timezone'];
        $lgusrid = $data['orderinfo']['user_id'];
        if ($data["status_data"]['stop_type'] === "P") {
            if ($data['orderinfo']['plat'] != "") {
                $pickupLatitude = $data['orderinfo']['plat'];
                $pickupLongitude = $data['orderinfo']['plng'];
            } else {
                $checkLatitudeLongitudes = $this->ci->standardstatusmodel->getLatitudeLongitude($lgusrid);
                if (!empty($checkLatitudeLongitudes)) {
                    $pickupLatitude = $checkLatitudeLongitudes->latitude;
                    $pickupLongitude = $checkLatitudeLongitudes->longitude;
                }
            }
            $latitude = $pickupLatitude;
            $longitude = $pickupLongitude;
        } else {
            if ($data['orderinfo']['dlat'] != "") {
                $deliveryLatitude = $data['orderinfo']['dlat'];
                $deliveryLongitude = $data['orderinfo']['dlng'];
            } else {
                $checkLatitudeLongitudes = $this->ci->standardstatusmodel->getLatitudeLongitude($lgusrid);
                if (!empty($checkLatitudeLongitudes)) {
                    $deliveryLatitude = $checkLatitudeLongitudes->latitude;
                    $deliveryLongitude = $checkLatitudeLongitudes->longitude;
                }
            }
            $latitude = $deliveryLatitude;
            $longitude = $deliveryLongitude;
        }

        if ($longitude !== "") {
            $locationName = getLocationName($latitude, $longitude);
        }
        $data['locationName'] = $locationName;
        $data['latitude'] = $latitude;
        $data['longitude'] = $longitude;

        $statusdate = getdatetimebytimezone($curtz, $data['status_data']['sts_date'], DFLT_TZ);
        $data['statusdatetime'] = $statusdate['datetime'];
        $shiftId = $data["status_data"]['ship'] ?? $data['orderinfo']['shift_id'];
        $data['drivername'] = $this->ci->standardstatusmodel->getshipmentDrivername($shiftId);
        $orderStatusXMl = $this->generateOrderStatusXML($data);
        $orderStatusXMl = str_replace(['&', 'amp;', ';'], ['AND', '', ','], $orderStatusXMl);
        $filename = "Status_" . date('Ymd') . "SVK" . $data['orderinfo']['shipmentid'] . ".xml";
        $localfile = "./xml/tripoutbound/" . $filename;
        log_message("error", "Status XML filename  name" . $localfile);
        if (!file_exists(dirname($localfile))) {
            if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                throw new \RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
            }
        }
        file_put_contents($localfile, $orderStatusXMl);

        $this->sendStatusXML($orderStatusXMl);
    }

    private function generateOrderStatusXML(array $data): string
    {
        $tansctionno = date("Ymdhis") . "_KN" . $data['status_data']['orderid'];
        $getUserTimeZone = $this->ci->altovaordercreationmodel->getOrderUserTimeZone($data['orderinfo']['user_id']);
        $company_code = $data['orderinfo']['company_code'];
        $curtz = $getUserTimeZone['cntry_timezone'];
        $hrs = $getUserTimeZone['cntry_hrs'];
        $currency = $getUserTimeZone['currency'] ?? "SGD";
        $countryCode = [
            "THKN" => 66,
            "SGKN" => 65,
            "INKN" => 91
        ];
        $code = $getUserTimeZone['phone_code'] ?? $countryCode[$company_code];

        $requestXML = "<?xml version='1.0' encoding='UTF-8'?>
    <SVKEDIMessage>
      <SVKEDITransmissionHeader>
        <EDIVersion>6.3.1</EDIVersion>
        <SenderTransmissionNo>" . $tansctionno . "</SenderTransmissionNo>
        <AckSpec>
          <AckOption>ERROR</AckOption>
        </AckSpec>
        <SourceApp>ETRA</SourceApp>
        <DestinationApp>ALTOVA</DestinationApp>
        <Action>BookingStatusUpdate</Action>
      </SVKEDITransmissionHeader>
      <SVKEDITransmissionBody>
        <eTNOrgDetails>
            <Companycode>" . $data['orderinfo']['company_code'] . "</Companycode>
            <Branchcode>" . $data['orderinfo']['branch_code'] . "</Branchcode>
            <Departmentcode>" . $data['orderinfo']['branch_code'] . "</Departmentcode>
            <PhysicalReceiver>" . $data['orderinfo']['physicalreceiver'] . "</PhysicalReceiver>
            <LogicalReceiver>" . $data['orderinfo']['logicalreceiver'] . "</LogicalReceiver>
            <PhysicalSender>" . $data['orderinfo']['physicalsender'] . "</PhysicalSender>
            <LogicalSender>" . $data['orderinfo']['logicalsender'] . "</LogicalSender>
        </eTNOrgDetails>
        <Order>
            <OrderID>" . $data['status_data']['orderid'] . "</OrderID>
            <ShipmentID>" . $data['orderinfo']['shipmentid'] . "</ShipmentID>
            <TripID>" . $data['orderinfo']['shipmentid'] . "</TripID>
            <CustomerDetails>
                <ID>" . $data['customer_details']['code'] . "</ID>
                <Company>
                    <Name>" . $data['customer_details']['name'] . "</Name>
                    <RegistrationNumber>" . $data['customer_details']['code'] . "</RegistrationNumber>
                </Company>
                <Address>
                    <CustomerName>" . $data['customer_details']['name'] . "</CustomerName>
                    <Address1>" . $data['customer_details']['address'] . "</Address1>
                    <Address2>" . $data['customer_details']['address'] . "</Address2>
                    <Street>" . $data['customer_details']['code'] . "</Street>
                    <City>" . $data['customer_details']['location'] . "</City>
                    <State>" . $data['customer_details']['location'] . "</State>
                    <Postal>" . $data['customer_details']['pincode'] . "</Postal>
                    <Country>" . $data['customer_details']['country'] . "</Country>
                    <ContactInfo>
                        <CountryCode>" . $code . "</CountryCode>
                        <ContactNo>" . $data['customer_details']['phone'] . "</ContactNo>
                        <EmailAddress>" . $data['customer_details']['email_id'] . "</EmailAddress>
                    </ContactInfo>
                </Address>";
        if (count($data['customer_details']['references']) > 0) {
            $requestXML .= "<PartyReference>";
            foreach ($data['customer_details']['references'] as $partyref) {
                $requestXML .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
            }
            $requestXML .= " </PartyReference>";
        }

        $requestXML .= "</CustomerDetails><ManageReferences>";
        if (count($data['orderReferences']) > 0) {
            foreach ($data['orderReferences'] as $reference) {
                $requestXML .= "<References>";
                $requestXML .= "<RefType>";
                $requestXML .= "<Code>" . $reference['reference_id'] . "</Code>";
                $requestXML .= "<Value>" . $reference['ref_value'] . "</Value>";
                $requestXML .= "</RefType>";
                $requestXML .= "</References>";
            }
        }
        $requestXML .= "</ManageReferences>
                          <Status>
                        <StatusCode>" . $data['status_data']['status_code'] . "</StatusCode>
                        <StatusValue>" . $data['status_string'] . "</StatusValue>
                        <StatusType>" . $data['status_data']['stop_type'] . "</StatusType>
                        <DateTime>" . str_replace(" ", "T", $data['statusdatetime']) . $hrs ."</DateTime>
                        <TimeZone>" . $data['status_data']['timezone'] . "</TimeZone>
                        <Lat>" . $data['latitude'] . "</Lat>
                        <Lng>" . $data['longitude'] . "</Lng>
                        <Location>" . $data['locationName'] . "</Location>
                        <ActionUser>" . $data['drivername'] . "</ActionUser>
                        <Comments></Comments>
                    </Status>
                </Order>
              </SVKEDITransmissionBody>
            </SVKEDIMessage>";
        return $requestXML;
    }

    private function sendStatusXML($requestXML): void
    {
        try {
            log_message("error", "sendTollXML Request to Altova" . json_encode($requestXML));
            $data = 'inputFiles=' . $requestXML;
            $curl = curl_init(ALTOVA_ORDER_STATUS_URL);
            curl_setopt($curl, CURLOPT_URL, ALTOVA_ORDER_STATUS_URL);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $headers = ["Content-Type: application/x-www-form-urlencoded"];
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            $resp = curl_exec($curl);
            if ($resp === false) {
                log_message('error', 'sendElg360order request failed: ' . curl_error($curl));
            }
            log_message("error", "sendTollXML Response" . $resp);
            curl_close($curl);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Status to Altova. " . $ex->getMessage());

        }
    }

    private function validate_status(string $status): array
    {
        $data = [];
        $result = false;
        $status_list = [
            "0212",
            "0420",
            "0500",
            "0191",
            "1550",
            "0192",
            "2300",
            "3000",
            "0218"
        ];
        $result = in_array($status, $status_list);

        if ($result) {
            $result = true;
            switch ($status) {
                case "0212":
                    $status_string = "DRIVER ACCEPTED";
                    break;
                case "0420":
                    $status_string = "ORIGIN_GATE_IN";
                    break;
                case "0500":
                    $status_string = "PICKUP";
                    break;
                case "0191":
                    $status_string = "ORIGIN_GATE_OUT";
                    break;
                case "1550":
                    $status_string = "IN_TRANSIT";
                    break;
                case "0192":
                    $status_string = "DESTINATION_GATE_IN";
                    break;
                case "2300":
                    $status_string = "DELIVERY";
                    break;
                case "3000":
                    $status_string = "DESTINATION_GATE_OUT";
                    break;
                case "0218":
                    $status_string = "CLOSE";
                    break;
                default:
                    $status_string = "";
            }
        } else {
            $result = false;
            $status_string = "";
            log_message("error", "Standard Status Info: Invalid status string.");
        }

        return ["valid" => $result, "status_string" => $status_string];
    }

}
