<?php

use App\Integrations\Salog\ePod\AbstractXMLData;
use App\Integrations\Salog\ePod\IntegrationService;
use App\PodUploads\Constants\DocumentType;

class Standarddocumenthandler
{
    private $ci;

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->library(['roadlogsalogdocument', 'standard_document_execution']);
        $ci->load->model(['Singlestatusmodel', 'Roadlogtosalogmodel', 'standardstatusmodel']);
    }

    public function insertOrderDocument(array $postXMLData): array
    {
        try {
            $orderDocumentinfo = $this->readOrderDocumentXML($postXMLData);
            if (array_key_exists("status", $orderDocumentinfo) && $orderDocumentinfo['status'] == "Failed") {
                return $orderDocumentinfo;
            }
            $response = $this->orderDocumentUpdate($orderDocumentinfo);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While inserting the Order Status " . $ex->getMessage());
        }
        return $response ?? [];
    }

    private function readOrderDocumentXML(array $postXMLData): array
    {
        $orderHeader = $postXMLData['SVKEDITransmissionHeader'];
        $orderInfo = $postXMLData['SVKEDITransmissionBody'];
        if (!array_key_exists("OrderDocument", $orderInfo)) {
            log_message("error", "Wrong XML was Triggered: " . json_encode($postXMLData));
            return ['status' => "Failed", "status_code" => "404", 'message' => "Wrong XML was Triggered"];
        }
        $orderID = !empty($orderInfo['OrderDocument']['OrderID']) ? $orderInfo['OrderDocument']['OrderID'] : "";
        if ($orderID == "") {
            log_message("error", "There is no Booking ID for: " . json_encode($postXMLData));
            return ['status' => "Failed", "status_code" => "404", 'message' => "Booking ID Empty"];
        }

        $headerdata = [
            "EDIVersion" => $orderHeader['EDIVersion'] ?? "",
            "SenderTransmissionNo" => $orderHeader['SenderTransmissionNo'] ?? "",
            "AckOption" => $orderHeader['AckSpec']['AckOption'] ?? "",
            "EmailAddress" => $orderHeader['AckSpec']['EmailAddress'] ?? "",
            "SourceApp" => $orderHeader['SourceApp'] ?? "",
            "DestinationApp" => $orderHeader['DestinationApp'] ?? "",
            "Action" => $orderHeader['Action'] ?? ""
        ];
        if (empty($orderInfo['OrderDocument']['DocumentUpload'])) {
            log_message("error", "DocumentUpload Tag is Missing for: " . json_encode($postXMLData));
            return ['status' => "Failed", "status_code" => "401", 'message' => "DocumentUpload Tag is Missing"];
        }
        if (array_key_exists("0", $orderInfo['OrderDocument']['DocumentUpload']) == 1) {
            foreach ($orderInfo['OrderDocument']['DocumentUpload'] as $documents) {
                $documentData[] = [
                    "OrderID" => $orderInfo['OrderDocument']['OrderID'],
                    "DocumentType" => $documents['DocumentType'],
                    "DocumentName" => $documents['DocumentName'],
                    "DocumentCode" => $documents['DocumentCode'],
                    "DocumentFile" => $documents['DocumentFile'],
                    "DocumentURL" => $documents['DocumentURL'],
                    "DocumentDateTime" => $documents['DocumentDateTime'],
                ];
            }
        } else {
            $documentData[] = [
                "OrderID" => $orderInfo['OrderDocument']['OrderID'],
                "DocumentType" => $orderInfo['OrderDocument']['DocumentUpload']['DocumentType'],
                "DocumentName" => $orderInfo['OrderDocument']['DocumentUpload']['DocumentName'],
                "DocumentCode" => $orderInfo['OrderDocument']['DocumentUpload']['DocumentCode'],
                "DocumentFile" => $orderInfo['OrderDocument']['DocumentUpload']['DocumentFile'],
                "DocumentURL" => $orderInfo['OrderDocument']['DocumentUpload']['DocumentURL'],
                "DocumentDateTime" => $orderInfo['OrderDocument']['DocumentUpload']['DocumentDateTime'],
            ];
        }

        return $documentData ?? [];
    }

    private function orderDocumentUpdate(array $orderDocumentData): array
    {
        $ci = &get_instance();
        foreach ($orderDocumentData as $orderDocumentinfo) {
            $bookingId = $orderDocumentinfo['OrderID'];
            $tripInformation = $ci->standardstatusmodel->getTripInformation($bookingId);
            if (empty($tripInformation)) {
                return ['status' => "Failed", "status_code" => "401", 'message' => "Invalid Booking ID"];
            }
            $orderid = $tripInformation['orderid'];
            $ci->edi_logger->setTxn_obj_id($orderid);
            $shift_id = $tripInformation['shift_id'];
            $trip_id = $tripInformation['trip_id'];
            $carrier_id = $tripInformation['carrier_id'];
            $driver_id = $tripInformation['driver_id'];
            $vehicle_id = $tripInformation['vehicle_id'];
            $company_code = $tripInformation['company_code'];
            $branch_code = $tripInformation['branch_code'];
            $user_id = $tripInformation['user_id'];
            $ci->edi_logger->setUser_id($user_id);
            $ci->edi_logger->setCompany_code($company_code);
            $ci->edi_logger->setBranch_code($branch_code);
            $documentName = $orderDocumentinfo['DocumentName'];
            if (empty($documentName)) {
                return ['status' => "Failed", "status_code" => "401", 'message' => "Empty Document Name Tag Received"];
            }
            $documentURL = $orderDocumentinfo['DocumentURL'];
            $documentFile = $orderDocumentinfo['DocumentFile'];
            if (empty($documentFile)) {
                return ['status' => "Failed", "status_code" => "401", 'message' => "Empty Document File Tag Received"];
            }
            $documentType = $orderDocumentinfo['DocumentType'];
            if (empty($documentType)) {
                return ['status' => "Failed", "status_code" => "401", 'message' => "Empty Document Type Tag Received"];
            }
            $documentDateTime = !empty($orderDocumentinfo['DocumentDateTime']) ? $orderDocumentinfo['DocumentDateTime'] : date('Y-m-d H:i:s');
            $userTimeZone = $ci->Singlestatusmodel->getUsersTimezone($user_id);
            $documentDateTime = (getdatetimebytimezone(DFLT_TZ, $documentDateTime, $userTimeZone))['datetime'];
            $documentFileName = $ci->Singlestatusmodel->podImageFolder($documentFile, $documentType);
            if ($documentFileName === '') {
                return ['status' => "Failed", "status_code" => "401", 'message' => "Document File Name empty: Document Upload failed "];
            }
            $getOrderStopDetails = $ci->common->gettblrowdata(['order_id' => $bookingId], '`stop_id`,`drop_stopid`,id AS stop_detail_id', 'tb_employee', 0, 0);
            if (!empty($getOrderStopDetails)) {
                $stop_id = $getOrderStopDetails['stop_id'];
                $drop_stopid = $getOrderStopDetails['drop_stopid'];
                $stop_detail_id = $getOrderStopDetails['stop_detail_id'];
                $created_source = $tripInformation['created_source'];
            }
            $stop_type = ($documentName == "POD") ? "D" : "P";
            $stop_value = ($documentName == "POD") ? $drop_stopid : $stop_id;
            $orderDocumentType = $ci->Singlestatusmodel->getDocumentType($documentName);
            $uploadDocumentData = [
                "order_id" => $orderid,
                "trip_id" => $trip_id,
                "shipment_id" => $shift_id,
                "user_id" => $user_id,
                "doc_type" => $orderDocumentType,
                "stop_type" => $stop_type,
                "stop_id" => $stop_value,
                "stop_detail_id" => $stop_detail_id,
                "createdby" => $driver_id,
                "latitude" => "",
                "longitude" => "",
                "carrier_pod_trigger" => 1,
                "imgpath" => $documentFileName,
                "createdon" => str_replace("T", " ", $documentDateTime),
            ];
            $ci->common->insertTableData("tb_pod_uploads", $uploadDocumentData);

            $getCountryCode = $ci->common->gettblrowdata(['user_id' => $user_id], 'country_code', 'tbl_country_master', 0, 0);
            $countryCode = $getCountryCode['country_code'] ?? '65';
            $documentData = [
                "order_id" => $bookingId,
                "ord_id" => $orderid,
                'country_code' => $countryCode,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'shipment_id' => $shift_id,
                'trip_id' => $trip_id,
                'stop_id' => $stop_id,
                'userid' => $user_id,
                'filename' => $documentFileName
            ];
            if ($created_source == 18) {
                $documentData['doc_type'] = DocumentType::DOCUMENT_NAME_MAPPING[$documentName];
                $ci->Singlestatusmodel->pushOrderDocumentsToRoadlog($documentData);
            }

            if ($created_source == 5) {
                $salogXmlData = AbstractXMLData::getDataProvider($orderDocumentType);
                $salogePodIntegrationService = new IntegrationService();
                $salogePodIntegrationService->sendePod(
                    $salogXmlData->getData($shift_id, $trip_id, $stop_id, $bookingId, $orderid, $tripInformation['plat'], $tripInformation['plng']),
                    $salogXmlData->getOrderType()
                );
            }

            try {
                $documentData['doc_type'] = $orderDocumentType;
                $ci->standard_document_execution->sendStandardDocumentXMLtoAltova($documentData);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order Documentto Altova " . $ex->getMessage());
            }
        }

        return ['status' => "Success", "status_code" => "200", 'message' => "Document Uploaded Successfully"];
    }
}
