<?php

class Standardoutboundhandler
{
    private $ci;

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->helper('Log');
        $ci->load->model(['common', 'Standardstatusmodel']);
    }

    public function sendOrderStatusoutbound(array $customerOrdersList, array $externalStatusCode, string $partyType): string
    {
        $ci = &get_instance();
        $orderDetails = [];
        foreach ($customerOrdersList as $orderDetails) {
            if ($orderDetails['customerlinks']['category_type'] == "KN Office") {
                $orderDetails['statusList'] = $ci->Standardstatusmodel->getInternalCustomersOrderStatusList($orderDetails['orderids'], $partyType);
            }
            if (!empty($externalStatusCode)) {
                if ($orderDetails['customerlinks']['category_type'] == "External") {
                    $orderDetails['statusList'] = $ci->Standardstatusmodel->getExternalCustomersOrderStatusList($orderDetails['orderids'], $externalStatusCode, $partyType);
                }
            }
            if ($partyType == "Carrier") {
                $orderDetails['statusList'] = $ci->Standardstatusmodel->getInternalCustomersOrderStatusList($orderDetails['orderids'], $partyType);
            }

            if (!empty($orderDetails['statusList'])) {
                foreach ($orderDetails['statusList'] as $orders) {
                    $response [] = $this->sendOrderStatusXML($orders, $orderDetails['customerlinks'], $partyType);
                }
            } else {
                log_message("error", "There is no Status are available for Triggering.");
            }
        }

        return "success";
    }

    public function sendDocumentOutBound(array $customerOrderDetails, string $partyType): string
    {
        $ci = &get_instance();
        $response = [];
        foreach ($customerOrderDetails as $orderDetails) {
            $orderDetails['documents'] = $ci->Standardstatusmodel->getOrderDocuments($orderDetails['orderids'], $partyType);
            if (!empty($orderDetails['documents'])) {
                $response [] = $this->sendOrderDocumentXML($orderDetails, $partyType);
            }
        }
        return "success";
    }

    private function sendOrderDocumentXML(array $orderDetails, string $partyType): void
    {
        $ci = &get_instance();
        $arrContextOptions = [
            "ssl" => [
                "verify_peer" => false,
                "verify_peer_name" => false,
            ],
        ];
        foreach ($orderDetails['documents'] as $orders) {
            $tansctionno = date("Ymdhis") . "_KN" . $orders['order_id'];
            $documentType = pathinfo($orders['imgpath'], PATHINFO_EXTENSION);
            $filePath = NEW_POD_PATH . $orders['imgpath'];
            $base64DocumentData = base64_encode(file_get_contents($filePath));
            $timeZone = $ci->Standardstatusmodel->getUserTimeZone($orders['user_id']);
            $documentDates = getdatetimebytimezone($timeZone, $orders['createdon'], DFLT_TZ);
            $documentDateTime = $documentDates['datetime'];
            $ci->edi_logger->setEdi_type(2);
            $ci->edi_logger->setTxn_obj_id($orders['orderid']);
            $ci->edi_logger->setUser_id($orders['user_id']);
            $ci->edi_logger->setCompany_code($orders['company_code']);
            $ci->edi_logger->setBranch_code($orders['branch_code']);
            $ci->edi_logger->setTransaction_id(time());
            $ci->edi_logger->setEdi_id("39");
            $ci->edi_logger->setEdi_name('Document Outbound');
            $ci->edi_logger->setBounded_type(2);
            $ci->edi_logger->setEdi_format_type('XML');

            $requestXML = "<?xml version='1.0' encoding='UTF-8'?>
            <SVKEDIMessage>
              <SVKEDITransmissionHeader>
                <EDIVersion>6.3.1</EDIVersion>
                <SenderTransmissionNo>" . $tansctionno . "</SenderTransmissionNo>
                <AckSpec>
                  <AckOption>ERROR</AckOption>
                </AckSpec>
                <SourceApp>ETRA</SourceApp>
                <DestinationApp>" . $orderDetails['customerlinks']['customer_name'] . "</DestinationApp>
                <Action>Document</Action>
              </SVKEDITransmissionHeader>
              <SVKEDITransmissionBody>
              <OrderDocument>
			<OrderID>" . $orders['order_id'] . "</OrderID>
			<DocumentUpload>
					<DocumentType>" . $documentType . "</DocumentType>
					<DocumentName>" . $orders['type_name'] . "</DocumentName>
					<DocumentCode>" . $orders['document_id'] . "</DocumentCode>
					<DocumentFile>" . $base64DocumentData . "</DocumentFile>
					<DocumentURL></DocumentURL>
					<DocumentDateTime>" . str_replace(" ", "T", $documentDateTime) . "</DocumentDateTime>
					</DocumentUpload>
		</OrderDocument>
	</SVKEDITransmissionBody>
</SVKEDIMessage>";
            $requestXML = str_replace(";", "", $requestXML);
            $requestXML = str_replace("&", "&amp;", $requestXML);
            $ci->edi_logger->setEdi_request($requestXML);
            $filename = "DocumentOutbound_" . $tansctionno . ".xml";
            $localfile = "./xml/documentoutbound/" . $filename;
            log_message("error", "Document XML for " . $orders['order_id'] . ": URL " . $localfile);
            if (!file_exists(dirname($localfile))) {
                if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                    throw new \RuntimeException(sprintf('Directory " % s" was not created', $concurrentDirectory));
                }
            }
            file_put_contents($localfile, $requestXML);
            $webResponse = $this->sendDocumentXML($requestXML, $orderDetails['customerlinks'], $orders['order_id']);
            if (!empty($webResponse)) {
                if (isset($orders['podrowid'])) {
                    if ($partyType == "Customer") {
                        $ci->common->updatetbledata("tb_pod_uploads", ['customer_pod_trigger' => 1], ['id' => $orders['podrowid']]);
                    }
                    if ($partyType == "Carrier") {
                        $ci->common->updatetbledata("tb_pod_uploads", ['carrier_pod_trigger' => 1], ['id' => $orders['podrowid']]);
                    }
                }
                $ci->edi_logger->setStatus(1);
                $ci->edi_logger->setEdi_response(json_encode($webResponse));
                $ci->edi_logger->setObj_type_name('Document Outbound');
                $ci->edi_logger->saveToEdiLogs();
                if ($webResponse['success'] == false) {
                    $this->sendDocumentFailedEmailNotification($orders['order_id'], $webResponse);
                }
            }
        }
    }

    private function sendDocumentXML(string $requestXML, array $sendingInfo, string $order_id): array
    {
        if ($sendingInfo['ediservice'] == "Web Services") {
            try {
                log_message("error", "Customer  request" . json_encode($requestXML));
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $sendingInfo['edi_url']);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_PROXY, KN_NEW_PROXY_URL);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                $headers = ["Content-Type: application/xml"];
                if ($sendingInfo['user_name'] != "" && $sendingInfo['password'] != "") {
                    $username = $sendingInfo['user_name'];
                    $password = $sendingInfo['password'];
                    $headers = [
                        'Content-Type: application/xml',
                        'Authorization: Basic ' . base64_encode("$username:$password")
                    ];
                }
                if ($sendingInfo['authentication'] != null) {
                    $authInfo = explode(":", $sendingInfo['authentication']);
                    if ($authInfo[0] == "Sign") {
                        $headers = [
                            'Content-Type: application/xml',
                            'Cache-Control: no-cache',
                            'Accept-Encoding: gzip, deflate, br',
                            'Connection: keep-alive',
                            ''.$authInfo[0].':  '.$authInfo[1]
                        ];
                    }
                }
                curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $requestXML);
                $response = curl_exec($curl);
                if ($response === false) {
                    log_message('error', 'Customer  request failed: ' . curl_error($curl));
                }
                log_message("error", "Customer  Response" . json_encode(json_decode($response, true)));
                curl_close($curl);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Customer  " . $ex->getMessage());
            }
            if (json_encode(json_decode($response)) !== "null") {
                $response = json_decode($response, true);
            } else {
                $response = json_decode(
                    json_encode(simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA)),
                    true,
                    512,
                    JSON_THROW_ON_ERROR
                );
            }
        }
        return $response ?? [];
    }

    private function sendOrderStatusXML(array $orderStatusList, array $orderWebInfo, string $partyType): string
    {
        $ci = &get_instance();


        foreach ($orderStatusList['status'] as $status) {
            $timeZone = $ci->Standardstatusmodel->getUserTimeZone($status['user_id']);
            $statusDates = getdatetimebytimezone($timeZone, $status['createdon'], DFLT_TZ);
            $statusDateTime = $statusDates['datetime'];
            $stop_type = $status['stop_type'] == "" ? "P" : $status['stop_type'];

            $ci->edi_logger->setEdi_type(2);
            $ci->edi_logger->setTxn_obj_id($status['id']);
            $ci->edi_logger->setUser_id($status['user_id']);
            $ci->edi_logger->setCompany_code($status['company_code']);
            $ci->edi_logger->setBranch_code($status['branch_code']);
            $ci->edi_logger->setTransaction_id(time());
            $ci->edi_logger->setEdi_id("39");
            $ci->edi_logger->setEdi_name('Status Outbound');
            $ci->edi_logger->setBounded_type(2);
            $ci->edi_logger->setEdi_format_type('XML');

            $tansctionno = date("Ymdhis") . "_KN" . $status['order_id'];
            $requestXML = "<?xml version='1.0' encoding='UTF-8'?>
            <SVKEDIMessage>
              <SVKEDITransmissionHeader>
                <EDIVersion>6.3.1</EDIVersion>
                <SenderTransmissionNo>" . $tansctionno . "</SenderTransmissionNo>
                <AckSpec>
                  <AckOption>ERROR</AckOption>
                </AckSpec>
                <SourceApp>ETRA</SourceApp>
                <DestinationApp>" . $orderWebInfo['customer_name'] . "</DestinationApp>
                <Action>Document</Action>
              </SVKEDITransmissionHeader>
              <SVKEDITransmissionBody>";
            if (isset($orderStatusList['trip_info'])) {
                $requestXML .= "<TripOrderDetails>
                <VehicleDetails>
                <VehicleTypeCode>" . $orderStatusList['trip_info']['trucktype'] . "</VehicleTypeCode>
                <VehicleModelCode>" . $orderStatusList['trip_info']['truck_brand'] . "</VehicleModelCode>
                <RegistrationNumber>" . $orderStatusList['trip_info']['register_number'] . "</RegistrationNumber>
                </VehicleDetails>
                <DriverDetails>
                <DriverName>" . $orderStatusList['trip_info']['drivername'] . "</DriverName>
                <DriverLicence>" . $orderStatusList['trip_info']['driving_licence_num'] . "</DriverLicence>
                <DriverNationalIdentificationNumber>" . $orderStatusList['trip_info']['driver_national_identification_number'] . "</DriverNationalIdentificationNumber>
                <ContactNo>" . $orderStatusList['trip_info']['drivernumber'] . "</ContactNo>
                </DriverDetails>
                </TripOrderDetails>";
            } else {
                $requestXML .= "<TripOrderDetails>
                <VehicleDetails>
                <VehicleTypeCode></VehicleTypeCode>
                <VehicleModelCode></VehicleModelCode>
                <RegistrationNumber></RegistrationNumber>
                </VehicleDetails>
                <DriverDetails>
                <DriverName></DriverName>
                <DriverLicence></DriverLicence>
                <DriverNationalIdentificationNumber></DriverNationalIdentificationNumber>
                <ContactNo></ContactNo>
                </DriverDetails>
                </TripOrderDetails>";
            }
            $requestXML .= "<Order>
                            <OrderID>" . $status['order_id'] . "</OrderID>
                            <Status>
                            <StatusCode>" . $status['status_code'] . "</StatusCode>
                            <StatusValue>" . $status['status_name'] . "</StatusValue>
                            <StatusType>" . $stop_type . "</StatusType>
                            <DateTime>" . str_replace(" ", "T", $statusDateTime) . "</DateTime>
                            <TimeZone>" . $timeZone . "</TimeZone>
                            <Lat>" . $status['latitude'] . "</Lat>
                            <Lng>" . $status['longitude'] . "</Lng>
                            <Location>" . $status['loc_name'] . "</Location>
                            <NextStopETA>" . str_replace(" ", "T", $status['next_stop_eta']) . "</NextStopETA>
                            <NextStopDuration>" . $status['next_stop_duration'] . "</NextStopDuration>
                            </Status>
                            <Pod>
                            <PodUrl/>
                            </Pod>
                            <AdditionalInfo>";

            if (isset($orderStatusList['remarks'])) {
                foreach ($orderStatusList['remarks'] as $remark) {
                    $requestXML .= " <Reason>
                        <ReasonCode></ReasonCode>
                        <ReasonDescription></ReasonDescription>
                        <RemarkCode>" . $remark['order_id'] . "</RemarkCode>
                        <RemarkDescription>" . $remark['order_id'] . "</RemarkDescription>
                        </Reason>";
                }
            } else {
                $requestXML .= " <Reason>
                        <ReasonCode></ReasonCode>
                        <ReasonDescription></ReasonDescription>
                        <RemarkCode></RemarkCode>
                        <RemarkDescription></RemarkDescription>
                        </Reason>";
            }
            $requestXML .= "</AdditionalInfo></Order></SVKEDITransmissionBody></SVKEDIMessage>";

            $requestXML = str_replace(";", "", $requestXML);
            $requestXML = str_replace("&", "&amp;", $requestXML);
            $ci->edi_logger->setEdi_request($requestXML);

            $filename = "StatusOutbound_" . $tansctionno . ".xml";
            $localfile = "./xml/statusoutbound/" . $filename;
            log_message("error", "Document XML for " . $status['order_id'] . ": URL " . $localfile);
            if (!file_exists(dirname($localfile))) {
                if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                    throw new \RuntimeException(sprintf('Directory " % s" was not created', $concurrentDirectory));
                }
            }
            file_put_contents($localfile, $requestXML);
            $ci->load->library('EportalBUFA');
            $ci->eportalbufa->orderId = isset($status['order_id']) ? $status['order_id'] : 0;
            $ci->eportalbufa->sendStatusNotificationToEportal($requestXML);
            $webResponse[] = $this->sendDocumentXML($requestXML, $orderWebInfo, $status['order_id']);
            if (!empty($webResponse)) {
                if (isset($status['statusrowid'])) {
                    if ($partyType == "Customer") {
                        $ci->common->updatetbledata("tb_stop_status", ['customer_status_trigger' => 1], ['id' => $status['statusrowid']]);
                        $ci->common->updatetbledata("tb_order_status", ['customer_status_trigger' => 1], ['id' => $status['statusrowid']]);
                    }
                    if ($partyType == "Carrier") {
                        $ci->common->updatetbledata("tb_stop_status", ['carrier_status_trigger' => 1], ['id' => $status['statusrowid']]);
                        $ci->common->updatetbledata("tb_order_status", ['carrier_status_trigger' => 1], ['id' => $status['statusrowid']]);
                    }
                }
            }
            $ci->edi_logger->setStatus(1);
            $ci->edi_logger->setEdi_response(json_encode($webResponse));
            $ci->edi_logger->setObj_type_name('Status Outbound');
            $ci->edi_logger->saveToEdiLogs();
        }
        return "Success";
    }

    public function sendDocumentFailedEmailNotification(int $order_id, array $response): void
    {
        $ci = &get_instance();
        log_message("error", "sendDocumentFailedEmailNotification for Document data: " . $order_id);
        $ci->load->library('PhpMailerLibrary');
        $subject = "Error/Alert -Document Outbound Failed for The Booking ID:  " . $order_id;
        $message = "Hi Team,<br>";
        $message .= "Document Outbound Failed for  Booking ID: " . $order_id . "<br>";
        $message .= "The Error Message is:  " . $response['message'] . "<br><br>";
        $message .= "This is an automatically generated EMail, please do not reply <br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
        try {
            if ($ci->phpmailerlibrary->sendmail(YTDREPORT_MAILS, $subject, $message, json_decode(YTDREPORT_CC_MAILS))) {
                log_message("error", "email sent for " . $subject);
            } else {
                log_message("error", "email failed for " . $subject);
            }
        } catch (Exception $e) {
            log_message("error", "sendTripFailedEmailNotification email failed - " . $e->getMessage());
        }
    }
}
