<?php

class Standardstatushandler
{
    private $ci;

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->library(['statusintigration', 'macdamstatusintigration', 'knlogin', 'roadlogsalogdocument']);
        $ci->load->model(['Singlestatusmodel', 'Roadlogtosalogmodel', 'standardstatusmodel', 'common']);
        $ci->load->helper("cleanstr_helper");
    }

    public function insertOrderStatus(array $postXMLData): array
    {
        try {
            $orderStatusinfo = $this->readOrderStatusXML($postXMLData);
            if (array_key_exists("status", $orderStatusinfo) && $orderStatusinfo['status'] == "Failed") {
                return $orderStatusinfo;
            }
            return $this->orderStatusUpdate($orderStatusinfo);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While inserting the Order Status " . $ex->getMessage());
        }
        return ['status' => "Failed", "status_code" => "500", 'message' => "Some Internal Server Error server"];
    }

    private function readOrderStatusXML(array $postXMLData): array
    {
        $orderHeader = $postXMLData['SVKEDITransmissionHeader'];
        $orderInfo = $postXMLData['SVKEDITransmissionBody'];
        $additionalInfo = [];
        $orderID = !empty($orderInfo['Order']['OrderID']) ? $orderInfo['Order']['OrderID'] : "";

        if ($orderID === "") {
            log_message("error", "There is no Booking ID for: " . json_encode($postXMLData));
            return ['status' => "Failed", "status_code" => "404", 'message' => "Booking ID Empty"];
        }
        $StatusCode = !empty($orderInfo['Order']['Status']['StatusCode']) ? $orderInfo['Order']['Status']['StatusCode'] : "";

        if ($StatusCode === "") {
            log_message("error", "Empty Status Code Received " . json_encode($postXMLData));
            return ['status' => "Failed", "status_code" => "404", 'message' => " Status Code Empty"];
        }
        $DateTime = !empty($orderInfo['Order']['Status']['DateTime']) ? $orderInfo['Order']['Status']['DateTime'] : date('Y-m-d H:i:s');

        $headerdata = [
            "EDIVersion" => $orderHeader['EDIVersion'] ?? "",
            "SenderTransmissionNo" => $orderHeader['SenderTransmissionNo'] ?? "",
            "AckOption" => $orderHeader['AckSpec']['AckOption'] ?? "",
            "EmailAddress" => $orderHeader['AckSpec']['EmailAddress'] ?? "",
            "SourceApp" => $orderHeader['SourceApp'] ?? "",
            "DestinationApp" => $orderHeader['DestinationApp'] ?? "",
            "Action" => $orderHeader['Action'] ?? ""
        ];
        $vehicleDetails = [
            "VehicleTypeCode" => $orderInfo['TripOrderDetails']['VehicleDetails']['VehicleTypeCode'] ?? "",
            "VehicleModelCode" => $orderInfo['TripOrderDetails']['VehicleDetails']['VehicleModelCode'] ?? "",
            "RegistrationNumber" => $orderInfo['TripOrderDetails']['VehicleDetails']['RegistrationNumber'] ?? "",
        ];

        $driverDetails = [
            "DriverName" => $orderInfo['TripOrderDetails']['DriverDetails']['DriverName'] ?? "",
            "DriverLicence" => $orderInfo['TripOrderDetails']['DriverDetails']['DriverLicence'] ?? "",
            "DriverNationalIdentificationNumber" => $orderInfo['TripOrderDetails']['DriverDetails']['DriverNationalIdentificationNumber'] ?? "",
            "ContactNo" => $orderInfo['TripOrderDetails']['DriverDetails']['ContactNo'] ?? "",
        ];
        if (isset($orderInfo['Order']['AdditionalInfo']['Reason'])) {
            $additionalInfo [] = [
                "ReasonCode" => $orderInfo['Order']['AdditionalInfo']['Reason']['ReasonCode'] ?? "",
                "ReasonDescription" => $orderInfo['Order']['AdditionalInfo']['Reason']['ReasonDescription'] ?? "",
                "RemarkCode" => $orderInfo['Order']['AdditionalInfo']['Reason']['RemarkCode'] ?? "",
                "RemarkDescription" => $orderInfo['Order']['AdditionalInfo']['Reason']['RemarkDescription'] ?? ""
            ];
        }
        $statusDetails [] = [
            "OrderID" => $orderInfo['Order']['OrderID'] ?? "",
            "Status" => [
                "StatusCode" => $orderInfo['Order']['Status']['StatusCode'] ?? "",
                "StatusValue" => $orderInfo['Order']['Status']['StatusValue'] ?? "",
                "StatusType" => $orderInfo['Order']['Status']['StatusType'] ?? "",
                "DateTime" => $orderInfo['Order']['Status']['DateTime'] ?? "",
                "TimeZone" => $orderInfo['Order']['Status']['TimeZone'] ?? "",
                "Latitude" => $orderInfo['Order']['Status']['Lat'] ?? "",
                "Longitude" => $orderInfo['Order']['Status']['Lng'] ?? "",
                "Location" => $orderInfo['Order']['Status']['Location'] ?? "",
                "NextStopETA" => $orderInfo['Order']['Status']['NextStopETA'] ?? "",
                "NextStopDuration" => $orderInfo['Order']['Status']['NextStopDuration'] ?? "",
            ],
            "vehicleDetails" => $vehicleDetails,
            "driverDetails" => $driverDetails,
            "additionalInfo" => $additionalInfo ?? []
        ];
        return $statusDetails ?? [];
    }

    private function getOrderStatusDetails(array $orderInfo): array
    {
        if (array_key_exists("0", $orderInfo['Order']) == 1) {
            foreach ($orderInfo['Order'] as $orders) {
                if (array_key_exists("0", $orders['AdditionalInfo']['Reason']) == 1) {
                    foreach ($orders['AdditionalInfo']['Reason'] as $reasons) {
                        $additionalInfo [] = [
                            "ReasonCode" => $reasons['ReasonCode'],
                            "ReasonDescription" => $reasons['ReasonDescription'],
                            "RemarkCode" => $reasons['RemarkCode'],
                            "RemarkDescription" => $reasons['RemarkDescription']
                        ];
                    }
                } else {
                    $additionalInfo [] = [
                        "ReasonCode" => $orders['AdditionalInfo']['Reason']['ReasonCode'],
                        "ReasonDescription" => $orders['AdditionalInfo']['Reason']['ReasonDescription'],
                        "RemarkCode" => $orders['AdditionalInfo']['Reason']['RemarkCode'],
                        "RemarkDescription" => $orders['AdditionalInfo']['Reason']['RemarkDescription']
                    ];
                }
                $statusDetails[] = [
                    "OrderID" => $orders['OrderID'],
                    "Status" => [
                        "StatusCode" => $orders['Status']['StatusCode'],
                        "StatusValue" => $orders['Status']['StatusValue'],
                        "StatusType" => $orders['Status']['StatusType'],
                        "DateTime" => $orders['Status']['DateTime'],
                        "TimeZone" => $orders['Status']['TimeZone'],
                        "Latitude" => $orders['Status']['Lat'],
                        "Longitude" => $orders['Status']['Lng'],
                        "NextStopETA" => $orders['Status']['NextStopETA'],
                        "NextStopDuration" => $orders['Status']['NextStopDuration'],
                    ],
                    "additionalInfo" => $additionalInfo
                ];
            }
        } else {
            if (array_key_exists("0", $orderInfo['Order']['AdditionalInfo']['Reason']) == 1) {
                foreach ($orderInfo['Order']['AdditionalInfo']['Reason'] as $reasons) {
                    $additionalInfo [] = [
                        "ReasonCode" => $reasons['ReasonCode'],
                        "ReasonDescription" => $reasons['ReasonDescription'],
                        "RemarkCode" => $reasons['RemarkCode'],
                        "RemarkDescription" => $reasons['RemarkDescription']
                    ];
                }
            } else {
                $additionalInfo [] = [
                    "ReasonCode" => $orderInfo['Order']['AdditionalInfo']['Reason']['ReasonCode'],
                    "ReasonDescription" => $orderInfo['Order']['AdditionalInfo']['Reason']['ReasonDescription'],
                    "RemarkCode" => $orderInfo['Order']['AdditionalInfo']['Reason']['RemarkCode'],
                    "RemarkDescription" => $orderInfo['Order']['AdditionalInfo']['Reason']['RemarkDescription']
                ];
            }
            $statusDetails[] = [
                "OrderID" => $orderInfo['Order']['OrderID'],
                "Status" => [
                    "StatusCode" => $orderInfo['Order']['Status']['StatusCode'],
                    "StatusValue" => $orderInfo['Order']['Status']['StatusValue'],
                    "StatusType" => $orderInfo['Order']['Status']['StatusType'],
                    "DateTime" => $orderInfo['Order']['Status']['DateTime'],
                    "TimeZone" => $orderInfo['Order']['Status']['TimeZone'],
                    "Latitude" => $orderInfo['Order']['Status']['Lat'],
                    "Longitude" => $orderInfo['Order']['Status']['Lng'],
                    "Location" => $orderInfo['Order']['Status']['Location'],
                    "NextStopETA" => $orderInfo['Order']['Status']['NextStopETA'],
                    "NextStopDuration" => $orderInfo['Order']['Status']['NextStopDuration'],
                ],
                "additionalInfo" => $additionalInfo
            ];
        }
        return $statusDetails ?? [];
    }

    private function orderStatusUpdate(array $orderStatusinfo): array
    {
        $ci = &get_instance();
        foreach ($orderStatusinfo as $statusinfo) {
            $bookingId = $statusinfo['OrderID'];
            $tripInformation = $ci->standardstatusmodel->getTripInformation($bookingId);
            if (empty($tripInformation)) {
                log_message("error", "There is no Data Found with this Booking " . $bookingId);
                return ['status' => "Failed", "status_code" => "401", 'message' => "Invalid Booking ID " . $bookingId];
            }
            $orderid = $tripInformation['orderid'];
            $ci->edi_logger->setTxn_obj_id($orderid);
            $shift_id = $tripInformation['shift_id'];
            $trip_id = $tripInformation['trip_id'];
            $carrier_id = $tripInformation['carrier_id'];
            $driver_id = $tripInformation['driver_id'];
            $vehicle_id = $tripInformation['vehicle_id'];
            $company_code = $tripInformation['company_code'];
            $branch_code = $tripInformation['branch_code'];
            $user_id = $tripInformation['user_id'];
            $ci->edi_logger->setUser_id($user_id);
            $ci->edi_logger->setCompany_code($company_code);
            $ci->edi_logger->setBranch_code($branch_code);
            if (!empty($statusinfo['vehicleDetails']) || !empty($statusinfo['vehicleDetails'])) {
                $checkVehicle = $ci->standardstatusmodel->checkTripVehicle($statusinfo['vehicleDetails'], $company_code, $branch_code, $user_id, $carrier_id);
                $newVehicleId = ($checkVehicle != 0) ? $checkVehicle : $vehicle_id;
                $checkDriver = $ci->standardstatusmodel->checkTripVehicleDriver($statusinfo['driverDetails'], $user_id, $carrier_id);
                $newDriverId = ($checkDriver != 0) ? $checkDriver : $driver_id;
                $newVehicleAndDriverFlag = 0;
                if ($newVehicleId != $vehicle_id || $newDriverId != $driver_id) {
                    $newVehicleAndDriverFlag = 1;
                    log_message("error", "New Vehicle and Driver is assigned to the trip: " . $trip_id);
                    $data["driver_id"] = $newDriverId;
                    $data["vehicle_id"] = $newVehicleId;
                    $data["user_id"] = $user_id;
                    $data['mobile_no'] = (empty($statusinfo['driverDetails']['ContactNo'])) ? "" : $statusinfo['driverDetails']['ContactNo'];
                    $data["created_on"] = $data["from_time"] = $data["to_time"] = date('Y-m-d H:i:s');
                    $checkAssignedDriverExists = $ci->common->gettblrowdata(['vehicle_id' => $newVehicleId, 'driver_id' => $newDriverId,  'status' => 1], "id", "tbl_assigned_drivers", 0, 0);
                    if (empty($checkAssignedDriverExists)) {
                        $ci->common->updatetbledata("tbl_assigned_drivers", ['status' => 0], ['vehicle_id' => $newVehicleId]);
                        $ci->common->insertTableData("tbl_assigned_drivers", $data);
                    }
                    $register_number = (empty($statusinfo['vehicleDetails']['RegistrationNumber'])) ? "" : $statusinfo['vehicleDetails']['RegistrationNumber'];
                    $ci->common->insertTableData("tb_vehicles_drivers", ["vehicle_id" => $newVehicleId, "driver_id" => $newDriverId, "imei" => "", "status" => "1", "createdon" => date('Y-m-d H:i:s')]);
                    $ci->common->insertTableData("tb_vendor_vehicles", ["vehicle_id" => $newVehicleId, "vendor_id" => $carrier_id, "status" => "1", "createdon" => date('Y-m-d H:i:s')]);
                    $ci->common->updatetbledata("tb_trips", ["vehicle_id" => $newVehicleId, "driver_id" => $newDriverId], ["id" => $trip_id]);
                    $ci->common->updatetbledata("tb_shft_veh", ["vehicle_id" => $newVehicleId, "register_number" => $register_number], ["shft_id" => $shift_id]);
                    $ci->common->insertTableData("tb_shft_veh_history", [
                        "user_id" => $user_id,
                        "shft_id" => $shift_id,
                        "carrier_id" => $carrier_id,
                        "vehicle_id" => $newVehicleId,
                        "driver_id" => $newDriverId,
                        "register_number" => $register_number,
                        "status" => "1",
                        'created_on' => date('Y-m-d H:i:s'),
                        'updated_on' => date('Y-m-d H:i:s')
                    ]);
                }
            }
            $ordersStatusData[] = [
                "OrderID" => $bookingId,
                "externalreferenceid" => "",
                "statustype" => (empty($statusinfo['Status']['StatusType']) ? "" : $statusinfo['Status']['StatusType']),
                "statuscode" => (empty($statusinfo['Status']['StatusCode']) ? "" : $statusinfo['Status']['StatusCode']),
                "statusvalue" => (empty($statusinfo['Status']['StatusValue']) ? "" : $statusinfo['Status']['StatusValue']),
                "datetime" => (empty($statusinfo['Status']['DateTime']) ? "" : $statusinfo['Status']['DateTime']),
                "timezone" => (empty($statusinfo['Status']['TimeZone']) ? "" : $statusinfo['Status']['TimeZone']),
                "utc" => (empty($statusinfo['Status']['DateTime']) ? "" : $statusinfo['Status']['DateTime']),
                "lat" => (empty($statusinfo['Status']['Latitude']) ? "" : $statusinfo['Status']['Latitude']),
                "lng" => (empty($statusinfo['Status']['Longitude']) ? "" : $statusinfo['Status']['Longitude']),
                "location" => (empty($statusinfo['Status']['Location']) ? "" : $statusinfo['Status']['Location']),
                "actionuser" => "",
                "PODURL" => "",
                "referenceCode" => "",
                "referenceValue" => "",
            ];
            try {
                log_message("error", "Standrad Status Inbound Data: " . json_encode($ordersStatusData));
                $statusCodes = ['1075', '0420', '0500', '0191', '1550', '0192', '2300', '3000', '0218'];
                if (in_array($statusinfo['Status']['StatusCode'], $statusCodes)) {
                    $statusresponse = $ci->Singlestatusmodel->updateStatus(json_encode($ordersStatusData));
                }
                if (!in_array($statusinfo['Status']['StatusCode'], $statusCodes)) {
                    $statusresponse = $this->insertOrderOtherStatus($statusinfo);
                }
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While inserting the Order Status " . $ex->getMessage());
            }

            if (!empty($statusinfo['additionalInfo'])) {
                $this->insertOrderAdditionalInformation($statusinfo['additionalInfo'], $tripInformation, $statusinfo);
            }
            $lastStatus = $ci->standardstatusmodel->getOrderLastinsertedStatus($shift_id, $orderid);
            if ($lastStatus != 0) {
                $statusinfo['Status']['DateTime'] = !empty($statusinfo['Status']['DateTime']) ? $statusinfo['Status']['DateTime'] : date('Y-m-d H:i:s');
                $nextStopETA = !empty($statusinfo['Status']['NextStopETA']) ? $statusinfo['Status']['NextStopETA'] : $statusinfo['Status']['DateTime'];
                $nextStopDuration = !empty($statusinfo['Status']['NextStopDuration']) ? $statusinfo['Status']['NextStopDuration'] : $statusinfo['Status']['DateTime'];
                $ci->common->updatetbledata("tb_stop_status", ["next_stop_eta" => $nextStopETA, "next_stop_duration" => $nextStopDuration], ["id" => $lastStatus]);
            }
            if ($newVehicleAndDriverFlag == 1 && in_array($company_code, ['CNKN', 'TWKN'])) {
                $this->sendNotificationForNewDriverAndVehicle($statusinfo, $orderid);
            }
        }
        return ['status' => "Success", "status_code" => "200", 'message' => "Status Uploaded Successfully"];
    }

    private function insertOrderAdditionalInformation(array $additionalInfo, array $tripInformation, array $statusinfo): void
    {
        $ci = &get_instance();
        foreach ($additionalInfo as $additionalData) {
            $reasonCode = (empty($additionalInfo['ReasonCode'])) ? "" : $additionalInfo['ReasonCode'];
            $reasonDescription = (empty($additionalInfo['ReasonDescription'])) ? "" : $additionalInfo['ReasonDescription'];
            $remarkCode = (empty($additionalInfo['RemarkCode'])) ? "" : $additionalInfo['RemarkCode'];
            $remarkDescription = (empty($additionalInfo['RemarkDescription'])) ? "" : $additionalInfo['RemarkDescription'];
            if ($reasonCode != "") {
                $reasonCodes = [
                    'shipment_id' => $tripInformation['shift_id'],
                    'stop_id' => 0,
                    'order_id' => $tripInformation['orderid'],
                    'stop_detail_id' => 0,
                    'stop_type' => "P",
                    'trip_id' => $tripInformation["trip_id"],
                    'status_id' => $reasonCode,
                    'latitude' => (empty($statusinfo['Status']['Latitude']) ? "" : $statusinfo['Status']['Latitude']),
                    'longitude' => (empty($statusinfo['Status']['Longitude']) ? "" : $statusinfo['Status']['Longitude']),
                    'status' => $reasonDescription,
                    'status_code' => $reasonCode,
                    "reason" => "From EDI",
                    "comment" => $reasonDescription,
                    'vehicle_id' => $tripInformation["vehicle_id"],
                    'driver_id' => $tripInformation["vehicle_id"],
                    'createdon' => (empty($statusinfo['Status']['DateTime']) ? "" : $statusinfo['Status']['DateTime'])
                ];
                $ci->common->insertTableData('tb_stop_status', $reasonCodes);
            }
            if ($remarkCode != "") {
                $ci->standardstatusmodel->insertOrdeeRemarks($remarkCode, $remarkDescription, $tripInformation);
            }
        }
    }

    public function insertOrderOtherStatus(array $statusinfo): string
    {
        $ci = &get_instance();
        $tripInformation = $ci->standardstatusmodel->getTripInformation($statusinfo['OrderID']);
        $statusId = $ci->standardstatusmodel->getStatusCodeId($statusinfo['Status']['StatusCode'], $statusinfo['Status']['StatusValue']);
        $userTimeZone = $ci->Singlestatusmodel->getUsersTimezone($tripInformation['user_id']);
        $nextStopETA = !empty($statusinfo['Status']['NextStopETA']) ? $statusinfo['Status']['NextStopETA'] : $statusinfo['Status']['DateTime'];
        $datetime = (getdatetimebytimezone(DFLT_TZ, $statusinfo['Status']['DateTime'], $userTimeZone))['datetime'];
        $nextStopETA = (getdatetimebytimezone(DFLT_TZ, $nextStopETA, $userTimeZone))['datetime'];

        $NextStopDuration = !empty($statusinfo['Status']['NextStopDuration']) ? $statusinfo['Status']['NextStopDuration'] : $statusinfo['Status']['DateTime'];

        $stopStatusData = [
            "order_id" => $tripInformation['orderid'],
            "shipment_id" => $tripInformation['shift_id'],
            "stop_id" => "0",
            "stop_detail_id" => "0",
            "stop_type" => "",
            "trip_id" => $tripInformation['trip_id'],
            "status_id" => $statusId,
            "latitude" => (empty($statusinfo['Status']['Latitude']) ? "" : $statusinfo['Status']['Latitude']),
            "longitude" => (empty($statusinfo['Status']['Longitude']) ? "" : $statusinfo['Status']['Longitude']),
            "loc_name" => (empty($statusinfo['Status']['Location']) ? "" : $statusinfo['Status']['Location']),
            "status" => 1,
            "carrier_status_trigger" => 1,
            "reason" => 'From EDI',
            "vehicle_id" => $tripInformation['vehicle_id'],
            "driver_id" => $tripInformation['driver_id'],
            "status_code" => (empty($statusinfo['Status']['StatusCode']) ? "" : $statusinfo['Status']['StatusCode']),
            "createdon" => $datetime,
            "next_stop_eta" => $nextStopETA ?? "",
            "next_stop_duration" => $NextStopDuration
        ];
        $checkStatusData = [
            "order_id" => $tripInformation['orderid'],
            "shipment_id" => $tripInformation['shift_id'],
            "status_code" => (empty($statusinfo['Status']['StatusCode']) ? "" : $statusinfo['Status']['StatusCode'])
        ];
        $checkStatus = $ci->common->gettbldata($checkStatusData, "id", "tb_stop_status", 0, 0);
        foreach ($checkStatus as $status) {
            $ci->common->updatetbledata("tb_stop_status", ['status' => 0], ["id" => $status['id']]);
        }

        $getStatus = $ci->common->gettblrowdata($stopStatusData, "id", "tb_stop_status", 0, 0);
        if (empty($getStatus)) {
            $ci->common->insertTableData('tb_stop_status', $stopStatusData);
        } else {
            $ci->common->updatetbledata("tb_stop_status", $stopStatusData, ["id" => $getStatus['id']]);
        }
        return "Success";
    }

    private function sendNotificationForNewDriverAndVehicle(array $data, int $orderRowId): void
    {
        $ci = &get_instance();
        $vehicleDetails = $data['vehicleDetails'];
        $driverDetails = $data['driverDetails'];
        $vehicleTypeCode = (!empty($vehicleDetails['VehicleTypeCode'])) ? $vehicleDetails['VehicleTypeCode'] : '';
        $registrationNumber = (!empty($vehicleDetails['RegistrationNumber'])) ? $vehicleDetails['RegistrationNumber'] : '';
        $driverName = (!empty($driverDetails['DriverName'])) ? $driverDetails['DriverName'] : '';
        $driverLicence = (!empty($driverDetails['DriverLicence'])) ? $driverDetails['DriverLicence'] : '';
        $driverNationalIdentificationNumber = (!empty($driverDetails['DriverNationalIdentificationNumber'])) ? $driverDetails['DriverNationalIdentificationNumber'] : '';
        $driverContactNo = (!empty($driverDetails['ContactNo'])) ? $driverDetails['ContactNo'] : '';
        $getCustomerIdAndCode = $ci->standardstatusmodel->getCustomerIdAndCode($data['OrderID']);
        $customerGroupEmailIds = $bccMailIds = [];
        $getCarrierEmailId = $ci->Roadlogtosalogmodel->getCarrierEmailId($data['OrderID']);
        if (($getCarrierEmailId['email'] ?? '') != '') {
            $bccMailIds[] = $getCarrierEmailId['email'];
        }
        $customerCode = '';
        if ($registrationNumber == '' && $driverName == '') {
            return;
        }
        if (!empty($getCustomerIdAndCode)) {
            $customerId = $getCustomerIdAndCode['id'];
            $customerCode = $getCustomerIdAndCode['code'];
            $customerGroupEmailIds = $ci->Roadlogtosalogmodel->getCustomerGroupEmailIds($customerId);
        }
        $getReferences = $ci->common->gettbldata_where_in(['order_id' => $orderRowId, 'status' => 1], ['col' => 'reference_id', 'arr' => ['SAC', 'XSR', 'SDT']], 'reference_id,ref_value', 'tb_order_references', 0, 0);
        if (empty($getReferences)) {
            return;
        }
        $toEmailId = $trackingNumber = $importType = '';
        foreach ($getReferences as $eachReferences) {
            if ($eachReferences['reference_id'] == 'SAC') {
                $toEmailId = $eachReferences['ref_value'];
            } elseif ($eachReferences['reference_id'] == 'XSR') {
                $trackingNumber = $eachReferences['ref_value'];
            } elseif ($eachReferences['reference_id'] == 'SDT') {
                $importType = $eachReferences['ref_value'];
            }
        }
        if ($toEmailId == '') {
            return;
        }
        $ccMailIds = [];
        switch ($customerCode) {
            case "1000211110":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'SZX-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'scnair-import.occ@kuehne-nagel.com';
                }
                break;
            case "1000211118":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'XMN-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                }
                break;
            case "1000353916":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'HDU-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                }
                break;
            case "1000397871":
                $ccMailIds[] = 'knzsn.air.ccl@kuehne-nagel.com';
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'SZX-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                }
                break;
            case "1000466462":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                    $ccMailIds[] = 'knhkg.zao.import@kuehne-nagel.com';
                }
                break;
            case "1004573268":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                }
                break;
            case "1000659010":
                $ccMailIds[] = 'kncgo.air.pricing@kuehne-nagel.com';
                break;
            case "1000211120":
                $ccMailIds[] = 'knsia.air.ccl@kuehne-nagel.com';
                break;
            case "1000210679":
                $ccMailIds[] = 'knckg.air.ccl@kuehne-nagel.com';
                break;
            case "1000084925":
                $ccMailIds[] = 'knwuh.air.ccl@kuehne-nagel.com';
                break;
            case "1000599141":
                $ccMailIds[] = 'jerry.w.ding@kuehne-nagel.com';
                break;
            case "1000210660":
                $ccMailIds[] = 'knctu.air.ccl@kuehne-nagel.com';
                break;
            default:
                $ccMailIds = [];
        }
        $ccMailIds = array_merge($customerGroupEmailIds,$ccMailIds);
        $subject = "Booking ID:" . $data['OrderID'] . " SALOG Tracking No: " . ($trackingNumber ?? '');
        $message = "Hi, <br><br>";
        $message .= "Vehicle Type                           : " . $vehicleTypeCode . "<br>";
        $message .= "Registration Number                    : " . $registrationNumber . "<br>";
        $message .= "Driver Name                            : " . $driverName . "<br>";
        $message .= "Driver Licence                         : " . $driverLicence . "<br>";
        $message .= "DriverNational Identification Number   : " . $driverNationalIdentificationNumber . "<br>";
        $message .= "Driver Contact No                      : " . $driverContactNo . "<br><br>";
        $message .= "Best Regards,<br>";
        $message .= "Svkonekt Team";
        try {
            $ci->load->library('PhpMailerLibrary');
            if ($ci->phpmailerlibrary->sendmail($toEmailId, $subject, $message, $ccMailIds, [] , $bccMailIds)) {
                log_message("error", "Trip notification email success " . $subject . " -- " . $message." bcc -".json_encode($bccMailIds)." cc -".json_encode($ccMailIds)."toEmailId " . $toEmailId. " " . $customerCode);
            } else {
                log_message("error", "Trip notification email failed" . $subject . " -- " . $message." bcc -".json_encode($bccMailIds)." cc -".json_encode($ccMailIds)."toEmailId " . $toEmailId. " " . $customerCode);
            }
        } catch (Exception $e) {
            log_message("error", "Trip notification email failed - " . $e->getMessage());
        }
    }
}
